      SUBROUTINE ZZDTTM ( CHDATE )

C## A R G U M E N T S:
                       CHARACTER *(*) CHDATE

C## S T A T U S:
C               SINGLE/DOUBLE CONVERSION:        NOT REQUIRED.
C               SYSTEM  DEPENDENCE:                      NONE.
C
C>RCS $HEADER: DTTM.F,V 1.10 91/11/19 16:15:05 BUCKLEY EXP $
C>RCS $LOG:     DTTM.F,V $
C>RCS REVISION 1.10  91/11/19  16:15:05  BUCKLEY
C>RCS FINAL SUBMISSION TO TOMS
C>RCS
C>RCS REVISION 1.9  89/06/30  13:28:53  BUCKLEY
C>RCS PREPARING SUBMITTED VERSION OF MT
C>RCS
C>RCS REVISION 1.3.1.1  89/05/20  13:39:29  BUCKLEY
C>RCS TEMP. TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.3  89/05/18  14:26:41  BUCKLEY
C>RCS FINAL TEST OF MT BEFORE SUBMITTING
C>RCS
C>RCS REVISION 1.2  89/05/15  14:44:17  BUCKLEY
C>RCS INITIAL INSTALLATION OF MT INTO RCS FORM.
C>RCS
C>RCS REVISION 1.1  89/01/17  16:30:07  BUCKLEY
C>RCS INITIAL REVISION
C>RCS
C
C## D E S C R I P T I O N:
C
C     THIS ROUTINE RETURNS IN CHDATE A 41-CHARACTER DATE OF THE FORM
C     GIVEN IN MODEL(BELOW). IT USES THE TIME AND DATE AS OBTAINED
C     FROM THE OPERATING SYSTEM (VIA THE ROUTINES ZZTIME AND ZZDATE)
C     AND CONVERTS THEM TO THE FORM OF THE MODEL GIVEN BELOW.
C     IT ASSUMES THAT THE ROUTINES ZZTIME AND ZZDATE RETURN 10
C     CHARACTER STRINGS, RESPECTIVELY, OF THE FORM:
C
C        TIME:  (HH+MM+SS)
C        DATE:  (YY+MM+DD)
C
C     NOTE THAT EXCESS BLANKS IN THE DATE ARE ELIMINATED.
C     IF CHDATE IS MORE THAN 41 CHARACTERS IN LENGTH, ONLY THE
C     LEFTMOST 41 WILL BE ALTERED.  IF IT IS LESS THAN 41 IN
C     LENGTH, ONLY THE LEFTMOST CHARACTERS OF THE DATE WILL BE
C     RETURNED.
C
C## E N T R Y   P O I N T S: THE NATURAL ENTRY ZZDTTM
C## S U B R O U T I N E S:
C
C     ZZDATE   USER ROUTINE TO GET A DATE.
C     ZZTIME   USER ROUTINE TO GET THE TIME OF DAY.
C     ZZLENG   USER ROUTINE TO GET STRING LENGTH.
C     ZZSHFT   USER ROUTINE TO SHIFT A STRING.
C     MIN, INT, LEN, MOD, REAL    ...INTRINSIC
C
C## P A R A M E T E R S:

      INTEGER     PTHOUR,       PTMIN,      PTAMPM
      PARAMETER ( PTHOUR =  1,  PTMIN =  4, PTAMPM =  7 )
      INTEGER      PTMON,       PTDAY,      PTYEAR,      PTDAYN
      PARAMETER (  PTMON = 24,  PTDAY = 34, PTYEAR = 40, PTDAYN = 13 )

      CHARACTER*(*) MODEL
      PARAMETER (   MODEL ='00:00 A.M., WEDNESDAY, SEPTEMBER 00, 1999')

C## L O C A L   D E C L:
                        INTEGER   KMON, TO, K, DAYNO, MODLEN
                        INTEGER  ZZLENG

                        CHARACTER *10    TEMP
                        CHARACTER *41   TDATE
                        CHARACTER * 9  MONTHS(12), DAYS(0:6)

C## S A V E:
                        SAVE   MONTHS, DAYS

C## E Q U I V A L E N C E S: NONE ARE DEFINED.
C## C O M M O N:             NONE IS DEFINED.
C## D A T A:                 NONE ARE SET.

      DATA MONTHS( 1), MONTHS( 2)/'JANUARY  ','FEBRUARY '/
      DATA MONTHS( 3), MONTHS( 4)/'MARCH    ','APRIL    '/
      DATA MONTHS( 5), MONTHS( 6)/'MAY      ','JUNE     '/
      DATA MONTHS( 7), MONTHS( 8)/'JULY     ','AUGUST   '/
      DATA MONTHS( 9), MONTHS(10)/'SEPTEMBER','OCTOBER  '/
      DATA MONTHS(11), MONTHS(12)/'NOVEMBER ','DECEMBER '/

      DATA   DAYS(0)  / 'SUNDAY   ' /
      DATA   DAYS(1)  / 'MONDAY   ' /
      DATA   DAYS(2)  / 'TUESDAY  ' /
      DATA   DAYS(3)  / 'WEDNESDAY' /
      DATA   DAYS(4)  / 'THURSDAY ' /
      DATA   DAYS(5)  / 'FRIDAY   ' /
      DATA   DAYS(6)  / 'SATURDAY ' /
C##                                                E X E C U T I O N
C##                                                E X E C U T I O N
      TDATE  = MODEL
      MODLEN = LEN(TDATE)
      CALL ZZDATE(TEMP)

      IF ( TEMP(8:8) .EQ. '0' ) THEN
           TEMP(8:8) = ' '
      ENDIF

      TDATE ( PTDAY  :  PTDAY+1 ) = TEMP(8:9)
      TDATE ( PTYEAR : PTYEAR+1 ) = TEMP(2:3)

      READ ( TEMP(8:9), '(I2)' )  DAYNO
      READ ( TEMP(2:3), '(I2)' )   K
      K = K + 1900

      READ ( TEMP(5:6), '(I2)' )  KMON
      TDATE(PTMON:PTMON+8) = MONTHS(KMON)
      TO = ZZLENG ( MONTHS(KMON) )

      IF ( TO .NE. 9 ) THEN
         CALL ZZSHFT ( TDATE, PTMON+9, PTMON+TO, MODLEN )
      ENDIF

      IF ( KMON .EQ. 1 .OR. KMON .EQ. 2 ) THEN
         KMON = KMON + 13
         K    = K    - 1
      ELSE
         KMON = KMON + 1
      ENDIF

      DAYNO = DAYNO + INT ( REAL(KMON) * 30.6001 )
      DAYNO = DAYNO + INT ( REAL(  K ) * 365.25  )
      DAYNO = MOD ( DAYNO+5, 7 )

      CALL ZZTIME(TEMP)
      TDATE(PTMIN:PTMIN+1) = TEMP(5:6)
      READ ( TEMP(2:3), '(I2)' ) K

      IF      ( K .GE. 13 ) THEN
         K = K-12
         TDATE(PTAMPM:PTAMPM) = 'P'
      ELSE IF ( K .EQ. 12 ) THEN
         TDATE(PTAMPM:PTAMPM) = 'P'
      ELSE IF ( K .EQ.  0 ) THEN
         K = K + 12
         TDATE(PTAMPM:PTAMPM) = 'A'
      ELSE
         TDATE(PTAMPM:PTAMPM) = 'A'
      ENDIF

      WRITE ( TDATE(PTHOUR:PTHOUR+1), '(I2)' ) K
      TDATE(PTDAYN:PTDAYN+8) = DAYS(DAYNO)
      K = ZZLENG (DAYS(DAYNO))

      IF ( K .NE. 9 ) THEN
C                          ==> SHIFT OVER BLANKS.

         CALL ZZSHFT ( TDATE, PTDAYN+9, PTDAYN+K, MODLEN )
      ENDIF
      GOTO 90000

C## E X I T

90000 MODLEN = MIN ( MODLEN, LEN(CHDATE) )
      CHDATE(1:MODLEN) = TDATE

      RETURN

C## F O R M A T S:  NONE ARE DEFINED.
C##                 E N D         OF ZZDTTM.
                    END
