c **** * * * * * * * * * * * * * * * * * * * * * * * * * * *  * * 
c 
C SUBROUTINE RANDG 
c 
C PURPOSE 
C 
C COMPUTE RANDOM NUMBERS FROM ANY GENERAL DISTRIBUTION. 
c 
C USAGE 
C 
C CALL RANDG (L,X,R,Y) 
c 
C DESCRIPTION OF PARAMETERS 
c   INPUT 
c     L -A NON ZERO ODD RANDOM INTEGER 
c     X -VECTOR OF LENGTH 257 CONTAINING ORDINATE POINTS 
c        SEPERATED BY EQUAL PROBABILITY ON DESIRED DISTRIBUTION. 
c        (CAN BE CALCULATED IN RANDGI). 
c     R -VECTOR OF LENGTH 256 CONTAINING RATIOS OF DERIVATIVE*DX 
c        TO AREA/DX FOR EACH ORDINATE POINT IN X. 
c        (CAN BE CALCULATED IN RANDGI), 
c OUTPUT 
c     Y -RANDOM NUMBER 
c 
C REMARKS 
c   QUADRATIC APPROXIMATION OF CDF (CUMULATIVE DENSITY FUNCTION) 
c   WHICH IMPLIES LINEAR APPROXIMATION OF PDF (PROBABILITY DENSITY 
c   FUNCTION). 
c 
C SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED 
c   NONE DIRECTLY. RANDGI MAY BE USED FOR INITIALIZATION. 
c 
C METHOD 
c   TABLE LOOK UP PLUS UNIFORM AND TRIANGULAR DISTRIBUTION 
c   VARIABLES ARE USED, 
c 
c * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * 

      SUBROUTINE RANDG (L,X,R, Y) 
      DIMENSION X(257) ,R(256) 
c 
C GENERATE TWO UNIFORM RANDOM NUMBERS ON INTERVAL (1 - 2**31) 
C ANY GOOD GENERATOR MAY BE SUBSTITUTED, 
c 
      L1=IABS(65539*L) 
      L=IABS(65539*L1) 
      L2=L 
c 
C CALCULATE TWO UNIFORM RANDOM NUMBERS 
C K1 INTEGER ON INTERVAL (1 - 256) 
C AK2 REAL ON INTERVAL (0 - 1.0) 
c 
      K1=L1/8388608+1 
      AK2=FLOAT(MOD(L1,8368608))*1.192093E-7 
      IF (AK2-ABS (R (K1))) 8, 8, 30 
8       IF(R(K1)) 20,10,10 
c 
C CALCULATE TRIANGULAR RANDOM SKEWED LEFT 
c 
10    Y=X(K1) + (X (K1+1)-X(K1)) *AMAXO(L1,L2) *4.656613E-10 
      RETURN 
c 
C 
CALCULATE TRIANGULAR RANDOM SKEWED RIGHT 
c 
20       Y=X(K1)+(X(K1+1)-X(K1))*AMINO(L1,L2)*4.656613E-10 
      RETURN 
c 
C CALCULATE UNIFORM RANDOM 
c 
30       Y=X(K1)+(X(K1+1)-X(K1))*FLOAT(L2)*4.656613E-10 
      RETURN 
      END 

c **** * * * * * * * * * * * * * * * * * * * * * * * * * * * *  
c 
C SUBROUTINE RANDGI 
c 
C PURPOSE 
c   COMPUTE INITIAJ;.IZING VECTORS FOR RANDG 
c 
C USAGE 
c   CALL RANDGI (N,X,Y,P,Q,$fi1eR,IER) 
c 
C DESCRIPTION OF PARAMETERS 
c   INPUT 
c     N -NUMBER OF (X,Y) POINTS OF APPROXIMATION TO PDF 
c        (PROBABILITY DENSITY FUNCTION) 
c     X -VECTOR OF LENGTH N CONTAINING ORDINATE OF PDF 
c     Y -VECTOR OF LENGTH N CONTAINING ABSCISSA OF PDF 
c   OUTPUT 
c     P -WORK VECTOR OF LENGTH N 
c     Q -VECTOR OF LENGTH 257 CONTAINING ORDINATE POINTS 
c        SEPARATED BY EQUAL PROBABILITY ON DESIRED DISTRIBUTION, 
c     R -VECTOR OF LENGTH 256 CONTAINING RATIOS OF DERIVATIVE*DX 
c        TO AREA/DX FOR EACH ORDINATE POINT IN Q. 
c     IER-ERROR INDICATOR 
c         1 -ERROR IN SCALING, I.E. TOTAL AREA OF PDF NOT EQUAL TO 
c            1. ASSUMING ESTIMATION ERRORS A FUDGE FACTOR IS USED 
c            TO SCALE A RESULT, 
c         2 -DENSITY NOT POSITIVE, I.E. SOME Y(I) LT 0, ABORT 
c         3 -NOT IN SORT. I.E. SOME X(I) LT X(I-1), ABORT 
c         4 -SEARCH ERROR. SHOULD NEVER OCCUR BECAUSE OF FUDGE 
c            FACTOR USED. THIS MEANS SOME P(I) NOT LARGE ENOUGH 
c            FOR SEARCH OF PROPER Q, INVESTIGATION IS NEEDED, 
c 
C REMARKS 
c   NONE 
c 
C SUBROUTINES AND FUNCTION SUBPROGRAMS REQUIRED 
c   NONE 
c 
C METHOD 
c   LINEAR APPROXIMATION OF PDF TO FIND CDF (CUMULATIVE DENSITY 
c   FUNCTION) AND ICDF (INVERSE CDF). QUADRATIC INTERPOLATION ON 
c   ICDF TO FIND Q AND R. 
c * * * * * * * * * * * * * * * * * * * * * * ~ * * * * * * * * * * * 
      SUBROUTINE RANDGI (N,X,Y,P,Q,R,IER) 
      DIMENSION X(300), Y(300) ,P(300) ,Q (257) ,R(256) 
c 
C CALCULATE CUMULATIVE PROBABILITIES 
c 
      IER=0 
      IF(Y(1)) 5,10,10 
c 
C ERROR 2 
c 
5     IER=2 
      RETURN
10     P(1)=0.0
      DO 15 I=2,N
      IF(Y(I)) 5,11,11
11     IF(X(I)-X(I-1)) 6,12,12
c
C ERROR 3
c
6     IER=3
      RETURN
12     P(I)=(Y(I)+Y(I-1))*(X(I)-X(I-1))*0.5+P(I-1)
15     CONTINUE
      IF(P(N)-0.996094) 7,7,16
16     IF(P(N)-1.003906) 3,7,7
c
C ERROR 1
c
7     IER=1
3       F=1.0/P (N) 
      DO 4 I=2,N 
4       P(I)=P(I)*F 
c 
C CALCULATE X POINTS FOR EQUAL-DISTANT CUMULATIVE PROBABILITIES 
c 
      V=0.0 
      Q(1) =X(1) 
      T1=Y(1) 
      J1=2 
100       DO 150 I=2,257 
      IF(I-257) 102,103,103 
102       V=V+3.90625E-3 
c 
C LOCATE BEST POINT FOR INTERPOLATION 
c 
      DO 101 J=J1, N 
      IF(P(J)-V) 101,104,105 
101       CONTINUE 
c 
C ERROR 4 
c 
      IER=4 
103   J=N 
104   Q(I) =X(J) 
      T2=Y(J) 
      GO TO 125 
105   IF(J-3) 113,108,107 
107   IF(J-N) 108,111,111 
108   IF((P(J)-V)-(V-P(J-1))) 110,110,111 
110   J1=J-1 
      GO TO 120 
111   J1=J-2 
      GO TO 120 
113   J1=1 
C
C QUADRATIC INTERPOLATION OF P INVERSE FOR Q 
c 
120   XT2=P (J1+2)-P (J1) 
      XT3=P(J1+2)-P(J1+1) 
      XT1=P(J1+1)-P(J1) 
      XV1=V-P (J1) 
       XV2=V-P (J1+1)
      XV3=V-P (J1+2) 
      Q(I) =(XV3*XV2*X(J1)) /(XT1*XT2)-(XV3*XV1*X(J1+1) )/(XT1*XT3)+ 
     1 (XV2*XV1*X(J1+2))/(XT2*XT3)
c 
C LINEAR INTERPOLATION OF Y FOR T2 AND R 
C
      T2=(Y(J)-Y(J-1))*(Q(I)-X(J-1))/(X(J)-X(J-1))+Y(J-1) 
125   R(I-1)=(T2-T1)/(T2+T1) 
      T1=T2 
      J1=J 
150   CONTINUE 
      RETURN 
      END       
