
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01024_poly_chebyshev_u : public TestCaseReal
    {
    public:
      TestCase_case_01024_poly_chebyshev_u() { }
      virtual ~TestCase_case_01024_poly_chebyshev_u() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01024_poly_chebyshev_u");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(111u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::chebyshev_u(k, ef::euler_gamma() + (k - 10));
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 111u> a =
        {{
           e_float("1."),
           e_float("-16.845568670196934278786975819835195137915681328120152802388465530230264546444670658126105873416506500970737105500385835038078991971026914327551652004710152927492999332514125324524652114414809483505810167982529592103668658293533696446776942757600996984030412509828588519940157290427706611940791349156961882448929465337201491974065158972491720901776629794384031530244825589923137812005277254893878221337"),
           e_float("219.39090914153277161845673078014722131993947106084340864903423031937752866101248773868044102385507194027574563842595631559633842278084519310277219670216673505052719358278685553802790400326944558223019840777215008942889208966044632526208687179087905126157521329386294306462192197342347972519145331702520987897679649062868547843299978462286876622583838071601874778406843168298272137039536438885756703234"),
           e_float("-2093.9386078005307479373494823357482936403979117496803371395947781990022467981350226774911431822982484716693832473352823143488110489185655509443324248372326364630655527052583410709505888241219523682794603487256032099097654505755203365033224996251910206047558598601781164462682120372426535703504696287537290069108134314407750053078585930660516347331481217919502043653052185754458582224102774752325281728"),
           e_float("13484.081435744083850668061420871533193234349537345000879578382844113872996644344178660587804314586898247946385968693195487410466839191991081055545140924021125800362257137725226657341654016348600214845597101508691810675864063643077868303453068946593074711410059452212874447201314999886024714575702954043082889867761236494233246597862843016690666853833069073772980821242634437924518510341209157978073518"),
           e_float("-51411.864936493548696727952564010505287380790662708345162170537757607185346654161611456254303620752171089616095568202820941914228745207391571883601908473972103564221377320381412832547189682987304864357726840087956379449846800615096563393765410779593316238307603024166045159649967336252946903098993881186485652893384361124605123641815473770918815236308672971026616999474439402350991762455674349895001674"),
           e_float("92209.932074592734365036067120027896359379112575065060685943259125456001693066116021711756329727563950810216602451503723253955422036115680510427418504807999826327999493053959691759318920524501559135062558278159172376559372369816736922139712621634183956703276669867891787090896418266729474386178680265402946979779571691464196579040185683027789456291001499956716967857057361609470224484258400332037869137"),
           e_float("-47811.536746163542884220841723836100304628120919010026462540259452929058892560740221912772959391085903371581449516433559727410300467157935890174063531096268805181197210159025776410697444292000512157252066913716744376024732249215953775780243003210197305027933325224953633380828220361390481797489289852056620540147129780767253660191138595800990479534489685026113077958408322313355114754311716678263145806"),
           e_float("1486.0501118283270905589384924068745210343199280617503728061504890217131656407662295070953030503328292303866567495827780794088763105159120441640101660539376256719128770832550225248789303562335230208421439278958599152855756422536350412769513907903019043914561543715395148487336910960891329130574661881631292684388387372899070177106790667536793990456385291606851180709633717495752506528269717583965317748"),
           e_float("1.037614571749973349067066940673025043880197808371485907600733112989850217346555191162284435092035178160221640426936702483390084285363153103065523928940144755895205218601994479745078191365880199326575027146675263768570980084586047388957235860997971288271101969669298325160365777179214681409227174275427538858975407495348845524961202281773490374995603036734111473218112111414099495261429016623399383729"),
           e_float("-1.0832159793372841026846588390279088546559692844556513670823526801155951656633546775896789702589420351697193005226914610305219788200747393240863000872348131453658452770670801777740248688435795814965546739289259034676037738954698323372951663192233591760193601300457992628629376768334177781663869700830870657463126353015345121915614331706400001818606235198509502644175049044915126529384140120012959394762"),
           e_float("93936.220490603346909677574958330591278853193574082891623803617458769734346485696571771581407030196819115010077578424890144144045289787755783067323422352594563007963080748375787687118815896432988688502762386722781185170100594253520269687816685660973827796749643102548325723438474546501153062227756556886582236540944300845494166759485813707432114416609366824693577341974024594724629985803533186662644206"),
           e_float("2.2697904939492602358288263504578016969376573849002250879585401082575918749965424044256689956488065936469176515660945296702862488395321714082141480798064055095509007658474879431076193170647904621166750520663132554902701190318498063945988731300721955939952886480645763156943663500642524833785791114053988884602080483431554990057180006698737295920900896578537276071208764758450528232039882777219283966309e8"),
           e_float("1.0109277948873471348737854478596887628753462089856878426407255471864049509626176090434178383840875418751161237880286238890601231708527868343744760049785418797544339190209782132002572032309909889315131726830036354947330981761465814717021018549829242364597383379704076767101311789563014143736239643010648255291001353786982854109154856254945152083391788586866419018516566496974956325943484001698268531224e11"),
           e_float("2.4791083602775830376206107079501837105241661930959881943639447678538704387547903098859630798704554645049395189844220573685998123713431454754014205517374934690271479989805814364727100820904948523582507453849243176544209335921674799087565559901044125564858058910515945282306508445836918170313515915519405816491740305133198045734556798562609909319290398753731876640259720534001143097926793163948892932506e13"),
           e_float("4.594871917105848004059665531519041069147410770136939055721009634733571884179916104257727201304889981989969847908087290010458341509846946961886963671371034761172794523103259491875609961882171575289809514660417407069405889894866830551991871821185671134489700123450435925822835398830756092301341772950679334572024993541981212021828880441304629013926518774158162378051257243015361097728625382384727782911e15"),
           e_float("7.3652993884336521012916996969015234247325345001662524769673339159043920826887208828355657374440895411768208199625517558375251208868707933710204324692062180773912649858595309531419675510993577508150716603280306153544383176241528581879657517079253073391583550500062165116534171520901326406891735849371271212033018284727403563000076463309514322454925928014422131014500377605860997428236053662559690155031e17"),
           e_float("1.0932659761294470246065679556378701489227580698296897417969516721453729382794025094622831366161396927693220533014672681814159404474048017549470418055059281837705143405755767839603668067507378759456305206757768550925566176017204505551724846125647981549423218065962064483970863545329798870767431551422856334234085583128910141249660637893511444388868518394010297906641449419781919384303922159290206615337e20"),
           e_float("1.5615692497333911345413083830262753475483772409191562369325940019142624247144316818933695725948470880129783093801943688863814216818364831571411254911242523256218418592886631204695803888189587590946052862362637152631605527611933846630551587045318283386203814475652423095062216357858030767968952382632067510972651647646079935746793308604116196872187593236816000320488114026057096204743419307809494011163e22"),
           e_float("2.1964676504282246559752555381757867957836151414539442185680443373602830332918516029158361938500255241305376252771145448167871206568205561322241198997854920629665341804218011379164902002397162731441236781019075936892041873200276979209260207884175591348805809948769147012082583743166606952781028426308289177978451705790181704123049560126450388212659667846132680749382627503579581223655498511002011467314e24"),
           e_float("3.0869405802349008036179978321254897083777957154024674608715489998349464910013404954454423930784511555420997238161862382310747289553777143756537283507176517359533151713236749436916243774072842433736018672025734566682699538232668495411014749858820061372891034054113268462177695715277676723269496395861942337376242108769020749160345226858478037047296267448558044940732120346986891733700192775093789559215e26"),
           e_float("4.3759399213632239615584879338403133021011929061481894214423942413209642571903889960156916756148865490345070034508633634223306681449931544353401902914874622008019437822675967280056124527743110214141300501395841464458252802080112431920396575322260072559686986074153688322627761065724266271721794337828836537382672474306046100646213113654044340635848515473978593546455828318999911666107847830415792723586e28"),
           e_float("6.2961085987906238945947872677518920495211375489257242114007211530273490760925472626704212534089381383446422477994787438705726100296871441889687879838715467819403589717465134963423227543092181673155456908075418007713758089352185644457504650136270546615975202988283331924429028130587259524065085621685440545050769978040601548207083448918046045350745165795775659861725872033675305959500959101038030389918e30"),
           e_float("9.2332185348423424208664545797076529126146236085959442298285673122433470242859457194475594426496736961515544007247495182831051281331106259852206262202028324500253969771527841216246949739137806697726402716867228882980592313232184589441623854728259522152469942915706600689724916019647356539022180989304587476949101508820133072947148703179833425155186750747039516355019072911469942811590223138722226888578e32"),
           e_float("1.3840055828378856729399740937872483515477579811128863045456412337240266356226625587472041931047728274293340187936279044763469120493583060990267215370332770749940374490905676549550072101404610898844749032162033690303945923983337043333282188132518291373117423656337655899645734135082920241984341022348302399737333188920351306890311041134988707714234026771354889468687216082693387715071024038346101576846e35"),
           e_float("2.1244217268301845279875690141433347691348457659675254338823309088977474812244032717318810518539604298533752383870759979211554658564647597431276201387905268787117395159708768469851280747177958467790912887722978638952129500429844614109293758504699551491403889753062098721463087847541473833242539422065783113000271241786043508962316920733362742898197348113633125520821821675569066713514690432467477481737e37"),
           e_float("3.3434178157637049517281592533308015247858438002005180906437367417141170168001266621540384803006493016698774327190301236261894604349088705615088400512503203336542521786052363807867976731414824848152978255318957160951505629941142549545164899426631768969650702331515339709095966288251347677498144616540877944302677330781996833301239347718015002075879382062109906350636780071305981728616879065416256670995e39"),
           e_float("5.3990131338899621442639150960787695593654392682867543552763110278886722787462718726364457638726939801924274609529943127667735179534571112111798433964768493165443780647263752751717504622178069130656396042067163078055983976660535233438551413680832384001350020819935378075631671112079635717192343121948327753074666267866402190339417333926700040005293808964342317872927593188596174308286988178642736493849e41"),
           e_float("8.9494020340391064127939458038618905808557846055840758526223248103141840781563934665645508821418133021386470016422027544258782053544434112680172586472904583621693123896945590165798281460494990580801806049825578569671197623331093483966283610886335033646197686536507230169332274881339744186331191494468903049507991117862290676198226017783722625921530004837123343373419076181453422614970293148641290335271e43"),
           e_float("1.5230254314808928712791580917829114628751127837305125621683234091718000182491398160567772334711246987783637710686750404567940327156007743076231721594685227788229099022647114591773644200298199153409299704212033033356558364514764801885659606369663103006596453747354052633241734882846900872346263393745296120667511531860904646437783750182022084620452350664495020389031866217711815176039292476374706249349e46"),
           e_float("2.6610653561675530811871934154475607007534145193302455634701910070523912802298573964651082538639716939902054355671200113692909420868144303241139115216903461820689244254358095051741911169798432697252127985725513329288598126609282321183718686919773601967320171392568067696415345341790899527166013768058726111602187732962563847928995663441138127526717534273061313582181081885455879920035502526961029921892e48"),
           e_float("4.7729374506280622117404821972643401560754052127224704272007264429234533107193116675164428464965944339720735600852744182538785468984434703080687787170785363502108278632394545936136549621403927392857084682258729465828739693082829545064563927386116063689263500213853914667265368514370928619612550880346885622805766280288409130600478808122053875557531290156281024907961449782392189475739761441009344150188e50"),
           e_float("8.7862640650903460639827238919255686487814469682324644892602546446528855296530840090832431752048522008129651821713138942256028191448125341419582988964745593210961004594995567491385189541249434260086458294067935329066426019683390908872289418315749105709772484603649733557235996240202882138897746933412173030132557263289359343645184204430799617705488596631201762059420894958380040502368561783406042408059e52"),
           e_float("1.6595434281939072743521936071983955433268893114417728156695568590585564513673094382134085579521973356283553285470351896109387029819277748932776032424102420280675554990136740827472306667772803790293541029553844658748549323013656545083170181604218118277826003880213969629146592722748104468214771783631493792754170235149971224033694017922530085089272052774494202700092566547575874015825360852379715970954e55"),
           e_float("3.2151094470241410682434433423294477067612979008457871284695954345344723177995423927509720609988583418022147015710913935117282652665862047920216276518250052184206089840457159194945955780894353985816696259454699727909457752748244437813507444881151663657115299535967994630474704710257950453795150542280816632379730544412678786326132137679591525709075512426495123463162597437894823082911442494690899715564e57"),
           e_float("6.3865767817528963241631825337358768076616184745839614920918032246060436080095621303262599987136321054550624630355613909449500380057303743032982938385264126095765907897233270106766625258206468356207206502428499072319574386031614091263279629681487308289836373561417198693321962906144449077057204576430267221599108204916455081717495162399424818301017934486873274865354614984927110832403018072208390895475e59"),
           e_float("1.3002846937979623285037194674592449680496672383952727084910383087667773987353561255066123259584972974165773258623149416896774631575516500301106188314358836006011069092617568942202817914443002606309667335894982479860549933654468742783801414666111936454816664921524627340356455813732767045543583034608396523921404122525229519563564216808709577691745296686804211085500444264567283894229223518419011653556e62"),
           e_float("2.7122715146325425633973413939769966910651761435413165818693500194868412620047268631189424232024376767626149729154502198453024579091814828049488458867415427123377774765338931630761553508640338372394534489319077780302142393085271625444331010719947648628065856347493556699931990802608863536046989437765639375077204920538606253096188289613868330099070527326634364096878883196217255087154844770608999867196e64"),
           e_float("5.7939558038052807405579189079437007586670795139192666837666621897260904410166737221234903473910235109727592524846340157057610217196003942888793233357624066858547526201491154661939239816389244995319183882672713921287249696657560166979203152797241648319593954751933868535953515511648287520003621033809176160930694413050330268673079606351981418850483589831094154731085871855117888115705966343864006080885e66"),
           e_float("1.2670269859324960740987154153959014408277970939600820619389350138623176710342514045307067143489315002264854827278921956174047783371153765019488320532807738986452112512516842715689139949738288087611519157542332387364196826561138139016677094351738450047487649665038924048760275218102157477730709126770858301785846233648290755285245655359269999752858106148853040118136319084863000661164197057964986106545e69"),
           e_float("2.835218881371606761407445030384463695496032609713185441920168153930896326356307727638844023440147771461611529032255681018202539307638651579692361463230271749205259319205731059127477244630009641452080824437134231673166247718588104265578737448568451525696308737201971997398086045661530310379822810504909977382545460387593511360352521003020846013758841454327803867651533047042570412606202424192828400196e71"),
           e_float("6.4893304166901132461359672738161972649236531891660826062529285407669595109753658181190447101609369450975784806232216117408796278567837578389154595572222907408822331510423934941042154966920101125362139481459845423046461810380017741399292075664310633673754162594076896137191655549782655529239341194900135108491005784822107489222687364878078774331214447858621701107327876381474415891138538383909530281262e73"),
           e_float("1.5186241497952097121528151294955138884794977151961438414821160778037504116919975837274707765049579063391851332506457205540979309007869041379673891360372026086674039442184289233519373805427879243408686325772016954116369184111101442835212743540466897558264372037860700761961167809186641787404709541886984913695394986956789204512368155518741702749215441402848821052168031651645325790164492240241629226807e76"),
           e_float("3.6321606940296726662799480477268217650774500700913991874729243997302069224976302707011585431203111646116203062743658487403481645883408620119849930961831328996957891100077479189783256470162381059126100637917220125847261239727659966891086686048242306831815866933551865492477965466584743693094220300628692652707844893543182768596423579949332314312274416115088310249782661932065452791890365462828161380809e78"),
           e_float("8.8751254651163814934102094568993536834955143572577203215418370625437652246633592722371833800737113713850062564290815098546025674744053149252086580462348851653048293591033249496077501952776218709477546633990488619781153543613353637570041622633080181038552693541826095285224718591486393892639102120791918903682947218075994288859675108405204095635974926340306803963281943829078479131070853665903748249034e80"),
           e_float("2.2146875873437644950642366646251878448739118109809595201978301797065143861768768497310688994778420203513353426151798019181100335836858041570371473412359972646604189871545505388692269187822420096134674880454676129008532672378647110324436064599581940034531777978597172321654395478866977115530543725070389975536661418157577007249235616532102072941862444151271266320486981744591933142935499368839964711227e83"),
           e_float("5.6417845466435785093413651213917012763058616808598797283703539838295824376551630496202640887717171251115479517876042009112236258065282031368070522326659831748658987982943082426619945785405317488435527802281057279089281053552736350279439654681670418112554077765393882136690495451508585071879001070267451610211707055947131748630453180578086320398096314871878257827179066416195699772778982308606912596755e85"),
           e_float("1.4666549793543488958797896630733927016016954369147611694338558850971921779574774395590333876557764234724557476388799270123027674767965784161306241600283686075571509076074943340877619509856247305948387668454305309602461577497887899886271309214776131911366712997856576626112420351933724563928699258434905291609962589635265200528177372784462999260803375400116959172776140395367648241622764793384486667921e88"),
           e_float("3.8894857577767129118202696606668643738491601572625180720702758266863068278250739652222769995267080008735450148422957056901997317771465751620305970868429041741903695692048657245478778687213416111210477753027068133863368810771310246947516032330933856674134653861989041484545743369183433746052120694512723177720624748018272336252180061700411803279825308161260632744275514246445983510101470127477206800107e90"),
           e_float("1.05186127663773693937994719174878101062807475674445021694315810798860669147338604674504854176811786441100253342951300977447002954405384090041410275554301837032186532645011376950473519717811893865318227431399382285288745988844572639030515143610904200828940356034800120592491628512338886580059801718319200622452565931102831824263468089908070583029872245484355492382248804808396560736151537836209808012e93"),
           e_float("2.8998803354308938222601398954297266919029322078023686880836085617299659791119384072301877002426916232534232465615931521112667568808784527965782077776800340938340221061635833279412000008230820248254298175150162837489736347739481394753619872139521467487390032129850346571806021259900070657230798262592047335604081042893359664854413288175470962725567375250986424690668327729858180258026764624835107712179e95"),
           e_float("8.1473097910244866147120121732929147614103163734453181270385567988541992116487586599834124729880040689937131395665554227791970997041829238438806790185441992666888376494987803728675669275884402913811240818238000351842189480740254435435692047751268961893956748880794909907596329899631817505152786706992758888489919562342345066286322057809973619427366632146941254336583482592956854728232832366882904972507e97"),
           e_float("2.3319650362784725947485036360749859496034648876474663561584171548591763049738508155736528699120736546273513160239287126752777798262779681513334925072713629572120068009741860763656527226355108026558727281229987672168007911078275472775633196552550919578869948901064888655474773042678111495541141483293876109742559379921564358889427061324916215608412348084632373487215084705927880728117820040771878806956e100"),
           e_float("6.7978006207632132419164291551504863607306118539039382493421318091466879839766574059647355568350744210407529254109168244428474894578218116487532421022867548158317863029083413802650285330475843671426935525816972799132348843675387746815255317630496377317330146473294576378264833456347343604887281942795359132417747967287436817835427524620269544875946584140210295551142101576936112008798139222999758546268e102"),
           e_float("2.0175396071367558327294718873749784519989378570885886398265886009504252653056081474524941409441848921911191767280470647158668138427652839793191676529088586951073105153957063173094050407124590671569162377883244015232447575527801641830592902340973980911595433438696768612997531465400246125482258095529208652528890760970038779635745146969796502206349662563166903484228492179909919020462424354036216812078e105"),
           e_float("6.0947416887604738171987259823930634338818169089984704680165308899231705500495292122104360477385460776565890400390792913849454869684353421530288012975527297827821338826255812930767529062129454880138785572354956518177176376082569191667822486158769107189890281966456036063442991996344406266746039641635105236588698393247213718513914760616093662897731710727546974973249504831568259554178240134167448318205e107"),
           e_float("1.8734582234339967134251320722781905873040524522500919317950952340435476279132147231068822529578444669683052674257399578796276083875057836042011169374612648808584408942022513003293817040538849898183015280793475465571764787583204118656811302669846939013963125103920961544968825283962314361075823394325551428912569918705176276552604585504201742298308054798643401698680132219222191530752663493163381695086e110"),
           e_float("5.8582451613120487469840574261261665409333032348719914622675615682104174544188615066563575962381914156789047511536677320682481971644877880435697715959125811507419375885848151979312710105239505552213865918139545132443067787669083884150668018622566302210060315028459022479008816966295985462538584563756576037486753005335607478467573993252518736389711355467178349212495903998964270610878849045571223786882e112"),
           e_float("1.8629817185378354671402612986452616891577165586602271274844980754800322856266458300273763025173331997151499737967633700638070060056298155592210525794867456080758005645853183746365505930959397978851327426129553113927654701799144111686958854306902601807660167769284818609893715485486040907147115978292471927734010251181651188496554281269675378161250823415284195484176622384497292374167385755689305853725e115"),
           e_float("6.0235583205260418709048374223658511120809390604537575263673736547466796465703844290995400964200138190735517276676748801926906197446484684885723308670163015451277748857142657135677431510913865261844330862593225876639698038191586146472056293528566333946294141130227558336399668177680641068298637703232706589169959315187444291994611597018966984759881366557157904427831731388012210485858675441094107021191e117"),
           e_float("1.9796582586586542455712684876480537207764131507777689440062208093976949052106189148153021867791370612832458820953937252183295263652581419440810046923280029104561600276727741462119431523450188974800298454947079062190347218603275467001944678688496801563072706334942417535824261596136883765088086501116295524305796598710879568767965128018375859149166139585039060177405957914669729186251886892553011593581e120"),
           e_float("6.6116836361826117123798136333091853081727243339633981563979610504450480022451900663379002986650419719849408809784496461534762089811500520932947883100570285518199696487414196427865723353781431261031451888286371327719604861529296921038760513125969057202927008797683512321236177696277892663165785698066866131060121464746677463253609061537237939672331182803068137670768895383205849183965089535411981162673e122"),
           e_float("2.2434362604018027232081609303298617548695549324338218331808147153012475521590530766932918701794696375536373482476153180290467319480895681723421324561849189291826525278149863441076881357559324188754421615658899891815115260308760008751744553888846641178666229204338163898529877179695534072790802797947041606287988746000706266181991341673434752492561338074356586793530389561629624109114815980577585461805e125"),
           e_float("7.7320238418854084371538991832427857335253739314533727688260986760081573927987451053643916193448021219493913149673607748548009320709729142858432132206485404722331459352905980646833207030625115567271234088730696908389031981793039591308944916554266430719778063301070551858667532732551589910070894097256327626842680510267691804746834376815073376852298672043347494354833168830390879059385362683520028488792e127"),
           e_float("2.7061453077644983270173378126459299209939019476143738020073289897295583004144764796266697812475713426430185514762398461231393378228121263746989830845945001658780475565664810378480526399406951389805863942968418142358793908895337208597197776126692332522272423729453942173460173751550711242880971866320395541872103318658717029542199911523921985633108104097623243452139947822465996105407860940729040389122e130"),
           e_float("9.6159207686833219378741048057595914741565164002019207485173783233455710665245310027206905123939716473747718750491482718229490507805155182234038434865888272189770346843313987353366647307443428164735267470386099148763470265042227201173934065685753168385628159079774427744774545836796386537083270880218026613095705691334868163568682077541191522070571349776002681144046700956011665879780855107076306166066e132"),
           e_float("3.4683139230381219137095280145065793533527259213733134939588254011047629122508690823703042482768046058514448460113155741011871662888144160851167320055444424637143450951172138415674681520622589463553898996817958002367641324758073694129068649036320515585289121186613052130163417551744100470002143804822435145240917921748803390464405770599927260771569490264996068853322763871625647204673662214888030452386e135"),
           e_float("1.2695274138343702781400739763789518463635885049992305266327088806314437052998864513073420097649473511891725845953816929193997132627553917023016816042496485640030773746592265811358245456836985502062338389046440954191641437741993404742430721480615306256180702070127565249311546585570779115178330172246423990509327299362860847694775871381481257350059938312625772827005050013918458777125330321465243685008e138"),
           e_float("4.7149025656639806451360430992518561868173955288590663099830934290511935982787099178197354959943049122012577477829998848456819191665324571037495651350712289798790871423498570005198601768364864955501749107147210820852986958979229879647801367568706127754092946376753345925525743288627113094414996021364489590036640927891810844376492547837620391568246158849185281464917168778236285696758479714112033704201e140"),
           e_float("1.7763290578802829011401011719887749146265577427099234086275159953869904573370213126262345842963931489032707064435363085323890298309504267013468133492395397063847484134112184078371442481056079526915450739409612528653578401743949632880573280917958063823413639750392435469635973125695219336620126453858137084604803554601768977953491189837210418033566144651889668253856950251850283370044807148073206999067e143"),
           e_float("6.78749481084037306072671448323772290706572192483330265175856188869845623588638608353586598886994396649352321108030473846730387183617599666346664264891898534334578424045345510769066120376870635171125439818529036688636531025614772970149764752357095031409003739123850067034234078964238764364026622488640867711991398972612328429625019293839068896304394856233372109257887554318306534152812040725825302151e145"),
           e_float("2.6299559855250476447347126292915329365025387152739649737975591826411226748108265941059506158379162610618841321488937605199580235332826158013973538279060792125198432420468738487584505560492531145183641303772222591384638085537037821220825235976458527381936372903642801339384805531535705763361671121744929332709926028797472349470078365371281349039705216296244518174535639383444518099923537594504172776514e148"),
           e_float("1.0331417099178291581251254943503939202640755266944196579700406821506444767191305132510921595127405681724978546554674109384296211340586860648017002521487734660106637786158150817285550370710981571270515602582797248322976044529130950372727715839174722352065178941775044812621367074699869502987224278964379213965467976862890978064042108498265017124119846676511547862069315461886420055803535918236985002641e151"),
           e_float("4.1140098675074967285171527915814489911579930000028207815820700882722839273505732870969438249916240277421976053874324901833246204451479764015129356828616392385332643464865938924231644407456807690105897540479670306216595492952842139176927196201275322940902617205918604470643813810968948776849496884389645015435116588819017711297020084016538588626733872132278479917090132489175698651331081634363510489356e153"),
           e_float("1.6603066013868400220603267898927446933338994926543006752663972227090038812902077250395612451484598558666393694684496328320097298614846640410966498534985039389019903964818389161839868386959141996154782182693618961802539495394973901001993366002334781561942323707553276782714824416328238718500076906975618040824532015448172903989207842782955624348192343618630486237649543560044260190996516054458251573712e156"),
           e_float("6.7897561703011713294168111838561752673004974629713868568319020473978832127870773065243602425775927229398065940710496578444824363358424908988241744854823925627872662924579471499617827127365367103498535088689232299804731788117582459461451388795898260591802167427858867789973502710248731271687891404190785065110971966626184702606999530819044408963391235101570381593087005610076673553285300184948255673595e158"),
           e_float("2.8131324257591157483073897199196898539747451819131859416385600087337139930710979555639959621973133341808364482602592878702418467489401862545318647703968827515461856884516732347452995412732959694681770468447313465533178173525223249477586392646763433557825906182637472003744653381037694636043224299909062407593698680637678908359547661132259275229884320805814759212824839914070411343516586560208149638085e161"),
           e_float("1.1806610468363758072855385534704509491837805803177667684183663753087307528450953877579807965698760535785683002276824686808753160816691406115294843552510908785209661148567063010168533517918535610232658158698106190675612468810811898412066478250227973539239970471954178407257700709220878478514965890440145679167337323658889799701734567815973350180720719068963003408137944295540548900167030362090332796128e164"),
           e_float("5.0186855966211950120415925855252190363801820984927347808526518391127543662440882440738851064694207113257430128857050775163270928497333444027361903357725145485263496803273913563243910971780244643859093495207425210368473548324173067819433004578832034464272331204436010462686745407511781717928716243134458286046610480093270533791036494338558246386306784964558414973065486978842316743468273123860544318163e166"),
           e_float("2.1603131594728555983742110177199542114760260705149917648051343600356797318585544529648130968417197933003730883990447165375493879881734177649100722757348247369477631577791020614880439711529417492074337470358019442818873212589890719321680410005106613441943932394168851734816332853970828317022953622738566232963731804033803599367250933738179755243332772592752588220189496470798440174007876616219816136126e169"),
           e_float("9.4154103250887024963391049992443534534946836842072083537466411372797926927704289413183152329192002942581586378468414329569848741867890141010057260525041015901643030368032864589688224667773253920402140860860476110655082610595742970850529350783551582487487953250921736322774802983796174145484687537653253953459789616792313706919743418124592651190582226054884618390248831244312377251764271987106375573006e171"),
           e_float("4.1542534625774221209185683271972551929155033889053541083054193662546876319154648494820283531647248016827475800336953622217163732361471531039357414663052251364388175392579637478147462536769591657129468605893680120636913960061727841660956784902795395611311922747031444634452623722283850342196671209913949278747748068360012074295020967507866190783225313908672606043098808372548637815365214014739921926807e174"),
           e_float("1.8553027482710484584140957701299556281204644600455229612638978025708683884303251827531168064110141957143542864818664306904048913709703605326017612230241046675975355130294192468401524049574694578424477860780822958110727707899450258780669324856841437411205458037531843605917677012692656733132037708114111278324514737075888742567015582336557033047537094464411765879309077810929211789830933260074161837621e177"),
           e_float("8.3857697581681807473697037935656395392040709663155799064510707983551424606107044925670667069458743933517542304720431630486069474603700004922601127120783263267668045273297476026428252307441757863921224270907678228147930728363119729067519473831728639530786836592420550747610952734155561525632784543443396060180947750510512565228056671505844102231851339943613181774097632837860433836762066675463587410771e179"),
           e_float("3.8354568853405775348169268902452714537203870124752439772691594723662183046615957591257213368692838578101466781927116277851239173523694605588192394778513105619418341435503470223618920425889761477121605786305724093538762927481372637875625028654112752371786228081502467767311122093216978091742681744060818846975099536976458329985680806729031923612936888433343010713064767507827628255341980889969440408215e182"),
           e_float("1.7749180999591217551694661929480362178132467970959326997277961993320617635516916182139780740596294523305356326770884378060672641889221644525198622744840608089999403010939353182685629447240537353018618231133411937488249176139215754494143405337818573180583833256685322080275728514053706390642828874658502502672018525206205179494355828908378334096040320554283646506720744797539620867600381104316285336844e185"),
           e_float("8.3093851449782973224606443333968835457251900345626104778070625979436545881899455192736637698018165997481896985134073343725004779173843490977776438373537261779920739938091252015701642575825323806152910829726743677212987160651681164462890025588497784141371370096380612495016710088400115901193947374881339981243304459322062698449288037807323197878558207672019863262249151752507645131186463019880627485799e187"),
           e_float("3.934888154102498380748521399922701433317518876750517187472436301129348539957571107487502362102303163742306529116996616699956283961239487583129293386537926734337068748520160322604114024888016671538981049397883496133276514819521718151256935165840866745908764872837239930319448119474404767552127914653472209426832898107996142534757840960286126955057532353354366184462192073093669434721907794280909011088e190"),
           e_float("1.8845758467690062288965228904620452152147112958238579512016853692695559965722432708687870437319095051809345542144138937712886941214571018856111675966181647898550306641629220100093679732547685844375812726653741600742568935779965203415103642124556429293781091521798800292734964640627978043244521906076589373326225765896421667352516011242154570240027934197241830314741808851188471743119205986425455571405e193"),
           e_float("9.1276409634734455977263679721650282754150565947897230898730613029703658969347872321810747855722256939528559362968983199408937334902940396513917841135491041805252374726235883350951591703206745853733604218091538518700677955955980804816592798187882067902202913925753534211476454858391095595937025019548031194235060393632214114198591770518905794830358012116233936944573606005349922560423441298054830238975e195"),
           e_float("4.4700697084294995413250170099042988800556799505671319966112067771736658990178860002078481688676717107874747589064184418488067159882984551510601336320568381997546682398043906298984953082117982718818801688426745477476897607714940818415606972622243010645447891424822335125105303860170481225940308005822890290722392981669785072897186198450012947757330286898445701586452020657686433465296112928424867371884e198"),
           e_float("2.2132429614769204298819561755135976504116406226771999073405424309798556180759649417989399584588406327010332443142015879855572890882983857356993065473355820096301826259629373114555936994988945806074178524300113842494606433896384625494408465423276344324846268697074090609642087476301023921966767307314560497568028531328371047441683687800263111983991381745260124475211151989594626858441760684873159975156e201"),
           e_float("1.1077767433638597219810462763850633074523105812195820966755363545651378444863141073151764144305872465916567083045483914657843445835935173151381316855605990135508496829737537631662543723937608541710061449311984672808346620039602028780877403371251275633031501207484038401719497214414645022865669719032135807763884685151897386508935064050812864894479059042907652332055870073668396928033065084524693337248e204"),
           e_float("5.6044642324621291348174142123060600191212329892621433575618143567936979212226481213107071067612258641781367180255066562437700650601885463599386532162093211621711403529873296505878552874141896981767196388647853512941852065538630516273263602497724324984709358834663212928822915374765757994114152151877557118245132569980974879848653447711431194184955764603403753811764765593642030848319269989791674386061e206"),
           e_float("2.8656690437911866987812559431628738252025679010897758531494026089447520341252033312917589899479930059553553411108502606005068078419122523202729102589125864712910942083639016244072443958630751644219451810201463255329754874616220105793280046427687902631346130490261669583189496069805867336103409966741769408023174595760254298180881081748492291082836911491757180252163927846764490263073491669541263138649e209"),
           e_float("1.4807453700977840629220489655387526713704333514023682530376538331195881505778188892201301253176888266619213873589365467116047599220744682469264571001035942166707094619220450207785260630977669639079734241407369236346992814705041820658957687338256779135946820107684444437190849610291733256986628993637435867702060273677016455350991153117047341404159042613599993085614035948612376414365080441377068663507e212"),
           e_float("7.7312632111034747788718825478130914383566225522244777757017393820750079337593885297730441011342044437517468538241774660776591195852341172678907400736338806355073274827025115058467390062547087535058617226757662411649345837171489336917050558046006731420697753656740543317888075591527270770281436842630804471209055001695845368401679583618161685149655498918676553147348965377935698602459896268106920921513e214"),
           e_float("4.0784063161375385408296274825285085118509711553439722618292409501569318115231958065884261233147742434515776092347335329063340700397118124724621324426868909431373351972961913485721284970264794032159923249591197974442226077429779758352502306190537015624717562311910232319078970199037000987791820352807475939406063377162244693519041982919891746650153970457028608031070279331746044745636931016455741807771e217"),
           e_float("2.1734798104676440189137499024056902805662804316217847398327074786942132635256464318770516035452552762831730525789370269155108654679056864950985393242942872162909698812569688588191687726638314596434350196133202105776356462899131359289556711596903509461880355815932895043827194537382534348304829234904619684892780794896718055413334938984341780733658699778213150742965156967275411929677705653919218064583e220"),
           e_float("1.1700430070967540602509012040004179837744120021289249366290656417496557580831899019550269300411315472575031799855642144341767764412985624949306822807782605639094975112691107809746251723397049796862658111286779485563106926450662330064319333916429450219697808947868086164023294757011599019870092364102717892475209618469801778301289376228978498396455526393946027223253750318538917548129687658193168592467e223"),
           e_float("6.3618876209249639059392996901114378341324856241677642441895081594318395525098639579138221422249435037367149227041593253903460474410320022356821882390803722628753216489140328711917887475031496229766008336043928582967122184715724181252784507039909233353879504094209045406486933166447491045996966859394095555500250240097756827790503053888886685512313017868405537299695811065155906082797752050960630574819e225"),
           e_float("3.4935406294424040818998590693280104711487779815985674986775731955696808153578188429585569019026620794276851564553657148798765222217726893418012520555334593447940844649460515151867584107621425190517274219268051625862035283400720735652059095637197354849937203168667414946599108917594628258730061954080271528638756969979783040344972178214503179972651309776640347984504600429329427325681653506332132235436e228"),
           e_float("1.9373127135835480448432490111684413249152625817986496469891518301498704141648302631747085252799580454436536187718930310055994922082082613794275082381305551343076827069221162404198322309867096098966171374783489754605397532535607563758675477826179577012367305992684742269634973477294070252647934936714866081204762780860193708573423116150597915444063367378001998025242058363812966366323441076839380861638e231"),
           e_float("1.0847934464049989515893242429942088669277736760905312705885128186506679929573764362101049787471927797975058106413804131830154840390867695378489506141788585249935476125517724395276101902745232924448318065895873584119638189806947343672126972120395772595169589294584713895767411386968935170706399877787302951923273756685860423057561550919241020266164232783623243248920436576414241270729551212404179119777e234"),
           e_float("6.1329270727649440335251079824252254598649965620852893057680254877373847329010203335153309543270756619167424578513514485076761099352501715079217046613764291231428224870854688392381966828981212315874499687972472202738335267805408536208201630286565540800498930659672936833651343482976058157553126671369397052956322251892831125976218613076102803233619728897604511580680062861575975970369961634817319196347e236"),
           e_float("3.5004408234609858568091102386847974317560569200640574873509682896448349890324976337356354137720747057677025750798276103466644056902100064099998464990614902439162350115892569233766963323801447830829930878486318864243474769005996967823790059760224908521732680243790546497627745669097413646676123605890162957922750236481810935097756027494632835717859554310390099728654454995690829821813247192605741127353e239"),
           e_float("2.0168488867497490849736074753806000487687197652665187239683460767162296736305314097391337490370634805180958875122146257343167053783770470049227093660169051084472903865073851232214781329948186670581348231336706027209621747337467781220495658531778557982222299484090689906505134050686502637083784645823412073184213696058321380419560793313210180805852122750202802956635223317047746755875586487186681829075e242"),
           e_float("1.1729563416970516492383588802724822781862461302360437728380208861116580652038009686635253757000072527187473151397816862801094112670375169287531413487118254915069282179088402119254637920197062745575243857144323943960515540727109324307800539384685363231160775784453344852209462369871448131170927214658906235627605304216732651681330991164126431098693460141118774504467163817640330771687754022654578899417e245"),
           e_float("6.8851130226754328092766667898113718510277953567771975336257830436663717548359377024944732559755798908672976895458125579607070698413745533015646288217617896088143849994755659576809089956118802585034935845201057624942756165157844449209965963488650038951123743974425213076892795821722652914532621060846676160808394990314000119787359591766073095168474041457337665765220666765094751706200281695320483001452e247"),
           e_float("4.0787263812623347660448364820501945508149627805143304264343544650917390121151918395849188727174858191844589856838156858544367983266032068203589603090087043718109323112093829627895525374019825433260090304240136917356438263085947243017934595387475242578233948202363880633254756063473617242215643027931018294326025861951003036464294985521966779441395193905672121974990745997859063488867097064435432874276e250"),
           e_float("2.4382965383928296229533704800152907833385498836279883022346424047835789516466251746547646214999246940353600592662508543752087958444882503051264080595347317517071447797208075461894277215589984796226065768978543419902095337858232431888119042652967524727253509511542757270847061713830795116490494693910734505230996676928195019329065913651036227449478415269508359587540218837359519864753881334384853277667e253"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01024_poly_chebyshev_u(const bool b_write_output)
    {
      return TestCase_case_01024_poly_chebyshev_u().execute(b_write_output);
    }
  }
}
