
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_01022_poly_legendre_q : public TestCaseReal
    {
    public:
      TestCase_case_01022_poly_legendre_q() { }
      virtual ~TestCase_case_01022_poly_legendre_q() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_01022_poly_legendre_q");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::legendre_q(k, (ef::euler_gamma() + k) / 103);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("0.0056040942479874707653008308293806640904190309494393355859510430192089222621305054233370327964812702351338156015583800282966868976565468900219489204089954472168668447533116985398261695262689908643516768536085294983077166485078600646796776035417817339544134953430893981581711548016480408390693972962230901101945589302801962971953343806014667313086484408500320865236675338546030893124499593488744583163221"),
           e_float("-0.99976550063970556804847662333184543509909434951496435032582353976389289265679604391930874298807956276246873730500959559281144250900448577657840267651589148733230225062714111815884612671361177711003468842755988092403129469313371727718976096817023578336360918620637231885041382006756502281363566811117315524297585872478841714688075744397945278391831897590015792830896825888067962199527660316982414641067"),
           e_float("-0.050022131537063899923566428954149979001190507823584503994067775141385644674347799502781028683892842465418732112931513837076275227332925546713697491972008655436823107221308662579150058665267573329705659146680505574676516490563221830299688427112175983869123947781739002361042466946889597486100232063759999026328535111726023010694318177352896246526111070014322486154569565993925312834355399307231449262358"),
           e_float("0.66184481656214474523581568374820929025427926297946824662258262124935067925142738907240221407795108056085189191947270014086136044475069772811523298145747099176411631015709388514483873835310705901383759164774704839493892361931954994314530817371287896499141280536247312479246807242233733403970737534017218226714337251778961510180947875672675419113021485567046803332232850336077970748330486134179887835097"),
           e_float("0.11780244701184240695586362334209357535933138740479512491824208512047856322951280657628925156191596431619961128820335351485854676383745454460454184158421224344618521127667274062332389348505069521982365959305503465328047909554850314229673662071232363648450592448182193022211807869285445733889982112691798477688682176100241417083842992493740958598218298222265588282039936523484216756601473301486768440463"),
           e_float("-0.5100149336700546560384050371947563730227944087208715747871989764469795741300752417059232000234130136935274397580109920160477813186582111324394461880623054998607967854608461835771634339425963093687037461310434186175251906800356782909563753469606963176859217705049854453800252229413845709154628324551642840524114241339032679643615509177789101391623073343179422693081203390014153393220609001195552208629"),
           e_float("-0.1988197551589610576320176993131948633678886849607496092547863661245864277648401292140263598526881311157378477628625565807672139371808815623081731848316074179362187659593666407281620654375666720271420315742585851779288033365599375746810104864683439549337385843481182229404753389055628121679545735416769786812760427299109282376961982519978667395324872796034683772345070026920125125748768392000392543084"),
           e_float("0.38942321742884519951354937248663433378369449163287992131943311783943873518353511651718473996576719801411488907600952871709635440917736353844900084950262619999879446642950021211987547764411774196586512637889569699952627769549518932293737371894931839752965337895265047717773099642241460645231073392399012610576460967258457196614051431872889097745993460381321497255319255811466416064487876234329672213208"),
           e_float("0.28041511287018930970503070395177086127442441125589987986558987433323203424617001481910811460926994728190085180087580312199218107246270885898648309151615673761747668142212922821809382701452532681283133768886469574749361740537961076947383374014279124033494773586142529837660373719677926774977912666265739101353433927258651299371866899075772793711720930875093348722972253756706951624124392351514159654863"),
           e_float("-0.25763132088363673130137683462864797584175719057167364064741645300670853638901385024611497427111146030512900390552558546030141111208632730097693459823334564070865427739671455759629328313751741368242699332328457692710919430607686818818324714820320428705881831446330598875989840207740987795083108595578294533519731965289664039297873947608220897959761093176564666907703415817116932275095058126574763216847"),
           e_float("-0.34208818978868044662092279746957295421541268969806152394922304485757291516622849852789861046421034503540201954345586216363630086677940257642581251380446526658730707410197863935929126794358785731622753442851031974229386927982343627088720131343537922426671984300577139653528774303987028656906673328602441241774677498513594320931044670312318967824985491209209174668977752530180384517165817810046837140669"),
           e_float("0.10035685261174081887490945295652473485933054585756821283924973889373949236949482627238802397013618715577347075622089902065792326634056597801335011372756515558840340174997019424670346280739078093555817128183712249537298693272145445401802264875157433013449483372246259159696220637500098797234900972906242287651065734361104398196983633396108124649026785027891233977539205403663186229369877635679058580064"),
           e_float("0.35540487377221187759832642270598599612801758468378708743983874163721365164551493025444724358439121326379856030644919491788428763814900716876204328771760392413087571640559092364546972045495400872001682254267647412622872970700622231853109086113681155736924763694890334907278203089999258797303535063236685561911086522458637460586730257329498880794144084231456393701801000814672922007381629106626908251862"),
           e_float("0.073123553377357598856574180619878093895131150831691751109929164384727189001276018902592913858212960332152464849943435016994452690924230564740284341251599074293090312945773144403612580370577089032236822329027093433096596661850010113968174538365927571664676243365792694431891245014249825969091195716566011545402421496158944192609444734979606626088361392228232411866911448654061961224941409814608137873431"),
           e_float("-0.29187347464045206537775120912116462188779850026635281920047900818375714659315093719058663631664221272188456554766237061989355181573776645593230572383939702105487777897453971581161436477985531415856394111354478283955834757632274514239339562360089791985197953959001786211904932237123116627955887877605804771507313661477960680810759594953728709497531227759026616928237505097005501222572109475606386210012"),
           e_float("-0.22594201515407963155692286900030910549994860592228591158073681796488204116978644616974382403768974168145365902962902805682111225405575394223758761877999933322167203682514097245206254568815279400163263697706376120537507368239156993492581426766582469751473851460273250196046351919089595245690796772987873677945476144983070923372861526693279437668642734575566119808912285518807034113516215039022861459182"),
           e_float("0.14150373447007844945566892256227990520522575244262817533682457030802913409091335334395707647322714707854489731590068964336027784491681588379046716406600460529385253489161344868842263720553032372181399282468940596598538539158277320072441999745985405698157575502911397849279469315859434895771891765960704803218484270797399540763132761060154450087162859387876188339940739926539094206482531399120725877235"),
           e_float("0.29883706089529066271413323493024012542776043839989930520704694466736326574983834903147002750314354218445344520797066963984630271260197049545009058892430427556374595697521837240171651745484996468642867515449963547537241109351408416999930542873057752620700547246231071666125060468174321229742693611792153669088111896493080313746856629236294612923772232316114513942592475020894444905558792460659430022134"),
           e_float("0.062582325343624269975896500323505758724830009973818498876992507836316979687250689546662059659303019512071099448349253681660119093258108617319750755967760047779945038007504457403218714995107396945046408066294393310646251933229694274952221437772412541221924505909557776232225850805625350409395189497868765924762318687763200565103220386615022602077998246454794333472371401945530058636509851752278683669489"),
           e_float("-0.23818328929386365401061392565977872023305341041199503881650161600661770505977935277408423556395488672852827648239915705347277490826520416545050019065257741000102612465775449200940936550482593779107747757899554050333672602335242489201008182395796463418716069179978294925504941786080826465135653639989154404271814518218726527984459664098451757163139570396603511128162170651868109189985047659389299813775"),
           e_float("-0.23265170811489246639646042643155234183352795923192914722978046369204395906011226697637169767557772005999010398893313088545881464279705343408977388021935246040015081298147421736487138957484845143403909245314518816937144848898189667988012911132218539656904846370446110499853632076595610340639429496320233116802761199431253647212535679800871435267345748172559940550885579462215983893625629941438153690216"),
           e_float("0.047195359108336737371577449479761129077887515791461912821840713864624839087749320478365613284355461987931599263333663049482326340264466103796843024169155612196237640116065154355927567917605096190077871874700330261621063766719585793581410755743649850510986882740458699676550112857172262878948528417508231765941212744474743343199995845564093566140770289633877746863542348482274977481115282234462272993319"),
           e_float("0.25839147031281868606857373864683126335002896153681563503743068538741222550256299595671276672373202489036414399196369371644273376540416982024296994977380063160322847682293202906678737534346367313123636024608491172889887813665964404457624478906124643869277199741244986666846536403320093099942180009337694218097374801752884673661058796996181640974116502917689823406304801604323514631874559536260374659302"),
           e_float("0.17202507044432403497115031160080097973854835551669661313348142533148245325054541967163995583075154216520060107647361663145718963472534562839762410614898150319923117969986596077871376836495912993092296326288877999690619080029034710901557309670437045242282902729304910757246269248695332345039312408862879764154798058648189831827168690714630689779216995194584810954609178491489081792912531794506121740199"),
           e_float("-0.095045215053739500511022882957319140687268360965789293847002228305299559016619886465714544216552403980864102410349792576123753808100695004531650889889174139845782641583918788105427460993498325809581003386222894729993923252766091467072591201866989700452367526967885866911448848600026397856166304838169640913487463629201916433034367610022847772637452597697529309821308860652543890694645102451791940170223"),
           e_float("-0.25041703530886225010913278640804677988372620768656190167422625469755672048266697361043795207435757804609462757837729222774973886914966071665780570830460760121910998452539930640188153395155052862887659468304579636132523076836118123464668590414571849798918789328397314576133827142644415302708321610912375289321876229519258990517156780400566295146334209866104713331714128334533501040641758233549557984502"),
           e_float("-0.1467428855097870564149564153931127542652986936867244886230827199181236128194424038464765965175779444589332950480792430361866532072383675907524138284196253743208227646031948007118608724155654796461340133547323618692642918443202403427638442047971377227176942028841849432602800587680247074816425775556980461680025354297057301909848140183999255972270501340980060179451089164391807754964460245571518024193"),
           e_float("0.094570449259676351839649766625596370572577613398476234159937423427529641012482235314390453129695656611372947020287066564596008163837350369308849124422888072586621040171066497880207165908315827029579627370911018527687940481141604929862378189811904263900690216505385344055832899918228190338309898042517985211555366909023437242274785670298424759472113216907803211072884979816862708055683288217877176174469"),
           e_float("0.2364483054280768038952460451200189644685469727046706366217862921506979753794234160874195576753264509536342875285371403950838588758352713780505569688319944347228259875974752584772410203079074299225636617341396291352622576860860470064746832717111879273352457590600976124046241145624222270334311044402198171707620712658228698440260459313211386681234186069836063212174952989630301475270539202527110074575"),
           e_float("0.15886101994745358950542534415807371935416829803257038200044776774919185473097754957079778573681869748134510990797070102229352642977584969777549898086634347840311935550316402629196357648560564570353630949843333164945812786934974239377028650842151595745023050661180846122093095469352665334754201958214929849731227249893186010625693472570463158809671473009629268963098995501554158353492819570140651626063"),
           e_float("-0.05305885029952427748704682738813258120291990172908367379420530492189761787593581687358685124837309589088917404986085306055427762254302042597831157748222347264010394193653188849758875140169373295614339099180954506361057964457320179528735584632289312532679144404848818272841443620924816278492671104151407365928145764837779854777693247156081518067482216104234647875512856684433219630744865460162567508244"),
           e_float("-0.21153978081070593216614953704722441836827625300157200801355195575744015080182155555611112079413995719606451185182988018157772539561359220354603453439529544097179804560157058807621991870109486305667980544820403133394843861723955815303798931440915506465783627955978658720775271576741703473360855419684278675348965525663591988405789308012406578806965585992974059990856750709208183327870627509458362735663"),
           e_float("-0.19410756629254030020684600354870307969882255491722797214434829372707694359866980248452507554995999939328905490704649419709544235001781856065865070439962624346333316183925256208043112941806272619701878878230457705392987007990355802628341206363801566312702669186223818907578903036289344075779876600107875453114024722027671080140548419623187967592222960047031165391735412117518642932091771432439727416994"),
           e_float("-0.028816698383725149735498953930533145084433278121475163826285945844533036409832746868196725864125377865119461617063032323614455376837425214335897558913670470814461967993691310506274072748937950265269420980113512261416314731695215206448496494007798189149929876868542919512297380631072373882399577847686909088535694221184064707474970124514546971078971996462946906857572015083264748852789856017140424750191"),
           e_float("0.1504974701691349626234847387021803116917813503430612694186357781735083030246299887900001213555124067609884654183699068375614655539335832881730131160116727121915847573159926581358662257300853751692445560237114623360263082987038082105413108272737659851952779418222165724698043740704085628321685004544258769651895393275640586243798737220299354950951235383792477581959905093424467360711502018593774114053"),
           e_float("0.21690700033112849502634561452250774306091381780857371746428077825919506439975255591733017281227380704818097864920352249760536501646376031984017150713007048468112968035174911699673015972762711186882411484472504195679936902707117789335615551679383635731566645232678834342789297945243638851946654110931290487858012432583457772161178090105483392268019158615138876988906965706966006319418655768563979320997"),
           e_float("0.13589260291218229632973384781313214325849535287184202630955367777131426023993770699342813421919308725491512537763516747513033378011875965476751517328299772549765571733721881807765343387462704765447496942375237041148702671550417494921294881667624593164516878973447088416859732733248401363172328320931861442687085860618865255545947708114149152029646454579353440589054716390812590350702930771579968809112"),
           e_float("-0.027828163135297542924141512390370272265615786929472569722893209381464547352293042161593438205078374683051774140151495941595197922427585688543191706411366516702689153573428586028865612749082098335414155405222845917542669629559391561041706404293009689440575488133822273850583070093586813628776849274467234741548637530322291536929705270912404410516877189518502793939598502064279673129754197095288771635179"),
           e_float("-0.16772417979267061602724243459293981453749948217829359781704502537780679513688825392869136110887856229019709399580771913439514549712477649622488335981948234239659504232058852253688618690732392989762017790179268862664754071193160659290396480254566705965113160842214707646035392561444226444044689430281106679768760286878193048220271648253789150775200453976197578145392499678944857951272804715569203064447"),
           e_float("-0.20582781279447149144346145074520356564372480138753861690847464289342794263608323168273818182213161922790356565666542513561478677578565680323072269891476042423258138860594306048821363975282240799483895424619507393189952098491938140400311212376329398155231626772532974117005913103346342523389349400841857410246154424770543295467675744546959610135982115754220556210073971156592974357430107377028627500817"),
           e_float("-0.1312243325106517477319422517757399631042755140689691881182695520703719281287442509731215724762589769106914827626287515940499828484943540260149877869120276197366069895336672796958308305209707799158238916797226016720908903386926827042795598876951762446947428756743113893801871381685939259344753422753880042838787719506338591787569410786745319311841302860795687151268135766322108497622875142659599709287"),
           e_float("0.0068138139122230001967197169771091682583370870534806200870387082302628751690208815295209186742959512840158498279780885329140048082134615335703992691506528912996613919792906754549456686297200935886912754632518795105853853150367171819728517537465272036411479020829683441718100218947714725156751493433779973589664185235378315423380093024417231051874590391824137011027306399600620304655483676460987267266165"),
           e_float("0.13535363872707119709568491167346023727475409136930278048108484280780704089724330876420652226914605075934864203314543214403841491716241855055742139264452431958363468180035631264809341717420719131961030418550864273732142113584718265200976784143365041863612495386509544880440774466260803189951128715929524111844323912346168104480541830290510941756936293216747525553454087133717982920294660767270840335545"),
           e_float("0.19724891777798367333413068320263490601424621849980386261452508913665652491450446616256691678492802567051997319015368404786486358806426415649333585440099588915883778538945842981247443072576599171966249583918777801539845746939791015278821071072389090732706676571772582861108132747816243250026094675734729375030635675751901298674843696311378948021822014356201180042809843422465932865914035218644118886206"),
           e_float("0.17350242984409005779546646749037009187745232325083809728394211819198635292641650363884181400374260982547678330460133769200188840649205680856239664387018505269724625523430571534991423301063357292591804528319357155258090976128699426756243084145005529598253963596779562590860182835530714892940679350036594855505046969527786652584286286674584551855956929571847576557067814684887990760344932928323108471688"),
           e_float("0.083100072132090590253225159470443957164313593580529497964028862253560482885125286640598308681910953150423740159806870796490150587164891551900000025227656882342030425863180362402238932007554713828725387549597820276689115115610746342802081459812669044701770714366017917689554027423460035166678318414575116290650498237967897380382138975325497571449113046723954684543943864055866862687550691644639218612839"),
           e_float("-0.03297394339096909504645624893887268665502803854713891565449858880942431414392850914904334942589029200057813638870139392784054932951115269312566570440693554990695702810030282592353885701989776314660683286052942763724134274136509696648728538237073080056461252495304776789990156133030994390365040073047496794259777953453441676458739841963380257111076484883768182961017510263547422891315063928742894198526"),
           e_float("-0.13208382454269637117072341053880285405857764130440550511508362968222493501441775025755474547219167325892555513550988072479315603726933807476854958741811338285870654389087364565150546419870500301667528399690835376351400442615667729737475590101506128342380463270490475000077509737587132525255689111375080594249253519944303798968757992995841154453404687931484291664492168555261605870695380754850122585037"),
           e_float("-0.18523550099773354295347336846480517549584505620544968932299224876878762048290697071945178081453819474344404161523301121679715855582779412832057556873356416491708418858401303905315328039515908087598358819000634816991860239549432482050119230067566518520076035165705388064174460218498702917689345068299319796738644812530716522694779892081213254345040369417886178533260847438694647097421737326717506698503"),
           e_float("-0.18317986033261758804881238746336260722916525333217054084593132066226417148992373954697234366278076139004047918246560840097227825335688012770354511790620634120265150573299733054561115271032398199794469422812912133492475151731311814319474477782191397235660703717710981325614576174728369122120011623920128698547768280686832859298484481767741200410826515319768451840993898743789942786932025094598035462597"),
           e_float("-0.13415906179632640911807476610792346624974261862901287253614585688674153683650793735404256297144601127675204515041981503127116443830063944054353423312701020549169509265912249834646614736942762863227585903932040519740950831785258944104813636860341069313430359246843547287168576710658465067671641531038996704739922081763089927909457736332738635323211493775104340749086904143184639235188096445736411147437"),
           e_float("-0.056868023379703172486176297302803690450665846917533682062637970723433973824660652272169574149568071535849738277285147161815025597928034356517424085268716495192705987031360665672631216189501190903407905472848651570282981067434769305318612644791417527937026762743635584485347353890806444839961164533070499813424845353175645481368786073826958595177796579001423187004653187539211010185639471844843745368837"),
           e_float("0.027456781095292098646034086434781063958944268522357511481315341771647915131311408215674265251018886666838177783723613035173797167004332696321294130664053365281751844594112854964529142958802487933936369619430801370745585841245417960209633950039370618785398167638791056427090834628095175233111759150562021473401619964921975401047837685145091658800291407520138589994879951313486984942230818358148259909404"),
           e_float("0.10109671622570660873553561838746866597130699118768758648374272151097813438693902657806315154205206349584798416160093581907884607550961253241954512617845555283427150348116096587466818964974125366973675913939617213317329471148508671674475048146967280453668947896846235527615324285122926092795556489596856231625759252257479049029091833857535798493562512821698102811489850044832950744164993962624904262497"),
           e_float("0.15296866525428608756241537459520991030585314858589886826666201043884940465462022557783119686182716575827305885321951301773072651866854011107868183590679836191901798593079055963677700374531596364020559369151263743467367291919911672844847335662538521041328516810958847369571982840434228793052082918943980848911287583820076681436171986454618357907954759530283616246422115952323647663343387612080637846242"),
           e_float("0.17902710596296450249189765272862880979328473017829339576864370978268363346596195154263585997742957706581799133453783397414633184306090131940157471330415114803112178378164843732788078817631341243918113707716249457244077557106370989844518621561328956772623834543867370210010879771701702331533761533387507898791654400514710781308284949858938022401171888819409692214977253828749994573375256995615081144678"),
           e_float("0.1808697096358248066639042993538086053092536894458923015718153193931895710513520959408080736231993309459331951054169961537163605378650170949048021605395398273707525937298245698770722469373902535072713226858560545446914948179236772324731855943675339099620023130273472602508758807607717763839718406917578999051833602239505052855529408106606829005446653206323517022399864838118005351673408415991630824867"),
           e_float("0.16358711087405425358353081730081943680685355177054123511775840398323788351874293813328271592688117873656913733771572064096317981466473265526406379437792628376500892318337654310920875224578301805213390674899631811905563601258801043223500081118589051101389353345326996757502431059636072797704851766362554911568177139088810140275430562381185548178811641625870379278048204715681592584314091931204286046792"),
           e_float("0.13366650609546041219128579678965613419885941994198778998104161091160521161344918096150720280365040359756422204720178439983400464918566375143732286841717187491306974554123604259698284831024621886191601444701544957251037131696502459157838591564573937192883698599972724080309216624444242174377464213801186424237692185273696215791850238027459563322476399367328670074874373154820343661811866352309799704495"),
           e_float("0.097405193389741134266316227341742663792420288825427327186986613235254091241634607549945132240307275257976288121788044146571424486503482190703690802518527620036315569138806716094667542214385176037741280995901287288138537384714863547567757278561336393622197514127500164472817244859503224672111071960730894811641701460516498195586590885948931730967774643174054127740983179549737010128224540403346656357865"),
           e_float("0.059972884918358374708022462991576676464244458571778509066197186195417607619532923387779276346911023903522979237271032912183677969815934680706317494326919191653698291265397185421688268522395370319756348284321998647071923944785797006846414944866972564350270757720999516075967844878009496627795604931463511952085869448460496449924262901414420546619217576956491548295035519254612425457544514020003301771055"),
           e_float("0.025052127117810038332675922235326160148945141600880050248086178694301730345158881282842843356012021493260488948517714713057798464078034420224722731122756671192064012782933568609325817820812321266717360311417855155909270958141882597468369931784593457563064004118376055046250956563788875308642812134213130485618822824468638420083631896072606314311424864615876360526097809076134486303450787264721521966747"),
           e_float("-0.0051101609573580296849354473891711383878819699251004818844884252952416743990922049323292629583099328714703659730173198089098327476807475351538272187018192599926700340964643886631317746505629102434931640042753726726031991908004817225809602004489461234638746349327731797580546657039271332383961841640074288731850123779627449103115263164692732228804599489254086607832997256922707982023329329045611083404241"),
           e_float("-0.029419315812137734088293329885199955440428208046130776951181194808047982253624556749741346990930776341268057137095261301378842008373220644746992147225671463870319385936522433258021473910372241314763483671709830484412059889751464105454951665966644128804843979488047827055518902601275029626800594863199863034837992528241036193380575982033840733982346094097772608053601025247412263859182626181389444089667"),
           e_float("-0.047562962776906798316738459020980285742955205622757501837512935469222835877742500408598100933890488864937497977165951435692875580348926311488607590266248790346443317475681686661815918058286460814335058363357958934245485363213209479345680131347849467126287252741818049871985720459528497727555872977588009357680881506331952905906821436588964357701365080951344874461260007731374373956735912566130860589721"),
           e_float("-0.059650611691793646599854955954079560193320154594619595946192274585893637639205428396563078759850161417252745727562379788367838299473019883049083276774022602948084089930691091572313383521173779133394672718920351795741334161335094233491598853405488438964464631037402386389794151108218081235157069296029846797279409023567313267457813229228152810884955023375358266617288669680375282933935153389821354224372"),
           e_float("-0.065914657641421698844044620801561279314795553813627385503444624005442560998940183599183986087486129752315225896550039890302047844598315984237292871523550449394553757074581229854686519019579211970171253390812518352388772023217936565863057141174587621405266852933183683388382697148555146514265163704064048589637728924181116894915908095873548327601412122583340539617737371918435383874491788003552747969205"),
           e_float("-0.066494301754280404170911295159964566481597890641869787607891163891483452268106040718006807522798258792118881914634964929667256234553815696082538490616693842914541388646857101007951350218267848155367100822127263476578742203322415623331997310446758115752278444717777022834252305274793522756754121631590890343796844652218364368616989590635960419251831842907234796384185585641910339968082235884040703816537"),
           e_float("-0.06130952712196546835656901975010105833188942990481801830269319265237360540503796423985089883338905815984450809885879048596216616128836795586134607779466506301181005653759802676987794055299744370489063228088832836687433313302016579996445489079377352008845026533780537938331346301556536952940296027777450017936878044635904227186914144635347921384756862589595443249923855221163632159390195178565526568209"),
           e_float("-0.050031783780183576937998010018038386366017579873615496380323241052403905948136369702683192478038108087545452107272413679227659291982181334541106325088512356730731954538974462554054608299531278148875980663141116796939032825426199189710209673806616773430980573224539959325076561505506129193843663753068731831864312344641817013538666218926835536097937173692550074680563988737022305883982867567079317249814"),
           e_float("-0.032167314105344496009263612865931075986222866348309677943578626895079315690306647040376111234121142450324525041748198537799940206672279711151540977788605463879264008010830731286733772124707216820136750748918595245444351634981739111948584282064263550593143551677255605181846480846639425839611699203653009925834465367945064355502238688478261653886197847978432791037667382333955590378039958872279501840303"),
           e_float("-0.0072820095021917426473370017913134186642198292198445781321641893930676598225461668630789121527840766017401970868434848910653550966486426907871877564435931366792061632477772088664821690981103113122663220154498638216628059774408820549906568331033279827933710956587830696571216973089775307969146793894797749538509341074375441032883498731835415058030310148949401386490031790928982288334657962168517645883413"),
           e_float("0.024596195331851487771700813724192595645886170516742897418826497874398002721091685881278390032422522715396993184667039758492290505764251780845503629671809231724001628911376291396726731542672250982929464277224287888417144679665132154592068912657106550570364960627681774101949468551358577491119361041310411733506369527735698093696874390197700589873002412101025642510541030488050234736540646878132852281985"),
           e_float("0.062375598131822008814983869408289996100649306132569672611854315666271807174286313656889421081412847449267159728384168701541231635786292666093108577356255172838441932078703336139378400162414880349902390471488643695562928414822579404245791050303491576664642321549036800170515318750963284754470196919501390689643780684507259264047371733155218698612527222308518534913364285206389760185400125265485636753732"),
           e_float("0.10313651651309021249171352171803135181117322039184648711637930503027665180048822278092448410346439831645822388561362340686297185038986188200146297252361467607063617602503536251466725664645660573598757047310593113189971476761964743938781307667098735207768714017679510281508401657009684462825500680239655099748802352047888807652445963605529947428932844480524927109257839315043685767469164120925034848382"),
           e_float("0.14137179699390468609804057557375531213889352718747859280370231317182596215004241552893976174221674778559946360725274946086947010942005808431490629957779099638448639157086977492970477373212110208004349375330017393677065763789857041719895585097539329571524786647368421926444734767693924742560880734758850256313833453303803172102068220644020387876162973731631373545737843211781094699277108478745637285421"),
           e_float("0.16861698336795584276661457880640851376716017243730197013863252142896696796858258795555350604677831230971423587514127826011629154574507529683231882175374755791876785917690832740371659742116786934272187050869468817214284630394838494786716230042196315381177304769802710202883723908295012714230521025767648930850219510464394300012646359386634026402904644029914636820491199152768121394991319195151998103259"),
           e_float("0.17412605495643558241663468455649362208436627451234984659011304895790853742257770106272146990980125956719756558671576131654704033858819999300478572932352303600693669898500896955042575440889887636053096715685804270111807650999833112868371359472042836213658629211876074279475960250636267772475456343560007567705284351766869553122766386406750051327802460856758026661078442288585657855510136158487739705562"),
           e_float("0.14742518559711257464598392889315197429018799746515437912909872843729606666414198533284760619597831518011350862239515589316321163291757935911321344866183674371533679678958714239389238528398054563022119784121970596944867521795013184909727792332085887888176061316164678229810335648403389405634032705132482968119689560956969982738773668836855241937850703406714417910593380326830630312121507859856605307553"),
           e_float("0.083332349490540679378119257581705264473526351011216540206809333072508637890020450197281178707826484648131900325752805006188852636992417130875725411575943697397253268699883221038745215794381609028775142797573002441695076346796443847741533950791137170249316742133855847992484873926935551450128426054301451638314302148685780785364543811066501850804750624560255859628685917860680204317755606981284988732168"),
           e_float("-0.011119097323977066471459120697332210367726384199134543320003480637124245970179918355193661836119595659708778527633590543657754633472997566618945940221838755042487046342754039007279235156297339997543884659311210834386606220704200822573918058215328985383787717300596902541973894690949846050198667077365785979524960972274432688344041826240761120044793373117274840304368796492289753737706922207078286424343"),
           e_float("-0.11081898171832553137391263720372017514704778416224893128864314942447358483751667319460485892895246415402601251277523624417317435458862402027652359753762230096390458783126531930944511677816369611466923656233042864327068027857444512829793227548387979431352098070272620630696642312041297595648097255378337050301071568089866733743492697449784155993693802847174245529781851794346178346624507037068061211217"),
           e_float("-0.17385319433572862840296527241784521704204790535063214721656949093878338671975541673581158218519849464296217435971298035400376458207107746996320202581019332769692110969752616028672070407387216248941266406408795706660883952807980283287623024324566350637997884340828588090926591545482973712411053787130037038390733941763549553698413818283327971822656123564864941454502909128400971567221318175896582167248"),
           e_float("-0.15719857550877186220128023178382844004099274667652237161201377858101984554327711888119062258662281038194167972076706797212927524466228788165168175744774975474403000452199713533826733417311003516976064375900041275876402972486932404291214661720200525782095619231692325128493735029315303468211058913184599402325117350696758781148621546106820985916018471500614807969033048743265641005693318431312918442788"),
           e_float("-0.048450112457876626468075659319095236035632438767112374479382196127266013246164215190445040786818658094727204949436447775711553829289913792735511182330958016081637945557641855956777072088669605198833995984418969724798763286222216593316150803596751110798966269315521211303413980602627118042181804522810757891355814470914642001675152710011013010036555222166370339143251588848471091731921410602822566474553"),
           e_float("0.10163286288532851090238642436839360051724260092897142102626377631475763493818336535360242753410679273667448952308640310414949251309294196711876811777453011087037368593147335498820028123427537180774324877583265260488977435739326363039738464366492068367713857429921879669917917362066195776375525231028440006954733067141092857035613816763002723058502495083047670975499458680487574964060750109847576537052"),
           e_float("0.1829521139469199869377513050191833057526474566436191175518668955800171835023832995162747729495893859456202088491830154714878510535998765480469048208530907962913420225220387041288247765769177617451050350347155814117328233585751771580002765583539537060442320327720881359373683583327831495305447997574371753813285029919653618571378819405692585828904353188904489085303875086433647780740866864893433770548"),
           e_float("0.10281591277085426959658647476647874853852175954654816508486460558952716270342233826938256846367217501496083067646313834025748700815678821879078924848913386214832292520243516903812654797164624493199500564304947474019526071717428050965407022712286193505661054006797489467240321247161425778623928976133884268406772600499034862857294910864064693129629029125401281472072058937912784693533388260117933316031"),
           e_float("-0.091504856817594075137127046711303884083457565392391093595370991648429570986641995598207789157959216551738354427115876894107303423136912555272054671442750478167914696648182256027782574593264159873341934163342509486931198371466125829313882862817565377152236687762533929692960572419321975773142556142443557183250324749361537563600019880530929375398153999377570774510737480761619447403332298945610720558376"),
           e_float("-0.18677562933752481331979248559737851748091661284153833289378548776226566707204061333926401124970584563677026550059944280486400319487736539662193787719773806214688178425283465854859065438128215604736192565224569382320626039114981730921360758025620932239140390820524479952870070737655475217940571882483328023558466033521372128997966865775810719879301820009613404399549952399647850522523070038437126103547"),
           e_float("-0.026131846259797135132090120939929710740473771831213141673989548147453890240630148330534273404266542267129108971098834196790018079213049125788388686450607902982037106088146976667737811406933106072601651628691252716349295924680049763511859116047998431095881818374241628830596901704124134187905444698559356840495154264222209944320515655315145691763717752761801488281722691085683906844936047866998173700027"),
           e_float("0.18491411475171981867431675596261547382854229177617918170885890941827967087121550853888697997274548130263407930425417107795803154200433125126274970526272199989421736585290605737998538036160127834452963432116958409463476241558730748167927164677243581990312618635130745720949115884647267181797297602984097141957595276802977196346806432605871232202548969985183963969236074940148663250987561291750765841806"),
           e_float("0.066261045005235832380326906882368786551550415661955631060159124629391136600227434241935114571350417075902077399547389541989600381019379429486442980650307507194601493312352486552217816670083251352731608201512964409549517114018754404450862058770338959441092090304346135837316536066552087807603375630973034386762484909530714508717409221892104325802474207703142608459954131306237210785504294251485403682439"),
           e_float("-0.194400998414159553803280236392009917302589785472563391347958582326128587591730517701225058228573940691540083664502068379037120355078175819706541749700191744469167301506391494334125208646336709035808797090927443502521238559513592537569633362555700713256861491824175210015009251465887235868726669712757064684449323496191258066699455020267376120883708171442911490273205681711778283354462833714472682523"),
           e_float("0.0010819491841447905973304008153463246862822522662949397846488178335355616504606130439868416004622564818214088504134973318722176475899287896913289077076698232090304157315807773100993970204699471812112067024979021052708603790078310230664955500291830056764830864606277785849803759341931219834818641270627343904922245813093902105582519248874716477940847205798862005689781853008599459945833038868800953447205"),
           e_float("0.19010490400903927090264174044605826448645236156379422868399404948994370726961691388039565695627428947007065396959468745087552666911429871547632381839658769204122246771001905198996592490150766024573638016621536332111735507769810818402473057241799876990952757723542232440822909986603827834067591261614642277663557731290945077073081150681261662269717756076157101753380418525195312972801707121522176268045"),
           e_float("-0.1916449619511316286420004658520482324365492818397478825743588776984438201361985155662186772411644335083912115218892399605764916809294059052749467352531704832437953246754171823786801126795513533873507574266383303911714938320151515174596962250852568279236662323764690520034437521019269126518403195323746735200922950859660144220348386679880222769920510732310177191362051863485208779086222761650768249146"),
           e_float("0.092769643730512599241470666397653660099335655322318537853056991910179007130779147848208104611148709060420847175991892619299170282246588568134468064341384293111852676324159841591832464739348235144340509868938266083609792453485421385018701737275302981520520314818815020727702974305371091780356994148250895265954000311073946289685512581292970865923640172804413818268673836841723532342945829264745632650881"),
           e_float("-0.022018786788758852625185344402202671395835186932772780843928678183091123761840385005797441709137029234367709347800343184804456965842047568895281855499673877102232584988472847807404912326709070872671959610131683209261817095279060150564521624113988880007406460740094107799855701591029503604143570515496914753061581377006771586167009743203484533176864512866772023427337220172472860128444657603572011779992"),
           e_float("0.049370157480930092184061725429538204579122855360870296427308385972359064726854089570008682252854959035196526559939191897236198337187724318597722115445446390291659009087803441634921141697593156603165830711393562643991334541795843050841863256089697489671078520558831994986622275796548812037533312901544850120950071189058766057604981330708980278056887065400164505481624000265054034706723818375930399280395"),
           e_float("-0.21756338872142238003800471304811380095916219664089982214304134410983553357802193354163678498483654442910247646478492464847520260596463599943195829686830941329976446703892446611534851391981167351982000979202530953089380463632975874957901568585795186594812306013468173658224890863487049634030286223292719466050342578285819473245782493191151630348137248483990575180017173994146521692943074913513484242977"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_01022_poly_legendre_q(const bool b_write_output)
    {
      return TestCase_case_01022_poly_legendre_q().execute(b_write_output);
    }
  }
}
