
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00581_airy_ai_small_x : public TestCaseReal
    {
    public:
      TestCase_case_00581_airy_ai_small_x() { }
      virtual ~TestCase_case_00581_airy_ai_small_x() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00581_airy_ai_small_x");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::airy_a(((e_float(k) / 5) - 10) * ef::euler_gamma());
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("-0.20494500629915508088666241691787213053800277741579379766498482255542758618856204658036794694735068745252939503423309121683212731085537556429282327819477357017667131046695972897241330396040221512058807013738251307192719315919894932971403935088628619236509841081305962968909866354779581221915945821705325139685010476747064631168678387708437793909699640811274535204980010330808323372066683764531926262383"),
           e_float("-0.11577718052969433399442989327319973368025355857318685763815615650765676784374351546410901766113511588563513643912646958930559430626698939742685818264579633772796930987089791478400976692113588519618840191089895625671036325542868262981505258043534986450663447854157413550378937733739746806352547293631693519641462523799348531632239156929949958907337882415775908433890644635623500404553827148738578438923"),
           e_float("-0.01791177137559513425788381323143552425974467996157805307493154884822631333222313395349384982427056773168013344910112481150070328457795941109445394803784535301616571173054392228481721459983022362454504010578743912683853375712729443735552363396161475183080949677524172987906648860642819106464153796790092257964902267361264321974829419648972646492929749610170141658231000764986603667175943631294119582627"),
           e_float("0.081293679081539430317995549217180409343338986508872211223154930715589433616462775185046639533747442482760759174099668168002478684811515482713592845945300280188009788785488288814023807505239484089120387427079227768034299130341635779313573589448302929137310278946078882587882173077140208691417104850069036264939376602713546455020910344392687663260991259435801890332550173153479134832942384175946921039751"),
           e_float("0.17468087837667368407437203051441278953637348813779313597451888323989711800761076434588818296088714784997009723889260530812885390561838746008249841929034042186469652411225330360526103234509257366439558189984378311596432057386739139758131244723518026071436652612281149444075568622752527304136397738607734965178312501026264220437771746212736596405370956627207196615720329945988636321545500232369101743173"),
           e_float("0.25580075480343568175933718058930275672906401126954971383246402461271972572042536816633528043348104152352025112659702699244729116126369825114521027021625822601219705959261611666668755109496602758791946419655489099649229347497410156051659700521958365111584043419393932008274310802639764900371004667878332274794767425482177335845928495295960662238158230047443163526924215172295954191965743902772750468511"),
           e_float("0.31933119124105775950130111161687243002501399233802503637731847048866128170205922998359036264432648187384344985932885443016522467294373897261808614168919385220403042053460502552319550694491827794850162769556886264390206964724976732558960306011116879208926109372277134190774559320323916379159940657847660330949035116176315610560797763650526068410833317101494116400370618007215489188849012851194638619971"),
           e_float("0.3613797412251356847599729464578431606507393332805305851313817571667028827767727902040585013500703567673480911817185084223220903183215989259335807661363578497652079156577811213872247125375603360389137108253460992133865696070245088904293384869140734991913145847518619985816985887733817635574408547841163851773030642796614562986057105395483135393243517890389192743435019364890229870632552663243683575274"),
           e_float("0.37965992721203239870751702357506018610248475179057685552834212392140918047787033097334804750736845231985558619045477955931325823991355732821111505572267884894348376001189290133744813551181463115502965046996671870638499217986499280666721680750248144701538295741183749064971658343757994065841213866873956069270377531899405775977996925577640100205385458907026424953798457790662418493767640874053003150054"),
           e_float("0.3735406151312995962838470493817293299594392445282229729757895356083750916715110858269579268030204544742775363930985231107838859652082641195095723687005226146422966046634209764570502677326170768385243860151177065747095215824625148156301159513563034478766446525299604154998820996383636622713269639990356998851992251335272832437614354330689889352869369843919913239291083730996946570585524893889412339047"),
           e_float("0.34397754330576845322595019246036870870533908999994001460977792170833921249111053425619050749503848923752989125948590071920143995958048486298506850311194646987301853032827700173741567703528089065167678069193472287004703941613564860313123755271488543451075560290702048735235441444476843193103159564732901547919774305703981668131029090781949293341404201846827423707018442105696076149056751188616843601499"),
           e_float("0.29334376289042956659420955609383682216095501660622691690535181438889988314057565785223315874513401532419301397002164463578930749470365981981667956732795191443162509207106950993156521939445089070550203380292674430402403837294647720547810779482887801124696079796628708175628114069766550194327555781156605546312807683285342416424882166175020114979970797791140444386530022693939188471876402409151982459629"),
           e_float("0.22518117135121044545599432393583457873428270963337963994817164769263852423249894682306638786071037351598104819051142863786438543169159091520948504647957648141348908844691181633793174207304261502231031568054135232516488972352084711767824501188831821321589535680506699118470981443641147667922738556361191283135724839566785679343893633659905099766997675419486344522542717034291828335388963739075582734141"),
           e_float("0.14389837691513417091897082274460314269428853002235845084700760328760373938985454426581351254690268539526813704233133206785889962708375291308236742228741073394625680830818053540053948516336825549885594223701136130683218856509524055716842955589239266263580773763931643836863475503003300583231805348511849412377691060917920183497728148768334110654017196578708925862546209806835549252126352482962979362407"),
           e_float("0.054440915898697250750103048070308005476914367374884321784564189053606655308881972188409096627270496606384577711832714409894391115010940803529922427798257925695991216640139009676830591414756542962188302464720107971922715062843764106368170700000228603276040628789049927403486892065732660685684418905911572440543649426362477290498696637074367772751690552009114240793603203570585665103995281989222727840589"),
           e_float("-0.038041380544785758179293878001016667179009237792154326091438697351382400283750371537113359512434637085293512626953922460798891141645782367603380194374174635459413667866188173655489711361734396959419474168504728891649180122915994764784734293748647312497126625900930359438160140215242205886519916136635388016345283396960176001139827541471974484075882473630620624407379288781847870829485701701344085894943"),
           e_float("-0.12850792642044115457726096763826565224135773687495036444216027917627269039192000472464009527964460170852352354538168596215820395000225906130469873058841187057199085290403396267452393781221531156958264632351078861324898190436259379915318316662084491724700609076731683589707202281545815488144145660278264740496579927702774751862458692384099657138737952746104447600397931082809227258701775696392134536429"),
           e_float("-0.21230391341204329350509061711007116087083783643802498125956852396096673294336529316718087360473915832396570129517182681338891094607453690735797915668937214576493050341169217420771888664302487626002924163013731667893329701415178570570816941447669512511539564549016151953518496463296196016369870592658210662895504648805317332183652061206803380174678019691826737812858799596837014144619342637087782788708"),
           e_float("-0.28538665702267175531023318624644653647616856149371231212852561008985983603814526336521248169906864461643702808721233933532200580097807603107813231434861116011505192393596202095131277148294214245322279945238598532045166203110446516641352617497123394577089245563159813615104313779899373458433938995322037750363453109746659259043475544312579621840385339746188208729558245139587554630804135599826982439236"),
           e_float("-0.34449356751415721968092322159909698256392907253971944703947215687003637969147138170985097130464122638790002205804128846605686247152319587108513768054430418337950500608023706421604785253807770546343724347527244838946962679796258583459367946548577777830610378879077715813069809021840789723425643798455288796833112561053998140170998957505187577852696961909181061311841283928996787391106132161798957511448"),
           e_float("-0.38724840332822278800843413012513000580722771318327429598227838153734523045419555898204518026113337620468625932405538851729214432937797985884898465521258066187354443821420151027291162076613222165397252850321949874258797052656099806211068540272369168346715171583149292164040013255932239281171883672028460805257858834813236164922339209152582081726071778505112029026813381459314685908630181268831636195304"),
           e_float("-0.41220684412992342337879440921714721235267648881280675431914912477814062956524376326207107645832697822760104466064693402095451270719212954134303901493751321348065489916978515361858266936632921584658741760900382103823323605515390566190229681936237871145723120158379594753244010433679753796813531966011519789517746758860388487150891045142606667064811327513752547337854954823499665150017182461625869803647"),
           e_float("-0.41884609673095330617244161270195454335095720006345049046480188811280214727152914377393844638585521735295365446912606855896725622775979886431737277352948952339951711014194236831671879474015047542297102754308508378999110396049141491196277533559290830765579851517863520232429932548910967154664463226688032556057600751426494134921234304325972620740344662679028182401203197893632883429738874352555147244237"),
           e_float("-0.40750607392552306931662511750076061145561137760864513772094151456758097208194430063700675603317628568661910888638417862266557491578727444849063695954709342630074688423699195377873770878203196413361614168382959602490921259166855871924655668250353687369207108194099364744685708532865288237438188558592242714192214092950475895047209150100622170146600597915604432562094771050838865906017082226315225760875"),
           e_float("-0.37929160339554165295796776145754198244326781394772424094318545085328106387595665750683323000718328258544387754621023141971783424653098095317231909091515664134516245741984482690218203066230835718729155272619317473665742435280721031437656388114357125815162013295053152455615243878287476938130710674154996639357933785727728857016167482835443959383244803262545628713929182637728317768994822286170254714027"),
           e_float("-0.33594614620878195351838173784631034430326779292431226167632306832714614985103585031692195227113728995172778611329482095410803091382069392800481798813123431950631977778886499647959078029611229045452957698918693624896785726169650889954362836497133211273449548761385197868913835418509867470495092926351547311626540870341787678939364802376014826105932416764112698562679680453325388588125173601554605034907"),
           e_float("-0.27970770773344954780193615067065050257198386643000192449622436794563742747364661878368418475050445560401942697795729660268496337006759641680824626176467297712380366327498015725913528360155966511591884476894130177078013773674447768840522562749893653088829947018750434521966613180431205604731620194602003317817850776752847667976388915845440806981288126056796599241127937751567288745318669985626445387838"),
           e_float("-0.21315712809236547943361562571730283884979354240215650253788816632320568957059746752029101819547624897513482716788967114857534324633608311422076504546812527886839841556575324892687021255880787620724910553374231980419696112311871971504086137250494756178242616352506308429564449066064985398987681891892600215061448193213382156572139101690903491470544884195654489036683299863648251063472358652311394459992"),
           e_float("-0.13906789228988081304386343918233449511691792778495635930221775022584965532900848472715999069434551245872626010647247941538085906003951508683569880532536299560471708549814441778458280448817223238477294450732496064455834628993973191482511430432782000947268139341854135501154798393016662325639502548780270580131226249751000830275516577622091683787465123352208876816308926072983302533905431713766066059318"),
           e_float("-0.060265161548376511112403202947413724201893899103775951299336014075318719480984108828301630541985288004567353903749069245879998986004424191603406959645936925788427075619822883695313794486732928804127765799168966240291540636280968541025845711671381369134877314736403305829318434157966577098077021815256870929590379634969015318664646092022340843158195446421486962504333036383433105232646495278767955213534"),
           e_float("0.02049994474166831897931992269116269798380161144579445166508898842188607739777863726408529284071390881010065818068518449192053615159058609185194860952836918954516371833623914189631825232645292559642964255359373551317703778865312547080893315217466084418607101290011849786778247804491402528199488111115372045208527822739055571271960325383814716770650191194175291465420674292203376578416302315368219056235"),
           e_float("0.10065654713318292509968295703024437276838808079919822355721126445704853341197273996680834220842960706384316638317446049499107252802852514590777486644912239981149872570564600436824770837859568997211363791640398394642962330300740431324741740464958974379199253281265722802928616244921115772799971281522426316543100918966429370733934034001526079975049257304603149426200569998492536622719751153152386173903"),
           e_float("0.17789813773524122553220709489609149036769815885735960636741238491177445108211983298253639776327972599123247032616371267369579731007392786142483137753399022260092689041942286224536255357649286681680849876364187761047711903636828689121125147955474023298481620929193083406287967432612228592228761850986673944423665258990524017379022199296962733130519180377212393113739199402308014217725188269741679285987"),
           e_float("0.25024368412819007937809486005662380958663070883883929887693789207920065945255191446193847660062413931800295825148813693011033459452528486595659174180995176223327279505338323729737501336106177770643517663670287971376922327436885475540379175116639179835555758260504029164513102864300990841020412060292327459632325234050345197547527445413454584374369445519487926981970029558018956946129357739974909986855"),
           e_float("0.31607611950338587060652478892313049143575241534780319767825371619186340217505687061857527055868697146551527116642674781446659994362607277633036520469608281349298406435151212166938101268976416881580095317358328501169195731975671359716204728971172027751569290491088790776018240295369094895459988356538476935173127271016955955203812156108286850127635188677923430113313341594089030939629701073893988214918"),
           e_float("0.3741597519655881833101501591169625934098785264210903628040927477626833113371893917823446774744168622737078990763959755360002645628508556921861517724495502471717949775304347832453377275089885055451874776691202916094810154645201170338104033277747125284759421124890050257979593885892708048448250114418180684156663782180356097099297403819494191417850493437269626862679822358023079551081079323665776796767"),
           e_float("0.42363896782397530454841631574088243008975751165005046322163735205437270584681690090832107778900452581715560111816826967082312470632381712050383673488910957214596206478764651444880342574125257924294444714968149184099203160522012375335951406201196469621236613582883618177065959251448551350224555919599412823658678161025516941612981189449581398741728242294227257633615784900293326669779830941729708727039"),
           e_float("0.46402116883381715509495285678507549718574554108376599842248868454128208569954732964191549734193332725772035981609516979700537787095626251867875688924083077100391419749418251320485181455429907261558757323508286500666277108119698429159501993401761034642448977227589188674405188366295573416841052979263724028849653522240706858056708225958750442412526250488832685141423717188704903456313400397826520723805"),
           e_float("0.49514718927823930484357428288089016763285236345527106439398600652912595303427768098815628623053784597576596333940364442185977194956720460122409509842886050110454341116543138392227363896984898913264584691760519786405086762507345860350706024814091878215136216961697647479385019492415640152443686427504600339982830103155393067476749488072159323073390356694168969715903701555923343420030293964141483495262"),
           e_float("0.51715251565960923960208986828238575538771311445748547805401114015735874953055820482351676728558472569535144951219343862452295469040437162105131588280759712837629020716722131103762433351396625350721185628925739523902983918884076271558667507725864474189055978826367126326811266733412845448465739494802784611713046772346273956450112300022390098479403607623920536335487889184986573583504319953038500096283"),
           e_float("0.5304225179091713214646088868041304873882293591588045060927140297177590820851387487498847125740888391883942002395351108880815930685371885464937816999134261909244257124894042842324325658629308682512890688352340507718408403740404990053683201438705173227636268156548234864515924110727069778216634007937918301550428505873537366697927727345556120885641772166354005579692145317814023538329155911812694696415"),
           e_float("0.5355446387768077897674088254987748838964226628567985296029516443549642403328433521517690991710852649937505199987539204641241968008862552204743704244976584393985518225752272001585075910125383699297269162873567592641189876210008168716136356164522337774349205266947334643668410477720792647601511961035777368576984152897771875109355178038824663856172238383004111499766423250091911387251276837328596677337"),
           e_float("0.53326012032293326354052000176931255915483894853726369242524458469943885408020950766962472565114260038130775807525229576412456435118607054066034175983431068588665436462448679505920375818483023966620006224873060862034874531927752940135854332784448684838627310501263149611062861096668664593633637337575992718067984959796391976526300767253930099829221717790337074172121384245279462189786627560992568682198"),
           e_float("0.5244174138242290683690334278319861303991670335318060959081094423905221761784408305230349300632553245534397789260577328772298065098124671518886825635375886077720858994650707262778494288844672997128293380025481891030522329211778974462372708189625540628931824121340443210003589762505703037317928911352164473322218986552362764727707235641410561779441276206545852081879522929211348560540875140688001003564"),
           e_float("0.50992895821434247357784795306993384966370732398227758326142429198838563300341527295541534646035605914237972223530937201634922587329640423200547604795205174929199750789992467945079125825769213774379304782272662513188496566137732784481524905999503688653927339277923141366689130999254227585980488106705918522606927799050980533932969074779487491990882617229101138183242356695407372543616705071687142868142"),
           e_float("0.4907325530285057576799465523352812048426729635508473138802805566111067269954065688855846025006429736999793292464942029459199991480701386662773088485173095359741563456729002982205766656338146005267587841050161241378829630759025140708765762234267335130947342707155486816446172757340136287473352806868571618817729805255638499582810336089393060630218717183895690894376518434214213463202457492665225094775"),
           e_float("0.46775811897081344157857110398693534473722365905695740696483468733137709088775041055833841169977187214825668741966911376335171695140856964471650259920344184823895322862328633643031712517400989639750205406462449893174153968673204979878928033106934846059703152023813210589749778460904875255466846549770728497656397165775558346707054759633572404501194191536856565190777667929620290926547491004634724744447"),
           e_float("0.44190025045528816852670017813005714232687033236937915165193130893580865991435725043454643272913391093820096687082677155918651184859460712606865689666880157700184870081473185248220700834793186101529544552519544691800464839051368121062685287131350568270944252242354731021248915995522203953232780448493206566307418593776126296396326972137690224884693926302340727322722144113802539067129362741038262120763"),
           e_float("0.41399663139713377175488455858424784843699558471861514630293988463006313304289071360866182627759517402633542292865911733393282991333627572403068424779574164570293022234300779846083669407767677950160693763249686799376169414846877587349361808365960132670182789979928046905212728406755331825800737893047306688928632078935155568236897626738368512404750123026305046501806015851375978141986782959465295232837"),
           e_float("0.38481211422149044973801107517925109209856114410367758476189524297261787456370125462305120164609805288080484624389791175922144801385167333977049586750920092370731702615711669368790930555236486719073579853336058589832892103220614744463029952805194448989600001277025873742303204592193075453626058732864390957499860902055208519322134867579076298275311363619174132825314381057640184645885779870245103164755"),
           e_float("0.35502805388781723926006318600418317639797917419917724058332651030081004245012671295717424605404027168842044873034949583975829267044616193710504024002258538638400990260103571281905156820329024916964476618232796777024189895947961734890864062573238976014176400567803973877338048631761087545202532334922238896963107976778170184076513520993704131557339153313266287571700397135560804917486391028135850253521"),
           e_float("0.32523634131761338477946802834129010705041625195885111900174328003583308097356170321394661122540513096518964385081793861809753738818216404512273778126541041127308156628261419918949698438071807347107415570603605975074219897648532072998281443227218325595357105489461284523380228269338830224230262131404059168208403952772299954592870659261977917616533717132337958633425108482693267944298040725319850436823"),
           e_float("0.29593748878729959255139943085731842982221603689836484140555887899129838690604227771241201313740832045739192525052834448486548868599080276155283008673493181448038044219519120874997128523116205920692536773634736537422814846206325567485251153698486578712437601461466818954631883080774525480703834748039970866551242867441492249416966257983670024140969268336909712411274004036404010299090896439138414055647"),
           e_float("0.26754207655425127897053813649347875661129253050872793812228406245323206095826175641831177321950109373673303572282841745524697925034642466010428124361463485586887756980151089352666095127858352097784020901729987259384818512102993443184533349011765689823630503229703997062448177759969872732098770920544709262043109294982460511130295572864253671016642077924855973619515398748854785966130720284676124422277"),
           e_float("0.2403748671117102083779322069693559723321951173014853226535933100725610731357382911189529230445925146581034255832425527635656050837207142950952418108250745051610556299634092935829140831732975787104699196713798157181490975172269171811842492937853640772059925387558203954239249740454675242496873180223618082234732785468439684895755452837874662292844045726615246213471597666704015946511847028891072476483"),
           e_float("0.21468092254465718668185998531500819177381451908022736249792249740501060510848187011468926505490017053223431170738459629659020020517865870846728197784548691902865449293271680926184478454547636791622530223438457256793663342469190758026476744666375616234322096762546171012179674913206859077383775000243338396005687043375607722373631017860816398135709425196887093806389794667336467100436384227399618215368"),
           e_float("0.19063311320492256346327286436311452396380756674092884626064298197799636678165668009075671865706139701557918424486458489524574716359393905143426926614208741111763800913274287119322859122668536427528959278561356225503448148188417546450617133837017084948862167374067726500386426503015414188676090548225897262158998228815170170985741759129978731495683802044647220837687344791467829436778286597865339409321"),
           e_float("0.16834047467101485946887199754014636442370980513443257528783347953454974812653614128743375748984958689604140473673712280105189943317639757965946996790251183750968499092049802421639713199710995178434508906168460794300379743929092882345874086158931146882285346511950080702366399865674037162813724088305397752495336539520943831714102754082120239788599232803607848107116529428012868563361232842959676887988"),
           e_float("0.14785694793030346949466309150477919837946950300117798526736544286012828622201405445280713760635890043526557940272937235636733336861984649199868105570826695555306180542011955881684067272530741775285975165871700268350181883569670296088846115333349852924655549860104764440889666026846536832139619104066154335645462314950746321683367443804411070701404988520864650316378649246532998144801709001689031737448"),
           e_float("0.12919011919936364663416107499393930538063144426427092880348059290966857147343038411796595759567085151176994168425474574328496035148428715276398323158681412760819780532719845465019481790195719019738985148016678846865524064992828467188539698438908632256161094336596932867954374783510146936926198723090073303172236901089976854875039734076858669111038380515832420005509320392633283259410623550021677217555"),
           e_float("0.11230965618512358322787622161161530605837096223540832716355163103002503003047913623823890487900338912281782122899667530391413745996800278769934668909003616819150365678804114464670634533493979802906131007200732261120067438152875174452623252063388258720712767749815920180420176312352335241569449154564509452420734413480630207886381197668063582823759948957508996273327497488716649792530021609196495240784"),
           e_float("0.097155213394084599568620553755936553464381389425888555514098147275009342115746555121986343602091892493410128026378248868919371687370826550042277388207933529022503718163548141979979172049672876464649939640246412242402025771572983547889893598121334496185023456420232802826872154313002748223406619379089931070995004945656110427992730171088038894672369811384524292988106009055882923732370351756291823245651"),
           e_float("0.083643647860676736257361630536426587050738230374517417871724970012197847683569813212633471297690782282518976615711778512089016179859877802367828874631360964733738059770123842035374215118434056538789708624209342414692615218822778871271615354497933931859621188791296179449776553277080938474756188435737956239802574864516276149240021920360487928970744438837664212848549781488484527870254325524708189304036"),
           e_float("0.071675446847853161329150168312533175015240271957866883645301240433079009890952950411114450599423109891200161328354534806370609359565801791342542214027290228342525331356250979928139447277607775852270073145439062097569778122475320341089124802218991482635013565119853830068833438158441488785139428846037775664699769670200927817887346642084237874347839251126590041139984275647873056915480318621076435876259"),
           e_float("0.061140319912157259404754398479605866573564724111085249931518123109739627102093797596383732518160179771674723039383723426708863517042166210719902597057390161250416697368816081625350858016573108136736949731990030219906580865185729881637799354201732915009001648260704742786769508905449419034537423092704884609632674495462029307333914036300381592005316099746793764715077856016317018057475048218914015312347"),
           e_float("0.051921949092793823313554236537720579763437356449135262819373335012033780891663658663662335494226553268790528396775106635171412313738114096338271380341727234216262506227930123714819855488010825272622395809246919962726184042962550142830638877153022162994460764347081174784346531761888955795317609527667337160751421454388694522599582212746662430632607880154134970953544271524552970490479831361911429776733"),
           e_float("0.043901923236970307888227421332549801875026017156252024054223394188250471552284680984325217681755283899443813693154753224425521063494631522629295197582814916916303218244709455041225616621539154500404734976744461670739037683675018907565741544498712238433488084941451248229602199251930728891624042472439263808640513354435140864679534704182313880089312499595589515371586852791705066530395612565027532298185"),
           e_float("0.036962906318924941070086303806154038071872222487083462575219326579812845388410791681530942758661138732608461613591266832531622061860327980561080676169991252195851265244701999620894102172252454901641983231208617293792648233104523927401173748602304909019351751357256877119205437572629676450786732380887057718785893382759564969609373747516487061943162311676192096380162603048374667406053762479544775230292"),
           e_float("0.03099110598283150924813569509630261012453598854806564926374005048382608285858032940091143879444662539120276341844623268703191376187873783344235935164249310833293374901140926364669392046399013353094783565182335580677259128174071618060184601310624036927236458773849518012798539948450724883343557709686369319776274419377858283082203204176500434614517991155125979082590899819769984657625923909034788822845"),
           e_float("0.025878118500242226566318751063930039051951398000739561932953247654717610049453824191731295389383803797738191297666476899499901922280818198297088148188353723432386456024482084304289263208637064522761219453140706769861662215257338291206713623166389981625379111259965563688265489970932569588695869371481273831688264123203666773505769970286937466606844232976843023896811104732936625777297790220726314555924"),
           e_float("0.021522230981845918125471128974930791814643535902115778284650213180657358875791411814250223757055860061645367636636027758836176608442324731188418362485485706830471688201037227756654532250782290051441966215059792500584732315836782441104421065102689965746947583311010761611789566089263365456711746212004149547805578382613008514799642767388155686557119567948025368520075572714538264388895989910697276638412"),
           e_float("0.017829262098002173263410451425423469104801261342997250053688456313922003057012067275464065774193034481535088463670527741442223917190670041814197333862518230658759718321062961355111162377319759778990452453235408927782668292141876928627490354787745924908964018705895967913196733266687097180345751890816338967470490709952229211950487294346764114154487199542532859165900365814939685226003586000255191164608"),
           e_float("0.014713019748570997820536381956113240881113422099496707709257181953275644209340586039216422826191381188334995761380470384414813060126676172226543292137219028933783662152396902755931695961450681549968488042314479231811497652970318355876276995977253432208599793938687234213123372591238994039406834103418107531662533225336472361202072793229523931081785455290164756815214471568319811844230441347405946660185"),
           e_float("0.012095448983377685308764825721859765503642835004476876062834275451151907721871779030157545364233518501608669909161775122414557411315696433109306546904171248526982856338999577831621869561216380649494784093764912470771306290076890165526045767113028891513745907674750479342287497092018579867025050166466604931433254465869045112270206426679396505904508398307692220669431787696129800582302780998425773686401"),
           e_float("0.0099065367932786235266467499321069109123544413912985880702639042201219018038097569580526118557367375648098038313482605180695831503089272734928247375607139434494573040826563393493692349387647529618989770535749478431103586358285547466304153282599491374736189863721711178486587956516920353905492337988659173188848648352334163070045639600113425938919970646345892497956726594595669174059746555019364652320936"),
           e_float("0.0080840328238595252684440040679107256156676985703858565148695417317729398286436735233210352044264891549455466742378216205803187123130796775793333496015219800095714548431744120477108271446117570621670621822134348648979212118988308467449938541838230176930106372937321797940865779209208914482908380800184906120806002757909341437389591941605305395000496855054251769137640969740752006398656817608156616458494"),
           e_float("0.0065730371388252141663070287465461557571105716302717488131000165528141582072915131000883310742678794230422634536742034176480342576008037417739944626002883276273682066448484815667448717419159990039763113529627280593541967226044254201758403926125764157375264405813853783585021659675489833908073036544606206734379602799726263538484005561966816494143747905056587990075667183841054636474064674686017751700608"),
           e_float("0.005325498288912950589237903732204502413445868993803956561612199792801024509726845466501150347718208440395522116546686208102286993852845825982230070382061935916289779149224472150054340810420936776911785135724196021550483897130266108327232436809683273328501713310035092953038177391461325975163834599233194296510514523036507170927747117795738095293069593965237756445339499069729293519597180135836488636911"),
           e_float("0.0042996574281531232538015950370461192579599481817965204230564075846643042508060066787990825560726759810556049983045604661046533519112761984235170300289266764953476009181240632432332457661841508955392528763053665453551099360778765361575610684299841228699414792981766240197172836554739038206787508239734046125787757818465679564778070219644137437973678492540472023896332086197151783313391560752557712819942"),
           e_float("0.0034594672724625166585246577984734052905393808759221717508903296462989791931301510834665033208216291002676768642803481970218112164124779932621829299439869852312741978517034612930769186386074108755950194032621922655936844591934220629760594216859835266011159848376046950191344996878237171664401213881084163798863601621702624603810457616958022575673716145019977688946378832511481845521306661920758290696646"),
           e_float("0.0027740084470900066937450345934109282061033048093822565123522039695723891160483082449329280364011995602928566429235009033419070776003844520904723258459299995611724186930565919625166076607799031718992303402686405007319010432661301374973054759290214170017732509350904502484310671716248333765894988869916795624117595946260323360058662209234894436986864716508971217425842577860775740908403666296753642619674"),
           e_float("0.0022169202865186619275802722645474700930594930004264256871031829537095755864413204738221134883930657475755975064026989972167154646330040516486670314718207826973048744640708723291350764994093988512565694065390322861823176936807554788783395412688369347457321214123590766248430215890039431080520401691688243823492340294801793823063290348463238492765903709554417351320876498782779111113032836075251397877968"),
           e_float("0.0017658584501178639545774622318014215359919179176812122399408057141012198330583308049716446066416266574972246789797163813663677234157125686966487778789570766396090105805992970024653110148378788359661294659178619792579412113567425605379073290248554510436246589590866841376626146735126562305070388308187171624373007730936348503782748872522858385880383789378978588093321161695486704352048406481419964904507"),
           e_float("0.001401987778664273192006702102097551389831888629529415682200690219174040050137719358830118061056201857940579704320156473780687270144375334402612925704593043255967727877961919830918742592700918156123504605302070664980356811033285132919838402962863646210535180943062359047684791006791728609997703592467436870161463912942552062894214261000887194941550252225492346628643973955543768207464436556651737539851"),
           e_float("0.00110951559380700275647632662895846236301148959274351566392932633975740460735778398511928107808622997942084943854723966214195564313474958218010850843712942947062164334775813911156158779521577446971264468692380211469117893443673930562136402708594809274308479975147198370007255867411499566113949587152149971295526235508437708611232441053476646254904914717019211247261774853156871941102875934379960836078"),
           e_float("0.00087526807036942214524619484082741932504963484037071216196101990777765040300343624778336606233197749672842581077666083016592606619211864692297632234069940473599191916357166861064543184103125491265303163269254597754342093660798410011717174602492348668677558830436756738129645397252291245188740812827553203159894256710249038816513384934980590044292748400666820807003368223132753758380855875736446655131485"),
           e_float("0.0006883103160702532224744123512074599880179219551606605852808405823125381339083344068898167907081420935944045198658637632858371266090436977054157432546591686484900903806937495543064971188319767831724874946384607008794242826416795331361793032748757979091701800478218062854894013264546581072033442981314880903421156510013126164930145728929688557945224061891098740967924954995991227155450710895488315793098"),
           e_float("0.00053960929703516481968538106189621688058106022774031457818218976734741570784621693641154298384760029376703188331699324579202035277999646306576258594375433640435823611727156288868746680479565063321409864382854098164860766224779004767868487304119521601609460042671705968585240831666111172545440784975230820218786528717295961038614233068190730243975098049035699522251470379756362293054294849795213875884733"),
           e_float("0.0004217376732584756914929429780866643668738126318727350316905249893111772098035361053343819487001513233385660208675285670448136045063852124677952575306360958620845639790887904906120347925708029111167598999280840765709582519846677106221781404311545019828349866813462295011335458878137857415935177715227500238862030896580642188831068867202915412139944199600979725840094934128232932688022158847360922357942"),
           e_float("0.00032861588272914645523108985441353689568533771571969786812424768534404471813996115761083543041594879014668540778528083719998995612623753844664608088306292117912612999169067943729286656136957150426423564554623814686799815485649266007690092757499267030987941379211424201941431731076940167247085777692966016193431948555810123907245334210721632034306929077208972762988842525782557602067308007022565782367829"),
           e_float("0.0002552893690022447975253357595596402160924852068982200142163740345627871862839334612534753257881512496299245218486251269977944258936744261303748160305406139107052505619285387520930783394753050906775094836163918341913179008198951436692922500035999815053331506591578785754181408580530692997964395433216231138069353504760292719563802658039380466575638631089072863439655175219765555097933955259770844126566"),
           e_float("0.00019773762454547956006818973291731602828739866575221482863529030222047663072772777981162069696481554354864352369520128298149701738506962494374320186642610614783705118287302715403243342957294375825954130771869693243829009904879715997561324654538369024528394768589358393986459752076410698509510924440632776338290915784200580670815886874868633755271984339300038928730426794296647349851330822601837619486752"),
           e_float("0.00015271166897044752288187860288230275644420731143299524041686673890189301611094934222720235182622740131739500194019077373694348027846907958337794391661914060890000284749921730282962777426834598817988938614561853439658201950122510364061367053922439919466480168229556161155280587944626162012586337643029831205907054632513566910989186951901262030399436827434776732065186022526862295165244196198257387389254"),
           e_float("0.00011759665284488975712099340960861350569900791605391204855876013435591125967402242947091430254012750007681426906504607442696343542916121494870286633183920647966233611600641907909381758688405883150505885055330743170303240301336392779091822902494882260883302746772777718430031078268637244837854126759468764881926216284041623990262244710011196615089983611629514914827185021130995815630974079405203818954621"),
           e_float("0.000090296437250084168003532035853918448103024906644171787310370218199726364105333891925153498289964502716442520649146869149447638571144530604049555114052145043211817071707535487785317923209379375890889882890482453093055305004975147738261973547661323848762600771588094011267608190546308895106546685077195233198389534012141010595056549292650482632129328265647496584654863749665717709842896352501549076557305"),
           e_float("0.000069137216599428741711164092706418068244888904735573335350975526160071409509631495566368039986049515099985679981014856437590853555980179419963676586470886179041346136196157766663677095538413158943890120059412196837595484218252193437727823434917119255548432538543544931431049513560294999900454838715710620020391325776082248778116856991290579854452403578070995560154146863355734179480346172115627083692893"),
           e_float("0.000052787503683247643895768925189263222300893674478910609754252308101046062829398167253304181710151088490590977458424821055865083959961155503538624481854722037272556702910022509791819589883915583895170428117906153599499461115483045636213530244345172256984986081203234840487367468755291644206739014951424638617413807936717724049590665927309264315513339750271486648282643963117688040567999922466793306952307"),
           e_float("0.000040192063085756202613936058579700059880082856192091434049414338530898760884402837432610703376068201573728572834863588250008466693038167671449132068337609198274137067952788473895428183423097320371655514121612307897359172914883431060296528419344055215588763252409954342436658190522233772366596935998885585168853457628654838984324499502362801698689965669240421599993227041383638622844937429228659752061313"),
           e_float("0.000030517648289756501524451066846914609227379251222799976831727771117817703852278048198346878441660618379946864267330045315129042746480448351099312879888575530350351019151971575754008394165857734805649579517310305540652612647929956933080128259819274630230288142146537989829913493714016231668419389479376653016361510714836400471870732471626687507182375869865037330531487789370410385659397275427255675639582"),
           e_float("0.000023108659051111690021284779214058887659415867903486075275893377595674951924391014523808237648545936363708171849598072885022332549190497139259375161946000695150052739447014302153312799325486369898214286879057198344772895729134238209867217727518387988255974502882587133031892874202062905950571573630471635551648578144126809034680907889752342141120640058895416546981244671304764271251560405640799792749118"),
           e_float("0.000017451082233985816588989101141847415474216499771679560222570554604140867575249480398411431552407043958031938577830209211536661249660133401047353365641200428129780537008622210957810103711978008071917013579946516176016216668152567682262580190476494538847399505226327091940101356690436414656965338046948480005917196192282553819268099211455459748576914456311306786106398416920970350878074913759911889452813"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00581_airy_ai_small_x(const bool b_write_output)
    {
      return TestCase_case_00581_airy_ai_small_x().execute(b_write_output);
    }
  }
}
