
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00106_rootn : public TestCaseReal
    {
    public:
      TestCase_case_00106_rootn() { }
      virtual ~TestCase_case_00106_rootn() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00106_rootn");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const INT32 k_plus_one = static_cast<INT32>(k + 1);
          data[static_cast<std::size_t>(k)] = ef::rootn(ef::googol() * (k_plus_one * ef::pi()), k_plus_one);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("3.1415926535897932384626433832795028841971693993751058209749445923078164062862089986280348253421170679821480865132823066470938446095505822317253594081284811174502841027019385211055596446229489549303819644288109756659334461284756482337867831652712019091456485669234603486104543266482133936072602491412737245870066063155881748815209209628292540917153643678925903600113305305488204665213841469519415116094e100"),
           e_float("2.506628274631000502415765284811045253006986740609938316629923576342293654607841974946595838378057266116009972665203879644866323618126736180957855655966147931913435480458123731137327804313019938802647150234465504898425802329413862779668683613033675823844181156078490095600041375150275291651461225843861864920699060926664091188015739697252377702538748247848633488642597506589513095738763427251926880402e50"),
           e_float("4.5508275209874842284775026867107515489803492342081977829684698902080228017513070354957837143529346955244673877628418475193461822666300373354925009938578926386129646833064324885263368623493588920074016088207194832230832008311624067861799823589916739537593658935227574156094038386923977596646660079199484641658168721015803572174346354392163211495967011149940050300257342708865045343497074648806315340279e33"),
           e_float("1.8827925275534296252520792527491356162295534425206692752800732569771809376656028030887546707796770581588012723651208947108266551682126600032226519658823297525283708941083066444831314757827423013656324677180055374738095719451320476140838883629912657066900048548706365547717234804166461637468280918819100188440444660982280003379855304240766312386189378583749135815221874071570946240763973102963484443812e25"),
           e_float("1.7346983899761929606576000169166069874434756875996505754794298798291099203603547306123232408945711099515804665715668231225854942822964850663781865426880125507619535750488161540530710574882400982583306502563888560333905147453106820813509714335388682285386241565258236816810322932804917590791333493337043543417843912874952194578129041707845977721764461775602998354624006198244760428666024161124392454415e20"),
           e_float("7.5721089454213705673990174637978319793995335783953830176413091386042460690126351925536073349270363468770326806913146882989849336096193994547156331743187222706532268050636068082995067049936918417793458417602363342846919918687916215490824796727973846389943435685325180397459441775064277600646967878903888948579962581862291369475872849318112367397199269910448211778306707893229102130233430005707983124844e16"),
           e_float("3.0023684488114833183663047157474048377252636896929194228273087088165353275930632710019252744170288987023415449336738158690000230236236958840730215904781984898825048522208951917006175638928902153889653130105594172874605369791993075785023966085139217113160412138069213954744563712397732009840014909425745334222704981441575923853721534018968493209111811618054507682876592440028064151670981273820202320496e14"),
           e_float("4.7318392511163090620202546053799664576519493271474767200487455311876758729399837892952053228345745017822872702736770605495384272860033477332314477903473862259428589205624585242830634475710926335785631354152156111839724536563041312982055763365615322658103495222446151958188199870588829812768448565406506452941297831361236078835109381098078064262444109262915611391070338142707766329646850799483429949464e12"),
           e_float("1.8723064410446853104584579919302409843976751555013157533394259027266026291437204075545481162175999859192508533205144077327302120014752626249798887896882501810154285004900163061917998647677182240749229993602726823260212232503495663563145737555905801481386432627778702730196879534383150299664721695758738766727985163824006913423439092899094784421757080822116529206150254260000885321391849979681961746208e11"),
           e_float("1.4116108482799563602032042121845234321815261241653145071243288439165042376842392770616866579526649055213708420519875096039520721410417652097158091426603105392357469757454212766784837187808476453167890168468467502159155208028398495042162818016156209554101973869768073459860821262369296537196084094988394676141189386579686270095654869670707180150525614768493154941323777287066134066979293727562728435376e10"),
           e_float("1.7012831324483054038403052516471324240775236002900375249173946857599683358223666005992331260219918779436591567863010568846818083000574807141339104500078296327504994647665104989319265383534768624156088060437286291603315361095013185872819316761033720793034318795077410932031620166684249705771655147879859124952463679366781257556935175901529388011251214814400148246595946176299380239241371235854144946328e9"),
           e_float("2.9153738897265643430317253946206581606414478897332968997660398006170152085964051592274027924359656191597475639273995070379526457037625351140310955186226518202593748784803444511715118431874750489058917735236284495028982874551652520945944293286855819543775021965864130035182208565221457212891607251256937476152790908858475544221614843948539738557424178446375110651067916649227619891043605614271271809638e8"),
           e_float("6.5499493308290529815311803847113042217089469744992634335647605165898133252027144614691628262612975922689128339746279591021095472844572882079500769030562109593019700535775229925394456598182160830447485729880930644056379764352668431136124829566757030209308142853170029938565193099647284292354005297764076030176289394081238284568316933905765846655707388306913954281102851269614736735133160749335560294341e7"),
           e_float("1.8206821580160192663241349901348101095333771060908253853246575523748893431364244849815532595309561954171314890986422263735718602868061211199459957839132315564734818074642027157679934310653203367407004392674612606166949639820891050065220753709387227245515480164472720660553895410548268960476461047738093947844691915563073735477805158900696045317309139705658738985302303979923433211764411716480593788512e7"),
           e_float("6.0008956582321505261690684044890042991520479639050288576852775506618981757215586713042454289021576214656548087256194669628582019923215957654211651872231094365781338413582420439306642746135790696024792651927942925682030781053860987063566730392123716874784658190088548454269200785727326785028056486029658603811347070669061406215582991604226341428747731270005320153409762845016016821648535427627128877735e6"),
           e_float("2.2715869547678153910516570000268583473132896794888889474898628191270218491060269915977331244118472373464760825923869865068872353685257206821238275703893944865366810453148763892008109966508290205246336165585542081487589881303861038670713520235614010616372767006784680659344927032136243673400803759027854862962651518934330072052235992441700074185727011496186421881184091085471252538491921358799100242392e6"),
           e_float("963776.64883235378639997568521549906065664454728199320088273902580517991368732698189468717282352258205938472347054134785451965197671413243882735148447019431968619062202761424073197825357571117612174620982564439933427985266564261243523898297569590240005957873927460766061455876780131741544757423056238015463701905465038362308111130390590308629730022019197482607824419706726658053196808870230659500549166"),
           e_float("449689.09324566743954135523310702375696984276471402780193537547368214562825584928846773963206486073977552772109091205125328169925793866942258147715429119259127031955723677580872177900854420079897318742165225969936196655889364908275848185016805409628956042313181205328497272270977290928597490907649845901665118774952793258933129094265125550963348566341222183262932080994452873194826089550595434740507132"),
           e_float("227314.16455048302754900891588603351970399307974806259287480905398477318395306309180362151174886530116847724064857043685698551943908056010024384109718002796443303888967487642046082890903513019743243120461882037553638061107334149093106319184598679808543817112378263351591673937886224550298910007563123955074045934037261850992970785521127456017323119358532453083714247381310696337619701040364339572901699"),
           e_float("123001.09945097250316063237510747068626728808929641911867530695463311227240310302461634594993770455817431243390315884265588141697186163995898998593026496612491440833508232415989626428483561117404525646784114540569112123740879455568990994716562227178180527860253345757472789748929439441725607099885140875365629577695318293578239753247942419067548364863777838402835856871937465548533224544779099075994334"),
           e_float("70557.208294004127436681910647561731179873162789709630769713331035460699515791853965198679721947234098567454413175742160055567870315336000699819830649802877264616531494310267575099863384428865114687442584812927126803499983912702369591858000025470668968835551313564704751185586553002330747806334914330564111236875468520083257222479313120409401725704864202523595988122528074166661709353658896895765268504"),
           e_float("42566.846733444744401334168699323336696397776274622647442910695974888296300446206958553349128976649890461134988686616404953036047040479608228112335353962306280498431433694695635032841007437031916536208469190035180583680817233918280663198472488736314669579363956508816205357197529450642951502619839872709024229058388900883110533715845634807792961895499202934564764447012560608373935385987363233214659182"),
           e_float("26831.61766741302127355939649607210207903957844615135100490564630541933053515435081408486521386515713666164747978120571193714997098298887349800605165383101813693025790016928332041506554380222470442725914379383820530474716795376234027675674142147824782955632470617216296861425296986284807649849643496913408203223806973459599224342198687090827605650949605856806591091487452731274900678070986915745049075"),
           e_float("17574.786036888189398883797431106713047486585487800722852933996609071081714761083264150896265700946865374285447246888623138606838385100771630774395491873680780614590108139638652226526906933354382842731226088063686648819591530069896292309417020906146312350940509153221983355009371237084701563460978025515989742392851933216289293048127029186026468183590291109096749834076131209722170523318882199802586691"),
           e_float("11907.034041610506952353558147339299275786226245405003567475206614199939771928642185492456249976159853880740683591636710651742428369693578136294159147200500250405669025505872401685526918651671810759445221257759062669275756193671939794375041659254564659757758423080579817098510061540145850217732162998438595779288915142885668738171728453271019660695555769169770128731104995088141674330334454758025102019"),
           e_float("8311.8375566610704474426438444217990377376063761906835739709503611300271065446721530467650841356678900395804571001595868794861989037246572151724644163103379760636674052298902718588764739495897127824317106952174320260827731292052410662962719329924915988382414750258251043120474417858755359736063184198925848623516561125468352246480743011729229215919188095904596100716521430046275009270620419794474692465"),
           e_float("5958.4065818079836790095907605714563188490925170148364795536620159561497837308102452521193849930692485274927559821538650613299190758694812454019037070622022295589463076099895294201319253730174129038611595875610662579361204813899169150639775048261788380631340901869126134670995592318190324964844053714475208761030387973394538324979378942330378751190475694417786173126762904664343749175795337625262137844"),
           e_float("4373.8928478105200448978410016120795961223427705209833115918266513773791087110322905183141304961124051377484493239369481245647858825620519788374884368452102683285449597543264902207423092657314922411083029154120137746570557723487252653153020684182735712177625204162621300449071033980934694708665978440892866841023709737267344223800751898293717526880214845479743694306296821447462248118470813562599581344"),
           e_float("3279.7933297835881346989733197326507333040301163145817997778017967236636054281027418730481478512530530988556520152683630675592816719845661564709154659202798580072768839152868652356108867364610691287703917757792888092025348002289936131056149120863186769837141335059826695982858975279517671460519016281951328561096646848830121885694350119099585197693921046619730837545612847873230474434091323634982402318"),
           e_float("2506.9309433102355533861250777464782554176080454413341510116759239125346755988853701397406458359163524171694926919208398509494390782502018504726643648264896172124469282172578008484494558465104400866024611809892285515250513737512045517715459353863145335008985534264415917717928953206202999843326958641436466188134711967901477252185753887247383054616545860883679202047948829889011731708931422467893579128"),
           e_float("1949.6290441055105866709921680194525295574793941169639395979944917771535011213847240372391477545673196935642515761244421596613730273047650861220039937895055133412287729376093066710691612932348280529573433555286304473843982485966887290794222962140479748906561195945804057830243972596559565843311256684893299085426771147292691116614471429764016633332437093987784718026434852658731984673348418666614397448"),
           e_float("1540.1813858660145533780538270175475781769532861093006605969135945545040661269051403486138643073767167945923821217617962676767849661528500932454490720817716246863055716118338846093876764138806888834212361368098274744260180910160727904649704862670371656267710858401200392022926200096806285475053520225613078154576101492501613599433207929284199154839319835421033642848511913041445593215072996167161230888"),
           e_float("1234.1949125801360485297203688885053384095327079812392462281947842436876723448824587090519759200363329053697394310217796938712121928351681543094533945592773617123233199994313188090816110296691315203825796971729285525382543802013440836616902140087402924047815418899394810274317386760757089034420788701491053905269158425383526771780878938401302487493779178735133297614409019340982744477475543166822327878"),
           e_float("1001.9407108781162786680390916586899096167451088304928700528983514162778884527022487451813137370776830123140523868699340275686195658254228349670565045194408119721850295262532516794219603619263514678530861697512069215005960784272604358513547192923084249999237420514886629404044919175770347615676148743169223704528038568943054334259248767025072777878386394951938257887448031976208681306554637681222607886"),
           e_float("823.12040719471824035438223357544802831636947790949599036324879838852192834097628736380948018384785951737211173391808535000707751893354691055947814495601382737103321548322849189966441066850523876036344001918445441570451107679537923760648865393224576475829600810805495039744573293801192340691704014124427504551841943376208804413053660899657443928811539588064802679173730901696670165871478021246249982679"),
           e_float("683.62529137053860217362812966325705206202931369227544086925712364452356230668873442583177947922615560399095118175976981217112497223688312173913332592200612615226548932333716801051378533220083935117205296061506031990468917914820087466561014577348216435376709526315694377576459375392244043799521295233201171413108501111750830354110092867373718709990657226887448220156004074339379484548453705388339737876"),
           e_float("573.48625855948618167972104006566236320808293118358959933635193313548347976768597744527443031131305769831747830297118257521920890632858250265097151588015536856530971797598838656988463454967701345266773691850691974448488333767317415895437331660879278607170500451649524478108024040532788152290182269451799182617864084322006510242071805500412651852594876699458156286136516764755279341040023196053382498539"),
           e_float("485.5512665389775535325179583696654544236233195615947146989095350297662775788212615853701753640972969758194327110518934864969834846046505194549216118650071679195050509843233684741076341591997151357307572054049441476425630073512588382226073064684893961114471337824380150228912061866412841797866376111653488471132120711681485124034817414395005925475921694052100159086521908265848372054130801721696167361"),
           e_float("414.61644645912831983436583353036220562710900727872009303805448521775651133166664777628270222521153934388195029372305883581654535287388941424659861437440925006716257994285755635499704806133196011754124326891552807493438564604060527629542519450046600300678790032430798319953103062819382436634501822245242376056434307336846986969982880733072402849419463768874261139442462597708609227616460692493028602609"),
           e_float("356.84551819452174373388650632799534598254097310540421889032785947715579346985301756061547266127003218792409666523528712899312152762735804485986384183447393323937686909323717305416502095804483401633193167400587878206744561875811295781813602337941498831070156511167568410780686887901716544912670745594529936594941329682386018171817525618817722707600807951947353035833035961452351801499171222604224357188"),
           e_float("309.37569259117128299164730591922440520832633228065453394380665761409586086131848702529449130799623662134918091682910971269057786042087991470835765608735774095969124477742133666859836891217723817057658701387505931471252606702798960316176295128722666090198566774702281077099820998523726795909990920697816296262166178742901007145547695631610197205826750033597762375666405727165221508625142380864630031549"),
           e_float("270.04620304591578387351363575326924183385824052594994616531467367413669534711986542799392667836341616501569567334653404536628074385486269917454466195430002063679106508740246374040700215631174285798702863992616816828983880523291728409160594335870538394522630465953325472854614294651522513030192177804533393093703267184515323004027293042571097328729884839593341202665673045994070988174872896648521555455"),
           e_float("237.20872478815743831636346126380753870323053971188802259517837928837111744165437048762385200475423822146593352609859768589207263146460577346605364160731104084321787562831697084307439141121829768193422431879373328881419582424006824381393365599923232958807966290775551120444253668082287938732088863124030529156578122029941838758407290893341166544550323313193971241993411724559751763506681866916517904756"),
           e_float("209.59326866837129239939134191144234254221902601886799153507297190917633918612642746483401283796902228396876617548098527709078617920356883947236639300659201429855649606100567709141490013650594251708989476296881997837052169108954901068105335644964368699548546133371662350888123536652848907155626754776475707099778287188876331995544314566706613081970387723290742451787640145149077033529864604398411232436"),
           e_float("186.21216652792155025012998723063800994821370545522859791684417200600888561166139181596641775154742431597170443212348565877277782153725674243703750106578235650042353471058944821498843684399735034614882433813017631402682994704996953810691318500940611813050300520197963002213642967735475296627250242331116277846353215807727634281139301380440426480368130780219987010578203789162759222636507998951219962416"),
           e_float("166.29054581221736193743607965438203813195571540556276041744818124311383319271865949852409919394153269480747033978746513697383455865029515980706280602452728024027534610898785346747528974164787558813496898290405585139128520213258945990094921668799582196289415186077588862993471052286657863660194169256735565478553573021220316686372499566569226517038528306172782567311222185108005570216696875743736100955"),
           e_float("149.21544605264908295993945649604285337624519718826170339522511247882857712759510607335731874460089073845801898704753456500189496779409436861912293899505581311440747659554277440213419288703788269919039921798107728399557167408140809252018994277341920952749500208966138855241759630945526315488793292726128341029587120514966235620401322686088115588166229534061764540653109240550402251054407246856151567603"),
           e_float("134.49820287386678146415934117436307502527253382782756683242558803623204372535001903059952331187383003860763373916209613087224920642323030876914180417744941292915135703827726917716169461155380816523013541525064300018281942902987113774649832405107851262615047816612855045800479352444196097818959938847644895442220287283912353786424242613580468026214975428187030621470220258018349158225338734661141573645"),
           e_float("121.74637525131974272454558722147879927552923813837385989933905483762963091864899955061129604620396949021837430587726614860594389154064816930040727892714378269500043299946051650713998983491638635916031488981108330117519154571017260641823220174679813385602946220171718507847869621796127188906326155016110321274441813386811005811950360701606814779230073167747892140373841375628240185806460112332658735145"),
           e_float("110.64260631711559498322474001762380740584392875352463205238210105939782790743352350606739154257360582368801383831074621861005079817761460800747298574584683644725917439371228693130740547395703988345964898329232057802290530228367477935870094290205403602359935670249458583482201754669750582845724037588283318437124123171016867892208974286334821884053702058111248236666946423058096609647220532373526244413"),
           e_float("100.92856967012972193917518928060009394792622902695496254802502737367893928307826618274300463895480959346808257384295573469247626042710972910372876840374990223706613730516228141137722239487448585719213891921217237096671157284201787401704406207428649666830485021808623886749203942660900675084911238356554714766693423052531262274564405133098865268607784068129787781485947495234719038913303467154832772822"),
           e_float("92.392679392092631563959752527878583887479296807720417672962326048128400138121704639802684043715437101357072800577597755851817223055441821489535301562911297877933157022237713907029135826411587652301428873892926679742731836949998669456021610943483508390451889900759082872123824690046542053242950032787770287618249238118532582560439669526270180671771327309278282286916850429221715222684437784190817824479"),
           e_float("84.860609378284820785602952170404586422751901600748048264200718574664896680769463369795301037001496303080888428105127807347644813861774346012471093453102826317718752593349031354859759488428592181267087792920272435685117389333993857796284285469584645304399609721613159789935446750610229219287306100364883031493944862142278195325002912834514221503748376089201908315590094401759888005719999040741938057036"),
           e_float("78.187926655225531502357307056698206336381909672953827424126837885868693379755515307427693715187210880496027467909426806132171473014313500117188662661329489307483070519798355255538668528254097606014555607058274329718496828129605068283590960438411934868297782290066038418547615727244342706333248727158109476116275839072595818492297328306415117462165830715546191982607886864096419075136831227098153613152"),
           e_float("72.254327754720167168188182676794653687714982834520287425061706420532299129556578626408215860843989786491771900224471331493109577666938392538738575457104756508921406418481911225854570110473144806526512991575828832113401294321981537218681076089232381149949156176429592633893182344552796525628349139139963359529298638766678285554717319033546508400519636984880833305690400105228017471444142224986480309606"),
           e_float("66.959099644962861983615247884155537635896441329822245964933213520028362108865521916429302906026057589955789299568659724663900039988113875459272607689069458228001732098319063938613425365290092436585884680401154231487402044096555072981207949343836600459922673024179380396236210378638196680142123338114059889182685974623673184780180914761771500268412317879093380228779326938138352755469565091007544934089"),
           e_float("62.217522644670735596968642581559054324452597599739953945987530074605423001988767399001820090151218177763128893517483054249876599749526745825894397963338812385300524802292413430811802383698566309447539479480475918162543933998420990704370479351755145920173559633817429822918107659746726422830388842878769473188165006332755636444530618051085055792513106944166318834872535627621428789420200512512457378386"),
           e_float("57.958002796323544067153747882247230483427752445143211131618297968276029647295326864353764736034401208961789320511007462501677157621854408342885131363924760258460572197218317455436950726190182540193523852924811154294608262692412659988915336814611098720645185592344964274307257689860204879041726226824726326090321631946734895674711987528438515969487135495595062789395823305773461774890178642561870915821"),
           e_float("54.11977272794664441109055367356789646308230201123324406484742764523581459557850632823784049922581132816342679242399225185691782814786210581057291410003764266816802284579341063272248119408239619040366870284751144584481658659903400379057088155267351209943761426074855441514019936480154912698301555385167922427568584819463735826773764304493571250532835932344428748170267829010898717889678247451324376332"),
           e_float("50.651038256116152820297966867204708818194805566214319013039506272499240376219560426198783656294689316058527033838057570894560993805422975464910732352265028912116467966839271138600543890372316567452024651987168488946954161872202276471686275262129251118335836973341453687002589948325044214150047047468114431568238577392905085986728622458816279524248359638061504730356478146984683844599393511675371260861"),
           e_float("47.507476524533991201131181366810188851397457980595242110379598830391060946124803548264112952672524490151910031160867592995187524646803934290859662790353903081075198924453946264593543754020259000756035874240423476826674089091386954608838204815184242464102934426813107390284149950390582119057864430626694526742291987748854767386344547494723281640104733109674775268532282890396859269133378663660513970845"),
           e_float("44.651012930085526404984963449215816701801977321360473790193973877637917247914061656918073857003848407253928427732837836386659853936029674229815617050197415093084171693909522698715420197161405911930161537395734143204004535727719984289460800431821865825810419788279023367456607907800171927042071033803672685996566020389713842987254888585337158640123183300754524836615596191568690966393139154116819146712"),
           e_float("42.048820325324062416231902695778944983164413102014584329020168609550828694928737298503376071415383828879336089213634268307875379117957582729584756148367394913016276378925022258921569245874988782015735144713565306585919854231066294091842394588879473360582486087017657681753203321620612760193315633392694655462769843072504968930162512639282065328720685066731032583030148485675931599985257062041450784099"),
           e_float("39.672496349821826081342002031318172039914263893879444691340776916911866133612975623865850840648730252741733294087242224833147279731382402130397038465625110910437054838575476282977729666669037215093548525393409781176940350119246713963105246002846711177371045191247193900853905274459128450306583693290311806930433870153215413871269109383222674431805486617856346306176575567010151638172314677428765541002"),
           e_float("37.497384213361903922967809308734566206247429011468108223041977049629569006840187266939822728560833267607314731657657043308933696389041513749911908553032526904667374462548267318138869332549026104638592845005618750562553875222510572381601709888013925352133552427891561464077657639043555598149844256079962489168111398755505551859466241284073538770681585458570376594628855517123095777650022709489916807628"),
           e_float("35.502009550247993707664991267787047506972134953058820564972161767379674512106740230644519101414992008147473626046861362088133632054096167266755546978311116715400812559779751595340406854737403931278288820294333544062724417465051815055921678965532077662352302625241780314631229906684448965133570762583648547157706633401902511387020295796465942861899015261255752445696450033044008121623805777046196958954"),
           e_float("33.667611616352798469780510002462899717656676346972542258603848840147342176381478286419505320047450120614781519644884618634818170954313362927658937565661032597043061082693793252344889131498255084315923793437993481450279097337021111953982319302732813886216676441052732269236105878837517642579115376257840110346877638435558585861704768715806844260414202148919078812176271061103243717086222235237983729498"),
           e_float("31.977751502622393310575150746580338599479398149438326664845586669711225106679312944750633857800846084650256938490881543884326575921311636503135925492508830355946227162621191388183620954461909446103042309193924549892745995300842248308618770717957243572292970531154740789432290733125608165331001549987282114241818081856596075604660436171025129035223095558429444180625888647729478142072761910768809930843"),
           e_float("30.417983484700835243276414208137507487098667979296864814086181598405665599318555359699410614826475904295513179383806346580773057990491433854639938752774418191922594787204092797604190450269912529954157297777556885216324632281867666797974067543391102295271672493353595739738032868062316579740565123720439165242044844785339193324091428918215535546311799935362530499127301566165063986280744930708092439425"),
           e_float("28.975578339112497548634766957030310402616033869144422042964107908451554601782686907529723671626324807606309381845594014407177717599045429684729928946114903012409436717648224098804205976083901529033854337122228821071267593456207576514903932626610166938038040687757680922277498677898290999339094347966703818924938352438426549994692241536604865991636349220148276765422816377856960855128919117623227719096"),
           e_float("27.639289599010721317809546899467433950121974863564541446395139825639764644818203625653176500362810280488455315911271280084451350621763128060253538885650306447530431188303669496786774314211987248345709967817360926401502701999924402495032476713120183097018283930774040656560460399467881666834127382196942836412441865533611327320353056334086139029745967402313178141712379836006743563724225437873878620635"),
           e_float("26.399155423722331397681052773995550094911763952308199332597014216148523540285694617247297403112834756380797800529655475414308937293177057364803475931821470546503671537679202410124450351783230713423739749901853873888058529205273993884856127985538986301052673282298452135873265480509380555376249373680350184129252801017544528173128218538736877959635056281640554938094970031015323532504589258623288747284"),
           e_float("25.246330113066143899099158071106850141276220852124562226454108307998028802082846025501165401284115935900434148709379332401590874001296578184215243743392131287346767086189886933849513590004365651639153653494121396009179075452545398643032186000425072097315667266237339742847408912919986527005523967771060418697211674919677045672114039888678864632437502085328830276976984000474652018189964131552663111672"),
           e_float("24.17294038406062865238419115252689003211480846288935109820473543888507402900357106324188635528624080887501697290027603955851823470475326301878320290790377424027658046338613710419252209148818778932565731080508209263249725006825380621567205989025121279720538195847577077377443367121483909578040138747770853019078194465094758869168736860331563484574366919733389264228111171645642994260409311956527415523"),
           e_float("23.17196240151774789528728299434491661707861536611377913654339086805250076857411730491562499269017860318235202986149536601847695739923637307096168012856256389731647260239302779192199966172250391554031938412665526400976854477164799963373713967367642022584681076660800393068710630806367738867727798332351884149238140164469677696382770199961990821651710057638793573616284195728078838117045473005002063948"),
           e_float("22.237116259595923627485293851623109503607561490166466052555184053109898644048272297983941596470275339235554641053299625064708882764168594642962640395561244282760688980408441059459825031838676313829459647149438377015033600855352703306885101505013454244380877486583349409872660437154295989023208647868869859822403134538551042386726777551035835918279681337194148792897099236778635091951142230611240033189"),
           e_float("21.362775183258932544622442119768213018205056507476120890348465402324402627053916429255554621174168563964820060830498918624886917672994245466166951556134786973682454819629735081678678965365265568987945820437083568384037520317792879718064018038062337253853402248010710667474927664674276836521079898225511864774600628291731472467710962761597956433966382841305581117030886111390951820839047906457889457952"),
           e_float("20.543887183817315060364243391879067443800617593834060711006874837246545369219352481153772565782078391664652949540506685740788401997948435942098653931677715820537021782234477850107762716780424574348209372443434417717266387050922200739429073388503116499955346965896980101377442018822890736546480914145958303708327178182534342340319511998416054748225522559057986104568720331460089069600024345851636793235"),
           e_float("19.775907282562599163460385670423199388140170252154633982253492756175981618488286154914093680328229180833952415567462054483081308832192386721364129714038622267121115901355857895036732738519070385237176818442322872224669729639025201808359302279241709475044136846661924871193210873234406995973881895678797959114600485344701382051528043884748513065984020274888000892556423147353138713683086866827216065411"),
           e_float("19.054738727696729015834243582916306345360857007108940822303092349861379892193932927813064148102588219408223349417390673124990567697344408887187249207073520980662792343844535456660157313705708822927396158305088755328394596069947322805835501850334916992787453490393151609345980365208579988708438722921938436446552595722044539737899895267721518915828927098225666535169457814590798059403797340438064419624"),
           e_float("18.376681885573621271339019302769148339330953543796878479955346523008222096724247004314252431244818914571180431331582165446925764565905321659517837907390366796752580035737765678303960539272664805830362921935227081115660729191788347125738273398939318062937920442186099967695673476923619838072590771060302394060846239196149782809517660008362110800898200150035179835676145629986604029011098342368488818439"),
           e_float("17.738389698248282678501686424616984421796399699779226575278890892308848898573585838261249733502696467168599015625380779453665162697877258994271766258401790081163445694300762265378956315478999433733570772385537534835705145525342134699601090672159071286614150652740173596368673262162892723674409449086049591717167068158694068146627426441870611539186991903817945789872444292134654054603887588316681984792"),
           e_float("17.136828773880708229588025958926122158112789767892558476050365642331944158578310391722010641029187796530253310938029194013378268699433903965594780338015836548668070617917581951515032164686771175358517702696031470507872495864180462559017526994164237674004873465660536982720267591432613773132210079265402790325424426975919411513696087378251479304794438763722593800716060280284849994177444170307439644395"),
           e_float("16.569245321399633986405453306135634969524881750263188221867542440585962581459151089336718204121525460308707976940994305578487840670027368507319855560863293853454220998578926460515706176569907946975826823110127018669131317932888086822837909043144878244834194962841022836100299395156547362606460387326012672204694871647011754192976947834224903465620595479940673848155072856398777315718149945838732958959"),
           e_float("16.033135261404722647483574076377878899982680844416304263027546493752838214896889122861423032427646895323197065689234145651208438915767549088708521998913994023557704918230357128501693457105097376615521876364050410659512103099403270879747764076522175248980402311235670287233310563248594286455051971383498791202527983922477380679316075152714747688064024056881488977363625065057855011191126147886226313933"),
           e_float("15.526217945936246307078739129246544165949938066023385598556904942074142558037877605745435741006232761493231604531349126074567110482971431709019118481882291014075285077434545128898468852740995506271254267345275360820518888772237525892619188229025407148559332988067796469668063918018481018057447913358596938114895427184054293992489328419268190009382918761156506660779862925241297073740951886950913343751"),
           e_float("15.046413003996725231334673013406474686963450589454917920615619910985989826000580445303169476362423955122278188467309971871134716497366720005353643765771830252569107183539378378207417802624797664244844920627317063861121357477171437692074387679986097545765483950411891762779895202674827821385429749786113792368385285080348445293384576109985637760592028589528217942303137214432051869775252059172346718005"),
           e_float("14.591819900432291786420944121309663502863329762390949679053672319070298491796691597267090301924988100202161894157250385779240848348067711525576318142354943364797903838198418009178820732763207511700777118493736336347733310501859895200837219599244181450334414655717085690771984811605359585505401150222152561192256175036275440957626562564152882463888381011994583286449332803709621957718137194601273650072"),
           e_float("14.160699855303489302565233693758668482507570568296324010992999875373298948084888095802044785140601016499987880937662956345523248124621284412949993109829973138682345028351450621648340689711306999399799700299132207541620658781858703429156197557062402204746582041775244325345369715787249767210742842310369926557963385718612481572309373749390113060130069040305626480075355039511881447178841927865138095714"),
           e_float("13.7514598210989711314495908585993837296273024692350166565400319739852694824183639785803776563566102589342019906051835261730912736207366482158635845041888710587100005082090810441511374715781230476705410367141393223134117777125685094332559742616413450933748611345120162788591041884232049428307456628405496503442502259820034350172065914200708220401567919192168011441060515904174652607471072623912032254"),
           e_float("13.362638257629831819282920977069981825861150053543610541684987494611722409170726332656953071912152750872248346974420276918691753631462607047378496488391117673172313830373154735702430142048715034646637000251534603416842614908208568681595211741550385038075679448162353501497496277518856564127832952596151892722045946562802252591235798679311241860426916009019332559475708439916890079295536891547098798807"),
           e_float("12.992892480467333454049301393459444184725589591622644522306340229021664885230541225579782416748773116972995914126050340534912941940419145358283191714043844893817153533736300365399721702429730690860374266844213621885695362035727034358068839437679388866500928976265961335794969251054393917044035822080341256905187003304571121988695958012649796532674445101682635294920228283476387814077474808714206753229"),
           e_float("12.640987389407094919074470087486104588996037581883095189431484433289843849736405963255538961337037559676307171552578329055083844391958257752460175893041294449696818669850194602992976022682345933878508263029805232559625675574611371859211062438147185037391970448614957916780245813866941502507420372646747050928798565484166369758420293052344686907522683076336697842689643857229140920404920913059421535885"),
           e_float("12.305785409529338337667526365853347154740197857513913441680461064120415179090024353911329648545054303353093420318740387165571113459301418838605912704460319286339164994527196144928472687184614009833334514551186774985806312269311267218980210746917129775101056269280772103332209641826455634844613420296495095481479748960335336489994246490166865460020505722370544196936557032171438837274587258028770430979"),
           e_float("11.986237499698793988984677071386091283607228570471824801031846002387129144984568238359845978123098733103330623822919272152100383564759133910160373955276470184208611969578519680588040383857375356082190690184338588374526677067620034069309503636377728973567679560846999763479081465884115084776839752817398638263103350924867139951978152074576243445518682397541701085570289748652273914825822912705677291242"),
           e_float("11.681375102408199724430122178566319138403037228965687481654395912336865582559114356771117719242618159778855077714933161905062557474438174958607956045155911178127553200385788309409683711103200234642942927705352987123894814059744153492721836292197768025407979048889769381793800247945219153988432958083656834413151575315292613217395159032551360911748987770895016118926378308034643236205080811422021798725"),
           e_float("11.390302925214463279709082431241089598252007579490176213576260548473676479556576022622823307114194714452466563604047823626936413953853142367884174833212838400863522119564202530033540341791477782542921337033929822511347464851008410704041482431943452713439793518943783367611153461496114082305697315920804923761153720351501778006549495974224839295719131504415867981579430449206306913345422606944825017723"),
           e_float("11.112192458062426736253446782414101236645749413302605209117679186178146084154264905524978728818813613751121584906871163080562604293264007331409986910495962991668941968113299206223512986279088113679342859839511759751810964707070862009522216985648801647613207385888462250270158542154191266493838556663053215714890293638122894265706684923021464832304882970702830390696389028262165163911451302220227790342"),
           e_float("10.846276142885692142805042052608310895389098441810288087410473218588112114782674072693331614323167640330566497691650692267844448353722931602864990954679676695362979827008884019966602820842001345909437228770733519817484311864274698137236114610406534783861285754812222708181478532447708124621970132183539040165775376124371901232456918693007263915109974971992032715827406275356816008736258697889647698045"),
           e_float("10.591842122308825296094049503334908287095247848120739375888070933296218427952086920409051766523736575564999213713729097807129534856793245449295281173312150140429138797764690716754590551022838392364487179885237103334167407945280453007652656006259584830921416781408639000946534295520640457037008163814258765334722026177836995696474139525183636089095387150893425987650174790428202315980937078345789130474"),
           e_float("10.348229503295563761299987137492108519545277386163041290247822628759176571163254460733262164072565059241737055263386737314025751364549213107179825223336229496667605256716806296774501524653900938000650964079070893797741284755687778508998431465156509759575497709677711814055787823221648920438771036717993818081417421464807930880988000797550005485644054625577919633072148699413287173992889297084023024527"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00106_rootn(const bool b_write_output)
    {
      return TestCase_case_00106_rootn().execute(b_write_output);
    }
  }
}
