
// Automatically generated file
#include <functions/functions.h>
#include <test/real/test_case_real.h>

namespace test
{
  namespace real
  {
    class TestCase_case_00051_factorial : public TestCaseReal
    {
    public:
      TestCase_case_00051_factorial() { }
      virtual ~TestCase_case_00051_factorial() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_00051_factorial");
        return str;
      }
      virtual void e_float_test(std::vector<e_float>& data) const
      {
        data.resize(101u);
        for(UINT32 k = static_cast<UINT32>(0u); k < static_cast<UINT32>(data.size()); k++)
        {
          data[static_cast<std::size_t>(k)] = ef::factorial(10u * k);
        }
      }
      virtual const std::vector<e_float>& control_data(void) const
      {
        static const std::tr1::array<e_float, 101u> a =
        {{
           e_float("1."),
           e_float("3.6288e6"),
           e_float("2.43290200817664e18"),
           e_float("2.6525285981219105863630848e32"),
           e_float("8.15915283247897734345611269596115894272e47"),
           e_float("3.0414093201713378043612608166064768844377641568960512e64"),
           e_float("8.3209871127413901442763411832233643807541726063612459524492776964096e81"),
           e_float("1.197857166996989179607278372168909873645893814254642585755536286462800958278984531968e100"),
           e_float("7.156945704626380229481153372318653216558465734236575257710944505822703925548014884266894486728081408e118"),
           e_float("1.485715964481761497309522733620825737885569961284688766942216863704985393094065876545992131370884059645617234469978112e138"),
           e_float("9.3326215443944152681699238856266700490715968264381621468592963895217599993229915608941463976156518286253697920827223758251185210916864e157"),
           e_float("1.58824554152274294042537031270907728717244102344735632075817483184445671629481830309599601315176785204792436726381799902085211486234222668767576239112192e178"),
           e_float("6.68950291344912705758811805409037258675274633313802981029567135230163355724496298936687416527198498130815763789321409055253440858940812185989848111438965000596496052125696e198"),
           e_float("6.4668554892204736725073043955364852531553594478280496089759523229447819611855261655127070472292684529256839692403980271491207400740421058447377477994593100296357809917746129838031509651456e219"),
           e_float("1.346201247571752460587607385894161555835585114819396719005139146805746036709053569679792094662968183668086909704195898370226404837090287111401357994137076640037432774170113989560487154525481078806098932137984e241"),
           e_float("5.713383956445854590478932865261054003189553578601126418254837583317982912484539839312657448867531114537710787874685420416266625019868450446635594919592206657494259209573577892932535729044496247240541679072211844543712226967552e262"),
           e_float("4.71472363599206132240694321176194377951192623045460204976904578317542573467421580346978030238114995699562728104819596262106947389303901748942909887857509625114880781313585012959529941660203611234871833992565791817698209861793313332044734813700096e284"),
           e_float("7.2574156153079989673967282111292631147169916812964513765435777989005618434017061578523507492426174595114909912378385207766660225654427530253289007732075109024004302800582956039666125996582571043985582942575689663134396122625710949468067112055688804571933402126614528e306"),
           e_float("2.008960624991342996569513368984668389175403407988677779404353351600448609533959809411801381120973097356315941010373996096710321321863314952736095985319667309729456535588198064750643538568581574450408092095603584633196446648911142564300178241417967538181923386423026933278187319860396032e329"),
           e_float("9.68032267525524915612334651461533120541816126046287336075085991994410462342522820764047067493354016942468236052599198291616159698344959404552555370425360228744319778327465695705654633878300134043409479509755322962027305744027229877317936593591410512862942634895874863822608410681848432800485117416175566848e351"),
           e_float("7.8865786736479050355236321393218506229513597768717326329474253324435944996340334292030428401198462390417721213891963883025764279024263710506192662495282993111346285727076331723739698894392244562145166424025403329186413122742829485327752424240757390324032125740557956866022603190417032406235170085879617892222278962370389737472e374"),
           e_float("1.05823620292236563784274284243348353057589905787169019562352737522144487532400210147849369011714673954768265316577892528273760626189481169051055226066650741189573897273684791411180134039439160066561895838501000817711682625725670477616267598661259194975646029749546282594356217374097544153589482020891750774735012558313460846824864172030239122128896e398"),
           e_float("2.28386033591464145739726586511533372704297307154622870177363471612602769260302484587777654979192110294570655819607477957500955052322419704995617697230205658766722616606097632340497755473254301355713314682574755379945084952337706589453102105527251633427846687561490492136580783384585342855715518008495788482264298986700329455138599299386217835234902726469669185449361408e421"),
           e_float("7.7585873046867252018131742988927814424139521309955333653039645243449444126413897396031520006445159574088140023194920323212342505069680284555944456899723133743053010193409497892911899721494504050251596241558271523296765804409594286158028936381465581632354831421365407836878119979276153468596584172058329541259158619833071772325875958215127234296986277805302558741676020777553565928248049664e444"),
           e_float("4.0678853636470581204935759214868853101720512591828271460697559690814869189255851040091007297283485229238208902458700986591471560519057325631473815990984592447524630276881157053717046282863266212384565433072676086125451683377796691387594517603959682174236179543307370341645964969639868177222522210597680808524899409956055791719996669160040429652938967998005980799852641951195066815776220562150448516182e468"),
           e_float("3.2328562609091077323208145520243684709948437176737806667479424271128237475551112094888179153710281994509285073531894329267309317128089908227910302790712819216765272401892647332180411862610068329253651336789390895699357135301750405131787600772479330654023390061648255522488194365725860573992226412548329822048491377217766506412768588071531289787776729519139908443774787025891729732551502832417873206582e492"),
           e_float("3.830195860836169235117497985604491875279556752309096960191300817480651475135399533485285838275429773913773383359294010103333339344249624060099745511339849626153802980398232848965472622820196848860832049579523313702327662760125732592551956622024712475139889122106940319324041688318583612166708334763727216738353107304842707002261430265483385206376839110078156900663427220806900528365808580136352143714e516"),
           e_float("6.6621141046691026594410219757361346277694489302798629336532186305519480035110878325654158284486782802739787536172111053304795032153913950512859414116769528074686592856396963031940163564261029052932460928744747616459128566956442406652459826044851913275808949842616405128554842438413843358493626951236150357509357068783245747378584895128610922190298993737266945556429151868323319322932721629219691088377e540"),
           e_float("1.6772277799452185316008559642481690996154162653443224216229144166533010495138176552175779628900866154937655467080893509725117402094786797430449965992591855047863335070498197537053948882096262565780315504934744482331080425680552490971597062111349307447058139219943834846427081475234675780303186241495364354473220247981334182737896146496569057168205263172422932268545207065230644665792052186286503978375e565"),
           e_float("6.0316116183878209766117976235613285674586630483425933084029202472047670485819885245164731849642810548475941525840095286214179522721593990128930118982329294365767928511440729849320802184711774330495375545958604447485894133813040753046757845833254416671760299033093062086252031499964109155039154660288221882477747977319966161835146771580496981591719779344293705580123767115637822100135690925946157620356e589"),
           e_float("3.0605751221644063603537046129726862938858880417357699941677674125947653317671686746551529142247757334993914788870172636886426390775900315422684292790697455984122547693027195460400801221577625217685425596535690350678872526432189626429936520457644883038890975394348962543605322598077652127082243763944912012867867536830571229368194364995646049816645022771650018517654646934011222603472972406633325858351e614"),
           e_float("2.166323073961557382463235264778187954767951899579521884911749141815166917768056633646824067318712225871550633171925355564906025115638044857878569891843414846307413324707511313247266239236774741772624822915918442537622628917260707314565701879241499870498583771093167297022939238794527693358867266016175252639871156716646566862026946552693688226163413890167864080356863316871962066199873051047909315137e639"),
           e_float("2.1161033472192524829557170410776298658794639108376130676557783015578090330844472167861788371083170940722591241807108382859295872641348645166391260040395583908986502774347856154314632614857393087562331369896964916313777278292965202780626304839725254323083321245935920345445760469315716688808181386083935737705284353395869520861742156127496385090743602309049820934917134755461873012945704938955132724663e664"),
           e_float("2.8240846225838710865601065535098442135823061554844791712597381906120408795341067513167173456488587183699485758424051605240860430734116506705261823551533559258491538012488850144424176471527010285806240484110526907253071690361234188056781083955225765449360114949222604307544628677076900025355074672950342497308281617049371682730704925445700543334270975125277956188775073181736313034579696036350067170104e689"),
           e_float("5.1008644721037110809301932839272933630344671982885376039468582437981130708498852292131363729546498990203510117610597788061337889364935774345003616834151889824724013463388848611414227407131388805908338112936942713654312102013237233708574388954023204119295061839695988633829528183893692358325009116412814178085996438696887269886990263126005411391824906115932394760450675523753157387123915179975205016239e714"),
           e_float("1.2358740582654887501439519976654645722453207394691951587942933023009303535749131421693458329501117844594155210943276153244976776189223704344494221396409009166949054566125511133453306982545560785278983645158512290209964997730422679487484060181101776413758486813750497539732592588254177711770661949023836340925458999407933462689319460801688898694968499433345902936521455578486235393910256726674571284682e740"),
           e_float("3.9831669221188106782059903365647184342241206056641437011836087681419052507877828777197836786790614849623650815370930359235012970451643257831407447009876949575323891584008581164429335764558987537599253484560326086502781503271101808348167605963030972865236052804284294361064452529813599103779308187748551124524743322498734122591361323687319174150539832960422913966914391504332796003064686903067076824896e765"),
           e_float("1.6942137841497677149803436030075057517988498526656202856719083857397583414630442712845769099105564573438389636920762959736205385299249859151725329116045506052492512753306483929155304307254424410170096221327709589011102167266208376408632680159577693793831169490854321854848497343874643632330529579330285233123963371425930720889073797302452831533903673636109094054896196268725563178356915428332141796856e791"),
           e_float("9.4393168351665886793554228175829937281475850403264861536294867440001070424512734225968904784336560504559134730512884707573002822595788279111896522659296183926703477685657760564561788800392693083412398664314990780985234900785061901304079852525256361351937861988290906418153623632161178883769938621502531415986813192533198006266430114951917984661048592587828555685832339613792777097590401865022734476038e816"),
           e_float("6.8401217773822066239061896487020494763148132747702853506611179202824743590161456302595815813557640070957506241223099480621161478659715395889446969132612296899088116302049059705574128294081129244511376907422518614811902283222676389594083409538167168473690144166571294947309191744813932033971026219566770513534166536533055752328274776270569216310894640502449534064526417380810191996248929231724797537688e842"),
           e_float("6.403452284662389526234797031950300585070258302600295945868444594280239716918683143627847864746326467629435057503585681084829816288351743522896198864680299793734165415083816242646194235230704624432501511444867089066277391491811733195599644070954967134529047702032243491121079759328079510154537266725162787789000934976376571032635033153396534986838683133935202437378815778679150631185870261827016981974e868"),
           e_float("7.6950918588667633662634386556689644984871950792350070913747905777950041895932540644009028242721648765009379053940741552827255513576622685582156113545461753231364849919773857857052381801253820138506309028542446019961148177839185279600110511009358448318518025293137705450607335573389962709276378814084031328892146259205941035217998575436585792511310143770111437627499248635309480207239685907153937095329e894"),
           e_float("1.1798323952931782591485877784439827674239081636296676897992109695508842313511693478047667995005102940503883496965320847293740875333842040193228929611788194646981212635330126853352730042947893826524773244654270017013262301459114663160296447143717488238611280042148060817707142773745446328801800090633253108676114668145595621756094143401774174785802909812926615867007680755447883602420534368994391860099e921"),
           e_float("2.294652936781292116271730560991890688493520741404433340920090228689996425176193757286874683441604744705791219417005577535027240790821826889284723914882392201525501706334274804618418250919490941979442888013577941566013670907024572195515146947950413830149024975779440770362364889298137709827424764586374640142721449771088523730425178927996603810907767773453718741175285937669394045150222945855792299229e947"),
           e_float("5.6299448635663384211410188122316651841036248999122041309595746313692050999137594530505862585076461215223021983008336995777832707201314930846052067516257405228873705655160977518966047397236764107270500174639536046132430305499860256769856967603324233062680461494847143129164004203088468524557842011599069239234358828964614952717114638314523227959953631175758992769027159282689926311161722079132465458085e973"),
           e_float("1.7333687331126326593447131461045793996778112652090510155692075095553330016834367506046750882904387106145811284518424097858618583806301650208347296181351667570171918700422280962237272230663528084038062312369342674135036610101508838220494970929739011636793766165023730853896403901590836144149594432684204513784716402303182604094683993315061302563918385303341510606761462420205820006936352095967417183192e1000"),
           e_float("6.6632855430628135680954352951708640385498155531230324480728891395876824424437944307202536884083669691480313711377230781961568195061940405487599854501783542049183403260603350413785883172041616866901871669314236504316128923474016774276612136718793302402295451834802243062613095056087352608542865267572700441649999568192520480726968406619104227676356137980213293834333581964841629200236134962403614168507e1026"),
           e_float("3.1827505434030270123367061567829135361457330168936413441263627651440268169501764834337084988179382322408036236266717998276089499520772226449599644798963929098918702154574264517091463699176364376913963557047353473751863559554867466924195160823347808447432481786906286789030752824205821445601705774036433670118861483165514127987919823727196124062917518895073539766873447964527482373313833577228813744211e1053"),
           e_float("1.8803061994017742522309094612021230852562035603803293131485640229757622125071436634210139305813969502178382179366990366443181140825530092831194306545091151371135589467822485364756990104255312373802603886183703625853691465286638197325393984118342724105884666127375352820666080947071975897665043221857799683426911229564033711129072556234814419472894065438647034758516263030364616202874906458565150290538e1080"),
           e_float("1.3678702847856840267729917378620749034376250253831391017360844697134069180472475941057047908150291482939899278053726184692980498686468432309573369390452428690089243751395176492320165428162161447325476334649280017783927134164396533098887851834536649805211446897767424173551757043161633830820832885417090043231030788434879490107917048039070180158540854926630787328160593946568046882840235481182073937378e1107"),
           e_float("1.2201368259911100687012387854230469262535743428031928421924135883858453731538819976054964475022032818630136164771482035841633787220781772004807852051593292854779075719393306037729608590862704291745478824249127263443056701732707694610628023104526442188787894657547771498634943677810376442740338273653974713864778784954384895955375379904232410612713269843277457155463099772027810145610811883737095310164e1134"),
           e_float("1.3290766393761486986618784848740233274187601882199098620743925940067004082323081822839751446075030017904241197981187108048518594899326879482026400182735213634368573570691512768355587220122055460631279138494334348436448156068647555540628153745167098142494373258761191262787081059932730967086649002361644314735201381570812059566862615466216704143602628553610676124660316728016083175530605192476521402875e1161"),
           e_float("1.7610403417821111561460117109879578542911478279626825158356419020266350135316290492507452894055179921749200005291146070085155438850638417965728154324846728407158333741072487686882930286404967263861328009051100613515481700246220249838510289801823172689568139770942545337507101048688685272896705812596362498604753026067474836458847095056257533018986923327002140429816632192746245464828742608012561527824e1188"),
           e_float("2.8276889451180688404069331749473537087028619704607286430202820774127111338611703385246622293347212278677268235002015265099991997053306122138632331388230593401146230785544905092856613368741029303642248786039938406884579004686304554018094198854195718825453268720279151908236730972819147016998077829275755343167497733526524347571353438258174932160268291144745329067097323813970955104297149235174973396863e1215"),
           e_float("5.4823140670823195089602024548824085342976952564918559820409967769788357279154881709056835932509769719953194572871723382018875445174658418707185995679901241244985812191750246282714136230779328158875326593388173397572844237953895643903527927554547845319870719193317865923317106271234337487730631177673438105397872039035095263109403861520488642086176257856936852152100782657418436237356624476510424764641e1242"),
           e_float("1.2789431970371636606966620734791313516604437860464878229575155395257656153529144509770146781023755836666984342522223668276487104935057419157191303316572641730844442916621884079259664744503530060106462229406709913795896382483051752421457376925139375918554742142277084109072075415472744773895909513758702137196402197602987575610953689410300363603347469264966415853466714416517106192691686307844235819017e1270"),
           e_float("3.5779464182863193446023936590126501250708882394147338254286613910039652390804588748564243039049292563772898742555569021663858871347448419208794788785069890505960509870304745484158208895769504084658282911667045794019878293893080053697689930267837124911057480489073051004943198559575800853855757336478383911387330479481027965215316885151132774024212533761102767874392278247855946883616631150154012011935e1297"),
           e_float("1.1964757582667999252131509716061119850305662190076833994840099123766158727034181038947821335345309069925415445432071961454875091186263490869668682030500437930624779710348867904342138322132459484149833269028204408518702722361765923095184280949459792149405670968527026388787443575354770916708426292662033327413877051484114622712309517575730444877209319437327949030120708996578766485751275667245135757155e1325"),
           e_float("4.7676360194261430014675104919353730444095235391747191526549794124205739709234849156951289416039376950432948916541553077325203601593290066774437521463840177496720975209054238119531000283781749531787456087894594953293601024269602330603546865850959063634946731227370896406287482151404488969905389064895931171232820498217732687247620283775363019958734030133495169407372077490429676714043054288165032624037e1352"),
           e_float("2.2569390298234942299814033608633333267114767898214891133295432503616488985155418388632023474987945611421864815635870268864859053388211576460365445324180204446025721315141395048282282745004769849831439005038762801944174103877101980371639331896578273267052082186785505226992141523156260429328111666968664757431281986985272905942437877808006499658059942552773415002057914699888572665502981708989041793219e1380"),
           e_float("1.2655723162254307425418678245150829297671403862274660768187828858528140823147351237817802795619571074765208532598060224803240903782164769430795025578054271906283387643826088448124626488332623608376164081221171179439885840257818732919037889603719186743943363062139593784473922231852782547619771723889252476871186000174697934549112845662596182308280390615184691924446215552586523740084932807259056238962e1408"),
           e_float("8.3826160990316653882862988443391267190206704514369366239959262845808616271019302063844780283986411640516049649319606454251565946173459983677527230372847467574319899062060444464682132812526971645908888073731400794646098061235405731639210841114991372956370937804083319861037348765631387426181517619369367855867851715139135878078975885036384253099126541511411609027176159775699281765939102326857676736962e1435"),
           e_float("6.5405287759404082839796769112162319469748057995713927282569708844722217991462478537684391088080180298847870502173383871019062273624700235505448733484109288478286522573052248483817980340259958821502322771030087405157580097459176989657076458237216558730315068396328396913038213593832660758638843596778545713147378010146113745851041627769906006259100740696476178419998613238313473071379665214902873763962e1463"),
           e_float("5.9957043839244381599018111443659072152319591783902705404606803305259697949097402039461604114755896574508016179003200872801715128672158203442693763489877074532108397099182859650735121434471993116526092775973089236993137878241456366190222370996700817500625538474536310849168443621933853354736640784592394109505795005261518500099286408891039917114215227290311182063672032854980222429867341821268200250751e1491"),
           e_float("6.4409718565200018055131800965981532721782172857809350501197690249179126493865567364359901759424828815083117320871816463020106140978012140712246136492458377710508516955614515870499288921594586346123434331807801705332376438583499830732112050850081772212333495548954853961346428711348679625478228038619242902556432022520662136294311646067063179388639341640855877438120216959063800708753411615928938573254e1519"),
           e_float("8.0885536793881448790173309686591401920529333829767826953404205796787238274159610290295795694965822494681824457313664611672938772472085191711929989188267498833056309171857004540914029745350734551893232892780606680389375776054260971291095830300504823787614546385136927138253022105327461688130330214538654023022904438977861323013211694629499328346375588192828906121769406597293635186489792056580390068905e1547"),
           e_float("1.1845574776103298668108996611464848941298114758752849955839899515943785936771277621868784031678851459697654158282068706909975320139600711043510969878851972867066637303859577102038629568864882113293677344271316754018351837011502130166812019953728371406583077111886117124196679437327967894798492878091517527904897031301318471314068480796311216464897234263828412545873076852790938835071294503481398081099e1576"),
           e_float("2.0183491060019763788800607386207983259144505893244096791161214917548293524525377059826805087921688433345200814318394823168697265850536692893548719001841016602629506215064288513312650615958441400762338302723605854391749637247065039691646466920350433169660638224172690149162000249910137779225739192551076429669090433355063627035467832870307842107201865715311074911999714290061563990844629425628855809255e1604"),
           e_float("3.9921840844355408853383212201990434314678845252568736340188545811286614665092139678957118194169153652256313263278997483951852426824687572995647634935765284201263435347521301111472739811169949230313621617192704694734091619076799755945434117622788430033574519518522266305690539245917836969739588104949360051971047957963435626324835584772411153747949512534471174724974764976153086606179126677031298742775e1632"),
           e_float("9.1463333557104838838672215246427549750087477396334744546711063371914565851935596921647346198157624427118693528005625493296350262948940542076926282738460604883503287215522042261617376446095275739863037463948294907676288128954882472584389153845147511990492540659111218200288982965327157293979429103096957766036927255618792661845683968415628008783737307277867800286997953491724415531185030789561152563598e1660"),
           e_float("2.422040124750272179867875093812352218590983385729207299450679664929938160215647420444519051666484819249321456671497049842327525093874817343838393757631459228450828499972271274140160311057830558463636337124079332447820739281101037112665387537180790257577919273108262916904750405235055060084012219492892375635136296622020023178109619818046179906897450420548912610870589088056503913584562211037693288783e1689"),
           e_float("7.3980203447224978807121404344491999585061171902164333035701898547759213584415790590665220556815512528497875560160322943975021929902571120663615922799695253704956317743345569295156212998914811127813197617716855313121248608990878184242027072168158319973962813227630328863068809858256048259083123858125879001187255494908653037626051677956023773725396792399876351646121040098292270471327717008834027225309e1717"),
           e_float("2.6012189435657951002049032270810436111915218750169457857275418378508356311569473822406785779581304570826199205758922472595366415651620520158737919845877408325291052446903888118841237643411919510455053466586162432719401971139098455367272785370993456298555867193697740700037004307837589974206767840169672078462806292290321071616698672605489884455142571939854994489395944960640451323621402659861930732494e1746"),
           e_float("1.0507926825048197528363587319990612687670456488047396621179593464860765742321485133003589251390022681402065971207334118415614743214925432991919644428075781244027981141689266396021312910078375089367290474335290787975811667634937258346999731413302084840179334053144189068479836665684778367474399513886026057436556849845979165637858418541415968875918527604190088995092044899947462903907256504812057378617e1775"),
           e_float("4.8675530514654859402814171375320923550705064309933587102958846537802405993833680314178867767168997961087792692962381597005903900460848747568176692666485715613987773547071005949921950302498899703528111271213273906516435965885003158421406060162762647932748062955355636910109564085959295800261834485435462457405600577503501427220155806332873414928710105312195483614567978398138277081339418487630044728659e1803"),
           e_float("2.5808034888851509959233216448446275633987313846543957343030778319741629924302715595417766278237798812178633024170420589569662386351213606007331239964290321498120867731433271817915314197805096691294904466728565450938289350574260732042113813248931597523102481045500756116902726146751201676821952094953552354624585458748830030158718383177130698323011770200854184058804986801626236753094205045967918995946e1832"),
           e_float("1.5633932669581298633929322162542533813347386373960141575132734734492349675200920147549614945198771934640279436983962739665178517959822451164946926531122922528510089310366500543976021115401620321522201720287847149112982146772183832406816334901289283249283307898270097915193020853091140582697571159209655688612574531184626882685711208681774764127224708505034976647942333750293370478435503139678433200869e1861"),
           e_float("1.0801637929071119739026842520721128479176158837890689980957843771414921546448452370934204394173470009654887204119520380920627549247785761056713078045667384023118516577445644331177384326473101472099888613297165842697903793998969505016165369186503903478576388462500007755049204730564171951753881856268689235793003346984858590895706546254008880937981002787495219492423173581145633288211601135974316069298e1890"),
           e_float("8.4972392897964072098249533940415832032901226147549483885937628906393387016759749166779390912108512193770727396731176148684817099219862241070518329897737419790700834153338358789804054247254662503406001643932256413944181262536626134781963753899870200241216683120301369375204827350328695627459108294334206019027913654171970749305552969884823232609436511764040695691647958710090181422374514248844937618455e1918"),
           e_float("7.5981997634092450194330119110404106514679873250205652953516519108726693027429848669319619072459992433853371989586706563303914622785309276124965343515114384346336366037180741876769231703282762131093912098438259403102301028152979772816093672761018579653371990569407324738683491431721011322977390742916335187516459264408833665120582505291973060065902138453466463767485592665656379805084354482165868440444e1947"),
           e_float("7.7105301133538600414463939777502836059555640181601023916341099403397085182709306936709076979553903309264786122423067744465978515263974540148018465317490976250447063827425912017330970170261087509291881684698584215059362371860386164206307883411723409851372526504540252305657565886062123887041264021962997102468682662471338366096312704819557227970771168835262025986914099490128789574729041072249610615195e1976"),
           e_float("8.8656804587967779433619846106232660654596838207503103738865198813411371106068998076210739016190706950353328733153852607170309774497560631177837307000827197649856269110668607598439101017920714466104826886158864825795148499046742370510244849775664626110798445873301575564152322363261020169947441890731137729267161124044275373454898884387857937992418046039131432636348268665244591674658445269936551190895e2005"),
           e_float("1.1532535229665107474635688916429171810843808886873680239124624106340700998423537482114208063655145415768538794655719329183070881587725524624339491128673864119889997508057513104647615773284154926997614329375157748992784073300328685882824361905445081600196074547497804216289335603119963133037532172851195926221323594361042386450004729698002187082064626481742282550760028615510453794427646135872788171108e2035"),
           e_float("1.6946080950273457183444835406966804165550715902354876543052597293543510239355545570029672100584703054355838387076524485865372712699600170443840100181246081527240591422863011784737811976656058443499687040402488852297171064748475921043396921980909425482680020315282816160276676671201153454578844076386465987133721729277333348622886171381803016178591940671798599841643909004247320916784315433527237653681e2064"),
           e_float("2.8087181146742502039227684727111870467827295347439941966992743213630862187821847608789708328827145946617268540116169472616264306113457109073336638890294624791409628698386918347406512091031450612524423544060906434422625294166739500645622101042251106308362504396243487846395822364359656905456010183888733476785985893375904758553707144025111719679888427556656452546555424048656314917015645139205908297378e2093"),
           e_float("5.2434751522060149269696758009111366494594006149283971551118518704361064639661011262327769680210270052405196789850366740433480742081853431690138814839247096312393098508601663171386622962201449494651694232294447165511801941404582111464552094033017415943152746288180465697972482714766701591182776216378597637016012582764527433363037287892386862534832329869493630145056976279925089778568129223896723943726e2122"),
           e_float("1.1010191564854388007930455240681198187559188702388956535952134307444003098191878109499411075546642356894447821766757073219457963373009603967326192408683670983465309561114654245240271034197073297893522752972197628163968343706840722488868460977327739899312102344821191344832906135954618976038059750851144960292440904382504598250923001507135323631431971052665383349173640002213585660956333602535798006503e2152"),
           e_float("2.5968190111934037858618813593014828907106279244193050296111349584699159538232390214281652859265804298129950705045539216876420230337179812191943310708307639456362968331374962493937500401690295860609460925139594768920237867157882587713392610794153505814785627583292407214446089359267492355974251261020445763775377683693770017870929080652335885691967004747090605907643472212500744517033499018381900961313e2181"),
           e_float("6.8703650568568003698056399130482768919022606819116551587330958237153165376156083835788756547301496085106107905238714519925897277894017352501754287967430525282345399190059543746814435200500688112961295169975094902663620628257472084017811634151703899860951772430744838464738013327376136008401911350509172096143765814904247982698297319693368456338087727661288360848199657988476270639109899512338448583787e2210"),
           e_float("2.0363040351179084699873194754033082824110396277765402964278399999807251418312114829141516273143940679864522186532781074994340992730425431568164921648104551317277228666999757305501127166972448864104125718626177188719590472606560634377077182110922274387488575191032784459291684131780673855461581766365126667095247338393416730441896754513040093600580658748112967502598389135013120458090247061817702193472e2240"),
           e_float("6.7526802209645841583879061361800814224269427869589384312198268703685091643180416969132446952698303794226010370578672908593198347699886928591906501031587651846976759681112609524787093848004428636186893395272784450630354080243217646658024696659065951793757223520229235577548653833681102170973893746054649126415909143150172860721156685810655759230011450132992176454983227538696340112610447029002337004888e2269"),
           e_float("2.5022971491776594488705990054646785118846462686726221664364774234373195063810259596067759452488639193058003739344012295253349838731140406548346566384229644817789112859996359809161273835372293271365226265316479202714731587029026581794053181912664424106721725470177440631191161022014842313257273037101181582471024170444105747792437358053472940067254951097568768093649504846862244524026153033397414442523e2299"),
           e_float("1.0349062101922404990829182916756412911972788499117769572250963715038226297462309706234749187106172295051847660908809339928170607860373539658715904374589498666841548933492718011979376320594015450183928434109808011781836435308231472399495350372281976736764160727348353192173223874822656894011592697146852159717517196573413921573043678938953826660131141525019843559311299612030801125834257414170544274408e2329"),
           e_float("4.7713833294969032666897275133756877054962445837773210823797137051648428926804331353911068081915030721693890621597870264801212492233264221841477821316337728708319519334092886216586265829212330500732965271617102829342966348146383572563086532348705375314214429305473440733364855825936109887798604396031365727302705256699265207891048037075795106880532146770323244773367182459402829858473804688893812219547e2358"),
           e_float("2.4494115247874388286900912225574375371097996154542016829634110161710440875118268120392121477493822203768033205508124878259576451738057282905742883656038185558117888582834558546895693074110134826969660821248215590610008506894763063317907641249169182165396229490380765626456696218309217990117679791999424650078259034339341085112327848894343449162820637782605167423175107459395266816321673278293202913757e2388"),
           e_float("1.3984825417829356438040766915604808899159984401558172891844243614710885548319454267696277935644221824170551061646873289688003378380150920919024267080625857545757587618406291011480222020886167919124890534828668453684926893626803486537962054835553738545924562180706946917055257403967987059408686467248242842070931516111095761107205484443293177102161106478779918962264224915218508285955404048580220759497e2418"),
           e_float("8.8704232123729413349621085789494963768577373616440183605980982300520793595650371093743148413781442710279703073851842375919194681786404376151252936336159828557978357115122976890751778458814920607607709100129067224950658069769330706119917868990165146272329876327004374490961063241068122468445757829179291044474909354577886195130959778560979674956846697972611984424044566149235072431374557421398064554104e2447"),
           e_float("6.2437844808488742164427620115537153381313331451377895691704330795401355313228681182602530481129163355744521659423539913724433939379524322442706398387692278409257974412438043949849465863271635684881126558539038292848480526493016938183011539303738647810901217176080228999001960632078055284884507376130462505282871307585376554743296547728176334003837755046675017359350375070743286749125390109398246055941e2477"),
           e_float("4.8719387003591740981522332673501306263991793421471480149218334668341222166758818411718974437715714098770196944313980727236921858962073787304381813042695098733670149328915895389798772110683197267436823633461935547328813482190044367668006197055076383039575559503198514214988658453416681232106745477095342590598381433163294586605180117682225052651945311104491579973431713445521343095785903818172694611411e2507"),
           e_float("4.2096855399485171675594104233606177313832041734974792174406433068784916529065885005818331753952729597724434688407751526357100094005644356194672448594342274049756054411079049010773759769651419262698931327440295073514562964999503763144306712239489999947374367560130705251413549558377734203626650255493181046446253530223478116235669795401821164433551014738253832588582208194711386993687833320470663111889e2537"),
           e_float("4.0238726007709377354370243392300398571937486421071463254379991042993851239862902059204420848696940480047998861019719605863166687299480855890132382966994459099742450408707375991882362772718873251977950595099527612087497546249704360141827809464649629105639388743788648733711918104582578364784997701247663288983595573543251318532395846307555740911426241747434934755342864657661166779739666882029120737914e2567"),
        }};
        static const std::vector<e_float> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_00051_factorial(const bool b_write_output)
    {
      return TestCase_case_00051_factorial().execute(b_write_output);
    }
  }
}
