
// Automatically generated file
#include <functions/functions.h>
#include <test/imag/test_case_imag.h>

namespace test
{
  namespace imag
  {
    class TestCase_case_02122_z_cosh : public TestCaseImag
    {
    public:
      TestCase_case_02122_z_cosh() { }
      virtual ~TestCase_case_02122_z_cosh() { }
    private:
      virtual const std::string& name(void) const
      {
        static const std::string str("TestCase_case_02122_z_cosh");
        return str;
      }
      virtual void e_float_test(std::vector<ef_complex>& data) const
      {
        data.resize(51u);
        for(INT32 k = static_cast<INT32>(0); k < static_cast<INT32>(data.size()); k++)
        {
          const e_float x = ef::euler_gamma() + k;
          const e_float y = ef::catalan() + static_cast<INT32>(2 * k);
          data[static_cast<std::size_t>(k)] = efz::cosh(ef_complex(x * x, y * y));
        }
      }
      virtual const std::vector<ef_complex>& control_data(void) const
      {
        static const std::tr1::array<ef_complex, 51u> a =
        {{
           ef_complex(e_float("0.70564502928470724256172567179226588307754848413645067086014508755882997558051608710751800551546296792548172221795800913316958388119713567835546996386699146652565313112062115365176066350136330340627099076030495325488710060922257310542444618551372384335822894918926433387228579349703657810309493196079408082180206807389986483699438229978540094196806271691486606863545262514592026134620691301281648325222"), e_float("0.25248608766862036686658549749190714501135368919230963817994966023291595963105865375657096779755802365016921068469216088220724985663110106736731567227250109379391273388383628143497456845049961062035128410342644016508120138306378557217391762422947805744051311664953007396317011656953239047519009320801807934758968660941012835519158726955323493966961108748958555955158962562470392453774649614862373826173")),
           ef_complex(e_float("-3.6606593680695993122474670135539096056998059988486013532868788702640448250287017319833267338967541264402002925993166155186266182735532024447174332704921134352682774468151273518377299368778338026732436859478505962315074813529365295191707005289728437441498708653491067656761685723081537115446722745119218057522701801663030321435060623499995197950629959475619041266200989752403993350969931996111938424426"), e_float("4.7604180218331175030740794791144641400834980542645504040951718337526738166046235070199616310282363462939453120813456481929811617631876065024303831226650036980560199617550065083615789504373074613995868512318191237001365797413983455678602731206232913496181115739967564178557228292154974133551853048958621336053072666325994635408818830141078605959297715342431581081997276508336698124352522198693845998416")),
           ef_complex(e_float("217.95168703551570455858650582430403173747076045198641210003756893782855938910737819993179626673280719372086076971019326213979580753871347733519601650557852596083317452774118757602083151945746519722910644126928003560758747113969041160391380770501451279293709684368037254429898794057647339035844986095222604503141982792221065433087285828118957460544255017196051053034285345184768547347598696401357011977"), e_float("-315.33782105798293429624440853571805541678198545335921315327989606032354804200562917980062794745267686830892971276653416683832450543970868951403751898921296163540196387601337477676718807007985035740294818359055527546544591306144858241774844620743568219846517729951271067947260352842592491037968432382614948263951971417154215808190602045831431946068179730995671213506254203415953521442970974216070907645")),
           ef_complex(e_float("-137250.83104936010683648560527663975049275928994316280908329583088474608947369268948487978384294542147502852951509999609467348429070706528561986215638770830354451312819481820821020435374681456642807769283834208249711391643412386654184092796723087154259714949553977731569941694750676000828384577828291444653761158033745592192392105002114374108836764068882632186674850043711598980944395324593114491914048"), e_float("-117183.39947745979103083375325469573599524321342628427766759001759184715327905830048766426939041543190578738952652510946391528625847630744951176347775814665793139210008576866147631076394318081402417762244340407590466694844178902702069924613380557931545379768397024960684233300648213148139378078322581856004101079983802885390007654390147270124160234831139727442113966792510799620315551625836973267943471")),
           ef_complex(e_float("-3.6282300779413504894967104206602363358464584631480315451377136444186092340235360406115478331072119911042578410468802319857627314726667980507484679505057672641818603976250769129699552822901361117526835486825252379226460792186230155418900384177342746827453363721192943321498220234397329558932804988500349106986809199415923666484170565721264320397408496254191974481523211545947072049606585226332112801529e8"), e_float("-5.1235838389979256889905575930561892667880143744896800207025754303845344092462698764392417983488406810880615429718121727900691310549789172875973390599120802390323648544069029410710128349761708276654741221208575567465699597096683115122147245529192322940612187085174537545251036839320391713977359008388036262403722502703039971369593530149459094523990811274574238253557556235797861734349583825577686183017e8")),
           ef_complex(e_float("1.5741025448048176154268192296379728021484052752360272108823831800283223158437999536333309296011155699000331344638195225513952079340955823976824363337941610374187032421275897014515000973790352767343087124690662697096392715444439783432742251107456476515641670211962824916010243141319964081153049231507960014353501959448584662900470982181702310809614207557568704955820241642924346798491629427523866861468e13"), e_float("-3.5566433598824478001484028598030031086771678409788822274170710764376303144190311675692164402429853660891776646689668536789181470335371065924902626349492866447077813286694670643963088995428784861113603408363389397455850478358965685985519319835180544914881358415537597977251987692880087077603737787256117653821813769898376731600267988248497077839152833828904624073558907923631388503450113731440168308e12")),
           ef_complex(e_float("-2.9116771566553267439669777308588279506475158823201342022023669841918545140649582428008006610148357676713228298263585459590693258872620152937317891793250733256159718654704739195723333106587093137086366285761224108832497638405775767706332265844190020450058474520387157975861701466718791748255470902487013030106084052218552299387873023259947799143506725651351344165132376985687935406855877581252587442311e18"), e_float("-9.576549012440550742382608546401823126174529240718445351954312679288724274072993527292263695129635455481038612992944292070645708525458151690565656041592073121590481535210140127157706991305378685855696858167669743109787338741100318527487630136276288266830228315460948797138116462094992386049936595358540511326472972059768293976125537698622030344602423791529025858147359493874931290420778407333823656254e17")),
           ef_complex(e_float("-3.6284313975960059246920762395862284618540978839413896714213488105014755951714626223601954331154020751743569894059748410722744182168309345900066910413410397607552450970782209851777587521853242911218557998012725575963079183095818095204382079711929107006309395021859103549386878494938940438357054761937409008621857722658020184512504017325927932099901867839045994725377801649724370893968270553814313869933e24"), e_float("2.3106312870487930891709074629988515403633082299935602224886586622935236981785963804516651497706722210684186379380745991205287856305313279887527171554532037554589507026803665189994902247470702512776750623023324478195620207944208970206019926170175216542046821851584343508198916505007306435406935912203376969506292114379862236859744222781739620104205181718796892512355481205946084655734635478636167790308e24")),
           ef_complex(e_float("-4.3051969648280170921617027132509027960140854192465433374142255001674303492951964597627598912582236184564797395899598479635454649888860287675643914756345753343634113568249817059938996072060257184856206878958247632863666686505550578413945653331047881302452819670787589070499791329735011788747489941006280583358580837544907015181545273955653693479559638958438686751808328796653168584373912394649277893454e31"), e_float("-1.1681728030412053626213725796394082606981293595430093040021337809493188863756835493254981683278051570331896574179602396837438067594852315558178027287533524342110264092294333226347604735333134418531794087619122391328096684371771453548535049749206854180522468275832652205460549158040005692547995566538290576290788270037436832508373618699305802296358180457224206134761205380813679169332690149107243423946e31")),
           ef_complex(e_float("3.23611719715671023346786466364832344575335843821220371506486599776414032488016482913644985882268432428740803737921054764475652165654132454004873392314681052348427020327739417378605782301160150298464650338743966184005797029781634555705151126102796823419397741472975049726505600109888089753877137853525564714029345444500391903021248880862787652149525221314252530584320220477383357239535044729321435862e39"), e_float("-1.1005312766933813274328504148481609162062374085120882509246142472128808172694654558209388782382354226213881099500335114283526427892404197758209057582386973522307281371815160971303191291954768277920049269844959632599340096410803847936616397043916566953735174825671852768831643853068321040136270185641567541022381384959933671120043389212751335318271147833366424295435080348062586910121754399161676229264e39")),
           ef_complex(e_float("-1.3535461209542691090184488205458044108334911668976694422367285942844560654431564179202157119414816424990657107941442339928818141153747951821886164917975688740626188797590228381197400785074087076712971403196720620259157472015574237645163703073150500533251762930258197885115552306964069717596744310598975541618704063345589998759123987890650508284340659949861755907830978732843724209765070058988228744351e48"), e_float("-1.3832129975788872199276197105195130802643897891219796458425569147951932493586604304179033084830523464513563107568685356690464059947758318051928201935056030325235935202543542454389495125058976917404922651518846087428494939847221845539398912867748223179867566497158269668528622814838488972197325772665415084439247345132660910454559054652294197859981444983895593638405122142660844336188406105929533299754e48")),
           ef_complex(e_float("-7.1226713342649731029277141519032971715749256094246818681298222129239977841913596722910812967203609479278551685219509699914078949374204994626156899154977553871064514577019642044854133879364385814271104180231744970419573519371591397762657094481512933141407141853271298632011654488305502080290048143837353971363249973966488683026794438777821578286935526774182778481134666093986437554637834493436942950111e57"), e_float("-3.8496719226025009408131493037718349872478727963904698852238527444287365520565273057548560872617387952958581815160320610587444951780925067356024708243582194456070407060726127963667228405327412568087391941653283207521245017165371803325032315283417121171312133916058000534788254115065549965457448888579173581259579993666272308208251098649144467698284257958662187685558985037793136721578293014674048145598e57")),
           ef_complex(e_float("8.365295283044161449873346682117397689799132028714938309147413749195318040276620013162784505821972226366507147770544148631115287090585218563724383682100976430560728010117812899323965531851032865143534192554179357394026451034469303153302879349709447937103141433220065486338036855934583096956964784471783189349460896199939153412787132431131905283728740842687348657017270067031089909210490554295592396784e67"), e_float("-2.358888483845774041102642208592162481309299347407757660398505635561652926865805911463458940095533281721511477180130479354170362567776807228068889723337809281830140957205809587132524180312530045219367375764760685966718211569631165565624354055323062031402872656228430764156055104516356339150161890376988832393864769181067303793566656283590688694880709037948060936820199748813147183476347040569147938797e68")),
           ef_complex(e_float("-1.8638396106761196029682513593593684732884104791848368842982910605052523237737987576250085393318704480843540517745791426791418564752124321825055925642802203317881580794852622270541817606596433376240080880670104404750579317336812181539829348276821348783655457169082563923280489793851930610362237401381808341769821707515406875673762327853006065155812618572264186846009168062490917369215873959952585757539e79"), e_float("5.4044729099781079108793237928230050599141717006901249666083152403693298273087396128648988644509969668549408838570377914886483527137345564813861791121204588898251479776369093447829588703448507556445548651856229070682032516376804232547722730754407413637506264122174567168601324251045273836998567120756707359440432778987967073009422740785121841430573398006980832933869870265105414719594232304271489807596e79")),
           ef_complex(e_float("8.6050295533749666236157192710611107233084977965115811339602337355125335054357106595583173469690401996531002017823125075903700752275325495539474947634295235832663489435236843041239541443834599213370832127581498615205120145363333322256251102520272915065147203094329684460689870469318533495766992485531769186422367487186732261803236102086580446877989374822580279890098759018164766820086755476787728511825e91"), e_float("4.3647888913193229515617890139421109684998488653384224447212925734249252017357738668906581731586275883735068047993745612696443317237058401227289566910643040873292478251307730831303552406710687269353554326857317253699385840889730377423793999359514803971363725003403980866383739918471994926051343879953236686425305469800236299411198982912888619089445257554099976088528384824430305622425869149987371334761e91")),
           ef_complex(e_float("8.781708521423674383767097834962096767557890409935045596921390190917596976395918638717546325951734383313827957580329189542618598112369584167141527291524262686558504221183452255953148362528892295766954605951151649213252777653645871363466304744012368732396693782680302485902376204999878634787199355685500729981683286924804273730389070071401654899177812514029683529638182000630153670181597743756224346639e104"), e_float("8.2264297733923574368808588912132833541802959180211839842526020870975599296122722333636500041909203491961422487372681500183965394520742318719697806155128635403637791298991261189820339640456668741947012627701045098129382709868028752353655412332809333603639811314106184207717652656138928133417912831529142278161784862319652136920011689168848156531281667249034111833986404863932270046119761973517782178057e104")),
           ef_complex(e_float("-1.02612536162384743188402967625921028869820391743946907019205610696209925670556690180183343982253538927439358998457027664302937317996509212736021860629601188059427970819146133278416076932154080657593743739238617208437007375500768417115946260815483787886718240641034743274798541669344198684459879051441608269603463964821007166691138779624067658569230032242258115525074933286918304675264664437231154235596e119"), e_float("4.2020478311587451454658519689807226179055654188779013643574711927325153305171471141395131901119238207762672616088390713251109337672903177988432098595307098193530100043542678875045881965940699634849827906257309316790965882031570606929734182627632493980114109996110297813588944461432636864040353724987703877812989925651238390607167207678920158806070867386435106119494290225773315210867178411763984977169e118")),
           ef_complex(e_float("7.4187799840449939387324917370406211533826962503945679756913595442097369421831628221868074411218669589117765010547243549703775530493632026685886934451967602989337366529039314432888763930453929844077623864851843511162669985554053765528561020181248353416430920465037984582101325616914415633393091770176841697493868957793798215101234218658953316340695580617123501577721974406446600103849060865640672063876e133"), e_float("1.401436135480725796671069162408956028753909378087009973094232550355625564447631784152453737787086261021921230618203991244734892527378352805855257419496647408163548734790120083465782865728562451945866618382956023483635941274780833698903939190482626684718097375888258890188751450929456618728135047682332894074896925184680011701116896820922810573639730057408150945086065889349603376416263759653204959709e133")),
           ef_complex(e_float("2.9945246919254280396016832519830856586590428156894868587547580059651512439924471044734417547715750173465599276903627590874103499907355854933009664145536873035749220106220575407003338316712090713487117091496234607185945385084972869790393538545181273735528849296893355456340097408673153310691318220483870915548909455546671082672016062603494783033238750251456102779687907199944228846500426831219847925111e149"), e_float("-2.337028098365200763915361658111680734561620088859536601023771289155128955575311780599073494622705748754661714630950113746701664488933968826710124417567596376187843848142200456378798579262453401488665925067887008121881878319368725126820772586853271368750023944628748554858784217012883189212674619242642579465530334706176870723760409106923544234846438441583707574992088263788084395054061000315042200219e149")),
           ef_complex(e_float("1.38264397661925330284992157739896839985170944307587788725543486268310018556578396606770814667639334768288245876523390767703058765598784685885472956806686524851820990085498734297843740473739011757920912843819460724697086004727909320922191255647312251441284816342301749501061449839201221337210155716559791076668236489804085877490563640549248370918565991946218351823231172449386659410749412086147364252897e166"), e_float("2.8707530960571396400299476302465483642405208067905713207103275312646630892016480587201342752725952691156887972257742443870490893136202840414864162593183867917255023851167583401095250530977133579732626893790943935090503351250163347178079063225611833030176272030803125319355687626103788598078040042156135265063529623314415060032357842931421872340124074107963779021038783806675588907525497493228859904481e165")),
           ef_complex(e_float("-3.6403263014076246281022400254523316620364362592135005370712247108613864096760284489110427484919607092585696925605261514056194031303758174212236327915672017580131300456692302536348986809625710610888552264766349418654429734202198987638426196534585069755123657559133199393279870055799713646167253201512923762937200112970584193112480500074948529160424989946243918003950667958207713243865304402353352799587e183"), e_float("1.3397403290941228833833403731499275831591901529840353716590762952206148907546257604349664617557298458181560089641350874484155337730110575845059810928095501404333371067232749570376959918247601111811171566495510811759298894244371285976093245479648234469411970846851074544754649270837446403172449524376822570979357375917908419621397781570639061499532784093629942993069238020928459814105064663208844252905e183")),
           ef_complex(e_float("5.4468453814747859717787911497395452945761901090884834745202622618767137526170949513113444336579172121449738243401659103913587213340257202086377264753861204387035989712346458927711141345619000666598019436048407944160839071492354839579057436136526577433220587145529778307346982185426231477867049152378929012367997216319790465165572175575740292664497067677626912787439421171829358260186132288697383987189e201"), e_float("5.6852160505943758316056341265697395366984255665899495416486039282062217455993054167916487407812796436052608187805280385196386619815064439765453330938212650153823078225420025683577356790118688787290722802084472219068927028799513901892516909718771870054160857197254872120855895014179224770152275727640238853735142498703287795161147720098619607861607115763859814913934721642232248042764208309721495621145e201")),
           ef_complex(e_float("1.0119043377078488392567112268897334801599239936221099977778975245904146936883032694190537304268819204630760116731743755025709500842066845668971430992719475577729665616875291413346849982020018314351981645105327582596164129955280966046784796970740257276691368466988233582086782015503404025411280197528496313906064992305919384497507038986600580136176569200081832509696633052422176121219328255921289090394e221"), e_float("6.0860525870886998209108259540776833768930752425705644489274056849488306590798080436606046769185320676261591407117323502149904221109988467134930495386158278197857996763615179815867239414541890571565177299019805315463079376717264711379783692633296323292831937819961614250468130024620055151991739972325212652274277615544017073545566951902888298333443411236053789145774083751089532086420577540002731911381e220")),
           ef_complex(e_float("-5.3618398601169415947201997569446292511165072610447941740125453833110330005584781488924845029458478411154474993262895389790422523657614527370231741768502621106466526406838875496917785419171616042553860197065651195296519766277132189798876230000029449839303248576041752335815154888896332016818432586570084399594611249542387468551322264399414342720601589432432297042499905623313460230206333455980225410449e240"), e_float("1.19368879092269777667356451342343844437343822699351140039381689886805096573950223545968660628216707537317939017607749510263869591248006106456447490975752823171832245682863600865663900024883283978550141720107804713190799017148519657710518990262966103446594804066709835720300212113342762162967064995004599314357826039781256627745462347812170175561424631977167225664207892690526212486649951242739742576338e241")),
           ef_complex(e_float("4.6500219459348045899412153323819461894045722987359390469091481235401324454717102283795749665383456803229820846014875879600004662432108501763114159116080760814067057274368135714087768348883985370162211898647993306657433748015048369673818957151444368965400683092220158593343293167694265782647683865567067351231603156305434246593347182287524281076571946029588795137939468471164288023150006688303283644011e261"), e_float("-9.6537621997368329859293736340275730719200127268032007029866746682967693206617460034762811929404954720206391818448771377693316973229940592514024972133039325453037088938551469901657948147630233947201002119935742632922137747096058709319651107406271270938352976258646648755725305364348785690315824990252492946323788323771438327293964509717400866282849369048229187605285837872432358474640109145005447012009e261")),
           ef_complex(e_float("-5.2705504358370908554350172318697216863205313689602541078095424470313844139622109896415730525027737852782297094466287439085230881156202476280087285764977942239748085665887703963660810801589062686720750447955322806427401850676587963729400022029524076315153001825821333691713791857521077495146830492737351176033686391706154574968812509935854236858507916191942410283124293286881699682885364200831222801475e283"), e_float("-3.7755439078922160603413704610071954181648015720685801066598836247898232200296138428251806146578842381706348444518965122452055304263229301209471258687499251547783234400709919778244085886372156465104617363239681999349496029121626067837554655843359799966231096034475676096752676834926763750624810307880704811273069836873447120765908448192465394920859630882432775309322657180446605886395197834177788008017e283")),
           ef_complex(e_float("-1.7086799193516830844127925329641464255574810375026063728907624783613793583596511986312785200743000273321032693592129433877912474868457658551535863894213132741521977809663469524837770899789659943545560765599471697912448547302515428935416882432857529983965036601745022947983444793832243117260536425875397334464891988944583946262538137877281987292777155500714481384399658336023545856790026303509047665699e306"), e_float("-2.3413547411656698849070050307633774669766973017279596557777296925266639427562755442117677950970445405799055121550641124081870624154502022665696923084692550581303711539617073235919443435705837871935905592616307870104330052986360652949754212192628032088447371244556660884726267116068412181711724494607037756075215834654176089827323809221371097650091587808532276695306205635496179245355004604239672270694e306")),
           ef_complex(e_float("9.4441404215062877633661142426419447711417367407139925136003311342981207978694895253502224703420479194690939101177112530792221757071020799919628123570657001138709338528616361588569503676405421667401368630138212631707262940266544350093788004337136420114287786566313834391542492273198385340112487877262753233649791342615872778731215092737811136596445675424278198238205147159831021201949785724743632977257e329"), e_float("-1.579087014118544858061608326114484973624804958464600207025576730717122129326176856015329125389734860866601637104008263193968768381534402352932216967285242066344746637237149229061608705972273839937300620463992400602171915745827836254893697175229933958557172971585363969310453049457605805117327288340537918085614423493450814076264283106856386450964742114301029459798612295153676524892265413792177469639e329")),
           ef_complex(e_float("-2.1095335709917411710689571329152187103252066018344571311523406151884999470015389560076801985744772408288341297473071674197824743174765270917758336776695186326505391660516700182455631984237359722227502075867695318653798340757525762993356700876505597587981845626517828944443571336866763711815813883063773350177202755640993458028552926268200700762032407136735367563192276439727761752353765151702900257557e354"), e_float("-1.0063375648883879098307908214523141095659396400631700459172390298567632848608134976644622880874469195210310673746767860302407827635421577005982441694649055736808915978151740129617744577548400181885951444903146907543680520210962514986036839254361959770451288532974785595528644402772021197019518295167969763744424273051467623657411336999869822400391890078387395935632375683424562667838877339912331790504e354")),
           ef_complex(e_float("-3.9320122854793900741587661145186649399843684105172487060055176017048560876922331060781506495586832326544401757832546696309826701063837018365157838481053975241672754678251549523734766068269088621044283616635705524353230459417920488505287876901955476858858872128538977484248728401508528773074058597824734467562855206229046861945573917414333893794834885901846493998576924586757673790460103772559090112357e379"), e_float("1.5200200118710733112735546927828442863479293319012540317354811088866877115946742367782567848472147884642709077915857072915673201248304120151605426923735372780695624870757997131688249011719152043915494769149912344007783625090902933400727216801523508748849733616674074351900382945509347009400336956439917776001975411214468107288641662468891215103586431565624254191201377782215328340807350019003954395892e379")),
           ef_complex(e_float("-4.8361774423087682404253838118046013423723119871553040021266323121959020356445629377413995075548998359754747570054832186906720448103683816930730666363954621583269070107501557338865729282797782609269232693045500463399441693284454896670970422998805127842136425136400018820286184292648710982022185799224221266734402159690242322627172576825319445583301218132846541177737192850963291278865704475326660848522e405"), e_float("-2.8592564257359270278810717148693571348602947941023696553720097701977056619332286066793821965469072382849695665191817614381193831170472497762136292098223181574091641256257135371365612379518129251868791049653479447009162600912100150107148842447615564046888348556584835784886455110702805790250736624268281355560686589276667174827520397237497787894651807689858305401362872601295510675669139962189316467892e405")),
           ef_complex(e_float("5.532113852813902943234075277642352705609930846785429834202618316655056323172897014158766924646478994173402308594990978354269298743687147322855847028081713823504293157794205286848995910612717311806470456282774930327186662994840621316210306973750579979618160346883433862657172770328792050956739607748363649824062946567095126616526992750233643734145580504211078177211379075864667809584188074849390417363e432"), e_float("6.62951825900330329111066258724975404885880678686757153969464191993852240844193413149113513946125314189164948372439696186153685036795993310302911403576070803701247187718711885291830849452140285391351805821385906147696241402467105611057065648938440803745604461111051894258067776034144527152706545183645888122120491014159619083983072965322365961285665065639870395721460663780488594787668736281678552778e430")),
           ef_complex(e_float("-1.4330312705186836643504718328945078301295854022306354165344574737547444709357234446030524620544518798764456318634679866058782048901457735666297221621784473599841444786489587303876085786431997723973832666879219244677409981782820231489896643606180230671639852254301723212439900825629850330058834566786309937688521084421212266229933672891550395080088605160776040042352387260487293705026097586882516315802e460"), e_float("-3.761969324576549134206300711445278921107388874705442997458572119945399117110300181963403148209885058545137318074029012313658274705313912013902126347295056341319803592724945627067666211598721672769596815562694562765029057593224797716805539538506838454476522547659972459527537043981969133905887159603685377085894330689043876166580580278623629691139447717383578670662181098174274528782234872355125705343e460")),
           ef_complex(e_float("-1.211163478220948833634129372031962927368678318043594281619985681099352954757499568475251684326162928395649976110321160571304632534223424278126689214360830634852663105587245010806987686640612016661178846583962589997428719390138928959592011838352956639597617870890000284532632094868795618395502563104540423640384996903201838482896174599862635536542943966568613282304712570715174758504419958199669426393e489"), e_float("-1.7938263941136071199255565945591078765609211534678445593461721137840071706058410764178056398714002831842204572033920027425620903733469193205817001395257643030224643027156741526914437990387409323826055464104229071729939951078784227420219248211317140189851200019101710074467793235816518168419350099063479126792583455855250815087999880556489640499872525909084006893255083779533777311478313384604012609351e489")),
           ef_complex(e_float("6.6981547670062215106154722855653294804841887620584091586215731200901243017536309597498861689848508325556250361163989169677060976913250664917295391734917663100685664278684665650674167312181394536723894297840580593254803393701958352462598561029629425553879809901409369239101300500194742250146277221346144305143671005263067229786073531038320846824550493289692229206060181572340151442200163943237398947626e518"), e_float("-5.3919721389496443570049656220264509642435682637618193955029029380888395042743260562761498586148942007162368495676471214043965108951964286761503408127795372610611135097556001286182677824977869344577618142741913534108382153644115612622047469926093156240957360839858051988389244363591208664624812747127181738903519612438763691275971738172161676952286315545683841811794487735952749724437611505082940637252e518")),
           ef_complex(e_float("-2.0607079370079310742582755232513228928021625291467388850034585246390614359769422517513912787275712521431482679423397439481018829623606424089119917941944462369850128938237874379554356041266008401474631262208170668651598427959740653140620422889950408872313852333187215576426485094934390321588320081930405276767314403457720256380194039165909477117259068409625497673346145478417604404799219675606664547593e549"), e_float("1.4577048532278847881334014274464883013510043844172755090088215732026676192785954196607320506646661905736630723593235054782826498249457452384015808314420719200381400671679710263446442663663049365146283482439415874858822029917081207008973444465690466457415007207943558184750841110006627415122642343636148569329794535009277348257691884794153899611275761493102047970136313608047637536616928974092600766228e549")),
           ef_complex(e_float("2.169992173541827565180852188253933198438600890291049753630954998084682230541965586300297561637354041513327868134472415765096028278035376892318291905799892204065798408227786980298885683484948683150184381632255215519398619288950134186343684448793433561746497029470678706484527075746719708895354740326868766893460379158846479562265776686551795337530740745654258157518721445168682527531013715427819553218e580"), e_float("5.0266790832362996163734172487377946405865993071361682893268387250726873792217457412587874284662386233717630504814801597790015843699834758298895032873834815724078437081473311551986127834685927392595093881112056941806545510696319305170534030844274214394095562354699608412431331370305654951164917940700644617558241480655804828493589393913555926699943015723237989196508811729089670478901503871328839206587e580")),
           ef_complex(e_float("4.681438382236954627739770813650935500310870332350008416922297239682787604080595673177828281526945192726730965002703410858960140313129856570093645987462581809360791933475557549918768750161780504994115639929359702173439670331433231706591635398237813976939963558254771170068315104701527853619191238525633003752293785546006933387866667822451297682819710457483208642236094514402511384215380554111614424396e611"), e_float("8.7625584765876157608518719982374837756036310093065669869879558723752961942199112821361357672577140944666353568863074979407712278416868039256744596622408226974711957803261905352937479911175692821630237685818953634139733058658748843233718218015401165976249177576259576254416957364212585197870717893397843238524268993846460969200666089105845487681478786732276647548262930723265260525615151774252094433347e612")),
           ef_complex(e_float("-9.3718783920656422273023345254604889533280804282668566517546510954770155758182641919326073152750398795737447456517649099030234390368955700451164846983563763976132030305128156039759883021893476770690562526568568511282079844784589163643004729674366761029314652270192423594975777706081506909279042263729310861852105980859638247352894376480166285114682222831289125040037798148393395017649362264212825153522e645"), e_float("-4.4901628807010350128639121663836982174463133267495104641917614390752616308025390637760028235562547399202812634178101748468644641986922372071093429298637114209876016375492745806583826110076636266902991775817897346348195482821278023083343166382591333436569387340736824856786105243615106886147659009669027417206763106952945513403515580637889432506267616727584499769463098977699701829427115459115059736755e645")),
           ef_complex(e_float("4.1815762397159392864085295248783856410903438048480569222207678730124566548390647634807709366635915346117159491399004276256153429215087124052729158091007339481088427504401141773329216746623517672987350152135252585432678506740228079157707919668374900410305594589756204828789800820328916506720645770235285313465267765683537457490056545132606315798818334815300652139976176397622720566141173405664667541301e679"), e_float("8.0751826843660307013836296256429628792829524373699264571687931656660822469055176388271592787214800793240947367068203140745829411008107993927471826325937680655216063137436047595449887577022224029030485413864314535225369441897852763544651380650193312334147451627940448866034652490478746119442043734371193053783869046599678921081807719264545586007033916135844262359097486210822467744792676159852672712297e679")),
           ef_complex(e_float("5.5916150357915938904793464378876482807801012747528086938374659102006549744198039782237429450137246961188035815989824472328851404604084199994574062792357420983409817188036627756823235047425666376667219485965591298050817692910622869861554819969594925741911196554450487790002583151147638834483805758586330693423717833349907203865065037518916917276089732711402076622678126734884631016689634257393532168508e714"), e_float("1.8183015498171211643957148649014784760558423911782461520037982707536459639432931690872527645582234813114254169956492209270425960582039013709261487907388792567406703286633745465778975337664043718504099559663330569417698990219219400659717501228847805648364785687467906970550565902394765632311261759982349934838108351807681047305192673549591867380488400826627563986949978033641610883886585154487376438555e714")),
           ef_complex(e_float("8.788005749706022872771921751415725147464133564353584163371991754751913116008639308438635398092044858827369554167218344708119824400254201791806736310189684598895852189980521191268966879014835050225687459996424499639355993744511100257054837613205371845566083361546181060369493587700380925100779469592014676178631253660117897693231662988269264914227623721801274679082347306868566849815169928140742026066e749"), e_float("2.6681918025474536158958864079065134673268023038165923745044949935178321519255499389746822445884664228320235592488098842001001834421370876131423051243009238132998862503647315004472372260522553100702760306009400489239041481767489449508762698769440722991254308937041274421309564510700640523436683025904802524151105341036241061571399009964953631316112602618189822901189229608924711592493241215457387406403e750")),
           ef_complex(e_float("-7.1466700625131816506517692988528890820010254842742263986192272152516221791117621719306423055140086081293607223351777838041447504967608717374568446606208777276924168167420853315637002730244817388580280093625425400662613357494246403983844938228009301840712088223211759961477359716567442625491601613654596656599372715322428125925740047614031769930613563516625885002951484306615576411001255504503345638531e786"), e_float("-6.8756499336729843825608494454889528250435462931821960588436082943381411802466893359066258537869729288507682344575531552248527708115037338070627309934197288964778968829877865191154968686233254264863599539212529779351698025091937302691433750874002274919862288667551258699223631548001286201173662297383347758998622766401907643013775477545376465021008517202113269471284947883608556315537611192464077262603e786")),
           ef_complex(e_float("-1.0679053344678401443527217749357116094377358510393520816498416536445432434401057026918666827688353035017260367077995140968221122636023550656237805527543353541956811389231477974753746185602082696037279488072078205199793194251536909137705873170801736551243956732297691539288767241818758963952631706184014138380545157852966288279563332376618520978543512163893941425910345085337350661369498282924744613618e824"), e_float("2.3561926620071720878517361792843405904303217981649808887962899666940079480180804377552923931501736155950443814069754120248572014883386684867062341429177646334278864245714689836463492201986190999050104647402238322890980847453155303248576495003157104765174159876949051769647063473336783862326581133205609952346464486225672605560005484506287965174812529708089384844229529136651752337030244979950741400829e824")),
           ef_complex(e_float("-1.1416990309137097287393149150088451472723197251982803501068912458190355296491777529902501327734153532355646150153520404151324993568065063260705257965305320776581722036850429184750835704192574678572272467653724162874718342418120192233815992345628351230850698742931909081520209044430383114514352579251819121971369806794512418243889627943762738196369131994373240920070099774022952189143659387317516483667e862"), e_float("4.853655093255361778950732149861277628499859595921408179552613943482329302542148084139415271229329716519865519078261075377620277910932574111578645907596484429535116469843173203254044011199786894380176452370677922073432018090926044562949741280348916965724518799685209973752667329563123492260872061206355188343929153875322849602854111649214833625590209929419690027420523749589030630772746492539938175831e862")),
           ef_complex(e_float("-6.9832901358894160796669966605687869960531612484659478065842641950842148133466017914839915543795615408104773803885182375790530053684882963718101951372493140231730264042300054423171897662340071132828065887762643659784848773954807685472033604375776875399398076274483849194379881375606658856845313863852175712681920076214286348779288170622368792682123048421354004236827654540282607147129174336827270896119e901"), e_float("-1.2889951350382483749656184932206455190037440224980773516679748248152736571957458361291945664962317569950425627923422908668182342013934098528757365663085958243863268561996862154322882360425975448719578257834588245971035969997060243981257370343758521789070513094990349561840581126225686219956196322726972646875959269167761125795314657000720029557114298272336051010793353215401605476948358211511068745112e901")),
           ef_complex(e_float("7.1818842358084001444657818662138577830817667085438169442023032203502403468650840891737051146444306855407166580420665001256836643559181089016521210748324069108257297578640874859848930100341411396929371458312659294339791436169887770429472137167794284199439223035013396015087539513120721797938890341619783260230130716375036493235410008646543581898826990285344272734833309351054446927924018102455567005148e941"), e_float("2.0655724876396686252918572290066782649711237082763884192482896136814083341886417340700637929454576617994832035718522916052746929710753232870180137773351733967224201418362490891593087149963709323080086463661398342164240502764393088005904862326444016437320561825941960132347346658861111892947585152231390505469110256886316903642502497934773928720231073576859577161160654639322941353322979125468807005342e941")),
           ef_complex(e_float("2.9054271535403832063542907541400346266903859317439753669764587012277922043865122947642553106706998941355767465919668678199184457802470154660849719784171466722870042576515046411204990443107220054104972353060555395394711880789385037140824963072027938443572210962772274930794949363065676001919425361717907452534628170564825904327177767862103481522059689111052772359741272340497364942752255977473168385103e982"), e_float("-5.032443552356623845993602575355762902359235660076476009907087153942727932759095792503703732144994504025024502792368439038623805252107543461198368039405829430553924880024149552183993973382326037570335570498885760771494355151531762922668849890098774003103232296325981040546500685047406401601992732597068034502484891685518597548158840154857750232048262718981216708069406942557564537389936330178244515929e982")),
           ef_complex(e_float("2.6424031439367317698066495964099156317798960548376468801282108458378709842893898263247332073894871276336700524788059400827932032784016089050256804024604036608757308502459663974752886333667639695210645667863450212472440240800941717974507932268290740810040316737142586496325558055891754130937246988435065195965886371732570604479645821137095697829834129467967089666591384958490533368880248382652293276866e1024"), e_float("-2.0408383092491575085051945797641679916304876211789313590001335120698523522760008982275833512721770624838296882854924578809145252201071026207866638787775458211571427886016410800893534683187576009920513275359728115124723080290058706886397545581128295958842790005697955745439030461056221582860200887697683945281611926583503126022948015769804087602467318007542627840710391377091622783279682794720950045288e1024")),
           ef_complex(e_float("1.726010778119196269388355436967696440005858454546977968134071410145937183664639286714327101077401225753030125714952814171036669916719246652201770268031561097627111721833225925806320837982754275088917873910216099112036115199826364513684932187991557448047637321539076677144565218937479333862712039154306720397778132174876748277060448579375596970489915763662203719793219656764814379655590549284967758963e1066"), e_float("1.406919464600290559603459339266548495361909160564541299110569851509649490180496930211802346674258115157867880907985348935987210377433048096904320949104698166307045107179394801248371421876529948796696039602694044973198249201032906853768310667908885986685522484240737987882648808255424155638875924615811072038136812172779161329449804389899275579391867573807005330095750667035128649507028706788121137378e1067")),
           ef_complex(e_float("2.3601935273260723848272417586005194996895987794278395776068126675024456838044991111253098638357198934590747619560477319643264467064278005340532215811320634917647126737993526686707580001179676396134162894234932686174867945816532567238943310225691860642635162389171146644069114441966435572610880227332576828947278331891079531431772082285133356693978052793002701845684837723094469297579406983320344773913e1110"), e_float("-3.7685416503387672374061390127323897767663405123873886077645048620076985197130646539871863173581309561509053308301859546885533125223650069432800564917294027877443362837655940726361481944021901432957290144236239677265038183962925593641042567424849331746968489117070580728503099216190466495208847480038697867387389391106594437055061505537480837924061249067823931016159629927602818506925730561318596123198e1110")),
        }};
        static const std::vector<ef_complex> v(a.begin(), a.end());
        return v;
      }
    };

    bool test_case_02122_z_cosh(const bool b_write_output)
    {
      return TestCase_case_02122_z_cosh().execute(b_write_output);
    }
  }
}
