! Real-valued quad precision mathematical functions.

SUBROUTINE QXFLOOR(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  INTEGER(8) N
  N = FLOOR(X, 8)
  DST = QFLOAT(N)
  RETURN
END

SUBROUTINE QXCEIL(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  INTEGER(8) N
  N = CEILING(X, 8)
  DST = QFLOAT(N)
  RETURN
END

SUBROUTINE QXCBRT(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = X**0.3333333333333333333333333333333333333333Q0
  RETURN
END

SUBROUTINE QXROOTN(DST, X, P)
  IMPLICIT NONE
  REAL(16) DST, X
  INTEGER(4) P
  INTEGER(8) INT8
  DST = X**(1.0Q0/QFLOAT(INT8(P)))
  RETURN
END

SUBROUTINE QXEXP(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = EXP(X)
  RETURN
END

SUBROUTINE QXLOG(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = LOG(X)
  RETURN
END

SUBROUTINE QXPOW(DST, X, A)
  IMPLICIT NONE
  REAL(16) DST, X, A
  DST = X**A
  RETURN
END

SUBROUTINE QXSIN(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = SIN(X)
  RETURN
END

SUBROUTINE QXCOS(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = COS(X)
  RETURN
END

SUBROUTINE QXTAN(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = TAN(X)
  RETURN
END

SUBROUTINE QXASIN(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ASIN(X)
  RETURN
END

SUBROUTINE QXACOS(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ACOS(X)
  RETURN
END

SUBROUTINE QXATAN(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ATAN(X)
  RETURN
END

SUBROUTINE QXATAN2(DST, Y, X)
  IMPLICIT NONE
  REAL(16) DST, Y, X
  DST = ATAN2(Y, X)
  RETURN
END

SUBROUTINE QXSINH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = SINH(X)
  RETURN
END

SUBROUTINE QXCOSH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = COSH(X)
  RETURN
END

SUBROUTINE QXTANH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = TANH(X)
  RETURN
END

SUBROUTINE QXASINH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ASINH(X)
  RETURN
END

SUBROUTINE QXACOSH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ACOSH(X)
  RETURN
END

SUBROUTINE QXATANH(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ATANH(X)
  RETURN
END

SUBROUTINE QXERF(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ERF(X)
  RETURN
END

SUBROUTINE QXERFC(DST, X)
  IMPLICIT NONE
  REAL(16) DST, X
  DST = ERFC(X)
  RETURN
END
