/*-------------------------------------------------------------------------------------*/
/*  NOMAD - Nonsmooth Optimization by Mesh Adaptive Direct search - version 3.4        */
/*                                                                                     */
/*  Copyright (C) 2001-2010  Mark Abramson        - the Boeing Company, Seattle        */
/*                           Charles Audet        - Ecole Polytechnique, Montreal      */
/*                           Gilles Couture       - Ecole Polytechnique, Montreal      */
/*                           John Dennis          - Rice University, Houston           */
/*                           Sebastien Le Digabel - Ecole Polytechnique, Montreal      */
/*                                                                                     */
/*  funded in part by AFOSR and Exxon Mobil                                            */
/*                                                                                     */
/*  Author: Sebastien Le Digabel                                                       */
/*                                                                                     */
/*  Contact information:                                                               */
/*    Ecole Polytechnique de Montreal - GERAD                                          */
/*    C.P. 6079, Succ. Centre-ville, Montreal (Quebec) H3C 3A7 Canada                  */
/*    e-mail: nomad@gerad.ca                                                           */
/*    phone : 1-514-340-6053 #6928                                                     */
/*    fax   : 1-514-340-5665                                                           */
/*                                                                                     */
/*  You can find information on the NOMAD software at www.gerad.ca/nomad               */
/*-------------------------------------------------------------------------------------*/
/**
  \file   Cache_Point.cpp
  \brief  Point stored in the cache (implementation)
  \author Sebastien Le Digabel
  \date   2010-04-08
  \see    Cache_Point.hpp
*/
#include "Cache_Point.hpp"

/*-----------------------------------------------------------*/
/*                     comparison operator                   */
/*-----------------------------------------------------------*/
bool NOMAD::Cache_Point::operator < ( const Set_Element<NOMAD::Eval_Point> & cp ) const
{
  if ( get_element()->get_tag() == cp.get_element()->get_tag() )
    return false;
  return get_element()->Point::operator < ( *(cp.get_element()) );
}
