.TH TQL1 3 "31 August 1983" "Version 1.00"
.\" WARNING: This file was produced automatically from file common/tql1.f
.\" by fortran-to-man-page.awk on Sun Dec 31 09:02:26 MST 2000.
.\" Any manual changes will be lost if this file is regenerated!
.SH NAME
tql1 \- Double-precision symmetric tridiagonal matrix eigenvalues
.\"=====================================================================
.SH SYNOPSIS
Fortran (77, 90, 95, HPF):
.RS
.B f77
.I "[ flags ] file(s) .\|.\|. -L/usr/local/lib -lgjl"
.RS
.nf
.B "SUBROUTINE tql1(n,d,e,ierr)"
.B "DOUBLE PRECISION    d(*),        e(*)"
.B "INTEGER             ierr,        n"
.fi
.RE
.RE
C (K&R, 89, 99), C++ (98):
.RS
.B cc
.I "[ flags ] -I/usr/local/include file(s) .\|.\|. -L/usr/local/lib -lgjl"
.br
Use
.RS
.B "#include <gjl.h>"
.RE
to get this prototype:
.RS
.B "void tql1(const fortran_integer * n_,"
.B "          fortran_double_precision d_[],"
.B "          fortran_double_precision e_[],"
.B "          fortran_integer * ierr_);"
.RE
.RE
.PP
NB: The definition of C/C++ data types
.B fortran_
.IR xxx ,
and the mapping of Fortran external names to C/C++ external names,
is handled by the C/C++ header file.  That way, the same function
or subroutine name can be used in C, C++, and Fortran code,
independent of compiler conventions for mangling of external
names in these programming languages.
.PP
Last code modification: 31-Aug-1983
.\"=====================================================================
.SH DESCRIPTION
Given a symmetric tridiagonal matrix of order \fBn\fP\& stored with its
diagonal in \fBd\fP\&(1.\|.\fBn\fP\&), and its subdiagonal in \fBe\fP\&(2.\|.\fBn\fP\&), with \fBe\fP\&(1)
arbitrary, use the QL method to find the eigenvalues.
.PP
On return, the original contents of \fBd\fP\&(*) and \fBe\fP\&(*) will have been
destroyed, and \fBd\fP\&(*) will contain the eigenvalues in ascending
order.
.PP
The error indicator, \fBierr\fP\&, is normally set to zero on return.
However, if an error exit is made, \fBierr\fP\& is set to a positive
value, and then the eigenvalues are correct and ordered for
indices 1, 2, .\|.\|., \fBierr\fP\&-1, but may not be the smallest
eigenvalues.
.PP
This routine is a translation of the Algol procedure \fBtql1\fP\&() from
``The QR and QL Algorithms for Symmetric Matrices'', Numerische
Mathematik 11, 293--306 (1968), by H. J. Bowdler, R. S. Martin,
C. Reinsch and J. H. Wilkinson. That article was republished
in the Handbook for Automatic Computation, Vol. II, Linear
Algebra, 227--240 (1971), eds. J. H. Wilkinson and C. Reinsch,
Springer-Verlag, ISBN 3-540-05414-6.
.PP
\fBtql1\fP\&() is part of the EISPACK-1 and EISPACK-2 libraries.
.\"=====================================================================
.SH AUTHORS
The algorithms and code are described in detail in
the paper
.RS
.I "Algorithm xxx: Quadruple-Precision Gamma(x) and psi(x) Functions for Real Arguments"
.RE
in ACM Transactions on Mathematical Software,
Volume ??, Number ??, Pages ????--???? and
????--????, 2001, by
.RS
.nf
Nelson H. F. Beebe
Center for Scientific Computing
University of Utah
Department of Mathematics, 110 LCB
155 S 1400 E RM 233
Salt Lake City, UT 84112-0090
Tel: +1 801 581 5254
FAX: +1 801 581 4148
Email: \fCbeebe@math.utah.edu\fP, \fCbeebe@acm.org\fP, \fCbeebe@computer.org\fP
WWW URL: \fChttp://www.math.utah.edu/~beebe\fP
.fi
.RE
and
.RS
.nf
James S. Ball
University of Utah
Department of Physics
Salt Lake City, UT 84112-0830
USA
Tel: +1 801 581 8397
FAX: +1 801 581 6256
Email: \fCball@physics.utah.edu\fP
WWW URL: \fChttp://www.physics.utah.edu/people/faculty/ball.html\fP
.fi
.RE
.\"==============================[The End]==============================
.\"=====================================================================
.\" This is for GNU Emacs file-specific customization:
.\" Local Variables:
.\" fill-column: 50
.\" End:
