function draw_simplices(S,T)
% draw_simplices(S,T) draw the simplex subdvision
% in 2 or 3 dimension
% S: each column corresponds to the vertex
%    coordinates of the simplex
% T: Cell array with the k^d color schemes,
%    generated by the function color_schemes(),
%    defining the vertices of each the new simplices
d = size(S,1);
k = size(T{1},1);
figure
hold
for i = 1: max(size(T))
  chi = T{i};
  P = zeros(d,d+1);
  for j = 1:d+1
    for m = 1:k
      P(:,j)=P(:,j)+S(:,chi(m,j)+1)/k;
    end
  end
  draw_splx(P,chi)
end
hold
%------------------------------------
function draw_splx(P,X)
% Draw lines connecting the vertices
[d,k]=size(P);
for i=1:k-1
  for j=i+1:k
    if d == 2
      plot(P(1,[i j]),P(2,[i j]))
    else
      plot3(P(1,[i j]),P(2,[i j]),P(3,[i j]))
    end
  end
end