*
*
      SUBROUTINE PSSPGST( IBTYPE, UPLO, N, A, IA, JA, DESCA, B, IB, JB,
     $                    DESCB, SCALE, WORK, LWORK, INFO )
*
*  -- ScaLAPACK routine (version 1.6 ALPHA) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     May 1, 1997
*
*
*
*
*  Purpose
*  =======
*
*  PSSPGST reduces a REAL symmetric-definite generalized
*  eigenproblem to standard form.
*
*  In the following sub( A ) denotes A( IA:IA+N-1, JA:JA+N-1 ) and
*  sub( B ) denotes B( IB:IB+N-1, JB:JB+N-1 ).
*
*  If IBTYPE = 1, the problem is sub( A )*x = lambda*sub( B )*x,
*  and sub( A ) is overwritten by inv(U**H)*sub( A )*inv(U) or
*  inv(L)*sub( A )*inv(L**H)
*
*  If IBTYPE = 2 or 3, the problem is sub( A )*sub( B )*x = lambda*x or
*  sub( B )*sub( A )*x = lambda*x, and sub( A ) is overwritten by
*  U*sub( A )*U**H or L**H*sub( A )*L.
*
*  sub( B ) must have been previously factorized as U**H*U or L*L**H by
*  PSPPTRF.
*
*  Matrices A, and B are stored in packed storage.
*  UPLO applies to both A and B.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  IBTYPE   (global input) INTEGER
*          = 1: compute inv(U**H)*sub( A )*inv(U) or
*               inv(L)*sub( A )*inv(L**H);
*          = 2 or 3: compute U*sub( A )*U**H or L**H*sub( A )*L.
*
*  UPLO    (global input) CHARACTER
*          = 'U':  Upper triangle of sub( A ) is stored and sub( B ) is
*                  factored as U**H*U;
*          = 'L':  Lower triangle of sub( A ) is stored and sub( B ) is
*                  factored as L*L**H.
*
*  N       (global input) INTEGER
*          The order of the matrices sub( A ) and sub( B ).  N >= 0.
*
*  A       (local input/local output) REAL
*          array of dimension (LLD_A, LOCc(JA+N-1)).
*          On entry, this array contains the local pieces of the
*          N-by-N Hermitian distributed matrix sub( A ). If UPLO = 'U',
*          the leading N-by-N upper triangular part of sub( A ) contains
*          the upper triangular part of the matrix, and its strictly
*          lower triangular part is not referenced.  If UPLO = 'L', the
*          leading N-by-N lower triangular part of sub( A ) contains
*          the lower triangular part of the matrix, and its strictly
*          upper triangular part is not referenced.
*
*          On exit, if INFO = 0, the transformed matrix, stored in the
*          same format as sub( A ).
*
*  IA      (global input) INTEGER
*          A's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JA      (global input) INTEGER
*          A's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  B       (local input) REAL
*          array of dimension (LLD_B, LOCc(JB+N-1)). On entry,
*          this array contains the local pieces of the triangular factor
*          from the Cholesky factorization of sub( B ), as returned by
*          PSPPTRF.
*
*  IB      (global input) INTEGER
*          B's global row index, which points to the beginning of the
*          submatrix which is to be operated on.
*
*  JB      (global input) INTEGER
*          B's global column index, which points to the beginning of
*          the submatrix which is to be operated on.
*
*  DESCB   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix B.
*
*  SCALE   (global output) REAL
*          Amount by which the eigenvalues should be scaled to
*          compensate for the scaling performed in this routine.
*          At present, SCALE is always returned as 1.0, it is
*          returned here to allow for future enhancement.
*
*  WORK    (local workspace) REAL
*          Since Matrices A and B are both stored in packed
*          storage, for row-wise operation, it is convenient to
*          first copy the block row into a contiguous temporary
*          workspace. The copy can be performed without further
*          communication.
*
*  LWORK   (local input) INTEGER
*           Size of WORK
*           An upper bound is storage for 2 block row
*           to accomodate two NB by N row vectors.
*           Actual storage required may be much less.
*
*           WORK is needed for
*
*           (IBTYPE .eq. 1) .and. (LSAME(UPLO,'Upper'))
*           or
*           (IBTYPE .ne. 1) .and. (LSAME(UPLO,'Lower'))
*
*           LWORK <= 2*NP0*DESCA(MB_)
*
*           WHERE NP0 = NUMROC( N, DESCA(NB_),0,0,NPCOL )
*
*
*  INFO    (global output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*  =====================================================================
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, DLEN_, DTYPE_, CTXT_, M_, N_,
     $                   MB_, NB_, RSRC_, CSRC_, LLD_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DTYPE_ = 1,
     $                   CTXT_ = 2, M_ = 3, N_ = 4, MB_ = 5, NB_ = 6,
     $                   RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      REAL               ONE
      PARAMETER          ( ONE = 1.0E+0 )
      REAL               CONE, HALF
      PARAMETER          ( CONE = 1.0E+0, HALF = 0.5E+0 )
*     ..
*     .. Local Scalars ..
      LOGICAL            UPPER
      INTEGER            IA1, IA2, IACOFF, IACOL, IAROFF, IAROW, IB1,
     $                   IB2, IBCOFF, IBCOL, IBROFF, IBROW, ICOFFA,
     $                   ICOFFB, ICTXT, IFREE, IFREE_SAVED, IIA, IIB,
     $                   IINFO, INEED, IP_AWORK, IP_BWORK, IROFFA,
     $                   IROFFB, JA1, JA2, JB1, JB2, JJA, JJB, K, KB,
     $                   LDWORK, LOCP, LOCQ, LOFFA1, LOFFA2, LOFFB1,
     $                   LOFFB2, MYCOL, MYROW, NB, NFREE, NN, NPCOL,
     $                   NPROW
*     ..
*     .. Local Arrays ..
      INTEGER            DESCA1( DLEN_ ), DESCA2( DLEN_ ),
     $                   DESCAWORK( DLEN_ ), DESCB1( DLEN_ ),
     $                   DESCB2( DLEN_ ), DESCBWORK( DLEN_ ),
     $                   IDUM1( 2 ), IDUM2( 2 )
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, CHK1MAT, DESCINIT, DESCINITT,
     $                   PCHK2MAT, PSLACPT2, PSLACPT3, PSSPR2K, PSSYGS2,
     $                   PSSYMM, PSTPMM, PSTPSM, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          ICHAR, MAX, MIN, MOD
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            ICEIL, INDXG2P, NUMROC
      EXTERNAL           LSAME, ICEIL, INDXG2P, NUMROC
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IB, IBTYPE, INFO, JA, JB, LWORK, N
      REAL               SCALE
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      REAL               A( * ), B( * ), WORK( * )
*     ..
*     .. Executable Statements ..
*       This is just to keep ftnchek happy
      IF( BLOCK_CYCLIC_2D*CSRC_*CTXT_*DLEN_*DTYPE_*LLD_*MB_*M_*NB_*N_*
     $    RSRC_.LT.0 )RETURN
      IFREE = 1
      INEED = 1
*
*     Get grid parameters
*
      SCALE = ONE
*
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
*
*     Test the input parameters
*
      INFO = 0
      IF( NPROW.EQ.-1 ) THEN
         INFO = -( 700+CTXT_ )
      ELSE
         UPPER = LSAME( UPLO, 'U' )
         CALL CHK1MAT( N, 3, N, 3, IA, JA, DESCA, 7, INFO )
         CALL CHK1MAT( N, 3, N, 3, IB, JB, DESCB, 11, INFO )
         IF( INFO.EQ.0 ) THEN
            IAROW = INDXG2P( IA, DESCA( MB_ ), MYROW, DESCA( RSRC_ ),
     $              NPROW )
            IBROW = INDXG2P( IB, DESCB( MB_ ), MYROW, DESCB( RSRC_ ),
     $              NPROW )
            IACOL = INDXG2P( JA, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ),
     $              NPCOL )
            IBCOL = INDXG2P( JB, DESCB( NB_ ), MYCOL, DESCB( CSRC_ ),
     $              NPCOL )
            IROFFA = MOD( IA-1, DESCA( MB_ ) )
            ICOFFA = MOD( JA-1, DESCA( NB_ ) )
            IROFFB = MOD( IB-1, DESCB( MB_ ) )
            ICOFFB = MOD( JB-1, DESCB( NB_ ) )
            IF( IBTYPE.LT.1 .OR. IBTYPE.GT.3 ) THEN
               INFO = -1
            ELSEIF( .NOT.UPPER .AND. .NOT.LSAME( UPLO, 'L' ) ) THEN
               INFO = -2
            ELSEIF( N.LT.0 ) THEN
               INFO = -3
            ELSEIF( IROFFA.NE.0 ) THEN
               INFO = -5
            ELSEIF( ICOFFA.NE.0 ) THEN
               INFO = -6
            ELSEIF( DESCA( MB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -( 700+NB_ )
            ELSEIF( IROFFB.NE.0 .OR. IBROW.NE.IAROW ) THEN
               INFO = -9
            ELSEIF( ICOFFB.NE.0 .OR. IBCOL.NE.IACOL ) THEN
               INFO = -10
            ELSEIF( DESCB( MB_ ).NE.DESCA( MB_ ) ) THEN
               INFO = -( 1100+MB_ )
            ELSEIF( DESCB( NB_ ).NE.DESCA( NB_ ) ) THEN
               INFO = -( 1100+NB_ )
            ELSEIF( ICTXT.NE.DESCB( CTXT_ ) ) THEN
               INFO = -( 1100+CTXT_ )
            ENDIF
         ENDIF
         IDUM1( 1 ) = IBTYPE
         IDUM2( 1 ) = 1
         IF( UPPER ) THEN
            IDUM1( 2 ) = ICHAR( 'U' )
         ELSE
            IDUM1( 2 ) = ICHAR( 'L' )
         ENDIF
         IDUM2( 2 ) = 2
         CALL PCHK2MAT( N, 3, N, 3, IA, JA, DESCA, 7, N, 3, N, 3, IB,
     $                  JB, DESCB, 11, 2, IDUM1, IDUM2, INFO )
      ENDIF
*
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( ICTXT, 'PSSPGST', -INFO )
         RETURN
      ENDIF
*
*     Quick return if possible
*
      IF( N.EQ.0 )
     $   RETURN
*
      IF( IBTYPE.EQ.1 ) THEN
         IF( UPPER ) THEN
*
*           Compute inv(U')*sub( A )*inv(U)
*
            K = 1
            NB = DESCA( NB_ )
            KB = MIN( ICEIL( JA, NB )*NB, JA+N-1 ) - JA + 1
*
   10       CONTINUE
*
*           Update the upper triangle of A(ia+k-1:ia+n-1,ja+k-1:ja+n-1)
*
            IFREE_SAVED = IFREE
            IIB = IB + K - 1
            JJB = JB + K - 1
            IIA = IA + K - 1
            JJA = JA + K - 1
            NN = N - K - KB + 1
*
            CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1, LOFFA1,
     $                      DESCA1 )
            CALL DESCINITT( UPLO, IIB, IIB, DESCB, IB1, JB1, LOFFB1,
     $                      DESCB1 )
            CALL PSSYGS2( IBTYPE, UPLO, KB, A( LOFFA1 ), IA1, JA1,
     $                    DESCA1, B( LOFFB1 ), IB1, JB1, DESCB1, INFO )
            IF( K+KB.LE.N ) THEN
*
*    Use AWORK to hold A( IIA:IIA+KB-1, (JJA+KB):(JJA+KB+NN-1)
*
               IF( NN.GE.1 ) THEN
                  IAROW = INDXG2P( IIA, DESCA( MB_ ), MYROW,
     $                    DESCA( RSRC_ ), NPROW )
                  IACOL = INDXG2P( JJA+KB, DESCA( NB_ ), MYCOL,
     $                    DESCA( CSRC_ ), NPCOL )
                  IAROFF = MOD( IIA-1+DESCA( MB_ ), DESCA( MB_ ) )
                  IACOFF = MOD( JJA+KB-1+DESCA( NB_ ), DESCA( NB_ ) )
                  LOCP = NUMROC( KB+IAROFF, DESCA( MB_ ), MYROW, IAROW,
     $                   NPROW )
                  LOCQ = NUMROC( NN+IACOFF, DESCA( NB_ ), MYCOL, IACOL,
     $                   NPCOL )
                  LDWORK = MAX( 1, LOCP )
                  CALL DESCINIT( DESCAWORK, KB+IAROFF, NN+IACOFF,
     $                           DESCA( MB_ ), DESCA( NB_ ), IAROW,
     $                           IACOL, DESCA( CTXT_ ), LDWORK, IINFO )
                  IP_AWORK = IFREE
                  IFREE = IFREE + LOCP*LOCQ
                  INEED = MAX( INEED, IFREE-1 )
                  NFREE = LWORK - IFREE
                  IF( NFREE.LT.0 ) THEN
                     CALL PXERBLA( DESCA( CTXT_ ), 'PXHPGST', 14 )
                     WORK( 1 ) = INEED
                     RETURN
                  ENDIF
*
                  CALL PSLACPT2( UPLO, KB, NN, A, IIA, ( JJA+KB ),
     $                           DESCA, WORK( IP_AWORK ), 1+IAROFF,
     $                           1+IACOFF, DESCAWORK )
*
*
                  CALL PSTPSM( 'Left', UPLO, 'Conjugate Transpose',
     $                         'Non-unit', KB, NN, CONE, B, IIB, JJB,
     $                         DESCB, WORK( IP_AWORK ), 1+IAROFF,
     $                         1+IACOFF, DESCAWORK )
*
*    Use BWORK to hold B( IIB:IIB+KB-1, (JJB+KB):(JJB+KB+NN-1) )
*
                  IBROW = INDXG2P( IIB, DESCB( MB_ ), MYROW,
     $                    DESCB( RSRC_ ), NPROW )
                  IBCOL = INDXG2P( JJB+KB, DESCB( NB_ ), MYCOL,
     $                    DESCB( CSRC_ ), NPCOL )
                  IBROFF = MOD( IIB-1+DESCB( MB_ ), DESCB( MB_ ) )
                  IBCOFF = MOD( JJB+KB-1+DESCB( NB_ ), DESCB( NB_ ) )
                  LOCP = NUMROC( KB+IBROFF, DESCB( MB_ ), MYROW, IBROW,
     $                   NPROW )
                  LOCQ = NUMROC( NN+IBCOFF, DESCB( NB_ ), MYCOL, IBCOL,
     $                   NPCOL )
                  LDWORK = MAX( 1, LOCP )
                  CALL DESCINIT( DESCBWORK, KB+IBROFF, NN+IBCOFF,
     $                           DESCB( MB_ ), DESCB( NB_ ), IBROW,
     $                           IBCOL, DESCB( CTXT_ ), LDWORK, IINFO )
                  IP_BWORK = IFREE
                  IFREE = IFREE + LOCP*LOCQ
                  INEED = MAX( INEED, IFREE-1 )
                  NFREE = LWORK - IFREE
                  IF( NFREE.LT.0 ) THEN
                     CALL PXERBLA( DESCB( CTXT_ ), 'PXHPGST', 14 )
                     RETURN
                  ENDIF
                  CALL PSLACPT2( UPLO, KB, NN, B, IIB, JJB+KB, DESCB,
     $                           WORK( IP_BWORK ), 1+IBROFF, 1+IBCOFF,
     $                           DESCBWORK )
*
                  CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1,
     $                            LOFFA1, DESCA1 )
                  CALL PSSYMM( 'Left', UPLO, KB, NN, -HALF, A( LOFFA1 ),
     $                         IA1, JA1, DESCA1, WORK( IP_BWORK ),
     $                         1+IBROFF, 1+IBCOFF, DESCBWORK, CONE,
     $                         WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                         DESCAWORK )
*
                  CALL PSSPR2K( UPLO, 'Conjugate Transpose', NN, KB,
     $                          -CONE, WORK( IP_AWORK ), 1+IAROFF,
     $                          1+IACOFF, DESCAWORK, WORK( IP_BWORK ),
     $                          1+IBROFF, 1+IBCOFF, DESCBWORK, ONE, A,
     $                          IA+K+KB-1, JJA+KB, DESCA )
*
                  CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1,
     $                            LOFFA1, DESCA1 )
                  CALL PSSYMM( 'Left', UPLO, KB, NN, -HALF, A( LOFFA1 ),
     $                         IA1, JA1, DESCA1, WORK( IP_BWORK ),
     $                         1+IBROFF, 1+IBCOFF, DESCBWORK, CONE,
     $                         WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                         DESCAWORK )
*
                  CALL PSTPSM( 'Right', UPLO, 'No transpose',
     $                         'Non-unit', KB, NN, CONE, B, IIB+KB,
     $                         JJB+KB, DESCB, WORK( IP_AWORK ),
     $                         1+IAROFF, 1+IACOFF, DESCAWORK )
*
*    Copy AWORK and BWORK
*
                  CALL PSLACPT3( UPLO, KB, NN, WORK( IP_AWORK ),
     $                           1+IAROFF, 1+IACOFF, DESCAWORK, A, IIA,
     $                           JJA+KB, DESCA )
                  CALL PSLACPT3( UPLO, KB, NN, WORK( IP_BWORK ),
     $                           1+IBROFF, 1+IBCOFF, DESCBWORK, B, IIB,
     $                           JJB+KB, DESCB )
               ENDIF
               IFREE = IFREE_SAVED
            ENDIF
            K = K + KB
            KB = MIN( N-K+1, NB )
*
            IF( K.LE.N )
     $         GOTO 10
*
         ELSE
*
*           Compute inv(L)*sub( A )*inv(L')
*
            K = 1
            NB = DESCA( MB_ )
            KB = MIN( ICEIL( IA, NB )*NB, IA+N-1 ) - IA + 1
*
   20       CONTINUE
*
*           Update the lower triangle of A(ia+k-1:ia+n-1,ja+k-1:ja+n-1)
*
            IIA = IA + K - 1
            JJA = JA + K - 1
            IIB = IB + K - 1
            JJB = JB + K - 1
            NN = N - K - KB + 1
*
            CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1, LOFFA1,
     $                      DESCA1 )
            CALL DESCINITT( UPLO, IB+K-1, JJB, DESCB, IB1, JB1, LOFFB1,
     $                      DESCB1 )
            CALL PSSYGS2( IBTYPE, UPLO, KB, A( LOFFA1 ), IA1, JA1,
     $                    DESCA1, B( LOFFB1 ), IB1, JB1, DESCB1, INFO )
            IF( K+KB.LE.N ) THEN
               IF( NN.GE.1 ) THEN
                  CALL DESCINITT( UPLO, IIA+KB, JJA, DESCA, IA1, JA1,
     $                            LOFFA1, DESCA1 )
                  CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA2, JA2,
     $                            LOFFA2, DESCA2 )
                  CALL PSTPSM( 'Right', UPLO, 'Conjugate transpose',
     $                         'Non-unit', NN, KB, CONE, B, IB+K-1, JJB,
     $                         DESCB, A( LOFFA1 ), IA1, JA1, DESCA1 )
*
                  CALL DESCINITT( UPLO, IIB+KB, JJB, DESCB, IB1, JB1,
     $                            LOFFB1, DESCB1 )
                  CALL PSSYMM( 'Right', UPLO, NN, KB, -HALF,
     $                         A( LOFFA2 ), IA2, JA2, DESCA2,
     $                         B( LOFFB1 ), IB1, JB1, DESCB1, CONE,
     $                         A( LOFFA1 ), IA1, JA1, DESCA1 )
*
                  CALL PSSPR2K( UPLO, 'No transpose', NN, KB, -CONE,
     $                          A( LOFFA1 ), IA1, JA1, DESCA1,
     $                          B( LOFFB1 ), IB1, JB1, DESCB1, ONE, A,
     $                          IIA+KB, JJA+KB, DESCA )
*
                  CALL PSSYMM( 'Right', UPLO, NN, KB, -HALF,
     $                         A( LOFFA2 ), IA2, JA2, DESCA2,
     $                         B( LOFFB1 ), IB1, JB1, DESCB1, CONE,
     $                         A( LOFFA1 ), IA1, JA1, DESCA1 )
*
                  CALL PSTPSM( 'Left', UPLO, 'No transpose', 'Non-unit',
     $                         NN, KB, CONE, B, IIB+KB, JJB+KB, DESCB,
     $                         A( LOFFA1 ), IA1, JA1, DESCA1 )
               ENDIF
            ENDIF
            K = K + KB
            KB = MIN( N-K+1, NB )
*
            IF( K.LE.N )
     $         GOTO 20
*
         ENDIF
*
      ELSE
*
         IF( UPPER ) THEN
*
*           Compute U*sub( A )*U'
*
            K = 1
            NB = DESCA( NB_ )
            KB = MIN( ICEIL( JA, NB )*NB, JA+N-1 ) - JA + 1
*
   30       CONTINUE
*
*           Update the upper triangle of A(ia:ia+k+kb-2,ja:ja+k+kb-2)
*
            IIA = IA + K - 1
            JJA = JA + K - 1
            IIB = IB + K - 1
            JJB = JB + K - 1
            NN = K - 1
            IF( NN.GE.1 ) THEN
               CALL DESCINITT( UPLO, IA, JJA, DESCA, IA1, JA1, LOFFA1,
     $                         DESCA1 )
               CALL PSTPMM( 'Left', UPLO, 'No transpose', 'Non-unit',
     $                      NN, KB, CONE, B, IB, JB, DESCB, A( LOFFA1 ),
     $                      IA1, JA1, DESCA1 )
*
               CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA2, JA2, LOFFA2,
     $                         DESCA2 )
               CALL DESCINITT( UPLO, IB, JB+NN, DESCB, IB1, JB1, LOFFB1,
     $                         DESCB1 )
               CALL PSSYMM( 'Right', UPLO, NN, KB, HALF, A( LOFFA1 ),
     $                      IA2, JA2, DESCA2, B( LOFFB1 ), IB1, JB1,
     $                      DESCB1, CONE, A( LOFFA1 ), IA1, JA1,
     $                      DESCA1 )
*
               CALL PSSPR2K( UPLO, 'No transpose', NN, KB, CONE,
     $                       A( LOFFA1 ), IA1, JA1, DESCA1, B( LOFFB1 ),
     $                       IB1, JB1, DESCB1, ONE, A, IA, JA, DESCA )
*
               CALL PSSYMM( 'Right', UPLO, NN, KB, HALF, A( LOFFA2 ),
     $                      IA2, JA2, DESCA2, B( LOFFB1 ), IB1, JB1,
     $                      DESCB1, CONE, A( LOFFA1 ), IA1, JA1,
     $                      DESCA1 )
*
               CALL PSTPMM( 'Right', UPLO, 'Conjugate transpose',
     $                      'Non-unit', NN, KB, CONE, B, IB+NN, JB+NN,
     $                      DESCB, A( LOFFA1 ), IA1, JA1, DESCA1 )
            ENDIF
*
            CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA2, JA2, LOFFA2,
     $                      DESCA2 )
            CALL DESCINITT( UPLO, IB+NN, JB+NN, DESCB, IB2, JB2, LOFFB2,
     $                      DESCB2 )
            CALL PSSYGS2( IBTYPE, UPLO, KB, A( LOFFA2 ), IA2, JA2,
     $                    DESCA2, B( LOFFB2 ), IB2, JB2, DESCB2, INFO )
*
            K = K + KB
            KB = MIN( N-K+1, NB )
*
            IF( K.LE.N )
     $         GOTO 30
*
         ELSE
*
*           Compute L'*sub( A )*L
*
            K = 1
            NB = DESCA( MB_ )
            KB = MIN( ICEIL( IA, NB )*NB, IA+N-1 ) - IA + 1
*
   40       CONTINUE
*
*           Update the lower triangle of A(ia:ia+k+kb-2,ja:ja+k+kb-2)
*
*
            IFREE_SAVED = IFREE
            IIA = IA + K - 1
            JJA = JA + K - 1
            IIB = IB + K - 1
            JJB = JB + K - 1
            NN = K - 1
*
*
*    Use AWORK to hold A(IIA:IIA+KB-1, JA:JA+NN-1)
*
            IF( NN.GE.1 ) THEN
               IAROW = INDXG2P( IIA, DESCA( MB_ ), MYROW,
     $                 DESCA( RSRC_ ), NPROW )
               IACOL = INDXG2P( JA, DESCA( NB_ ), MYCOL, DESCA( CSRC_ ),
     $                 NPCOL )
               IAROFF = MOD( IIA-1+DESCA( MB_ ), DESCA( MB_ ) )
               IACOFF = MOD( JA-1+DESCA( NB_ ), DESCA( NB_ ) )
               LOCP = NUMROC( KB+IAROFF, DESCA( MB_ ), MYROW, IAROW,
     $                NPROW )
               LOCQ = NUMROC( NN+IACOFF, DESCA( NB_ ), MYCOL, IACOL,
     $                NPCOL )
               LDWORK = MAX( 1, LOCP )
               IP_AWORK = IFREE
               IFREE = IFREE + LOCP*LOCQ
               INEED = MAX( INEED, IFREE-1 )
               NFREE = LWORK - IFREE
               IF( NFREE.LT.0 ) THEN
                  CALL PXERBLA( DESCA( CTXT_ ), 'PXHPGST', 14 )
                  WORK( 1 ) = INEED
                  RETURN
               ENDIF
               CALL DESCINIT( DESCAWORK, KB+IAROFF, NN+IACOFF,
     $                        DESCA( MB_ ), DESCA( NB_ ), IAROW, IACOL,
     $                        DESCA( CTXT_ ), LDWORK, IINFO )
               CALL PSLACPT2( UPLO, KB, NN, A, IIA, JA, DESCA,
     $                        WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                        DESCAWORK )
               CALL PSTPMM( 'Right', UPLO, 'No transpose', 'Non-unit',
     $                      KB, NN, CONE, B, IB, JB, DESCB,
     $                      WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                      DESCAWORK )
*
*    Use BWORK to hold B(IIB:IIB+KB-1,JB:JB+NN-1)
*
               IBROW = INDXG2P( IIB, DESCB( MB_ ), MYROW,
     $                 DESCB( RSRC_ ), NPROW )
               IBCOL = INDXG2P( JB, DESCB( NB_ ), MYCOL, DESCB( CSRC_ ),
     $                 NPCOL )
*
               IBROFF = MOD( IIB-1+DESCB( MB_ ), DESCB( MB_ ) )
               IBCOFF = MOD( JB-1+DESCB( NB_ ), DESCB( NB_ ) )
               LOCP = NUMROC( KB+IBROFF, DESCB( MB_ ), MYROW, IBROW,
     $                NPROW )
               LOCQ = NUMROC( NN+IBCOFF, DESCB( NB_ ), MYCOL, IBCOL,
     $                NPCOL )
               LDWORK = MAX( 1, LOCP )
               CALL DESCINIT( DESCBWORK, KB+IBROFF, NN+IBCOFF,
     $                        DESCB( MB_ ), DESCB( NB_ ), IBROW, IBCOL,
     $                        DESCB( CTXT_ ), LDWORK, IINFO )
*
               IP_BWORK = IFREE
               IFREE = IFREE + LOCP*LOCQ
               INEED = MAX( INEED, IFREE-1 )
               NFREE = LWORK - IFREE
               IF( NFREE.LT.0 ) THEN
                  CALL PXERBLA( DESCA( CTXT_ ), 'PXHPGST', 14 )
                  WORK( 1 ) = INEED
                  RETURN
               ENDIF
*
               CALL PSLACPT2( UPLO, KB, NN, B, IIB, JB, DESCB,
     $                        WORK( IP_BWORK ), 1+IBROFF, 1+IBCOFF,
     $                        DESCBWORK )
*
               CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1, LOFFA1,
     $                         DESCA1 )
               CALL PSSYMM( 'Left', UPLO, KB, NN, HALF, A( LOFFA1 ),
     $                      IA1, JA1, DESCA1, WORK( IP_BWORK ),
     $                      1+IBROFF, 1+IBCOFF, DESCBWORK, CONE,
     $                      WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                      DESCAWORK )
*
               CALL PSSPR2K( UPLO, 'Conjugate transpose', NN, KB, CONE,
     $                       WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                       DESCAWORK, WORK( IP_BWORK ), 1+IBROFF,
     $                       1+IBCOFF, DESCBWORK, ONE, A, IA, JA,
     $                       DESCA )
*
               CALL PSSYMM( 'Left', UPLO, KB, NN, HALF, A( LOFFA1 ),
     $                      IA1, JA1, DESCA1, WORK( IP_BWORK ),
     $                      1+IBROFF, 1+IBCOFF, DESCBWORK, CONE,
     $                      WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                      DESCAWORK )
*
               CALL PSTPMM( 'Left', UPLO, 'Conjugate transpose',
     $                      'Non-unit', KB, NN, CONE, B, IIB, JJB,
     $                      DESCB, WORK( IP_AWORK ), 1+IAROFF, 1+IACOFF,
     $                      DESCAWORK )
*
*    Copy AWORK and BWORK back
*
               CALL PSLACPT3( UPLO, KB, NN, WORK( IP_AWORK ), 1+IAROFF,
     $                        1+IACOFF, DESCAWORK, A, IIA, JA, DESCA )
               CALL PSLACPT3( UPLO, KB, NN, WORK( IP_BWORK ), 1+IBROFF,
     $                        1+IBCOFF, DESCBWORK, B, IIB, JB, DESCB )
            ENDIF
*
            CALL DESCINITT( UPLO, IIA, JJA, DESCA, IA1, JA1, LOFFA1,
     $                      DESCA1 )
            CALL DESCINITT( UPLO, IIB, JJB, DESCB, IB1, JB1, LOFFB1,
     $                      DESCB1 )
*
            CALL PSSYGS2( IBTYPE, UPLO, KB, A( LOFFA1 ), IA1, JA1,
     $                    DESCA1, B( LOFFB1 ), IB1, JB1, DESCB1, INFO )
*
            IFREE = IFREE_SAVED
*
            K = K + KB
            KB = MIN( N-K+1, NB )
*
            IF( K.LE.N )
     $         GOTO 40
*
         ENDIF
*
      ENDIF
*
      WORK( 1 ) = INEED
      RETURN
*
*     End of PSSPGST
*
      END
