      SUBROUTINE PDTPSM( SIDE, UPLO, TRANS, DIAG, M, N, ALPHA, A, IA,
     $                   JA, DESCA, B, IB, JB, DESCB )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*
*  Purpose
*  =======
*
*  PTPSM  solves one of the distributed matrix equations
*
*  A is stored in packed storage.
*
*                 op( sub( A ) )*X = alpha*sub( B ),   or
*
*                 X*op( sub( A ) ) = alpha*sub( B ),
*
*  where sub( A ) denotes A(IA:IA+M-1,JA:JA+M-1)  if SIDE = 'L',
*        sub( A ) denotes A(IA:IA+N-1,JA:JA+N-1)  if SIDE = 'R',
*
*        sub( B ) denotes B(IB:IB+M-1,JB:JB+N-1),
*
*  alpha is a scalar, X and sub( B ) are an M-by-N distributed matrix,
*  sub( A ) is a unit, or non-unit, upper or lower triangular distribu-
*  ted matrix and op( A ) is one of
*
*     op( A ) = A   or   op( A ) = A'   or   op( A ) = conjg( A' ).
*
*  The distributed matrix X is overwritten on sub( B ).
*
*
*
*
*
* Several cases to consider:
*
* forward or backward solve correspond to
* how the right-hand side B(*) is sweeped.
*
*
* L x = b        forward solve  axpyupdate   notransA
* L^t x = b      backward solve  dotupdate    transA
* U x = b        backward solve  axpyupdate   notransA
* U^t x = b      forward solve   dotupdate    transA
*
* x L = b        backward solve  dotupdate    notransA
* x L^t = b      forward solve   axpyupdate   transA
* x U = b        forward solve   dotupdate    notransA
* x U^t = b      backward solve  axpyupdate   transA
*
*     .. Parameters ..
      INTEGER            BLOCK_CYCLIC_2D, DLEN_, DT_
      PARAMETER          ( BLOCK_CYCLIC_2D = 1, DLEN_ = 9, DT_ = 1 )
      INTEGER            CTXT_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, MB_ = 5, NB_ = 6 )
      INTEGER            LLD_
      PARAMETER          ( LLD_ = 9 )
      INTEGER            LWORK
      PARAMETER          ( LWORK = 100 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          DIAG, SIDE, TRANS, UPLO
      INTEGER            IA, IB, JA, JB, M, N
      DOUBLE PRECISION   ALPHA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( DLEN_ ), DESCB( DLEN_ )
      DOUBLE PRECISION   A( * ), B( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            HASWORK, ISAXPYUPDATE, ISBACKWARD, ISDOTUPDATE,
     $                   ISFORWARD, ISLEFT, ISLOWER, ISRIGHT, ISTRANS,
     $                   ISTRANSA, ISUPPER, ISVALID, NOTRANS, NOTRANSA
      CHARACTER          TRANSA
      INTEGER            IA1, IADIAG, IAEND, IAPOS, IASTART, IBPOS,
     $                   IBSIZE, IC, ICONTXT, ICPOS, ICTXT, IDUMMY,
     $                   IIBPOS, IJOFF, INC, INFO, JA1, JADIAG, JAEND,
     $                   JAPOS, JASTART, JBPOS, JC, JCPOS, JEND, JENDLR,
     $                   JINC, JJBPOS, JSIZE, JSTART, KK, LCOFF, LDA,
     $                   LDB, LOFFSET1, LROFF, MM, MYID, MYPCOL, MYPROW,
     $                   NN, NPCOL, NPROC, NPROW, SAVEDT
      DOUBLE PRECISION   LALPHA, LBETA, ONE, ZERO
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ )
      DOUBLE PRECISION   WORK( LWORK )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, BLACS_PINFO, CHK1MAT,
     $                   DESCINITT, INFOT, PCHK1MAT, PDGEMM, PDSCAL,
     $                   PDTRSM, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          DBLE, MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
* ===========================================================
*
*  Check parameters.
*
      ONE = DBLE( 1 )
      ZERO = DBLE( 0 )
      IC = IA
      JC = JA
      INFO = 0
      ICTXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
      IF( NPROW.EQ.-1 ) THEN
         INFO = -( 11*100+CTXT_ )
         RETURN
      ENDIF
      ICTXT = DESCB( CTXT_ )
      CALL BLACS_GRIDINFO( DESCB( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
      IF( NPROW.EQ.-1 ) THEN
         INFO = -( 15*100+CTXT_ )
         RETURN
      ENDIF
      ICONTXT = DESCA( CTXT_ )
      ISVALID = ( LSAME( SIDE, 'R' ) .OR. LSAME( SIDE, 'L' ) )
      IF( .NOT.ISVALID ) THEN
         INFO = -1
         CALL PXERBLA( ICONTXT, 'PDTPSM', 1 )
         RETURN
      ENDIF
      ISVALID = ( LSAME( TRANS, 'T' ) .OR. LSAME( TRANS, 'C' ) .OR.
     $          LSAME( TRANS, 'N' ) )
      IF( .NOT.ISVALID ) THEN
         INFO = -3
         CALL PXERBLA( ICONTXT, 'PDTPSM', 3 )
         RETURN
      ENDIF
      ISVALID = ( LSAME( UPLO, 'U' ) .OR. LSAME( UPLO, 'L' ) )
      IF( .NOT.ISVALID ) THEN
         INFO = -2
         CALL PXERBLA( ICONTXT, 'PDTPSM', 2 )
         RETURN
      ENDIF
      ISVALID = ( LSAME( DIAG, 'U' ) .OR. LSAME( DIAG, 'N' ) )
      IF( .NOT.ISVALID ) THEN
         INFO = -4
         CALL PXERBLA( ICONTXT, 'PDTPSM', 4 )
         RETURN
      ENDIF
*
*
*   sub(A)  is a square m x m matrix if side = 'L'
*   sub(A)  is a square n x n matrix if side = 'R'
*
*   sub(B)  is a m x n matrix
*
*
      ISLEFT = LSAME( SIDE, 'L' )
      IF( ISLEFT ) THEN
         SAVEDT = DESCA( DT_ )
         DESCA( DT_ ) = BLOCK_CYCLIC_2D
         CALL CHK1MAT( M, 5, M, 5, IA, JA, DESCA, 11, INFO )
         IF( INFO.NE.0 ) THEN
            CALL PXERBLA( DESCA( CTXT_ ), 'PDTPSM', 11 )
            RETURN
         ENDIF
         IDUMMY = 1
         CALL PCHK1MAT( M, 5, M, 5, IA, JA, DESCA, 11, IDUMMY, IDUMMY,
     $                  IDUMMY, INFO )
         IF( INFO.NE.0 ) THEN
            CALL PXERBLA( DESCA( CTXT_ ), 'PDTPSM', 11 )
            RETURN
         ENDIF
         DESCA( DT_ ) = SAVEDT
      ELSE
         SAVEDT = DESCA( DT_ )
         DESCA( DT_ ) = BLOCK_CYCLIC_2D
         CALL CHK1MAT( N, 6, N, 6, IA, JA, DESCA, 11, INFO )
         IF( INFO.NE.0 ) THEN
            CALL PXERBLA( DESCA( CTXT_ ), 'PDTPSM', 11 )
            RETURN
         ENDIF
         IDUMMY = 1
         CALL PCHK1MAT( N, 6, N, 6, IA, JA, DESCA, 11, IDUMMY, IDUMMY,
     $                  IDUMMY, INFO )
         IF( INFO.NE.0 ) THEN
            CALL PXERBLA( DESCA( CTXT_ ), 'PDTPSM', 11 )
            RETURN
         ENDIF
         DESCA( DT_ ) = SAVEDT
      ENDIF
      SAVEDT = DESCB( DT_ )
      DESCB( DT_ ) = BLOCK_CYCLIC_2D
      CALL CHK1MAT( M, 5, N, 6, IB, JB, DESCB, 15, INFO )
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( DESCB( CTXT_ ), 'PDTPSM', 15 )
         RETURN
      ENDIF
      IDUMMY = 1
      CALL PCHK1MAT( M, 5, N, 6, IB, JB, DESCB, 15, IDUMMY, IDUMMY,
     $               IDUMMY, INFO )
      IF( INFO.NE.0 ) THEN
         CALL PXERBLA( DESCB( CTXT_ ), 'PDTPSM', 15 )
         RETURN
      ENDIF
      DESCB( DT_ ) = SAVEDT
*
* Check for quick return;
*
      HASWORK = ( M.GE.1 ) .AND. ( N.GE.1 )
      IF( .NOT.HASWORK ) THEN
         WORK( 1 ) = 0
         RETURN
      ENDIF
      CALL BLACS_PINFO( MYID, NPROC )
      CALL BLACS_GRIDINFO( DESCA( CTXT_ ), NPROW, NPCOL, MYPROW,
     $                     MYPCOL )
      LDA = DESCA( LLD_ )
      LDB = DESCB( LLD_ )
      NOTRANS = LSAME( TRANS, 'N' )
      ISTRANS = ( .NOT.NOTRANS )
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISLEFT = LSAME( SIDE, 'L' )
      ISRIGHT = LSAME( SIDE, 'R' )
      ISDOTUPDATE = ( ISLEFT .AND. ( ( ISLOWER .AND. ISTRANS ) .OR.
     $              ( ISUPPER .AND. ISTRANS ) ) ) .OR.
     $              ( ISRIGHT .AND. ( ( ISLOWER .AND. NOTRANS ) .OR.
     $              ( ISUPPER .AND. NOTRANS ) ) )
      ISTRANSA = ISTRANS
      ISFORWARD = ( ISLEFT .AND. ( ( ISLOWER .AND. NOTRANS ) .OR.
     $            ( ISUPPER .AND. ISTRANS ) ) ) .OR.
     $            ( ISRIGHT .AND. ( ( ISLOWER .AND. ISTRANS ) .OR.
     $            ( ISUPPER .AND. NOTRANS ) ) )
      ISAXPYUPDATE = ( .NOT.ISDOTUPDATE )
      ISBACKWARD = ( .NOT.ISFORWARD )
      NOTRANSA = ( .NOT.ISTRANSA )
      IF( NOTRANSA ) THEN
         TRANSA = 'N'
      ELSE
         TRANSA = 'T'
      ENDIF
      JINC = MAX( DESCA( MB_ ), DESCA( NB_ ) )
*
*
* =====================================
* Basic algorithm:
*
* Use diagonal block to solve part of B.
* Update the rest of B.
* =====================================
*
*
      JINC = DESCA( NB_ )
      IF( ISLEFT ) THEN
         JENDLR = M
         IJOFF = ( IC-1 )
      ELSE
         JENDLR = N
         IJOFF = ( JC-1 )
      ENDIF
      JSTART = 1
      JEND = JENDLR
   10 CONTINUE
      IF( .NOT.( ( ISFORWARD .AND. ( JSTART.GT.JENDLR ) ) .OR.
     $    ( ISBACKWARD .AND. ( JEND.LT.1 ) ) ) ) THEN
*
*
*  Operate on B( jstart:jend,1:n)       for side = 'L'
*  Operate on B( 1:m, jstart:jend)      for side = 'R'
*
*
         IF( ISFORWARD ) THEN
*
*               Attempt to be block aligned.
*
            JA1 = IJOFF + JSTART
            IA1 = JA1
            CALL INFOT( UPLO, IA1, JA1, DESCA, IASTART, JASTART, IAEND,
     $                  JAEND )
            JA1 = MIN( IJOFF+JENDLR, JAEND )
            JEND = MIN( JENDLR, JSTART+JINC-1 )
         ELSE
*
*               Attempt to be block aligned.
*
            JA1 = IJOFF + JEND
            IA1 = JA1
            CALL INFOT( UPLO, IA1, JA1, DESCA, IASTART, JASTART, IAEND,
     $                  JAEND )
            JA1 = MAX( IJOFF+1, JASTART )
            JSTART = JA1 - IJOFF
            JSTART = MAX( 1, MIN( JEND, JSTART ) )
         ENDIF
         JSIZE = JEND - JSTART + 1
*
*       Position of diagonal.
*
         ICPOS = ( IC-1 ) + JSTART
         JCPOS = ( JC-1 ) + JSTART
         IADIAG = ICPOS
         JADIAG = JCPOS
         LROFF = MOD( IADIAG, JINC )
         IF( LROFF.EQ.0 ) THEN
            LROFF = JINC
         ENDIF
         LCOFF = MOD( JADIAG, JINC )
         IF( LCOFF.EQ.0 ) THEN
            LCOFF = JINC
         ENDIF
         IF( ISDOTUPDATE ) THEN
*
*            Perform dot product like computation
*
            IF( ISFORWARD ) THEN
*
*               Reference previously computed
*               solution  B(1:jstart-1)
*
               IBPOS = ( IB-1 ) + 1
               JBPOS = ( JB-1 ) + 1
               IBSIZE = JSTART - 1
            ELSE
               IF( ISBACKWARD ) THEN
*
*               Reference previously computed
*               solution  B( (jend+1):jendLR )
*
                  IF( ISLEFT ) THEN
                     IBPOS = ( IB-1 ) + ( JEND+1 )
                     JBPOS = ( JB-1 ) + 1
                  ELSE
                     IBPOS = ( IB-1 ) + 1
                     JBPOS = ( JB-1 ) + ( JEND+1 )
                  ENDIF
                  IBSIZE = JENDLR - ( JEND+1 ) + 1
               ENDIF
            ENDIF
            IF( ISLOWER ) THEN
               IAPOS = ( IC-1 ) + ( JEND+1 )
               JAPOS = ( JC-1 ) + JSTART
            ELSE
               IAPOS = ( IC-1 ) + 1
               JAPOS = ( JC-1 ) + JSTART
            ENDIF
*
*               Reminder:
*
*               PGEMM: C <- lalpha*op(A)*op(B) + lbeta*C
*
*               C is mm x nn
*
            LALPHA = -ONE
            LBETA = ONE
            IF( ISLEFT ) THEN
               ICPOS = ( IB-1 ) + JSTART
               JCPOS = ( JB-1 ) + 1
               MM = JSIZE
               NN = N
               KK = IBSIZE
            ELSE
               ICPOS = ( IB-1 ) + 1
               JCPOS = ( JB-1 ) + JSTART
               MM = M
               NN = JSIZE
               KK = IBSIZE
            ENDIF
            HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND. ( KK.GE.1 )
            IF( HASWORK ) THEN
               IF( ISLEFT ) THEN
                  CALL DESCINITT( UPLO, IAPOS, JAPOS, DESCA, IA1, JA1,
     $                            LOFFSET1, DESC1 )
                  CALL PDGEMM( TRANSA, 'N', MM, NN, KK, LALPHA,
     $                         A( LOFFSET1 ), IA1, JA1, DESC1, B, IBPOS,
     $                         JBPOS, DESCB, LBETA, B, ICPOS, JCPOS,
     $                         DESCB )
               ELSE
                  CALL DESCINITT( UPLO, IAPOS, JAPOS, DESCA, IA1, JA1,
     $                            LOFFSET1, DESC1 )
                  CALL PDGEMM( 'N', TRANSA, MM, NN, KK, LALPHA, B,
     $                         IBPOS, JBPOS, DESCB, A( LOFFSET1 ), IA1,
     $                         JA1, DESC1, LBETA, B, ICPOS, JCPOS,
     $                         DESCB )
               ENDIF
            ENDIF
         ENDIF
*
*--------------------------------------------------------------
*    Apply inverse(A(jstart:jend,jstart:jend)) to
*               B(jstart:jend,*) for side= 'L'
*    Apply inverse(A(jstart:jend,jstart:jend)) to
*               B(*,jstart:jend) for side= 'R'
*--------------------------------------------------------------
*
         IF( ISLEFT ) THEN
            IBPOS = ( IB-1 ) + JSTART
            JBPOS = ( JB-1 ) + 1
            MM = JSIZE
            NN = N
         ELSE
            IBPOS = ( IB-1 ) + 1
            JBPOS = ( JB-1 ) + JSTART
            MM = M
            NN = JSIZE
         ENDIF
         LALPHA = ONE
         HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 )
*
*               Assume matrices are TRSM aligned.
*
         CALL DESCINITT( UPLO, IADIAG, JADIAG, DESCA, IA1, JA1,
     $                   LOFFSET1, DESC1 )
         CALL PDTRSM( SIDE, UPLO, TRANS, DIAG, MM, NN, LALPHA,
     $                A( LOFFSET1 ), IA1, JA1, DESC1, B, IBPOS, JBPOS,
     $                DESCB )
* ------------------------------------------------------
* use the newly computed X(:) to update the rest of the
* entries in B
* ------------------------------------------------------
         IF( ISAXPYUPDATE ) THEN
*
*           Column update in B
*
            IF( ISFORWARD ) THEN
*
*               The rest of the vector (jend+1):jendLR
*
               IF( ISLEFT ) THEN
                  IBPOS = ( IB-1 ) + ( JEND+1 )
                  JBPOS = ( JB-1 ) + 1
               ELSE
                  IBPOS = ( IB-1 ) + 1
                  JBPOS = ( JB-1 ) + ( JEND+1 )
               ENDIF
               IBSIZE = JENDLR - ( JEND+1 ) + 1
            ELSE
*
*               The rest of the vector 1:(jstart-1)
*
               IBPOS = ( IB-1 ) + 1
               JBPOS = ( JB-1 ) + 1
               IBSIZE = JSTART - 1
            ENDIF
            IF( ISLOWER ) THEN
               IAPOS = ( IC-1 ) + JEND + 1
               JAPOS = ( JC-1 ) + JSTART
            ELSE
               IF( ISUPPER ) THEN
                  IAPOS = ( IC-1 ) + 1
                  JAPOS = ( JC-1 ) + JSTART
               ENDIF
            ENDIF
            LALPHA = -ONE
            LBETA = ONE
            IF( ISLEFT ) THEN
               MM = IBSIZE
               NN = N
               KK = JSIZE
               IIBPOS = ( IB-1 ) + JSTART
               JJBPOS = ( JB-1 ) + 1
            ELSE
               MM = M
               NN = IBSIZE
               KK = JSIZE
               IIBPOS = ( IB-1 ) + 1
               JJBPOS = ( JB-1 ) + JSTART
            ENDIF
            HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND. ( KK.GE.1 )
            IF( HASWORK ) THEN
               IF( ISLEFT ) THEN
                  CALL DESCINITT( UPLO, IAPOS, JAPOS, DESCA, IA1, JA1,
     $                            LOFFSET1, DESC1 )
                  CALL PDGEMM( TRANSA, 'N', MM, NN, KK, LALPHA,
     $                         A( LOFFSET1 ), IA1, JA1, DESC1, B,
     $                         IIBPOS, JJBPOS, DESCB, LBETA, B, IBPOS,
     $                         JBPOS, DESCB )
               ELSE
                  CALL DESCINITT( UPLO, IAPOS, JAPOS, DESCA, IA1, JA1,
     $                            LOFFSET1, DESC1 )
                  CALL PDGEMM( 'N', TRANSA, MM, NN, KK, LALPHA, B,
     $                         IIBPOS, JJBPOS, DESCB, A( LOFFSET1 ),
     $                         IA1, JA1, DESC1, LBETA, B, IBPOS, JBPOS,
     $                         DESCB )
               ENDIF
            ENDIF
         ENDIF
* end if (isaxpyupdate)
* prepare for next iteration
         IF( ISFORWARD ) THEN
            JSTART = JEND + 1
         ELSE
            JEND = JSTART - 1
         ENDIF
         GOTO 10
      ENDIF
   20 CONTINUE
* end while
* -----------------------------------
*  need to rescale the solution by alpha
* -----------------------------------
      IF( ALPHA.NE.ONE ) THEN
         DO 30 JSTART = 1, N
            IBPOS = ( IB-1 ) + 1
            JBPOS = ( JB-1 ) + JSTART
            INC = 1
            CALL PDSCAL( M, ALPHA, B, IBPOS, JBPOS, DESCB, INC )
   30    CONTINUE
   40    CONTINUE
      ENDIF
      RETURN
      END
