#include <stdio.h>
#include <assert.h>
#include <string.h>


#include "pxsp.h"

#ifndef MAX
#define MAX(x,y) (((x) > (y) ) ? (x) : (y))
#endif






pdlamvt_(  uplo, trans, m, n, alpha, 
              A, ia, ja, desc_A, 
              X, ix, jx, desc_X, incx,
        beta, Y, iy, jy, desc_Y, incy )

/*
*  .. Scalar Arguments ..
*/
   F_CHAR      uplo;
   F_CHAR      trans;
   int         * ia, * incx, * incy, * ix, * iy, * ja, * jx, * jy, * n, *m;
   double      * alpha, * beta;
/* ..
*  .. Array Arguments ..
*/
   int         desc_A[], desc_X[], desc_Y[];
   double      A[], X[], Y[];
{



/*
  Purpose
  =======

  PxLAMVT  performs the distributed matrix-vector operation
     sub( Y ) := alpha*sub( A ) * sub( X ) + beta*sub( Y ),

  where sub( A ) denotes A(IA:IA+M-1,JA:JA+N-1),

        sub( X ) denotes X(IX,JX:JX+N-1) if INCX = M_X,
                         X(IX:IX+N-1,JX) if INCX = 1 and INCX <> M_X,

        sub( Y ) denotes Y(IY,JY:JY+N-1) if INCY = M_Y,
                         Y(IY:IY+N-1,JY) if INCY = 1 and INCY <> M_Y.

  alpha and beta are scalars, sub( X ) and sub( Y ) are N element
  distributed vectors and sub( A ) is an N-by-N symmetric distributed
  matrix stored in compressed triangular form.

  Moreover, sub(A) is stored in strict upper part if uplo = 'U'
            sub(A) is stored in strict lower part if uplo = 'L'

  Matrix sub(A) is stored in packed storage.

  Notes
  =====

  Each global data object is described by an associated description
  vector.  This vector stores the information required to establish
  the mapping between an object element and its corresponding process
  and memory location.

  Let A be a generic term for any 2D block cyclicly distributed array.
  Such a global array has an associated description vector descA.
  In the following comments, the character _ should be read as
  "of the global array".

  NOTATION        STORED IN      EXPLANATION
  --------------- -------------- --------------------------------------
  DT_A   (global) descA[ DT_ ]   The descriptor type.  In this case,
                                 DT_A = 1.
  CTXT_A (global) descA[ CTXT_ ] The BLACS context handle, indicating
                                 the BLACS process grid A is distribu-
                                 ted over. The context itself is glo-
                                 bal, but the handle (the integer
                                 value) may vary.
  M_A    (global) descA[ M_ ]    The number of rows in the global
                                 array A.
  N_A    (global) descA[ N_ ]    The number of columns in the global
                                 array A.
  MB_A   (global) descA[ MB_ ]   The blocking factor used to distribu-
                                 te the rows of the array.
  NB_A   (global) descA[ NB_ ]   The blocking factor used to distribu-
                                 te the columns of the array.
  RSRC_A (global) descA[ RSRC_ ] The process row over which the first
                                 row of the array A is distributed.
  CSRC_A (global) descA[ CSRC_ ] The process column over which the
                                 first column of the array A is
                                 distributed.
  LLD_A  (local)  descA[ LLD_ ]  The leading dimension of the local
                                 array.  LLD_A >= MAX(1,LOCr(M_A)).

  Let K be the number of rows or columns of a distributed matrix,
  and assume that its process grid has dimension p x q.
  LOCr( K ) denotes the number of elements of K that a process
  would receive if K were distributed over the p processes of its
  process column.
  Similarly, LOCc( K ) denotes the number of elements of K that a
  process would receive if K were distributed over the q processes of
  its process row.
  The values of LOCr() and LOCc() may be determined via a call to the
  ScaLAPACK tool function, NUMROC:
          LOCr( M ) = NUMROC( M, MB_A, myprow, RSRC_A, NPROW ),
          LOCc( N ) = NUMROC( N, NB_A, mypcol, CSRC_A, NPCOL ).
  An upper bound for these quantities may be computed by:
          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A

  Because vectors may be seen as particular matrices, a distributed
  vector is considered to be a distributed matrix.

  The distributed vectors X and Y must be distributed along the same
  axis, i.e if INCX = M_X then INCY must be equal to M_Y, similarly if
  INCX = 1 and INCX <> M_X, then INCY must be equal to 1. Moreover,
  MB_A = NB_A is required as well as MOD(IA-1,MB_A) = MOD(JA-1,NB_A).

  If INCY = M_Y, the process column having the first entries of
  sub( Y ) must also contain the first block of sub( A ), similarly,
  if INCX = 1 and INCX <> M_X, the process row having the first
  entries of sub( X ) must also contain the first block of sub( A ).

  If INCX = M_X (resp. (INCX = 1 and INCX <> 1) ), the column (resp.
  row) offset of sub( X ) must be equal to the row offset of sub( A ),
  i.e MOD(JX-1,NB_X) (resp. MOD(IX-1,MB_X)) = MOD(JA-1,NB_A). Moreover,
  the column (resp. row) blocksize of X must be equal to the column
  blocksize of A, i.e NB_X = NB_A (resp. MB_X = NB_A).

  If INCY = M_Y (resp. (INCY = 1 and INCY <> M_Y)), the column (resp.
  row) offset of sub( Y ) must be equal to the row offset of sub( A ),
  i.e MOD(JY-1,NB_Y) (resp. MOD(IY-1,MB_Y)) = MOD(IA-1,MB_A). Moreover,
  the column (resp. row) blocksize of Y must be equal to the row
  blocksize of A, i.e NB_Y = MB_A (resp. MB_Y = MB_A).

  Parameters
  ==========

  UPLO    (global input) pointer to CHARACTER
          On entry, UPLO specifies whether the upper or lower
          triangular part of the distributed matrix sub( A ) is to be
          referenced as follows:

             UPLO = 'U' or 'u'   Only the upper triangular part of
                                 sub( A ) is to be referenced.

             UPLO = 'L' or 'l'   Only the lower triangular part of
                                 sub( A ) is to be referenced.

  N       (global input) pointer to INTEGER
          The order of the distributed matrix sub( A ). N >= 0.

  ALPHA   (global input) pointer to DOUBLE PRECISION
          On entry, ALPHA specifies the scalar alpha.

  A       (local input) DOUBLE PRECISION pointer into the local memory
          to an array of dimension (LLD_A,LOCc(JA+N-1) containing the
          local pieces of the distributed matrix sub( A ). Before
          entry with  UPLO = 'U' or 'u', the leading N-by-N upper
          triangular part of the distributed matrix sub( A ) must
          contain the upper triangular part of the symmetric matrix
          contain the upper triangular part of the hermitian matrix
          must contain the lower triangular part of the symmetric
          matrix and the strictly upper triangular part of sub( A )
          is not referenced.

  IA      (global input) pointer to INTEGER
          The global row index of the submatrix of the distributed
          matrix A to operate on.

  JA      (global input) pointer to INTEGER
          The global column index of the submatrix of the distributed
          matrix A to operate on.

  DESCA   (global and local input) INTEGER array of dimension 8.
          The array descriptor of the distributed matrix A.

  X       (local input) DOUBLE PRECISION array containing the local
          pieces of a distributed matrix of dimension of at least
                  ( (JX-1)*M_X + IX + ( N - 1 )*abs( INCX ) )
          This array contains the entries of the distributed vector
          sub( X ).

  IX      (global input) pointer to INTEGER
          The global row index of the submatrix of the distributed
          matrix X to operate on.

  JX      (global input) pointer to INTEGER
          The global column index of the submatrix of the distributed
          matrix X to operate on.

  DESCX   (global and local input) INTEGER array of dimension 8.
          The array descriptor of the distributed matrix X.

  INCX    (global input) pointer to INTEGER
          The global increment for the elements of X. Only two values
          of INCX are supported in this version, namely 1 and M_X.

  BETA    (global input) pointer to DOUBLE PRECISION
          On entry,  BETA  specifies the scalar  beta.  When  BETA  is
          supplied as zero then sub( Y ) need not be set on input.

  Y       (local input/local output) DOUBLE PRECISION array
          containing the local pieces of a distributed matrix of
          dimension of at least
                ( (JY-1)*M_Y + IY + ( N - 1 )*abs( INCY ) )
          This array contains the entries of the distributed vector
          sub( Y ).  On exit, sub( Y ) is overwritten by the updated
          distributed vector sub( Y ).

  IY      (global input) pointer to INTEGER
          The global row index of the submatrix of the distributed
          matrix Y to operate on.

  JY      (global input) pointer to INTEGER
          The global column index of the submatrix of the distributed
          matrix Y to operate on.

  DESCY   (global and local input) INTEGER array of dimension 8.
          The array descriptor of the distributed matrix Y.

  INCY    (global input) pointer to INTEGER
          The global increment for the elements of Y. Only two values
          of INCY are supported in this version, namely 1 and M_Y.

  =====================================================================
*/

  extern void pdlamvtf_();

  double *work;
  int ineed, lwork;

  work = (double *) malloc( sizeof(double) ); lwork = -1;
  assert( work != 0 );

  pdlamvtf_( uplo, trans, m, n, alpha, 
               A, ia, ja, desc_A, 
               X, ix, jx, desc_X, incx,
	 beta, Y, iy, jy, desc_Y, incy, 
               work, &lwork );


  ineed = (int) work[0];


  ineed = 1+MAX(1, ineed );

  free(work);
  work = (double *)  malloc( sizeof(double) * (ineed+1) );
  assert( work != NULL );

  lwork = ineed;


  pdlamvtf_( uplo, trans, m, n, alpha, 
                A, ia, ja, desc_A, 
                X, ix, jx, desc_X, incx,
	  beta, Y, iy, jy, desc_Y, incy, 
                work, &lwork );

  free( work );

}



