      SUBROUTINE PCTPMMF( SIDE, UPLO, TRANSA, DIAG, M, N, ALPHA, A, IA,
     $                    JA, DESCA, B, IB, JB, DESCB, WORK, LWORK,
     $                    INFO )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* PTPMM performs one of the distributed matrix-matrix operations
*
*    sub( B ) := alpha*op( sub( A ) )*sub( B ),
*
* where sub( A ) denotes A(IA:IA+M-1,JA:JA+M-1)  if SIDE = 'L',
*       sub( A ) denotes A(IA:IA+N-1,JA:JA+N-1)  if SIDE = 'R',
*
*       sub( B ) denotes B(IB:IB+M-1,JB:JB+N-1),
*
* alpha is a scalar, sub( B ) is an M-by-N distributed matrix, sub( A )
* is a unit, or non-unit, upper or lower triangular distributed matrix
* and op( A ) is one of
*
*    op( A ) = A   or   op( A ) = A'   or   op( A ) = conjg( A' ).
*
* Matrix A stored in packed storage.
*
* Notes
* =====
*
* Each global data object is described by an associated description
* vector.  This vector stores the information required to establish
* the mapping between an object element and its corresponding process
* and memory location.
*
* Let A be a generic term for any 2D block cyclicly distributed array.
* Such a global array has an associated description vector descA.
* In the following comments, the character _ should be read as
* "of the global array".
*
* NOTATION        STORED IN      EXPLANATION
* --------------- -------------- --------------------------------------
* DT_A   (global) descA[ DT_ ]   The descriptor type.  In this case,
*                                DT_A = 1.
* CTXT_A (global) descA[ CTXT_ ] The BLACS context handle, indicating
*                                the BLACS process grid A is distribu-
*                                ted over. The context itself is glo-
*                                bal, but the handle (the integer
*                                value) may vary.
* M_A    (global) descA[ M_ ]    The number of rows in the global
*                                array A.
* N_A    (global) descA[ N_ ]    The number of columns in the global
*                                array A.
* MB_A   (global) descA[ MB_ ]   The blocking factor used to distribu-
*                                te the rows of the array.
* NB_A   (global) descA[ NB_ ]   The blocking factor used to distribu-
*                                te the columns of the array.
* RSRC_A (global) descA[ RSRC_ ] The process row over which the first
*                                row of the array A is distributed.
* CSRC_A (global) descA[ CSRC_ ] The process column over which the
*                                first column of the array A is
*                                distributed.
* LLD_A  (local)  descA[ LLD_ ]  The leading dimension of the local
*                                array.  LLD_A >= MAX(1,LOCr(M_A)).
*
* Let K be the number of rows or columns of a distributed matrix,
* and assume that its process grid has dimension p x q.
* LOCr( K ) denotes the number of elements of K that a process
* would receive if K were distributed over the p processes of its
* process column.
* Similarly, LOCc( K ) denotes the number of elements of K that a
* process would receive if K were distributed over the q processes of
* its process row.
* The values of LOCr() and LOCc() may be determined via a call to the
* ScaLAPACK tool function, NUMROC:
*         LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*         LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
* An upper bound for these quantities may be computed by:
*         LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*         LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
* The triangular distributed matrix sub( A ) must be distributed
* according to a square block cyclic decomposition, i.e MB_A = NB_A, if
* NA+MOD(IA-1,MB_A) > MB_A or NA+MOD(JA-1,NB_A) > NB_A.
* If SIDE = 'Left', the distributed matrix sub( A ) is of order NA = M,
* and NA = N if SIDE = 'Right'. If NA+MOD(IA-1,MB_A) > MB_A or
* NA+MOD(JA-1,NB_A) > NB_A, then sub( A ) is not just contained into a
* block, in which case IA-1 (resp. JA-1) must be a multiple of MB_A
* (resp. NB_A).
*
* If SIDE = 'L', the row process having the first entries of sub( B )
* must also own the first entries of sub( A ).
* If sub( A ) is not just contained into a block, IB-1 (resp. IA-1,
* JA-1) must be a multiple of MB_B (resp. MB_A, NB_A = MB_A), and
* the column block size of A should be equal to the row block size of
* B, i.e NB_A = MB_B.
*
* If SIDE = 'R', the column process having the first entries of
* sub( B ) must also own the first entries of sub( A ).
* If sub( A ) is not just contained into a block, JB-1 (resp. IA-1,
* JA-1) must be a multiple of NB_B (resp. MB_A, NB_A = MB_A), and
* the row block size of A should be equal to the column block size of
* B, i.e NB_A = MB_B.
*
* Parameters
* ==========
*
* SIDE    (global input) pointer to CHARACTER
*         On entry, SIDE specifies whether  op( sub( A ) ) multiplies
*         sub( B ) from the left or right as follows:
*
*         SIDE = 'L' or 'l'  sub( B ) := alpha*op( sub( A ) )*sub( B ),
*
*         SIDE = 'R' or 'r'  sub( B ) := alpha*sub( B )*op( sub( A ) ).
*
* UPLO    (global input) pointer to CHARACTER
*         On entry, UPLO specifies whether the distributed matrix
*         sub( A ) is an upper or lower triangular distributed matrix
*         as follows:
*
*         UPLO = 'U' or 'u'  sub( A ) is an upper triangular
*                            distributed matrix,
*
*         UPLO = 'L' or 'l'  sub( A ) is a lower triangular
*                            distributed matrix.
*
* TRANSA  (global input) pointer to CHARACTER
*         On entry, TRANSA specifies the form of op( A ) to be
*         used in the matrix multiplication as follows:
*
*         TRANSA = 'N' or 'n'   op( A ) = A,
*
*         TRANSA = 'T' or 't'   op( A ) = A',
*
*         TRANSA = 'C' or 'c'   op( A ) = conjg( A' ).
*
* DIAG    (global input) pointer to CHARACTER
*         On entry, DIAG specifies whether or not sub( A ) is unit
*         triangular as follows:
*
*         DIAG = 'U' or 'u'  sub( A ) is assumed to be unit
*                            triangular,
*
*         DIAG = 'N' or 'n'  sub( A ) is not assumed to be unit
*                            triangular.
*
* M       (global input) pointer to INTEGER
*         The number of rows to be operated on i.e the number of rows
*         of the distributed submatrix sub( B ). M >= 0.
*
* N       (global input) pointer to INTEGER
*         The number of columns to be operated on i.e the number of
*         columns of the distributed submatrix sub( B ). N >= 0.
*
* ALPHA   (global input) pointer to DTYPE
*         On entry, ALPHA specifies the scalar alpha.
*
* A       (local input) DTYPE pointer into the local memory
*         to an array of dimension (LLD_A, LOCc(JA+NA-1). Before entry
*         with  UPLO = 'U' or 'u', the  leading NA-by-NA upper trian-
*         gular part of the distributed matrix sub( A ) must contain
*         the local pieces of the upper triangular distributed matrix
*         and its strictly lower triangular part is not referenced.
*         Before entry  with  UPLO = 'L' or 'l', the leading  NA-by-NA
*         lower triangular part of the distributed matrix sub( A ) must
*         contain the lower triangular distributed matrix and its
*         strictly upper triangular part is not referenced.  Note that
*         when  DIAG = 'U' or 'u', the diagonal elements of sub( A )
*         are not referenced either, but are assumed to be  unity.
*
* IA      (global input) pointer to INTEGER
*         The global row index of the submatrix of the distributed
*         matrix A to operate on.
*
* JA      (global input) pointer to INTEGER
*         The global column index of the submatrix of the distributed
*         matrix A to operate on.
*
* DESCA   (global and local input) INTEGER array of dimension 8.
*         The array descriptor of the distributed matrix A.
*
* B       (local input/local output) DTYPE pointer into the
*         local memory to an array of dimension (LLD_B, LOCc(JB+N-1)).
*         Before entry, this array contains the local pieces of the
*         distributed matrix sub( B ). On exit, sub( B ) is overwritten
*         by the transformed distributed matrix.
*
* IB      (global input) pointer to INTEGER
*         The global row index of the submatrix of the distributed
*         matrix B to operate on.
*
* JB      (global input) pointer to INTEGER
*         The global column index of the submatrix of the distributed
*         matrix B to operate on.
*
* DESCB   (global and local input) INTEGER array of dimension 8.
*         The array descriptor of the distributed matrix B.
*
*===================================================
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, MB_, NB_
      PARAMETER          ( CTXT_ = 2, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          DIAG, SIDE, TRANSA, UPLO
      INTEGER            IA, IB, INFO, JA, JB, LWORK, M, N
      COMPLEX            ALPHA
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( * ), DESCB( * )
      COMPLEX            A( * ), B( * ), WORK( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            HASWORK, ISBACKWARD, ISCOLOP, ISFORWARD,
     $                   ISLEFT, ISLOWER, ISRIGHT, ISROWOP, ISTRANSA,
     $                   ISUPPER, ISVALID, NOTRANSA
      CHARACTER*12       TRANSB
      INTEGER            CONTEXT, IA1, IAROW, ICOFF, IDIAG, IEND, IIA,
     $                   IIB, INEED, INEED0, IROFF, ISIZE, ISTART, JA1,
     $                   JACOL, JDIAG, JEND, JJA, JJB, JSIZE, JSTART,
     $                   KK, LLD, LOCQ, LOFFSET1, MM, MYCOL, MYROW, NA,
     $                   NB, NN, NPCOL, NPROW, WORKNEED
      COMPLEX            CONE
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ ), DESCWORK( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INDXG2P, INFOMEM, NUMROC
      EXTERNAL           LSAME, INDXG2P, INFOMEM, NUMROC
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_GRIDINFO, DESCINIT, DESCINITT, PCGEMM,
     $                   PCLACPT2, PCSCAL, PCTRMM, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CMPLX, MAX, MIN, MOD, REAL
*     ..
*     .. Executable Statements ..
*
*       Row operation require temporary storage
*       to hold block row.
*
*       Col operation can be performed in place.
*
*
*       B <- L*B        backward, row operation
*       B <- L'*B       forward,  col operation
*       B <- U*B        forward,  row operation
*       B <- U'*B       backward, col operation
*
*       B <- B*L        forward,  col operation
*       B <- B*L'       backward, row operation
*       B <- B*U        backward, col operation
*       B <- B*U'       forward,  row operation
*
      CONTEXT = DESCA( CTXT_ )
      CALL BLACS_GRIDINFO( CONTEXT, NPROW, NPCOL, MYROW, MYCOL )
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISVALID = ISLOWER .OR. ISUPPER
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTEXT, 'PxTPMMF', 2 )
         INFO = -2
         RETURN
      ENDIF
      ISLEFT = LSAME( SIDE, 'Left' )
      ISRIGHT = LSAME( SIDE, 'Right' )
      ISVALID = ISLEFT .OR. ISRIGHT
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( CONTEXT, 'PxTPMMF', 1 )
         INFO = -1
         RETURN
      ENDIF
      NB = DESCA( NB_ )
      IF( ISLEFT ) THEN
         NA = M
      ELSE
         NA = N
      ENDIF
      ISTRANSA = LSAME( TRANSA, 'T' ) .OR. LSAME( TRANSA, 'C' )
      NOTRANSA = .NOT.ISTRANSA
      ISFORWARD = ( ISLEFT .AND. ISLOWER .AND. ISTRANSA ) .OR.
     $            ( ISLEFT .AND. ISUPPER .AND. NOTRANSA ) .OR.
     $            ( ISRIGHT .AND. ISLOWER .AND. NOTRANSA ) .OR.
     $            ( ISRIGHT .AND. ISUPPER .AND. ISTRANSA )
      ISBACKWARD = ( ISLEFT .AND. ISLOWER .AND. NOTRANSA ) .OR.
     $             ( ISLEFT .AND. ISUPPER .AND. ISTRANSA ) .OR.
     $             ( ISRIGHT .AND. ISLOWER .AND. ISTRANSA ) .OR.
     $             ( ISRIGHT .AND. ISUPPER .AND. NOTRANSA )
      ISVALID = ( ISFORWARD .AND. ( .NOT.ISBACKWARD ) ) .OR.
     $          ( ( .NOT.ISFORWARD ) .AND. ISBACKWARD )
      ISCOLOP = ( ISLEFT .AND. ISLOWER .AND. ISTRANSA ) .OR.
     $          ( ISLEFT .AND. ISUPPER .AND. ISTRANSA ) .OR.
     $          ( ISRIGHT .AND. ISLOWER .AND. NOTRANSA ) .OR.
     $          ( ISRIGHT .AND. ISUPPER .AND. NOTRANSA )
      ISROWOP = ( ISLEFT .AND. ISLOWER .AND. NOTRANSA ) .OR.
     $          ( ISLEFT .AND. ISUPPER .AND. NOTRANSA ) .OR.
     $          ( ISRIGHT .AND. ISLOWER .AND. ISTRANSA ) .OR.
     $          ( ISRIGHT .AND. ISUPPER .AND. ISTRANSA )
      ISVALID = ( ISCOLOP .AND. ( .NOT.ISROWOP ) ) .OR.
     $          ( ( .NOT.ISCOLOP ) .AND. ISROWOP )
      IROFF = MOD( DESCA( MB_ )+IA-1, DESCA( MB_ ) )
      ICOFF = MOD( DESCA( NB_ )+JA-1, DESCA( NB_ ) )
      IF( ISCOLOP ) THEN
*
*     No need to touch work(*)
*
         INEED0 = 1
         INEED = INEED0
      ELSE
*
*     Need to hold a block row.
*
         LOCQ = NUMROC( NA+ICOFF, NB, MYCOL, MYCOL, NPCOL )
         INEED0 = MAX( 1, LOCQ*NB )
         INEED = INEED0
      ENDIF
      IF( LWORK.LT.INEED ) THEN
         IF( LWORK.NE.-1 ) THEN
            CALL PXERBLA( CONTEXT, 'PxTPMMF', 17 )
         ENDIF
         WORK( 1 ) = INEED
         RETURN
      ENDIF
      INEED = 1
      CONE = CMPLX( REAL( 1 ) )
      IF( ISFORWARD ) THEN
         JSTART = JA
   10    CONTINUE
         IF( JSTART.LE.JA+NA-1 ) THEN
            JEND = JSTART - MOD( JSTART-1+NB, NB ) + ( NB-1 )
            JEND = MIN( JEND, JA+NA-1 )
            JSIZE = JEND - JSTART + 1
            JDIAG = JSTART
            IDIAG = IA + ( JSTART-JA )
            ISTART = IDIAG + JSIZE
            IEND = IA + NA - 1
            ISIZE = IEND - ISTART + 1
*
*           Handle diagonal block.
*
            CALL DESCINITT( UPLO, IDIAG, JDIAG, DESCA, IA1, JA1,
     $                      LOFFSET1, DESC1 )
            IF( ISLEFT ) THEN
               IIB = IB + ( JSTART-JA )
               JJB = JB
               MM = JSIZE
               NN = N
            ELSE
               IIB = IB
               JJB = JB + ( JSTART-JA )
               MM = M
               NN = JSIZE
            ENDIF
            CALL PCTRMM( SIDE, UPLO, TRANSA, DIAG, MM, NN, CONE,
     $                   A( LOFFSET1 ), IA1, JA1, DESC1, B, IIB, JJB,
     $                   DESCB )
*
*          Update SAME block with
*           off-diagonal contribution.
*
            IF( ISCOLOP ) THEN
*
*                Use column data in place.
*
               IF( ISLEFT ) THEN
*
*                         B <- B + A*B
*
                  TRANSB = 'No transpose'
                  MM = JSIZE
                  NN = N
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL DESCINITT( UPLO, ISTART, JSTART, DESCA, IA1,
     $                               JA1, LOFFSET1, DESC1 )
                     CALL PCGEMM( TRANSA, TRANSB, MM, NN, KK, CONE,
     $                            A( LOFFSET1 ), IA1, JA1, DESC1, B,
     $                            IIB+JSIZE, JJB, DESCB, CONE, B, IIB,
     $                            JJB, DESCB )
                  ENDIF
               ELSE
*
*                         B <- B + B*A
*
                  TRANSB = 'No transpose'
                  MM = M
                  NN = JSIZE
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL DESCINITT( UPLO, ISTART, JSTART, DESCA, IA1,
     $                               JA1, LOFFSET1, DESC1 )
                     CALL PCGEMM( TRANSB, TRANSA, MM, NN, KK, CONE, B,
     $                            IIB, JJB+JSIZE, DESCB, A( LOFFSET1 ),
     $                            IA1, JA1, DESC1, CONE, B, IIB, JJB,
     $                            DESCB )
                  ENDIF
               ENDIF
            ELSE
*
*               Row operation.
*               Need to copy block row data
*                into temporary work space.
*
               IIA = IDIAG
               JJA = JDIAG + JSIZE
               MM = JSIZE
               NN = ISIZE
               HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 )
               IF( HASWORK ) THEN
                  IROFF = MOD( IIA-1, DESCA( MB_ ) )
                  ICOFF = MOD( JJA-1, DESCA( NB_ ) )
                  IAROW = INDXG2P( IIA, DESCA( MB_ ), MYROW,
     $                    DESCA( RSRC_ ), NPROW )
                  JACOL = INDXG2P( JJA, DESCA( NB_ ), MYCOL,
     $                    DESCA( CSRC_ ), NPCOL )
                  LLD = MAX( 1, DESCA( MB_ ) )
                  CALL DESCINIT( DESCWORK, MM+IROFF, NN+ICOFF,
     $                           DESCA( MB_ ), DESCA( NB_ ), IAROW,
     $                           JACOL, CONTEXT, LLD, INFO )
                  WORKNEED = INFOMEM( DESCWORK )
                  INEED = MAX( INEED, WORKNEED )
                  CALL PCLACPT2( UPLO, MM, NN, A, IIA, JJA, DESCA, WORK,
     $                           1+IROFF, 1+ICOFF, DESCWORK )
               ENDIF
               IF( ISLEFT ) THEN
*
*                        B <- B + A*B
*
                  TRANSB = 'No Transpose'
                  MM = JSIZE
                  NN = N
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL PCGEMM( TRANSA, TRANSB, MM, NN, KK, CONE,
     $                            WORK, 1+IROFF, 1+ICOFF, DESCWORK, B,
     $                            IIB+JSIZE, JJB, DESCB, CONE, B, IIB,
     $                            JJB, DESCB )
                  ENDIF
               ELSE
*
*                         B <- B + B*A
*
                  TRANSB = 'No Transpose'
                  MM = M
                  NN = JSIZE
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL PCGEMM( TRANSB, TRANSA, MM, NN, KK, CONE, B,
     $                            IIB, JJB+JSIZE, DESCB, WORK, 1+IROFF,
     $                            1+ICOFF, DESCWORK, CONE, B, IIB, JJB,
     $                            DESCB )
                  ENDIF
               ENDIF
            ENDIF
            JSTART = JEND + 1
            GOTO 10
         ENDIF
   20    CONTINUE
* end while
      ELSE
*
*      Backward.
*
         JEND = JA + NA - 1
   30    CONTINUE
         IF( JEND.GE.JA ) THEN
            JSTART = JEND - MOD( JEND-1+NB, NB )
            JSTART = MAX( JSTART, JA )
            JSIZE = JEND - JSTART + 1
            JDIAG = JSTART
            IDIAG = IA + ( JSTART-JA )
            ISTART = IA
            IEND = IDIAG - 1
            ISIZE = IEND - ISTART + 1
*
*           Handle diagonal block.
*
            CALL DESCINITT( UPLO, IDIAG, JDIAG, DESCA, IA1, JA1,
     $                      LOFFSET1, DESC1 )
            IF( ISLEFT ) THEN
               IIB = IB + ( JSTART-JA )
               JJB = JB
               MM = JSIZE
               NN = N
            ELSE
               IIB = IB
               JJB = JB + ( JSTART-JA )
               MM = M
               NN = JSIZE
            ENDIF
            CALL PCTRMM( SIDE, UPLO, TRANSA, DIAG, MM, NN, CONE,
     $                   A( LOFFSET1 ), IA1, JA1, DESC1, B, IIB, JJB,
     $                   DESCB )
*
*           Update SAME diagonal block
*           with off-diagonal contributions.
*
            IF( ISCOLOP ) THEN
*
*             Use data in place.
*
               IF( ISLEFT ) THEN
*
*                 B <- B + A*B
*
                  TRANSB = 'No Transpose'
                  MM = JSIZE
                  NN = N
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL DESCINITT( UPLO, ISTART, JSTART, DESCA, IA1,
     $                               JA1, LOFFSET1, DESC1 )
                     CALL PCGEMM( TRANSA, TRANSB, MM, NN, KK, CONE,
     $                            A( LOFFSET1 ), IA1, JA1, DESC1, B, IB,
     $                            JB, DESCB, CONE, B, IIB, JJB, DESCB )
                  ENDIF
               ELSE
*
*                 B <- B + B*A
*
                  TRANSB = 'No Transpose'
                  MM = M
                  NN = JSIZE
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL DESCINITT( UPLO, ISTART, JSTART, DESCA, IA1,
     $                               JA1, LOFFSET1, DESC1 )
                     CALL PCGEMM( TRANSB, TRANSA, MM, NN, KK, CONE, B,
     $                            IB, JB, DESCB, A( LOFFSET1 ), IA1,
     $                            JA1, DESC1, CONE, B, IIB, JJB, DESCB )
                  ENDIF
               ENDIF
            ELSE
*
*               Row operation.
*               Need to copy block row data
*               into temporary work space.
*
               IIA = IDIAG
               JJA = JA
               MM = JSIZE
               NN = ISIZE
               HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 )
               IF( HASWORK ) THEN
                  IROFF = MOD( DESCA( MB_ )+IIA-1, DESCA( MB_ ) )
                  ICOFF = MOD( DESCA( NB_ )+JJA-1, DESCA( NB_ ) )
                  IAROW = INDXG2P( IIA, DESCA( MB_ ), MYROW,
     $                    DESCA( RSRC_ ), NPROW )
                  JACOL = INDXG2P( JJA, DESCA( NB_ ), MYCOL,
     $                    DESCA( CSRC_ ), NPCOL )
                  LLD = MAX( 1, DESCA( MB_ ) )
                  CALL DESCINIT( DESCWORK, MM+IROFF, NN+ICOFF,
     $                           DESCA( MB_ ), DESCA( NB_ ), IAROW,
     $                           JACOL, CONTEXT, LLD, INFO )
                  WORKNEED = INFOMEM( DESCWORK )
                  INEED = MAX( INEED, WORKNEED )
                  CALL PCLACPT2( UPLO, MM, NN, A, IIA, JJA, DESCA, WORK,
     $                           1+IROFF, 1+ICOFF, DESCWORK )
               ENDIF
               IF( ISLEFT ) THEN
*
*                    B <- B + A*B
*
                  TRANSB = 'No Transpose'
                  MM = JSIZE
                  NN = N
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL PCGEMM( TRANSA, TRANSB, MM, NN, KK, CONE,
     $                            WORK, 1+IROFF, 1+ICOFF, DESCWORK, B,
     $                            IB, JB, DESCB, CONE, B, IIB, JJB,
     $                            DESCB )
                  ENDIF
               ELSE
*
*                     B <- B + B*A
*
                  TRANSB = 'No Transpose'
                  MM = M
                  NN = JSIZE
                  KK = ISIZE
                  HASWORK = ( MM.GE.1 ) .AND. ( NN.GE.1 ) .AND.
     $                      ( KK.GE.1 )
                  IF( HASWORK ) THEN
                     CALL PCGEMM( TRANSB, TRANSA, MM, NN, KK, CONE, B,
     $                            IB, JB, DESCB, WORK, 1+IROFF, 1+ICOFF,
     $                            DESCWORK, CONE, B, IIB, JJB, DESCB )
                  ENDIF
               ENDIF
            ENDIF
            JEND = JSTART - 1
            GOTO 30
         ENDIF
   40    CONTINUE
*
*             end while
*
      ENDIF
      IF( ALPHA.NE.CONE ) THEN
*
*        Rescale solution.
*
         DO 50 JSTART = JB, JB + N - 1
            CALL PCSCAL( M, ALPHA, B, IB, JSTART, DESCB, 1 )
   50    CONTINUE
   60    CONTINUE
      ENDIF
      WORK( 1 ) = CMPLX( REAL( MAX( 1, INEED ) ) )
      RETURN
      END
