      PROGRAM PCPPDRIVER
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
* Purpose
* =======
*
* PxPPDRIVER is the main test program for the Cholesky routines
* with packed storage. This test driver performs a
* A = L*L^H or A = U*U^H factorization and solve.
*
* The program must be driven by a short data file. An annotated
* example of a data file can be obtained by deleting the first 2
* characters from the following 18 lines:
* 'ScaLAPACK LLt factorization input file'
* 'Intel iPSC/860 hypercube, gamma model.'
* 'LLT.out'            output file name (if any)
*  6                    device out
* 'U'                  define Lower or Upper
*  1                    number of problems sizes
*  31 100 200           values of N
*  1                    number of NBs
*  2 10 24              values of NB
*  1                    number of NRHSs
*  1                    values of NRHS
*  1                    Number of NBRHSs
*  1                    values of NBRHS
*  1                    number of process grids (ordered pairs of P & Q)
*  2                    values of P
*  2                    values of Q
*  1.0                  theshold
*
*
* Internal Parameters
* ===================
*
* TOTMEM   INTEGER, default = 2000000
*          TOTMEM is a machine-specific parameter indicating the
*          maximum amount of available memory in bytes.
*          The user should customize TOTMEM to his platform.  Remember
*          to leave room in memory for the operating system, the BLACS
*          buffer, etc.  For example, on a system with 8 MB of memory
*          per process (e.g., one processor on an Intel iPSC/860), the
*          parameters we use are TOTMEM=6200000 (leaving 1.8 MB for OS,
*          code, BLACS buffer, etc).  However, for PVM, we usually set
*          TOTMEM = 2000000.  Some experimenting with the maximum value
*          of TOTMEM may be required.
*
* INTGSZ   INTEGER, default = 4 bytes.
* DBLESZ   INTEGER, default = 8 bytes.
*          INTGSZ and DBLESZ indicate the length in bytes on the
*          given platform for an integer and a double precision real.
* MEM      DOUBLE PRECISION array, dimension ( TOTMEM / DBLESZ )
*
*          All arrays used by SCALAPACK routines are allocated from
*          this array and referenced by pointers.  The integer IPA,
*          for example, is a pointer to the starting element of MEM for
*          the matrix A.
*
* =====================================================================
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            M_, N_, MB_, NB_
      PARAMETER          ( M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
      INTEGER            RSRC_, CSRC_, LLD_
      PARAMETER          ( RSRC_ = 7, CSRC_ = 8, LLD_ = 9 )
      INTEGER            DBLESZ, TOTMEM
      PARAMETER          ( DBLESZ = 8, TOTMEM = 10*2000000 )
      INTEGER            MEMSIZ
      PARAMETER          ( MEMSIZ = TOTMEM / DBLESZ )
      INTEGER            MAXCASES
      PARAMETER          ( MAXCASES = 80 )
      INTEGER            LDNBRVAL, LDNBVAL, LDNRVAL
      PARAMETER          ( LDNBRVAL = MAXCASES, LDNBVAL = MAXCASES,
     $                   LDNRVAL = MAXCASES )
      INTEGER            LDNVAL, LDPQVAL
      PARAMETER          ( LDNVAL = MAXCASES, LDPQVAL = MAXCASES )
      INTEGER            NIN
      PARAMETER          ( NIN = 5 )
      INTEGER            MAXN
      PARAMETER          ( MAXN = 50*1000 )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER
      CHARACTER          UPLO
      CHARACTER*6        PASSED
      CHARACTER*9        CSYMM
      CHARACTER*80       SUMMRY, USRINFO
      INTEGER            CSRC, HH, I, IAM, IASEED, IBSEED, ICNUM, ICOFF,
     $                   ICTXT, IEND, IERR, IFREE, IFREE_HH, IFREE_I,
     $                   IFREE_J, IFREE_K, IFREE_KK, IIA, INFO, IPA,
     $                   IPAP, IPB, IPBP, IPX, IPXP, IRNUM, IROFF,
     $                   ISTART, IVALUE, J, JA, JB, JJA, K, KFAIL, KK,
     $                   KPASS, KSKIP, LDA, LDB, LOFFSET, MB, MYCOL,
     $                   MYPCOL, MYPROW, MYROW, N, NB, NBR, NBRHS,
     $                   NGRIDS, NMAT, NNB, NNBR, NNR, NOUT, NP, NPCOL,
     $                   NPROCS, NPROW, NQ, NRHS, RSRC, SIZEA, SIZEAP,
     $                   SIZEB, SIZEBP, SIZEX, SIZEXP
      REAL               ANORM, ANORMP, BERR, BNORM, MACHEPS, SRESID,
     $                   SRESIDP, THRESH, XERR, XNORM
      COMPLEX            ALPHA, ONE, ZERO
      DOUBLE PRECISION   NOPS, TMFLOPS, TMPFLOPS
*     ..
*     .. Local Arrays ..
      INTEGER            DESCA( DLEN_ ), DESCAP( DLEN_ ),
     $                   DESCB( DLEN_ ), DESCBP( DLEN_ ),
     $                   DESCNEW( DLEN_ ), DESCX( DLEN_ ),
     $                   DESCXP( DLEN_ ), NBRVAL( LDNBRVAL ),
     $                   NBVAL( LDNBVAL ), NRVAL( LDNRVAL ),
     $                   NVAL( LDNVAL ), PVAL( LDPQVAL ),
     $                   QVAL( LDPQVAL )
      REAL               RWORK( MAXN )
      COMPLEX            MEM( MEMSIZ )
      DOUBLE PRECISION   CTIME( 64 ), WTIME( 64 )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      INTEGER            INFOMEM, INFOMEMT, NUMROC
      REAL               PCLANGE, PCLANHE, PCLANHP, PSLAMCH
      EXTERNAL           LSAME, INFOMEM, INFOMEMT, NUMROC, PCLANGE,
     $                   PCLANHE, PCLANHP, PSLAMCH
*     ..
*     .. External Subroutines ..
      EXTERNAL           BLACS_ABORT, BLACS_BARRIER, BLACS_EXIT,
     $                   BLACS_GET, BLACS_GRIDEXIT, BLACS_GRIDINFO,
     $                   BLACS_GRIDINIT, BLACS_PINFO, BLACS_SETUP,
     $                   DESCINIT, DESCINITT, ICOPY, IGEBR2D, IGEBS2D,
     $                   IGSUM2D, PCAXPY, PCCOPY, PCLASCHK, PCMATGEN,
     $                   PCPOTRF, PCPOTRS, PCPPTRF, PCPPTRS, SGEBR2D,
     $                   SGEBS2D, SLBOOT, SLCOMBINE, SLTIMER
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          CHAR, CMPLX, DBLE, ICHAR, MAX, REAL
*     ..
*     .. Executable Statements ..
      ONE = CMPLX( REAL( 1 ) )
      ZERO = CMPLX( REAL( 0 ) )
      DO 10 I = 1, MAXN
         RWORK( I ) = REAL( 0 )
   10 CONTINUE
   20 CONTINUE
      CALL BLACS_PINFO( IAM, NPROCS )
      IASEED = 100
      IBSEED = 200
      KSKIP = 0
      KPASS = 0
      KFAIL = 0
*
*   Read in information.
*
*
*      Process 0 reads the input data, broadcasts to other processes and
*      writes needed information to NOUT
*
      IF( IAM.EQ.0 ) THEN
         OPEN( NIN, FILE = 'LLT.dat', STATUS = 'old' )
         REWIND ( NIN )
         READ( NIN, FMT = '(A)' )SUMMRY
         SUMMRY = ' '
         READ( NIN, FMT = '(A)' )USRINFO
*
*       Read name and unit number for summary output file
*
         READ( NIN, FMT = * )SUMMRY
         READ( NIN, FMT = * )NOUT
         IF( ( NOUT.NE.0 ) .AND. ( NOUT.NE.6 ) ) THEN
            OPEN( NOUT, FILE = SUMMRY, STATUS = 'unknown' )
            REWIND ( NOUT )
         ENDIF
*
*       Read and check the parameter values for the tests.
*
         READ( NIN, FMT = * )UPLO
         READ( NIN, FMT = * )NMAT
         IF( ( NMAT.LT.1 ) .OR. ( NMAT.GT.LDNVAL ) ) THEN
            WRITE( NOUT, FMT = 9992 )'n', LDNVAL
            GOTO 210
         ENDIF
         READ( NIN, FMT = * )( NVAL( I ), I = 1, NMAT )
*
*       Get values of nb.
*
         READ( NIN, FMT = * )NNB
         IF( ( NNB.LT.1 ) .OR. ( NMAT.GT.LDNBVAL ) ) THEN
            WRITE( NOUT, FMT = 9992 )'nb', LDNBVAL
            GOTO 210
         ENDIF
         READ( NIN, FMT = * )( NBVAL( I ), I = 1, NNB )
*
*        Get values of nrhs.
*
         READ( NIN, FMT = * )NNR
         IF( ( NNR.LT.1 ) .OR. ( NNR.GT.LDNRVAL ) ) THEN
            WRITE( NOUT, FMT = 9992 )'nrhs', LDNRVAL
            GOTO 210
         ENDIF
         READ( NIN, FMT = * )( NRVAL( I ), I = 1, NNR )
*
*       Get values of nbrhs.
*
         READ( NIN, FMT = * )NNBR
         IF( ( NNBR.LT.1 ) .OR. ( NNBR.GT.LDNBRVAL ) ) THEN
            WRITE( NOUT, FMT = 9992 )'nbrhs', LDNBRVAL
            GOTO 210
         ENDIF
         READ( NIN, FMT = * )( NBRVAL( I ), I = 1, NNBR )
*
*       Get number of grids.
*
         READ( NIN, FMT = * )NGRIDS
         IF( ( NGRIDS.LT.1 ) .OR. ( NGRIDS.GT.LDPQVAL ) ) THEN
            WRITE( NOUT, FMT = 9992 )'ngrids', LDPQVAL
            GOTO 210
         ENDIF
         READ( NIN, FMT = * )( PVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * )( QVAL( I ), I = 1, NGRIDS )
         READ( NIN, FMT = * )THRESH
         CLOSE ( NIN )
*
*
*         For pvm only: if virtual machine not set up, allocate it and
*         spawn the correct number of processes.
*
*
         IF( NPROCS.LT.1 ) THEN
            NPROCS = 0
            DO 30 I = 1, NGRIDS
               NPROCS = MAX( NPROCS, PVAL( I )*QVAL( I ) )
   30       CONTINUE
   40       CONTINUE
            CALL BLACS_SETUP( IAM, NPROCS )
         ENDIF
*
*
*         Temporarily define blacs grid to include all processes so
*         information can be broadcast to all processes.
*
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*       Perform broadcast.
*
         MACHEPS = REAL( PSLAMCH( ICTXT, 'Epsilon' ) )
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, MACHEPS, 1 )
         CALL SGEBS2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NMAT, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NNB, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NNR, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NNBR, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, NGRIDS, 1 )
         IVALUE = ICHAR( UPLO )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NMAT, NVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NNB, NBVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NNR, NRVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NNBR, NBRVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NGRIDS, PVAL, 1 )
         CALL IGEBS2D( ICTXT, 'All', ' ', 1, NGRIDS, QVAL, 1 )
*
*       write out information about this run.
*
         WRITE( NOUT, FMT = 9999 )
         WRITE( NOUT, FMT = 9998 )
 9999    FORMAT( 'ScaLAPACK Ax=b Cholesky factorization',
     $         / 'Tests of the factorization and solve.',
     $         / 'The matrix A is randomly generated for each test. ',
     $         / 'The residual is residual R is estimated   to be ',
     $         / ' R = ||Ax-b||/(||x||*||A||*eps*N)            ',
     $         / '                                             ' )
 9998    FORMAT( 1X, /
     $         'An explanation of the input/output parameters follows:',
     $         / ' ', /
     $         'uplo:     whether the data is stored in upper or lower '
     $         , / '          portion of array A',
     $         / 'n:        the number of rows and columns',
     $         / 'nb:       the size of square blocks A is split into',
     $         / 'nrhs:     the total number of RHS to solve for',
     $         / 'nbrhs:    the number of RHS to be put on a column ',
     $         / '          of processes before going on to the next ',
     $         / '          column of processes',
     $         / 'p,q:      the number of process rows and columns.', /
     $         'thresh:   if a residual value (R) is less than thresh, '
     $         , / '          this case is flagged as passed',
     $         / 'fac time: time in seconds to factor the matrix',
     $         / 'sol time: time in seconds to solve the system', / )
         WRITE( NOUT, FMT = '(A)' )
     $      'The following parameter values will be used'
         WRITE( NOUT, FMT = * )'      uplo: ', UPLO
         WRITE( NOUT, FMT = 9997 )'n: ', ( NVAL( I ), I = 1, NMAT )
         WRITE( NOUT, FMT = 9997 )'nb: ', ( NBVAL( I ), I = 1, NNB )
         WRITE( NOUT, FMT = 9997 )'nrhs: ', ( NRVAL( I ), I = 1, NNR )
         WRITE( NOUT, FMT = 9997 )'nbrhs: ',
     $      ( NBRVAL( I ), I = 1, NNBR )
         WRITE( NOUT, FMT = 9997 )'p: ', ( PVAL( I ), I = 1, NGRIDS )
         WRITE( NOUT, FMT = 9997 )'q: ', ( QVAL( I ), I = 1, NGRIDS )
 9997    FORMAT( 2X, A10, ( 10I6 ), / ( 12X, ( 10I6 ) ) )
      ELSE
*
*
*         If in pvm, must participate setting up virtual machine
*
*
         IF( NPROCS.LT.1 ) THEN
            CALL BLACS_SETUP( IAM, NPROCS )
         ENDIF
*
*
*         Temporarily define blacs grid to include all processes so
*         all processes have needed startup information
*
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', 1, NPROCS )
*
*       Receive broadcast.
*
         MACHEPS = REAL( PSLAMCH( ICTXT, 'Epsilon' ) )
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, MACHEPS, 1, 0, 0 )
         CALL SGEBR2D( ICTXT, 'All', ' ', 1, 1, THRESH, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NMAT, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NNB, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NNR, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NNBR, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, NGRIDS, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, 1, IVALUE, 1, 0, 0 )
         UPLO = CHAR( IVALUE )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NMAT, NVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NNB, NBVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NNR, NRVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NNBR, NBRVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NGRIDS, PVAL, 1, 0, 0 )
         CALL IGEBR2D( ICTXT, 'All', ' ', 1, NGRIDS, QVAL, 1, 0, 0 )
      ENDIF
      CALL BLACS_GRIDEXIT( ICTXT )
      ISLOWER = LSAME( UPLO, 'L' )
*
* Start of main loop.
*
      IFREE = 1
      IF( IAM.EQ.0 ) THEN
         WRITE( NOUT, FMT = * )
         WRITE( NOUT, FMT = 9996 )
         WRITE( NOUT, FMT = 9995 )
         WRITE( NOUT, FMT = * )
 9996    FORMAT( 'TIME UPLO     N  NB NRHS NBRHS    P    Q LLt Time ',
     $         'Slv Time   MFLOPS CHECK' )
 9995    FORMAT( '---- ---- ----- --- ---- ----- ---- ---- -------- ',
     $         '-------- -------- ------' )
 9994    FORMAT( A6, 2X, A1, 1X, I5, 1X, I3, 1X, I4, 1X, I5, 1X, I4, 1X,
     $         I4, 1X, F8.2, 1X, F8.2, 1X, F8.2, 1X, A6 )
      ENDIF
      DO 190 I = 1, NGRIDS
         IFREE_I = IFREE
         NPROW = PVAL( I )
         NPCOL = QVAL( I )
         IF( NPROW.LE.0 ) THEN
            IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = 9990 )'nprow '
            ENDIF
            KSKIP = KSKIP + 1
            GOTO 190
         ENDIF
         IF( NPCOL.LE.0 ) THEN
            IF( IAM.EQ.0 ) THEN
               WRITE( NOUT, FMT = 9990 )'npcol '
            ENDIF
            KSKIP = KSKIP + 1
            GOTO 190
         ENDIF
*
*       define process grid.
*
         CALL BLACS_GET( -1, 0, ICTXT )
         CALL BLACS_GRIDINIT( ICTXT, 'Row-major', NPROW, NPCOL )
         CALL BLACS_GRIDINFO( ICTXT, NPROW, NPCOL, MYROW, MYCOL )
         MYPROW = MYROW
         MYPCOL = MYCOL
         IF( ( MYROW.GE.NPROW ) .OR. ( MYCOL.GE.NPCOL ) ) THEN
*
*               process grid does not use this processor.
*
            GOTO 190
         ENDIF
         DO 170 J = 1, NMAT
            IFREE_J = IFREE
            N = NVAL( J )
            IERR = 0
            IF( .NOT.( N.GE.1 ) ) THEN
               IERR = 1
            ENDIF
            CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
            IF( IERR.GT.0 ) THEN
               IF( IAM.EQ.0 ) THEN
                  WRITE( NOUT, FMT = 9990 )'n'
               ENDIF
               KSKIP = KSKIP + 1
               GOTO 170
            ENDIF
            DO 150 K = 1, NNB
               IFREE_K = IFREE
               NB = NBVAL( K )
               IERR = 0
               IF( .NOT.( NB.GE.1 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9990 )'nb'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 150
               ENDIF
*
*               Initialize the array descriptor for the matrix A.
*
               RSRC = 0
               CSRC = 0
               NP = NUMROC( N, NB, MYROW, RSRC, NPROW )
               NQ = NUMROC( N, NB, MYCOL, CSRC, NPCOL )
               LDA = MAX( 1, NP )
               CALL DESCINIT( DESCA, N, N, NB, NB, RSRC, CSRC, ICTXT,
     $                        LDA, INFO )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9990 )'descriptor'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 150
               ENDIF
               CALL ICOPY( DLEN_, DESCA, 1, DESCAP, 1 )
*
*               allocate storage for matrix.
*
               SIZEA = INFOMEM( DESCA )
               IPA = IFREE
               IFREE = IFREE + MAX( 1, SIZEA )
               SIZEAP = INFOMEMT( UPLO, DESCAP )
               IPAP = IFREE
               IFREE = IFREE + MAX( 1, SIZEAP )
               IERR = 0
               IF( .NOT.( IFREE.LE.MEMSIZ ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = 9990 )'memsiz'
                  ENDIF
                  KSKIP = KSKIP + 1
                  GOTO 150
               ENDIF
*
*       Generate matrices.
*
               IROFF = 0
               ICOFF = 0
               IRNUM = NUMROC( DESCA( M_ ), DESCA( MB_ ), MYROW,
     $                 DESCA( RSRC_ ), NPROW )
               ICNUM = NUMROC( DESCA( N_ ), DESCA( NB_ ), MYCOL,
     $                 DESCA( CSRC_ ), NPCOL )
               CALL PCMATGEN( ICTXT, 'Hermitian', 'DDominant',
     $                        DESCA( M_ ), DESCA( N_ ), DESCA( MB_ ),
     $                        DESCA( NB_ ), MEM( IPA ), DESCA( LLD_ ),
     $                        DESCA( RSRC_ ), DESCA( CSRC_ ), IASEED,
     $                        IROFF, IRNUM, ICOFF, ICNUM, MYROW, MYCOL,
     $                        NPROW, NPCOL )
               ANORM = PCLANHE( 'M', UPLO, N, MEM( IPA ), 1, 1, DESCA,
     $                 RWORK )
*
*               copy matrix into packed storage.
*
               DO 50 JA = 1, N
                  IF( ISLOWER ) THEN
                     ISTART = JA
                     IEND = N
                  ELSE
                     ISTART = 1
                     IEND = JA
                  ENDIF
                  CALL DESCINITT( UPLO, ISTART, JA, DESCAP, IIA, JJA,
     $                            LOFFSET, DESCNEW )
                  CALL PCCOPY( IEND-ISTART+1, MEM( IPA ), ISTART, JA,
     $                         DESCA, 1, MEM( ( IPAP-1 )+LOFFSET ), IIA,
     $                         JJA, DESCNEW, 1 )
   50          CONTINUE
   60          CONTINUE
               ANORMP = PCLANHP( 'M', UPLO, N, MEM( IPAP ), 1, 1,
     $                  DESCAP, RWORK )
               CALL SLBOOT
               CALL BLACS_BARRIER( ICTXT, 'All' )
*
*               Perform cholesky factorization.
*
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 1 )
               CALL PCPOTRF( UPLO, N, MEM( IPA ), 1, 1, DESCA, INFO )
               CALL SLTIMER( 1 )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = * )'PxPOTRF info = ', INFO
                  ENDIF
                  KFAIL = KFAIL + 1
                  GOTO 150
               ENDIF
               CALL BLACS_BARRIER( ICTXT, 'All' )
               CALL SLTIMER( 3 )
               CALL PCPPTRF( UPLO, N, MEM( IPAP ), 1, 1, DESCAP, INFO )
               CALL SLTIMER( 3 )
               IERR = 0
               IF( .NOT.( INFO.EQ.0 ) ) THEN
                  IERR = 1
               ENDIF
               CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1, -1 )
               IF( IERR.GT.0 ) THEN
                  IF( IAM.EQ.0 ) THEN
                     WRITE( NOUT, FMT = * )'PxPPTRF info = ', INFO
                  ENDIF
                  KFAIL = KFAIL + 1
                  GOTO 150
               ENDIF
               DO 130 HH = 1, NNR
                  IFREE_HH = IFREE
                  DO 110 KK = 1, NNBR
                     IFREE_KK = IFREE
                     NRHS = NRVAL( HH )
                     NBRHS = NBRVAL( KK )
                     NBR = NBRHS
                     MB = NB
                     RSRC = DESCA( RSRC_ )
                     CSRC = DESCA( CSRC_ )
                     LDB = MAX( 1, NUMROC( N, MB, MYROW, RSRC, NPROW ) )
                     CALL DESCINIT( DESCB, N, NRHS, MB, NBR, RSRC, CSRC,
     $                              ICTXT, LDB, INFO )
                     IERR = 0
                     IF( .NOT.( INFO.EQ.0 ) ) THEN
                        IERR = 1
                     ENDIF
                     CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1,
     $                             -1 )
                     IF( IERR.GT.0 ) THEN
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = 9990 )'descriptor B'
                        ENDIF
                        KSKIP = KSKIP + 1
                        GOTO 110
                     ENDIF
                     CALL ICOPY( DLEN_, DESCB, 1, DESCX, 1 )
                     CALL ICOPY( DLEN_, DESCB, 1, DESCBP, 1 )
                     CALL ICOPY( DLEN_, DESCB, 1, DESCXP, 1 )
*
*               allocate storage for matrix.
*
                     SIZEB = INFOMEM( DESCB )
                     IPB = IFREE
                     IFREE = IFREE + MAX( 1, SIZEB )
                     SIZEBP = INFOMEM( DESCBP )
                     IPBP = IFREE
                     IFREE = IFREE + MAX( 1, SIZEBP )
                     SIZEXP = INFOMEM( DESCXP )
                     IPXP = IFREE
                     IFREE = IFREE + MAX( 1, SIZEXP )
                     SIZEX = INFOMEM( DESCX )
                     IPX = IFREE
                     IFREE = IFREE + MAX( 1, SIZEX )
                     IERR = 0
                     IF( .NOT.( IFREE.LE.MEMSIZ ) ) THEN
                        IERR = 1
                     ENDIF
                     CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1,
     $                             -1 )
                     IF( IERR.GT.0 ) THEN
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = 9990 )'memsiz'
                        ENDIF
                        KSKIP = KSKIP + 1
                        GOTO 110
                     ENDIF
                     IROFF = 0
                     ICOFF = 0
                     IRNUM = NUMROC( DESCB( M_ ), DESCB( MB_ ), MYROW,
     $                       DESCB( RSRC_ ), NPROW )
                     ICNUM = NUMROC( DESCB( N_ ), DESCB( NB_ ), MYCOL,
     $                       DESCB( CSRC_ ), NPCOL )
                     CALL PCMATGEN( ICTXT, 'Random', 'NonDominant',
     $                              DESCB( M_ ), DESCB( N_ ),
     $                              DESCB( MB_ ), DESCB( NB_ ),
     $                              MEM( IPB ), DESCB( LLD_ ),
     $                              DESCB( RSRC_ ), DESCB( CSRC_ ),
     $                              IBSEED, IROFF, IRNUM, ICOFF, ICNUM,
     $                              MYROW, MYCOL, NPROW, NPCOL )
                     BNORM = PCLANGE( 'M', DESCB( M_ ), DESCB( N_ ),
     $                       MEM( IPB ), 1, 1, DESCB, RWORK )
*
*               copy rhs matrix.
*
                     DO 70 JB = 1, NRHS
                        CALL PCCOPY( N, MEM( IPB ), 1, JB, DESCB, 1,
     $                               MEM( IPBP ), 1, JB, DESCBP, 1 )
                        CALL PCCOPY( N, MEM( IPB ), 1, JB, DESCB, 1,
     $                               MEM( IPX ), 1, JB, DESCX, 1 )
                        CALL PCCOPY( N, MEM( IPB ), 1, JB, DESCB, 1,
     $                               MEM( IPXP ), 1, JB, DESCXP, 1 )
   70                CONTINUE
   80                CONTINUE
*
*               Solve linear system.
*
                     CALL BLACS_BARRIER( ICTXT, 'All' )
                     CALL SLTIMER( 2 )
                     CALL PCPOTRS( UPLO, N, NRHS, MEM( IPA ), 1, 1,
     $                             DESCA, MEM( IPX ), 1, 1, DESCX,
     $                             INFO )
                     CALL SLTIMER( 2 )
                     IERR = 0
                     IF( .NOT.( INFO.EQ.0 ) ) THEN
                        IERR = 1
                     ENDIF
                     CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1,
     $                             -1 )
                     IF( IERR.GT.0 ) THEN
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = * )'PxPOTRS info = ', INFO
                        ENDIF
                        KFAIL = KFAIL + 1
                        GOTO 110
                     ENDIF
                     XNORM = PCLANGE( 'M', DESCX( M_ ), DESCX( N_ ),
     $                       MEM( IPX ), 1, 1, DESCX, RWORK )
                     CALL BLACS_BARRIER( ICTXT, 'All' )
                     CALL SLTIMER( 4 )
                     CALL PCPPTRS( UPLO, N, NRHS, MEM( IPAP ), 1, 1,
     $                             DESCAP, MEM( IPXP ), 1, 1, DESCXP,
     $                             INFO )
                     CALL SLTIMER( 4 )
                     IERR = 0
                     IF( .NOT.( INFO.EQ.0 ) ) THEN
                        IERR = 1
                     ENDIF
                     CALL IGSUM2D( ICTXT, 'All', ' ', 1, 1, IERR, 1, -1,
     $                             -1 )
                     IF( IERR.GT.0 ) THEN
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = * )'PxPPTRS info = ', INFO
                        ENDIF
                        KFAIL = KFAIL + 1
                        GOTO 110
                     ENDIF
                     CSYMM = 'Hermitian'
                     SRESID = REAL( 0 )
                     CALL PCLASCHK( CSYMM, 'Diag', N, NRHS, MEM( IPX ),
     $                              1, 1, DESCX, IASEED, 1, 1, DESCA,
     $                              IBSEED, ANORM, SRESID,
     $                              MEM( IFREE ) )
                     SRESIDP = REAL( 0 )
                     CALL PCLASCHK( CSYMM, 'Diag', N, NRHS, MEM( IPXP ),
     $                              1, 1, DESCXP, IASEED, 1, 1, DESCA,
     $                              IBSEED, ANORM, SRESIDP,
     $                              MEM( IFREE ) )
                     ALPHA = -ONE
                     DO 90 JB = 1, NRHS
                        CALL PCAXPY( N, ALPHA, MEM( IPBP ), 1, JB,
     $                               DESCBP, 1, MEM( IPB ), 1, JB,
     $                               DESCB, 1 )
                        CALL PCAXPY( N, ALPHA, MEM( IPXP ), 1, JB,
     $                               DESCXP, 1, MEM( IPX ), 1, JB,
     $                               DESCX, 1 )
   90                CONTINUE
  100                CONTINUE
                     BERR = PCLANGE( 'M', N, NRHS, MEM( IPB ), 1, 1,
     $                      DESCB, RWORK )
                     XERR = PCLANGE( 'M', N, NRHS, MEM( IPX ), 1, 1,
     $                      DESCX, RWORK )
                     IF( SRESIDP.LE.THRESH ) THEN
                        PASSED = 'PASSED'
                     ELSE
                        PASSED = 'FAILED'
                        IF( IAM.EQ.0 ) THEN
                           WRITE( NOUT, FMT = * )
     $                        'sresid from PxPOTRF/PxPOTRS is ', SRESID
                           WRITE( NOUT, FMT = * )
     $                        'sresid from PxHPTRF/PxHPTRS is ', SRESIDP
                           WRITE( NOUT, FMT = * )
     $                        'maxium deviation in solution X is  ',
     $                        XERR
                        ENDIF
                     ENDIF
*
*
*                     Gather maximum of all CPU and WALL clock timings
*
*
                     CALL SLCOMBINE( ICTXT, 'All', '>', 'Wall-clock', 4,
     $                               1, WTIME )
                     CALL SLCOMBINE( ICTXT, 'All', '>', 'Cpu-clock', 4,
     $                               1, CTIME )
                     IF( IAM.EQ.0 ) THEN
*
*
*                        1/3 N^3 + 1/2 N^2 flops for LLt factorization
*
*
                        NOPS = ( DBLE( N )**3 ) / DBLE( 3 ) +
     $                         ( DBLE( N )**2 ) / DBLE( 2 )
*
*
*                        nrhs * 2 N^2 flops for LLt solve.
*
*
                        NOPS = NOPS + DBLE( 2 )*( DBLE( N )**2 )*
     $                         DBLE( NRHS )
                        TMFLOPS = DBLE( 0 )
                        TMPFLOPS = DBLE( 0 )
                        IF( WTIME( 1 )+WTIME( 2 ).GT.DBLE( 0 ) ) THEN
                           TMFLOPS = NOPS / ( ( WTIME( 1 )+WTIME( 2 ) )*
     $                               DBLE( 1000 )*DBLE( 1000 ) )
                        ENDIF
                        IF( WTIME( 3 )+WTIME( 4 ).GT.DBLE( 0 ) ) THEN
                           TMPFLOPS = NOPS / ( ( WTIME( 3 )+
     $                                WTIME( 4 ) )*DBLE( 1000 )*
     $                                DBLE( 1000 ) )
                        ENDIF
                        WRITE( NOUT, FMT = 9994 )'Wall', UPLO, N, NB,
     $                     NRHS, NBRHS, NPROW, NPCOL, WTIME( 1 ),
     $                     WTIME( 2 ), TMFLOPS, PASSED
                        WRITE( NOUT, FMT = 9994 )'P*Wall', UPLO, N, NB,
     $                     NRHS, NBRHS, NPROW, NPCOL, WTIME( 3 ),
     $                     WTIME( 4 ), TMPFLOPS, PASSED
                        TMFLOPS = DBLE( 0 )
                        TMPFLOPS = DBLE( 0 )
                        IF( CTIME( 1 )+CTIME( 2 ).GT.DBLE( 0 ) ) THEN
                           TMFLOPS = NOPS / ( ( CTIME( 1 )+CTIME( 2 ) )*
     $                               DBLE( 1000 )*DBLE( 1000 ) )
                        ENDIF
                        IF( CTIME( 3 )+CTIME( 4 ).GT.DBLE( 0 ) ) THEN
                           TMPFLOPS = NOPS / ( ( CTIME( 3 )+
     $                                CTIME( 4 ) )*DBLE( 1000 )*
     $                                DBLE( 1000 ) )
                        ENDIF
                        WRITE( NOUT, FMT = 9994 )'cpu', UPLO, N, NB,
     $                     NRHS, NBRHS, NPROW, NPCOL, CTIME( 1 ),
     $                     CTIME( 2 ), TMFLOPS, PASSED
                        WRITE( NOUT, FMT = 9994 )'P*cpu', UPLO, N, NB,
     $                     NRHS, NBRHS, NPROW, NPCOL, CTIME( 3 ),
     $                     CTIME( 4 ), TMPFLOPS, PASSED
                     ENDIF
* end if (iam==0)
                     IFREE = IFREE_KK
  110             CONTINUE
  120             CONTINUE
* end do kk
                  IFREE = IFREE_HH
  130          CONTINUE
  140          CONTINUE
* end do hh
               IFREE = IFREE_K
  150       CONTINUE
  160       CONTINUE
* end do k
            IFREE = IFREE_J
  170    CONTINUE
  180    CONTINUE
* end do j
         CALL BLACS_GRIDEXIT( ICTXT )
         IFREE = IFREE_I
  190 CONTINUE
  200 CONTINUE
* end do i
*
*   all done.
*
      IF( IAM.EQ.0 ) THEN
         IF( KSKIP.GE.1 ) THEN
            WRITE( NOUT, FMT = * )KSKIP, ' cases were skipped '
         ENDIF
         IF( KFAIL.GE.1 ) THEN
            WRITE( NOUT, FMT = * )KFAIL, ' cases failed '
         ENDIF
         CLOSE ( NOUT )
      ENDIF
      CALL BLACS_EXIT( 0 )
      STOP '** all done **'
  210 CONTINUE
      WRITE( NOUT, FMT = 9993 )
      CLOSE ( NIN )
      IF( ( NOUT.NE.0 ) .AND. ( NOUT.NE.6 ) ) THEN
         CLOSE ( NOUT )
      ENDIF
      CALL BLACS_ABORT( ICTXT, 1 )
      STOP '** stop with error ** '
 9993 FORMAT( ' Illegal input in file ', 40A, '.  Aborting run.' )
 9992 FORMAT( ' Number of values of ', 5A,
     $      ' is less than 1 or greater ', 'than ', I2 )
 9991 FORMAT( 1X, A4, 1X, A, 1X, 6I6, 2( 1X, F10.1 ) )
 9990 FORMAT( 'Bad ', A6, ' parameters: going on to next test case.' )
      END
