      SUBROUTINE PCLASCLT( UPLO, TYPE, CFROM, CTO, M, N, A, IA, JA,
     $                     DESCA, INFO )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*
*  Purpose
*  =======
*
*  PLASCLT multiplies the M-by-N distributed matrix sub( A )
*  denoting A(IA:IA+M-1,JA:JA+N-1) by the real scalar CTO/CFROM.
*  matrix sub(A) is stored in packed storage.
*  This is done without over/underflow as long as the final result
*  CTO * A(I,J) / CFROM does not over/underflow. TYPE specifies that
*  sub( A ) may be full, upper triangular, lower triangular or upper
*  Hessenberg part of a matrix in packed storage.
*
*  Matrix A is stored in packed storage.
*
*  Notes
*  =====
*
*  Each global data object is described by an associated description
*  vector.  This vector stores the information required to establish
*  the mapping between an object element and its corresponding process
*  and memory location.
*
*  Let A be a generic term for any 2D block cyclicly distributed array.
*  Such a global array has an associated description vector DESCA.
*  In the following comments, the character _ should be read as
*  "of the global array".
*
*  NOTATION        STORED IN      EXPLANATION
*  --------------- -------------- --------------------------------------
*  DTYPE_A(global) DESCA( DTYPE_ )The descriptor type.  In this case,
*                                 DTYPE_A = 1.
*  CTXT_A (global) DESCA( CTXT_ ) The BLACS context handle, indicating
*                                 the BLACS process grid A is distribu-
*                                 ted over. The context itself is glo-
*                                 bal, but the handle (the integer
*                                 value) may vary.
*  M_A    (global) DESCA( M_ )    The number of rows in the global
*                                 array A.
*  N_A    (global) DESCA( N_ )    The number of columns in the global
*                                 array A.
*  MB_A   (global) DESCA( MB_ )   The blocking factor used to distribute
*                                 the rows of the array.
*  NB_A   (global) DESCA( NB_ )   The blocking factor used to distribute
*                                 the columns of the array.
*  RSRC_A (global) DESCA( RSRC_ ) The process row over which the first
*                                 row of the array A is distributed.
*  CSRC_A (global) DESCA( CSRC_ ) The process column over which the
*                                 first column of the array A is
*                                 distributed.
*  LLD_A  (local)  DESCA( LLD_ )  The leading dimension of the local
*                                 array.  LLD_A >= MAX(1,LOCr(M_A)).
*
*  Let K be the number of rows or columns of a distributed matrix,
*  and assume that its process grid has dimension p x q.
*  LOCr( K ) denotes the number of elements of K that a process
*  would receive if K were distributed over the p processes of its
*  process column.
*  Similarly, LOCc( K ) denotes the number of elements of K that a
*  process would receive if K were distributed over the q processes of
*  its process row.
*  The values of LOCr() and LOCc() may be determined via a call to the
*  ScaLAPACK tool function, NUMROC:
*          LOCr( M ) = NUMROC( M, MB_A, MYROW, RSRC_A, NPROW ),
*          LOCc( N ) = NUMROC( N, NB_A, MYCOL, CSRC_A, NPCOL ).
*  An upper bound for these quantities may be computed by:
*          LOCr( M ) <= ceil( ceil(M/MB_A)/NPROW )*MB_A
*          LOCc( N ) <= ceil( ceil(N/NB_A)/NPCOL )*NB_A
*
*  Arguments
*  =========
*
*  UPLO    (global input) CHARACTER
*          = 'U':  Upper triangle of A(IA:IA+M-1,JA:JA+N-1)
*          = 'L':  Lower triangle of A(IA:IA+M-1,JA:JA+N-1)
*
*
*
*  TYPE    (global input) CHARACTER
*          TYPE indices the storage type of the input distributed
*          matrix.
*          = 'G':  sub( A ) is a full matrix,
*          = 'L':  sub( A ) is a lower triangular matrix,
*          = 'U':  sub( A ) is an upper triangular matrix,
*          = 'H':  sub( A ) is an upper Hessenberg matrix.
*
*  CFROM   (global input) FTYPE
*  CTO     (global input) FTYPE
*          The distributed matrix sub( A ) is multiplied by CTO/CFROM.
*          A(I,J) is computed without over/underflow if the final
*          result CTO * A(I,J) / CFROM can be represented without
*          over/underflow.  CFROM must be nonzero.
*
*  M       (global input) INTEGER
*          The number of rows to be operated on i.e the number of rows
*          of the distributed submatrix sub( A ). M >= 0.
*
*  N       (global input) INTEGER
*          The number of columns to be operated on i.e the number of
*          columns of the distributed submatrix sub( A ). N >= 0.
*
*  A       (local input/local output)
*          an array of dimension (LLD_A,LOCc(JA+N-1)).
*          This array contains the local pieces of the distributed
*          matrix sub( A ). On exit, this array contains the local
*          pieces of the distributed matrix multiplied by CTO/CFROM.
*
*  IA      (global input) INTEGER
*          The row index in the global array A indicating the first
*          row of sub( A ).
*
*  JA      (global input) INTEGER
*          The column index in the global array A indicating the
*          first column of sub( A ).
*
*  DESCA   (global and local input) INTEGER array of dimension DLEN_.
*          The array descriptor for the distributed matrix A.
*
*  INFO    (local output) INTEGER
*          = 0:  successful exit
*          < 0:  If the i-th argument is an array and the j-entry had
*                an illegal value, then INFO = -(i*100+j), if the i-th
*                argument is a scalar and had an illegal value, then
*                INFO = -i.
*
*
*     .. Parameters ..
      INTEGER            DLEN_
      PARAMETER          ( DLEN_ = 9 )
      INTEGER            CTXT_, M_, N_, NB_
      PARAMETER          ( CTXT_ = 2, M_ = 3, N_ = 4, NB_ = 6 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          TYPE, UPLO
      INTEGER            IA, INFO, JA, M, N
      REAL               CFROM, CTO
*     ..
*     .. Array Arguments ..
      INTEGER            DESCA( DLEN_ )
      COMPLEX            A( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISUPPER, ISVALID
      INTEGER            IADIAG, IAEND, IASTART, ICONTXT, IIA, ISIZE,
     $                   JEND, JJA, JSIZE, JSTART, LOFFSET, NB
*     ..
*     .. Local Arrays ..
      INTEGER            DESC1( DLEN_ )
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. External Subroutines ..
      EXTERNAL           DESCINITT, PCLASCL, PXERBLA
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MIN, MOD
*     ..
*     .. Executable Statements ..
*
* Error checking.
*
      ICONTXT = DESCA( CTXT_ )
      INFO = 0
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISVALID = ISLOWER .OR. ISUPPER
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 1 )
         INFO = -1
         RETURN
      ENDIF
      ISVALID = LSAME( TYPE, 'G' ) .OR. LSAME( TYPE, 'L' ) .OR.
     $          LSAME( TYPE, 'U' ) .OR. LSAME( TYPE, 'H' )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 2 )
         INFO = -2
         RETURN
      ENDIF
      IF( ( M.LE.0 ) .OR. ( N.LE.0 ) ) THEN
         RETURN
      ENDIF
      ISVALID = ( 1.LE.M ) .AND. ( M.LE.DESCA( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 5 )
         INFO = -5
         RETURN
      ENDIF
      ISVALID = ( 1.LE.N ) .AND. ( N.LE.DESCA( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 6 )
         INFO = -6
         RETURN
      ENDIF
      ISVALID = ( 1.LE.IA ) .AND. ( IA+M-1.LE.DESCA( M_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 8 )
         INFO = -8
         RETURN
      ENDIF
      ISVALID = ( 1.LE.JA ) .AND. ( JA+N-1.LE.DESCA( N_ ) )
      IF( .NOT.ISVALID ) THEN
         CALL PXERBLA( ICONTXT, 'PxLASCLT', 9 )
         INFO = -9
         RETURN
      ENDIF
      IF( LSAME( TYPE, 'G' ) ) THEN
*
*            Full matrix.
*
         ISVALID = ( ISLOWER .AND. ( IA.GE.JA+N-1 ) ) .OR.
     $             ( ISUPPER .AND. ( IA+M-1.LE.JA ) )
      ELSE
         IF( LSAME( TYPE, 'L' ) ) THEN
*
*           Index set is  (( (ia-1)+j:m, (ja-1)+j ),j=1:min(m,n))
*
            ISVALID = ( ISLOWER .AND. ( IA.GE.JA ) ) .OR.
     $                ( ISUPPER .AND. ( JA.GE.( IA-1 )+M ) )
         ELSE
            IF( LSAME( TYPE, 'U' ) ) THEN
*
*            Index set is  ( (ia-1)+1:min(j,m), (ja-1)+j), j=1:n )
*
               ISVALID = ( ISLOWER .AND. ( IA.GE.( JA-1 )+N ) ) .OR.
     $                   ( ISUPPER .AND. ( ( IA-1 )+M.LE.JA ) )
            ELSE
               IF( LSAME( TYPE, 'H' ) ) THEN
*
*            Index set is ( (ia-1)+1:min(j,m)+1,(ja-1)+j, j=1:n )
*
                  ISVALID = ( ISLOWER .AND. ( IA+1.GE.( JA-1 )+N ) )
     $                       .OR. ( ISUPPER .AND.
     $                      ( ( IA-1 )+M+1.LE.JA ) )
               ENDIF
            ENDIF
         ENDIF
      ENDIF
      IF( ( M.LE.0 ) .OR. ( N.LE.0 ) ) THEN
         RETURN
      ENDIF
      NB = DESCA( NB_ )
      JSTART = JA
   10 CONTINUE
      IF( JSTART.LE.( JA+N-1 ) ) THEN
         JEND = ( JSTART-MOD( JSTART-1, NB ) ) + ( NB-1 )
         JEND = MIN( JEND, JA+N-1 )
         JSIZE = JEND - JSTART + 1
         IADIAG = IA + ( JSTART-JA )
         IF( LSAME( TYPE, 'L' ) ) THEN
*
*             Lower triangular part.
*
*
*                 Diagonal block (triangular) matrix.
*
            CALL DESCINITT( UPLO, IADIAG, JSTART, DESCA, IIA, JJA,
     $                      LOFFSET, DESC1 )
            CALL PCLASCL( 'L', CFROM, CTO, JSIZE, JSIZE, A( LOFFSET ),
     $                    IIA, JJA, DESC1, INFO )
            IF( INFO.NE.0 ) THEN
               GOTO 30
            ENDIF
*
*                 Off-diagonal block (rectangular) matrix.
*
            IASTART = IADIAG + JSIZE
            IAEND = IA + M - 1
            ISIZE = IAEND - IASTART + 1
            IF( ISIZE.GE.1 ) THEN
               CALL DESCINITT( UPLO, IADIAG+JSIZE, JSTART, DESCA, IIA,
     $                         JJA, LOFFSET, DESC1 )
               CALL PCLASCL( 'G', CFROM, CTO, ISIZE, JSIZE,
     $                       A( LOFFSET ), IIA, JJA, DESC1, INFO )
               IF( INFO.NE.0 ) THEN
                  GOTO 30
               ENDIF
            ENDIF
         ELSE
            IF( LSAME( TYPE, 'U' ) .OR. LSAME( TYPE, 'H' ) ) THEN
*
*                Upper triangular part.
*
*
*                 Off-diagonal block (rectangular) matrix.
*
               IASTART = IA
               IAEND = IADIAG - 1
               ISIZE = IAEND - IASTART + 1
               IF( ISIZE.GE.1 ) THEN
                  CALL DESCINITT( UPLO, IASTART, JSTART, DESCA, IIA,
     $                            JJA, LOFFSET, DESC1 )
                  CALL PCLASCL( 'G', CFROM, CTO, ISIZE, JSIZE,
     $                          A( LOFFSET ), IIA, JJA, DESC1, INFO )
                  IF( INFO.NE.0 ) THEN
                     GOTO 30
                  ENDIF
               ENDIF
*
*                 Diagonal block (triangular) matrix.
*
               CALL DESCINITT( UPLO, IADIAG, JSTART, DESCA, IIA, JJA,
     $                         LOFFSET, DESC1 )
               CALL PCLASCL( TYPE, CFROM, CTO, JSIZE, JSIZE,
     $                       A( LOFFSET ), IIA, JJA, DESC1, INFO )
               IF( INFO.NE.0 ) THEN
                  GOTO 30
               ENDIF
            ELSE
               IF( LSAME( TYPE, 'G' ) ) THEN
*
*                   Full/general matrix.
*
                  IASTART = ( IA-1 ) + 1
                  IAEND = ( IA-1 ) + M
                  ISIZE = IAEND - IASTART + 1
                  CALL DESCINITT( UPLO, IASTART, JSTART, DESCA, IIA,
     $                            JJA, LOFFSET, DESC1 )
                  CALL PCLASCL( 'G', CFROM, CTO, ISIZE, JSIZE,
     $                          A( LOFFSET ), IIA, JJA, DESC1, INFO )
                  IF( INFO.NE.0 ) THEN
                     GOTO 30
                  ENDIF
               ENDIF
            ENDIF
         ENDIF
         JSTART = JEND + 1
         GOTO 10
      ENDIF
   20 CONTINUE
   30 CONTINUE
      RETURN
      END
