      SUBROUTINE INFOT( UPLO, IA, JA, DESC, IASTART, JASTART, IAEND,
     $                  JAEND )
*
*
*  -- ScaLAPACK auxiliary routine (version 2.0) --
*     University of Tennessee, Knoxville, Oak Ridge National Laboratory,
*     and University of California, Berkeley.
*     Oct 10, 1996
*
*
*  Purpose:
*  =======
*
*  Determine coordinates of the block/slab containing
*  global index (ia,ja) in compressed triangular format
*
*
*     .. Parameters ..
      INTEGER            M_, N_, MB_, NB_
      PARAMETER          ( M_ = 3, N_ = 4, MB_ = 5, NB_ = 6 )
*     ..
*     .. Scalar Arguments ..
      CHARACTER          UPLO
      INTEGER            IA, IAEND, IASTART, JA, JAEND, JASTART
*     ..
*     .. Array Arguments ..
      INTEGER            DESC( * )
*     ..
*     .. Local Scalars ..
      LOGICAL            ISLOWER, ISUPPER, ISVALID
      INTEGER            M, MB, N, NB, NNB
*     ..
*     .. External Functions ..
      LOGICAL            LSAME
      EXTERNAL           LSAME
*     ..
*     .. Intrinsic Functions ..
      INTRINSIC          MAX, MIN, MOD
*     ..
*     .. Executable Statements ..
      N = DESC( N_ )
      M = DESC( M_ )
      NB = DESC( NB_ )
      MB = DESC( MB_ )
      ISLOWER = LSAME( UPLO, 'L' )
      ISUPPER = LSAME( UPLO, 'U' )
      ISVALID = ( ( 1.LE.IA ) .AND. ( IA.LE.M ) ) .AND.
     $          ( ( 1.LE.JA ) .AND. ( JA.LE.N ) )
      NNB = NB
      JASTART = MAX( 1, MIN( N, JA-MOD( NNB+JA-1, NNB ) ) )
      JAEND = MAX( 1, MIN( N, JASTART+( NNB-1 ) ) )
      IF( ISLOWER ) THEN
         IASTART = MAX( 1, MIN( M, JASTART ) )
         IAEND = M
      ELSE
         IASTART = 1
         IAEND = MAX( 1, MIN( M, JAEND ) )
      ENDIF
      RETURN
      END
