#ifndef CHECKMAT_H
#define CHECKMAT_H 1



#define CHECK_CONTEXT( icontext_, descApos0 ) { \
	ictxt = icontext_; \
	call blacs_gridinfo( icontext_, nprow,npcol,myprow,mypcol ); \
	if (nprow == -1) { \
		info =  -(descApos0*100 + CTXT_); \
		return; \
		}; \
	}


#define CHECK_MAT( m,mpos0, n,npos0, ia,ja,descA, descApos0 ) {\
    savedt = descA(DT_); descA(DT_)= BLOCK_CYCLIC_2D; \
    call chk1mat( m, mpos0, n, npos0, ia,ja, descA, descApos0, info); \
    if (info != 0) { \
	call pxerbla( descA( CTXT_), caller, descApos0); return; }; \
    idummy = 1; \
    call pchk1mat( m,mpos0,n,npos0, ia,ja,descA, descApos0,  \
		idummy,idummy,idummy, info ); \
    if (info != 0) {  \
	call pxerbla( descA( CTXT_), caller, descApos0); return; }; \
    descA(DT_) = savedt; \
    }

#define CHECK_IO( descA, descApos0 ) {  \
	if (descA(DT_) != DISK_BLOCK_CYCLIC_2D) {  \
		info =  -(descApos0 *100 + DT_);  \
		call pxerbla( descA(CTXT_), caller, descApos0 );  \
		return;  \
		};  \
	info = 0;  \
	call laio_info( descA(IODEV_),   \
		mm,nn, mmb,nnb, mb,nb, csrc,rsrc, icontxt );  \
	if (mb != descA(MB_)) { info = -(descApos0*100 + MB_ ); };  \
	if (nb != descA(NB_)) { info = -(descApos0*100 + NB_); };  \
	if (icontxt != descA(CTXT_)) { info = -(descApos0*100 + CTXT_); };  \
	if (descA(RSRC_) != rsrc) { info = -(descApos0*100 + RSRC_); }; \
	if (descA(CSRC_) != csrc) { info = -(descApos0*100 + CSRC_); }; \
	if (info != 0) {   \
		call pxerbla( descA(CTXT_), caller, descApos0); return; };  \
	};

		
#define CHECK_TRANS( icontxt, transA, transApos0 ) {\
  isvalid = (lsame(transA,'T') | lsame(transA,'C') | lsame(transA,'N') ); \
  if (!isvalid) { \
	info = -transApos0; \
	call pxerbla( icontxt, caller, transApos0 ); \
	return; \
	}; \
  }

#define CHECK_VECT( veclen, ix,jx,descX,descXpos, incx, incxpos0 ) {  \
	isvalid = (incx == 1) | (incx == descX(M_));  \
	if (!isvalid) {  \
		info = -incxpos0;  \
		call pxerbla( descX(CTXT_), caller, incxpos0 );  \
		return;  \
		};  \
	isvalid = (1 <= descX( MB_ ));  \
	if (!isvalid) {  \
		info = -(descXpos0*100 + MB_);  \
		call pxerbla(descX(CTXT_), caller, descXpos0 );  \
		return;  \
		};  \
	isvalid = (1 <= descX( NB_ ));  \
	if (!isvalid) {  \
		info = -(descXpos0*100 + NB_);  \
		call pxerbla(descX(CTXT_), caller,descXpos0 );  \
		return;  \
		};  \
	call blacs_gridinfo( descX(CTXT_), nprow,npcol,myprow,mypcol);  \
	isvalid = (descX(LLD_) >= 1) &  \
	   (descX(LLD_) >= numroc( descX(M_), descX(MB_),   \
				myprow, descX(RSRC_),npcol));  \
	if (!isvalid) {  \
		info = -(descXpos0*100 + LLD_ );  \
		call pxerbla( descX(CTXT_), caller, descXpos0 );  \
		return;  \
		};  \
	if (incx == 1) {  \
	  isvalid = (1 <= ix) & ((ix + veclen-1) <= descX(M_));   \
	  if (!isvalid) {  \
		info = -(descXpos0*100 + M_);  \
		call pxerbla( descX(CTXT_), caller, descXpos0 );  \
		return;  \
		};  \
	  isvalid = (1 <= jx) & (jx <= descX(N_));  \
	  if (!isvalid) {  \
		info = -(descXpos0*100 + N_);  \
		call pxerbla( descX(CTXT_), caller, descXpos0 );  \
		return;  \
		};  \
	  }  \
	else {  \
	   isvalid = (1 <= ix) & (ix <= descX(M_));  \
           if (!isvalid) {  \
                info = -(descXpos0*100 + M_);  \
                call pxerbla( descX(CTXT_), caller, descXpos0 );  \
                return;  \
                };  \
           isvalid = (1 <= jx) & ((jx + veclen - 1) <= descX(N_));  \
           if (!isvalid) {  \
                info = -(descXpos0*100 + N_);  \
                call pxerbla( descX(CTXT_), caller, descXpos0 );  \
                return;  \
                };  \
	   };  \
	}


#define CHECK_SIDE( icontxt, side, sidepos0 ) { \
	isvalid = (lsame(side,'R') | lsame(side,'L')); \
	if (!isvalid) { \
	   info = -sidepos0; \
	   call pxerbla( icontxt, caller, sidepos0 ); \
	   return; \
	   }; \
	}
	

#define CHECK_UPLO( icontxt, uplo, uplopos0 ) { \
        isvalid = (lsame(uplo,'U') | lsame(uplo,'L')); \
        if (!isvalid) { \
           info = -uplopos0; \
           call pxerbla( icontxt, caller, uplopos0 ); \
           return; \
           }; \
        }

#define CHECK_DIAG( icontxt, diag, diagpos0 ) { \
        isvalid = (lsame(diag,'U') | lsame(diag,'N')); \
        if (!isvalid) { \
           info = -diagpos0; \
           call pxerbla( icontxt, caller, diagpos0 ); \
           return; \
           }; \
        }

#define CHECK_STORAGE( descA, descApos0, ncopy,  m, nnb ) { \
	call blacs_gridinfo( descA(CTXT_), nprow,npcol, myprow,mypcol);  \
	Locp = numroc( m, descA(MB_), myprow, myprow, nprow );  \
	Locq = numroc( nnb, descA(NB_), mypcol,mypcol,npcol);  \
	Aneed = ncopy*(Locp*Locq);  \
	if (descA(SIZE_) < Aneed) {  \
		A(1) = Aneed;  \
		info  =  -(descApos0*100 + SIZE_);  \
                if (descA(SIZE_) != -1) { \
		    call pxerbla( descA(CTXT_), caller, descApos0 );  \
                    }; \
		return;  \
		};  \
	}



#endif
