#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Parser;

##########################################
my $util = new RIB::Util();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();
my $MAXHITS = 50;

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}
eval { $util->dbConnect(); };
if ($@) { $util->error("Database error $@"); }


##########################################
# get repository properties
my $sth = $util->dbh->prepare("SELECT name,contact,object_approval_required,"
                            . "primary_class FROM "
                            . "repositories WHERE handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error $@"); }
my $row = $sth->fetchrow_hashref();
my $repoName = $row->{'name'};
my $repoContact = $row->{'contact'};
my $object_approval_required = $row->{'object_approval_required'};
my $primary_class = $row->{'primary_class'};

if (param('query')) {
  # parse repository configuration
  my $rp = new RIB::Parser;
  eval {
    $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml");
  };
  if ($@) {
    $util->error("Can't parse repository configuration : " . $@);
  }

  my $query = param('query');
  $query =~ s/"//g;
  $query =~ s/'//g;
  $query =~ s/\*/.\*/g;
  $query = lc($query);

  my $bool = param('bool');
  if ($bool ne 'OR' and $bool ne 'AND') {
    $util->error("Improper boolean value supplied");
  }

  # assemble reqular expression
  my $term_count = 0;
  my $regex;
  if ($bool eq 'OR') {
    foreach  my $term (split(/\s+/,$query)) {
      last if ++$term_count == 6; # max of 6 terms
      $regex .= "[[:<:]]".$term."[[:>:]]|";
    }
    chop $regex;
  }

  print header;
  unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/search_template.html")) {
    $util->error("Can't open search template : $!");
  }
  while (<TEMPLATE>) {
    s/\bREPOSITORY_NAME\b/$repoName/g;
    s/\bREPOSITORY_CONTACT\b/$repoContact/g;
    s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
    s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
    s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
    s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
    s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
    s/\bDATA_MODEL_URL\b/$riburl\/$repoHandle\/config.xml/g;
    s/\bREPOSITORY_HANDLE\b/$riburl\/repository.pl\?rh=$repoHandle/g;
    s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
    s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;

    print;
    if (/<!-- RIB -->/i) {
      my @hits = ();
      my @classes = ();
      foreach my $class (@{$rp->classes}) {
        next if $class->name eq $primary_class;
        push (@classes, $class);
      }

      unshift (@classes, $rp->getClass($primary_class));
      foreach my $class (@classes) {
        my $buf = "";
        my $className = $class->name();
        next if $className eq "RigObject";
        my %nameCache = ();
        if ($bool eq "OR") {
          foreach my $attr (@{$class->attributes}) {
            next if $attr->display eq "noshow";
            $buf .= "LCASE(" . $attr->name() ."_) regexp \"$regex\" OR "
          }
          chop($buf);chop($buf);chop($buf);chop($buf);
        } elsif ($bool eq "AND") {
          foreach  my $term (split(/\s+/,$query)) {
            last if ++$term_count == 6; # max of 6 terms
            $buf .= "(";
            foreach my $attr (@{$class->attributes}) {
              next if $attr->display eq "noshow";
              $buf .= "LCASE(" . $attr->name() ."_) regexp "
                    . "\"[[:<:]]". $term ."[[:>:]]\" OR ";
            }
            chop($buf);chop($buf);chop($buf);chop($buf);
            $buf .= ") AND ";
          }
          chop($buf);chop($buf);chop($buf);chop($buf);chop($buf);
        }
    
        if ($object_approval_required) {
          $sth= $util->dbh->prepare("SELECT Name_,IF(handle,handle,extends) FROM $repoHandle\_$className "
              . "WHERE $buf AND approved=1");
        } else {
          $sth= $util->dbh->prepare("SELECT Name_,IF(handle,handle,extends) FROM $repoHandle\_$className "
              . "WHERE $buf");
        }
        eval { $sth->execute(); };
        if ($@) { $util->error("Database error $@"); }
        my $prefix = "$riburl/object.pl?rh=$repoHandle&"
                   . "class=$className&html=1&oh=";
        while (my $row = $sth->fetchrow_arrayref) {
          next if defined $nameCache{$row->[1]};
          if (defined ($row->[0])) {
            push (@hits, [$row->[0],$prefix.$row->[1]]);
            $nameCache{$row->[1]} = $row->[1];
          }
          elsif (defined $nameCache{$row->[1]}) {
            push (@hits, [$nameCache{$row->[1]},$prefix.$row->[1]]);
          } else {
            my $sth2 = $util->dbh->prepare("SELECT Name_ FROM "
                                         . "$repoHandle\_$className WHERE handle="
                                         . $row->[1]);
            eval { $sth2->execute; };
            if (!$@ and $sth2->rows >= 1) {
              my $name = $sth2->fetchrow_arrayref()->[0];
              push (@hits, [$name,$prefix.$row->[1]]);
              $nameCache{$row->[1]} = $name;
            }
          }
          last if $#hits+1 == $MAXHITS;
        }

        if (($className eq $primary_class) and ($#hits+1 < $MAXHITS)) { # interops
          my $sth = $util->dbh->prepare("SELECT DISTINCT Name_, url FROM "
                                      . "$repoHandle\_interop_objects WHERE $buf");
          eval { $sth->execute(); };
          if ($@) { $util->error($@); }
          while (my $row = $sth->fetchrow_arrayref()) {
            my $url = $row->[1];
            if ($url =~ /object.pl\?/) {
              $url .= "&html=1";
            }
            push (@hits,[$row->[0],$url]);
            last if $#hits+1 == $MAXHITS;
          }
        }
      }
      print start_form,
            textfield('-name'=>'query', '-size'=>50, '-maxlength'=>50),
            submit('-value'=>'Submit'),
            br,
            "Combine search terms with : ",
            "<INPUT TYPE=RADIO NAME=bool VALUE=OR";

      if ($bool eq 'OR') {
        print " CHECKED";
      }

      print ">OR ",
            "<INPUT TYPE=RADIO NAME=bool VALUE=AND";

      if ($bool eq 'AND') {
        print " CHECKED";
      }

      print ">AND ",
            hidden('rh'),
            end_form,
            "Search query <STRONG>&quot;",
            param('query'),
            "&quot;</STRONG> found ",$#hits+1, " matches :",
            p, "\n<UL>\n";
      foreach my $hit (@hits) {
          print "<LI><A HREF=\"",
                $hit->[1], "\">",
                $hit->[0], "</A><P>";
      }
      print "</UL>\n";
      if ($#hits+1 >= $MAXHITS) {
        print "Maximum number of matches has been reached ($MAXHITS).";
      }
    }
  }
  goto FALLOFF;
}

print header;
unless (open (TEMPLATE, "$ribdir/docRoot/$repoHandle/search_template.html")) {
  $util->error("Can't open search template : $!");
}
while (<TEMPLATE>) {
  s/\bREPOSITORY_NAME\b/$repoName/g;
  s/\bREPOSITORY_CONTACT\b/$repoContact/g;
  s/\bSEARCH_URL\b/$riburl\/search.pl\?rh=$repoHandle/g;
  s/\bADVANCED_SEARCH_URL\b/$riburl\/advancedSearch.pl\?rh=$repoHandle/g;
  s/\bJOIN_URL\b/$riburl\/join.pl\?rh=$repoHandle/g;
  s/\bWHATS_NEW_URL\b/$riburl\/whatsNew.pl\?rh=$repoHandle/g;
  s/\bCATALOG_URL\b/$riburl\/catalog.pl\?rh=$repoHandle/g;
  s/\bABOUT_URL\b/$riburl\/about.pl\?rh=$repoHandle/g;
  s/\bRIB_LOGO\b/<A HREF="http:\/\/www.nhse.org\/RIB\/"><IMG ALIGN="CENTER" WIDTH="72" HEIGHT="82" BORDER="0" SRC="$riburl\/images\/poweredRIB.gif"><\/A>/g;

  print;
  if (/<!-- RIB -->/i) {
    print "Please enter your search query into the form below.",
          p,
          start_form,
          textfield('-name'=>'query', '-size'=>50, '-maxlength'=>50),
          submit('-value'=>'Submit'),
          br,
          "Combine search terms with : ",
          "<INPUT TYPE=RADIO NAME=bool VALUE=OR CHECKED>OR ",
          "<INPUT TYPE=RADIO NAME=bool VALUE=AND>AND ",
          hidden('rh'),
          end_form;
  }
}

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
