#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use RIB::Parser;
use XML::DOM;

##############################################

my $util = new RIB::Util();
my $rp = new RIB::Parser;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;
my $ribversion = $util->RibVersion();
$util->dbConnect();

unless (param('rh') =~ /^\d+$/) {
  $util->error("Repository handle not specified");
}
my $repoHandle = param('rh');

my $configFile = "$ribdir/docRoot/$repoHandle/config.xml";
eval {
  unless ($rp->parse_config_file($configFile)) {
    $util->error("Can't parse configuration file : " . $rp->errormsg());
  }
};
if ($@) {
  $util->error("Can't parse configuration file : $@");
}

my $sth = $util->dbh->prepare("SELECT name,handle,contact,primary_class,"
                            . "primary_attribute FROM repositories where "
                            . "handle=$repoHandle");
eval { $sth->execute(); };
if ($@) { $util->error("Database error. $@"); }

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);

my @info = $sth->fetchrow_array();
my $repo_element = $document->createElement('repository');
$repo_element->setAttribute('name',$info[0]);
$repo_element->setAttribute('handle',$info[1]);
$repo_element->setAttribute('contact',$info[2]);
$repo_element->setAttribute('primClass',$info[3]);
$repo_element->setAttribute('primAttr',$info[4]);
$repo_element->setAttribute('config',"$riburl/".$info[1]."/config.xml");
$rib_element->appendChild($repo_element);

foreach my $class (@{$rp->classes()}) {
  next if $class->name() eq 'RigObject';
  my $class_element = $document->createElement('class');
  $class_element->setAttribute('name',$class->name());
  $class_element->setAttribute('objects',"$riburl/listObjects.pl?rh=$repoHandle&class=".$class->name());
  $repo_element->appendChild($class_element);
}

print header(-type=>"text/xml"),
      $document->toString();

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
