#BANGLINE

##############################################
use strict;
use File::Find;
use CGI qw/:standard :netscape/;
use DBI;
use RIB::Util;
use File::Path;

##############################################
my $util = new RIB::Util;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;
my $sth = undef;

unless (param('password'))
{
  print header,
        start_html('-title'=>'Enter RIB password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter RIB Password')),
        p,hr,p,
        "Please enter the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80),
        submit, end_form, end_html;
  goto FALLOFF;
}

$util->dbConnect();
$util->authenticate(param('password'),undef);

if (param('rh') !~ /^\d+$/) {
  $sth = $util->dbh->prepare("select name,handle from repositories");
  eval { $sth->execute(); };
  if ($@) { $util->error("database error $@"); }
  my %repositories = ();
  while (my $row = $sth->fetchrow_arrayref) {
    $repositories{$row->[0]} = $row->[1];
  }
  unless (keys %repositories) {
    print header,
          start_html('-title'=>'Delete a repository',-BGCOLOR=>'#FFFFFF'),
          center(h1('Delete a Repository')),
          p,hr,p,
          "There are currently not any repositories to delete.",
          end_html;
    goto FALLOFF;
  }
  print header,
        start_html('-title'=>'Delete a repository',-BGCOLOR=>'#FFFFFF'),
        center(h1('Delete a repository')),
        p,hr,p,
        "Please choose the repository to delete<P>",
        start_form,
        hidden(-name=>'password'),
        "<SELECT NAME=\"rh\">";
  foreach (sort keys %repositories) {
        print "<OPTION VALUE=",
              $repositories{$_},
              ">$_";
  }
  print "</SELECT>",
        submit, end_form, end_html;
  goto FALLOFF;
}

unless (param('verified')) {
  print header,
        start_html('-title'=>'Delete a repository', -BGCOLOR=>'#FFFFFF'),
        center(h1('Delete a repository')),
        p,hr,p,
        "When you delete a repository the HTML catalog, uploaded files, ",
        "and objects in that repository will all be permanently erased. If any ",
        "repositories are interoperating with the deleted repository then ",
        "they will contain stale pointers to the objects that are erased. ",
        "Caution should be used before taking this action since a repository ",
        "cannot be restored after it has been deleted.",
        p,
        "Are you sure that you want to delete this repository?",
        p,
        start_form,
        hidden(-name=>'password'),
        hidden(-name=>'verified',-value=>1),
        hidden(-name=>'rh'),
        submit(-value=>'Yes'),
        end_form,
        #p,
        #start_form(-action=>'top.pl'),
        #hidden(-name=>'password'),
        #submit(-value=>'No'),
        end_form,
        end_html;
  goto FALLOFF;
}

##############################################
# check input - carefule since we're removing files
unless (param('rh') =~ /^[A-Za-z0-9]+/) {
  $util->error("a repository handle was not specified in your input");
}

# delete the files from the repository directory. careful here!
my @notwritable = ();
sub wanted {
  !-w && (chmod (0770, $File::Find::name) || push (@notwritable,$File::Find::name));
}
find(\&wanted,"$ribdir/docRoot/" . param('rh'));

if (@notwritable) {
  my $files = undef;
  foreach (@notwritable) { $files.= "<li>$_\n"; }
  $util->error("Your http user (&quot;". (getpwuid($<))[0]. "&quot;) ".
               "doesn't have write permissions for the following file(s) ".
               "and/or directory(s):\n".
               "<ul>$files</ul>\n".
               "<p>Before this repository can be deleted those files need ".
               "to be deleted manually.");
}

$sth = $util->dbh->prepare("SHOW TABLES");
$sth->execute or $util->error($DBI::errstr);
my $tmpref = $sth->fetchall_arrayref;
my @tables = ();
my $handle = param('rh');

foreach (@{$tmpref}) {
  $_->[0] =~ /^${handle}_/ or next;
  $util->dbh->do("drop table ".$_->[0]) or $util->error($DBI::errstr);
}

eval {
  $util->dbh->do("delete from repositories where handle=" . param('rh'));
  $util->dbh->do("delete from sequences where table_name like '"
                 . param('rh') . "\\__%'");
};
if ($@) {  $util->error($@); }

unless (rmtree ("$ribdir/docRoot/" . param('rh'))) {
  $util->error("Can't rmtree $ribdir/docRoot/" . param('rh') . " : $!");
}

print header,
      start_html('-title'=>'Delete a repository', -BGCOLOR=>'#FFFFFF'),
      center(h1('Delete a repository')),
      p,hr,p,
      "The repository was successfully deleted.",
      p,
      start_form(-action=>'top.pl'),
      hidden(-name=>'password'),
      submit(-value=>'Return to the RIB management page'),
      end_form,
      end_html;

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
