#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::ObjectCreator;

my $util = new RIB::Util();
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}
my $newObject = param('newObject');
unless (defined($newObject) and $newObject=~/^<\?xml\s/) {
  $util->error("new object not supplied in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

my $oc = new RIB::ObjectCreator();
my $response;
eval { $response = $oc->createObject(param('newObject'),param('rh'),$util); };
if ($@) { $util->error($@); }
if ($response !~ /^http:\/\//) {
  $util->error($response);
}
print header(-type=>"text/plain"), $response;

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
