#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;

##############################################

my $util = new RIB::Util();

unless (param('rh') =~ /^\d+$/) {
  $util->error("repository handle not specified in input");
}

$util->dbConnect();
$util->authenticate(param('repoPasswd'),param('rh'));

unless (param('newContact') =~ /^\S+$/) {
  $util->error("new contact not specified in input");
}

my $sth = $util->dbh->prepare("UPDATE repositories SET contact="
                   . $util->dbh->quote(param('newContact'))
                   . " WHERE handle="
                   . param('rh'));
unless ($sth->execute) {
  $util->error($util->dbh->errstr);
}

print header(-type=>"text/plain"), "ok";

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
