#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::Util;
use RIB::Catalog;
use RIB::Parser;

my $util = new RIB::Util();
$util->dbConnect();
my $ribdir = $util->RibDir();
my $riburl = $util->RibUrl();

# determine repository handle
my $repoHandle = param('rh');
unless ($repoHandle =~ /^\d+$/) {
  $util->error("Properly formatted repository handle not supplied");
}

# parse repository configuration
my $rp = new RIB::Parser;
eval {
  $rp->parse_config_file("$ribdir/docRoot/$repoHandle/config.xml");
};
if ($@) {
  $util->error("Can't create catalog : " . $@);
}

# instantiate catalog object
my $catalog = new RIB::Catalog();
$catalog->dbh($util->dbh);
$catalog->repoHandle($repoHandle);
$catalog->config($rp);

# allow alternative primary class/attribute
if (param('primClass') or param('primAttr')) {
  $util->authenticate(param('repoPasswd'),$repoHandle);
  if (param('primClass' =~ /^\w+$/)) {
    $catalog->primClass(param('primClass'));
  }
  if (param('primAttr' =~ /^\w+$/)) {
    $catalog->primAttr(param('primAttr'));
  }
}

if (param('term')) {
  unless (param('term') =~ /^[\d\!]+/) {
    $util->error("Improperly formatted term.");
  }
}

# print catalog
print header,
      $catalog->buildCatalog(param('term'));

FALLOFF:
$util->{dbh} && $util->{dbh}->disconnect();
