package RIB::Util;

use DBI;
use strict;
use Carp;

sub new {
  my $proto = shift;
  my $class = ref($proto) || $proto;
  my $self  = {
    'dbh' => undef
  };
  bless ($self, $class);
  return $self;
}

sub dbConnect {
  my $self = shift;
  # set up a database connection
  eval {
    #my $dbh = DBI->connect('DBI:mysql:database=rib;mysql_socket=', 'mcmahan', 'asdfasdf');
    my $dbh = DBI->connect('DBI:mysql:database=rib', 'mcmahan', 'asdfasdf');
    $dbh or $self->error($DBI::errstr);
    $self->dbh($dbh);
  };
  if ($@) {
    $self->error("Can't connect to database. " . $@);
  }
  END { $self->{'dbh'} and $self->{'dbh'}->disconnect; }
}

sub authenticate {
  my ($self,$passwd,$repoHandle) = @_;
  #get the main rib password
  my $dbh = $self->dbh;
  $dbh or $self->error("database connection not established");
  my $sth = $dbh->prepare("select password from admin");
  $sth->execute or $self->error($DBI::errstr);
  my $main_rib_password = $sth->fetchrow_array;
  my $current_password = undef;
  if (defined($repoHandle)) { # $repoHandle==undef => main password is required
    if ($repoHandle !~ /^\d*$/) {
      $self->error("Improperly formatted repository handle.");
    }
    #get the repository password and name
    $sth = $dbh->prepare("SELECT password FROM repositories "
                       . "WHERE handle="
                       . $repoHandle);
    eval { $sth->execute(); };
    if ($@) { $self->error($@); }
    $current_password = $sth->fetchrow_array;
  }

  #check the password supplied by the user
  unless ((defined $current_password and ($passwd eq $current_password))
                         or
          $passwd eq $main_rib_password) {
    $self->error("Incorrect password");
  }
}

sub authenticateTry {
  my ($self,$passwd,$repoHandle) = @_;
  if (defined($repoHandle) && $repoHandle !~ /^\d+$/) {
    $self->error("Improperly formatted repository handle.");
  }
  #get the main rib password
  my $dbh = $self->dbh;
  $dbh or $self->error("database connection not established");
  my $sth = $dbh->prepare("select password from admin");
  $sth->execute or $self->error($DBI::errstr);
  my $main_rib_password = $sth->fetchrow_array;
  my $current_password = undef;
  if ($repoHandle) {
    #get the repository password and name
    $sth = $dbh->prepare("SELECT password FROM repositories "
                       . "WHERE handle="
                       . $repoHandle);
    eval { $sth->execute(); };
    if ($@) { $self->error($@); }
    $current_password = $sth->fetchrow_array;
  }
  #check the password supplied by the user
  unless ((defined $current_password and ($passwd eq $current_password))
                         or
          $passwd eq $main_rib_password) {
    return 0;
  }
  return 1;
}

sub RibDir { '/paulm/rib'; }
sub RibUrl { 'http://tozgnaw.cs.utk.edu:9000'; }
sub RibVersion { '2.0'; }

sub dbh {
  my $self = shift;
  if (@_) { $self->{'dbh'} = shift }
  return $self->{'dbh'};
}

sub error {
  my ($self,$error) = @_;
  if (defined ($error)) {
    print "Content-type: text/plain\n\nerror: $error";
  } else {
    print "Content-type: text/plain\n\nerror: undefined error";
  }
  exit(0);
}

sub html_error {
  my ($self,$error) = @_;
  print "Content-type: text/html\n\n",
        "<HEAD><TITLE>Error</TITLE></HEAD>\n",
        "<BODY>Error: $error</BODY>";
  exit 0;
}

sub getSequence {
  my ($self,$table_name) = @_;
  my $dbh = $self->dbh;
  my $sth = undef;
  my $seq = undef;

  eval {
    $dbh->do("LOCK TABLES sequences WRITE");
    $sth = $dbh->prepare("SELECT _seq FROM sequences WHERE table_name='$table_name'");
    $sth->execute();
    unless (($seq) = $sth->fetchrow_array) {
      $sth = $dbh->prepare("INSERT INTO sequences (table_name,_seq) VALUES "
                         . "('$table_name', 0)");
      $sth->execute();
    }
    $seq++;
    $dbh->do("UPDATE sequences SET _seq=$seq WHERE table_name='$table_name'");
    $dbh->do("UNLOCK TABLES");
  };
  if ($@) {
    $self->error("Error creating sequence : " . $@);
  }
  return $seq;
}

sub deleteSequence {
  my ($self,$table_name) = @_;
  my $dbh = $self->dbh;
  my $sth = undef;
  my $seq = undef;

  eval {
    $sth = $dbh->prepare("DELETE FROM sequences WHERE table_name='$table_name'");
    $sth->execute();
  };
  if ($@) {
    $self->error("Error creating sequence : " . $@);
  }
  return $seq;
}

1;
