#BANGLINE

##############################################
use strict;
use CGI qw/:standard :netscape/;
use RIB::BIDMParser;    # this is for parsing objects from version < 2.0
use RIB::ConfigParser;  # this is for parsing configs from version < 2.0
use RIB::DomainParser;  # this is for parsing domains from version < 2.0
use XML::DOM;
use LWP::UserAgent;
use RIB::Parser;
use RIB::Util;
use RIB::RepositoryCreator;
use RIB::ObjectCreator;
use RIB::Object;

##############################################
my $rp = new RIB::Parser;
my $util = new RIB::Util;
my $ribdir = $util->RibDir;
my $riburl = $util->RibUrl;
my $ribversion = $util->RibVersion();
my $sth = undef;
my $newdir = '';
my @errors = ();
my $repo_handle;

my $RelAttrNameMaxSize = 50;

unless (param('password'))
{
  print header,
        start_html('-title'=>'Enter RIB password',-BGCOLOR=>'#FFFFFF'),
        center(h1('Enter RIB Password')),
        p,hr,p,
        "Please enter the main RIB password in the form below<p>\n",
        start_form,
        password_field(-name=>'password', -size=>50, -maxlength=>80),
        submit(-value=>'Submit'), end_form, end_html;
  goto FALLOFF;
}

$util->dbConnect();
$util->authenticate(param('password'),undef);
my $password = param('password');
my $interop_handle = param('interop_handle');

unless (param('start')) {
  print header;
  print <<"EOF";
<HTML>
<HEAD><TITLE>Import a repository</TITLE></HEAD>
<BODY BGCOLOR="#FFFFFF">
<CENTER><H1>Import a repository</H1></CENTER>
<P><HR><P>
When you import a repository, its data model and all of its approved objects
are copied to a new repository managed by your installation or RIB.
Importing a repository does not copy
its interoperations or HTML templates; those must be installed separately
from within the new repository's administration interface.
<P>
In the form below, please enter a name,
contact address, and password for the new repository. You will also
need the interoperation handle for the repository that you want to import.
The interoperation handle can be found by clicking on the
&quot;About&quot; link at the bottom of the repository's catalog web page.
While importing objects, RIB will automatically adjust
the value of any relationships that point
to objects that are also imported during the operation.
<P>
You can import
a repository that was created using RIB version 1.x. The interoperation handle
for RIB v1.x repositories is available on the catalog table of contents
page near the bottom (the link says &quot;local Assets&quot;). If you
import a RIB v1.x repository then all of the Asset objects from that
repository are copied into the new repository. The objects that each Asset points
at (either directly or indirectly) via relationships are also copied if they
are in the same repository as the Asset.
Note that this operation will
only copy objects that are connected in some way to an Asset object (some
objects in the repository might be &quot;orphaned&quot;).
<P><HR><P>

<FORM ACTION="importRepository.pl" METHOD="POST">
<TABLE>
  <TR>
    <TD>Name:</TD>
    <TD><INPUT NAME="name" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Contact email address:</TD>
    <TD><INPUT NAME="contact" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Password:</TD>
    <TD><INPUT NAME="new_password" TYPE="password" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Retype Password:</TD>
    <TD><INPUT NAME="new_password2" TYPE="password" SIZE="50" MAXLENGTH="128"></TD>
  </TR>
  <TR>
    <TD>Repository's interoperation handle:</TD>
    <TD><INPUT NAME="interop_handle" SIZE="50" MAXLENGTH="128" VALUE="$interop_handle"></TD>
  </TR>
</TABLE>
<INPUT TYPE="hidden" NAME="password" VALUE="$password">
<INPUT TYPE="hidden" NAME="start" VALUE="1">
<P>
After clicking the &quot;Submit&quot; button below it is important that you
do not interrupt your web browser until the import process has completed.
Importing a repository which has a slow network connection can take several
minutes or even hours, depending on the number of objects in that repository.
Importing a repository with an extremely slow network connect can fail
completely (resulting in a timeout message from your browser).
<P>
<INPUT TYPE="submit" VALUE="Submit">
<P>
</FORM>
</BODY>
</HTML>
EOF
  goto FALLOFF;
}

##############################################
# check inputs

# clear leading and trailing whitespace
foreach ('name','contact','interop_handle') {
  my $tmp = param($_);
  $tmp =~ s/^\s*//; $tmp =~ s/\s*$//;
  param($_,$tmp);
}
unless (param('name')) {
  $util->error("a repository name was not specified in your input");
}
unless (param('contact') =~ /.+@.+/) {
  $util->error("an email address should be supplied for the contact");
}
unless (defined(param('new_password'))) {
  $util->error("a password was not specified in your input");
}
unless (length(param('new_password')) >= 5) {
  $util->error("password should contain at least 5 characters");
}
unless (param('new_password') eq param('new_password2')) {
  $util->error("passwords didn't match");
}
unless (defined(param('interop_handle'))) {
  $util->error("Repository's interoperation handle was not specified in your input");
}

##############################################
# figure out if the supplied interoperation handle
# points at a RIB v1.x or RIB v2.x repository.

my $content;
eval { $content = &getURL(param('interop_handle')); };
if ($@) { $util->error($@); }
unless (length($content)>0) {
  $util->error("Interoperation handle didn't lead to any information");
}

$| = 1; #unbuffer
print header,
      start_html('-title'=>'Import a repository', -BGCOLOR=>'#FFFFFF'),
      center(h1('Import a repository')),
      p,hr,p,
      "<!-- ";

if ($content !~ /^<\?xml\s/) {
  my $config_url;
  my $domains_url;
  my $objects_url;
  if (param('interop_handle') =~ /^(.+)\/.+repository=(.+)$/) {;
    $config_url = "$1/repositories/$2/conf/BIDM.conf";
    $domains_url = "$1/repositories/$2/conf/domains.html";
    $objects_url = "$1/repositories/$2/objects/";
  } else {
    $util->error("Can't retrieve remote repository's configuration file");
  }
  # retrieve config and parse
  my $buf;
  eval { $buf = &getURL($config_url); };
  if ($@) { $util->error($@); }
  unless (length($buf)) {
    $util->error("Remote repository's data model cannot be parsed.");
  }
  my $cp = new RIB::ConfigParser(); # this sucker can parse RIB 1.x
  $cp->parse($buf);
  unless ($cp->Classes) {
    $util->error("Remote repository data model cannot be parsed.");
  }

  ###################################################
  # make an XML encoded data model for the data model
  my $document = new XML::DOM::Document();
  my $xml_decl = new XML::DOM::XMLDecl();
  $xml_decl->setVersion('1.0');
  $xml_decl->setStandalone('yes');
  $document->setXMLDecl($xml_decl);
  my $rib_element = $document->createElement('rib');
  $rib_element->setAttribute('version',$ribversion);
  $document->appendChild($rib_element);

  # keep a pointer to the Asset::Domain attribute when it's found
  my $domain_element = undef;

  foreach my $class ($cp->Classes()) {
    next unless $class =~ /^[a-zA-Z\_]+/;
    my $class_element = $document->createElement('class');
    my $oldClass = $cp->InstanceOf('',$class);

    ## attributes
    foreach my $attribute ($oldClass->Attributes()) {
      if ($attribute eq 'Name') {
        next unless $class eq 'RigObject'; # Name can't be overridden
      }
      my $attribute_element = $document->createElement('attribute');
      $attribute_element->setAttribute("name",$attribute);
      $attribute_element->addText($oldClass->Desc($attribute));
      if ($oldClass->IsRequired($attribute)) {
        $attribute_element->setAttribute("status","req");
      } else {
        $attribute_element->setAttribute("status","opt");
      }
      if ($oldClass->IsMultiple($attribute)) {
        $attribute_element->setAttribute("cardinality","mult");
      } else {
        $attribute_element->setAttribute("cardinality","single");
      }
      if ($oldClass->IsShowable($attribute)) {
        $attribute_element->setAttribute("display","show");
      } else {
        $attribute_element->setAttribute("display","noshow");
      }
      if (my $dtype = $oldClass->DataType($attribute)) {
        $attribute_element->setAttribute("dtype",$dtype);
      }
      if (my $alt = $oldClass->Alt($attribute)) {
        if ($alt ne $attribute) {
          $attribute_element->setAttribute("alt",$alt);
        }
      }
      $class_element->appendChild($attribute_element);
      if ($class eq 'Asset' and $attribute eq 'Domain') {
        $domain_element = $attribute_element;
      }
    }

    ## relationships
    foreach my $relationship ($oldClass->Relationships()) {
      my $relationship_element = $document->createElement('relationship');
      if (my $dest = $oldClass->Destination($relationship)) {
        $relationship_element->setAttribute("name","$relationship.$dest");
      } else {
        next;
      }
      $relationship_element->addText($oldClass->Desc($relationship));
      $class_element->appendChild($relationship_element);
      if ($oldClass->IsRequired($relationship)) {
        $relationship_element->setAttribute("status","req");
      } else {
        $relationship_element->setAttribute("status","opt");
      }
      if ($oldClass->IsMultiple($relationship)) {
        $relationship_element->setAttribute("cardinality","mult");
      } else {
        $relationship_element->setAttribute("cardinality","single");
      }
      if ($oldClass->IsShowable($relationship)) {
        $relationship_element->setAttribute("display","show");
      } else {
        $relationship_element->setAttribute("display","noshow");
      }
      if (my $alt = $oldClass->Alt($relationship)) {
        $relationship_element->setAttribute("alt",$alt);
      }
      $class_element->appendChild($relationship_element);
    }

    $class_element->setAttribute('name',$class);

    # add in "extends" class info
    if ($oldClass->{'_hash'}{'EXTENDS'}) {
      $class_element->setAttribute('extends',$oldClass->{'_hash'}{'EXTENDS'});
    }

    $rib_element->appendChild($class_element);
  }

  # retrieve domains file and parse
  if ($domain_element) {
    eval { $buf = &getURL($domains_url); };
    if ($@) { $util->error($@); }
    eval {
      my $dp = RIB::DomainParser->new();
      if ($dp->parse($buf)){
        my %domains_hash = ();
        foreach my $domain ($dp->domains) {
          my $lastElement = $domain_element;
          my $buf = '';
          foreach my $term (split(/!/,$domain)) {
            $buf .= $term;
            unless ($domains_hash{$buf}) {
              # create the term element
              my $term_element = $document->createElement('term');
              $term_element->setAttribute('value',$term);

              # update the domains_hash
              $domains_hash{$buf} = $term_element;

              # add it to the appropriate parent node
              if ($buf =~ /(.+)![^!]+/) { # has a term parent
                $domains_hash{$1}->appendChild($term_element);
              } else { # has an attribute parent
                $domain_element->appendChild($term_element);
              }
            }
            $buf .= "!";
          }
        }
      }
    };
  }

  # make sure we can parse the config we just created. We'll also
  # use this parser later.
  my $rp = new RIB::Parser();
  eval { $rp->parse_config($document->toString()); };
  if ($@) { $util->error($@); }
  my $oc = new RIB::ObjectCreator($rp);
  
  my $rc = new RIB::RepositoryCreator();
  my $response;
  eval {
    $response = $rc->createRepository(
                      $document->toString(),
                      param('name'),
                      param('contact'),
                      param('new_password'),
                      $util);
  };
  if ($@) { $util->error($@); }
  if ($response !~ /^\d+$/) { $util->error($response); }
  $repo_handle = $response;

  my $sth = $util->dbh->prepare("UPDATE repositories SET primary_class='Asset', "
                              . "primary_attribute='Domain' WHERE "
                              . "handle=$repo_handle");
  eval { $sth->execute(); };
  if ($@) { push (@errors,"Can't set primary class and attribute"); }

  ## reconfigure the interop_objects table
  eval {
    $util->dbh->do("DROP TABLE $repo_handle\_interop_objects");
  };
  if ($@) {
    push (@errors,"Can't set primary class and attribute. Interoperation will not work for this repository.");
  }
  else {
    my $query = "CREATE TABLE $repo_handle\_interop_objects (";
    foreach my $field (@{$rp->getClass("Asset")->attributes},@{$rp->getClass("Asset")->relationships}) {
      my $fieldname = $field->name;
      $fieldname =~ s/\./\_/;
      $query .= "$fieldname\_ TEXT, ";
    }
    $query .= "url TEXT, owner_handle BIGINT UNSIGNED, "
            . "last_modified TIMESTAMP, created TIMESTAMP)";
    
    $sth = $util->dbh->prepare($query);
    eval { $sth->execute(); };
    if ($@) {
      push (@errors,"Can't set primary class and attribute. Interoperation will not work for this repository.");
    }
  }

  # now retrieve and add all the objects from the repository
  # start with Asset objects and follow any local relationships
  my @urls = ();
  my %urls_cache = ();
  foreach my $url (split(/[\s\n]+/,$content)) {
    next unless $url =~ /:\/\//;
    push (@urls,$url);
  }
  while (my $url = shift(@urls)) {
    print ".\n"; # for browser keep-alive
    next if defined $urls_cache{$url};
    #$url =~ m,/rib/repositories/[^/]+/objects/([^/]+)/,;
    $url =~ m,.+/repositories/[^/]+/objects/([^/]+)/,;
    my $class_name = $1;
    my $class;
    next unless $class = $rp->getClass($class_name);
    eval { $buf = &getURL($url); };
    if ($@) {
      push (@errors, "Can't retrieve $url");
      next;
    }
    my $bp = RIB::BIDMParser->new();
    eval { $bp->parse($buf); };
    if ($@) {
      push (@errors, "Can't parse object at $url");
      next;
    }
    unless ($bp->valueof("Name")) { # Name is always required in 2.0
      push (@errors, "Can't create object for $url : no Name attribute");
      next;
    }

    # make XML for a new object
    my $object = new XML::DOM::Document();
    my $xml_decl = new XML::DOM::XMLDecl();
    $xml_decl->setVersion('1.0');
    $xml_decl->setStandalone('yes');
    $object->setXMLDecl($xml_decl);
    my $rib_element = $object->createElement('rib');
    $rib_element->setAttribute('version',$ribversion);
    $object->appendChild($rib_element);
    my $repo_element = $object->createElement('repository');
    $rib_element->appendChild($repo_element);
    my $class_element = $object->createElement('class');
    $class_element->setAttribute('name',$class_name);
    $repo_element->appendChild($class_element);
    my $object_element = $object->createElement('object');
    $class_element->appendChild($object_element);

    foreach my $attribute (@{$class->attributes}) {
      foreach my $value ($bp->valuesof($attribute->name)) {
        my $attribute_element = $object->createElement('attribute');
        $attribute_element->setAttribute('name',$attribute->name);
        $attribute_element->addText($value);
        $object_element->appendChild($attribute_element);
      }
    }
    foreach my $relationship (@{$class->relationships}) {
      $relationship->name =~ /^(\w+)\.\w+/;
      my $tmpname = $1;
      foreach my $value ($bp->valuesof($tmpname)) {
        if ($value =~ m,^$objects_url,) {
          unshift (@urls,$value);
        }
        my $relationship_element = $object->createElement('relationship');
        $relationship_element->setAttribute('name',$relationship->name);
        $relationship_element->addText($value);
        $object_element->appendChild($relationship_element);
      }
    }
    my $response;
    eval {
      $response = $oc->createObject($object->toString(), $repo_handle, $util);
    };
    if ($@) {
      push @errors, "Can't create object from $url : $@";
      next;
    }
    if ($response !~ /^http:\/\//) {
      push (@errors, "Can't create object from $url : $response");
      next;
    }
    $urls_cache{$url} = $response;
  }

  ## now update all relationships that should point at local objects
  foreach my $oldUrl (keys %urls_cache) {
    my $newUrl = $urls_cache{$oldUrl};
    foreach my $class (@{$rp->classes}) {
      foreach my $relationship (@{$class->relationships}) {
        eval {
          my $relname = $relationship->name;
          $relname =~ s/\./_/;
          $util->dbh->do("UPDATE $repo_handle\_"
                       . $class->name()
                       . " SET $relname\_ = "
                       . $util->dbh->quote($newUrl)
                       . " WHERE $relname\_ = "
                       . $util->dbh->quote($oldUrl));
        };
      }
    }
  }
}

else {

  # parse the document pointed at by the interop handle
  my $parser = new XML::DOM::Parser;
  my $doc = undef;
  eval { $doc = $parser->parse($content); };
  if ($@) { $util->error($@); }
  unless ($doc) { $util->error("Can't parse document at ".param('interop_handle'));}
  my $repoNode = undef;
  eval { $repoNode = $doc->getElementsByTagName("repository")->item(0); };
  if ($@ or (!($repoNode))) {
    $util->error("Remote repository's data model cannot be retrieved.");
  }

  # get the repository's config file
  my $config_url = $repoNode->getAttribute("config");
  my $buf;
  eval { $buf = &getURL($config_url); };
  if ($@) { $util->error($@); }
  unless (length($buf)) {
    $util->error("Remote repository's data model cannot be parsed.");
  }
  unless ($buf =~ /^<\?xml\s/) {
    $util->error("Remote repository's data model cannot be parsed.");
  }
  # make sure the config looks legit. will use $rp later also
  my $rp = new RIB::Parser();
  eval { $rp->parse_config($buf); };
  if ($@) { $util->error("Can't parse repository's data model at $config_url"); }
  my $oc = new RIB::ObjectCreator($rp);

  # use the config file to create a new repository
  my $rc = new RIB::RepositoryCreator();
  my $response;
  eval {
    $response = $rc->createRepository(
                      $buf,
                      param('name'),
                      param('contact'),
                      param('new_password'),
                      $util);
  };
  if ($@) { $util->error($@); }
  if ($response !~ /^\d+$/) { $util->error($response); }
  $repo_handle = $response;

  # set primary class and primary attribute
  my $primClass = $repoNode->getAttribute("primClass");
  my $primAttr = $repoNode->getAttribute("primAttr");
  unless (defined $primAttr) { $primAttr = ""; }
  $sth = $util->dbh->prepare("UPDATE repositories SET primary_class="
                           . $util->dbh->quote($primClass)
                           . ",primary_attribute="
                           . $util->dbh->quote($primAttr)
                           . " WHERE handle=$repo_handle");
  eval { $sth->execute(); };
  if ($@) { push (@errors,"Can't set primary class and attirbute"); }

  ## reconfigure the interop_objects table
  eval {
    $util->dbh->do("DROP TABLE $repo_handle\_interop_objects");
  };
  if ($@) {
    push (@errors,"Can't set primary class and attribute. Interoperation will not work for this repository.");
  } else {
    my $query = "CREATE TABLE $repo_handle\_interop_objects (";
    foreach my $field (@{$rp->getClass($primClass)->attributes},@{$rp->getClass($primClass)->relationships}) {
      my $fieldname = $field->name;
      $fieldname =~ s/\./\_/;
      $query .= "$fieldname\_ TEXT, ";
    }
    $query .= "url TEXT, owner_handle BIGINT UNSIGNED, "
            . "last_modified TIMESTAMP, created TIMESTAMP)";
  
    $sth = $util->dbh->prepare($query);
    eval { $sth->execute(); };
    if ($@) {
      push (@errors,"Can't set primary class and attribute. Interoperation will not work for this repository.");
    }
  }


  # now start copying the objects
  my %urls_cache = ();
  my $classNodeList = $doc->getElementsByTagName("class");
  for (my $i=0; $i<$classNodeList->getLength(); $i++) {
    print ".\n"; # for browser keep-alive
    my $classNode = $classNodeList->item($i);
    my $objectsUrl = $classNode->getAttribute("objects");
    my $response;
    eval { $response = &getURL($objectsUrl); };
    if ($@) {
      push @errors, "Can't retrieve objects list at $objectsUrl : $@";
      next;
    }
    if ($response !~ /^<\?xml\s/) {
      push @errors, "Can't parse objects list at $objectsUrl";
      next;
    }
    my $objectsList = $response;
    my $parser = new XML::DOM::Parser;
    my $doc = undef;
    eval { $doc = $parser->parse($objectsList); };
    if ($@ or !(defined $doc)) {
      push @errors, "Can't parse objects list at $objectsUrl";
      next;
    }
    my $objectNodeList = $doc->getElementsByTagName("object");
    for (my $i=0; $i<$objectNodeList->getLength(); $i++) {
      print ".\n"; # for browser keep-alive
      my $objectNode = $objectNodeList->item($i);
      my $objectUrl = $objectNode->getAttribute("url");
      next unless $objectUrl;
      next if defined $urls_cache{$objectUrl};
      my ($c, $oh, $rh);
      if ($objectUrl =~ m,^\Q$riburl\E/object.pl\?(.+),) {
        my $params = $1;
        $params =~ /class=(\w+)/;
        $c = $1;
        $params =~ /oh=(\d+)/;
        $oh = $1;
        $params =~ /rh=(\d+)/;
        $rh = $1;
      }
      my $response;
      eval {
        if ($c ne '' and $oh ne '' and $rh ne '') {
          my $o = new RIB::Object( $util->dbh, $rh, $c,
                                   $oh, param('password') );
  
          $response = $o->asXML();
        }
        else {
          $response = &getURL($objectUrl);
        }
      };
      if ($@) {
        push @errors, "Can't create object from $objectUrl: $@";
        next;
      }
      if ($response !~ /^<\?xml\s/) {
        push @errors, "Can't parse object at $objectUrl";
        next;
      }
      my $object_xml = $response;
      eval {
        $response = $oc->createObject($object_xml, $repo_handle, $util);
      };
      if ($@) {
        push @errors, "Can't copy object from $objectUrl : $@";
        next;
      }
      if ($response !~ /^http:\/\//) {
        push (@errors, "Can't copy object from $objectUrl : $response");
        next;
      }
      $urls_cache{$objectUrl} = $response;
    }
  }

  ## now update all relationships that should point at local objects
  foreach my $oldUrl (keys %urls_cache) {
    my $newUrl = $urls_cache{$oldUrl};
    foreach my $class (@{$rp->classes}) {
      foreach my $relationship (@{$class->relationships}) {
        my $relname = $relationship->name;
        $relname =~ s/\./_/;
        eval {
          $util->dbh->do("UPDATE $repo_handle\_"
                       . $class->name()
                       . " SET $relname\_ = "
                       . $util->dbh->quote($newUrl)
                       . " WHERE $relname\_ = "
                       . $util->dbh->quote($oldUrl));
        };
      }
    }
  }
}

print "-->",
      p,
      "The repository was successfully imported.",
      p;

if (@errors) {
  print "The following errors occurred:\n<UL>";
  foreach (@errors) {
    print "<LI>$_\n";
  }
  print "</UL><P>\n";
}
print start_form(-action=>'top.pl'),
      hidden(-name=>'password'),
      submit(-value=>'Return to the RIB management page'),
      end_form,
      start_form(-action=>"adminRepository.pl?rh=$repo_handle"),
      hidden(-name=>'password'),
      hidden(-name=>'came_from_top', -value=>'1'),
      hidden(-name=>'rh', -value=>$repo_handle),
      submit(-value=>'Go to the administration page for '
                   . param('name')),
      end_form,
      end_html;

sub getURL {
  my $url = shift;
  my $content = "";
  my $ua = new LWP::UserAgent;
  $ua->agent("RIB/2.0 " . $ua->agent);
  my $req = HTTP::Request->new('GET' => $url);
  my $res = $ua->request($req);
  if (!($res->is_success)) {
    die $res->status_line;
  } else {
    $content = $res->content();
  }
  return $content;
}


FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
