/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.Component;
import java.text.StringCharacterIterator;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;

public class RibUtil {
    public static boolean alphaChars(String str) {
        if (str == null) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(str.toUpperCase());
        char c = iter.first();
        while (c != '\uffff') {
            if (c < 'A' || c > 'Z') {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    public static boolean alphanumericChars(String str) {
        if (str == null) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(str.toUpperCase());
        char c = iter.first();
        while (c != '\uffff') {
            if (!(c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '-' || Character.isWhitespace(c))) {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    public static boolean alphanumericsymbolChars(String str) {
        if (str == null) {
            return false;
        }
        StringCharacterIterator iter = new StringCharacterIterator(str.toUpperCase());
        char c = iter.first();
        while (c != '\uffff') {
            if (c < ' ' || c > '~') {
                return false;
            }
            c = iter.next();
        }
        return true;
    }

    public static String collapseString(String s) {
        String buf = new String();
        if (s == null) {
            return buf;
        }
        if (s.trim().length() == 0) {
            return buf;
        }
        StringCharacterIterator iter = new StringCharacterIterator(s.trim());
        boolean firstSpace = true;
        char c = iter.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                if (firstSpace) {
                    buf = String.valueOf(buf) + ' ';
                }
                firstSpace = false;
            } else {
                buf = String.valueOf(buf) + c;
                firstSpace = true;
            }
            c = iter.next();
        }
        return buf;
    }

    public static String getAlphabeticDialogInput(String prompt, int maxlength, Component parent) {
        String input;
        while (true) {
            if ((input = (String)JOptionPane.showInputDialog(parent, prompt, null, 3, null, null, "")) == null) {
                return null;
            }
            if (input.length() > maxlength) {
                JOptionPane.showMessageDialog(parent, "Input must be less than " + String.valueOf(maxlength) + " characters.");
                continue;
            }
            if (RibUtil.alphaChars(input)) break;
            JOptionPane.showMessageDialog(parent, "Input must contain only alphabetic characters.");
        }
        return input;
    }

    public static String getAlphanumericDialogInput(String prompt, int maxlength, Component parent) {
        String input;
        while (true) {
            if ((input = (String)JOptionPane.showInputDialog(parent, prompt, null, 3, null, null, "")) == null) {
                return null;
            }
            if (input.length() > maxlength) {
                JOptionPane.showMessageDialog(parent, "Input must be less than " + String.valueOf(maxlength) + " characters.");
                continue;
            }
            if (RibUtil.alphanumericChars(input)) break;
            JOptionPane.showMessageDialog(parent, "Input must contain only alphanumeric characters.");
        }
        return input;
    }

    public static String getAlphanumericsymbolDialogInput(String prompt, int maxlength, Component parent) {
        String input;
        while (true) {
            if ((input = (String)JOptionPane.showInputDialog(parent, prompt, null, 3, null, null, "")) == null) {
                return null;
            }
            if (input.length() > maxlength) {
                JOptionPane.showMessageDialog(parent, "Input must be less than " + String.valueOf(maxlength) + " characters.");
                continue;
            }
            if (input.indexOf("!") >= 0 || input.indexOf("\"") >= 0 || input.indexOf("<") >= 0 || input.indexOf(">") >= 0) {
                JOptionPane.showMessageDialog(parent, "Input should not contain the !, \", <, or > characters.");
                continue;
            }
            if (RibUtil.alphanumericsymbolChars(input)) break;
            JOptionPane.showMessageDialog(parent, "Input should only contain alphanumeric and symbols on your keyboard.");
        }
        return input;
    }

    public static Hashtable getInteropIntervals() {
        Hashtable<String, String> intervalHash = new Hashtable<String, String>();
        intervalHash.put("30 minutes", String.valueOf(1800));
        intervalHash.put("1 hour", String.valueOf(3600));
        intervalHash.put("2 hours", String.valueOf(7200));
        intervalHash.put("3 hours", String.valueOf(10800));
        intervalHash.put("6 hours", String.valueOf(21600));
        intervalHash.put("12 hours", String.valueOf(43200));
        intervalHash.put("1 day", String.valueOf(86400));
        intervalHash.put("2 days", String.valueOf(172800));
        intervalHash.put("3 days", String.valueOf(259200));
        intervalHash.put("6 days", String.valueOf(518400));
        intervalHash.put("12 days", String.valueOf(1036800));
        intervalHash.put("1 month", String.valueOf(2592000));
        return intervalHash;
    }

    public static String getRibVersion() {
        return "2.1";
    }

    public static String[] getSortedInteropIntervals() {
        String[] vals = new String[]{"30 minutes", "1 hour", "2 hours", "3 hours", "6 hours", "12 hours", "1 day", "2 days", "3 days", "6 days", "12 days", "1 month"};
        return vals;
    }

    public static Vector sortStringVector(Vector v) {
        int vsize = v.size();
        if (vsize == 0) {
            return v;
        }
        Vector x = new Vector();
        x.addElement(v.firstElement());
        int i = 1;
        while (i < vsize) {
            String str = (String)v.elementAt(i);
            int j = 0;
            while (j < i) {
                String xstr = (String)x.elementAt(j);
                if (str.toLowerCase().compareTo(xstr.toLowerCase()) < 1) {
                    x.insertElementAt(new String(str), j);
                    break;
                }
                if (j == i - 1) {
                    x.addElement(new String(str));
                }
                ++j;
            }
            ++i;
        }
        return x;
    }
}

