/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.Reader;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibInteropShell;
import org.nhse.rib.RibUtil;
import org.nhse.rib.TableSorter;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RibInteropShell
extends JPanel {
    RibComm ribComm;
    RibInterface ribInterface;
    Vector repoList = new Vector();
    Vector columnNames = new Vector();
    JTable table;
    TableSorter sorter;
    JScrollPane scrollpane;
    Hashtable intervalHash;
    String[] intervals;

    public RibInteropShell(RibInterface ri, RibComm rc) {
        this.setLayout(new FlowLayout(1, 5, 5));
        this.setBackground(Color.white);
        this.setSize(0, 0);
        this.ribInterface = ri;
        this.ribComm = rc;
        this.setLayout(new BorderLayout());
        this.intervalHash = RibUtil.getInteropIntervals();
        this.intervals = RibUtil.getSortedInteropIntervals();
        this.sorter = new TableSorter(new MyTableModel());
        this.table = new JTable(this.sorter);
        this.table.setShowHorizontalLines(false);
        this.sorter.addMouseListenerToHeaderInTable(this.table);
        this.table.addMouseListener(new PopupListener());
        this.scrollpane = new JScrollPane(this.table);
        this.add((Component)this.scrollpane, "Center");
        JToolBar jtb = new JToolBar();
        jtb.setBorder(new BevelBorder(1));
        ((Container)jtb).setLayout(new BoxLayout(jtb, 0));
        jtb.setFloatable(false);
        JButton createButton = new JButton("  Create  ");
        createButton.addMouseListener(new ButtonPushMouseListener(createButton));
        jtb.add(createButton);
        createButton.setToolTipText("Create a new interoperation");
        createButton.addActionListener(new 1());
        jtb.add(Box.createHorizontalStrut(2));
        JButton refreshButton = new JButton("  Refresh  ");
        refreshButton.addMouseListener(new ButtonPushMouseListener(refreshButton));
        jtb.add(Box.createHorizontalStrut(2));
        jtb.add(refreshButton);
        refreshButton.setToolTipText("Contact server to refresh \"Last Attempt\" column below");
        refreshButton.addActionListener(new 2());
        HelpButton helpButton = new HelpButton("interoperation.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, refreshButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on interoperation");
        jtb.add(Box.createHorizontalStrut(2));
        jtb.add(helpButton);
        this.add((Component)jtb, "North");
        this.refreshTable();
    }

    public void listObjects() {
        int rowCount = this.table.getSelectedRowCount();
        String[] handles = new String[rowCount];
        int[] rows = this.table.getSelectedRows();
        int i = 0;
        while (i < rows.length) {
            int index = rows[i];
            handles[i] = (String)this.sorter.getValueAt(index, 3);
            ++i;
        }
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        NodeList objectsList = null;
        try {
            objectsList = this.ribComm.listInteropObjects(handles);
        }
        catch (Exception e2) {
            this.ribInterface.showAlert(e2.toString());
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        if (objectsList.getLength() == 0) {
            this.ribInterface.showAlert("There are no objects from the selected interoperation(s)");
            return;
        }
        Vector<String> objectNames = new Vector<String>();
        Hashtable<String, String> objectUrls = new Hashtable<String, String>();
        int i2 = 0;
        while (i2 < objectsList.getLength()) {
            Element object = (Element)objectsList.item(i2);
            objectNames.addElement(object.getAttribute("name"));
            objectUrls.put(object.getAttribute("name"), object.getAttribute("url"));
            ++i2;
        }
        Vector sorted = RibUtil.sortStringVector(objectNames);
        JList jlist = new JList(sorted);
        jlist.setSelectionMode(0);
        jlist.addMouseListener(new 9(jlist, objectUrls, this));
        Container parent = this.getParent();
        while (!(parent instanceof Frame)) {
            parent = ((Component)parent).getParent();
        }
        JDialog jd = new JDialog((Frame)parent, "Interoperation objects", true);
        jd.getContentPane().setLayout(new BorderLayout());
        JToolBar jtb2 = new JToolBar();
        ((Container)jtb2).setLayout(new FlowLayout());
        JButton okButton = new JButton("  Ok  ");
        jtb2.setFloatable(false);
        okButton.addActionListener(new 10(jd));
        okButton.addMouseListener(new ButtonPushMouseListener(okButton));
        jtb2.add(okButton);
        JScrollPane jsp = new JScrollPane(jlist);
        jd.getContentPane().add((Component)jsp, "Center");
        jd.getContentPane().add((Component)jtb2, "South");
        jd.getContentPane().add((Component)new JLabel("   Double click an object to view it   "), "North");
        jd.pack();
        jd.setLocationRelativeTo(this.ribInterface);
        jd.show();
        jd.addWindowListener(new 11(jd));
    }

    public void refreshTable() {
        NodeList nl = null;
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            nl = this.ribComm.listInterops();
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        if (nl == null) {
            return;
        }
        this.repoList = new Vector(nl.getLength());
        int i = 0;
        while (i < nl.getLength()) {
            Element element = (Element)nl.item(i);
            String name = element.getAttribute("name");
            String handle = element.getAttribute("handle");
            String url = element.getAttribute("url");
            String last_attempt = element.getAttribute("last_attempt");
            String last_success = element.getAttribute("last_success");
            String update_interval = element.getAttribute("update_interval");
            String checkpoint = element.getAttribute("checkpoint");
            String last_failure = element.getAttribute("last_failure");
            if (name != null && handle != null && url != null && last_attempt != null && last_success != null && update_interval != null && checkpoint != null && last_failure != null) {
                Vector<String> interopInfo = new Vector<String>(5);
                interopInfo.addElement(name);
                String interval = null;
                Enumeration e = this.intervalHash.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String val = String.valueOf(this.intervalHash.get(key));
                    if (!val.equals(update_interval)) continue;
                    interval = new String(key);
                    break;
                }
                if (interval != null) {
                    interopInfo.addElement(interval);
                } else {
                    Integer x = Integer.valueOf(update_interval);
                    String time = String.valueOf(String.valueOf(x / 3600)) + " hours";
                    if (time.equals("0 hours")) {
                        time = String.valueOf(String.valueOf(x / 60)) + " minutes";
                    }
                    interopInfo.addElement(time);
                }
                try {
                    String dateString = String.valueOf(last_attempt.substring(0, 4)) + "/" + last_attempt.substring(4, 6) + "/" + last_attempt.substring(6, 8) + " at " + last_attempt.substring(8, 10) + ":" + last_attempt.substring(10, 12);
                    if (last_attempt.equals("00000000000000")) {
                        interopInfo.addElement("never tried");
                    } else if (Long.parseLong(last_attempt, 10) > Long.parseLong(last_success, 10)) {
                        if (Long.parseLong(checkpoint, 10) > Long.parseLong(last_failure, 10)) {
                            interopInfo.addElement(String.valueOf(dateString) + " (running)");
                        } else {
                            interopInfo.addElement(String.valueOf(dateString) + " (failed)");
                        }
                    } else {
                        interopInfo.addElement(String.valueOf(dateString) + " (completed)");
                    }
                }
                catch (Exception e2) {
                    interopInfo.addElement("???" + e2.toString());
                    this.ribInterface.showAlert(e2.toString());
                }
                interopInfo.addElement(handle);
                interopInfo.addElement(url);
                this.repoList.addElement(interopInfo);
            }
            ++i;
        }
        this.sorter.tableChanged(new TableModelEvent(this.table.getModel()));
        this.sorter.sortByColumn(0);
    }

    private void showLog() {
        int index = this.table.getSelectedRow();
        String handle = (String)this.sorter.getValueAt(index, 3);
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                String inputLine;
                Reader reader = this.ribComm.getInteropLog(handle);
                Container parent = this.getParent();
                while (!(parent instanceof Frame)) {
                    parent = ((Component)parent).getParent();
                }
                JDialog jd = new JDialog((Frame)parent, "Interoperation log", true);
                jd.getContentPane().setLayout(new BorderLayout());
                JToolBar jtb2 = new JToolBar();
                ((Container)jtb2).setLayout(new FlowLayout());
                JButton okButton = new JButton("  Ok  ");
                JTextArea jta = new JTextArea(30, 60);
                jtb2.setFloatable(false);
                okButton.addActionListener(new 7(jd));
                okButton.addMouseListener(new ButtonPushMouseListener(okButton));
                jtb2.add(okButton);
                String content = new String();
                BufferedReader br = new BufferedReader(reader);
                while ((inputLine = br.readLine()) != null) {
                    content = String.valueOf(content) + inputLine + "\n";
                }
                jta.setLineWrap(true);
                jta.setWrapStyleWord(true);
                jta.setCursor(Cursor.getPredefinedCursor(2));
                jta.setEditable(false);
                jta.setText(content);
                jta.setCaretPosition(0);
                JScrollPane jsp = new JScrollPane(jta);
                jd.getContentPane().add((Component)jsp, "Center");
                jd.getContentPane().add((Component)jtb2, "South");
                jd.pack();
                jd.setLocationRelativeTo(this.ribInterface);
                jd.show();
                jd.addWindowListener(new 8(jd));
            }
            catch (Exception e2) {
                this.ribInterface.showAlert(e2.toString());
            }
            Object var4_14 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        }
        catch (Throwable throwable) {
            Object var4_15 = null;
            this.ribInterface.showStatus("");
            this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
    }

    static /* synthetic */ void access$0(RibInteropShell $0) {
        $0.showLog();
    }

    private final class 1
    implements ActionListener {
        /* synthetic */ 1() {
        }

        public void actionPerformed(ActionEvent ae) {
            String[] handles = new String[RibInteropShell.this.repoList.size()];
            int i = 0;
            Enumeration e = RibInteropShell.this.repoList.elements();
            while (e.hasMoreElements()) {
                Vector v = (Vector)e.nextElement();
                handles[i] = String.valueOf(RibInteropShell.this.ribInterface.ribUrl) + "/cgi-bin/repository.pl?rh=" + (String)v.elementAt(3);
                ++i;
            }
            RibInteropShell.this.ribInterface.createInterop(handles);
        }
    }

    private final class 2
    implements ActionListener {
        /* synthetic */ 2() {
        }

        public void actionPerformed(ActionEvent ae) {
            RibInteropShell.this.ribInterface.showStatus("Accessing network...");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
            RibInteropShell.this.refreshTable();
            RibInteropShell.this.ribInterface.showStatus("");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class MyTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Repository Name", "Update Interval", "Last Attempt"};

        MyTableModel() {
            RibInteropShell.this = RibInteropShell.this;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int row) {
            return this.columnNames[row];
        }

        public int getRowCount() {
            return RibInteropShell.this.repoList.size();
        }

        public Object getValueAt(int row, int col) {
            Vector v = (Vector)RibInteropShell.this.repoList.elementAt(row);
            return v.elementAt(col);
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setValueAt(Object obj, int row, int col) {
            Vector v = (Vector)RibInteropShell.this.repoList.elementAt(row);
            v.setElementAt(obj, col);
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
            RibInteropShell.this = RibInteropShell.this;
        }

        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                return;
            }
            if (e.getClickCount() == 2) {
                RibInteropShell.this.listObjects();
            }
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void showPopup(MouseEvent e) {
            int rowCount = RibInteropShell.this.table.getSelectedRowCount();
            if (rowCount < 1) {
                return;
            }
            JPopupMenu jpm = new JPopupMenu();
            JMenuItem objects = new JMenuItem("List objects from interoperation");
            jpm.add(objects);
            objects.addActionListener(new 3(this));
            JMenuItem log = new JMenuItem("View last update log");
            if (rowCount > 1) {
                log.setEnabled(false);
            }
            jpm.add(log);
            log.addActionListener(new 4(this));
            JMenuItem force_update = new JMenuItem("Start an update");
            force_update.addActionListener(new 5(rowCount, this));
            jpm.add(force_update);
            JMenuItem delete = new JMenuItem("Delete");
            delete.addActionListener(new 6(rowCount, this));
            jpm.add(delete);
            JMenu interval = new JMenu("Set update interval");
            jpm.add(interval);
            int i = 0;
            while (i < RibInteropShell.this.intervals.length) {
                JMenuItem jmi = new JMenuItem(RibInteropShell.this.intervals[i]);
                jmi.addActionListener(new UpdateIntervals());
                interval.add(jmi);
                ++i;
            }
            jpm.pack();
            if (e.getY() - RibInteropShell.this.scrollpane.getViewport().getViewPosition().y + jpm.getPreferredSize().height > RibInteropShell.this.scrollpane.getViewport().getHeight()) {
                jpm.show(e.getComponent(), e.getX(), e.getY() - jpm.getPreferredSize().height);
            } else {
                jpm.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        static /* synthetic */ RibInteropShell access$0(PopupListener $0) {
            return $0.RibInteropShell.this;
        }
    }

    class UpdateIntervals
    implements ActionListener {
        UpdateIntervals() {
            RibInteropShell.this = RibInteropShell.this;
        }

        public void actionPerformed(ActionEvent ae) {
            String message;
            int answer;
            JMenuItem jmi = (JMenuItem)ae.getSource();
            String interval = jmi.getText();
            String seconds = (String)RibInteropShell.this.intervalHash.get(interval);
            int[] rows = RibInteropShell.this.table.getSelectedRows();
            String[] handles = new String[rows.length];
            if (rows.length > 1 && (answer = JOptionPane.showConfirmDialog(RibInteropShell.this.ribInterface, message = "Are you sure you want to change the update\ninterval for the " + rows.length + " selected repositories?", "Confirm update", 0, 3, null)) == 1) {
                return;
            }
            int i = 0;
            while (i < rows.length) {
                int index = rows[i];
                handles[i] = (String)RibInteropShell.this.sorter.getValueAt(index, 3);
                ++i;
            }
            RibInteropShell.this.ribInterface.showStatus("Accessing network...");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
            String response = RibInteropShell.this.ribComm.setUpdateIntervals(handles, seconds);
            RibInteropShell.this.ribInterface.showStatus("");
            RibInteropShell.this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
            if (!response.equals("ok")) {
                RibInteropShell.this.ribInterface.showAlert(response);
                return;
            }
            RibInteropShell.this.refreshTable();
        }
    }

    private static final class 7
    implements ActionListener {
        private final /* synthetic */ JDialog val$jd;

        /* synthetic */ 7(JDialog val$jd) {
            this.val$jd = val$jd;
        }

        public void actionPerformed(ActionEvent ae) {
            ((Component)this.val$jd).setVisible(false);
            this.val$jd.dispose();
        }
    }

    private static final class 8
    extends WindowAdapter {
        private final /* synthetic */ JDialog val$jd;

        /* synthetic */ 8(JDialog val$jd) {
            this.val$jd = val$jd;
        }

        public void windowClosing(WindowEvent e) {
            ((Component)this.val$jd).setVisible(false);
            this.val$jd.dispose();
        }
    }

    private static final class 9
    extends MouseAdapter {
        private final /* synthetic */ RibInteropShell this$0;
        private final /* synthetic */ JList val$jlist;
        private final /* synthetic */ Hashtable val$objectUrls;

        /* synthetic */ 9(JList val$jlist, Hashtable val$objectUrls, RibInteropShell this$0) {
            this.val$jlist = val$jlist;
            this.val$objectUrls = val$objectUrls;
            this.this$0 = this$0;
        }

        public void mouseClicked(MouseEvent me) {
            block3: {
                if (me.getClickCount() != 2) break block3;
                try {
                    String urlStr = new String((String)this.val$objectUrls.get((String)this.val$jlist.getSelectedValue()));
                    if (urlStr.indexOf("/rib/repositories/") < 0) {
                        urlStr = String.valueOf(urlStr) + "&html=1";
                    }
                    URL url = new URL(urlStr);
                    this.this$0.ribInterface.getAppletContext().showDocument(url, "_blank");
                }
                catch (Exception e2) {
                    this.this$0.ribInterface.showAlert(e2.toString());
                }
            }
        }
    }

    private static final class 10
    implements ActionListener {
        private final /* synthetic */ JDialog val$jd;

        /* synthetic */ 10(JDialog val$jd) {
            this.val$jd = val$jd;
        }

        public void actionPerformed(ActionEvent ae) {
            ((Component)this.val$jd).setVisible(false);
            this.val$jd.dispose();
        }
    }

    private static final class 11
    extends WindowAdapter {
        private final /* synthetic */ JDialog val$jd;

        /* synthetic */ 11(JDialog val$jd) {
            this.val$jd = val$jd;
        }

        public void windowClosing(WindowEvent e) {
            ((Component)this.val$jd).setVisible(false);
            this.val$jd.dispose();
        }
    }
}

