/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import com.ibm.xml.parser.TXDocument;
import com.ibm.xml.parser.TXElement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.StringCharacterIterator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.nhse.rib.ButtonPushMouseListener;
import org.nhse.rib.HelpButton;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibComm;
import org.nhse.rib.RibConfig;
import org.nhse.rib.RibConfigEditor;
import org.nhse.rib.RibInterface;
import org.nhse.rib.RibObjectEditor;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;
import org.nhse.rib.RibVocabularyTerm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RibConfigEditor
extends JPanel {
    private RibConfig ribConfig;
    private RibComm ribComm;
    private RibInterface ribInterface;
    private JTree jtree;
    private JScrollPane jsp;
    private DefaultMutableTreeNode rigObjectNode;
    public JButton saveButton;
    private JButton cancelButton;
    private JButton importButton;
    private JPanel mainPanel = this;

    RibConfigEditor(RibConfig r1, RibComm r2, RibInterface ri) {
        this.ribConfig = r1;
        this.ribComm = r2;
        this.ribInterface = ri;
        this.init();
    }

    private boolean checkFieldName(String name) {
        StringCharacterIterator iter = new StringCharacterIterator(name.toUpperCase());
        if (!Character.isLetter(iter.first())) {
            JOptionPane.showMessageDialog(this.mainPanel, "Field name must start with an alphabetic character");
            return false;
        }
        boolean spaceFound = false;
        char c = iter.first();
        while (c != '\uffff') {
            if (Character.isWhitespace(c)) {
                spaceFound = true;
            }
            c = iter.next();
        }
        if (spaceFound) {
            JOptionPane.showMessageDialog(this.mainPanel, "Field name should not contain any whitespace characters");
            return false;
        }
        return true;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EtchedBorder());
        this.removeAll();
        if (this.ribConfig.getClasses().size() == 0) {
            JLabel label = new JLabel("  Error: " + this.ribConfig.errorMsg);
            this.add((Component)label, "Center");
            return;
        }
        Vector<ClassTreeNode> classTreeNodes = new Vector<ClassTreeNode>();
        Enumeration e = this.ribConfig.getClasses(true).elements();
        while (e.hasMoreElements()) {
            RibClass ribClass = (RibClass)e.nextElement();
            classTreeNodes.addElement(new ClassTreeNode(ribClass));
        }
        Enumeration e2 = classTreeNodes.elements();
        while (e2.hasMoreElements()) {
            ClassTreeNode classTreeNode = (ClassTreeNode)e2.nextElement();
            RibClass ribClass = this.ribConfig.getClass(classTreeNode.toString());
            String lookFor = ribClass.getExtends();
            Enumeration e22 = classTreeNodes.elements();
            while (e22.hasMoreElements()) {
                ClassTreeNode tmp = (ClassTreeNode)e22.nextElement();
                if (!tmp.toString().equals(lookFor)) continue;
                tmp.getSubclasses().add(classTreeNode);
            }
        }
        Enumeration e3 = classTreeNodes.elements();
        while (e3.hasMoreElements()) {
            ClassTreeNode classTreeNode = (ClassTreeNode)e3.nextElement();
            if (!classTreeNode.toString().equals("RigObject")) continue;
            this.rigObjectNode = classTreeNode;
            break;
        }
        this.jtree = new JTree(this.rigObjectNode);
        this.jtree.addMouseListener(new PopupListener());
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.setToolTipText("Right click a node to edit its properties");
        this.jtree.setModel(new DefaultTreeModel(this.rigObjectNode, true));
        Enumeration e4 = classTreeNodes.elements();
        while (e4.hasMoreElements()) {
            ClassTreeNode classTreeNode = (ClassTreeNode)e4.nextElement();
            DefaultMutableTreeNode dmt = (DefaultMutableTreeNode)classTreeNode.getParent();
            if (dmt == null) continue;
            TreePath tp = new TreePath(dmt.getPath());
            this.jtree.expandPath(tp);
        }
        this.jsp = new JScrollPane(this.jtree);
        this.jsp.setPreferredSize(new Dimension(100, 100));
        this.add((Component)this.jsp, "Center");
        this.saveButton = new JButton("  Save  ");
        this.saveButton.addActionListener(new 1());
        this.saveButton.addMouseListener(new ButtonPushMouseListener(this.saveButton));
        this.saveButton.setToolTipText("Save changes and exit data model editor");
        this.cancelButton = new JButton("  Cancel  ");
        this.cancelButton.addActionListener(new 3());
        this.cancelButton.addMouseListener(new ButtonPushMouseListener(this.cancelButton));
        this.cancelButton.setToolTipText("Cancel without saving");
        this.importButton = new JButton("  Import...  ");
        this.importButton.setToolTipText("Import a data model from a URL");
        this.importButton.addActionListener(new 4());
        this.importButton.addMouseListener(new ButtonPushMouseListener(this.importButton));
        HelpButton helpButton = new HelpButton("properties_data_model_editor.html", this.ribInterface);
        helpButton.setMaximumSize(new Dimension(helpButton.getPreferredSize().width, this.saveButton.getPreferredSize().height));
        helpButton.setToolTipText("Display help on the data model editor");
        JToolBar buttonPanel = new JToolBar();
        buttonPanel.setFloatable(false);
        buttonPanel.setBorder(new BevelBorder(1));
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(this.saveButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(this.cancelButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(this.importButton);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(helpButton);
        this.add((Component)buttonPanel, "North");
        this.jtree.revalidate();
        this.saveButton.revalidate();
        this.cancelButton.revalidate();
        this.importButton.revalidate();
    }

    private TXElement[] makeTermElements(RibVocabularyTerm root) {
        Vector children = root.getChildren();
        TXElement[] elements = new TXElement[children.size()];
        int i = 0;
        while (i < children.size()) {
            RibVocabularyTerm rvt = (RibVocabularyTerm)children.elementAt(i);
            TXElement termElement = new TXElement("term");
            termElement.setAttribute("value", rvt.getTerm());
            elements[i] = termElement;
            if (rvt.getChildren().size() > 0) {
                TXElement[] childElements = this.makeTermElements(rvt);
                int j = 0;
                while (j < childElements.length) {
                    termElement.appendChild((Node)childElements[j]);
                    ++j;
                }
            }
            ++i;
        }
        return elements;
    }

    private VocabularyTreeNode[] makeVocabularyTreeNodes(Vector terms) {
        VocabularyTreeNode[] nodes = new VocabularyTreeNode[terms.size()];
        int i = 0;
        while (i < terms.size()) {
            RibVocabularyTerm rvt = (RibVocabularyTerm)terms.elementAt(i);
            nodes[i] = new VocabularyTreeNode(rvt);
            VocabularyTreeNode[] children = this.makeVocabularyTreeNodes(rvt.getChildren());
            if (children.length > 0) {
                nodes[i].setAllowsChildren(true);
            }
            int j = 0;
            while (j < children.length) {
                nodes[i].add(children[j]);
                ++j;
            }
            ++i;
        }
        return nodes;
    }

    private void saveConfiguration() {
        String response;
        JPanel objectsPanel = this.ribInterface.objectsPanel;
        if (objectsPanel.getComponentCount() > 0 && objectsPanel.getComponent(0) instanceof RibObjectEditor) {
            int confirm = JOptionPane.showConfirmDialog(this.mainPanel, "Saving this data model will cancel the object that is currently\nbeing edited in the \"Manage Objects\" tab. Are you sure that you want to proceed?", "Question", 2, 3);
            if (confirm != 0) {
                return;
            }
            objectsPanel.removeAll();
        } else if (objectsPanel.getComponentCount() > 0) {
            objectsPanel.removeAll();
        }
        TXDocument doc = new TXDocument();
        try {
            doc.setVersion("1.0");
            doc.setStandalone("yes");
            Element rootElement = doc.createElement("rib");
            rootElement.setAttribute("version", RibUtil.getRibVersion());
            doc.appendChild((Node)rootElement);
            Enumeration e = this.ribConfig.getClasses().elements();
            while (e.hasMoreElements()) {
                RibClass rc = (RibClass)e.nextElement();
                Element classElement = doc.createElement("class");
                classElement.setAttribute("name", rc.getName());
                classElement.setAttribute("extends", rc.getExtends());
                Enumeration e2 = rc.getNativeAttributes().elements();
                while (e2.hasMoreElements()) {
                    RibAttribute ra = (RibAttribute)e2.nextElement();
                    TXElement attributeElement = new TXElement("attribute");
                    attributeElement.setAttribute("name", ra.getName());
                    attributeElement.setAttribute("alt", ra.getAlt());
                    attributeElement.setAttribute("cardinality", ra.getCardinality());
                    attributeElement.setAttribute("display", ra.getDisplay());
                    attributeElement.setAttribute("dtype", ra.getDtype());
                    attributeElement.setAttribute("status", ra.getStatus());
                    if (ra.hasVocabulary()) {
                        TXElement[] elements = this.makeTermElements(ra.getVocabulary());
                        int i = 0;
                        while (i < elements.length) {
                            attributeElement.appendChild((Node)elements[i]);
                            ++i;
                        }
                    }
                    if (ra.getDesc() != null) {
                        attributeElement.appendChild((Node)doc.createTextNode(ra.getDesc()));
                    }
                    classElement.appendChild((Node)attributeElement);
                }
                Enumeration e22 = rc.getNativeRelationships().elements();
                while (e22.hasMoreElements()) {
                    RibRelationship rr = (RibRelationship)e22.nextElement();
                    TXElement relationshipElement = new TXElement("relationship");
                    relationshipElement.setAttribute("name", rr.getName());
                    relationshipElement.setAttribute("alt", rr.getAlt());
                    relationshipElement.setAttribute("cardinality", rr.getCardinality());
                    relationshipElement.setAttribute("display", rr.getDisplay());
                    relationshipElement.setAttribute("status", rr.getStatus());
                    if (rr.getDesc() != null) {
                        relationshipElement.appendChild((Node)doc.createTextNode(rr.getDesc()));
                    }
                    classElement.appendChild((Node)relationshipElement);
                }
                rootElement.appendChild(classElement);
            }
        }
        catch (Exception e) {
            this.ribInterface.showAlert(e.toString());
            return;
        }
        this.ribInterface.showStatus("Accessing network...");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(3));
        try {
            response = this.ribComm.saveConfig(doc);
        }
        catch (Exception e) {
            response = e.toString();
        }
        if (response.equals("ok")) {
            this.ribInterface.initPropertiesPanel();
        } else {
            this.ribInterface.showAlert(response);
        }
        this.ribInterface.showStatus("");
        this.ribInterface.setCursor(Cursor.getPredefinedCursor(0));
    }

    static /* synthetic */ void access$1(RibConfigEditor $0) {
        $0.saveConfiguration();
    }

    static /* synthetic */ RibConfig access$4(RibConfigEditor $0) {
        return $0.ribConfig;
    }

    static /* synthetic */ boolean access$10(RibConfigEditor $0, String $1) {
        return $0.checkFieldName($1);
    }

    private final class 1
    implements ActionListener {
        /* synthetic */ 1() {
        }

        public void actionPerformed(ActionEvent e) {
            int confirm = JOptionPane.showConfirmDialog(RibConfigEditor.this.mainPanel, "Are you sure that you want to save this data model?", "Confirm", 0);
            if (confirm != 0) {
                return;
            }
            SwingUtilities.invokeLater(new 2(RibConfigEditor.this));
        }
    }

    private final class 3
    implements ActionListener {
        /* synthetic */ 3() {
        }

        public void actionPerformed(ActionEvent e) {
            RibConfigEditor.this.ribInterface.initPropertiesPanel();
        }
    }

    private final class 4
    implements ActionListener {
        /* synthetic */ 4() {
        }

        public void actionPerformed(ActionEvent e) {
            Reader reader;
            int confirm = JOptionPane.showConfirmDialog(RibConfigEditor.this.mainPanel, "Importing a data model will replace the one currently being\nedited. Are you sure that you want to take this action?", "Confirm", 0);
            if (confirm != 0) {
                return;
            }
            String url = (String)JOptionPane.showInputDialog(RibConfigEditor.this.mainPanel, "URL : ", null, 3, null, null, null);
            if (url == null) {
                return;
            }
            url.trim();
            if (url.length() == 0) {
                return;
            }
            if (url.indexOf("://") == -1) {
                url = "http://" + url;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, "The url you supplied was not formatted properly.\nProperly formatted urls have the form protocol://machine/path", "Alert", 0);
                return;
            }
            try {
                reader = RibConfigEditor.this.ribComm.doProxy(url);
            }
            catch (Exception e2) {
                JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, e2.toString(), "Alert", 0);
                return;
            }
            try {
                RibConfig rc = new RibConfig(reader);
                rc.parse();
                if (rc.getClasses().size() == 0) {
                    throw new Exception();
                }
                RibConfigEditor.this.ribConfig = rc;
                RibConfigEditor.this.init();
            }
            catch (Exception exception) {
                JOptionPane.showMessageDialog(RibConfigEditor.this.mainPanel, "Invalid data model.", "Alert", 0);
                return;
            }
        }
    }

    class ClassTreeNode
    extends DefaultMutableTreeNode {
        RibClass ribClass;
        DefaultMutableTreeNode subclasses;

        ClassTreeNode(RibClass rc) {
            RibConfigEditor.this = RibConfigEditor.this;
            this.ribClass = rc;
            this.setUserObject(rc.getName());
            AttributeListNode attributes = new AttributeListNode();
            RelationshipListNode relationships = new RelationshipListNode();
            this.subclasses = new SubclassListNode();
            Enumeration e = rc.getNativeAttributes(true).elements();
            while (e.hasMoreElements()) {
                RibAttribute ra = (RibAttribute)e.nextElement();
                RibConfigEditor ribConfigEditor = RibConfigEditor.this;
                ribConfigEditor.getClass();
                AttributeTreeNode atn = ribConfigEditor.new AttributeTreeNode(ra);
                if (ra.hasVocabulary()) {
                    VocabularyTreeNode[] vtn = RibConfigEditor.this.makeVocabularyTreeNodes(ra.getVocabulary().getChildren());
                    int i = 0;
                    while (i < vtn.length) {
                        atn.setAllowsChildren(true);
                        atn.add(vtn[i]);
                        ++i;
                    }
                }
                attributes.add(atn);
            }
            Enumeration e2 = rc.getNativeRelationships(true).elements();
            while (e2.hasMoreElements()) {
                RibRelationship rr = (RibRelationship)e2.nextElement();
                RibConfigEditor ribConfigEditor = RibConfigEditor.this;
                ribConfigEditor.getClass();
                RelationshipTreeNode rtn = ribConfigEditor.new RelationshipTreeNode(rr);
                relationships.add(rtn);
            }
            this.add(attributes);
            this.add(relationships);
            this.add(this.subclasses);
        }

        public RibClass getRibClass() {
            return this.ribClass;
        }

        public DefaultMutableTreeNode getSubclasses() {
            return this.subclasses;
        }
    }

    class AttributeTreeNode
    extends DefaultMutableTreeNode {
        RibAttribute ribAttribute;

        AttributeTreeNode(RibAttribute ra) {
            RibConfigEditor.this = RibConfigEditor.this;
            this.ribAttribute = ra;
            this.setUserObject(ra.getName());
            this.setAllowsChildren(false);
        }
    }

    class RelationshipTreeNode
    extends DefaultMutableTreeNode {
        RibRelationship ribRelationship;

        RelationshipTreeNode(RibRelationship rr) {
            RibConfigEditor.this = RibConfigEditor.this;
            this.ribRelationship = rr;
            this.setUserObject(rr.getName());
            this.setAllowsChildren(false);
        }
    }

    class AttributeListNode
    extends DefaultMutableTreeNode {
        AttributeListNode() {
            RibConfigEditor.this = RibConfigEditor.this;
            this.setUserObject("Attributes");
        }
    }

    class RelationshipListNode
    extends DefaultMutableTreeNode {
        RelationshipListNode() {
            RibConfigEditor.this = RibConfigEditor.this;
            this.setUserObject("Relationships");
        }
    }

    class SubclassListNode
    extends DefaultMutableTreeNode {
        SubclassListNode() {
            RibConfigEditor.this = RibConfigEditor.this;
            this.setUserObject("Subclasses");
        }
    }

    class VocabularyTreeNode
    extends DefaultMutableTreeNode {
        RibVocabularyTerm ribVocabularyTerm;

        VocabularyTreeNode(RibVocabularyTerm rvt) {
            RibConfigEditor.this = RibConfigEditor.this;
            this.ribVocabularyTerm = rvt;
            this.setUserObject(rvt.getTerm());
            this.setAllowsChildren(false);
        }

        public RibVocabularyTerm getRibVocabularyTerm() {
            return this.ribVocabularyTerm;
        }
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
            RibConfigEditor.this = RibConfigEditor.this;
        }

        public void mousePressed(MouseEvent e) {
            TreePath selPath = RibConfigEditor.this.jtree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            RibConfigEditor.this.jtree.addSelectionPath(selPath);
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            TreePath selPath = RibConfigEditor.this.jtree.getPathForLocation(e.getX(), e.getY());
            if (selPath == null) {
                return;
            }
            if (e.isPopupTrigger()) {
                this.showPopup(e);
            }
        }

        private void showPopup(MouseEvent e) {
            TreePath selPath = RibConfigEditor.this.jtree.getSelectionPath();
            if (selPath == null) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
            JPopupMenu jpm = new JPopupMenu();
            if (node instanceof ClassTreeNode) {
                JMenuItem delete = new JMenuItem("Delete this class");
                if (node == RibConfigEditor.this.rigObjectNode) {
                    delete.setEnabled(false);
                }
                jpm.add(delete);
                delete.addActionListener(new 5(node, this));
            } else if (node instanceof AttributeTreeNode) {
                RibAttribute ra = ((AttributeTreeNode)node).ribAttribute;
                JMenuItem desc = new JMenuItem("Description...");
                desc.addActionListener(new 6(ra, this));
                jpm.add(desc);
                JMenuItem alt = new JMenuItem("Alternate name...");
                alt.addActionListener(new 10(ra, this));
                jpm.add(alt);
                JMenu submenu = new JMenu("Status");
                ButtonGroup group = new ButtonGroup();
                JRadioButtonMenuItem opt = new JRadioButtonMenuItem("optional");
                JRadioButtonMenuItem req = new JRadioButtonMenuItem("required");
                if (ra.getStatus().equals("opt")) {
                    opt.setSelected(true);
                } else {
                    req.setSelected(true);
                }
                group.add(opt);
                submenu.add(opt);
                group.add(req);
                submenu.add(req);
                opt.addActionListener(new 11(ra));
                req.addActionListener(new 12(ra, this));
                jpm.add(submenu);
                JMenu submenu2 = new JMenu("Display");
                ButtonGroup group2 = new ButtonGroup();
                JRadioButtonMenuItem show = new JRadioButtonMenuItem("show in catalog");
                JRadioButtonMenuItem noshow = new JRadioButtonMenuItem("don't show in catalog");
                if (ra.getDisplay().equals("noshow")) {
                    noshow.setSelected(true);
                } else {
                    show.setSelected(true);
                }
                group2.add(show);
                submenu2.add(show);
                group2.add(noshow);
                submenu2.add(noshow);
                noshow.addActionListener(new 13(ra));
                show.addActionListener(new 14(ra));
                jpm.add(submenu2);
                JMenu submenu3 = new JMenu("Cardinality");
                ButtonGroup group3 = new ButtonGroup();
                JRadioButtonMenuItem mult = new JRadioButtonMenuItem("multiple");
                JRadioButtonMenuItem single = new JRadioButtonMenuItem("single");
                if (ra.getCardinality().equals("single")) {
                    single.setSelected(true);
                } else {
                    mult.setSelected(true);
                }
                group3.add(mult);
                submenu3.add(mult);
                group3.add(single);
                submenu3.add(single);
                mult.addActionListener(new 15(ra));
                single.addActionListener(new 16(ra));
                jpm.add(submenu3);
                JMenu submenu4 = new JMenu("Data type");
                ButtonGroup group4 = new ButtonGroup();
                JRadioButtonMenuItem text = new JRadioButtonMenuItem("Text");
                JRadioButtonMenuItem string = new JRadioButtonMenuItem("String");
                JRadioButtonMenuItem url = new JRadioButtonMenuItem("URL");
                JRadioButtonMenuItem email = new JRadioButtonMenuItem("Email");
                JRadioButtonMenuItem date = new JRadioButtonMenuItem("Date");
                if (ra.getDtype().equals("string")) {
                    string.setSelected(true);
                } else if (ra.getDtype().equals("url")) {
                    url.setSelected(true);
                } else if (ra.getDtype().equals("email")) {
                    email.setSelected(true);
                } else if (ra.getDtype().equals("date")) {
                    date.setSelected(true);
                } else {
                    text.setSelected(true);
                }
                text.addActionListener(new 17(ra));
                string.addActionListener(new 18(ra));
                url.addActionListener(new 19(ra));
                email.addActionListener(new 20(ra));
                date.addActionListener(new 21(ra));
                group4.add(text);
                submenu4.add(text);
                group4.add(string);
                submenu4.add(string);
                group4.add(url);
                submenu4.add(url);
                group4.add(email);
                submenu4.add(email);
                group4.add(date);
                submenu4.add(date);
                jpm.add(submenu4);
                jpm.addSeparator();
                JMenuItem addTerm = new JMenuItem("Add a vocabulary term");
                addTerm.addActionListener(new 22(node, ra, this));
                jpm.add(addTerm);
                jpm.addSeparator();
                JMenuItem delete = new JMenuItem("Delete this attribute");
                delete.addActionListener(new 23(node, ra, this));
                jpm.add(delete);
                if (ra.getName().equals("Name") && node.getParent().getParent() == RibConfigEditor.this.rigObjectNode) {
                    jpm.getComponent(0).setEnabled(false);
                    jpm.getComponent(2).setEnabled(false);
                    jpm.getComponent(4).setEnabled(false);
                    jpm.getComponent(5).setEnabled(false);
                    jpm.getComponent(6).setEnabled(false);
                    jpm.getComponent(7).setEnabled(false);
                    jpm.getComponent(9).setEnabled(false);
                }
            } else if (node instanceof RelationshipTreeNode) {
                RibRelationship rr = ((RelationshipTreeNode)node).ribRelationship;
                JMenuItem desc = new JMenuItem("Description...");
                desc.addActionListener(new 24(rr, this));
                jpm.add(desc);
                JMenuItem alt = new JMenuItem("Alternate name...");
                alt.addActionListener(new 28(rr, this));
                jpm.add(alt);
                JMenu submenu = new JMenu("Status");
                ButtonGroup group = new ButtonGroup();
                JRadioButtonMenuItem opt = new JRadioButtonMenuItem("optional");
                JRadioButtonMenuItem req = new JRadioButtonMenuItem("required");
                if (rr.getStatus().equals("opt")) {
                    opt.setSelected(true);
                } else {
                    req.setSelected(true);
                }
                group.add(opt);
                submenu.add(opt);
                group.add(req);
                submenu.add(req);
                opt.addActionListener(new 29(rr));
                req.addActionListener(new 30(rr, this));
                jpm.add(submenu);
                JMenu submenu5 = new JMenu("Display");
                ButtonGroup group5 = new ButtonGroup();
                JRadioButtonMenuItem show = new JRadioButtonMenuItem("show in catalog");
                JRadioButtonMenuItem noshow = new JRadioButtonMenuItem("don't show in catalog");
                if (rr.getStatus().equals("noshow")) {
                    noshow.setSelected(true);
                } else {
                    show.setSelected(true);
                }
                group5.add(show);
                submenu5.add(show);
                group5.add(noshow);
                submenu5.add(noshow);
                noshow.addActionListener(new 31(rr));
                show.addActionListener(new 32(rr));
                jpm.add(submenu5);
                JMenu submenu6 = new JMenu("Cardinality");
                ButtonGroup group6 = new ButtonGroup();
                JRadioButtonMenuItem mult = new JRadioButtonMenuItem("multiple");
                JRadioButtonMenuItem single = new JRadioButtonMenuItem("single");
                if (rr.getCardinality().equals("single")) {
                    single.setSelected(true);
                } else {
                    mult.setSelected(true);
                }
                group6.add(mult);
                submenu6.add(mult);
                group6.add(single);
                submenu6.add(single);
                mult.addActionListener(new 33(rr));
                single.addActionListener(new 34(rr));
                jpm.add(submenu6);
                jpm.addSeparator();
                JMenuItem delete = new JMenuItem("Delete this relationship");
                delete.addActionListener(new 35(node, rr, this));
                jpm.add(delete);
            } else if (node instanceof AttributeListNode) {
                JMenuItem add = new JMenuItem("Add a new attribute");
                jpm.add(add);
                add.addActionListener(new 36(node, this));
            } else if (node instanceof RelationshipListNode) {
                JMenuItem add = new JMenuItem("Add a new relationship");
                jpm.add(add);
                add.addActionListener(new 37(node, this));
            } else if (node instanceof SubclassListNode) {
                JMenuItem add = new JMenuItem("Add a new subclass");
                jpm.add(add);
                add.addActionListener(new 41(node, this));
            } else if (node instanceof VocabularyTreeNode) {
                JMenuItem addTerm = new JMenuItem("Add a subvocabulary term");
                addTerm.addActionListener(new 42(node, this));
                jpm.add(addTerm);
                JMenuItem delete = new JMenuItem("Delete this term");
                delete.addActionListener(new 43(node, this));
                jpm.add(delete);
            }
            jpm.pack();
            if (e.getY() + jpm.getPreferredSize().height > RibConfigEditor.this.jsp.getHeight()) {
                jpm.show(e.getComponent(), e.getX(), e.getY() - jpm.getPreferredSize().height);
            } else {
                jpm.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        static /* synthetic */ RibConfigEditor access$0(PopupListener $0) {
            return $0.RibConfigEditor.this;
        }
    }
}

