/*
 * Decompiled with CFR 0.152.
 */
package org.nhse.rib;

import com.ibm.xml.parser.Parser;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import org.nhse.rib.RibAttribute;
import org.nhse.rib.RibClass;
import org.nhse.rib.RibRelationship;
import org.nhse.rib.RibUtil;
import org.nhse.rib.RibVocabularyTerm;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RibConfig {
    private Vector classes = new Vector();
    private String urlString;
    private Reader reader;
    private URL configUrl;
    private long configUrlLastModified;
    public String errorMsg = new String();

    public RibConfig(Reader r) {
        this.reader = r;
    }

    public RibConfig(String urlString) {
        try {
            this.configUrl = new URL(urlString);
            this.urlString = new String(urlString);
        }
        catch (MalformedURLException e) {
            this.errorMsg = e.toString();
            System.out.println("malformed URL : " + urlString);
        }
    }

    public void addClass(RibClass rc) {
        this.classes.addElement(rc);
    }

    private void addTerms(NodeList nl, RibVocabularyTerm rvt) {
        int i = 0;
        while (i < nl.getLength()) {
            Node termNode = nl.item(i);
            if (termNode.getNodeType() == 1) {
                RibVocabularyTerm newTerm = new RibVocabularyTerm(((Element)termNode).getAttribute("value"));
                if (((Element)termNode).getElementsByTagName("term").getLength() > 0) {
                    this.addTerms(termNode.getChildNodes(), newTerm);
                }
                rvt.addChild(newTerm);
            }
            ++i;
        }
    }

    public RibClass getClass(String name) {
        Enumeration e = this.classes.elements();
        while (e.hasMoreElements()) {
            RibClass tmp = (RibClass)e.nextElement();
            if (!tmp.getName().equals(name)) continue;
            return tmp;
        }
        return null;
    }

    public Vector getClassNames(boolean showRigObject) {
        Vector classNameList = new Vector(this.classes.size());
        Enumeration e = this.classes.elements();
        while (e.hasMoreElements()) {
            RibClass rc = (RibClass)e.nextElement();
            if (rc.getName().equals("RigObject")) continue;
            classNameList.addElement(rc.getName());
        }
        classNameList = RibUtil.sortStringVector(classNameList);
        if (showRigObject) {
            classNameList.insertElementAt("RigObject", 0);
        }
        return classNameList;
    }

    public Vector getClasses() {
        return this.classes;
    }

    public Vector getClasses(boolean sort) {
        if (sort) {
            Vector<RibClass> sorted = new Vector<RibClass>(this.classes.size());
            Enumeration e = this.getClassNames(true).elements();
            while (e.hasMoreElements()) {
                String className = (String)e.nextElement();
                sorted.addElement(this.getClass(className));
            }
            return sorted;
        }
        return this.classes;
    }

    /*
     * Unable to fully structure code
     */
    public void parse() {
        if (this.urlString != null) {
            parser = new Parser(this.urlString);
            parser.setExpandEntityReferences(true);
            uc = null;
            is = null;
            try {
                uc = this.configUrl.openConnection();
                uc.setUseCaches(false);
                uc.connect();
                is = uc.getInputStream();
                this.configUrlLastModified = uc.getLastModified();
                doc = parser.readStream(uc.getInputStream());
            }
            catch (IOException e) {
                System.out.println("Error. Cannot retrieve and parse " + this.urlString + ". Reason: " + e);
                this.errorMsg = e.toString();
                return;
            }
        } else if (this.reader != null) {
            try {
                doc = new Parser("configuration").readStream(this.reader);
            }
            catch (Exception e) {
                System.err.println(e.toString());
                return;
            }
        } else {
            System.err.println("Invalid configuration file specification");
            this.errorMsg = "Invalid configuration file specification";
            return;
        }
        root = doc.getDocumentElement();
        classNodes = root.getElementsByTagName("class");
        i = 0;
        while (i < classNodes.getLength()) {
            classNode = (Element)classNodes.item(i);
            attrNodes = classNode.getElementsByTagName("attribute");
            relNodes = classNode.getElementsByTagName("relationship");
            myClass = new RibClass();
            myClass.setName(classNode.getAttribute("name"));
            myClass.setExtends(classNode.getAttribute("extends"));
            j = 0;
            while (j < attrNodes.getLength()) {
                attrNode = (Element)attrNodes.item(j);
                myAttribute = new RibAttribute();
                myAttribute.setName(attrNode.getAttribute("name"));
                myAttribute.setStatus(attrNode.getAttribute("status"));
                myAttribute.setCardinality(attrNode.getAttribute("cardinality"));
                myAttribute.setDtype(attrNode.getAttribute("dtype"));
                myAttribute.setAlt(attrNode.getAttribute("alt"));
                myAttribute.setDisplay(attrNode.getAttribute("display"));
                myClass.addAttribute(myAttribute);
                children = attrNode.getChildNodes();
                k = 0;
                while (k < children.getLength()) {
                    childNode = children.item(k);
                    if (childNode.getNodeType() == 3 && (desc = childNode.getNodeValue().trim()).length() != 0) {
                        myAttribute.setDesc(desc);
                        break;
                    }
                    ++k;
                }
                if (attrNode.getElementsByTagName("term").getLength() > 0) {
                    rvt = new RibVocabularyTerm("root");
                    this.addTerms(attrNode.getChildNodes(), rvt);
                    myAttribute.setVocabulary(rvt);
                }
                ++j;
            }
            j = 0;
            while (j < relNodes.getLength()) {
                relNode = (Element)relNodes.item(j);
                myRelationship = new RibRelationship();
                myRelationship.setName(relNode.getAttribute("name"));
                myRelationship.setStatus(relNode.getAttribute("status"));
                myRelationship.setCardinality(relNode.getAttribute("cardinality"));
                relName = myRelationship.getName();
                i2 = relName.indexOf(".");
                if (i2 > -1) {
                    dest = relName.substring(i2 + 1);
                    myRelationship.setDest(dest);
                    myRelationship.setAlt(relNode.getAttribute("alt"));
                    myRelationship.setDisplay(relNode.getAttribute("display"));
                    children = relNode.getChildNodes();
                    k = 0;
                    while (k < children.getLength()) {
                        childNode = children.item(k);
                        if (childNode.getNodeType() == 3 && (desc = childNode.getNodeValue().trim()) != "") {
                            myRelationship.setDesc(desc);
                            break;
                        }
                        ++k;
                    }
                    myClass.addRelationship(myRelationship);
                }
                ++j;
            }
            this.classes.addElement(myClass);
            ++i;
        }
        rigObjectClass = this.getClass("RigObject");
        if (rigObjectClass == null) {
            this.classes = new Vector<E>();
            this.errorMsg = new String("Repository configuration does not contain a RigObject class");
            return;
        }
        if (rigObjectClass.getAttribute("Name") == null) {
            this.classes = new Vector<E>();
            this.errorMsg = new String("RigObject does not contain a \"Name\" attribute");
            return;
        }
        e1 = this.classes.elements();
        while (e1.hasMoreElements()) {
            rc = (RibClass)e1.nextElement();
            ext = rc.getExtends();
            if (ext == null) continue;
            e2 = this.classes.elements();
            while (e2.hasMoreElements()) {
                rc2 = (RibClass)e2.nextElement();
                if (!rc2.getName().equals(ext)) continue;
                rc.setParentClass(rc2);
            }
        }
        e1 = this.classes.elements();
        while (e1.hasMoreElements()) {
            rc = (RibClass)e1.nextElement();
            if (rc.getName().equals("RigObject")) continue;
            parentClass = rc.getParentClass();
            if (parentClass != null) ** GOTO lbl124
            this.classes.removeElement(rc);
            continue;
lbl-1000:
            // 1 sources

            {
                parentClass = parentClass.getParentClass();
lbl124:
                // 2 sources

                ** while (parentClass.getParentClass() != null)
            }
lbl125:
            // 1 sources

            if (parentClass.getName().equals("RigObject")) continue;
            this.classes.removeElement(rc);
        }
        e1 = this.classes.elements();
        while (e1.hasMoreElements()) {
            rc = (RibClass)e1.nextElement();
            e2 = rc.getRelationships().elements();
            while (e2.hasMoreElements()) {
                rr = (RibRelationship)e2.nextElement();
                if (this.getClass(rr.getDest()) != null) continue;
                rc.removeRelationship(rr);
            }
        }
    }

    public void removeClass(RibClass rc) {
        this.classes.removeElement(rc);
    }
}

