#BANGLINE

##############################################
use strict;
use CGI qw/:standard/;
use RIB::Util;
use XML::DOM;

##############################################

my $util = new RIB::Util();
my $rib_url = $util->RibUrl;
my $ribversion = $util->RibVersion();
$util->dbConnect();

my $sth = $util->dbh->prepare("SELECT name,handle,contact,primary_class,"
                            . "primary_attribute FROM repositories order by name");
eval { $sth->execute(); };
if ($@) { $util->error("Database error. " . $@); }

my $document = new XML::DOM::Document();
my $xml_decl = new XML::DOM::XMLDecl();
$xml_decl->setVersion('1.0');
$xml_decl->setStandalone('yes');
$document->setXMLDecl($xml_decl);
my $rib_element = $document->createElement('rib');
$rib_element->setAttribute('version',$ribversion);
$document->appendChild($rib_element);

while (my @info = $sth->fetchrow_array) {
  my $repo_element = $document->createElement('repository');
  $repo_element->setAttribute('name',$info[0]);
  $repo_element->setAttribute('contact',$info[2]);
  $repo_element->setAttribute('primClass',$info[3]);
  $repo_element->setAttribute('primAttr',$info[4]);
  $repo_element->setAttribute('config',"$rib_url/".$info[1]."/config.xml");
  $repo_element->setAttribute('interop_handle',"$rib_url/repository.pl?rh=".$info[1]);
  $rib_element->appendChild($repo_element);
}

print header(-type=>"text/xml"),
      $document->toString();

FALLOFF:
$sth && $sth->finish();
$util->{dbh} && $util->{dbh}->disconnect();
