/* config.h is generated by configure */
#include	"config.h"

#include	<stdio.h>
#include <stdlib.h>
#include <string.h>

/* TMP is defined by Makefile */
static const char	TMPDIR[] = TMP;

static const char	FILENAME[] = "sam.XXXXXXXXXXXXXXXXXXXX" ;

static void
string_append( char* buffer, const char* string, const int total_buffer_length ) {
		strncat( buffer, string, total_buffer_length );
		buffer[total_buffer_length-1] = 0 ;
}

static void
string_copy( char* buffer, const char* string, const int total_buffer_length ) {
		buffer[0] = 0 ;
		string_append( buffer, string, total_buffer_length );
}

static char*
template_create( char* buffer, const int total_buffer_length ) {
	if (buffer) {
		int	buffer_length_used ;

		string_copy( buffer, TMPDIR, total_buffer_length );
		buffer_length_used = strlen( buffer ) ;
		/* add '/' at the end of TMPDIR if it is missing */
		if ('/' != buffer[buffer_length_used-1]) {
			string_append( buffer, "/", total_buffer_length - buffer_length_used ) ;
			buffer_length_used++ ;
		}
		string_append( buffer, FILENAME, total_buffer_length - buffer_length_used );
	}
	return buffer ;
}

/* declaration type for function pointer. it is >func_p< that is beeing declared. */
typedef	int (* func_p)(char* template) ;

/*
 * if fd_create provides its own template handeling i use a dummy function
 */
static int
no_template( func_p fd_create ) {
	return fd_create( 0 ) ;
}
/*
 * make sure that there is room enough in the local buffer for
 * the full path to the temporary file (or allocate room).
 * call the supplied function that will create a file descriptor from
 * the temporary name. the file will be removed as to be gone when
 * the fd is later closed.
 *
 * return that fd.
 */
static int
a_template( func_p fd_create )
{
	char	buffer[80];
	int	total_template_length ;
	int	fd = -1 ;

	/* TMPDIR and FILENAME reserve space enough for one '/' and one '\0' in template */
	total_template_length = sizeof (TMPDIR) + sizeof (FILENAME) ;
	if (total_template_length < sizeof (buffer)) {
		fd = (*fd_create)( template_create( buffer, sizeof (buffer) ) ) ;
	} else {
		char*		template = 0 ;
		template = malloc( total_template_length ) ;
		/* template_create needs to be able to handle 0 pointers */
		fd = (*fd_create)(  template_create( template, total_template_length ) ) ;
		free( template ) ;
	}
	return (fd);
}

#ifdef	HAVE_MKSTEMP
static int
mkstemp_to_fd( char* template )
{
	int	fd = -1 ;
	if (template) {
		fd = mkstemp( template );
		(void)remove( template );
	}
	return (fd);
}
#define	FD_CREATE			mkstemp_to_fd
#define	TEMPLATE_CREATE	a_template
#endif	/* HAVE_MKSTEMP */

#ifdef	HAVE_MKTEMP
static int
mktemp_to_fd( char* template )
{
	int	fd = -1 ;
	if (template) {
		char*	filename ;
		filename = mktemp( template );
		if (filename) {
			FILE *f;
			f = fopen(filename, "w+");
			(void)remove( filename );
			fd = fileno(f);
		}
	}
	return (fd) ;
}
#define	FD_CREATE			mktemp_to_fd
#define	TEMPLATE_CREATE	a_template
#endif	/* HAVE_MKTEMP */

#ifdef	HAVE_TEMPNAM
int
tempnam_to_fd(char* template) {
	char *s;
	FILE *f;

	s = tempnam(TMPDIR, FILENAME);
	if (!s)
		return -1;
	f = fopen(s, "w+");
	if (!f)
		return -1;
	(void)remove(s);
	free( s );
	return fileno(f);
}
#define	FD_CREATE			tempnam_to_fd
#define	TEMPLATE_CREATE	no_template
#endif	/* HAVE_MKSTEMP */

#ifdef	HAVE_TMPFILE
int
tmpfile_to_fd(char* template) {
	int		fd = -1 ;
	FILE*	f;

	f = tmpfile();
	if (f) {
		fd = fileno(f);
	}
	return fd ;
}
#define	FD_CREATE			tmpfile_to_fd
#define	TEMPLATE_CREATE	no_template
#endif	/* HAVE_TMPFILE */

#ifdef	HAVE_TMPNAM
static int
tmpnam_to_fd(char* template) {
	int		fd = -1 ;
	char*	filename ;

	filename = tmpnam( 0 );
	if (filename) {
		FILE *f;
		f = fopen(filename, "w+");
		(void)remove( filename );
		fd = fileno(f);
	}
	return (fd);
}
#define	FD_CREATE			tmpnam_to_fd
#define	TEMPLATE_CREATE	no_template
#endif	/* HAVE_TMPNAM */

int
newtmp(int i) {
	return (TEMPLATE_CREATE( FD_CREATE ));
}
