#define MAXEVENTS 2000
#define MAXWORDSIZE 35
#define MAXSUCC 25
#define MAXPRED 25


#include <stdio.h>
#include <string.h>
#include "ab-post.h"

/* The structure that will hold an event.  
   Assumptions:
   * Component & machine names are of size <= MAXWORDSIZE
   * Depending on the event type, some fields may be missing. 
*/
/* Revision 1.0: 1993/07/24 swee
 * Added event types for barrier, barrier_done, whoami, initiateM,
 * initiateM_done, putstring, getstring.
*/

typedef int bool;

struct event {
  long event_sec;
  long event_usec;
  int event_type;
  char event_comp[MAXWORDSIZE];  
  int event_pid;
  int event_rc;
  char dest_comp[MAXWORDSIZE];
  char dest_mach[MAXWORDSIZE];
  int dest_pid;
  int msg_type;
  int msg_length;
  int msg_serial;
  int msg_count;
  long abmon_sec;
  long abmon_usec;
  int numsucc;
  int succ[MAXSUCC];
  int numpred;
  int pred[MAXPRED];
  int data; /* used by xab-post routines */
  char name[MAXWORDSIZE];  /* used by barrier */
  int number;
};

int whitespace(c)
char c;
{
  return((c==' ') || (c==',') || (c=='\n')|| (c=='\t'));
}

char next_non_ws(file)
FILE *file;
{
  char c;

  do {(c=getc(file));}
  while (whitespace(c));

  return(c);
}


char *read_word(file)
FILE *file;
{
  char c,word[MAXWORDSIZE];
  int i=0;
  
  word[i++]=next_non_ws(file);

  while(!whitespace(c=getc(file)) && !feof(file))
    word[i++]=c;

  word[i]='\0';

  return(word);
}

char *read_word_or_null(file)
FILE *file;
{
  char c,word[MAXWORDSIZE];
  int i=0;
  
  do
    c=getc(file);
  while ((c!='\n') && (!whitespace(c)) && (!feof(file)));

  if (!whitespace(c) && !feof(file)) {
    word[i++]=c;
    while(!whitespace(c=getc(file)) && !feof(file))
      word[i++]=c;
    word[i]='\0';
  }
  else
    strcpy(word,"NULL");

  return(word);
}

int read_int(file)
FILE *file;
{
  return(atoi(read_word(file)));
}

long read_long(file)
FILE *file;
{
  return(atol(read_word(file)));
}

read_record(file,ev)
FILE *file;
struct event *ev;
{
  char c,word[MAXWORDSIZE];
  
  ev->event_sec=read_long(file);
  ev->event_usec=read_long(file);
  ev->event_type=read_int(file);
  read_word(file); /* get redundant event_type name */
  strcpy((ev->event_comp),read_word(file));
  ev->event_pid=read_int(file);

  switch(ev->event_type) {

  case 0: /*initsend*/
    read_word(file); /* "serial" */
    ev->msg_serial=read_int(file);
    break;

  case 1: case 2: /* putnint,getnint */
  case 13: case 14: /* putbytes,getbytes */
  case 15: case 16: /* putstring,getstring */
  case XAB_putnfloat: case XAB_getnfloat:
    read_word(file); /* "rc" */
    ev->event_rc=read_int(file);
    read_word(file); /* "serial" */
    ev->msg_serial=read_int(file);
    read_word(file); /* "count" */
    ev->msg_count=read_int(file);
    break;

  case 17: /* barrier */
    read_word(file); /* "name" */
    strcpy(ev->name,read_word(file));
    read_word(file); /* "number" */
    ev->number=read_int(file);
    break;

  case 18: /* enroll */
    strcpy(ev->dest_comp,read_word(file));
    break;

  case 19: /* initiate */
    read_word(file); /* "comp" */
    strcpy(ev->dest_comp,read_word(file));
    read_word(file); /* "arch/host" */
    strcpy(ev->dest_mach,read_word_or_null(file));
    break;

  case 20: /* initiateM */
    read_word(file); /* "comp" */
    strcpy(ev->dest_comp,read_word(file));
    read_word(file); /* "arch/host" */
    strcpy(ev->dest_mach,read_word_or_null(file));
    break;

  case 21: /* leave */
    break;

  case 24: /* rcv */
  case XAB_vrcv: /* vrcv */
    read_word(file); /* "type" */
    ev->msg_type=read_int(file);
    break;

  case 26: /* rcvinfo */
    ev->event_rc=read_int(file);
    break;

  case 28: case 33: /* snd, rcv_done */
  case XAB_vsnd:
  case XAB_vrcv_done:
    read_word(file); /* "rc" */
    ev->event_rc=read_int(file);
    read_word(file); /* "dcomp","comp" */
    strcpy(ev->dest_comp,read_word(file));
    read_word(file); /* "dpid","pid" */
    ev->dest_pid=read_int(file);
    read_word(file); /* "mtype","type" */
    ev->msg_type=read_int(file);
    read_word(file); /* "len" */
    ev->msg_length=read_int(file);
    read_word(file); /* "mser","ser" */
    ev->msg_serial=read_int (file);
    break;

  case 32:  /* whoami */
    strcpy(ev->dest_comp,read_word(file));
    read_word(file); /* "rc" */
    ev->event_rc=read_int(file);
    break;

  case 34: /* barrier done */
    read_word(file); /* "rc" */
    ev->event_rc=read_int(file);
    break;

  case 35: /* initiate_done */
    read_word(file); /* "pid" */
    ev->dest_pid=read_int(file);
    break;

  case 39: /* initiateM_done */
    read_word(file); /* "pid" */
    ev->dest_pid=read_int(file);
    break;
    
  default: 
    fprintf(stderr,"Error: unknown event. \n");
    fprintf(stderr,"(At time %d sec, %d usec.)\n",ev->event_sec,ev->event_usec);
    return(1);
    break;
  }

  ev->abmon_sec=read_int(file);
  ev->abmon_usec=read_int(file);
  ev->numsucc=0;
  ev->numpred=0;

  return(0);
}

write_record(file,ev)
FILE *file;
struct event *ev;
{
  fprintf(file,"%d ",ev->event_sec);
  fprintf(file,"%d ",ev->event_usec);
  fprintf(file,"%d ",ev->event_type);
       
  switch(ev->event_type) {
  case 0: /*initsend*/
    fprintf(file,"initsend ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t serial ",ev->event_pid);
    fprintf(file,"%d\n",ev->msg_serial);
    break;

  case 1: case 2: /* putnint,getnint */
  case 13: case 14: /* putbytes,getbytes */
  case 15: case 16: /* putstring,getstring */
  case XAB_putnfloat: case XAB_getnfloat:
	switch(ev->event_type) {
		case XAB_putnint: fprintf(file,"putnint "); break;
		case XAB_getnint: fprintf(file,"getnint "); break;
		case XAB_putbytes: fprintf(file,"putbytes "); break;
		case XAB_getbytes: fprintf(file,"getbytes "); break;
		case XAB_putnfloat: fprintf(file,"putnfloat ");break;
		case XAB_getnfloat: fprintf(file,"getnfloat ");break;
		default: break;
		}
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d, ",ev->event_rc);
    fprintf(file,"serial %d, ",ev->msg_serial);
    fprintf(file,"count %d\n",ev->msg_count);
    break;

  case 17: /* barrier */
    fprintf(file,"barrier ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"name %s ",ev->name);
    fprintf(file,"number %d \n",ev->number);
    break;

  case 18: /* enroll */
    fprintf(file,"enroll ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"%s\n",ev->dest_comp);
    break;

  case 19: /* initiate */
    fprintf(file,"initiate ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"comp %s ",ev->dest_comp);
    fprintf(file,"arch/host %s\n",ev->dest_mach);
    break;
  
  case 20: /* initiateM */
    fprintf(file,"initiateM ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"comp %s ",ev->dest_comp);
    fprintf(file,"arch/host %s\n",ev->dest_mach);
    break;

  case 21: /* leave */
    fprintf(file,"leave ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d\n",ev->event_pid);
    break;

  case 24: /* rcv */
    fprintf(file,"rcv ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"type %d\n",ev->msg_type);
    break;

  case XAB_vrcv: /* vrcv */
    fprintf(file,"vrcv ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"type %d\n",ev->msg_type);
    break;


  case 26: /* rcvinfo */
    fprintf(file,"rcvinfo ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"%d\n",ev->event_rc);
    break;

  case 28: /* snd */
    fprintf(file,"snd ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d ",ev->event_rc);
    fprintf(file,"dcomp %s ",ev->dest_comp);
    fprintf(file,"dpid %d ",ev->dest_pid);
    fprintf(file,"mtype %d ",ev->msg_type);
    fprintf(file,"len %d ",ev->msg_length);
    fprintf(file,"mser %d\n",ev->msg_serial);
    break;

  case XAB_vsnd: /* vsnd */
    fprintf(file,"vsnd ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d ",ev->event_rc);
    fprintf(file,"dcomp %s ",ev->dest_comp);
    fprintf(file,"dpid %d ",ev->dest_pid);
    fprintf(file,"mtype %d ",ev->msg_type);
    fprintf(file,"len %d ",ev->msg_length);
    fprintf(file,"mser %d\n",ev->msg_serial);
    break;

  case 32: /* whoami */
    fprintf(file,"whoami ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"%s\n",ev->dest_comp);
    fprintf(file,"rc %d ",ev->event_rc);
    break;

  case 33: /* rcv_done */
    fprintf(file,"rcv_done ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d ",ev->event_rc);
    fprintf(file,"comp %s ",ev->dest_comp);
    fprintf(file,"pid %d ",ev->dest_pid);
    fprintf(file,"type %d ",ev->msg_type);
    fprintf(file,"len %d ",ev->msg_length);
    fprintf(file,"ser %d\n",ev->msg_serial);
    break;

  case XAB_vrcv_done: /* vrcv_done */
    fprintf(file,"vrcv_done ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d ",ev->event_rc);
    fprintf(file,"comp %s ",ev->dest_comp);
    fprintf(file,"pid %d ",ev->dest_pid);
    fprintf(file,"type %d ",ev->msg_type);
    fprintf(file,"len %d ",ev->msg_length);
    fprintf(file,"ser %d\n",ev->msg_serial);
    break;

  case 34: /* barrier_done */
    fprintf(file,"barrier_done ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"rc %d \n ",ev->event_rc);
    break;

  case 35: /* initiate_done */
    fprintf(file,"initiate_done ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"pid %d\n",ev->dest_pid);
    break;

  case 39: /* initiateM_done */
    fprintf(file,"initiateM_done ");
    fprintf(file,"%s ",ev->event_comp);
    fprintf(file,"%d \t ",ev->event_pid);
    fprintf(file,"pid %d\n",ev->dest_pid);
    break;

  default: 
    fprintf(stderr,"Error: unknown event. \n");
    return(1);
    break;
  }

  fprintf(file,"\t %d %d\n",ev->abmon_sec,ev->abmon_usec);

  return(0);
}





/* read_trf reads in the xab event trace specified by filename;
   it returns a pointer to an array of event structures, or 0
   if there was an error.
*/


struct event *read_trf(filename)
char *filename;
{
  FILE *file;
  int pos;
  struct event event_list[MAXEVENTS];

  pos=0; 

  if (filename==0)
    file=stdin;
  else 
    if ((file=fopen(filename,"r"))==0) {
      fprintf(stderr,"Error opening file %s \n",filename);
      return(1);
    }

  while (!feof(file) && (pos < MAXEVENTS-1))
    if (read_record(file,&(event_list[pos++]))==1)
      return(0);

  if (!feof(file)) {
    fprintf(stderr,"Error: tracefile too big. \n");
    return(0);
  }

  if (file!=stdin)
    if (fclose(file) == EOF) {
      fprintf(stderr,"Error closing input file \n");
      return(0);
    }

  event_list[pos-1].event_type=(-1); /* last record read is eof error */

  return(event_list);
}  
  
struct event *write_trf(filename,event_list)
char *filename;
struct event *event_list;
{
  FILE *file;
  int pos=0;


  if (filename==0)
    file=stdout;
  else
    if ((file=fopen(filename,"w"))==0) {
      fprintf(stderr,"Error opening file %s \n",filename);
      return(0);
    }
  
  while (event_list[pos].event_type != (-1)) {
    write_record(file,&(event_list[pos++]));
    if (pos>MAXEVENTS) {
      fprintf(stderr,"Error- event list too big.\n");
      return(0);
    }}

  if (fclose(file) == EOF) {
    fprintf(stderr,"Error closing output file \n");
    return(0);
  }

  return(event_list);
}

/* test i/o routines:

main(argc,argv)
int argc;
char **argv;
{
  struct event *e;
  e=read_trf(argv[1]);
  write_trf(argv[2],e);
}

*/








