/* 
 *      XAB 1.0
 *
 *		Adam Beguelin
 *      University of Tennesee, Knoxville, TN.
 *      Oak Ridge National Laboratory, Oak Ridge, TN.
 *      1 Dec 1991
 *
 *      ab.h
 *		
 *		Internal include file for ablib
 *
 *
 */

#include <stdio.h>

#define XAB			"xab"	 /* name of the xab monitor process */
#define XABMTYPE 	1963 	/* message type for xab messages */
#define MAXUPROCNAMELEN		32	/* just to make life easier (same as pvm) */

/* External functions */
extern char *sstring();
extern void bail();


/* macros */
#define tmalloc(n,t) 	(t*)malloc((unsigned)((n)*sizeof(t)))


/* event id numbers for xab events */

#define XAB_initsend		0

#define XAB_putnint			1
#define XAB_getnint			2

#define XAB_putnshort		3
#define XAB_getnshort		4

#define XAB_putnlong		5
#define XAB_getnlong		6
		
#define XAB_putnfloat		7
#define XAB_getnfloat		8

#define XAB_putndfloat		9
#define XAB_getndfloat		10

#define XAB_putncplx		11
#define XAB_getncplx		12

#define XAB_putbytes		13
#define XAB_getbytes		14

#define XAB_putstring		15
#define XAB_getstring		16


/*********************
* User Library Calls *
*********************/

#define XAB_barrier			17
#define XAB_enroll			18
#define XAB_initiate		19
#define XAB_initiateM		20
#define XAB_leave			21
#define XAB_probe			22
#define XAB_pstatus			23
#define XAB_rcv				24
#define XAB_rcvmulti		25
#define XAB_rcvinfo			26
#define XAB_ready			27
#define XAB_snd				28
#define XAB_status			29
#define XAB_terminate		30
#define XAB_waituntil		31
#define XAB_whoami			32
#define XAB_rcv_done		33
#define XAB_barrier_done	34
#define XAB_initiate_done   35
#define XAB_waituntil_done  36
#define XAB_rcv_multi		37
#define XAB_rcv_multi_done	38
#define XAB_initiateM_done	39
#define XAB_vrcv			40
#define XAB_vrcv_done		41
#define XAB_vsnd			42
#define XAB_vsnd_done		43
#define XAB_snd_done		44






