#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "u_defines.h"

int u_win = 1;              /*Global variable to signal user defined window*/
int u_scroll = 0;           /*Global variable to signal nonscrolling window*/
GC u_gc[MAXNODE+4];   
extern Display *mydisplay; 
Window u_window, button_win, menu_win;      
extern Font font1;  
unsigned long u_foreground, u_background;/*Displays */
extern int depth, num_nodes;  
char title[]= {"Transposition"};
int u_colors1[16], u_colors2[64], uopen, win_width, win_height;
Colormap cmap;        
XColor DATA_colors[MAXNODE];
extern int reds[], greens[], blues[], color[];
extern Cursor hand_cursor;

u_init()
{
 /* declarations */
        XSizeHints u_hint;    /*Variables*/
        int i, j, sextant, new1, new2, new3, myscreen;
       float val, hue, sat, fract;

        if (num_nodes>MAXNODE)
          u_win=0;
        else
	  u_win=1;

        myscreen = DefaultScreen(mydisplay);

/* pixel values */
        u_background = WhitePixel(mydisplay, myscreen);
        u_foreground = BlackPixel(mydisplay, myscreen);
        cmap = DefaultColormap(mydisplay,myscreen);


/* default program-specified window position and size */
        u_hint.x = 0; u_hint.y = 0;
	if(num_nodes<=16){
	   win_width = u_hint.width = 285; win_height = u_hint.height = 285;
	}else{
	   win_width = u_hint.width = 552; win_height = u_hint.height = 552;
	}
        u_hint.flags = PPosition | PSize;
        u_window = XCreateSimpleWindow(mydisplay,
                DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, u_hint.width, u_hint.height,
                2, u_foreground, u_background);
        XChangeProperty(mydisplay, u_window, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, title, strlen(title));
        menu_win = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, 98, 24, 2, u_foreground, u_background);
        XChangeProperty(mydisplay, menu_win, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, "User Menu", 9);
        button_win = XCreateSimpleWindow(mydisplay, menu_win,
                2, 2, 90, 16, 2, u_foreground, u_background);

    XSelectInput(mydisplay, u_window, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, menu_win, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, button_win, ExposureMask |StructureNotifyMask|
      ButtonPressMask);
    XDefineCursor(mydisplay, u_window, hand_cursor);
    XDefineCursor(mydisplay, menu_win, hand_cursor);
    XDefineCursor(mydisplay, button_win, hand_cursor);

/*initialize gc's*/
        for (i=0; i<=MAXNODE+4; i++){
          u_gc[i] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
          XSetBackground(mydisplay,u_gc[i],u_background);
          XSetFont(mydisplay, u_gc[i], font1);
          }
        XSetForeground(mydisplay,u_gc[0],u_foreground);
        XSetForeground(mydisplay,u_gc[num_nodes +1],
                       u_background);

/* color definitions */
    for (i=0; i<64; i++) {
      DATA_colors[i].red=reds[i]*256;
      DATA_colors[i].green=greens[i]*256;
      DATA_colors[i].blue =blues[i]*256;
    }
    if (depth  >1) {
      for (j=0;j<64;j++) {
          XAllocColor(mydisplay,cmap,&DATA_colors[j]);
          u_colors2[j] = DATA_colors[j].pixel;
          }
        XSetForeground(mydisplay,u_gc[66], color[7]);
        XSetForeground(mydisplay,u_gc[67], color[10]);
      }
      for (i=1;i<=num_nodes;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i],
                   u_colors2[(j)*64/num_nodes]);
      }
}
