#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdio.h>
#include "u_defines.h"

int u_win = 1;     
int u_scroll = 0;
int uopen;
GC u_gc[MAXNODE+4];
extern Display *mydisplay;
Window u_window, button_win, menu_win;    
unsigned long u_foreground, u_background;
extern Font font1;        
extern int depth, color[], num_nodes, task_colors[];
char title[]= {"Sort"}; 
XColor DATA_colors[64];
XColor color_def[16];
Colormap cmap;       
extern Cursor hand_cursor;

u_init()
{
 /* declarations */
        XSizeHints u_hint;    /*Variables*/
        int i, j, sextant, new1, new2, new3, myscreen;
  float val, temp1, temp2, hue, sat, fract;

        if (num_nodes>64)
          u_win=0;
        else
	  u_win=1;

/* pixel values */
	myscreen = DefaultScreen(mydisplay);
        u_background = WhitePixel(mydisplay, myscreen);
        u_foreground = BlackPixel(mydisplay, myscreen);
        cmap = DefaultColormap(mydisplay,myscreen);


/* default program-specified window position and size */
      if(num_nodes<=16){
        u_hint.x = 0; u_hint.y = 0;
        u_hint.width = 600; u_hint.height = 390;
        u_hint.flags = PPosition | PSize;
      }else{
        u_hint.x = 710; u_hint.y = 730;
        u_hint.width = 912; u_hint.height = 632;
        u_hint.flags = PPosition | PSize;
      }
        u_window = XCreateSimpleWindow(mydisplay,
                DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, u_hint.width, u_hint.height,
                5, u_foreground, u_background);
        XChangeProperty(mydisplay, u_window, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, title, strlen(title));
        menu_win = XCreateSimpleWindow(mydisplay, DefaultRootWindow(mydisplay),
                u_hint.x, u_hint.y, 98, 24, 2, u_foreground, u_background);
        XChangeProperty(mydisplay, menu_win, XA_WM_NAME,
                XA_STRING, 8, PropModeReplace, "User Menu", 9);
        button_win = XCreateSimpleWindow(mydisplay, menu_win,
                2, 2, 90, 16, 2, u_foreground, u_background);

/* initialize gc's */
        for (i=0; i<=MAXNODE+1; i++){
          u_gc[i] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
          XSetBackground(mydisplay,u_gc[i],u_background);
          XSetFont(mydisplay, u_gc[i], font1);
          }
        XSetForeground(mydisplay,u_gc[0],u_foreground);
        XSetForeground(mydisplay,u_gc[65], u_background);

    XSelectInput(mydisplay, u_window, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, menu_win, ExposureMask |StructureNotifyMask);
    XSelectInput(mydisplay, button_win, ExposureMask |StructureNotifyMask|
      ButtonPressMask);
    XDefineCursor(mydisplay, u_window, hand_cursor);
    XDefineCursor(mydisplay, menu_win, hand_cursor);
    XDefineCursor(mydisplay, button_win, hand_cursor);

    if (depth  >1) {
        for (i=1;i<=num_nodes;i++) {
            j=(i-1);
            XSetForeground(mydisplay,u_gc[i], task_colors[(j)*64/num_nodes]);
            }
        XSetForeground(mydisplay,u_gc[66], color[7]);
        XSetForeground(mydisplay,u_gc[67], color[10]);
	}
}
