#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern struct win_info windows[];
extern Display *mydisplay; 
extern Window u_window, menu_win, button_win; 
extern XEvent myevent; 
extern GC u_gc[];
extern int num_nodes;
extern int lengthnode[], task_colors[], order[], user_men, uopen;

u_event()
/* if event is an expose, it draws the inital configuration in the window */
{       
   if (myevent.type==Expose) {
     if(myevent.xexpose.window==u_window)
       u_expose();
     if(myevent.xexpose.window==menu_win)
       XFillRectangle(mydisplay, menu_win, u_gc[66], 0, 0, 98, 24);
     if(myevent.xexpose.window==button_win){
       if(uopen)
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
       XDrawString(mydisplay, button_win, u_gc[0], 33, 10, "Sort", 4);
     }
   }else if(myevent.type==ButtonPress){
     if(myevent.xbutton.window==button_win){
       if(uopen){
         XUnmapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[65], 0, 0, 90, 16);
         uopen=0;
       }else{
         XMapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[67], 0, 0, 90, 16);
         uopen=1;
       }
       XDrawString(mydisplay, button_win, u_gc[0], 33, 10, "Sort", 4);
     }
     if(myevent.xbutton.window==windows[73].window){
       if(user_men){
         XUnmapWindow(mydisplay, menu_win);
         user_men=0;
       }else{
         user_men=1;
         XMapWindow(mydisplay, menu_win);
         XMapSubwindows(mydisplay, menu_win);
       }
     }
   }
}

extern int most;
int u_height, u_height1,       /*Height of window, w/ and w/o margins*/
    u_width,u_width1,          /*Width of window, w/ and w/o margins */
    widthscale,                /*Scale used for width of nodes       */
    in[MAXNODE],               /*Index of first element on ea. node(gray)*/
    in2[MAXNODE];              /*Index of first element on ea. node(nat)*/
int heightscale;             /*Scale used for height of rectangles */
extern unsigned long u_background,u_foreground;

u_expose()
/* draws initial configuration of the window */

{ int x,  /*xcoordinate used for drawing rectangles and strings*/
      y,  /*ycoordinate used for drawing rectangles and strings*/
      h,  /*height used for drawing rectangles and strings*/
      w,  /*width used for drawing rectangles and strings*/
      i,j,/*loop control variables*/ 
      mar,/*variable used for spacing*/
      colheight;   /*used for drawing rectangles*/	
  XWindowAttributes u_windowattributes;
  char index[8];   /*string used for drawing strings*/
  char text[10];   /*string used for reading input*/
  XPoint points[4];/*points used for drawing axes*/

  if(most){
/*find heightscale,widthscale,SIZE,and indices*/
        XGetWindowAttributes(mydisplay,u_window,&u_windowattributes);
        u_height1=u_windowattributes.height;
        u_height = u_height1-2*MAR_SIZE;
        u_width1=u_windowattributes.width;
        u_width = u_width1-2*MAR_SIZE;
        for(i=1;i<num_nodes;i++){
	in[i] = in2[i] = 0;
          for(j=0; j<i;j++)
           in[i]+=lengthnode[j];
          for(j=0; j<i;j++)
           in2[i]+=lengthnode[j];
         }
        widthscale=u_width/num_nodes;

           /* write values along y axis */
               i=0;
               /*while (i< ((u_height)/heightscale)) {*/
               while (i< (most)) {
                   h= u_height - ((i*u_height)/most)+MAR_SIZE;
                   sprintf(index, "%3d",i);
                   i+=(most)/3 - 1;
                   XDrawImageString(mydisplay, u_window, u_gc[0],
                                   20,h,index,strlen(index));
                   }
           /* write values along x axis and colorkey */
           /* to separate nodes */
                mar = .5*MAR_SIZE;
                sprintf(index,"%s","Node");
                x=1;
                y=u_height1 - (mar-2) + .5*.75*MAR_SIZE;
                XDrawImageString(mydisplay, u_window,u_gc[0],
                                 x, y, index,strlen(index));
                y=u_height1 - mar - 2;
                sprintf(index,"%s","Index");
                XDrawImageString(mydisplay,u_window, u_gc[0],
                                 1,y,index, strlen(index));
                for (i=0;i<(num_nodes);i++) {
		   if(i%4==0 || num_nodes<=16) {
                       if (windows[92].opt1==1)
                        sprintf(index,"%2d",in[(i)]);
                       else
                        sprintf(index,"%2d",in2[i]);
                       x = i*widthscale +MAR_SIZE + 1;
                       XDrawImageString(mydisplay,u_window, u_gc[0],
                                    x,y,index, strlen(index));
		       }
                   }
                              
           /* draw axes and legend for node color */
                init2(points);
		XDrawLine(mydisplay, u_window, u_gc[0], MAR_SIZE, MAR_SIZE-1,
		    MAR_SIZE+u_width+1, MAR_SIZE-1);
		XDrawLine(mydisplay, u_window, u_gc[0], MAR_SIZE+u_width+1,
		    MAR_SIZE-1, MAR_SIZE+u_width+1, MAR_SIZE+u_height);
                XDrawLines(mydisplay,u_window,u_gc[0],
                           points, 4, CoordModeOrigin);
                drawlegend();
  }else XDrawImageString(mydisplay,u_window, u_gc[0], 50,50,
       "NO DATA FOUND FOR THIS DISPLAY",
       strlen("NO DATA FOUND FOR THIS DISPLAY"));
}

extern int depth;          /*depth of screen*/

drawlegend()
/*draws legend for node colors*/
{ int x,  /*xcoordinate used for drawing rectangles and strings*/
      y,  /*ycoordinate used for drawing rectangles and strings*/
      j,  /*loop control variable*/
      mar,/*variable used for spacing*/
      colheight;   /*used for drawing rectangles*/
  char index[5];   /*string used for drawing strings*/

/*if a monochrome screen, printout numbers of the nodes; otherwise */
/*printout colored rectangle with node number for each node */
   mar = 0.5*MAR_SIZE;
   for (j=0; j<num_nodes;j++){
    x=widthscale*order[j]+MAR_SIZE+1;
    y=u_height1-(mar - 2);
    colheight=.75*MAR_SIZE;
    if (depth>1) {
       XSetBackground(mydisplay,u_gc[0],task_colors[order[j]*64/num_nodes]);
         XFillRectangle(mydisplay,u_window, u_gc[order[j]+1],
	   x,y, widthscale,colheight);
         }
     sprintf(index,"%2d",j);
     y = y + .5*colheight;
     XDrawImageString(mydisplay,u_window, u_gc[0], x, y, index,
              strlen(index));
     }
   if (depth>1)
     XSetBackground(mydisplay,u_gc[0],u_background);
}

extern u_width1; /* height and width of window */

init2(p)
/*initializes points array for drawing the axes*/

        XPoint  p[4]; /* array of points for lines to be drawn */

{
        p[0].x=MAR_SIZE;
        p[0].y=0+MAR_SIZE-1;
        p[1].x=MAR_SIZE;
        p[1].y=u_height+MAR_SIZE;
        p[2].x=u_width1-MAR_SIZE;
        p[2].y=u_height+MAR_SIZE;
        p[3].x=MAR_SIZE;
        p[3].y=u_height+MAR_SIZE;
}


