#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <stdio.h>
#include "u_defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern GC u_gc[];
extern Display *mydisplay; 
extern Window menu_win, button_win, u_window;
extern struct win_info windows[];
extern XEvent myevent;
extern int uopen, user_men, max_cum, max_time, win_height, win_width;
extern float max_rate;

u_event(){
   if (myevent.type==Expose) {
     if(myevent.xexpose.window==u_window)
       u_expose();
     if(myevent.xexpose.window==menu_win)
       XFillRectangle(mydisplay, menu_win, u_gc[4],
         0, 0, 98, 24);
     if(myevent.xexpose.window==button_win){
       if(uopen)
         XFillRectangle(mydisplay, button_win, u_gc[5],
           0, 0, 90, 16);
       XDrawString(mydisplay, button_win, u_gc[1], 30, 10,
         "Count", 5);
     }
   } else if (myevent.type==ConfigureNotify) {
     if(myevent.xexpose.window==u_window){
      win_height=(myevent.xconfigure.height-120)/2;
      win_width=myevent.xconfigure.width-80;
     }
   }else if(myevent.type==ButtonPress){
     if(myevent.xbutton.window==button_win){
       if(uopen){
         XUnmapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[0], 0, 0, 90, 16);
         uopen=0;
       }else{
         XMapWindow(mydisplay, u_window);
         XFillRectangle(mydisplay, button_win, u_gc[5], 0, 0, 90, 16);
         uopen=1;
       }
       XDrawString(mydisplay, button_win, u_gc[1], 30, 10, "Count", 5);
     }
     if(myevent.xbutton.window==windows[73].window){
       if(user_men){
         XUnmapWindow(mydisplay, menu_win);
         user_men=0;
       }else{
         user_men=1;
         XMapWindow(mydisplay, menu_win);
         XMapSubwindows(mydisplay, menu_win);
       }
     }
   }
}
u_expose(){

  char buf[10];

  XClearWindow(mydisplay, u_window);
  XDrawRectangle(mydisplay, u_window, u_gc[1], 40, 39, win_width+1, 
    win_height+1);
  XDrawRectangle(mydisplay, u_window, u_gc[1], 40, 79+win_height, win_width+1, 
    win_height+1);
  XDrawImageString(mydisplay, u_window, u_gc[1], win_width/2-8, 24, 
    "Cumulative Count", 16);
  XDrawImageString(mydisplay, u_window, u_gc[1], win_width/2+4, 
    80+2*win_height+24, "Current Rate", 12);
  XDrawImageString(mydisplay, u_window, u_gc[1], win_width/2+28, 
    40+win_height+24, "Time", 4);
  sprintf(buf, "%d", 0);
  XDrawImageString(mydisplay, u_window, u_gc[1], 40, 40+win_height+24, 
    buf, strlen(buf));
  sprintf(buf, "%d", max_time);
  XDrawImageString(mydisplay, u_window, u_gc[1], 40+win_width-6*strlen(buf),
    40+win_height+24, buf, strlen(buf));
  sprintf(buf, "%d", max_cum);
  XDrawImageString(mydisplay, u_window, u_gc[1], 20-3*strlen(buf), 50, 
    buf, strlen(buf));
  sprintf(buf, "%d", (int)max_rate);
  XDrawImageString(mydisplay, u_window, u_gc[1], 20-3*strlen(buf), 90+win_height, 
    buf, strlen(buf));
  XDrawImageString(mydisplay, u_window, u_gc[1], 17, 38+win_height, "0", 1);
  XDrawImageString(mydisplay, u_window, u_gc[1], 17, 78+2*win_height, "0", 1);
}
