#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern int crit_time_send[], crit_node[], crit_time[], crit_count, go_flag,
           paused, trace_place, skip, time_unit, ****sendpoint,
	   last_time_trac, trace_width, max_lines, task_num, **task, num_task,
	   k_delta, trace_node, trace_type, min_time, task_ptr[], *tsks_prog,
           exit_count, *start_task, *task_time, *task_counter, *task_count,
           num_nodes, **msg_count, **cum_vol, k_init[MAXP], info_line, 
	   close_count, begin_of_file, num_info_lines;
int busy, from, msg_type, paired_comp[MAXP], anim_state[MAXP], 
    cur_time, raw_time, key_index, msg_lth, node,  dest, comm_count, comm_vol, 
    send_vol[MAXP], send_count[MAXP], msg_sent[MAXP], msg_rcvd[MAXP], 
    state[MAXP], queu_vol[MAXP], queu_count[MAXP], start_busy[MAXP], 
    max_sent[MAXP], hypenode1, hypenode2, max_rcvd[MAXP], max_queu_count[MAXP],
    max_queu_vol[MAXP], min_sent[MAXP], min_rcvd[MAXP];
MMT_STRUCT dist[MAXP], tmes[MAXP], tran[MAXP];
float current_time, current_util_pct[MAXP];
char trac_line[MAXLINE];

/* collect data from a line in the tracefile */
scan(l)

   char l[MAXLINE];
{

   static int send_time[MAXP], recv_time[MAXP];
   int e, i, j, k, temp, temp1, ibuf;
   char buf[100];


   sscanf(l, "%d %d", &e, &k);

   /* first "word", actually a number, in the traceline */
   skip = 0;
   if(isdigit(l[0])||strncmp(l,"-",1)==0){
   if(k<0){
     sscanf(l, "%*d %*d %f %d", &current_time, &node);
     cur_time = (int)((1000000.0*current_time)/(float)time_unit)-min_time;
     raw_time = (int)(1000000.0 * current_time);
     if(node!=HOST){
      if(k!=IDLE&&k!=RECVBLOCK&&k!=WAIT&&k!=RECVENDW&&k!=TSTART){
       if(e==EVENTENTRY){
         state[node]=2;
       }else if(e==EVENTEXIT){
         state[node]=1;
       }
      }else if(k!=TSTART){
       if(e==EVENTENTRY){
         state[node]=0;
       }else if(e==EVENTEXIT){
         state[node]=1;
       }
      }
     }

   switch(k) {

   case CLOCKSYNC:
       sscanf(l, "%*d %*d %*f %d", &node);
       sprintf(trac_line, "clock_sync clock %d node %d",
         (int)(current_time*1000000.0), node);
       key_index = k;
       break;

   case TMSG:
       sscanf(l, "%*d %*d %*f %d %s", &node, buf);
       sprintf(trac_line, "trace_message clock %d  node %d %s",
           (int)(current_time*1000000.0), node, buf);
       /* is user has selected stopping on tracemark/msg */
       if (e==EVENTENTRY&&windows[TSTP].opt1)
           go_flag=0;
       key_index = k;
       break;

   case OPEN:
       sscanf(l, "%*d %*d %*f %d", &node);
       sprintf(trac_line, "open clock %d node %d",
           (int)(current_time*1000000.0), node);
       if(e==EVENTENTRY&&node!=HOST)
         anim_state[node] = 1;
       key_index = k;
       break;

   case SYNC:
       sscanf(l, "%*d %*d %*f %d", &node);
       sprintf(trac_line, "sync clock %d node %d",
           (int)(current_time*1000000.0), node);
       key_index = k;
       break;

   case TSTART:
       sscanf(l, "%*d %*d %*f %d", &node);
       if(e==EVENTENTRY){
         sprintf(trac_line, "trace_start clock %d node %d",
           (int)(current_time*1000000.0), node);
         if (node != HOST){
           anim_state[node] = 1;
           state[node] = 1;
           start_busy[node] = raw_time;
         }
       key_index = k;
       }else{
         sprintf(trac_line, "trace_exit clock %d node %d",
           (int)(current_time*1000000.0), node);
         if (node != HOST){
           if (exit_count!=0)
               exit_count--;
           anim_state[node] = 0;
           state[node] = 0;
         }
       key_index = TEXIT;
       current_util_pct[node]=0.0;
       }
       break;

   case SENDBEGIN:
   case SEND:
       if(e==EVENTENTRY){
         sscanf(l, "%*d %*d %*f %d %*d %*d %*s %d %d %d", &node,
           &msg_lth, &msg_type, &dest);
         sprintf(trac_line, "send entry clock  %d node %d to %d type %d lth %d",
           (int)(current_time*1000000.0), node, dest, msg_type, msg_lth);
         if(dest>=num_nodes){
           printf("Missing trace data for node %d (open not found): exiting\n",
             dest);
           exit(1);
         }
       if (node != HOST && dest != HOST) {
           anim_state[node]=2;
           hypenode1=node;
           hypenode2=dest;
           if (msg_lth>max_sent[node])
               max_sent[node] = msg_lth;
           if (msg_lth<min_sent[node])
               min_sent[node] = msg_lth;
	   if(dest!=ALL){
             comm_count++;
	     comm_vol+=msg_lth;
             msg_count[node][dest]++;
             msg_sent[node]++;
             queu_count[dest]++;
             if ((ibuf=hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	       windows[DIMB].opt2, windows[COLB].opt1,node, dest))<
	       dist[node].min.sent)
               dist[node].min.sent = ibuf;
             if (ibuf>dist[node].max.sent)
               dist[node].max.sent = ibuf;
	     dist[node].total.sent+=ibuf;
             if (queu_count[dest]>max_queu_count[dest])
                 max_queu_count[dest] = queu_count[dest];
             queu_vol[dest] += msg_lth;
             if (queu_vol[dest]>max_queu_vol[dest])
                 max_queu_vol[dest] = queu_vol[dest];
	     send_count[node]++;
	     send_vol[node]+=msg_lth;
             cum_vol[node][dest] += msg_lth;
	     if(msg_count[node][dest]>0){
               sendpoint[node][dest][msg_count[node][dest]-1][0] = cur_time;
               sendpoint[node][dest][msg_count[node][dest]-1][1] = msg_type;
	     }
	   }else{
	   for(i=0; i<node; i++){
             comm_count++;
	     comm_vol+=msg_lth;
             msg_count[node][i]++;
             msg_sent[node]++;
             queu_count[i]++;
             if ((ibuf=hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2, 
	      windows[DIMB].opt2, windows[COLB].opt1,node, i))<dist[i].min.sent)
               dist[i].min.sent = ibuf;
             if (ibuf>dist[node].max.sent)
               dist[node].max.sent = ibuf;
	     dist[node].total.sent+=ibuf;
             if (queu_count[i]>max_queu_count[i])
                 max_queu_count[i] = queu_count[i];
             queu_vol[i] += msg_lth;
             if (queu_vol[i]>max_queu_vol[i])
                 max_queu_vol[i] = queu_vol[i];
	     send_count[node]++;
	     send_vol[node]+=msg_lth;
             cum_vol[node][i] += msg_lth;
	     if(msg_count[node][i]>0){
               sendpoint[node][i][msg_count[node][i]-1][0] = cur_time;
               sendpoint[node][i][msg_count[node][i]-1][1] = msg_type;
	     }
	   }
	   for(i=node+1; i<num_nodes; i++){
             comm_count++;
	     comm_vol+=msg_lth;
             msg_count[node][i]++;
             msg_sent[node]++;
             queu_count[i]++;
             if (queu_count[i]>max_queu_count[i])
                 max_queu_count[i] = queu_count[i];
             queu_vol[i] += msg_lth;
             if (queu_vol[i]>max_queu_vol[i])
                 max_queu_vol[i] = queu_vol[i];
	     send_count[node]++;
	     send_vol[node]+=msg_lth;
             cum_vol[node][i] += msg_lth;
	     if(msg_count[node][i]>0){
               sendpoint[node][i][msg_count[node][i]-1][0] = cur_time;
               sendpoint[node][i][msg_count[node][i]-1][1] = msg_type;
	     }
	   }
	 }
       }
         key_index=SEND;
       }else{
         sprintf(trac_line, "send exit clock  %d node %d",
           (int)(current_time*1000000.0), node);
         ibuf=raw_time-send_time[node];
         tmes[node].total.sent+=ibuf;
         if(ibuf>tmes[node].max.sent)
           tmes[node].max.sent=ibuf;
         if(ibuf<tmes[node].min.sent)
           tmes[node].min.sent=ibuf;
         key_index=0;
         anim_state[node]=1;
       }

       break;

   case RECVENDV:
   case RECVENDW:
   case RECV:
       if(e==EVENTEXIT){
       comm_count--;
         sscanf(l, "%*d %*d %*f %d %*d %*d %*s %d %d %d", &node,
           &msg_lth, &msg_type, &from);
         sprintf(trac_line, "recv exit clock %d node %d from %d type %d lth %d",
           (int)(current_time*1000000.0), node, from, msg_type, msg_lth);
         if(from>=num_nodes){
           printf("Missing trace data for node %d (open not found): exiting\n",
             from);
           exit(1);
         }

           hypenode1=from;
           hypenode2=node;
       if (node != HOST && from != HOST) {
           if(--msg_count[from][node]<0){
	   printf("warning: message received before sent (msg_count < 0).\n");
	    if(windows[PERR].opt1){
             go_flag=0;
	     paused = 1;
	     expose(PAUB);
	    }
	   }
               if (msg_lth>max_rcvd[node])
                   max_rcvd[node] = msg_lth;
               if (msg_lth<min_rcvd[node])
                   min_rcvd[node] = msg_lth;
              ibuf=raw_time-recv_time[node];
              tmes[node].total.rcvd+=ibuf;
              if(ibuf>tmes[node].max.rcvd)
                tmes[node].max.rcvd=ibuf;
              if(ibuf<tmes[node].min.rcvd)
                tmes[node].min.rcvd=ibuf;
              if(msg_count[from][node]>=0)
                ibuf=cur_time-sendpoint[from][node][msg_count[from][node]][0];
              else ibuf =0;
              tran[node].total.rcvd+=ibuf;
              if(ibuf>tran[node].max.rcvd)
                tran[node].max.rcvd=ibuf;
              if(ibuf<tran[node].min.rcvd)
                tran[node].min.rcvd=ibuf;
              tran[from].total.sent+=ibuf;
              if(ibuf>tran[from].max.sent)
                tran[from].max.sent=ibuf;
              if(ibuf<tran[from].min.sent)
                tran[from].min.sent=ibuf;
               if ((ibuf=hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2,
                 windows[DIMB].opt2, windows[COLB].opt1,node, from))<
                 dist[node].min.rcvd)
                   dist[node].min.rcvd = ibuf;
               if (ibuf>dist[node].max.rcvd)
                   dist[node].max.rcvd = ibuf;
               dist[node].total.rcvd+=ibuf;
           comm_vol-=msg_lth;
           for(i=0; i<msg_count[from][node]+1; i++){
             if(sendpoint[from][node][i][1]==msg_type){
               temp=sendpoint[from][node][i][0];
               temp1=sendpoint[from][node][i][1];
               break;
             }
           }
	     if(i==msg_count[from][node]+1)
	       printf("warning: message received before sent (no previous unreceived send with matching type.\n");

           for(j=i; j<msg_count[from][node]; j++){
             sendpoint[from][node][j][1]=sendpoint[from][node][j+1][1];
             sendpoint[from][node][j][0]=sendpoint[from][node][j+1][0];
           }
	   if(msg_count[from][node]>=0){
             sendpoint[from][node][msg_count[from][node]][1]=temp1;
             sendpoint[from][node][msg_count[from][node]][0]=temp;
	   }
           msg_rcvd[node]++;
	   if (queu_count[node]!=0)
               queu_count[node]--;
	   if (queu_vol[node]!=0)
               queu_vol[node] -= msg_lth;
	   if (send_count[from]!=0)
	       send_count[from]--;
	   if (send_vol[from]!=0)
	       send_vol[from] -= msg_lth;
           state[node] = 1;
         }
       key_index=RECV;
       }else{
         sprintf(trac_line, "recv entry clock %d node %d",
           (int)(current_time*1000000.0), node);
         key_index=0;
         anim_state[node]=3;
         recv_time[node]=raw_time;
       }
       break;

     case OVERHEAD:
       sscanf(l, "%*d %*d %*f %d", &node);
       if(e==EVENTEXIT){
         anim_state[node] = 1;
         state[node] = 1;
       sprintf(trac_line,"idle exit clock %d node %d",
         (int)(current_time*1000000.0), node);
       }else if(e==EVENTENTRY){
         anim_state[node] = 0;
         state[node] = 2;
       sprintf(trac_line,"idle entry clock %d node %d",
         (int)(current_time*1000000.0), node);
       }
       key_index=k;
     break;

     case IDLE:
       sscanf(l, "%*d %*d %*f %d", &node);
       if(e==EVENTEXIT){
       sprintf(trac_line,"idle exit clock %d node %d",
         (int)(current_time*1000000.0), node);
         anim_state[node] = 1;
         state[node] = 1;
       }else if(e==EVENTENTRY){
       sprintf(trac_line,"idle entry clock %d node %d",
         (int)(current_time*1000000.0), node);
         anim_state[node] = 0;
         state[node] = 0;
       }
       key_index=k;
     break;

     case RECVBLOCK:
       if(e==EVENTEXIT){
       comm_count--;
         sscanf(l, "%*d %*d %*f %d %*d %*d %*s %d %d %d", &node,
           &msg_lth, &msg_type, &from);
        sprintf(trac_line,"recv_waking clock %d node %d from %d type %d lth %d",
           (int)(current_time*1000000.0), node, from, msg_type, msg_lth);
         if(from>=num_nodes){
           printf("Missing trace data for node %d (open not found): exiting\n",
             from);
           exit(1);
         }
       hypenode1=from;
       hypenode2=node;
       if (node != HOST ) {
       anim_state[node] = 1;
       state[node] = 1;
	   if (from != HOST) {
               if(node==crit_node[crit_count-1]&&cur_time==crit_time[crit_count-1]/time_unit-min_time && from==crit_node[crit_count])
                  crit_count--;
               if(--msg_count[from][node]<0){
	   printf("warning: message received before sent (msg_count < 0).\n");
	        if(windows[PERR].opt1){
                 go_flag=0;
	         paused = 1;
	         expose(PAUB);
	        }
	       }
               if (msg_lth>max_rcvd[node])
                   max_rcvd[node] = msg_lth;
               if (msg_lth<min_rcvd[node])
                   min_rcvd[node] = msg_lth;
               if ((ibuf=hops(windows[DSTB].opt1, num_nodes/windows[DIMB].opt2,
		 windows[DIMB].opt2, windows[COLB].opt1,node, from))<
		 dist[node].min.rcvd)
                   dist[node].min.rcvd = ibuf;
               if (ibuf>dist[node].max.rcvd)
                   dist[node].max.rcvd = ibuf;
	       dist[node].total.rcvd+=ibuf;
	       ibuf=raw_time-recv_time[node];
	       tmes[node].total.rcvd+=ibuf;
	       if(ibuf>tmes[node].max.rcvd)
		 tmes[node].max.rcvd=ibuf;
	       if(ibuf<tmes[node].min.rcvd)
		 tmes[node].min.rcvd=ibuf;
	      if(msg_count[from][node]>=0)
                ibuf=cur_time-sendpoint[from][node][msg_count[from][node]][0];
	      else ibuf =0;
	      tran[node].total.rcvd+=ibuf;
	      if(ibuf>tran[node].max.rcvd)
	        tran[node].max.rcvd=ibuf;
	      if(ibuf<tran[node].min.rcvd)
	        tran[node].min.rcvd=ibuf;
	      tran[from].total.sent+=ibuf;
	      if(ibuf>tran[from].max.sent)
	        tran[from].max.sent=ibuf;
	      if(ibuf<tran[from].min.sent)
	        tran[from].min.sent=ibuf;
	       comm_vol-=msg_lth;
           for(i=0; i<msg_count[from][node]+1; i++){
             if(sendpoint[from][node][i][1]==msg_type){
               temp=sendpoint[from][node][i][0];
               temp1=sendpoint[from][node][i][1];
               break;
             }
           }
	     if(i==msg_count[from][node]+1)
	       printf("warning: message received before sent (no previous unreceived send with matching type.\n");

           for(j=i; j<msg_count[from][node]; j++){
             sendpoint[from][node][j][1]=sendpoint[from][node][j+1][1];
             sendpoint[from][node][j][0]=sendpoint[from][node][j+1][0];
           }
	   if(msg_count[from][node]>=0){
             sendpoint[from][node][msg_count[from][node]][1]=temp1;
             sendpoint[from][node][msg_count[from][node]][0]=temp;
	   }
               msg_rcvd[node]++;
               queu_count[node]--;
	       send_count[from]--;
	       send_vol[from] -= msg_lth;
               queu_vol[node] -= msg_lth;
	   }
       }
         key_index=RECVWAKE;
       }else if(e==EVENTENTRY){
         sscanf(l, "%*d %*d %f %d", &current_time, &node);
         sprintf(trac_line, "recv_blocking clock %d node %d",
           (int)(current_time*1000000.0), node);
         if (node != HOST){
           anim_state[node] = 0;
           state[node] = 0;
           recv_time[node]=raw_time;
         }
         key_index=RECVBLOCK;
       }
       break;

   case CLOSE:
       sscanf(l, "%*d %*d %*f %d", &node);
       sprintf(trac_line, "close clock %d node %d",
         (int)(current_time*1000000.0), node);
       if (node != HOST&&e==EVENTEXIT){
           anim_state[node] = 0;
           state[node] = 0;
           if (close_count!=0)
               close_count--;
	   if(exit_count==0) close_count=0;
       }
       key_index=k;
       break;

   default:
       skip = 1;
       key_index=0;
       break;
   }
   }else{
     sscanf(l, "%*d %d %f %d", &task_num, &current_time, &node);
     cur_time = (int)((1000000.0 * current_time)/ (float)time_unit) - min_time;
     raw_time = (int)(1000000.0 * current_time);
     if(e==EVENTMARK){
       sprintf(trac_line, "user mark clock %d node %d",
           (int)(current_time*1000000.0), node);
       /* is user has selected stopping on tracemark/msg */
       if (windows[TSTP].opt1){
           go_flag=0;
           paused = 1;
           expose(PAUB);
       }
        key_index=USERMARK;
     }
     if(e==EVENTENTRY){
       sprintf(trac_line, "user block_begin clock %d node %d task %d",
         (int)(current_time*1000000.0), node, task_num);
       if (node != HOST && task_num >=0){
         (*(task_count+task_num))++;
         if ((*(task_count+task_num)) == 1) (*(start_task+task_num)) = cur_time;
         (*(task_counter+task_num))+= (*(tsks_prog+task_num))*
             (cur_time - (*(task_time+task_num)));
         (*(task_time+task_num)) = cur_time;
             task_ptr[node]++;
             task[node][task_ptr[node]] = task_num;
       (*(tsks_prog+task_num))++;
       }
        key_index=USERBLOCKBEGIN;
     }else if(e==EVENTEXIT){
       sprintf(trac_line, "user block_end clock %d node %d task %d",
         (int)(current_time*1000000.0), node, task_num);
       if (node != HOST && task_num >=0){
           (*(task_counter+task_num))+= (*(tsks_prog+task_num))*
               (cur_time - (*(task_time+task_num)));
           (*(task_time+task_num)) = cur_time;
           if (task_num>=0){
             if(task[node][task_ptr[node]] != task_num){
                 printf("incorrectly nested blocks\n");
                 sprintf(buf,"incorrectly nested blocks\n");
               if(info_line<=num_info_lines){
                 XDrawString(mydisplay,windows[INFO].window,gc[CLOK], 9,
                   38+18*info_line, buf,strlen(buf));
                 info_line++;
               }else{
                 XCopyArea(mydisplay, windows[INFO].window,
                   windows[INFO].window, gc[CLOK], 0, 46, 200, 18*
                   num_info_lines, 0, 28);
                 XClearArea(mydisplay, windows[INFO].window, 0, 28 +
                   18*num_info_lines, 200, 16, False);
                 XDrawString(mydisplay,windows[INFO].window,gc[CLOK], 9,
                   38+18*num_info_lines, buf,strlen(buf));
               }
                 if(windows[PERR].opt1){
                   go_flag=0;
                   paused = 1;
                   expose(PAUB);
                 }
               }
               task_ptr[node]--;
           }
       (*(tsks_prog+task_num))--;
       }
        key_index=USERBLOCKEND;
     }
   }
  }else{
     printf("alphabetic characters detected:\n %s", l);
     if(windows[PERR].opt1){
       go_flag=0;
       paused = 1;
       expose(PAUB);
     }
  }
   u_scan(l);
   
   if (skip == 0 && windows[TRAC].opt1 == 1) {
       if (trace_place <= max_lines) {
        if(trace_type==0||(k==trace_type&&trace_type!=0))
	 if((trace_node==num_nodes)||(((k==SEND&&dest==trace_node)||
	    ((k==RECV||k==RECVWAKE)&&from==trace_node)||node==trace_node)&&
	    (trace_node!=num_nodes))){
	     XDrawImageString(mydisplay, windows[TRAC].window, gc[CLOK], 22, 
	       42 + 18 * trace_place, trac_line, strlen(trac_line));
           trace_place++;
	 }
       } else {
        if(trace_type==0||(k==trace_type&&trace_type!=0))
	 if((trace_node==num_nodes)||(node==trace_node&&trace_node!=num_nodes)){
           XCopyArea(mydisplay, windows[TRAC].window, windows[TRAC].window, 
	     gc[CLOK], 0, 46, trace_width, 18 * max_lines, 0, 28);
	   XClearArea(mydisplay, windows[TRAC].window, 20, 29 + 18 * max_lines,
               trace_width - 21, 16, False);
	   XDrawImageString(mydisplay, windows[TRAC].window, gc[CLOK], 22,  42 +
	       18 * max_lines, trac_line, strlen(trac_line));
	 }
       }
   }
}

int hops(dist_code, p, s, col_wise, src, dst)
        int dist_code, p, s, col_wise, src, dst;
/*
   Compute distance from src to dst in a network with p processors
   (or p*s processors for mesh or torus network).

   Input:
   -----------------------------------------------------------------------
   dist_code = 0 : Hamming distance (hypercube, etc.)
               1 : Mesh (1-D or 2-D mesh without wrap around)
               2 : Torus (mesh with wrap around; includes ring)
               3 : Binary Tree
               4 : Quadtree
               5 : Unit distance (crossbar, fully connected, etc.)
   -----------------------------------------------------------------------
               p : number of processors (number of rows for mesh or torus)
               s : number of columns for mesh or torus (otherwise unused)
    col_wise = 0 : column-wise (for mesh or torus)
               1 : row-wise
             src : source processor number
             dst : destination processor number
   -----------------------------------------------------------------------
   Output:
            hops : number of hops from src to dst
   -----------------------------------------------------------------------

*/

#define abs(x) (((x) >= 0) ? (x) : (-(x)))
#define min(x,y) (((x) < (y)) ? (x) : (y))
#define max(x,y) (((x) > (y)) ? (x) : (y))

{
        int i, j, next, fac, src_r, src_c, dst_r, dst_c, ihops;

switch (dist_code) {

case 0 :        /* Hamming distance */
        i = src^dst;
        ihops=0;
        while(i) {
                if (i & 1) ihops++;
                i = i>>1;
        }
        break;

case 1 :        /* Mesh  */
case 2 :        /* Torus */
        if (col_wise) { /* column-wise */
                src_r = src % p;
                src_c = src / p;
                dst_r = dst % p;
                dst_c = dst / p;
        }
        else {          /* row-wise */
                src_r = src / s;
                src_c = src % s;
                dst_r = dst / s;
                dst_c = dst % s;
        }
        if (dist_code == 1)
                ihops = abs(src_r-dst_r) + abs(src_c-dst_c);
        else {
                ihops = (src_r > dst_r) ? min(src_r-dst_r,dst_r-src_r+p)
                        : min(dst_r-src_r,src_r-dst_r+p) ;
                ihops += (src_c > dst_c) ? min(src_c-dst_c,dst_c-src_c+s)
                        : min(dst_c-src_c,src_c-dst_c+s) ;
        }
        break;

case 3 :        /* Binary Tree */
case 4 :        /* Quadtree    */
        i = 0;
        if (src != dst) {
        fac = (dist_code == 3) ? 2 : 4;
        j = fac;
        for (i = 1; ; i++, j *= fac) {
                next = src - src%j + (j/2) - 1;
                src = next ;

                next = dst - dst%j + (j/2) - 1;
                dst = next;
                if (src == dst) break;
        }
        }
        ihops = 2*i;
        break;

case 5 :        /* Unit Distance */
        ihops = 1;
        break;
}
        return(ihops);
}

