#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern Region sptm_clip_region, crit_clip_region;
extern XPoint sptm_clip_points[], crit_clip_points[];
extern int proc_width, proc_height, win_edge[],k_x[], k_y[], k_center_x, 
	   k_center_y, trace_width, scroll_width[], max_lines, phpt_height, 
	   phpt_width, num_nodes, ninf_center, ninf_height, radius, num_task, 
	   rad, tskc_height, tskc_width, total_tasks, tsmy_height, tsmy_bottom, 
	   left_scale[], right_scale[], psta_width, psta_height, tasks_origin_x,
	   scale_width, win_size, sends_origin_y, recvs_origin_x, 
	   recvs_origin_y;
extern XPoint ref;

resize(new_width, new_height, which)
    int new_width, new_height, which;
{
    int i;

    windows[which].width = new_width;
    windows[which].height = new_height;

    switch (which) {
    case CMMT:
	XMoveWindow(mydisplay, windows[MTRB].window, windows[CMMT].width/2-21,
	  12);
	break;
    case PSTA:
	if (new_width != 680 || new_height != 738) {
	   psta_width = (new_width-40)/2;
	   psta_height = (new_height-98)/2;
	   tasks_origin_x = psta_width + 30;
	   sends_origin_y = psta_height + 60;
	   recvs_origin_x = psta_width + 30;
	   recvs_origin_y = psta_height + 60;
	}
	break;

    case ANIM:
	  XMoveWindow(mydisplay, windows[MTYB].window, new_width/2-21, 10);
	  XMoveWindow(mydisplay, windows[MORB].window, new_width-70, 10);
	  XMoveWindow(mydisplay, windows[ASVB].window, new_width/2-30, 10);
	  XMoveWindow(mydisplay, windows[ARDB].window, new_width-70, 10);
	break;

    case HYPE:
	  /* ref point refers to the center of the designs */
	  ref.x = new_width/2-10;
	  ref.y = (new_height-60)/2-10;
	  /* rad refers to the maximum radius of any design */
	  if (new_width < (new_height-60))
	     rad = new_width/2-30;
	  else
	     rad = (new_height-25)/2-35;
	  XMoveWindow(mydisplay, windows[HTYB].window, new_width/2 - 55,
	     new_height - 25);
	break;

    case NTWK:
        XMoveWindow(mydisplay, windows[SHNB].window, new_width/2-57, 5);
        XMoveWindow(mydisplay, windows[NTYB].window, 5, new_height-25);
        XMoveWindow(mydisplay, windows[NOPB].window, new_width-161, 
	  new_height-25);
        XMoveWindow(mydisplay, windows[NMSB].window, 5, new_height-50);
        XMoveWindow(mydisplay, windows[NMOB].window, new_width-65, 
	  new_height-50);
      break;

    case KIVT:
           if(new_width < new_height)
               radius = (new_width-86)/2;
           else radius = (new_height-86)/2;
	   k_center_x = new_width/2;
	   k_center_y = new_height/2;
	   if(num_nodes<=16){
           for (i = 0; i < num_nodes; i++){
             if (cos(PI/2+2*PI*i/num_nodes)>.0000000001)
               k_x[i] = k_center_x-(int)(radius*cos(PI/2+2*PI*i/num_nodes))-24;
             else if (cos(PI/2+2*PI*i/num_nodes)<-.0000000001)
               k_x[i] = k_center_x-(int)(radius*cos(PI/2+2*PI*i/num_nodes))+8;
             else k_x[i] = k_center_x - 3;
             if (sin(PI/2+2*PI*i/num_nodes)>.0000000001)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/num_nodes))-7;
             else if (sin(PI/2+2*PI*i/num_nodes)<-.0000000001)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/num_nodes))+15;
             else k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/num_nodes))+7;
             if (sin(PI/2+2*PI*i/num_nodes)==1)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/num_nodes))-10;
             if (sin(PI/2+2*PI*i/num_nodes)==-1)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/num_nodes))+18;
           }
	   }else{
           for (i = 0; i < 16; i++){
             if (cos(PI/2+2*PI*i/16)>.0000000001)
               k_x[i] = k_center_x-(int)(radius*cos(PI/2+2*PI*i/16))-24;
             else if (cos(PI/2+2*PI*i/16)<-.0000000001)
               k_x[i] = k_center_x-(int)(radius*cos(PI/2+2*PI*i/16))+8;
             else k_x[i] = k_center_x - 3;
             if (sin(PI/2+2*PI*i/16)>.0000000001)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/16))-7;
             else if (sin(PI/2+2*PI*i/16)<-.0000000001)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/16))+15;
             else k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/16))+7;
             if (sin(PI/2+2*PI*i/16)==1)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/16))-10;
             if (sin(PI/2+2*PI*i/16)==-1)
               k_y[i] = k_center_y-(int)(radius*sin(PI/2+2*PI*i/16))+18;
           }
	   }
	break;

    case NINF:
	    win_edge[NINF-5] = new_width - 30;
	    right_scale[NINF-5] = left_scale[NINF-5]+(new_width-60)/
	      (win_size/scale_width);
	    XMoveWindow(mydisplay, windows[SNDB].window, new_width/2 - 131,
		new_height - 30);
	    XMoveWindow(mydisplay, windows[STYB].window, new_width/2 + 37,
		new_height - 30);
	    ninf_height = (new_height-68)/2;
	    ninf_center = ninf_height + 20;
	    if (windows[SCRB].opt1 == 1)
		scroll_width[NINF-5]=(new_width-21)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[NINF-5]=(new_width-21)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[NINF-5]=(3*(new_width-21))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[NINF-5]=(win_edge[NINF-5]-32);
	break;
    case QUEU:
	    XMoveWindow(mydisplay, windows[MESB].window, 
	      windows[QUEU].width/2+21, 2);
	break;
    case TRAF:
	    win_edge[TRAF-5] = new_width - 40;
	    right_scale[TRAF-5] = left_scale[TRAF-5]+(new_width-80)/
	      (win_size/scale_width);
            XMoveWindow(mydisplay, windows[SIZB].window, (win_edge[TRAF-5]- 
	      210)/2 + 84, 2);
            XMoveWindow(mydisplay, windows[TRNB].window, (win_edge[TRAF-5]- 
	      210)/2 + 192, 2);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[TRAF-5]=(new_width-41)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[TRAF-5]=(new_width-41)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[TRAF-5]=(3*(new_width-41))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[TRAF-5]=(win_edge[TRAF-5]-42);
	break;
    case UTLG:
	    win_edge[UTLG-5] = new_width-30;
	    right_scale[UTLG-5] = left_scale[UTLG-5]+(new_width-60)/
	      (win_size/scale_width);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[UTLG-5]=(new_width-16)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[UTLG-5]=(new_width-16)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[UTLG-5]=(3*(new_width-16))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[UTLG-5]=(win_edge[UTLG-5]-32);
	break;

    case CRIT:
	    win_edge[CRIT-5] = new_width - 30;
	    right_scale[CRIT-5] = left_scale[CRIT-5]+(new_width-60)/
	      (win_size/scale_width);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[CRIT-5]=(new_width-16)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[CRIT-5]=(new_width-16)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[CRIT-5]=(3*(new_width-16))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[CRIT-5]=(win_edge[CRIT-5]-32);
            crit_clip_points[0].x=crit_clip_points[1].x=31;
            crit_clip_points[0].y=crit_clip_points[3].y=16;
            crit_clip_points[1].y=crit_clip_points[2].y=windows[CRIT].height-16;
            crit_clip_points[2].x=crit_clip_points[3].x=windows[CRIT].width-31;
            crit_clip_region = XPolygonRegion(crit_clip_points, 4, 0);
            XSetRegion(mydisplay, gc[CRTP], crit_clip_region);
            XSetRegion(mydisplay, gc[NCRP], crit_clip_region);
	break;

    case SPTM:
	    win_edge[SPTM-5] = new_width - 30;
	    right_scale[SPTM-5] = left_scale[SPTM-5]+(new_width-60)/
	      (win_size/scale_width);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[SPTM-5]=(new_width-16)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[SPTM-5]=(new_width-16)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[SPTM-5]=(3*(new_width-16))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[SPTM-5]=(win_edge[SPTM-5]-32);
            sptm_clip_points[0].x=sptm_clip_points[1].x=31;
            sptm_clip_points[0].y=sptm_clip_points[3].y=16;
            sptm_clip_points[1].y=sptm_clip_points[2].y=windows[SPTM].height-16;
            sptm_clip_points[2].x=sptm_clip_points[3].x=windows[SPTM].width-31;
            sptm_clip_region = XPolygonRegion(sptm_clip_points, 4, 0);
            for (i=0; i<64; i++)
                XSetRegion(mydisplay, gc[SPC0+i], sptm_clip_region);
            for (i=0; i<5; i++)
                XSetRegion(mydisplay, gc[SPT0+i], sptm_clip_region);
	break;

    case UTLC:
	    win_edge[UTLC-5] = new_width - 30;
	    right_scale[UTLC-5] = left_scale[UTLC-5]+(new_width-60)/
	      (win_size/scale_width);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[UTLC-5]=(new_width-16)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[UTLC-5]=(new_width-16)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[UTLC-5]=(3*(new_width-16))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[UTLC-5]=(win_edge[UTLC-5]-32);
	break;
    case TSKG:
	    win_edge[TSKG-5] = new_width-30;
	    right_scale[TSKG-5] = left_scale[TSKG-5]+(new_width-60)/
	      (win_size/scale_width);
	    if (windows[SCRB].opt1 == 1)
		scroll_width[TSKG-5]=(new_width-16)/4;
	    else if (windows[SCRB].opt1 == 2)
		scroll_width[TSKG-5]=(new_width-16)/2;
	    else if (windows[SCRB].opt1 == 3)
		scroll_width[TSKG-5]=(3*(new_width-16))/4;
	    else if (windows[SCRB].opt1 == 4)
		scroll_width[TSKG-5]=(win_edge[TSKG-5]-32);
	break;

    case TSMY:
            tsmy_bottom = new_height - 61;
            tsmy_height = new_height - 84;
        break;
    case TSKC:
            tskc_width = new_width-60;
            tskc_height = new_height - 82;
        break;
    case PROF:
            XMoveWindow(mydisplay, windows[CPFB].window, 
	      (windows[PROF].width-60)/2 + 75, windows[PROF].height-19);
        break;
    case PHPT:
            phpt_width = new_width-60;
            phpt_height = new_height - 75;
        break;
    case TRAC:
	    max_lines = (new_height - 33) / 18 - 1;
	    trace_width = new_width;
        break;
    }
}
