#include <stdio.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern int step_inc, order[], win_edge[], win_size, user_order[],
	   scroll_width[], scale_width, is_env, is_ord, task_colors[], num_wds;
extern char wrd[5][50], print_command[], number[MAXP][4], pat_str[]; 

parse_env(fptr)
FILE *fptr;
{

char str[MAXLINE];
int i, j, k;

 while(fgets(str, MAXLINE, fptr)!=NULL)
 {
   sscanf(str, "%d", &k);

   switch(k)
   {
   case MTRX:
   case KIVT:
   case TSKS:
   case TSKG:
   case SPTM:
   case CRIT:
   case UTLG:
   case UTLC:
   case PSTA:
   case TSKC:
   case UTLS:
   case TSMY:
   case PHPT:
   case UTMT:
   case SLID:
   case TRAC:
   case STTS:
     sscanf(str, "%*d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y);
     break;
   case ANIM:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[ATYB].opt1);
     break;
   case HYPE:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[HTYB].opt1);
     break;
   case NTWK:
     sscanf(str, "%*d %d %d %d %d %d %d %d", &windows[k].opt1, 
       &windows[k].width, &windows[k].height, &windows[k].x, &windows[k].y, 
       &windows[NTYB].opt1, &windows[NOPB].opt1);
     break;
   case NINF:
     sscanf(str, "%*d %d %d %d %d %d %d %d", &windows[k].opt1, 
       &windows[k].width, &windows[k].height, &windows[k].x, &windows[k].y, 
       &windows[SNDB].opt1, &windows[STYB].opt1);
     break;
   case TRAF:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[SIZB].opt1);
     break;
   case QUEU:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[MESB].opt1);
     break;
   case PROF:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[CPFB].opt1);
     break;
   case STRK:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[SRKB].opt1);
     break;
   case CMMT:
     sscanf(str, "%*d %d %d %d %d %d %d", &windows[k].opt1, &windows[k].width,
	 &windows[k].height, &windows[k].x, &windows[k].y, &windows[MTRB].opt1);
     break;
   case CLOK: 
   case SOPT: 
   case INFO: 
   case TMEN: 
   case CMEN: 
   case UMEN: 
   case OMEN: 
     sscanf(str, "%*d %d %d %d", &windows[k].opt1, &windows[k].x, 
       &windows[k].y);
     break;
   case LGND:
     sscanf(str, "%*d %d %d %d %d", &windows[k].opt1, &windows[k].x, 
       &windows[k].y,
	 &windows[CODB].opt1);
     break;
   case FLBR:
     sscanf(str, "%*d %d %d %d %d", &windows[k].opt1, &windows[k].x, 
       &windows[k].y);
     break;
   case MENU:
     sscanf(str, "%*d %d %d", &windows[MENU].x, &windows[MENU].y);
     break;
   case SINC:
     sscanf(str, "%*d %d", &step_inc);
     break;
   case ORDB:
     sscanf(str, "%*d %d", &windows[ORDB].opt1);
     break;
   case SCRB:
     sscanf(str, "%*d %d", &windows[SCRB].opt1);
     break;
   case DSTB:
     sscanf(str, "%*d %d", &windows[DSTB].opt1);
     break;
   case SPRT:
     for(i=0; i<90; i++)
       print_command[i]=NULL;
     sscanf(str, "%*d %90c", print_command);
     print_command[strlen(print_command)-1]=NULL;
     break;
   case TSTP:
     sscanf(str, "%*d %d", &windows[TSTP].opt1);
     break;
   case PATB:
     sscanf(str, "%*d %s", pat_str);
     for(i=0; i<50; i++)
     wrd[0][i]=wrd[1][i]=wrd[2][i]=wrd[3][i]=wrd[4][i]=NULL;
     num_wds=0; k=0;
     for(i=0; i<strlen(pat_str) && num_wds<5; i++){
        if(pat_str[i]!=' '){
          wrd[num_wds][k]=pat_str[i];
          k++;
        }else{
          num_wds++;
          k=0;
        }
     }
     num_wds++;
     break;
   }
 }
 fclose(fptr);
 if(!windows[ORDB].opt1){
   for (j = 0; j < MAXP; j++)
     order[j] = j;
 }else{ 
   for (j = 0; j < MAXP; j++)
     order[j] = ginv(j);
 }
 win_edge[NINF-5]=windows[NINF].width-30;
 win_edge[TRAF-5]=windows[TRAF].width-40;
 win_edge[UTLG-5]=windows[UTLG].width-30;
 win_edge[CRIT-5]=windows[CRIT].width-30;
 win_edge[SPTM-5]=windows[SPTM].width-30;
 win_edge[UTLC-5]=windows[UTLC].width-30;
 win_edge[TSKG-5]=windows[TSKG].width-30;
 switch (windows[SCRB].opt1) {
   case 0:
   for(i=TSKG; i<=TRAF; i++)
     scroll_width[i-5] = win_size / scale_width;
   break;
   case 1:
   for(i=TSKG; i<=TRAF; i++) {
     scroll_width[i-5] = (win_edge[i-5]-16)/4; }  /* halfway back */
   break;
   case 2:
   for(i=TSKG; i<=TRAF; i++) {
     scroll_width[i-5] = (win_edge[i-5]-16)/2; }  /* halfway back */
   break;
   case 3:
   for(i=TSKG; i<=TRAF; i++) {
     scroll_width[i-5] = (3*(win_edge[i-5]-16))/4; }/* halfway back*/
   break;
   case 4:
     scroll_width[NINF-5] = win_edge[NINF-5]-32;
     scroll_width[TRAF-5] = win_edge[TRAF-5]-42;
     scroll_width[UTLG-5] = win_edge[UTLG-5]-32;
     scroll_width[CRIT-5] = win_edge[CRIT-5]-32;
     scroll_width[SPTM-5] = win_edge[SPTM-5]-32;
     scroll_width[UTLC-5] = win_edge[UTLC-5]-32;
     scroll_width[TSKG-5] = win_edge[TSKG-5]-32;
   break;
 }
 is_env=1;
}

parse_order(fptr)
FILE * fptr;
{

char str[MAXLINE];
int i, j, k;
char buf[10];

 while(fgets(str, MAXLINE, fptr)!=NULL)
 {
   k=sscanf(str, "%d %d %s", &i, &j, buf);
   user_order[j]=i;
   if(k==3) strcpy(number[i], buf);
   else sprintf(number[i], "%d", i);
   is_ord=1;
 }
}
parse_color(fptr)
FILE *fptr;
{

XColor task_color_def[64];
Colormap cmap;
char str[MAXLINE];
int i, j, k, m, screen;

 screen = DefaultScreen(mydisplay);
 cmap = DefaultColormap(mydisplay, screen);
 while(fgets(str, MAXLINE, fptr)!=NULL)
 {
   sscanf(str, "%d %d %d %d", &i, &j, &k, &m);
   task_color_def[i].red=j*256;
   task_color_def[i].green=k*256;
   task_color_def[i].blue=m*256;
   XAllocColor(mydisplay,cmap,&task_color_def[i]);
   task_colors[i] = task_color_def[i].pixel;
   XSetForeground(mydisplay, gc[TSK0+(i%8)*8+i/8], task_colors[i]);
 }
}
