/******************************************************************************
*******************************************************************************

  Title: ParaGraph

  Purpose: Graphical Animation of Message-Passing Parallel Programs

  Authors: Jennifer E. Finger 
	   Mathematical Sciences Section
           Oak Ridge National Laboratory
	   P.O. Box 2009, Bldg. 6012
	   Oak Ridge, Tennessee 37831-6367

      and  Michael T. Heath
           4157 Beckman Institute
           University of Illinois
           405 N. Mathews Ave.
           Urbana, IL 61801-2300

  Last update:6/8/94
  For further information: send email to heath@ncsa.uiuc.edu

*******************************************************************************
******************************************************************************/

#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/bitmaps/gray1>
#include <X11/bitmaps/gray3>
#include <X11/bitmaps/dimple1>
#include <X11/bitmaps/dimple3>
#include <dirent.h>
#include "defaults.h"
#include "defines.h"
#include "stripes.h"
#include "bitmaps.h"

Display *mydisplay;
GC gc[269], micro_gc;
Font font1, font2, font3;
XPoint ref;
FILE *tfptr; FILE *recptr[18]; FILE *envptr;
struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

struct win_info windows[147];

char dump_command1[14], dump_command2[21], print_command[90], dname[256],
     displayname[25], prof_type[5], meter_type[7],queu_type[8], envname[256], 
     traf_type[7],stat_type[5], code_type[9], rec_filename[256], ordername[256],
     number[MAXP][4], colorname[256], filename[256], files[100][90];
extern int num_nodes, k_center_x, k_center_y, u_win, win_edge[], ntwk_nodes, 
	   exit_count, num_mesh_dim, poss_mesh_dim[], ntwk_stages,
	   anim_num_nodes, streak_last_top[], streak_last_bottom[], 
	   streak_last_top[], streak_last_bottom[], flbr_width, longf, 
	   no_files, anim_center_x, anim_center_y, anim_rad;
int monochrome, depth, k_init[MAXP], task_button_place, num_task,
    first_file, loop_count, phpt_first_point, order[MAXP], kx[MAXP], ky[MAXP],
    lgnd_height, queue_node, sptm_colors[64], task_colors[64], is_ord, is_env, 
    first_button, is_color, color[32], user_order[MAXP], grayscale, use_color,
    which_map, num_wds, tmap_w[8];
char pgrc_str[256], print_str[256], dir_str[256], delta_str[20], sinc_str[20],
     trace_type_str[20], rec_file_str[256], start_str[20], stop_str[20],
     wrd[5][50], pat_str[256], trace_node_str[20], unit_str[20];
BOD_STRUCT cur_streak[MAXP];
Pixmap tmaps[8][4];
XSizeHints windowhints[37];
float user_anim_x[128], user_anim_y[128]; 
Cursor hand_cursor, toggle_cursor;

main(argc, argv)
    int argc;
    char *argv[];
{
    Pixmap stip1, stip2, stip3, stip4, stip5, stip6;
    unsigned long myforeground, mybackground;
    XColor sptm_color_def[64], task_color_def[64], color_def[42];
    int i, j, k, match, count, ibuf, jbuf, screen, is_anim;
    char **list, animname[256], pgname[256], cbuf[100];
    struct stat sbuf;
    unsigned long event_mask;
    FILE *orderptr, *colorptr, *animptr;
    DIR *dirp;
    Visual *visual;
    Colormap cmap;
    XWMHints wmhints;
    struct dirent *dp;
    float buf1, buf2;
    XFontStruct *font;
    
    orderptr = envptr = colorptr = tfptr = NULL;
    event_mask = ExposureMask | ButtonPressMask | KeyPressMask | 
		 StructureNotifyMask;

    num_nodes=64;
    windows[STAB].opt1=0; windows[KVTB].opt1=0;
    windows[SRKB].opt1=1; windows[MORB].opt1=0;
    windows[NOPB].opt1=0; windows[SLID].opt1=0;
    windows[ORDB].opt1=0; windows[SCRB].opt1=0;
    windows[SCLB].opt1=0; windows[ATYB].opt1=0;
    windows[PERR].opt1=1; windows[TSTP].opt1=0;
    windows[SNDB].opt1=0; windows[CODB].opt1=0;
    windows[CPFB].opt1=0; windows[STYB].opt1=0;
    windows[SIZB].opt1=1; windows[MTYB].opt1=1;
    windows[MESB].opt1=1; windows[HTYB].opt1=0;
    windows[NTYB].opt1=0; windows[SHNB].opt1=0;
    windows[DIMB].opt1=num_nodes; windows[DIMB].opt2=8;
    windows[ANIM].width=285; windows[ANIM].height=285;
    windows[HYPE].width=300; windows[HYPE].height=325;
    windows[MTRX].width=285; windows[MTRX].height=285;
    windows[KIVT].width=286; windows[KIVT].height=286;
    windows[TSKS].width=300; windows[TSKS].height=340;
    windows[TSKG].width=572; windows[TSKG].height=325;
    windows[SPTM].width=572; windows[SPTM].height=285;
    windows[CRIT].width=572; windows[CRIT].height=285;
    windows[UTLG].width=572; windows[UTLG].height=325;
    windows[UTLC].width=572; windows[UTLC].height=325;
    windows[NINF].width=552; windows[NINF].height=580;
    windows[TRAF].width=592; windows[TRAF].height=295;
    windows[PSTA].width=680; windows[PSTA].height=738;
    windows[QUEU].width=630; windows[QUEU].height=295;
    windows[TSKC].width=660; windows[TSKC].height=382;
    windows[UTLS].width=630; windows[UTLS].height=336;
    windows[PHPT].width=360; windows[PHPT].height=375;
    windows[NTWK].width=300; windows[NTWK].height=364;
    windows[TSMY].width=660; windows[TSMY].height=340;
    windows[PROF].width=260; windows[PROF].height=322;
    windows[STRK].width=450; windows[STRK].height=400;
    windows[UTMT].width=50; windows[UTMT].height=280;
    windows[CMMT].width=50; windows[CMMT].height=300;
    windows[SLID].width=200; windows[SLID].height=30;
    windows[TRAC].width=536; windows[TRAC].height=285;
    windows[STTS].width=744; windows[STTS].height=618;
    longf = 1; no_files = 1; flbr_width = 270;
    which_map = 0;
    for(i=ANIM; i<=MENU; i++)
      windows[i].x=windows[i].y=0;
    monochrome = grayscale=use_color=0;
    exit_count = 1;
    first_button=1;
    for(i=0; i<256; i++)
      ordername[i]=colorname[i]=pgrc_str[i]=envname[i] = dname[i] = 
      pgname[i] = pat_str[i] = dir_str[i] = filename[i] = NULL;
    first_file=1;
    for(i=ANIM; i<NTWK; i++)
      recptr[i]=NULL;
    is_anim=is_color=is_env=is_ord=0;
    if (argc > 16) {
    printf("usage: %s [-f tracefile] [-d display] [-e envfile] [-m or -g or -c] [-o orderfile] [-r rgbfile] [-n name] [-l animfile]\n",
	   argv[0]);
	exit(1);
    } else for (i=1; i<argc; i++) {
        if (!strcmp(argv[i],"-f") || !strcmp(argv[i],"-file")) {
	    strcpy(filename, argv[i+1]);
	    i++;
        }else if (!strcmp(argv[i],"-dir")) {
	    strcpy(dname, argv[i+1]);
	    i++;
	} else if (!strcmp(argv[i],"-m") || !strcmp(argv[i], "-monochrome")) {
	    if(!grayscale||!use_color)
	    monochrome =1;
	} else if (!strcmp(argv[i],"-g") || !strcmp(argv[i], "-grayscale")) {
	    if(!monochrome||!use_color)
	    grayscale =1;
	} else if (!strcmp(argv[i],"-c") || !strcmp(argv[i], "-color")) {
	    if(!monochrome||!grayscale)
	    use_color =1;
	} else if (!strcmp(argv[i],"-r") || !strcmp(argv[i], "-rgb")) {
	    strcpy(colorname, argv[i+1]);
	    is_color=1;
	    i++;
	} else if (!strcmp(argv[i],"-o") || !strcmp(argv[i], "-order")) {
	    strcpy(ordername, argv[i+1]);
	    is_ord=1;
	    i++;
	} else if (!strcmp(argv[i],"-e") || !strcmp(argv[i], "-env")) {
	    strcpy(envname, argv[i+1]);
	    is_env=1;
	    i++;
	} else if (!strcmp(argv[i],"-l") || !strcmp(argv[i], "-layout")) {
	    strcpy(animname, argv[i+1]);
	    is_anim=1;
	    i++;
	} else if (!strcmp(argv[i],"-d") || !strcmp(argv[i], "-display")) {
	    strcpy(displayname, argv[i+1]);
	    i++;
	} else if (!strcmp(argv[i],"-n") || !strcmp(argv[i], "-name")) {
	    strcpy(pgname, argv[i+1]);
	    i++;
        } else {
	    strcpy(filename, argv[i]);
	 }
    } 

    sprintf(dump_command1, "xwd -display ");
    sprintf(dump_command2, " | xpr -device ps | ");
    sprintf(print_command,"rsh seq lpr -P lw2");
    strcpy(print_str, print_command);
    sprintf(trace_type_str, "all");
    sprintf(sinc_str, "%d", step_inc);
    sprintf(delta_str, "%d", k_delta);
    sprintf(stop_str, "%d", stop_time);
    sprintf(start_str, "%d", start_time);
    sprintf(unit_str, "%d", time_unit);
    sprintf(trace_node_str, "%d", trace_node);
    for(i=ANIM; i<=OMEN; i++)
      windows[i].opt1=0;

    num_wds = 1;
    strcpy(pat_str, "*");
    strcpy(wrd[0], pat_str);

    for (i = 0; i < MAXP; i++){
	order[i]=user_order[i]=i;
	sprintf(number[i], "%d", i);
    }
    for(i=ANIM; i<=MENU; i++)
      windowhints[i].flags = PPosition | PSize;
    if(!is_env){
      sprintf(envname, ".pgrc");
      if((envptr=fopen(envname, "r"))!=NULL){
	parse_env(envptr);
      }else {
      sprintf(envname, "%s/.pgrc", getenv("HOME"));
      if((envptr=fopen(envname, "r"))!=NULL){
	parse_env(envptr);
      }
     }
    }else{
      if((envptr=fopen(envname, "r"))!=NULL){
	parse_env(envptr);
      }else{
        printf("specified envfile can not be opened.\nContinuing..\n");
      }
    }

    if(filename[0]!=NULL){
      stat(filename, &sbuf);
      if((sbuf.st_mode & S_IFMT) ==S_IFREG){
        if ((tfptr = fopen(filename, "r")) == NULL) {
          printf("Can't open file for reading\n");
          exit(1);
        } 
        first_file=0;
        strcpy(rec_file_str, filename);
        strcpy(rec_filename, filename);
        for(j=strlen(filename)-1; filename[j]!='/'; j--);
        for(k=0; k<j; k++)
          dname[k]=filename[k];
	if(dname[0]==NULL) sprintf(dname, (char *)getcwd(cbuf, 100));
      } else if((sbuf.st_mode & S_IFMT) ==S_IFDIR){
	strcpy(dname, filename);
	for(i=0; i<256; i++)
	  filename[i]=NULL;
      }else{
          printf("Can't open file for reading\n");
          exit(1);
      }
    }
    if(dname[0]==NULL) sprintf(dname, (char *)getcwd(cbuf, 100));
    strcpy(dir_str, dname);
    windows[FLBR].opt2= -1;
    if(dname[0]!=NULL){
      if ((dirp = opendir(dname)) == NULL) {
          printf("Can't access directory\n");
          exit(1);
      }
      no_files=0;
      longf=0;
      while((dp=readdir(dirp))!=NULL){
        sprintf(cbuf, "%s/%s", dname, dp->d_name);
	if(choose(dp->d_name)){
	  ibuf = alpha_shuffle(dp->d_name);
	  if(filename[0]!=NULL){
	    if(!strcmp(dname, (char *)getcwd(cbuf, 100)))
	      sprintf(cbuf, "%s", dp->d_name);
	    else sprintf(cbuf, "%s/%s", dname, dp->d_name);
	    if(!strcmp(filename, cbuf))
	      windows[FLBR].opt2=ibuf;
	  }
          if((ibuf=strlen(dp->d_name))>longf) 
    	    longf=ibuf;
          no_files++;
	}
      }
    }
    if(longf==0) longf = 1;
    if(no_files==0) no_files = 1;
    if(pgname[0]==NULL) sprintf(pgname, "ParaGraph");
    win_edge[SPTM-5]=windows[SPTM].width-30;
    win_edge[CRIT-5]=windows[CRIT].width-30;
    win_edge[UTLC-5]=windows[UTLC].width-30;
    win_edge[TSKG-5]=windows[TSKG].width-30;
    win_edge[UTLG-5]=windows[UTLG].width-30;
    win_edge[TRAF-5]=windows[TRAF].width-40;
    win_edge[NINF-5]=windows[NINF].width-30;
    /* set hints to be used by window manager. */

    ref.x = 140;  /*ref is used in the hypercube drawings*/
    ref.y = 122;
    windowhints[MENU].x = 25;
    windowhints[MENU].y = 150;
    windowhints[MENU].width = 98;
    if(u_win)
        windowhints[MENU].height = 350;
    else windowhints[MENU].height = 332;
    for(i=ANIM; i<=STTS; i++){
      windowhints[i].width=windows[i].width;
      windowhints[i].height=windows[i].height;
    }
    for(i=ANIM; i<=OMEN; i++){
      windowhints[i].x=windows[i].x;
      windowhints[i].y=windows[i].y;
    }

    if ((mydisplay = XOpenDisplay(displayname))==NULL){
        printf("Can't open display\n");
        exit(1);
    }


    screen = DefaultScreen(mydisplay);
    depth = DisplayPlanes(mydisplay, screen);
    cmap = DefaultColormap(mydisplay, screen);
    visual = DefaultVisual(mydisplay, screen);


    list = XListFonts(mydisplay, 
      "6x12", 10, &count);
    if(count==1) font1 = XLoadFont(mydisplay, "6x12");
    else{
      k=ibuf=0;
      count=0;
      while(!count){
        sprintf(cbuf, "-misc-fixed-*-*-*-*-%d-*-*-*-*-*-iso8859-*", 12+ibuf);
        list = XListFonts(mydisplay, cbuf, 10, &count);
        match = 0;
        j=0;
        while(!match){
          for(i=0; i<count; i++){
            font = XLoadQueryFont(mydisplay, list[i]);
            if((font->max_bounds).width>=6-j && (font->max_bounds).width<=6+j){
	      font1 = XLoadFont(mydisplay, list[i]);
	      XFreeFont(mydisplay, font);
	      match=1;
              break;
            }else{
	      XFreeFont(mydisplay, font);
	      j++;
	    }
          }
        }
	k++;
	if(k%2==0) ibuf += k;
	else ibuf -= k;
      }
      printf("Font 6x12 is not available. Using %s instead.\n", list[i]);
    }
    XFreeFontNames(list);

    list = XListFonts(mydisplay, 
      "8x13", 10, &count);
    if(count==1) font2 = XLoadFont(mydisplay, "8x13");
    else{
      k=ibuf=0;
      count=0;
      while(!count){
        sprintf(cbuf, "-misc-fixed-*-*-*-*-%d-*-*-*-*-*-iso8859-*", 13+ibuf);
        list = XListFonts(mydisplay, cbuf, 10, &count);
        match = 0;
        j=0;
        while(!match){
          for(i=0; i<count; i++){
            font = XLoadQueryFont(mydisplay, list[i]);
            if((font->max_bounds).width>=8-j && (font->max_bounds).width<=8+j){
	      font2 = XLoadFont(mydisplay, list[i]);
	      XFreeFont(mydisplay, font);
	      match=1;
              break;
            }else{
	      XFreeFont(mydisplay, font);
	      j++;
	    }
          }
        }
	k++;
	if(k%2==0) ibuf += k;
	else ibuf -= k;
      }
      printf("Font 8x13 is not available. Using %s instead.\n", list[i]);
    }
    XFreeFontNames(list);

    list = XListFonts(mydisplay, "micro", 10, &count);
    if(count==1) font3 = XLoadFont(mydisplay, "micro");
    else{
      k=ibuf=0;
      count=0;
      while(!count){
        sprintf(cbuf, "-misc-fixed-*-*-*-*-%d-*-*-*-*-*-iso8859-*", 8+ibuf);
        list = XListFonts(mydisplay, cbuf, 10, &count);
        match = 0;
        j=0;
        while(!match){
          for(i=0; i<count; i++){
            font = XLoadQueryFont(mydisplay, list[i]);
            if((font->max_bounds).width>=5-j && (font->max_bounds).width<=5+j){
	      font3 = XLoadFont(mydisplay, list[i]);
	      XFreeFont(mydisplay, font);
	      match=1;
              break;
            }else{
	      XFreeFont(mydisplay, font);
	      j++;
	    }
          }
        }
	k++;
	if(k%2==0) ibuf += k;
	else ibuf -= k;
      }
      printf("Font micro is not available. Using %s instead.\n", list[i]);
    }
    XFreeFontNames(list);

    /* create stipples from bitmap data to be used for shading */

    tmap_w[0] = 1;
    tmap_w[1] = 4;
    tmap_w[2] = 4;
    tmap_w[3] = 4;
    tmap_w[4] = 4;
    tmap_w[5] = 1;
    tmap_w[6] = 2;
    tmap_w[7] = 4;
    tmaps[0][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	horiz1_bits, horiz1_width, horiz1_height);
    tmaps[1][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up21_bits, up21_width, up21_height);
    tmaps[1][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up22_bits, up22_width, up22_height);
    tmaps[1][2] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up23_bits, up23_width, up23_height);
    tmaps[1][3] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up24_bits, up24_width, up24_height);
    tmaps[2][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down11_bits, down11_width, down11_height);
    tmaps[2][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down12_bits, down12_width, down12_height);
    tmaps[2][2] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down13_bits, down13_width, down13_height);
    tmaps[2][3] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down14_bits, down14_width, down14_height);
    tmaps[3][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross21_bits, cross21_width, cross21_height);
    tmaps[3][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross22_bits, cross22_width, cross22_height);
    tmaps[3][2] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross23_bits, cross23_width, cross23_height);
    tmaps[3][3] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross24_bits, cross24_width, cross24_height);
    tmaps[4][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up11_bits, up11_width, up11_height);
    tmaps[4][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up12_bits, up12_width, up12_height);
    tmaps[4][2] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up13_bits, up13_width, up13_height);
    tmaps[4][3] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	up14_bits, up14_width, up14_height);
    tmaps[5][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	horiz2_bits, horiz2_width, horiz2_height);
    tmaps[6][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross11_bits, cross11_width, cross11_height);
    tmaps[6][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	cross12_bits, cross12_width, cross12_height);
    tmaps[7][0] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down21_bits, down21_width, down21_height);
    tmaps[7][1] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down22_bits, down22_width, down22_height);
    tmaps[7][2] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down23_bits, down23_width, down23_height);
    tmaps[7][3] = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	down24_bits, down24_width, down24_height);

    stip1 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	dimple3_bits, dimple3_width, dimple3_height);
    stip2 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	gray3_bits, gray3_width, gray3_height);
    stip3 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	dimple1_bits, dimple1_width, dimple1_height);
    stip4 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	gray1_bits, gray1_width, gray1_height);
    stip5 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	stripes1_bits, stripes1_width, stripes1_height);
    stip6 = XCreateBitmapFromData(mydisplay, DefaultRootWindow(mydisplay),
	stripes2_bits, stripes2_width, stripes2_height);

       myforeground = BlackPixel(mydisplay, screen);
       mybackground = WhitePixel(mydisplay, screen);

    /* create gc's and set the fonts */

    for (j = ANIM; j <= TSK0+63; j++) {
        gc[j] = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
        XSetFont(mydisplay, gc[j], font1);
    }
    micro_gc = XCreateGC(mydisplay, DefaultRootWindow(mydisplay), 0, 0);
    XSetForeground(mydisplay, micro_gc, myforeground);
    XSetFont(mydisplay, micro_gc, font3);

    XSetFont(mydisplay, gc[ANIM], font2);
    XSetFont(mydisplay, gc[KIVT], font2);
    XSetFont(mydisplay, gc[CLOK], font2);
    XSetFont(mydisplay, gc[ERA2], font2);
    XSetFont(mydisplay, gc[TSKS], font2);

    hand_cursor = XCreateFontCursor(mydisplay, XC_hand2);
    toggle_cursor = XCreateFontCursor(mydisplay, XC_exchange);

    for(i=0; i<9; i++)
      XSetBackground(mydisplay, gc[NWK1+i], mybackground);
    for (j = ANIM; j <= CLOK; j++) {
        XSetForeground(mydisplay, gc[j], myforeground);
        XSetBackground(mydisplay, gc[j], mybackground);
    }
    
    /* set foreground to black and background to white for all of the
       displays and set stipples for msg lengths, animation, kiviat 
       and the menu because the screen is monochrome */

    if (depth == 1 || monochrome == 1) {
     
       num_task = 3;
       task_button_place = 104;
       XSetLineAttributes(mydisplay, gc[CSTD], 0, LineOnOffDash, 0, 0);
       XSetForeground(mydisplay, gc[UTLB], myforeground);
       XSetForeground(mydisplay, gc[BKED], myforeground);
       for (j = SOPT; j <= TSK0+63; j++) {
           XSetForeground(mydisplay, gc[j], myforeground);
           XSetBackground(mydisplay, gc[j], mybackground);
       }
       XSetForeground(mydisplay, gc[ERAS], mybackground);
       XSetBackground(mydisplay, gc[ERAS], myforeground);
       XSetForeground(mydisplay, gc[UTLI], mybackground);
       XSetForeground(mydisplay, gc[ANMI], mybackground);
       XSetForeground(mydisplay, gc[MNBG], mybackground);
       for (j = ANMC; j <= ANMR; j++) 
           XSetFillStyle(mydisplay, gc[j], FillOpaqueStippled);
       for (j = LGND; j <= LGN2; j++) 
           XSetFillStyle(mydisplay, gc[j], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[MENS], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[IDLS], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[BKBG], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[UTLO], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[KIVH], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[MSQH], FillOpaqueStippled);
       for(i=0; i<64; i+=5){
       XSetFillStyle(mydisplay, gc[COL0+i], FillOpaqueStippled);
       }
       for(i=1; i<64; i+=5){
       XSetFillStyle(mydisplay, gc[COL0+i], FillOpaqueStippled);
       }
       for(i=2; i<64; i+=5){
       XSetFillStyle(mydisplay, gc[COL0+i], FillOpaqueStippled);
       }
       for(i=3; i<64; i+=5){
       XSetFillStyle(mydisplay, gc[COL0+i], FillOpaqueStippled);
       }
       for(i=0; i<64; i++){
       XSetFillStyle(mydisplay, gc[TSK0+i], FillOpaqueStippled);
       }
       XSetFillStyle(mydisplay, gc[UTLO], FillOpaqueStippled);
       XSetFillStyle(mydisplay, gc[BKBG], FillOpaqueStippled);
       XSetStipple(mydisplay, gc[LGND], stip1);
       XSetStipple(mydisplay, gc[LGN0], stip2);
       XSetStipple(mydisplay, gc[LGN1], stip3);
       XSetStipple(mydisplay, gc[LGN2], stip4);
       XSetStipple(mydisplay, gc[KIVH], stip3);
       XSetStipple(mydisplay, gc[MSQH], stip3);
       XSetStipple(mydisplay, gc[ANMC], stip4);
       XSetStipple(mydisplay, gc[ANMS], stip3);
       XSetStipple(mydisplay, gc[ANMR], stip1);
       XSetStipple(mydisplay, gc[MENS], stip2);
       XSetStipple(mydisplay, gc[IDLS], stip3);
       for(i=0; i<64; i+=8){
	 for(j=0; j<8; j++)
	   XSetStipple(mydisplay, gc[TSK0+i+j], tmaps[j][0]);
       }
       for(i=0; i<64; i+=3){
       XSetForeground(mydisplay, gc[SPC0+i], myforeground);
       }
       for(i=4; i<64; i+=5)
       XSetForeground(mydisplay, gc[COL0+i], myforeground);
       for(i=0; i<64; i+=5)
         XSetStipple(mydisplay, gc[COL0+i], stip1);
       for(i=1; i<64; i+=5)
         XSetStipple(mydisplay, gc[COL0+i], stip2);
       for(i=2; i<64; i+=5)
         XSetStipple(mydisplay, gc[COL0+i], stip3);
       for(i=3; i<64; i+=5)
         XSetStipple(mydisplay, gc[COL0+i], stip4);
       XSetStipple(mydisplay, gc[BKBG], stip5);
       XSetStipple(mydisplay, gc[UTLO], stip5);
       XSetLineAttributes(mydisplay, gc[HDSH], 0, LineOnOffDash, 0, 0);
       XSetLineAttributes(mydisplay, gc[CRTP], 3, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK1], 1, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK2], 2, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK3], 3, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK4], 4, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK5], 5, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK6], 6, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK7], 7, LineSolid, 0, 0);
       XSetLineAttributes(mydisplay, gc[NWK8], 7, LineSolid, 0, 0);
       XSetForeground(mydisplay, gc[NWK8], mybackground);
    } else {

/* define the rgb values for the colors */

    color_def[ORANGE].red = 255*256; color_def[ORANGE].green = 140*256;
    color_def[ORANGE].blue = 0*256;
    color_def[YELLOWORANGE].red=255*256;color_def[YELLOWORANGE].green = 210*256;
    color_def[YELLOWORANGE].blue = 0*256;
    color_def[PURERED].red = 255*256; color_def[PURERED].green = 0*256;
    color_def[PURERED].blue = 0*256;
    color_def[ORANGERED].red = 255*256; color_def[ORANGERED].green = 90*256;
    color_def[ORANGERED].blue = 20*256;
    color_def[FUSCHIA].red = 255*256; color_def[FUSCHIA].green = 50*256;
    color_def[FUSCHIA].blue = 170*256;
    color_def[RED].red = 230*256; color_def[RED].green = 0*256;
    color_def[RED].blue = 0*256;
    color_def[REDVIOLET].red = 250*256; color_def[REDVIOLET].green = 75*256;
    color_def[REDVIOLET].blue = 190*256;
    color_def[BLUEVIOLET].red = 155*256; color_def[BLUEVIOLET].green = 85*256;
    color_def[BLUEVIOLET].blue = 225*256;
    color_def[DEEPPURPLE].red = 200*256; color_def[DEEPPURPLE].green = 50*256;
    color_def[DEEPPURPLE].blue = 225*256;
    color_def[PURPLE].red = 210*256; color_def[PURPLE].green = 2*256;
    color_def[PURPLE].blue = 240*256;
    color_def[DARKGREEN].red = 0*256; color_def[DARKGREEN].green = 150*256;
    color_def[DARKGREEN].blue = 70*256;
    color_def[GREEN].red = 10*256; color_def[GREEN].green = 245*256;
    color_def[GREEN].blue = 70*256;
    color_def[YELLOW].red = 255*256; color_def[YELLOW].green = 255*256;
    color_def[YELLOW].blue = 0*256;
    color_def[MEDIUMGREEN].red = 10*256;color_def[MEDIUMGREEN].green = 215*256;
    color_def[MEDIUMGREEN].blue = 10*256;
    color_def[PUREBLUE].red = 0*256; color_def[PUREBLUE].green = 0*256;
    color_def[PUREBLUE].blue = 255*256;
    color_def[BLUE].red = 50*256; color_def[BLUE].green = 120*256;
    color_def[BLUE].blue = 255*256;
    color_def[GREENBLUE].red = 0*256; color_def[GREENBLUE].green = 255*256;
    color_def[GREENBLUE].blue = 180*256;
    color_def[BEIGE].red = 230*256;
    color_def[BEIGE].green = 210*256;
    color_def[BEIGE].blue = 180*256;
    color_def[LIGHTBLUE].red = 190*256; color_def[LIGHTBLUE].green = 180*256;
    color_def[LIGHTBLUE].blue = 255*256;
    color_def[MEDIUMLIGHTBLUE].red = 55*256;
    color_def[MEDIUMLIGHTBLUE].green = 180*256;
    color_def[MEDIUMLIGHTBLUE].blue = 245*256;
    color_def[DARKBLUE].red = 35*256; color_def[DARKBLUE].green = 35*256;
    color_def[DARKBLUE].blue = 140*256;
    color_def[MEDIUMDARKBLUE].red = 100*256; 
    color_def[MEDIUMDARKBLUE].green = 150*256;
    color_def[MEDIUMDARKBLUE].blue = 255*256;
    color_def[CYAN].red = 0*256; color_def[CYAN].green = 235*256;
    color_def[CYAN].blue = 235*256;
    color_def[PLUM].red = 234*256; color_def[PLUM].green = 173*256;
    color_def[PLUM].blue = 234*256;
    color_def[ORCHID].red = 219*256; color_def[ORCHID].green = 112*256;
    color_def[ORCHID].blue = 219*256;
    color_def[BROWN].red = 170*256; color_def[BROWN].green = 100*256;
    color_def[BROWN].blue = 75*256;
    color_def[GRAY0].red = 235*256; color_def[GRAY0].green = 235*256;
    color_def[GRAY0].blue = 235*256;
    color_def[GRAY1].red = 220*256; color_def[GRAY1].green = 220*256;
    color_def[GRAY1].blue = 220*256;
    color_def[GRAY2].red = 205*256; color_def[GRAY2].green = 205*256;
    color_def[GRAY2].blue = 205*256;
    color_def[GRAY3].red = 185*256; color_def[GRAY3].green = 185*256;
    color_def[GRAY3].blue = 185*256;
    color_def[GRAY4].red = 160*256; color_def[GRAY4].green = 160*256;
    color_def[GRAY4].blue = 160*256;
    color_def[GRAY5].red = 140*256; color_def[GRAY5].green = 140*256;
    color_def[GRAY5].blue = 140*256;
    color_def[GRAY6].red = 115*256; color_def[GRAY6].green = 115*256;
    color_def[GRAY6].blue = 115*256;
    color_def[GRAY7].red = 90*256; color_def[GRAY7].green = 90*256;
    color_def[GRAY7].blue = 90*256;


       for (j=RED;j<=GRAY7;j++) {
	   XAllocColor(mydisplay,cmap,&color_def[j]);
	   color[j] = color_def[j].pixel;
        }

    if((visual->class==StaticGray||visual->class==GrayScale||grayscale==1)&&
       use_color==0){
    /* set shading for each display since the screen is grayscale */

   	    XSetForeground(mydisplay, gc[SPT0], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[SPT1], color[GRAY3]);
   	    XSetForeground(mydisplay, gc[SPT2], color[GRAY4]);
   	    XSetForeground(mydisplay, gc[SPT3], color[GRAY5]);
   	    XSetForeground(mydisplay, gc[SPT4], color[GRAY6]);
   	    XSetForeground(mydisplay, gc[LGND], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[LGN0], color[GRAY3]);
   	    XSetForeground(mydisplay, gc[LGN1], color[GRAY4]);
   	    XSetForeground(mydisplay, gc[LGN2], color[GRAY5]);
   	    XSetForeground(mydisplay, gc[LGN3], color[GRAY6]);
   	    XSetForeground(mydisplay, gc[NWK1], color[GRAY1]);
   	    XSetForeground(mydisplay, gc[NWK2], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[NWK3], color[GRAY3]);
   	    XSetForeground(mydisplay, gc[NWK4], color[GRAY4]);
   	    XSetForeground(mydisplay, gc[NWK5], color[GRAY5]);
   	    XSetForeground(mydisplay, gc[NWK6], color[GRAY6]);
   	    XSetForeground(mydisplay, gc[NWK7], color[GRAY7]);
            XSetForeground(mydisplay, gc[NWK8], mybackground);
        for(i=0; i<64; i++){
          XSetForeground(mydisplay, gc[TSK0+i], color[GRAY0+i%8]);
          XSetForeground(mydisplay, gc[SPC0+i], color[GRAY0+i%8]);
          XSetForeground(mydisplay, gc[COL0+i], color[GRAY0+i%8]);
        }
            num_task = 16;
            task_button_place = 59;
   	    XSetForeground(mydisplay, gc[MENU], myforeground);
   	    XSetForeground(mydisplay, gc[CSTH], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[BSYS], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[IDLS], color[GRAY4]);
   	    XSetBackground(mydisplay, gc[MENU], mybackground);
   	    XSetForeground(mydisplay, gc[BKBG], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[BKED], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[KIVH], color[GRAY3]);
   	    XSetForeground(mydisplay, gc[MSQH], color[GRAY3]);
   	    XSetForeground(mydisplay, gc[MSQC], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[NCRP], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[CRTP], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[KIVC], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[UTLB], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[COMH], color[GRAY5]);
   	    XSetForeground(mydisplay, gc[SLID], color[GRAY5]);
   	    XSetForeground(mydisplay, gc[ANMI], color[GRAY0]);
   	    XSetForeground(mydisplay, gc[ANMC], color[GRAY7]);
   	    XSetForeground(mydisplay, gc[ANMS], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[ANMR], color[GRAY4]);
   	    XSetForeground(mydisplay, gc[MENS], color[GRAY2]);
   	    XSetForeground(mydisplay, gc[TMBR], color[GRAY4]);
            XSetForeground(mydisplay, gc[ERAS], mybackground);
            XSetBackground(mydisplay, gc[ERAS], myforeground);
            XSetForeground(mydisplay, gc[MNBG], mybackground);
            XSetForeground(mydisplay, gc[GNTL], myforeground);
            XSetForeground(mydisplay, gc[UTLO], color[GRAY3]);
            XSetForeground(mydisplay, gc[HSLD], myforeground);
            XSetForeground(mydisplay, gc[HDSH], color[GRAY3]);
            XSetBackground(mydisplay, gc[HDSH], mybackground); 
            XSetBackground(mydisplay, gc[HSLD], mybackground); 
            XSetForeground(mydisplay, gc[UTLI], color[GRAY0]);
	    XSetForeground(mydisplay, gc[SPTH], myforeground);
	    XSetForeground(mydisplay, gc[CRTP], myforeground);
        }
	if((visual->class==PseudoColor||visual->class==StaticColor||
	   visual->class==DirectColor||visual->class==TrueColor||
	   use_color==1)&&grayscale==0){
    /* set colors for each display since the screen is color */

      for(i=0; i<64; i++){
      task_color_def[i].red=reds[i]*256; 
      task_color_def[i].green=greens[i]*256;
      task_color_def[i].blue=blues[i]*256;
      sptm_color_def[i].red=sptm_reds[i]*256; 
      sptm_color_def[i].green=sptm_greens[i]*256;
      sptm_color_def[i].blue=sptm_blues[i]*256;
      }
      for (j=0;j<64;j++) {
          XAllocColor(mydisplay,cmap,&task_color_def[j]);
          XAllocColor(mydisplay,cmap,&sptm_color_def[j]);
          task_colors[j] = task_color_def[j].pixel;
          sptm_colors[j] = sptm_color_def[j].pixel;
          XSetForeground(mydisplay, gc[TSK0+(j%8)*8+j/8], task_colors[j]);
          XSetForeground(mydisplay, gc[SPC0+(j%8)*8+j/8], sptm_colors[j]);
          XSetForeground(mydisplay, gc[COL0+(j%8)*8+j/8], sptm_colors[j]);
      }
            num_task = 16;
            task_button_place = 59;
   	    XSetForeground(mydisplay, gc[TSKS], color[DARKGREEN]);
   	    XSetForeground(mydisplay, gc[SPTH], color[DARKGREEN]);
   	    XSetForeground(mydisplay, gc[SPT0], color[MEDIUMLIGHTBLUE]);
   	    XSetForeground(mydisplay, gc[SPT1], color[BLUEVIOLET]);
   	    XSetForeground(mydisplay, gc[SPT2], color[PURPLE]);
   	    XSetForeground(mydisplay, gc[SPT3], color[REDVIOLET]);
   	    XSetForeground(mydisplay, gc[SPT4], color[PURERED]);
   	    XSetForeground(mydisplay, gc[MSQC], color[BLUEVIOLET]);
   	    XSetForeground(mydisplay, gc[MENU], myforeground);
   	    XSetBackground(mydisplay, gc[MENU], mybackground);
   	    XSetForeground(mydisplay, gc[BKBG], color[BEIGE]);
   	    XSetForeground(mydisplay, gc[BKED], color[BROWN]);
   	    XSetForeground(mydisplay, gc[PHDL], myforeground);
   	    XSetForeground(mydisplay, gc[LGND], color[MEDIUMLIGHTBLUE]);
   	    XSetForeground(mydisplay, gc[LGN0], color[BLUEVIOLET]);
   	    XSetForeground(mydisplay, gc[LGN1], color[PURPLE]);
   	    XSetForeground(mydisplay, gc[LGN2], color[REDVIOLET]);
   	    XSetForeground(mydisplay, gc[LGN3], color[PURERED]);
   	    XSetForeground(mydisplay, gc[KIVH], color[GREEN]);
   	    XSetForeground(mydisplay, gc[KIVC], color[MEDIUMGREEN]);
   	    XSetForeground(mydisplay, gc[UTLB], color[GREEN]);
   	    XSetForeground(mydisplay, gc[CSTH], color[MEDIUMDARKBLUE]);
   	    XSetForeground(mydisplay, gc[CSTD], color[PURERED]);
   	    XSetForeground(mydisplay, gc[COMH], color[BLUE]);
   	    XSetForeground(mydisplay, gc[SLID], color[RED]);
   	    XSetForeground(mydisplay, gc[ANMI], color[RED]);
   	    XSetForeground(mydisplay, gc[ANMC], color[GREEN]);
   	    XSetForeground(mydisplay, gc[ANMS], color[BLUE]);
   	    XSetForeground(mydisplay, gc[ANMR], color[YELLOW]);
   	    XSetForeground(mydisplay, gc[UTLO], color[YELLOW]);
   	    XSetForeground(mydisplay, gc[MSQH], color[PLUM]);
   	    XSetForeground(mydisplay, gc[MENS], color[BEIGE]);
   	    XSetForeground(mydisplay, gc[MNBG], color[CYAN]);
   	    XSetForeground(mydisplay, gc[TMBR], color[CYAN]);
   	    XSetForeground(mydisplay, gc[IDLS], color[RED]);
   	    XSetForeground(mydisplay, gc[BSYS], color[GREEN]);
            XSetForeground(mydisplay, gc[ERAS], mybackground);
            XSetBackground(mydisplay, gc[ERAS], myforeground);
            XSetForeground(mydisplay, gc[NWK1], color[BLUE]);
            XSetForeground(mydisplay, gc[NWK2], color[CYAN]);
            XSetForeground(mydisplay, gc[NWK3], color[GREENBLUE]);
            XSetForeground(mydisplay, gc[NWK4], color[GREEN]);
            XSetForeground(mydisplay, gc[NWK5], color[YELLOWORANGE]);
            XSetForeground(mydisplay, gc[NWK6], color[ORANGE]);
            XSetForeground(mydisplay, gc[NWK7], color[RED]);
            XSetForeground(mydisplay, gc[NWK8], mybackground);
            XSetForeground(mydisplay, gc[GNTL], color[BLUE]);
            XSetForeground(mydisplay, gc[UTLI], color[RED]);
            XSetForeground(mydisplay, gc[HDSH], color[RED]);
            XSetForeground(mydisplay, gc[HSLD], color[BLUE]);
            XSetBackground(mydisplay, gc[HDSH], mybackground); 
            XSetBackground(mydisplay, gc[HSLD], mybackground);
            XSetForeground(mydisplay, gc[CRTP], color[PURERED]);
            XSetForeground(mydisplay, gc[NCRP], color[MEDIUMLIGHTBLUE]);
          }
    }

    anim_center_y = ceil((double)(windows[ANIM].height/2));
    anim_center_x = ceil((double)(windows[ANIM].width/2));
    if(windows[ANIM].width < windows[ANIM].height)
        anim_rad = anim_center_x-50;
    else anim_rad = anim_center_y-25;

    ntwk_stages=ntwk_nodes=0;
    if (tfptr != NULL){
       preprocess();
    }else{
      ntwk_nodes=num_nodes;
      ms_net(windows[NTYB].opt1, &ntwk_nodes, &ntwk_stages);
      num_mesh_dim=0;
      anim_num_nodes=num_nodes;
      for(i=1; i<=32; i++){
       if(num_nodes%i==0&&num_nodes/i<=32){
         poss_mesh_dim[num_mesh_dim]=i;
         num_mesh_dim++;
       }
      }
      if(num_mesh_dim==0){
        anim_num_nodes=32*(int)ceil(((double)num_nodes)/32.0);
        for(i=1; i<=32; i++){
          if(anim_num_nodes%i==0&&anim_num_nodes/i<=32){
            poss_mesh_dim[num_mesh_dim]=i;
            num_mesh_dim++;
          }
        }
      }
      windows[NMSB].opt2=windows[MTYB].opt2=poss_mesh_dim[num_mesh_dim/2];
      windows[NMSB].opt1=windows[MTYB].opt1=num_mesh_dim/2;
    }
    u_init();

     if (stop_time>win_size/2){
         scale_width = win_size;
         windows[SCLB].opt1 = 0;
     } else if (stop_time>win_size/4){
         scale_width = win_size/2;
         windows[SCLB].opt1 = 1;
     } else if (stop_time>win_size/8){
         scale_width = win_size/4;
         windows[SCLB].opt1 = 2;
     } else {
         scale_width = win_size/8;
         windows[SCLB].opt1 = 3;
     }

    if(!is_anim){
      sprintf(animname, ".pganim");
      if((animptr=fopen(animname, "r"))!=NULL){
        i=0;
        while(fgets(cbuf, MAXLINE, animptr)){
          sscanf(cbuf, "%f %f", &buf1, &buf2);
          user_anim_x[i] = buf1;
          user_anim_y[i] = buf2;
          i++;
        }
        fclose(animptr);
      }else {
      sprintf(animname, "%s/.pganim", getenv("HOME"));
      if((animptr=fopen(animname, "r"))!=NULL){
        i=0;
        while(fgets(cbuf, MAXLINE, animptr)){
          sscanf(cbuf, "%f %f", &buf1, &buf2);
          user_anim_x[i] = buf1;
          user_anim_y[i] = buf2;
          i++;
        }
        fclose(animptr);
      }
     }
    }else{
      if((animptr=fopen(animname, "r"))!=NULL){
        i=0;
        while(fgets(cbuf, MAXLINE, animptr)){
          sscanf(cbuf, "%f %f", &buf1, &buf2);
          user_anim_x[i] = buf1;
          user_anim_y[i] = buf2;
          i++;
        }
        fclose(animptr);
      }else{
        printf("specified animfile can not be opened.\nContinuing..\n");
      }
    }
    if(!is_color){
      sprintf(colorname, ".pgcolors");
      if((colorptr=fopen(colorname, "r"))!=NULL){
	if(depth!=1 && monochrome !=1)parse_color(colorptr);
      }else {
      sprintf(colorname, "%s/.pgcolors", getenv("HOME"));
      if((colorptr=fopen(colorname, "r"))!=NULL)
	if(depth!=1 && monochrome !=1)parse_color(colorptr);
     }
    }else{
      if((colorptr=fopen(colorname, "r"))!=NULL)
	if(depth!=1 && monochrome !=1)parse_color(colorptr);
      else{
        printf("specified colorfile can not be opened.\nContinuing..\n");
      }
    }
    if(!is_ord){
      sprintf(ordername, ".pgorder");
      if((orderptr=fopen(ordername, "r"))!=NULL){
	parse_order(orderptr);
      }else {
      sprintf(ordername, "%s/.pgorder", getenv("HOME"));
      if((orderptr=fopen(ordername, "r"))!=NULL)
	parse_order(orderptr);
     }
    }else{
      if((orderptr=fopen(ordername, "r"))!=NULL)
	parse_order(orderptr);
      else{
        printf("specified orderfile can not be opened.\nContinuing..\n");
      }
    }

    /* create the many windows */
    for(i=ANIM; i<=OMEN; i++)
      if(windows[i].opt1) opencount++;
    if(is_env){
     for(i=ANIM; i<=MENU; i++){
      windowhints[i].flags = USPosition | PSize;
     }
    }

    windows[ANFL].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), 500, 540, 230, 79, 2,
	myforeground, mybackground);

    XChangeProperty(mydisplay, windows[ANFL].window, XA_WM_NAME,
	XA_STRING, 8, PropModeReplace, (unsigned char *)"Animation File", 14);

    windows[QEST].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), 500, 500, 208, 79, 2,
	myforeground, mybackground);

    XChangeProperty(mydisplay, windows[QEST].window, XA_WM_NAME,
	XA_STRING, 8, PropModeReplace, (unsigned char *)"Question", 8);

    windows[YESB].window = XCreateSimpleWindow(mydisplay, windows[QEST].window,
	96, 52, 40, 21, 2, myforeground, mybackground);

    windows[QNOB].window = XCreateSimpleWindow(mydisplay, windows[QEST].window,
	149, 52, 32, 21, 2, myforeground, mybackground);

    windows[TSKS].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TSKS].x, windows[TSKS].y,
	windows[TSKS].width, windows[TSKS].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TSKS].window, "Task Status", 
     "Task Status", None, argv, argc, &windowhints[TSKS]);

    windows[PSTA].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[PSTA].x, windows[PSTA].y,
	windows[PSTA].width, windows[PSTA].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[PSTA].window, "Processor Status", 
     "Processor Status", None, argv, argc, &windowhints[PSTA]);

    windows[NTWK].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[NTWK].x, windows[NTWK].y,
	windows[NTWK].width, windows[NTWK].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[NTWK].window, "Network", 
     "Network", None, argv, argc, &windowhints[NTWK]);

    windows[SHNB].window = XCreateSimpleWindow(mydisplay, windows[NTWK].window,
	windows[NTWK].height/2-57, 5, 114,20,1, myforeground, mybackground);

    windows[NTYB].window = XCreateSimpleWindow(mydisplay, windows[NTWK].window,
	5, windows[NTWK].height-25, 110,20,1, myforeground, mybackground);

    windows[NOPB].window = XCreateSimpleWindow(mydisplay, windows[NTWK].window,
	windows[NTWK].width-161, windows[NTWK].height-25,
	156,20,1, myforeground, mybackground);

    windows[NMSB].window = XCreateSimpleWindow(mydisplay, windows[NTWK].window,
	5, windows[NTWK].height-50, 42,20,1, myforeground, mybackground);

    windows[NMOB].window = XCreateSimpleWindow(mydisplay, windows[NTWK].window,
	windows[NTWK].width-65,windows[NTWK].height-50,
	60,20,1, myforeground, mybackground);

    windows[HYPE].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[HYPE].x, windows[HYPE].y,
	windows[HYPE].width, windows[HYPE].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[HYPE].window, "Hypercube", 
     "Hypercube", None, argv, argc, &windowhints[NTWK]);

    windows[HTYB].window = XCreateSimpleWindow(mydisplay,
        windows[HYPE].window,95,300,110,20,1, myforeground, mybackground);

    lgnd_height = 246;

    windowhints[LGND].width=64; windowhints[LGND].height=lgnd_height;
    windows[LGND].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[LGND].x, windows[LGND].y, 64, 
	lgnd_height, 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[LGND].window, "Color Code", 
     "Color Code", None, argv, argc, &windowhints[LGND]);

    windows[CODB].window = XCreateSimpleWindow(mydisplay, windows[LGND].window,
        2, 2, 58, 16, 1, myforeground, mybackground);

    windowhints[TMEN].width=98; windowhints[TMEN].height=78;
    windows[TMEN].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TMEN].x, windows[TMEN].y,
	windowhints[TMEN].width, 78, 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[TMEN].window, "Task", 
     "Task", None, argv, argc, &windowhints[TMEN]);

    windowhints[CMEN].width=98; windowhints[CMEN].height=186;
    windows[CMEN].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[CMEN].x, windows[CMEN].y, 
	windowhints[CMEN].width, 186, 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[CMEN].window, "Comm", 
     "Comm", None, argv, argc, &windowhints[CMEN]);

    windowhints[UMEN].width=98; windowhints[UMEN].height=132;
    windows[UMEN].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[UMEN].x, windows[UMEN].y, 
	windowhints[UMEN].width, 132, 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[UMEN].window, "Util", 
     "Util", None, argv, argc, &windowhints[UMEN]);

    windowhints[OMEN].width=98; windowhints[OMEN].height=132;
    windows[OMEN].window = XCreateSimpleWindow(mydisplay, 
	DefaultRootWindow(mydisplay), windows[OMEN].x, windows[OMEN].y, 
	windowhints[OMEN].width, 132, 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[OMEN].window, "Other", 
     "Other", None, argv, argc, &windowhints[OMEN]);

    windows[MENU].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[MENU].x, windows[MENU].y, 
	windowhints[MENU].width, windowhints[MENU].height,
	2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[MENU].window, pgname, 
     pgname, None, argv, argc, &windowhints[MENU]);

    windows[PHPT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[PHPT].x, windows[PHPT].y,
	windows[PHPT].width, windows[PHPT].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[PHPT].window, "Phase Portrait", 
     "Phase Portrait", None, argv, argc, &windowhints[PHPT]);

    windows[CMMT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[CMMT].x, windows[CMMT].y,
	windows[CMMT].width, windows[CMMT].height, 2, myforeground, 
	mybackground);

    windows[MTRB].window = XCreateSimpleWindow(mydisplay, windows[CMMT].window,
	4, 12, 42, 16, 1, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[CMMT].window, 
     "Communication Meter", "Communication Meter", None, argv, argc, 
     &windowhints[CMMT]);

    windows[UTMT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[UTMT].x, windows[UTMT].y,
	windows[UTMT].width, windows[UTMT].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[UTMT].window, "Utilization Meter",
     "Utilization Meter", None, argv, argc, &windowhints[UTMT]);

    windows[CLOK].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[CLOK].x, windows[CLOK].y,
	112, 50, 2, myforeground, mybackground);

    windowhints[CLOK].width=112; windowhints[CLOK].height=50;
    XSetStandardProperties(mydisplay, windows[CLOK].window, "Clock", 
     "Clock", None, argv, argc, &windowhints[CLOK]);

    windows[TRAC].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TRAC].x, windows[TRAC].y,
	windows[TRAC].width, windows[TRAC].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TRAC].window, "Trace Events", 
     "Trace Events", None, argv, argc, &windowhints[TRAC]);

    if((ibuf=flbr_width/(longf*6+8))==0) ibuf=1;
    jbuf=(int)ceil(((double)no_files)/((double)ibuf));
    windows[FLBR].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[FLBR].x, windows[FLBR].y,
	274, 88+jbuf*18, 2, myforeground, mybackground);

    windows[TFIL].window = XCreateSimpleWindow(mydisplay, windows[FLBR].window,
      2, 2, 266, 37, 2,myforeground, mybackground);

    windows[PATB].window = XCreateSimpleWindow(mydisplay, windows[FLBR].window,
      2, 45, 266, 37, 2,myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[FLBR].window, "Tracefile", 
     "Tracefile", None, argv, argc, &windowhints[FLBR]);

    windowhints[INFO].width=200; 
    windowhints[INFO].height=27+18*(num_info_lines+1);
    windows[INFO].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[INFO].x, windows[INFO].y,
	200, 28+18*(num_info_lines+1), 2, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[INFO].window, 
     "Coordinate Information", "Coordinate Information", None, argv, argc, 
     &windowhints[INFO]);

    windows[SLID].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[SLID].x, windows[SLID].y, 
	windows[SLID].width, windows[SLID].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[SLID].window, 
     "Slow Motion Slider", "Slow Motion Slider", None, argv, argc, 
     &windowhints[SLID]);

    /* next 18 windows are buttons/choices on menus */

    windows[TRFB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 2, 90, 16, 2, myforeground, mybackground);
    windows[STMB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
        2, 20, 90, 16, 2, myforeground, mybackground);
    windows[QUEB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 38, 90, 16, 2, myforeground, mybackground);
    windows[MTXB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 56, 90, 16, 2, myforeground, mybackground);
    windows[CMMB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 74, 90, 16, 2, myforeground, mybackground);
    windows[ANMB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 92, 90, 16, 2, myforeground, mybackground);
    windows[HYPB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
        2, 110, 90, 16, 2, myforeground, mybackground);
    windows[NTWB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
        2, 128, 90, 16, 2, myforeground, mybackground);
    windows[NIFB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
	2, 146, 90, 16, 2, myforeground, mybackground);
    windows[LGNB].window = XCreateSimpleWindow(mydisplay, windows[CMEN].window,
        2, 164, 90, 16, 2, myforeground, mybackground);


    windows[UTCB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
	2, 2, 90, 16, 2, myforeground, mybackground);
    windows[UTGB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
	2, 20, 90, 16, 2, myforeground, mybackground);
    windows[KIVB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
	2, 38, 90, 16, 2, myforeground, mybackground);
    windows[STKB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
        2, 56, 90, 16, 2, myforeground, mybackground);
    windows[UTSB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
        2, 74, 90, 16, 2, myforeground, mybackground);
    windows[UTMB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
        2, 92, 90, 16, 2, myforeground, mybackground);
    windows[PRFB].window = XCreateSimpleWindow(mydisplay, windows[UMEN].window,
        2, 110, 90, 16, 2, myforeground, mybackground);

    windows[TSCB].window = XCreateSimpleWindow(mydisplay, windows[TMEN].window,
	2, 2, 90, 16, 2, myforeground, mybackground);
    windows[TSGB].window = XCreateSimpleWindow(mydisplay, windows[TMEN].window,
	2, 20, 90, 16, 2, myforeground, mybackground);
    windows[TSTB].window = XCreateSimpleWindow(mydisplay, windows[TMEN].window,
	2, 38, 90, 16, 2, myforeground, mybackground);
    windows[TSMB].window = XCreateSimpleWindow(mydisplay, windows[TMEN].window,
	2, 56, 90, 16, 2, myforeground, mybackground);

    windows[CLKB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 2, 90, 16, 2, myforeground, mybackground);
    windows[TRCB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 20, 90, 16, 2, myforeground, mybackground);
    windows[STTB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 38, 90, 16, 2, myforeground, mybackground);
    windows[PSTB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 56, 90, 16, 2, myforeground, mybackground);
    windows[CRTB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
        2, 74, 90, 16, 2, myforeground, mybackground);
    windows[PHPB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 92, 90, 16, 2, myforeground, mybackground);
    windows[INFB].window = XCreateSimpleWindow(mydisplay, windows[OMEN].window,
	2, 110, 90, 16, 2, myforeground, mybackground);

    windows[UMNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 20, 90, 16, 2, myforeground, mybackground);
    windows[CMNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 38, 90, 16, 2, myforeground, mybackground);
    windows[TMNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 56, 90, 16, 2, myforeground, mybackground);
    windows[OMNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 74, 90, 16, 2, myforeground, mybackground);
    windows[USRB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 92, 90, 16, 2, myforeground, mybackground);
    if(u_win==0){
    windows[FBRB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 92, 90, 16, 2, myforeground, mybackground);
    windows[OPTB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 110, 90, 16, 2, myforeground, mybackground);
    windows[ROPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 128, 90, 16, 2, myforeground, mybackground);
    windows[RUNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 166, 90, 16, 2, myforeground, mybackground);
    windows[PAUB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 184, 90, 16, 2, myforeground, mybackground);
    windows[STPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 202, 90, 16, 2, myforeground, mybackground);
    windows[SLDB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 220, 90, 16, 2, myforeground, mybackground);
    windows[CLOB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 238, 90, 16, 2, myforeground, mybackground);
    windows[ENVB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 256, 90, 16, 2, myforeground, mybackground);
    windows[SDPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 274, 90, 16, 2, myforeground, mybackground);
    windows[RSTB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
        2, 292, 90, 16, 2, myforeground, mybackground);
    windows[QITB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
        2, 310, 90, 16, 2, myforeground, mybackground);

    }else{
    windows[FBRB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 110, 90, 16, 2, myforeground, mybackground);
    windows[OPTB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 128, 90, 16, 2, myforeground, mybackground);
    windows[ROPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 146, 90, 16, 2, myforeground, mybackground);
    windows[RUNB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 184, 90, 16, 2, myforeground, mybackground);
    windows[PAUB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 202, 90, 16, 2, myforeground, mybackground);
    windows[STPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 220, 90, 16, 2, myforeground, mybackground);
    windows[SLDB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 238, 90, 16, 2, myforeground, mybackground);
    windows[CLOB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 256, 90, 16, 2, myforeground, mybackground);
    windows[ENVB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 274, 90, 16, 2, myforeground, mybackground);
    windows[SDPB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
	2, 292, 90, 16, 2, myforeground, mybackground);
    windows[RSTB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
        2, 310, 90, 16, 2, myforeground, mybackground);
    windows[QITB].window = XCreateSimpleWindow(mydisplay, windows[MENU].window,
        2, 328, 90, 16, 2, myforeground, mybackground);
    }

    windowhints[ROPT].width=254; windowhints[ROPT].height=313;
    windows[ROPT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), 0, 0, 254, 313, 2, 
	myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[ROPT].window, "Record Options", 
     "Record Options", None, argv, argc, &windowhints[ROPT]);

    windows[UTCR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 21, 120, 16, 2, myforeground, mybackground);
    windows[UTGR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 43, 120, 16, 2, myforeground, mybackground);
    windows[KIVR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 65, 120, 16, 2, myforeground, mybackground);
    windows[UTSR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 87, 120, 16, 2, myforeground, mybackground);
    windows[TRAR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 109, 120, 16, 2, myforeground, mybackground);
    windows[SPTR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 131, 120, 16, 2,myforeground, mybackground);
    windows[QUER].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 153, 120, 16, 2,myforeground, mybackground);
    windows[MTRR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 175, 120, 16, 2,myforeground, mybackground);
    windows[ANIR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 197, 120, 16, 2,myforeground, mybackground);
    windows[HYPR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 21, 120, 16, 2,myforeground, mybackground);
    windows[NTWR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 43, 120, 16, 2,myforeground, mybackground);
    windows[NINR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 65, 120, 16, 2,myforeground, mybackground);
    windows[TSCR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 87, 120, 16, 2,myforeground, mybackground);
    windows[TSGR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 109, 120, 16, 2,myforeground, mybackground);
    windows[TSSR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 131, 120, 16, 2,myforeground, mybackground);
    windows[PSTR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 153, 120, 16, 2,myforeground, mybackground);
    windows[CRIR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 175, 120, 16, 2,myforeground, mybackground);
    windows[PHPR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      128, 197, 120, 16, 2,myforeground, mybackground);
    windows[RSTR].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 219, 246, 20, 2, myforeground, mybackground);
    windows[RSTP].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 245, 246, 20, 2, myforeground, mybackground);
    windows[RFNP].window = XCreateSimpleWindow(mydisplay, windows[ROPT].window,
      2, 271, 246, 36, 2,myforeground, mybackground);

    windowhints[SOPT].width=274; windowhints[SOPT].height=234;
    windows[SOPT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[SOPT].x, windows[SOPT].y,
	windowhints[SOPT].width, windowhints[SOPT].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[SOPT].window, "Options", 
     "Options", None, argv, argc, &windowhints[SOPT]);

    wmhints.initial_state=NormalState;
    wmhints.input=True;
    wmhints.flags=StateHint | InputHint;
    XSetWMHints(mydisplay, windows[SOPT].window, &wmhints);

    windows[ORDB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 2, 130, 21, 2, myforeground, mybackground);
    windows[SCRB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      138, 2, 130, 21, 2, myforeground, mybackground);
    windows[SCLB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 29, 130, 21, 2, myforeground, mybackground);
    windows[STMU].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      138, 29, 130, 21, 2, myforeground, mybackground);
    windows[STAR].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 56, 130, 21, 2, myforeground, mybackground);
    windows[STOP].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      138, 56, 130, 21, 2, myforeground, mybackground);
    windows[SINC].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 83, 130, 21, 2, myforeground, mybackground);
    windows[DELT].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      138, 83, 130, 21, 2, myforeground, mybackground);
    windows[TSTP].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 110, 185, 21, 2,myforeground, mybackground);
    windows[PERR].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      193, 110, 75, 21, 2,myforeground, mybackground);
    windows[TRCN].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 137, 130, 21, 2,myforeground, mybackground);
    windows[TRCT].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      138, 137, 130, 21, 2,myforeground, mybackground);
    windows[SPRT].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 164, 266, 37, 2,myforeground, mybackground);
    windows[DSTB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      2, 207, 266, 21, 2,myforeground, mybackground);
    windows[COLB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      160, 207, 55, 21, 2,myforeground, mybackground);
    windows[DIMB].window = XCreateSimpleWindow(mydisplay, windows[SOPT].window,
      221, 207, 45, 21, 2,myforeground, mybackground);

    windows[NINF].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[NINF].x, windows[NINF].y,
	windows[NINF].width, windows[NINF].height, 2, myforeground, 
	mybackground);

    windows[SNDB].window = XCreateSimpleWindow(mydisplay, windows[NINF].window,
	win_edge[NINF-5]/3-47, 545, 94, 18, 1, myforeground, mybackground);

    windows[STYB].window = XCreateSimpleWindow(mydisplay, windows[NINF].window,
	2*win_edge[NINF-5]/3-47,545, 94, 18, 1, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[NINF].window, "Node Data", 
     "Node Data", None, argv, argc, &windowhints[NINF]);

    windows[CRIT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[CRIT].x, windows[CRIT].y,
	windows[CRIT].width, windows[CRIT].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[CRIT].window, "Critical Path", 
     "Critical Path", None, argv, argc, &windowhints[CRIT]);

    windows[SPTM].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[SPTM].x, windows[SPTM].y,
	windows[SPTM].width, windows[SPTM].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[SPTM].window, "Spacetime Diagram", 
     "Spacetime Diagram", None, argv, argc, &windowhints[SPTM]);

    windows[ANIM].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[ANIM].x, windows[ANIM].y,
	windows[ANIM].width, windows[ANIM].height, 2, myforeground, 
	mybackground);

    windows[ATYB].window = XCreateSimpleWindow(mydisplay, windows[ANIM].window,
	10, 10, 36, 18, 1, myforeground, mybackground);

    windows[MTYB].window = XCreateSimpleWindow(mydisplay, windows[ANIM].window,
	windows[ANIM].width/2-21, 10, 42, 18, 1, myforeground, mybackground);

    windows[ASVB].window = XCreateSimpleWindow(mydisplay, windows[ANIM].window,
	windows[ANIM].width/2-33, 10, 66, 18, 1, myforeground, mybackground);

    windows[MORB].window = XCreateSimpleWindow(mydisplay, windows[ANIM].window,
	windows[ANIM].width-70, 10, 60, 18, 1, myforeground, mybackground);

    windows[ARDB].window = XCreateSimpleWindow(mydisplay, windows[ANIM].window,
	windows[ANIM].width-70, 10, 60, 18, 1, myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[ANIM].window, "Animation", 
     "Animation", None, argv, argc, &windowhints[ANIM]);

    windows[MTRX].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[MTRX].x, windows[MTRX].y,
	windows[MTRX].width, windows[MTRX].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[MTRX].window, 
     "Communication Matrix", "Communication Matrix", None, argv, argc, 
     &windowhints[MTRX]);

    windows[UTLG].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[UTLG].x, windows[UTLG].y,
	windows[UTLG].width, windows[UTLG].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[UTLG].window, 
     "Utilization Gantt Chart", "Utilization Gantt Chart", None, argv, argc, 
     &windowhints[UTLG]);

    windows[TSKG].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TSKG].x, windows[TSKG].y,
	windows[TSKG].width, windows[TSKG].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TSKG].window, "Task Gantt Chart", 
     "Task Gantt Chart", None, argv, argc, &windowhints[TSKG]);

    windows[STRK].window = XCreateSimpleWindow(mydisplay,
        DefaultRootWindow(mydisplay), windows[STRK].x, windows[STRK].y,
        windows[STRK].width, windows[STRK].height, 2,
        myforeground, mybackground);

    XSetStandardProperties(mydisplay, windows[STRK].window, 
	"Utilization Streak", "Utilization Streak", None, argv, argc, 
	&windowhints[STRK]);

    windows[SRKB].window = XCreateSimpleWindow(mydisplay, windows[STRK].window,
        windows[STRK].width/2-81, 2, 120, 16, 1, myforeground, mybackground);

    windows[KIVT].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[KIVT].x, windows[KIVT].y,
	windows[KIVT].width, windows[KIVT].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[KIVT].window, 
     "Utilization Kiviat Diagram", "Utilization Kiviat Diagram", None, 
     argv, argc, &windowhints[KIVT]);

    windows[KVTB].window = XCreateSimpleWindow(mydisplay, windows[KIVT].window,
        10, windows[KIVT].height-26, 78, 16, 1, myforeground, mybackground);

    windows[UTLC].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[UTLC].x, windows[UTLC].y,
	windows[UTLC].width, windows[UTLC].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[UTLC].window, "Utilization Count", 
     "Utilization Count", None, argv, argc, &windowhints[UTLC]);

    windows[TRAF].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TRAF].x, windows[TRAF].y,
	windows[TRAF].width, windows[TRAF].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TRAF].window, 
     "Communication Traffic", "Communication Traffic", None, argv, argc, 
     &windowhints[TRAF]);

    windows[SIZB].window = XCreateSimpleWindow(mydisplay, windows[TRAF].window,
	279, 2, 42, 16, 1, myforeground, mybackground);

    windows[TRNB].window = XCreateSimpleWindow(mydisplay, windows[TRAF].window,
	386, 2, 30, 16, 1, myforeground, mybackground);

    windows[QUEU].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[QUEU].x, windows[QUEU].y,
	windows[QUEU].width, windows[QUEU].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[QUEU].window, "Message Queues", 
     "Message Queues", None, argv, argc, &windowhints[QUEU]);

    windows[MESB].window = XCreateSimpleWindow(mydisplay, windows[QUEU].window,
	windows[QUEU].width/2+21, 2, 48, 16, 1, myforeground, mybackground);

    windows[UTLS].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[UTLS].x, windows[UTLS].y,
	windows[UTLS].width, windows[UTLS].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[UTLS].window, 
     "Utilization Summary", "Utilization Summary", None, argv, argc, 
     &windowhints[UTLS]);

    windows[PROF].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[PROF].x, windows[PROF].y, 
	windows[PROF].width, windows[PROF].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[PROF].window, 
     "Concurrency Profile", "Concurrency Profile", None, argv, argc, 
     &windowhints[PROF]);

    windows[CPFB].window = XCreateSimpleWindow(mydisplay, windows[PROF].window,
        (windows[PROF].width-60)/2 + 75, windows[PROF].height-19, 36, 16, 1,
        myforeground, mybackground);

    windows[STTS].window = XCreateSimpleWindow(mydisplay, 
	DefaultRootWindow(mydisplay), windows[STTS].x, windows[STTS].y, 
	windowhints[STTS].width, windowhints[STTS].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[STTS].window, "Statistics", 
     "Statistics", None, argv, argc, &windowhints[STTS]);

    windows[STAB].window = XCreateSimpleWindow(mydisplay, windows[STTS].window, 
        5, 5, 132, 16, 1, myforeground, mybackground);

    windows[TSKC].window = XCreateSimpleWindow(mydisplay,
	DefaultRootWindow(mydisplay), windows[TSKC].x, windows[TSKC].y,
	windows[TSKC].width, windows[TSKC].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TSKC].window, "Task Count", 
     "Task Count", None, argv, argc, &windowhints[TSKC]);

    windows[TSMY].window = XCreateSimpleWindow(mydisplay,
        DefaultRootWindow(mydisplay), windows[TSMY].x, windows[TSMY].y,
        windows[TSMY].width, windows[TSMY].height, 2, myforeground, 
	mybackground);

    XSetStandardProperties(mydisplay, windows[TSMY].window, "Task Summary", 
     "Task Summary", None, argv, argc, &windowhints[TSMY]);

    /* create cursors and define different cursors for different windows as a
       hint to user which windows take input and what type */

    for (j = ANMB; j <= SINC; j++)
	XDefineCursor(mydisplay, windows[j].window, hand_cursor);
    for (j = ORDB; j <= NTWR; j++)
	XDefineCursor(mydisplay, windows[j].window, toggle_cursor);
    for (j = RSTR; j <= CLOB; j++)
	XDefineCursor(mydisplay, windows[j].window, hand_cursor);
    for (j = ATYB; j <= SRKB; j++)
	XDefineCursor(mydisplay, windows[j].window, toggle_cursor);
    for (j = DIMB; j <= SCLB; j++)
	XDefineCursor(mydisplay, windows[j].window, toggle_cursor);
    XDefineCursor(mydisplay, windows[YESB].window, hand_cursor);
    XDefineCursor(mydisplay, windows[QNOB].window, hand_cursor);
    for (j = PATB; j <= RSTB; j++)
        XDefineCursor(mydisplay, windows[j].window, hand_cursor);

    for (j = ANIM; j <= SCLB; j++){
	XSelectInput(mydisplay, windows[j].window, event_mask);
	}

    XSelectInput(mydisplay, windows[SLID].window, event_mask|ButtonMotionMask);
    XSelectInput(mydisplay, windows[FLBR].window, event_mask|
      PointerMotionHintMask);

    phpt_first_point = 1;
    sprintf(stat_type, "node");
    sprintf(prof_type, "BUSY");
    sprintf(traf_type, "VOLUME");
    sprintf(meter_type, "VOLUME");
    sprintf(queu_type, "LENGTHS");
    sprintf(code_type, "MSG LTHS");
    for (i = 0; i < MAXP; i++){
        kx[i] = k_center_x;
        ky[i] = k_center_y;
	k_init[i] = 0;
        streak_last_top[i]=streak_last_bottom[i]=0;
        cur_streak[i].busy=cur_streak[i].busy_ovhd=cur_streak[i].ovhd_idle=
	cur_streak[i].idle=0;
    }

    /* map (display) menu and buttons/choices */
    XMapWindow(mydisplay, windows[MENU].window);
    XMapSubwindows(mydisplay, windows[MENU].window);
    if(windows[CRIT].opt1) backwards();
    if(windows[ANIM].opt1){
      XMapWindow(mydisplay, windows[ANIM].window);
      XMapWindow(mydisplay, windows[ATYB].window);
      if(windows[ATYB].opt1==1){
        XMapWindow(mydisplay, windows[MORB].window);
        XMapWindow(mydisplay, windows[MTYB].window);
      }
      if(windows[ATYB].opt1==2){
        XMapWindow(mydisplay, windows[ASVB].window);
        XMapWindow(mydisplay, windows[ARDB].window);
      }
    }
    if(windows[NTWK].opt1){
      XMapWindow(mydisplay, windows[NTWK].window);
      XMapWindow(mydisplay, windows[NTYB].window);
      if(windows[NTYB].opt1!=CROSSBAR&&windows[NTYB].opt1!=BINARY_TREE&&
	windows[NTYB].opt1!=QUADTREE){
        XMapWindow(mydisplay, windows[NOPB].window);
        XMapWindow(mydisplay, windows[SHNB].window);
      }
      if(windows[NTYB].opt1==NTWK_MESH){
        XMapWindow(mydisplay, windows[NMSB].window);
        XMapWindow(mydisplay, windows[NMOB].window);
      }
    }
    for(i=HYPE; i<=PHPT; i++)
      if(windows[i].opt1){
	XMapWindow(mydisplay, windows[i].window);
        XMapSubwindows(mydisplay, windows[i].window);
      }
    for(i=TSMY; i<=CLOK; i++)
      if(windows[i].opt1){
	XMapWindow(mydisplay, windows[i].window);
        XMapSubwindows(mydisplay, windows[i].window);
      }
    if(windows[SOPT].opt1){
	XMapWindow(mydisplay, windows[SOPT].window);
        XMapSubwindows(mydisplay, windows[SOPT].window);
	if(windows[DSTB].opt1!=1 && windows[DSTB].opt1!=2){
	  XUnmapWindow(mydisplay, windows[DIMB].window);
	  XUnmapWindow(mydisplay, windows[COLB].window);
	  XResizeWindow(mydisplay, windows[DSTB].window, 266, 21);
	}else XResizeWindow(mydisplay, windows[DSTB].window, 152, 21);
    }
    for(i=ROPT; i<=OMEN; i++)
      if(windows[i].opt1){
	XMapWindow(mydisplay, windows[i].window);
        XMapSubwindows(mydisplay, windows[i].window);
      }

    /* The variable go_flag changes depending on form of action the user
       chooses.  When no animation is being done, start has not been hit or
       pause has been selected - go_flag is equal to 0.  When it is running
       straight through the tracefile (start or resume has been selected),
       go_flag is equal to 1.  When step is being used, go_flag is equal to
       2. When the whole program is quit, go_flag is equal to -1.
       get_event() checks the queue for user input (kbd or mouse) or for window
       manager events.  It also decides what to do with each event.
       get_trace() reads tracefile and calls functions that do the drawing. A
       check for mouse or keyboard input is thus made between each line in
       tracefile */

    while (go_flag != -1) {
	get_event();
	get_trace();
    }
}
