/******************************************************************************
*******************************************************************************

  Hypercube display for ParaGraph
  Author: Loretta S. Auvil, student intern
          at Oak Ridge National Laboratory

*******************************************************************************
******************************************************************************/

#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC gc[];
extern char *number[];
extern int rad, num_nodes, webproc4[], webproc8[], hypenode1, hypenode2, 
	   hype_num_nodes, webproc16[], meshproc[], order[];
XPoint pts[16], ctr[16];
extern XPoint ref;

hype_setup()
{
  int buf, j, row, col;

	switch (windows[HTYB].opt1)
	{
	case RING:
	    if (hype_num_nodes == 4)
 	       for (j=0;j<hype_num_nodes;j++)
	       {
                 pts[j].x = rad*0.75*cos(2*PI/hype_num_nodes*
	          (order[j]-hype_num_nodes/4))+ref.x;
	         pts[j].y = rad*0.75*sin(2*PI/hype_num_nodes*
		  (order[j]-hype_num_nodes/4))+ref.y;
	       }
            else
	       for (j=0;j<hype_num_nodes;j++)
	       {
	         pts[j].x = rad*cos(2*PI/hype_num_nodes*
		   (order[j]-hype_num_nodes/4))+ref.x;
	         pts[j].y = rad*sin(2*PI/hype_num_nodes*
		  (order[j]-hype_num_nodes/4))+ref.y;
	       }
            break;

	case RING_OF_RINGS: 
	    if (hype_num_nodes==4)
	    {
	     pts[0].x = ref.x;      pts[0].y = ref.y-rad*0.75;
	     pts[1].x = ref.x+rad*0.75;  pts[1].y = ref.y;
	     pts[2].x = ref.x-rad*0.75;  pts[2].y = ref.y;
	     pts[3].x = ref.x;      pts[3].y = ref.y+rad*0.75;
	    }
     	    else if (hype_num_nodes==8)
	    {
             pts[0].x = ref.x; pts[0].y = ref.y-rad/2;
	     pts[7].x = ref.x; pts[7].y = ref.y+rad;
	     if(!windows[ORDB].opt1){
               pts[1].x = ref.x; pts[1].y = ref.y-rad;
     	       pts[2].x = ref.x+rad/2; pts[2].y = ref.y;
	       pts[3].x = ref.x+rad; pts[3].y = ref.y;
	       pts[4].x = ref.x-rad/2; pts[4].y = ref.y;
	       pts[5].x = ref.x-rad; pts[5].y = ref.y;
	       pts[6].x = ref.x; pts[6].y = ref.y+rad/2;
	     }else{
     	       pts[1].x = ref.x+rad/2; pts[1].y = ref.y;
	       pts[2].x = ref.x-rad/2; pts[2].y = ref.y;
	       pts[3].x = ref.x; pts[3].y = ref.y+rad/2;
               pts[4].x = ref.x; pts[4].y = ref.y-rad;
	       pts[5].x = ref.x+rad; pts[5].y = ref.y;
	       pts[6].x = ref.x-rad; pts[6].y = ref.y;
	     }
	    }
            else
	    {
              ref.y = ref.y + 5;
	      pts[0].x = ref.x; pts[0].y = ref.y-rad/4;
	      pts[5].x = ref.x+2*rad/4; pts[5].y = ref.y;
	      pts[10].x = ref.x-4*rad/4; pts[10].y = ref.y;
	      pts[15].x = ref.x; pts[15].y = ref.y+3*rad/4;
	      if(!windows[ORDB].opt1){
	        pts[1].x = ref.x; pts[1].y = ref.y-2*rad/4;
                pts[2].x = ref.x; pts[2].y = ref.y-4*rad/4;
	        pts[3].x = ref.x; pts[3].y = ref.y-3*rad/4;
	        pts[4].x = ref.x+rad/4; pts[4].y = ref.y;
      	        pts[6].x = ref.x+4*rad/4; pts[6].y = ref.y;
	        pts[7].x = ref.x+3*rad/4; pts[7].y = ref.y;
	        pts[8].x = ref.x-rad/4; pts[8].y = ref.y;
	        pts[9].x = ref.x-2*rad/4; pts[9].y = ref.y;
	        pts[11].x = ref.x-3*rad/4; pts[11].y = ref.y;
	        pts[12].x = ref.x; pts[12].y = ref.y+rad/4;
      	        pts[13].x = ref.x; pts[13].y = ref.y+2*rad/4;
	        pts[14].x = ref.x; pts[14].y = ref.y+4*rad/4;
	      }else{
	        pts[1].x = ref.x+rad/4; pts[1].y = ref.y;
	        pts[2].x = ref.x-rad/4; pts[2].y = ref.y;
	        pts[3].x = ref.x; pts[3].y = ref.y+rad/4;
	        pts[4].x = ref.x; pts[4].y = ref.y-2*rad/4;
	        pts[6].x = ref.x-2*rad/4; pts[6].y = ref.y;
      	        pts[7].x = ref.x; pts[7].y = ref.y+2*rad/4;
                pts[8].x = ref.x; pts[8].y = ref.y-4*rad/4;
      	        pts[9].x = ref.x+4*rad/4; pts[9].y = ref.y;
	        pts[11].x = ref.x; pts[11].y = ref.y+4*rad/4;
	        pts[12].x = ref.x; pts[12].y = ref.y-3*rad/4;
	        pts[13].x = ref.x+3*rad/4; pts[13].y = ref.y;
	        pts[14].x = ref.x-3*rad/4; pts[14].y = ref.y;
	      }
	      ref.y = ref.y - 5;
	    }
            break;

	case SQUARES: 
	    if (hype_num_nodes==4)
	    {
	     pts[0].x = ref.x-rad/2; pts[0].y = ref.y+rad/2;
	     pts[1].x = ref.x+rad/2; pts[1].y = ref.y+rad/2;
	     pts[2].x = ref.x-rad/2; pts[2].y = ref.y-rad/2;
	     pts[3].x = ref.x+rad/2; pts[3].y = ref.y-rad/2;
	    }
     	    else if (hype_num_nodes==8)
	    {
             pts[0].x = ref.x-rad/3; pts[0].y = ref.y+rad/3;
	     pts[7].x = ref.x+(2*rad)/3; pts[7].y = ref.y-(2*rad)/3;
	     if(!windows[ORDB].opt1){
               pts[1].x = ref.x+rad/3; pts[1].y = ref.y+rad/3;
     	       pts[2].x = ref.x-rad/3; pts[2].y = ref.y-rad/3;
	       pts[3].x = ref.x+rad/3; pts[3].y = ref.y-rad/3;
	       pts[4].x = ref.x-(2*rad)/3; pts[4].y = ref.y+(2*rad)/3;
	       pts[5].x = ref.x+(2*rad)/3; pts[5].y = ref.y+(2*rad)/3;
	       pts[6].x = ref.x-(2*rad)/3; pts[6].y = ref.y-(2*rad)/3;
	     }else{
     	       pts[1].x = ref.x-(2*rad)/3; pts[1].y = ref.y+(2*rad)/3;
	       pts[2].x = ref.x+rad/3; pts[2].y = ref.y+rad/3;
	       pts[3].x = ref.x+(2*rad)/3; pts[3].y = ref.y+(2*rad)/3;
               pts[4].x = ref.x-rad/3; pts[4].y = ref.y-rad/3;
	       pts[5].x = ref.x-(2*rad)/3; pts[5].y = ref.y-(2*rad)/3;
	       pts[6].x = ref.x+rad/3; pts[6].y = ref.y-rad/3;
	     }
	    }
            else
	    {
	      pts[0].x = ref.x-rad/5; pts[0].y = ref.y+rad/5;
	      pts[5].x = ref.x+(2*rad)/5; pts[5].y = ref.y+(2*rad)/5;
	      pts[10].x = ref.x-(4*rad)/5; pts[10].y = ref.y-(4*rad)/5;
	      pts[15].x = ref.x+(3*rad)/5; pts[15].y = ref.y-(3*rad)/5;
	      if(!windows[ORDB].opt1){
	        pts[1].x = ref.x+rad/5; pts[1].y = ref.y+rad/5;
                pts[2].x = ref.x-rad/5; pts[2].y = ref.y-rad/5;
	        pts[3].x = ref.x+rad/5; pts[3].y = ref.y-rad/5;
	        pts[4].x = ref.x-(2*rad)/5; pts[4].y = ref.y+(2*rad)/5;
      	        pts[6].x = ref.x-(2*rad)/5; pts[6].y = ref.y-(2*rad)/5;
	        pts[7].x = ref.x+(2*rad)/5; pts[7].y = ref.y-(2*rad)/5;
	        pts[8].x = ref.x-(4*rad)/5; pts[8].y = ref.y+(4*rad)/5;
	        pts[9].x = ref.x+(4*rad)/5; pts[9].y = ref.y+(4*rad)/5;
	        pts[11].x = ref.x+(4*rad)/5; pts[11].y = ref.y-(4*rad)/5;
	        pts[12].x = ref.x-(3*rad)/5; pts[12].y = ref.y+(3*rad)/5;
      	        pts[13].x = ref.x+(3*rad)/5; pts[13].y = ref.y+(3*rad)/5;
	        pts[14].x = ref.x-(3*rad)/5; pts[14].y = ref.y-(3*rad)/5;
	      }else{
	        pts[1].x = ref.x-(2*rad)/5; pts[1].y = ref.y+(2*rad)/5;
	        pts[2].x = ref.x-(4*rad)/5; pts[2].y = ref.y+(4*rad)/5;
	        pts[3].x = ref.x-(3*rad)/5; pts[3].y = ref.y+(3*rad)/5;
	        pts[4].x = ref.x+rad/5; pts[4].y = ref.y+rad/5;
	        pts[6].x = ref.x+(4*rad)/5; pts[6].y = ref.y+(4*rad)/5;
      	        pts[7].x = ref.x+(3*rad)/5; pts[7].y = ref.y+(3*rad)/5;
                pts[8].x = ref.x-rad/5; pts[8].y = ref.y-rad/5;
      	        pts[9].x = ref.x-(2*rad)/5; pts[9].y = ref.y-(2*rad)/5;
	        pts[11].x = ref.x-(3*rad)/5; pts[11].y = ref.y-(3*rad)/5;
	        pts[12].x = ref.x+rad/5; pts[12].y = ref.y-rad/5;
	        pts[13].x = ref.x+(2*rad)/5; pts[13].y = ref.y-(2*rad)/5;
	        pts[14].x = ref.x+(4*rad)/5; pts[14].y = ref.y-(4*rad)/5;
	      }
	    }
            break;

	case ORBITS: 
	    if (hype_num_nodes==4)
	    {
	     pts[0].x = ref.x-rad/4; pts[0].y = ref.y+rad/2;
	     pts[1].x = ref.x-rad/2; pts[1].y = ref.y+rad/4;
	     pts[2].x = ref.x+rad/2; pts[2].y = ref.y-rad/4;
	     pts[3].x = ref.x+rad/4; pts[3].y = ref.y-rad/2;
	    }
     	    else if (hype_num_nodes==8)
	    {
	     if(!windows[ORDB].opt1){
               pts[0].x = ref.x-rad/3; pts[0].y = ref.y+(2*rad)/3;
               pts[1].x = ref.x-(2*rad)/3; pts[1].y = ref.y+rad/3;
     	       pts[2].x = ref.x+(2*rad)/3; pts[2].y = ref.y-rad/3;
	       pts[3].x = ref.x+rad/3; pts[3].y = ref.y-(2*rad)/3;
	       pts[4].x = ref.x+rad/3; pts[4].y = ref.y+(2*rad)/3;
	       pts[5].x = ref.x-(2*rad)/3; pts[5].y = ref.y-rad/3;
	       pts[6].x = ref.x+(2*rad)/3; pts[6].y = ref.y+rad/3;
	       pts[7].x = ref.x-rad/3; pts[7].y = ref.y-(2*rad)/3;
	     }else{
               pts[0].x = ref.x+rad/3; pts[0].y = ref.y+(2*rad)/3;
     	       pts[1].x = ref.x-rad/3; pts[1].y = ref.y+(2*rad)/3;
	       pts[2].x = ref.x-(2*rad)/3; pts[2].y = ref.y-rad/3;
	       pts[3].x = ref.x-(2*rad)/3; pts[3].y = ref.y+rad/3;
               pts[4].x = ref.x+(2*rad)/3; pts[4].y = ref.y+rad/3;
	       pts[5].x = ref.x+(2*rad)/3; pts[5].y = ref.y-rad/3;
	       pts[6].x = ref.x-rad/3; pts[6].y = ref.y-(2*rad)/3;
	       pts[7].x = ref.x+rad/3; pts[7].y = ref.y-(2*rad)/3;
	     }
	    }
            else
	    {
	      pts[5].x = ref.x-(2*rad)/3; pts[5].y = ref.y+rad/3;
	      pts[10].x = ref.x+(2*rad)/3; pts[10].y = ref.y+rad/3;
	      if(!windows[ORDB].opt1){
	        pts[0].x = ref.x; pts[0].y = ref.y+rad;
	        pts[1].x = ref.x-rad/3; pts[1].y = ref.y+(2*rad)/3;
                pts[2].x = ref.x+rad/3; pts[2].y = ref.y+(2*rad)/3;
	        pts[3].x = ref.x; pts[3].y = ref.y+rad/3;
	        pts[4].x = ref.x-rad; pts[4].y = ref.y;
      	        pts[6].x = ref.x-(2*rad)/3; pts[6].y = ref.y-rad/3;
	        pts[7].x = ref.x-rad/3; pts[7].y = ref.y;
	        pts[8].x = ref.x+rad; pts[8].y = ref.y;
	        pts[9].x = ref.x+(2*rad)/3; pts[9].y = ref.y-rad/3;
	        pts[11].x = ref.x+rad/3; pts[11].y = ref.y;
	        pts[12].x = ref.x; pts[12].y = ref.y-rad;
      	        pts[13].x = ref.x+rad/3; pts[13].y = ref.y-(2*rad)/3;
	        pts[14].x = ref.x-rad/3; pts[14].y = ref.y-(2*rad)/3;
	        pts[15].x = ref.x; pts[15].y = ref.y-rad/3;
	      }else{
	        pts[0].x = ref.x; pts[0].y = ref.y+rad/3;
	        pts[1].x = ref.x-rad/3; pts[1].y = ref.y;
	        pts[2].x = ref.x+rad/3; pts[2].y = ref.y;
	        pts[3].x = ref.x; pts[3].y = ref.y-rad/3;
	        pts[4].x = ref.x-rad/3; pts[4].y = ref.y+(2*rad)/3;
	        pts[6].x = ref.x+(2*rad)/3; pts[6].y = ref.y-rad/3;
      	        pts[7].x = ref.x+rad/3; pts[7].y = ref.y-(2*rad)/3;
                pts[8].x = ref.x+rad/3; pts[8].y = ref.y+(2*rad)/3;
      	        pts[9].x = ref.x-(2*rad)/3; pts[9].y = ref.y-rad/3;
	        pts[11].x = ref.x-rad/3; pts[11].y = ref.y-(2*rad)/3;
	        pts[12].x = ref.x; pts[12].y = ref.y+rad;
	        pts[13].x = ref.x-rad; pts[13].y = ref.y;
	        pts[14].x = ref.x+rad; pts[14].y = ref.y;
	        pts[15].x = ref.x; pts[15].y = ref.y-rad;
	      }
	    }
            break;

	case WEB: 
            if (hype_num_nodes==4){
              for (j=0; j<hype_num_nodes; j++)
              {
                pts[j].x=rad*0.75*cos(PI/hype_num_nodes+2*PI/hype_num_nodes*
                   (webproc4[j]-hype_num_nodes/4-1))+ref.x;
                pts[j].y=rad*0.75*sin(PI/hype_num_nodes+2*PI/hype_num_nodes*
                   (webproc4[j]-hype_num_nodes/4-1))+ref.y;
              }
              }else if (hype_num_nodes==8){
	       if(windows[ORDB].opt1==0){
		 webproc8[0]=0; webproc8[1]=1; webproc8[2]=5; webproc8[3]=4;
		 webproc8[4]=7; webproc8[5]=2; webproc8[6]=6; webproc8[7]=3;
	       }else{
		 webproc8[0]=0; webproc8[1]=5; webproc8[2]=1; webproc8[3]=4;
		 webproc8[4]=7; webproc8[5]=6; webproc8[6]=2; webproc8[7]=3;
	       }
                for (j=0; j<hype_num_nodes; j++)
                {
                  pts[j].x = rad*cos(PI/hype_num_nodes+2*PI/hype_num_nodes*
                     (webproc8[j]-hype_num_nodes/4-1))+ref.x;
	          pts[j].y = rad*sin(PI/hype_num_nodes+2*PI/hype_num_nodes*
		     (webproc8[j]-hype_num_nodes/4-1))+ref.y;
                }
              }else{
	       if(windows[ORDB].opt1==0){
		 webproc16[0]=0; webproc16[1]=1; webproc16[2]=9; webproc16[3]=8;
		 webproc16[4]=13; webproc16[5]=4; webproc16[6]=12; 
		 webproc16[7]=5; webproc16[8]=15; webproc16[9]=2; 
		 webproc16[10]=10; webproc16[11]=7; webproc16[12]=14; 
		 webproc16[13]=3; webproc16[14]=11; webproc16[15]=6;
	       }else{
		 webproc16[0]=0; webproc16[1]=9; webproc16[2]=1; webproc16[3]=8;
		 webproc16[4]=15; webproc16[5]=10; webproc16[6]=2; 
		 webproc16[7]=7; webproc16[8]=13; webproc16[9]=12; 
		 webproc16[10]=4; webproc16[11]=5; webproc16[12]=14; 
		 webproc16[13]=11; webproc16[14]=3; webproc16[15]=6;
	       }
                for (j=0; j<hype_num_nodes; j++)
                {
                  pts[j].x = rad*cos(PI/hype_num_nodes+2*PI/hype_num_nodes*
	             (webproc16[j]-hype_num_nodes/4-1))+ref.x;
	          pts[j].y = rad*sin(PI/hype_num_nodes+2*PI/hype_num_nodes*
	             (webproc16[j]-hype_num_nodes/4-1))+ref.y;
                }
	      }
              break;

	case CUBE:
              if (hype_num_nodes==4)
	      {
	       pts[0].x = ref.x-rad/2; pts[0].y = ref.y+rad/2;
	       pts[1].x = ref.x+rad/2; pts[1].y = ref.y+rad/2;
	       pts[2].x = ref.x-rad/2; pts[2].y = ref.y-rad/2;
	       pts[3].x = ref.x+rad/2; pts[3].y = ref.y-rad/2;
	      }
              else if (hype_num_nodes==8)
	      {
	       pts[0].x = ref.x-rad+0.05*2*rad;
	       pts[0].y = ref.y-rad+0.95*2*rad;
	       pts[7].x = ref.x-rad+0.95*2*rad;
	       pts[7].y = ref.y-rad+0.1*2*rad;
	       if(windows[ORDB].opt1==0){
	       pts[1].x = ref.x-rad+0.65*2*rad;
	       pts[1].y = ref.y-rad+0.95*2*rad;
	       pts[2].x = ref.x-rad+0.05*2*rad;
	       pts[2].y = ref.y-rad+0.35*2*rad;
	       pts[3].x = ref.x-rad+0.65*2*rad;
	       pts[3].y = ref.y-rad+0.35*2*rad;
	       pts[4].x = ref.x-rad+0.35*2*rad;
	       pts[4].y = ref.y-rad+0.7*2*rad;
	       pts[5].x = ref.x-rad+0.95*2*rad;
	       pts[5].y = ref.y-rad+0.7*2*rad;
	       pts[6].x = ref.x-rad+0.35*2*rad;
	       pts[6].y = ref.y-rad+0.1*2*rad;
	       }else{
	         pts[1].x = ref.x-rad+0.35*2*rad;
	         pts[1].y = ref.y-rad+0.7*2*rad;
	         pts[2].x = ref.x-rad+0.65*2*rad;
	         pts[2].y = ref.y-rad+0.95*2*rad;
	         pts[3].x = ref.x-rad+0.95*2*rad;
	         pts[3].y = ref.y-rad+0.7*2*rad;
	         pts[4].x = ref.x-rad+0.05*2*rad;
	         pts[4].y = ref.y-rad+0.35*2*rad;
	         pts[5].x = ref.x-rad+0.35*2*rad;
	         pts[5].y = ref.y-rad+0.1*2*rad;
	         pts[6].x = ref.x-rad+0.65*2*rad;
	         pts[6].y = ref.y-rad+0.35*2*rad;
	       }
	      }
              else
	      {
               pts[0].x = ref.x-rad+0.17*2*rad;
               pts[0].y = ref.y-rad+0.73*2*rad;
	       pts[4].x = ref.x-rad+0.37*2*rad;
	       pts[4].y = ref.y-rad+0.65*2*rad;
	       pts[11].x = ref.x-rad+0.751*2*rad;
	       pts[11].y = ref.y-rad+0.19*2*rad;
       	       pts[15].x = ref.x-rad+0.999*2*rad;
	       pts[15].y = ref.y-rad+0.08*2*rad;
	       if(windows[ORDB].opt1==0){
	         pts[1].x = ref.x-rad+0.45*2*rad;
	         pts[1].y = ref.y-rad+0.73*2*rad;
	         pts[2].x = ref.x-rad+0.17*2*rad;
	         pts[2].y = ref.y-rad+0.45*2*rad;
	         pts[3].x = ref.x-rad+0.45*2*rad;
       	         pts[3].y = ref.y-rad+0.45*2*rad;
	         pts[5].x = ref.x-rad+0.65*2*rad;
	         pts[5].y = ref.y-rad+0.65*2*rad;
	         pts[6].x = ref.x-rad+0.37*2*rad;
	         pts[6].y = ref.y-rad+0.37*2*rad;
	         pts[7].x = ref.x-rad+0.65*2*rad;
	         pts[7].y = ref.y-rad+0.37*2*rad;
	         pts[8].x = ref.x-rad+0.001*2*rad;
                 pts[8].y = ref.y-rad+0.94*2*rad;
	         pts[9].x = ref.x-rad+0.751*2*rad;
                 pts[9].y = ref.y-rad+0.94*2*rad;
	         pts[10].x = ref.x-rad+0.001*2*rad;
	         pts[10].y = ref.y-rad+0.19*2*rad;
	         pts[12].x = ref.x-rad+0.249*2*rad;
	         pts[12].y = ref.y-rad+0.83*2*rad;
	         pts[13].x = ref.x-rad+0.999*2*rad;
	         pts[13].y = ref.y-rad+0.83*2*rad;
                 pts[14].x = ref.x-rad+0.249*2*rad;
	         pts[14].y = ref.y-rad+0.08*2*rad;
	       }else{
	         pts[1].x = ref.x-rad+0.001*2*rad;
                 pts[1].y = ref.y-rad+0.94*2*rad;
	         pts[2].x = ref.x-rad+0.45*2*rad;
	         pts[2].y = ref.y-rad+0.73*2*rad;
	         pts[3].x = ref.x-rad+0.751*2*rad;
                 pts[3].y = ref.y-rad+0.94*2*rad;
	         pts[5].x = ref.x-rad+0.249*2*rad;
	         pts[5].y = ref.y-rad+0.83*2*rad;
	         pts[6].x = ref.x-rad+0.65*2*rad;
	         pts[6].y = ref.y-rad+0.65*2*rad;
	         pts[7].x = ref.x-rad+0.999*2*rad;
	         pts[7].y = ref.y-rad+0.83*2*rad;
	         pts[8].x = ref.x-rad+0.17*2*rad;
	         pts[8].y = ref.y-rad+0.45*2*rad;
	         pts[9].x = ref.x-rad+0.001*2*rad;
	         pts[9].y = ref.y-rad+0.19*2*rad;
	         pts[10].x = ref.x-rad+0.45*2*rad;
       	         pts[10].y = ref.y-rad+0.45*2*rad;
	         pts[12].x = ref.x-rad+0.37*2*rad;
	         pts[12].y = ref.y-rad+0.37*2*rad;
                 pts[13].x = ref.x-rad+0.249*2*rad;
	         pts[13].y = ref.y-rad+0.08*2*rad;
	         pts[14].x = ref.x-rad+0.65*2*rad;
	         pts[14].y = ref.y-rad+0.37*2*rad;
	       }
	      }
	      break;

	case LATERAL_CUBES:
	      if (hype_num_nodes==4)
	      {
	        pts[0].x = ref.x-rad/2;
	        pts[0].y = ref.y+rad/2;
	        pts[1].x = ref.x+rad/2;
	        pts[1].y = ref.y+rad/2;
	        pts[2].x = ref.x-rad/2;
	        pts[2].y = ref.y-rad/2;
	        pts[3].x = ref.x+rad/2;
	        pts[3].y = ref.y-rad/2;
	      }
	      else if (hype_num_nodes==8)
	      {
	        pts[0].x = ref.x-rad+0.01*2*rad;
	        pts[0].y = ref.y-rad+0.7*2*rad;
	        pts[7].x = ref.x-rad+0.99*2*rad;
	        pts[7].y = ref.y-rad+0.4*2*rad;
		if(windows[ORDB].opt1==0){
	          pts[1].x = ref.x-rad+0.31*2*rad;
	          pts[1].y = ref.y-rad+0.7*2*rad;
	          pts[2].x = ref.x-rad+0.01*2*rad;
	          pts[2].y = ref.y-rad+0.4*2*rad;
	          pts[3].x = ref.x-rad+0.31*2*rad;
	          pts[3].y = ref.y-rad+0.4*2*rad;
	          pts[4].x = ref.x-rad+0.69*2*rad;
	          pts[4].y = ref.y-rad+0.7*2*rad;
	          pts[5].x = ref.x-rad+0.99*2*rad;
	          pts[5].y = ref.y-rad+0.7*2*rad;
	          pts[6].x = ref.x-rad+0.69*2*rad;
	          pts[6].y = ref.y-rad+0.4*2*rad;
		}else{
	          pts[1].x = ref.x-rad+0.69*2*rad;
	          pts[1].y = ref.y-rad+0.7*2*rad;
	          pts[2].x = ref.x-rad+0.31*2*rad;
	          pts[2].y = ref.y-rad+0.7*2*rad;
	          pts[3].x = ref.x-rad+0.99*2*rad;
	          pts[3].y = ref.y-rad+0.7*2*rad;
	          pts[4].x = ref.x-rad+0.01*2*rad;
	          pts[4].y = ref.y-rad+0.4*2*rad;
	          pts[5].x = ref.x-rad+0.69*2*rad;
	          pts[5].y = ref.y-rad+0.4*2*rad;
	          pts[6].x = ref.x-rad+0.31*2*rad;
	          pts[6].y = ref.y-rad+0.4*2*rad;
		}
	      }
	      else
	      {
                pts[0].x = ref.x-rad+0.005*2*rad;
                pts[0].y = ref.y-rad+0.73*2*rad;
	        pts[15].x = ref.x-rad+0.995*2*rad;
	        pts[15].y = ref.y-rad+0.35*2*rad;
		if(windows[ORDB].opt1==0){
	          pts[1].x = ref.x-rad+0.265*2*rad;
	          pts[1].y = ref.y-rad+0.73*2*rad;
	          pts[2].x = ref.x-rad+0.005*2*rad;
	          pts[2].y = ref.y-rad+0.47*2*rad;
	          pts[3].x = ref.x-rad+0.265*2*rad;
                  pts[3].y = ref.y-rad+0.47*2*rad;
	          pts[4].x = ref.x-rad+0.125*2*rad;
	          pts[4].y = ref.y-rad+0.61*2*rad;
	          pts[5].x = ref.x-rad+0.385*2*rad;
	          pts[5].y = ref.y-rad+0.61*2*rad;
	          pts[6].x = ref.x-rad+0.125*2*rad;
	          pts[6].y = ref.y-rad+0.35*2*rad;
	          pts[7].x = ref.x-rad+0.385*2*rad;
	          pts[7].y = ref.y-rad+0.35*2*rad;
                  pts[8].x = ref.x-rad+0.615*2*rad;
	          pts[8].y = ref.y-rad+0.73*2*rad;
	          pts[9].x = ref.x-rad+0.875*2*rad;
	          pts[9].y = ref.y-rad+0.73*2*rad;
	          pts[10].x = ref.x-rad+0.615*2*rad;
	          pts[10].y = ref.y-rad+0.47*2*rad;
        	  pts[11].x = ref.x-rad+0.875*2*rad;
	          pts[11].y = ref.y-rad+0.47*2*rad;
	          pts[12].x = ref.x-rad+0.735*2*rad;
	          pts[12].y = ref.y-rad+0.61*2*rad;
	          pts[13].x = ref.x-rad+0.995*2*rad;
	          pts[13].y = ref.y-rad+0.61*2*rad;
	          pts[14].x = ref.x-rad+0.735*2*rad;
	          pts[14].y = ref.y-rad+0.35*2*rad;
		}else{
                  pts[1].x = ref.x-rad+0.615*2*rad;
	          pts[1].y = ref.y-rad+0.73*2*rad;
	          pts[2].x = ref.x-rad+0.265*2*rad;
	          pts[2].y = ref.y-rad+0.73*2*rad;
	          pts[3].x = ref.x-rad+0.875*2*rad;
	          pts[3].y = ref.y-rad+0.73*2*rad;
	          pts[4].x = ref.x-rad+0.005*2*rad;
	          pts[4].y = ref.y-rad+0.47*2*rad;
	          pts[5].x = ref.x-rad+0.615*2*rad;
	          pts[5].y = ref.y-rad+0.47*2*rad;
	          pts[6].x = ref.x-rad+0.265*2*rad;
                  pts[6].y = ref.y-rad+0.47*2*rad;
        	  pts[7].x = ref.x-rad+0.875*2*rad;
	          pts[7].y = ref.y-rad+0.47*2*rad;
	          pts[8].x = ref.x-rad+0.125*2*rad;
	          pts[8].y = ref.y-rad+0.61*2*rad;
	          pts[9].x = ref.x-rad+0.735*2*rad;
	          pts[9].y = ref.y-rad+0.61*2*rad;
	          pts[10].x = ref.x-rad+0.385*2*rad;
	          pts[10].y = ref.y-rad+0.61*2*rad;
	          pts[11].x = ref.x-rad+0.995*2*rad;
	          pts[11].y = ref.y-rad+0.61*2*rad;
	          pts[12].x = ref.x-rad+0.125*2*rad;
	          pts[12].y = ref.y-rad+0.35*2*rad;
	          pts[13].x = ref.x-rad+0.735*2*rad;
	          pts[13].y = ref.y-rad+0.35*2*rad;
	          pts[14].x = ref.x-rad+0.385*2*rad;
	          pts[14].y = ref.y-rad+0.35*2*rad;
		}
	      }
	      break;

	case NESTED_CUBES:
	      if (hype_num_nodes ==4)
	      {
                pts[0].x = ref.x-rad/2;
		pts[0].y = ref.y+rad/2;
		pts[1].x = ref.x+rad/2;
		pts[1].y = ref.y+rad/2;
        	pts[2].x = ref.x-rad/2;
        	pts[2].y = ref.y-rad/2;
                pts[3].x = ref.x+rad/2;
	        pts[3].y = ref.y-rad/2;

	      }
	      else if (hype_num_nodes==8)
	      {
                pts[0].x = ref.x-rad+0.4*2*rad;
	        pts[0].y = ref.y-rad+0.6*2*rad;
        	pts[2].x = ref.x-rad+0.4*2*rad;
        	pts[2].y = ref.y-rad+0.4*2*rad;
        	pts[5].x = ref.x-rad+0.8*2*rad;
        	pts[5].y = ref.y-rad+0.8*2*rad;
        	pts[7].x = ref.x-rad+0.8*2*rad;
        	pts[7].y = ref.y-rad+0.2*2*rad;
		if(windows[ORDB].opt1==0){
        	  pts[1].x = ref.x-rad+0.6*2*rad;
        	  pts[1].y = ref.y-rad+0.6*2*rad;
        	  pts[3].x = ref.x-rad+0.6*2*rad;
        	  pts[3].y = ref.y-rad+0.4*2*rad;
        	  pts[4].x = ref.x-rad+0.2*2*rad;
        	  pts[4].y = ref.y-rad+0.8*2*rad;
        	  pts[6].x = ref.x-rad+0.2*2*rad;
        	  pts[6].y = ref.y-rad+0.2*2*rad;
		}else{
        	  pts[1].x = ref.x-rad+0.2*2*rad;
        	  pts[1].y = ref.y-rad+0.8*2*rad;
        	  pts[3].x = ref.x-rad+0.2*2*rad;
        	  pts[3].y = ref.y-rad+0.2*2*rad;
        	  pts[4].x = ref.x-rad+0.6*2*rad;
        	  pts[4].y = ref.y-rad+0.6*2*rad;
        	  pts[6].x = ref.x-rad+0.6*2*rad;
        	  pts[6].y = ref.y-rad+0.4*2*rad;
		}
	      }
	      else
	      {
                ref.y = ref.y + 10;
		pts[0].x = ref.x-rad+0.4*2*rad;
		pts[0].y = ref.y-rad+0.6*2*rad;
		pts[6].x = ref.x-rad+0.15*2*rad;
		pts[6].y = ref.y-rad+0.3*2*rad;
		pts[9].x = ref.x-rad+0.7*2*rad;
		pts[9].y = ref.y-rad+0.85*2*rad;
		pts[15].x = ref.x-rad+0.95*2*rad;
		pts[15].y = ref.y-rad+0.05*2*rad;
		if(windows[ORDB].opt1==0){
		  pts[1].x = ref.x-rad+0.6*2*rad;
		  pts[1].y = ref.y-rad+0.6*2*rad;
		  pts[2].x = ref.x-rad+0.4*2*rad;
		  pts[2].y = ref.y-rad+0.4*2*rad;
		  pts[3].x = ref.x-rad+0.6*2*rad;
		  pts[3].y = ref.y-rad+0.4*2*rad;
		  pts[4].x = ref.x-rad+0.15*2*rad;
		  pts[4].y = ref.y-rad+0.7*2*rad;
		  pts[5].x = ref.x-rad+0.85*2*rad;
		  pts[5].y = ref.y-rad+0.7*2*rad;
		  pts[7].x = ref.x-rad+0.85*2*rad;
		  pts[7].y = ref.y-rad+0.3*2*rad;
        	  pts[8].x = ref.x-rad+0.3*2*rad;
		  pts[8].y = ref.y-rad+0.85*2*rad;
		  pts[10].x = ref.x-rad+0.3*2*rad;
		  pts[10].y = ref.y-rad+0.15*2*rad;
		  pts[11].x = ref.x-rad+0.7*2*rad;
		  pts[11].y = ref.y-rad+0.15*2*rad;
		  pts[12].x = ref.x-rad+0.05*2*rad;
		  pts[12].y = ref.y-rad+0.95*2*rad;
		  pts[13].x = ref.x-rad+0.95*2*rad;
		  pts[13].y = ref.y-rad+0.95*2*rad;
		  pts[14].x = ref.x-rad+0.05*2*rad;
		  pts[14].y = ref.y-rad+0.05*2*rad;
		}else{
        	  pts[1].x = ref.x-rad+0.3*2*rad;
		  pts[1].y = ref.y-rad+0.85*2*rad;
		  pts[2].x = ref.x-rad+0.15*2*rad;
		  pts[2].y = ref.y-rad+0.7*2*rad;
		  pts[3].x = ref.x-rad+0.05*2*rad;
		  pts[3].y = ref.y-rad+0.95*2*rad;
		  pts[4].x = ref.x-rad+0.4*2*rad;
		  pts[4].y = ref.y-rad+0.4*2*rad;
		  pts[5].x = ref.x-rad+0.3*2*rad;
		  pts[5].y = ref.y-rad+0.15*2*rad;
		  pts[7].x = ref.x-rad+0.05*2*rad;
		  pts[7].y = ref.y-rad+0.05*2*rad;
		  pts[8].x = ref.x-rad+0.6*2*rad;
		  pts[8].y = ref.y-rad+0.6*2*rad;
		  pts[10].x = ref.x-rad+0.85*2*rad;
		  pts[10].y = ref.y-rad+0.7*2*rad;
		  pts[11].x = ref.x-rad+0.95*2*rad;
		  pts[11].y = ref.y-rad+0.95*2*rad;
		  pts[12].x = ref.x-rad+0.6*2*rad;
		  pts[12].y = ref.y-rad+0.4*2*rad;
		  pts[13].x = ref.x-rad+0.7*2*rad;
		  pts[13].y = ref.y-rad+0.15*2*rad;
		  pts[14].x = ref.x-rad+0.85*2*rad;
		  pts[14].y = ref.y-rad+0.3*2*rad;
		}
		ref.y = ref.y - 10;
	      }
	      break;

	case MESH:
	      if (hype_num_nodes ==4)
	      {
               pts[0].x = ref.x-rad/2; pts[0].y = ref.y+rad/2;
	       pts[1].x = ref.x+rad/2; pts[1].y = ref.y+rad/2;
	       pts[2].x = ref.x-rad/2; pts[2].y = ref.y-rad/2;
	       pts[3].x = ref.x+rad/2; pts[3].y = ref.y-rad/2;
	      }
	      else if (hype_num_nodes==8)
	       if(windows[ORDB].opt1==0){
                 for (row = 0; row < 2; row++)
	          for (col = 0; col < 4; col++)
		  {
		  pts[meshproc[row*4+col]].x=(col+1)*2*rad/5+ref.x-rad;
		  pts[meshproc[row*4+col]].y=(row+2)*2*rad/5+ref.y-rad;
		  }
		}else{
	          pts[0].x=2*rad/5+ref.x-rad;
	          pts[0].y=4*rad/5+ref.y-rad;
	          pts[1].x=4*rad/5+ref.x-rad;
	          pts[1].y=4*rad/5+ref.y-rad;
	          pts[2].x=2*rad/5+ref.x-rad;
	          pts[2].y=6*rad/5+ref.y-rad;
	          pts[3].x=4*rad/5+ref.x-rad;
	          pts[3].y=6*rad/5+ref.y-rad;
	          pts[4].x=8*rad/5+ref.x-rad;
	          pts[4].y=4*rad/5+ref.y-rad;
	          pts[5].x=6*rad/5+ref.x-rad;
	          pts[5].y=4*rad/5+ref.y-rad;
	          pts[6].x=8*rad/5+ref.x-rad;
	          pts[6].y=6*rad/5+ref.y-rad;
	          pts[7].x=6*rad/5+ref.x-rad;
	          pts[7].y=6*rad/5+ref.y-rad;
		}
	      else
	       if(windows[ORDB].opt1==0){
	         for (row = 0; row < 4; row++)
	          for (col = 0; col < 4; col++)
		  {
	          pts[meshproc[row*4+col]].x=(col+1)*2*rad/5+ref.x-rad;
	          pts[meshproc[row*4+col]].y=(row+1)*2*rad/5+ref.y-rad;
	          }
		}else{
	          pts[0].x=2*rad/5+ref.x-rad;
	          pts[0].y=2*rad/5+ref.y-rad;
	          pts[1].x=4*rad/5+ref.x-rad;
	          pts[1].y=2*rad/5+ref.y-rad;
	          pts[2].x=2*rad/5+ref.x-rad;
	          pts[2].y=4*rad/5+ref.y-rad;
	          pts[3].x=4*rad/5+ref.x-rad;
	          pts[3].y=4*rad/5+ref.y-rad;
	          pts[4].x=8*rad/5+ref.x-rad;
	          pts[4].y=2*rad/5+ref.y-rad;
	          pts[5].x=6*rad/5+ref.x-rad;
	          pts[5].y=2*rad/5+ref.y-rad;
	          pts[6].x=8*rad/5+ref.x-rad;
	          pts[6].y=4*rad/5+ref.y-rad;
	          pts[7].x=6*rad/5+ref.x-rad;
	          pts[7].y=4*rad/5+ref.y-rad;
	          pts[8].x=2*rad/5+ref.x-rad;
	          pts[8].y=8*rad/5+ref.y-rad;
	          pts[9].x=4*rad/5+ref.x-rad;
	          pts[9].y=8*rad/5+ref.y-rad;
	          pts[10].x=2*rad/5+ref.x-rad;
	          pts[10].y=6*rad/5+ref.y-rad;
	          pts[11].x=4*rad/5+ref.x-rad;
	          pts[11].y=6*rad/5+ref.y-rad;
	          pts[12].x=8*rad/5+ref.x-rad;
	          pts[12].y=8*rad/5+ref.y-rad;
	          pts[13].x=6*rad/5+ref.x-rad;
	          pts[13].y=8*rad/5+ref.y-rad;
	          pts[14].x=8*rad/5+ref.x-rad;
	          pts[14].y=6*rad/5+ref.y-rad;
	          pts[15].x=6*rad/5+ref.x-rad;
	          pts[15].y=6*rad/5+ref.y-rad;
		}
	      break;

	case LINEAR:
	      if ((hype_num_nodes ==4)||(hype_num_nodes==8))
               for (j=0;j<hype_num_nodes;j++)
	       {
	        pts[j].x=2*(ref.x+10)/(hype_num_nodes+1)*
			    (order[j]+1)-10;
	        pts[j].y=ref.y+rad*0.2;
	       }
	      else
	      {
	        for (j=0; j<8; j++)
	        {
		  pts[j].x = 2*(ref.x+10)/9*(order[j]+1)-10;
		  pts[j].y = ref.y-rad*0.2;
		}
		if (windows[ORDB].opt1 == 0) /**sets node to the natural order**/
		   for (j=8; j<16; j++)
		   {
		     pts[j].x = 2*(ref.x+10)/9*(j-7)-10;
		     pts[j].y = ref.y+rad*0.2;
		   }
		else  /**sets node to the gray order**/
		   for (j=8; j<16; j++)
		   {
		     pts[j].x = 2*(ref.x+10)/9*(16-order[j])-10;
	  	     pts[j].y = ref.y+rad*0.2;
		   }
	      }
	      break;
       
	case CROSSHATCH:
	      if(hype_num_nodes==4){
	        if(ref.x<ref.y) buf=(2*ref.x)/3;
	        else buf=(2*ref.y)/3;
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf;
	         pts[1].y = ref.y+buf;
		if(!windows[ORDB].opt1){
	         pts[2].x = ref.x+buf;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x-buf;
	         pts[3].y = ref.y-buf;
		}else{
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+buf;
	         pts[3].y = ref.y-buf;
		}
	      }else if(hype_num_nodes==8){
	        if(ref.x<ref.y) buf=(3*ref.x)/4;
	        else buf=(3*ref.y)/4;
	         pts[0].x = ref.x-buf/3;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf/3;
	         pts[1].y = ref.y+buf;
	         pts[2].x = ref.x-buf/3;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+buf/3;
	         pts[3].y = ref.y-buf;
		if(!windows[ORDB].opt1){
	         pts[4].x = ref.x+buf;
	         pts[4].y = ref.y-buf/3;
	         pts[5].x = ref.x-buf;
	         pts[5].y = ref.y-buf/3;
	         pts[6].x = ref.x+buf;
	         pts[6].y = ref.y+buf/3;
	         pts[7].x = ref.x-buf;
	         pts[7].y = ref.y+buf/3;
		}else{
	         pts[4].x = ref.x-buf;
	         pts[4].y = ref.y+buf/3;
	         pts[5].x = ref.x+buf;
	         pts[5].y = ref.y+buf/3;
	         pts[6].x = ref.x-buf;
	         pts[6].y = ref.y-buf/3;
	         pts[7].x = ref.x+buf;
	         pts[7].y = ref.y-buf/3;
		}
	      }else{
	        if(ref.x<ref.y) buf=(5*ref.x)/6;
	        else buf=(5*ref.y)/6;
	         pts[0].x = ref.x-buf/5;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf/5;
	         pts[1].y = ref.y+buf;
	         pts[2].x = ref.x-buf/5;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+buf/5;
	         pts[3].y = ref.y-buf;
	         pts[4].x = ref.x-(3*buf)/5;
	         pts[4].y = ref.y+buf;
	         pts[5].x = ref.x+(3*buf)/5;
	         pts[5].y = ref.y+buf;
	         pts[6].x = ref.x-(3*buf)/5;
	         pts[6].y = ref.y-buf;
	         pts[7].x = ref.x+(3*buf)/5;
	         pts[7].y = ref.y-buf;
		if(!windows[ORDB].opt1){
	         pts[8].x = ref.x+buf;
	         pts[8].y = ref.y-buf/5;
	         pts[9].x = ref.x-buf;
	         pts[9].y = ref.y-buf/5;
	         pts[10].x = ref.x+buf;
	         pts[10].y = ref.y+buf/5;
	         pts[11].x = ref.x-buf;
	         pts[11].y = ref.y+buf/5;
	         pts[12].x = ref.x+buf;
	         pts[12].y = ref.y-(3*buf)/5;
	         pts[13].x = ref.x-buf;
	         pts[13].y = ref.y-(3*buf)/5;
	         pts[14].x = ref.x+buf;
	         pts[14].y = ref.y+(3*buf)/5;
	         pts[15].x = ref.x-buf;
	         pts[15].y = ref.y+(3*buf)/5;
		}else{
	         pts[8].x = ref.x-buf;
	         pts[8].y = ref.y+buf/5;
	         pts[9].x = ref.x+buf;
	         pts[9].y = ref.y+buf/5;
	         pts[10].x = ref.x-buf;
	         pts[10].y = ref.y-buf/5;
	         pts[11].x = ref.x+buf;
	         pts[11].y = ref.y-buf/5;
	         pts[12].x = ref.x-buf;
	         pts[12].y = ref.y+(3*buf)/5;
	         pts[13].x = ref.x+buf;
	         pts[13].y = ref.y+(3*buf)/5;
	         pts[14].x = ref.x-buf;
	         pts[14].y = ref.y-(3*buf)/5;
	         pts[15].x = ref.x+buf;
	         pts[15].y = ref.y-(3*buf)/5;
		}
	      }
	      break;

	case TREE:
	      if(hype_num_nodes==4){
	         pts[0].x = ref.x;
	         pts[0].y = (2*ref.y)/3;
	         pts[1].x = (2*ref.x)/3;
	         pts[1].y = ref.y;
	         pts[2].x = (4*ref.x)/3;
	         pts[2].y = ref.y;
	         pts[3].x = ref.x;
	         pts[3].y = (4*ref.y)/3;
	      }else if(hype_num_nodes==8){
	         pts[0].x = ref.x;
	         pts[0].y = (2*ref.y)/5;
	         pts[1].x = (2*ref.x)/4;
	         pts[1].y = (4*ref.y)/5;
	         pts[2].x = ref.x;
	         pts[2].y = (4*ref.y)/5;
	         pts[3].x = (2*ref.x)/4;
	         pts[3].y = (6*ref.y)/5;
	         pts[4].x = (6*ref.x)/4;
	         pts[4].y = (4*ref.y)/5;
	         pts[7].x = ref.x;
	         pts[7].y = (8*ref.y)/5;
		if(!windows[ORDB].opt1){
	         pts[5].x = ref.x;
	         pts[5].y = (6*ref.y)/5;
	         pts[6].x = (6*ref.x)/4;
	         pts[6].y = (6*ref.y)/5;
		}else{
	         pts[6].x = ref.x;
	         pts[6].y = (6*ref.y)/5;
	         pts[5].x = (6*ref.x)/4;
	         pts[5].y = (6*ref.y)/5;
		}
	      }else{
	         pts[0].x = ref.x;
	         pts[0].y = (2*ref.y)/6;
	         pts[1].x = (2*ref.x)/5;
	         pts[1].y = (4*ref.y)/6;
	         pts[2].x = (4*ref.x)/5;
	         pts[2].y = (4*ref.y)/6;
	         pts[3].x = (2*ref.x)/7;
	         pts[3].y = ref.y;
	         pts[4].x = (6*ref.x)/5;
	         pts[4].y = (4*ref.y)/6;
	         pts[7].x = (2*ref.x)/5;
	         pts[7].y = (8*ref.y)/6;
	         pts[8].x = (8*ref.x)/5;
	         pts[8].y = (4*ref.y)/6;
	         pts[15].x = ref.x;
	         pts[15].y = (10*ref.y)/6;
		if(!windows[ORDB].opt1){
	         pts[5].x = (4*ref.x)/7;
	         pts[5].y = ref.y;
	         pts[6].x = (6*ref.x)/7;
	         pts[6].y = ref.y;
	         pts[9].x = (8*ref.x)/7;
	         pts[9].y = ref.y;
	         pts[10].x = (10*ref.x)/7;
	         pts[10].y = ref.y;
	         pts[11].x = (4*ref.x)/5;
	         pts[11].y = (8*ref.y)/6;
	         pts[12].x = (12*ref.x)/7;
	         pts[12].y = ref.y;
	         pts[13].x = (6*ref.x)/5;
	         pts[13].y = (8*ref.y)/6;
	         pts[14].x = (8*ref.x)/5;
	         pts[14].y = (8*ref.y)/6;
		}else{
	         pts[6].x = (4*ref.x)/7;
	         pts[6].y = ref.y;
	         pts[5].x = (6*ref.x)/7;
	         pts[5].y = ref.y;
	         pts[12].x = (8*ref.x)/7;
	         pts[12].y = ref.y;
	         pts[10].x = (10*ref.x)/7;
	         pts[10].y = ref.y;
	         pts[13].x = (4*ref.x)/5;
	         pts[13].y = (8*ref.y)/6;
	         pts[9].x = (12*ref.x)/7;
	         pts[9].y = ref.y;
	         pts[14].x = (6*ref.x)/5;
	         pts[14].y = (8*ref.y)/6;
	         pts[11].x = (8*ref.x)/5;
	         pts[11].y = (8*ref.y)/6;
		}
	      }
	      break;

	case TESSERACT:
	      if(hype_num_nodes==4){
	         pts[0].x = (2*ref.x)/3;
	         pts[0].y = (2*ref.y)/3;
	         pts[1].x = (4*ref.x)/3;
	         pts[1].y = (2*ref.y)/3;
	         pts[2].x = (2*ref.x)/3;
	         pts[2].y = (4*ref.y)/3;
	         pts[3].x = (4*ref.x)/3;
	         pts[3].y = (4*ref.y)/3;
	      }else if(hype_num_nodes==8){
	         pts[0].x = (9*ref.x)/15;
	         pts[0].y = (11*ref.y)/30;
	         pts[2].x = ref.x/15;
	         pts[2].y = ref.y;
	         pts[5].x = (29*ref.x)/15;
	         pts[5].y = ref.y;
	         pts[7].x = (21*ref.x)/15;
	         pts[7].y = (49*ref.y)/30;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = (21*ref.x)/15;
	           pts[1].y = (11*ref.y)/30;
	           pts[3].x = (13*ref.x)/15;
	           pts[3].y = ref.y;
	           pts[4].x = (17*ref.x)/15;
	           pts[4].y = ref.y;
	           pts[6].x = (9*ref.x)/15;
	           pts[6].y = (49*ref.y)/30;
		 }else{
	           pts[4].x = (21*ref.x)/15;
	           pts[4].y = (11*ref.y)/30;
	           pts[6].x = (13*ref.x)/15;
	           pts[6].y = ref.y;
	           pts[1].x = (17*ref.x)/15;
	           pts[1].y = ref.y;
	           pts[3].x = (9*ref.x)/15;
	           pts[3].y = (49*ref.y)/30;
		 }
	      }else{
	         pts[0].x = (5*ref.x)/8;
	         pts[0].y = (ref.y)/8;
	         pts[2].x = (ref.x)/8;
	         pts[2].y = (5*ref.y)/8;
	         pts[5].x = (15*ref.x)/8;
	         pts[5].y = (5*ref.y)/8;
	         pts[7].x = (11*ref.x)/8;
	         pts[7].y = (9*ref.y)/8;
	         pts[8].x = (5*ref.x)/8;
	         pts[8].y = (7*ref.y)/8;
	         pts[10].x = (ref.x)/8;
	         pts[10].y = (11*ref.y)/8;
	         pts[13].x = (15*ref.x)/8;
	         pts[13].y = (11*ref.y)/8;
	         pts[15].x = (11*ref.x)/8;
	         pts[15].y = (15*ref.y)/8;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = (11*ref.x)/8;
	           pts[1].y = (ref.y)/8;
	           pts[3].x = (7*ref.x)/8;
	           pts[3].y = (5*ref.y)/8;
	           pts[4].x = (9*ref.x)/8;
	           pts[4].y = (5*ref.y)/8;
	           pts[6].x = (5*ref.x)/8;
	           pts[6].y = (9*ref.y)/8;
	           pts[9].x = (11*ref.x)/8;
	           pts[9].y = (7*ref.y)/8;
	           pts[11].x = (7*ref.x)/8;
	           pts[11].y = (11*ref.y)/8;
	           pts[12].x = (9*ref.x)/8;
	           pts[12].y = (11*ref.y)/8;
	           pts[14].x = (5*ref.x)/8;
	           pts[14].y = (15*ref.y)/8;
		 }else{
	           pts[1].x = (9*ref.x)/8;
	           pts[1].y = (5*ref.y)/8;
	           pts[3].x = (5*ref.x)/8;
	           pts[3].y = (9*ref.y)/8;
	           pts[4].x = (11*ref.x)/8;
	           pts[4].y = (ref.y)/8;
	           pts[6].x = (7*ref.x)/8;
	           pts[6].y = (5*ref.y)/8;
	           pts[9].x = (9*ref.x)/8;
	           pts[9].y = (11*ref.y)/8;
	           pts[11].x = (5*ref.x)/8;
	           pts[11].y = (15*ref.y)/8;
	           pts[12].x = (11*ref.x)/8;
	           pts[12].y = (7*ref.y)/8;
	           pts[14].x = (7*ref.x)/8;
	           pts[14].y = (11*ref.y)/8;
		 }
	      }
	      break;

	case POLYTOPE:
	      if(hype_num_nodes==4){
	         pts[0].x = ref.x;
	         pts[0].y = (7*ref.y)/10;
	         pts[1].x = (ref.x)/5;
	         pts[1].y = ref.y;
	         pts[2].x = (9*ref.x)/5;
	         pts[2].y = ref.y;
	         pts[3].x = ref.x;
	         pts[3].y = (13*ref.y)/10;
	      }else if(hype_num_nodes==8){
	         pts[0].x = (19*ref.x)/15;
	         pts[0].y = (7*ref.y)/15;
	         pts[2].x = (27*ref.x)/15;
	         pts[2].y = (10*ref.y)/15;
	         pts[5].x = (3*ref.x)/15;
	         pts[5].y = (20*ref.y)/15;
	         pts[7].x = (11*ref.x)/15;
	         pts[7].y = (23*ref.y)/15;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = (11*ref.x)/15;
	           pts[1].y = (10*ref.y)/15;
	           pts[3].x = (19*ref.x)/15;
	           pts[3].y = (13*ref.y)/15;
	           pts[4].x = (11*ref.x)/15;
	           pts[4].y = (17*ref.y)/15;
	           pts[6].x = (19*ref.x)/15;
	           pts[6].y = (20*ref.y)/15;
		 }else{
	           pts[1].x = (11*ref.x)/15;
	           pts[1].y = (17*ref.y)/15;
	           pts[3].x = (19*ref.x)/15;
	           pts[3].y = (20*ref.y)/15;
	           pts[4].x = (11*ref.x)/15;
	           pts[4].y = (10*ref.y)/15;
	           pts[6].x = (19*ref.x)/15;
	           pts[6].y = (13*ref.y)/15;
		 }
	      }else{
	         pts[0].x = (10*ref.x)/10;
	         pts[0].y = (6*ref.y)/20;
	         pts[2].x = (14*ref.x)/10;
	         pts[2].y = (9*ref.y)/20;
	         pts[5].x = (1*ref.x)/10;
	         pts[5].y = (10*ref.y)/10;
	         pts[7].x = (5*ref.x)/10;
	         pts[7].y = (23*ref.y)/20;
	         pts[8].x = (15*ref.x)/10;
	         pts[8].y = (17*ref.y)/20;
	         pts[10].x = (19*ref.x)/10;
	         pts[10].y = (10*ref.y)/10;
	         pts[13].x = (6*ref.x)/10;
	         pts[13].y = (31*ref.y)/20;
	         pts[15].x = (10*ref.x)/10;
	         pts[15].y = (34*ref.y)/20;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = (6*ref.x)/10;
	           pts[1].y = (9*ref.y)/20;
	           pts[3].x = (10*ref.x)/10;
	           pts[3].y = (6*ref.y)/10;
	           pts[4].x = (5*ref.x)/10;
	           pts[4].y = (17*ref.y)/20;
	           pts[6].x = (9*ref.x)/10;
	           pts[6].y = (10*ref.y)/10;
	           pts[9].x = (11*ref.x)/10;
	           pts[9].y = (10*ref.y)/10;
	           pts[11].x = (15*ref.x)/10;
	           pts[11].y = (23*ref.y)/20;
	           pts[12].x = (10*ref.x)/10;
	           pts[12].y = (14*ref.y)/10;
	           pts[14].x = (14*ref.x)/10;
	           pts[14].y = (31*ref.y)/20;
		 }else{
	           pts[1].x = (5*ref.x)/10;
	           pts[1].y = (17*ref.y)/20;
	           pts[3].x = (9*ref.x)/10;
	           pts[3].y = (10*ref.y)/10;
	           pts[4].x = (6*ref.x)/10;
	           pts[4].y = (9*ref.y)/20;
	           pts[6].x = (10*ref.x)/10;
	           pts[6].y = (6*ref.y)/10;
	           pts[9].x = (10*ref.x)/10;
	           pts[9].y = (14*ref.y)/10;
	           pts[11].x = (14*ref.x)/10;
	           pts[11].y = (31*ref.y)/20;
	           pts[12].x = (11*ref.x)/10;
	           pts[12].y = (10*ref.y)/10;
	           pts[14].x = (15*ref.x)/10;
	           pts[14].y = (23*ref.y)/20;
		 }
	      }
	      break;

	case TORUS:
	      if(hype_num_nodes==4){
		 if(!windows[ORDB].opt1){
	         pts[0].x = (2*ref.x)/9;
	         pts[0].y = (8*ref.y)/9;
	         pts[1].x = (10*ref.x)/9;
	         pts[1].y = (8*ref.y)/9;
	         pts[2].x = (6*ref.x)/9;
	         pts[2].y = (10*ref.y)/9;
	         pts[3].x = (14*ref.x)/9;
	         pts[3].y = (10*ref.y)/9;
		 }else{
	         pts[0].x = (6*ref.x)/9;
	         pts[0].y = (6*ref.y)/9;
	         pts[1].x = (10*ref.x)/9;
	         pts[1].y = (8*ref.y)/9;
	         pts[2].x = (8*ref.x)/9;
	         pts[2].y = (10*ref.y)/9;
	         pts[3].x = (12*ref.x)/9;
	         pts[3].y = (12*ref.y)/9;
		 }
	      }else if(hype_num_nodes==8){
	         pts[0].x = (2*ref.x)/9;
	         pts[0].y = (6*ref.y)/9;
	         pts[7].x = (16*ref.x)/9;
	         pts[7].y = (12*ref.y)/9;
		 if(!windows[ORDB].opt1){
	         pts[1].x = (10*ref.x)/9;
	         pts[1].y = (6*ref.y)/9;
	         pts[2].x = (6*ref.x)/9;
	         pts[2].y = (8*ref.y)/9;
	         pts[3].x = (14*ref.x)/9;
	         pts[3].y = (8*ref.y)/9;
	         pts[4].x = (4*ref.x)/9;
	         pts[4].y = (10*ref.y)/9;
	         pts[5].x = (12*ref.x)/9;
	         pts[5].y = (10*ref.y)/9;
	         pts[6].x = (8*ref.x)/9;
	         pts[6].y = (12*ref.y)/9;
		 }else{
	         pts[1].x = (6*ref.x)/9;
	         pts[1].y = (8*ref.y)/9;
	         pts[2].x = (4*ref.x)/9;
	         pts[2].y = (10*ref.y)/9;
	         pts[3].x = (8*ref.x)/9;
	         pts[3].y = (12*ref.y)/9;
	         pts[4].x = (10*ref.x)/9;
	         pts[4].y = (6*ref.y)/9;
	         pts[5].x = (14*ref.x)/9;
	         pts[5].y = (8*ref.y)/9;
	         pts[6].x = (12*ref.x)/9;
	         pts[6].y = (10*ref.y)/9;
		 }
	      }else{
	         pts[0].x = (2*ref.x)/9;
	         pts[0].y = (2*ref.y)/9;
	         pts[7].x = (16*ref.x)/9;
	         pts[7].y = (8*ref.y)/9;
	         pts[8].x = (2*ref.x)/9;
	         pts[8].y = (10*ref.y)/9;
	         pts[15].x = (16*ref.x)/9;
	         pts[15].y = (16*ref.y)/9;
		 if(!windows[ORDB].opt1){
	         pts[1].x = (10*ref.x)/9;
	         pts[1].y = (2*ref.y)/9;
	         pts[2].x = (6*ref.x)/9;
	         pts[2].y = (4*ref.y)/9;
	         pts[3].x = (14*ref.x)/9;
	         pts[3].y = (4*ref.y)/9;
	         pts[4].x = (4*ref.x)/9;
	         pts[4].y = (6*ref.y)/9;
	         pts[5].x = (12*ref.x)/9;
	         pts[5].y = (6*ref.y)/9;
	         pts[6].x = (8*ref.x)/9;
	         pts[6].y = (8*ref.y)/9;
	         pts[9].x = (10*ref.x)/9;
	         pts[9].y = (10*ref.y)/9;
	         pts[10].x = (6*ref.x)/9;
	         pts[10].y = (12*ref.y)/9;
	         pts[11].x = (14*ref.x)/9;
	         pts[11].y = (12*ref.y)/9;
	         pts[12].x = (4*ref.x)/9;
	         pts[12].y = (14*ref.y)/9;
	         pts[13].x = (12*ref.x)/9;
	         pts[13].y = (14*ref.y)/9;
	         pts[14].x = (8*ref.x)/9;
	         pts[14].y = (16*ref.y)/9;
		 }else{
	         pts[1].x = (6*ref.x)/9;
	         pts[1].y = (4*ref.y)/9;
	         pts[2].x = (4*ref.x)/9;
	         pts[2].y = (6*ref.y)/9;
	         pts[3].x = (8*ref.x)/9;
	         pts[3].y = (8*ref.y)/9;
	         pts[4].x = (10*ref.x)/9;
	         pts[4].y = (2*ref.y)/9;
	         pts[5].x = (14*ref.x)/9;
	         pts[5].y = (4*ref.y)/9;
	         pts[6].x = (12*ref.x)/9;
	         pts[6].y = (6*ref.y)/9;
	         pts[9].x = (6*ref.x)/9;
	         pts[9].y = (12*ref.y)/9;
	         pts[10].x = (4*ref.x)/9;
	         pts[10].y = (14*ref.y)/9;
	         pts[11].x = (8*ref.x)/9;
	         pts[11].y = (16*ref.y)/9;
	         pts[12].x = (10*ref.x)/9;
	         pts[12].y = (10*ref.y)/9;
	         pts[13].x = (14*ref.x)/9;
	         pts[13].y = (12*ref.y)/9;
	         pts[14].x = (12*ref.x)/9;
	         pts[14].y = (14*ref.y)/9;
		 }
	      }
	      break;

	case SHUFFLE:
	      if(hype_num_nodes==4){
		 if (ref.x<ref.y) buf=ref.x/2;
		 else buf=ref.y/2;
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y;
	         pts[1].x = ref.x;
	         pts[1].y = ref.y-buf;
	         pts[2].x = ref.x;
	         pts[2].y = ref.y+buf;
	         pts[3].x = ref.x+buf;
	         pts[3].y = ref.y;
	      }else if(hype_num_nodes==8){
		 buf = (int)((float)ref.x/2.7071);
	         pts[0].x = ref.x/2-buf;
	         pts[0].y = ref.y;
	         pts[1].x = ref.x/2+buf;
	         pts[1].y = ref.y;
	         pts[2].x = ref.x/2;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+ref.x/2;
	         pts[3].y = ref.y-buf;
	         pts[4].x = ref.x/2;
	         pts[4].y = ref.y+buf;
	         pts[5].x = ref.x+ref.x/2;
	         pts[5].y = ref.y+buf;
	         pts[6].x = ref.x+ref.x/2-buf;
	         pts[6].y = ref.y;
	         pts[7].x = ref.x+ref.x/2+buf;
	         pts[7].y = ref.y;
	      }else{
		 buf = (int)((float)ref.x/2.7071);
	         pts[0].x = ref.x/2-buf;
	         pts[0].y = ref.y;
	         pts[1].x = ref.x/2-buf/2;
	         pts[1].y = ref.y-buf/2;
	         pts[2].x = ref.x/2+buf/2;
	         pts[2].y = ref.y-buf/2;
	         pts[3].x = ref.x/2;
	         pts[3].y = ref.y-buf;
	         pts[4].x = ref.x/2+buf/2;
	         pts[4].y = ref.y+buf/2;
	         pts[5].x = ref.x/2+buf;
	         pts[5].y = ref.y;
	         pts[6].x = ref.x+ref.x/2;
	         pts[6].y = ref.y-buf;
	         pts[7].x = ref.x+ref.x/2+buf/2;
	         pts[7].y = ref.y-buf/2;
	         pts[8].x = ref.x/2-buf/2;
	         pts[8].y = ref.y+buf/2;
	         pts[9].x = ref.x/2;
	         pts[9].y = ref.y+buf;
	         pts[10].x = ref.x+ref.x/2-buf;
	         pts[10].y = ref.y;
	         pts[11].x = ref.x+ref.x/2-buf/2;
	         pts[11].y = ref.y-buf/2;
	         pts[12].x = ref.x+ref.x/2;
	         pts[12].y = ref.y+buf;
	         pts[13].x = ref.x+ref.x/2-buf/2;
	         pts[13].y = ref.y+buf/2;
	         pts[14].x = ref.x+ref.x/2+buf/2;
	         pts[14].y = ref.y+buf/2;
	         pts[15].x = ref.x+ref.x/2+buf;
	         pts[15].y = ref.y;
	      }
	      break;

	case QUATREFOIL:
	      if(hype_num_nodes==4){
	         pts[0].x = (4*ref.x)/5;
	         pts[0].y = (6*ref.y)/5;
	         pts[3].x = (6*ref.x)/5;
	         pts[3].y = (4*ref.y)/5;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = (6*ref.x)/5;
	           pts[1].y = (6*ref.y)/5;
	           pts[2].x = (4*ref.x)/5;
	           pts[2].y = (4*ref.y)/5;
		 }else{
	           pts[1].x = (4*ref.x)/5;
	           pts[1].y = (4*ref.y)/5;
	           pts[2].x = (6*ref.x)/5;
	           pts[2].y = (6*ref.y)/5;
		 }
	      }else if(hype_num_nodes==8){
                 pts[0].x = 0.8*rad*cos((5*PI)/8)+ref.x;
	         pts[0].y = 0.8*rad*sin((5*PI)/8)+ref.y;
                 pts[2].x = 0.8*rad*cos((11*PI)/8)+ref.x;
	         pts[2].y = 0.8*rad*sin((11*PI)/8)+ref.y;
                 pts[5].x = 0.8*rad*cos((1*PI)/8)+ref.x;
	         pts[5].y = 0.8*rad*sin((1*PI)/8)+ref.y;
                 pts[7].x = 0.8*rad*cos((15*PI)/8)+ref.x;
	         pts[7].y = 0.8*rad*sin((15*PI)/8)+ref.y;
		 if(windows[ORDB].opt1==0){
                   pts[1].x = 0.8*rad*cos((3*PI)/8)+ref.x;
	           pts[1].y = 0.8*rad*sin((3*PI)/8)+ref.y;
                   pts[3].x = 0.8*rad*cos((13*PI)/8)+ref.x;
	           pts[3].y = 0.8*rad*sin((13*PI)/8)+ref.y;
                   pts[4].x = 0.8*rad*cos((7*PI)/8)+ref.x;
	           pts[4].y = 0.8*rad*sin((7*PI)/8)+ref.y;
                   pts[6].x = 0.8*rad*cos((9*PI)/8)+ref.x;
	           pts[6].y = 0.8*rad*sin((9*PI)/8)+ref.y;
		 }else{
                   pts[1].x = 0.8*rad*cos((7*PI)/8)+ref.x;
	           pts[1].y = 0.8*rad*sin((7*PI)/8)+ref.y;
                   pts[3].x = 0.8*rad*cos((9*PI)/8)+ref.x;
	           pts[3].y = 0.8*rad*sin((9*PI)/8)+ref.y;
                   pts[4].x = 0.8*rad*cos((3*PI)/8)+ref.x;
	           pts[4].y = 0.8*rad*sin((3*PI)/8)+ref.y;
                   pts[6].x = 0.8*rad*cos((13*PI)/8)+ref.x;
	           pts[6].y = 0.8*rad*sin((13*PI)/8)+ref.y;
		 }
	      }else{
                 pts[0].x = 0.48*rad*cos((5*PI)/8)+ref.x;
	         pts[0].y = 0.48*rad*sin((5*PI)/8)+ref.y;
                 pts[2].x = 0.48*rad*cos((11*PI)/8)+ref.x;
	         pts[2].y = 0.48*rad*sin((11*PI)/8)+ref.y;
                 pts[5].x = 0.48*rad*cos((1*PI)/8)+ref.x;
	         pts[5].y = 0.48*rad*sin((1*PI)/8)+ref.y;
                 pts[7].x = 0.48*rad*cos((15*PI)/8)+ref.x;
	         pts[7].y = 0.48*rad*sin((15*PI)/8)+ref.y;
                 pts[8].x = 0.8*rad*cos((5*PI)/8)+ref.x;
	         pts[8].y = 0.8*rad*sin((5*PI)/8)+ref.y;
                 pts[10].x = 0.8*rad*cos((11*PI)/8)+ref.x;
	         pts[10].y = 0.8*rad*sin((11*PI)/8)+ref.y;
                 pts[13].x = 0.8*rad*cos((1*PI)/8)+ref.x;
	         pts[13].y = 0.8*rad*sin((1*PI)/8)+ref.y;
                 pts[15].x = 0.8*rad*cos((15*PI)/8)+ref.x;
	         pts[15].y = 0.8*rad*sin((15*PI)/8)+ref.y;
		 if(windows[ORDB].opt1==0){
                   pts[1].x = 0.48*rad*cos((3*PI)/8)+ref.x;
	           pts[1].y = 0.48*rad*sin((3*PI)/8)+ref.y;
                   pts[3].x = 0.48*rad*cos((13*PI)/8)+ref.x;
	           pts[3].y = 0.48*rad*sin((13*PI)/8)+ref.y;
                   pts[4].x = 0.48*rad*cos((7*PI)/8)+ref.x;
	           pts[4].y = 0.48*rad*sin((7*PI)/8)+ref.y;
                   pts[6].x = 0.48*rad*cos((9*PI)/8)+ref.x;
	           pts[6].y = 0.48*rad*sin((9*PI)/8)+ref.y;
                   pts[9].x = 0.8*rad*cos((3*PI)/8)+ref.x;
	           pts[9].y = 0.8*rad*sin((3*PI)/8)+ref.y;
                   pts[11].x = 0.8*rad*cos((13*PI)/8)+ref.x;
	           pts[11].y = 0.8*rad*sin((13*PI)/8)+ref.y;
                   pts[12].x = 0.8*rad*cos((7*PI)/8)+ref.x;
	           pts[12].y = 0.8*rad*sin((7*PI)/8)+ref.y;
                   pts[14].x = 0.8*rad*cos((9*PI)/8)+ref.x;
	           pts[14].y = 0.8*rad*sin((9*PI)/8)+ref.y;
		 }else{
                   pts[1].x = 0.48*rad*cos((7*PI)/8)+ref.x;
	           pts[1].y = 0.48*rad*sin((7*PI)/8)+ref.y;
                   pts[3].x = 0.48*rad*cos((9*PI)/8)+ref.x;
	           pts[3].y = 0.48*rad*sin((9*PI)/8)+ref.y;
                   pts[4].x = 0.48*rad*cos((3*PI)/8)+ref.x;
	           pts[4].y = 0.48*rad*sin((3*PI)/8)+ref.y;
                   pts[6].x = 0.48*rad*cos((13*PI)/8)+ref.x;
	           pts[6].y = 0.48*rad*sin((13*PI)/8)+ref.y;
                   pts[9].x = 0.8*rad*cos((7*PI)/8)+ref.x;
	           pts[9].y = 0.8*rad*sin((7*PI)/8)+ref.y;
                   pts[11].x = 0.8*rad*cos((9*PI)/8)+ref.x;
	           pts[11].y = 0.8*rad*sin((9*PI)/8)+ref.y;
                   pts[12].x = 0.8*rad*cos((3*PI)/8)+ref.x;
	           pts[12].y = 0.8*rad*sin((3*PI)/8)+ref.y;
                   pts[14].x = 0.8*rad*cos((13*PI)/8)+ref.x;
	           pts[14].y = 0.8*rad*sin((13*PI)/8)+ref.y;
		 }
	      }
	      break;

	case ROSETTE: 
	      if(ref.x<ref.y) buf=(ref.x)/2;
	      else buf=(ref.y)/2;
	      if(hype_num_nodes==4){
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf;
	         pts[1].y = ref.y+buf;
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+buf;
	         pts[3].y = ref.y-buf;
	      }else if(hype_num_nodes==8){
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+buf;
                 pts[7].x = ref.x+(7*buf)/5;
	         pts[7].y = ref.y;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = ref.x+buf;
	           pts[1].y = ref.y+buf;
	           pts[2].x = ref.x-buf;
	           pts[2].y = ref.y-buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y-buf;
                   pts[4].x = ref.x-(7*buf)/5;
	           pts[4].y = ref.y;
                   pts[5].x = ref.x;
	           pts[5].y = ref.y+(7*buf)/5;
                   pts[6].x = ref.x;
	           pts[6].y = ref.y-(7*buf)/5;
		 }else{
	           pts[2].x = ref.x+buf;
	           pts[2].y = ref.y+buf;
	           pts[4].x = ref.x-buf;
	           pts[4].y = ref.y-buf;
	           pts[6].x = ref.x+buf;
	           pts[6].y = ref.y-buf;
                   pts[1].x = ref.x-(7*buf)/5;
	           pts[1].y = ref.y;
                   pts[3].x = ref.x;
	           pts[3].y = ref.y+(7*buf)/5;
                   pts[5].x = ref.x;
	           pts[5].y = ref.y-(7*buf)/5;
		 }
	      }else{
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+buf;
                 pts[7].x = ref.x+(7*buf)/5;
	         pts[7].y = ref.y;
                 pts[8].x = ref.x-buf;
	         pts[8].y = ref.y+(2*buf)/5;
                 pts[15].x = ref.x+buf;
	         pts[15].y = ref.y+(2*buf)/5;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = ref.x+buf;
	           pts[1].y = ref.y+buf;
	           pts[2].x = ref.x-buf;
	           pts[2].y = ref.y-buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y-buf;
                   pts[4].x = ref.x-(7*buf)/5;
	           pts[4].y = ref.y;
                   pts[5].x = ref.x;
	           pts[5].y = ref.y+(7*buf)/5;
                   pts[6].x = ref.x;
	           pts[6].y = ref.y-(7*buf)/5;
                   pts[9].x = ref.x+(2*buf)/5;
	           pts[9].y = ref.y+buf;
                   pts[10].x = ref.x-(2*buf)/5;
	           pts[10].y = ref.y-buf;
                   pts[11].x = ref.x+buf;
	           pts[11].y = ref.y-(2*buf)/5;
                   pts[12].x = ref.x-buf;
	           pts[12].y = ref.y-(2*buf)/5;
                   pts[13].x = ref.x-(2*buf)/5;
	           pts[13].y = ref.y+buf;
                   pts[14].x = ref.x+(2*buf)/5;
	           pts[14].y = ref.y-buf;
		 }else{
	           pts[2].x = ref.x+buf;
	           pts[2].y = ref.y+buf;
	           pts[4].x = ref.x-buf;
	           pts[4].y = ref.y-buf;
	           pts[6].x = ref.x+buf;
	           pts[6].y = ref.y-buf;
                   pts[1].x = ref.x-(7*buf)/5;
	           pts[1].y = ref.y;
                   pts[3].x = ref.x;
	           pts[3].y = ref.y+(7*buf)/5;
                   pts[5].x = ref.x;
	           pts[5].y = ref.y-(7*buf)/5;
                   pts[10].x = ref.x+(2*buf)/5;
	           pts[10].y = ref.y+buf;
                   pts[12].x = ref.x-(2*buf)/5;
	           pts[12].y = ref.y-buf;
                   pts[14].x = ref.x+buf;
	           pts[14].y = ref.y-(2*buf)/5;
                   pts[9].x = ref.x-buf;
	           pts[9].y = ref.y-(2*buf)/5;
                   pts[11].x = ref.x-(2*buf)/5;
	           pts[11].y = ref.y+buf;
                   pts[13].x = ref.x+(2*buf)/5;
	           pts[13].y = ref.y-buf;
		 }
	      }
	      break;

	case CIRCLES:
	      if(ref.x<ref.y){
	        buf=ref.x;
	      }else{
	        buf=ref.y;
	      }
	      if(hype_num_nodes==4){
	         pts[0].x = ref.x-(int)(0.7071*(double)(2*buf)/5);
	         pts[0].y = ref.y+(int)(0.7071*(double)(2*buf)/5);
	         pts[1].x = ref.x+(int)(0.7071*(double)(2*buf)/5);
	         pts[1].y = ref.y+(int)(0.7071*(double)(2*buf)/5);
	         pts[2].x = ref.x-(int)(0.7071*(double)(2*buf)/5);
	         pts[2].y = ref.y-(int)(0.7071*(double)(2*buf)/5);
	         pts[3].x = ref.x+(int)(0.7071*(double)(2*buf)/5);
	         pts[3].y = ref.y-(int)(0.7071*(double)(2*buf)/5);
	      }else if(hype_num_nodes==8){
	         pts[0].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[0].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[1].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[1].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[6].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[6].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[7].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[7].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
		 if(windows[ORDB].opt1==0){
	         pts[2].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[2].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[3].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[3].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[4].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[4].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[5].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[5].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
		 }else{
	         pts[2].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[2].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[3].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[3].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[4].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[4].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[5].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[5].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
		 }
	      }else{
	         pts[0].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[0].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[1].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[1].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[6].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[6].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[7].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[7].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[8].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[8].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[9].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[9].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[14].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[14].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
	         pts[15].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[15].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
		 if(windows[ORDB].opt1==0){
	         pts[2].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[2].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[3].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[3].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[4].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[4].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[5].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[5].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[10].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[10].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[11].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[11].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[12].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[12].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
	         pts[13].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[13].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
		 }else{
	         pts[2].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[2].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[3].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[3].y = ref.y+(int)(0.7071*(double)(3*buf)/10);
	         pts[4].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[4].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[5].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[5].y = ref.y+(int)(0.7071*(double)(9*buf)/10);
	         pts[10].x = ref.x-(int)(0.7071*(double)(9*buf)/10);
	         pts[10].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
	         pts[11].x = ref.x-(int)(0.7071*(double)(3*buf)/10);
	         pts[11].y = ref.y-(int)(0.7071*(double)(9*buf)/10);
	         pts[12].x = ref.x+(int)(0.7071*(double)(3*buf)/10);
	         pts[12].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
	         pts[13].x = ref.x+(int)(0.7071*(double)(9*buf)/10);
	         pts[13].y = ref.y-(int)(0.7071*(double)(3*buf)/10);
		 }
	      }
	      break;

	case PINWHEEL: 
	      if(hype_num_nodes==4){
                 pts[0].x = 0.7*rad*cos((5*PI)/4)+ref.x;
	         pts[0].y = -0.7*rad*sin((5*PI)/4)+ref.y;
                 pts[1].x = 0.7*rad*cos((7*PI)/4)+ref.x;
	         pts[1].y = -0.7*rad*sin((7*PI)/4)+ref.y;
                 pts[2].x = 0.7*rad*cos((3*PI)/4)+ref.x;
	         pts[2].y = -0.7*rad*sin((3*PI)/4)+ref.y;
                 pts[3].x = 0.7*rad*cos((PI)/4)+ref.x;
	         pts[3].y = -0.7*rad*sin((PI)/4)+ref.y;
	      }else if(hype_num_nodes==8){
                 pts[0].x = 0.8*rad*cos((5*PI)/4)+ref.x;
	         pts[0].y = -0.8*rad*sin((5*PI)/4)+ref.y;
                 pts[2].x = 0.8*rad*cos((3*PI)/4)+ref.x;
	         pts[2].y = -0.8*rad*sin((3*PI)/4)+ref.y;
                 pts[5].x = 0.8*rad*cos((3*PI)/2)+ref.x;
	         pts[5].y = -0.8*rad*sin((3*PI)/2)+ref.y;
                 pts[7].x = 0.8*rad*cos(0)+ref.x;
	         pts[7].y = -0.8*rad*sin(0)+ref.y;
		 if(windows[ORDB].opt1==0){
                   pts[1].x = 0.8*rad*cos((7*PI)/4)+ref.x;
	           pts[1].y = -0.8*rad*sin((7*PI)/4)+ref.y;
                   pts[3].x = 0.8*rad*cos((PI)/4)+ref.x;
	           pts[3].y = -0.8*rad*sin((PI)/4)+ref.y;
                   pts[4].x = 0.8*rad*cos(PI)+ref.x;
	           pts[4].y = -0.8*rad*sin(PI)+ref.y;
                   pts[6].x = 0.8*rad*cos((PI)/2)+ref.x;
	           pts[6].y = -0.8*rad*sin((PI)/2)+ref.y;
		 }else{
                   pts[1].x = 0.8*rad*cos(PI)+ref.x;
	           pts[1].y = -0.8*rad*sin(PI)+ref.y;
                   pts[3].x = 0.8*rad*cos((PI)/2)+ref.x;
	           pts[3].y = -0.8*rad*sin((PI)/2)+ref.y;
                   pts[4].x = 0.8*rad*cos((7*PI)/4)+ref.x;
	           pts[4].y = -0.8*rad*sin((7*PI)/4)+ref.y;
                   pts[6].x = 0.8*rad*cos((PI)/4)+ref.x;
	           pts[6].y = -0.8*rad*sin((PI)/4)+ref.y;
		 }
	      }else{
                 pts[0].x = 0.5*rad*cos((5*PI)/4)+ref.x;
	         pts[0].y = -0.5*rad*sin((5*PI)/4)+ref.y;
                 pts[2].x = 0.5*rad*cos((3*PI)/4)+ref.x;
	         pts[2].y = -0.5*rad*sin((3*PI)/4)+ref.y;
                 pts[5].x = 0.5*rad*cos((3*PI)/2)+ref.x;
	         pts[5].y = -0.5*rad*sin((3*PI)/2)+ref.y;
                 pts[7].x = 0.5*rad*cos(0)+ref.x;
	         pts[7].y = -0.5*rad*sin(0)+ref.y;
                 pts[8].x = rad*cos((5*PI)/4)+ref.x;
	         pts[8].y = -rad*sin((5*PI)/4)+ref.y;
                 pts[10].x = rad*cos((3*PI)/4)+ref.x;
	         pts[10].y = -rad*sin((3*PI)/4)+ref.y;
                 pts[13].x = rad*cos((3*PI)/2)+ref.x+1;
	         pts[13].y = -rad*sin((3*PI)/2)+ref.y;
                 pts[15].x = rad*cos(0)+ref.x;
	         pts[15].y = -rad*sin(0)+ref.y;
		 if(windows[ORDB].opt1==0){
                   pts[1].x = 0.5*rad*cos((7*PI)/4)+ref.x;
	           pts[1].y = -0.5*rad*sin((7*PI)/4)+ref.y;
                   pts[3].x = 0.5*rad*cos((PI)/4)+ref.x;
	           pts[3].y = -0.5*rad*sin((PI)/4)+ref.y;
                   pts[4].x = 0.5*rad*cos(PI)+ref.x;
	           pts[4].y = -0.5*rad*sin(PI)+ref.y;
                   pts[6].x = 0.5*rad*cos((PI)/2)+ref.x;
	           pts[6].y = -0.5*rad*sin((PI)/2)+ref.y;
                   pts[9].x = rad*cos((7*PI)/4)+ref.x;
	           pts[9].y = -rad*sin((7*PI)/4)+ref.y;
                   pts[11].x = rad*cos((PI)/4)+ref.x;
	           pts[11].y = -rad*sin((PI)/4)+ref.y;
                   pts[12].x = rad*cos(PI)+ref.x;
	           pts[12].y = -rad*sin(PI)+ref.y+1;
                   pts[14].x = rad*cos((PI)/2)+ref.x;
	           pts[14].y = -rad*sin((PI)/2)+ref.y;
		 }else{
                   pts[1].x = 0.5*rad*cos(PI)+ref.x;
	           pts[1].y = -0.5*rad*sin(PI)+ref.y;
                   pts[3].x = 0.5*rad*cos((PI)/2)+ref.x;
	           pts[3].y = -0.5*rad*sin((PI)/2)+ref.y;
                   pts[4].x = 0.5*rad*cos((7*PI)/4)+ref.x;
	           pts[4].y = -0.5*rad*sin((7*PI)/4)+ref.y;
                   pts[6].x = 0.5*rad*cos((PI)/4)+ref.x;
	           pts[6].y = -0.5*rad*sin((PI)/4)+ref.y;
                   pts[9].x = rad*cos(PI)+ref.x;
	           pts[9].y = -rad*sin(PI)+ref.y+1;
                   pts[11].x = rad*cos((PI)/2)+ref.x;
	           pts[11].y = -rad*sin((PI)/2)+ref.y;
                   pts[12].x = rad*cos((7*PI)/4)+ref.x;
	           pts[12].y = -rad*sin((7*PI)/4)+ref.y;
                   pts[14].x = rad*cos((PI)/4)+ref.x;
	           pts[14].y = -rad*sin((PI)/4)+ref.y;
		 }
	      }
	      break;

	case GEM:
	      if(hype_num_nodes==4){
		 if (ref.x<ref.y) buf=ref.x/2;
		 else buf=ref.y/2;
	         pts[0].x = ref.x;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf;
	         pts[1].y = ref.y;
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y;
	         pts[3].x = ref.x;
	         pts[3].y = ref.y-buf;
	      }else if(hype_num_nodes==8){
		 if (ref.x<ref.y) buf=ref.x/7;
		 else buf=ref.y/7;
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+5*buf;
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y-5*buf;
	         pts[5].x = ref.x+5*buf;
	         pts[5].y = ref.y+buf;
	         pts[7].x = ref.x+5*buf;
	         pts[7].y = ref.y-buf;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = ref.x+buf;
	           pts[1].y = ref.y+5*buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y-5*buf;
	           pts[4].x = ref.x-5*buf;
	           pts[4].y = ref.y+buf;
	           pts[6].x = ref.x-5*buf;
	           pts[6].y = ref.y-buf;
		 }else{
	           pts[1].x = ref.x-5*buf;
	           pts[1].y = ref.y+buf;
	           pts[3].x = ref.x-5*buf;
	           pts[3].y = ref.y-buf;
	           pts[4].x = ref.x+buf;
	           pts[4].y = ref.y+5*buf;
	           pts[6].x = ref.x+buf;
	           pts[6].y = ref.y-5*buf;
		 }
	      }else{
		 if (ref.x<ref.y) buf=ref.x/8;
		 else buf=ref.y/8;
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+5*buf;
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y-5*buf;
	         pts[5].x = ref.x+5*buf;
	         pts[5].y = ref.y+buf;
	         pts[7].x = ref.x+5*buf;
	         pts[7].y = ref.y-buf;
	         pts[8].x = ref.x-3*buf;
	         pts[8].y = ref.y+7*buf;
	         pts[10].x = ref.x-3*buf;
	         pts[10].y = ref.y-7*buf;
	         pts[13].x = ref.x+7*buf;
	         pts[13].y = ref.y+3*buf;
	         pts[15].x = ref.x+7*buf;
	         pts[15].y = ref.y-3*buf;
		 if(windows[ORDB].opt1==0){
	           pts[1].x = ref.x+buf;
	           pts[1].y = ref.y+5*buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y-5*buf;
	           pts[4].x = ref.x-5*buf;
	           pts[4].y = ref.y+buf;
	           pts[6].x = ref.x-5*buf;
	           pts[6].y = ref.y-buf;
	           pts[9].x = ref.x+3*buf;
	           pts[9].y = ref.y+7*buf;
	           pts[11].x = ref.x+3*buf;
	           pts[11].y = ref.y-7*buf;
	           pts[12].x = ref.x-7*buf;
	           pts[12].y = ref.y+3*buf;
	           pts[14].x = ref.x-7*buf;
	           pts[14].y = ref.y-3*buf;
		 }else{
	           pts[1].x = ref.x-5*buf;
	           pts[1].y = ref.y+buf;
	           pts[3].x = ref.x-5*buf;
	           pts[3].y = ref.y-buf;
	           pts[4].x = ref.x+buf;
	           pts[4].y = ref.y+5*buf;
	           pts[6].x = ref.x+buf;
	           pts[6].y = ref.y-5*buf;
	           pts[9].x = ref.x-7*buf;
	           pts[9].y = ref.y+3*buf;
	           pts[11].x = ref.x-7*buf;
	           pts[11].y = ref.y-3*buf;
	           pts[12].x = ref.x+3*buf;
	           pts[12].y = ref.y+7*buf;
	           pts[14].x = ref.x+3*buf;
	           pts[14].y = ref.y-7*buf;
		 }
	      }
	      break;

	case GRID:
	      if(hype_num_nodes==4){
		 if (ref.x<ref.y) buf=ref.x/2;
		 else buf=ref.y/2;
	         pts[0].x = ref.x-buf;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x+buf;
	         pts[1].y = ref.y+buf;
	         pts[2].x = ref.x-buf;
	         pts[2].y = ref.y-buf;
	         pts[3].x = ref.x+buf;
	         pts[3].y = ref.y-buf;
	      }else if(hype_num_nodes==8){
		 if (ref.x<2*ref.y) buf=ref.x/5;
		 else buf=(2*ref.y)/5;
	         pts[0].x = ref.x-3*buf;
	         pts[0].y = ref.y+buf;
	         pts[1].x = ref.x-buf;
	         pts[1].y = ref.y+buf;
	         pts[6].x = ref.x+3*buf;
	         pts[6].y = ref.y-buf;
	         pts[7].x = ref.x+buf;
	         pts[7].y = ref.y-buf;
		 if(windows[ORDB].opt1==0){
	           pts[2].x = ref.x+3*buf;
	           pts[2].y = ref.y+buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y+buf;
	           pts[4].x = ref.x-3*buf;
	           pts[4].y = ref.y-buf;
	           pts[5].x = ref.x-buf;
	           pts[5].y = ref.y-buf;
		 }else{
	           pts[2].x = ref.x-3*buf;
	           pts[2].y = ref.y-buf;
	           pts[3].x = ref.x-buf;
	           pts[3].y = ref.y-buf;
	           pts[4].x = ref.x+3*buf;
	           pts[4].y = ref.y+buf;
	           pts[5].x = ref.x+buf;
	           pts[5].y = ref.y+buf;
		 }
	      }else{
		 if (ref.x<ref.y) buf=ref.x/5;
		 else buf=ref.y/5;
	         pts[0].x = ref.x-3*buf;
	         pts[0].y = ref.y+3*buf;
	         pts[1].x = ref.x-buf;
	         pts[1].y = ref.y+3*buf;
	         pts[6].x = ref.x+3*buf;
	         pts[6].y = ref.y+buf;
	         pts[7].x = ref.x+buf;
	         pts[7].y = ref.y+buf;
	         pts[8].x = ref.x-3*buf;
	         pts[8].y = ref.y-3*buf;
	         pts[9].x = ref.x-buf;
	         pts[9].y = ref.y-3*buf;
	         pts[14].x = ref.x+3*buf;
	         pts[14].y = ref.y-buf;
	         pts[15].x = ref.x+buf;
	         pts[15].y = ref.y-buf;
		 if(windows[ORDB].opt1==0){
	           pts[2].x = ref.x+3*buf;
	           pts[2].y = ref.y+3*buf;
	           pts[3].x = ref.x+buf;
	           pts[3].y = ref.y+3*buf;
	           pts[4].x = ref.x-3*buf;
	           pts[4].y = ref.y+buf;
	           pts[5].x = ref.x-buf;
	           pts[5].y = ref.y+buf;
	           pts[10].x = ref.x+3*buf;
	           pts[10].y = ref.y-3*buf;
	           pts[11].x = ref.x+buf;
	           pts[11].y = ref.y-3*buf;
	           pts[12].x = ref.x-3*buf;
	           pts[12].y = ref.y-buf;
	           pts[13].x = ref.x-buf;
	           pts[13].y = ref.y-buf;
		 }else{
	           pts[2].x = ref.x-3*buf;
	           pts[2].y = ref.y+buf;
	           pts[3].x = ref.x-buf;
	           pts[3].y = ref.y+buf;
	           pts[4].x = ref.x+3*buf;
	           pts[4].y = ref.y+3*buf;
	           pts[5].x = ref.x+buf;
	           pts[5].y = ref.y+3*buf;
	           pts[10].x = ref.x-3*buf;
	           pts[10].y = ref.y-buf;
	           pts[11].x = ref.x-buf;
	           pts[11].y = ref.y-buf;
	           pts[12].x = ref.x+3*buf;
	           pts[12].y = ref.y-3*buf;
	           pts[13].x = ref.x+buf;
	           pts[13].y = ref.y-3*buf;
		 }
	      }
	      break;

	}   /*ends the switch statement for windows[HTYB].opt1*/
}

/******************************************************
 *  Procedure to draw and erase the connection lines  *
 *             for the animation display              *
 ******************************************************/

draw_hype(first,second,drawgc1,drawgc2)
   int first, second;
   GC drawgc1,drawgc2;

{
int buf, value, offset, ref_x, ref_y;

  /** draw or erase "connection" or "msg queue" line between
      sending and receiving nodes **/

  switch (windows[HTYB].opt1)
  {
   case RING:

     if (hype_num_nodes==4)   /* ring */
     {
       if(hops(0, num_nodes, 1, 0, first, second)==1){
         XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
	   ctr[first].y,ctr[second].x,ctr[second].y);
       }else{
         XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	   ctr[first].y,ctr[second].x,ctr[second].y);
       }
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)   /* ring */
     {
       if(hops(0, num_nodes, 1, 0, first, second)==1){
         XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
	   ctr[first].y,ctr[second].x,ctr[second].y);
       }else{
         XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	   ctr[first].y,ctr[second].x,ctr[second].y);
       }
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)   /* ring */
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    /** 0 sends to 1 **/
	 case 2:    /** 0 sends to 2 **/
	 case 4:    /** 0 sends to 4 **/
	 case 8:    /** 0 sends to 8 **/
	 case 19:   /** 1 sends to 3 **/
	 case 21:   /** 1 sends to 5 **/
	 case 25:   /** 1 sends to 9 **/
	 case 35:   /** 2 sends to 3 **/
	 case 38:   /** 2 sends to 6 **/
	 case 42:   /** 2 sends to 10 **/
	 case 55:   /** 3 sends to 7 **/
	 case 59:   /** 3 sends to 11 **/
	 case 69:   /** 4 sends to 5 **/
	 case 70:   /** 4 sends to 6 **/
	 case 76:   /** 4 sends to 12 **/
	 case 87:   /** 5 sends to 7 **/
	 case 93:   /** 5 sends to 13 **/
	 case 103:  /** 6 sends to 7 **/
	 case 110:  /** 6 sends to 14 **/
	 case 127:  /** 7 sends to 15 **/
	 case 137:  /** 8 sends to 9 **/
	 case 138:  /** 8 sends to 10 **/
	 case 140:  /** 8 sends to 12 **/
	 case 155:  /** 9 sends to 11 **/
	 case 157:  /** 9 sends to 13 **/
	 case 171:  /** 10 sends to 11 **/
	 case 174:  /** 10 sends to 14 **/
	 case 191:  /** 11 sends to 15 **/
	 case 205:  /** 12 sends to 13 **/
	 case 206:  /** 12 sends to 14 **/
	 case 223:  /** 13 sends to 15 **/
	 case 239:  /** 14 sends to 15 **/
	     if (abs(order[second]-order[first])==2)
	        do_arc(first,second,drawgc1,6,1,ref_x,ref_y);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 9:    /** 0 sends to 9 **/
         case 14:   /** 0 sends to 14 **/
         case 24:   /** 1 sends to 8 **/
         case 31:   /** 1 sends to 15 **/
             if ((order[first]-order[second]+16)==2)
	        do_arc(first,second,drawgc2,6,1,ref_x,ref_y);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
	     if ((order[second]-order[first])==2)
	        do_arc(first,second,drawgc2,6,1,ref_x,ref_y);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statements for ring*/

   case SQUARES:

     if (hype_num_nodes==4)   /* ring */
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1: 
	 case 2:  
	 case 7: 
	 case 11:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)   /* ring */
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1: 
	 case 2:   
	 case 4:  
	 case 11:   
	 case 13:  
	 case 19:
	 case 22:  
	 case 31:   
	 case 37: 
	 case 38:
	 case 47: 
	 case 55:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)   /* ring */
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    
	 case 4:   
	 case 19:
	 case 21:   
	 case 35:  
	 case 38: 
	 case 55:  
	 case 69:
	 case 76:   
	 case 84: 
	 case 87:
	 case 93:   
	 case 103:
	 case 110:  
	 case 127: 
	 case 137:
	 case 140:  
	 case 155:
	 case 157:  
	 case 171: 
	 case 174:
	 case 191:
	 case 205: 
	 case 223:
	 case 239:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
	       ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 2:    
             if (windows[ORDB].opt1==0)
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
	     else
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[2].x,
		  ctr[0].y, (6*rad)/5, (6*rad)/5, 90*64, 90*64);
	 case 70:   
             if (windows[ORDB].opt1==0)
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
	     else
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[4].x-
		  (3*rad)/5, ctr[4].y, (6*rad)/5, (6*rad)/5, 0*64, 90*64);
	 case 138:  
             if (windows[ORDB].opt1==0)
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
	     else
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[10].x,
		  ctr[10].y-(3*rad)/5, (6*rad)/5, (6*rad)/5, 180*64, 90*64);
	 case 206:  
             if (windows[ORDB].opt1==0)
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
	     else
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[12].x-
		  (3*rad)/5, ctr[14].y-(3*rad)/5, (6*rad)/5, (6*rad)/5, 
		  270*64, 90*64);
             break;
	 case 8:    
             if (windows[ORDB].opt1==0)
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[8].x,
		  ctr[0].y, (6*rad)/5, (6*rad)/5, 90*64, 90*64);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 25:   
             if (windows[ORDB].opt1==0)
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[1].x-
		  (3*rad)/5, ctr[1].y, (6*rad)/5, (6*rad)/5, 0*64, 90*64);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 42:   
             if (windows[ORDB].opt1==0)
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[10].x,
		  ctr[10].y-(3*rad)/5, (6*rad)/5, (6*rad)/5, 180*64, 90*64);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 59:   
             if (windows[ORDB].opt1==0)
		XDrawArc(mydisplay, windows[HYPE].window, drawgc1, ctr[3].x-
		  (3*rad)/5, ctr[11].y-(3*rad)/5, (6*rad)/5, (6*rad)/5, 
		  270*64, 90*64);
	     else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	       ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statements for ring*/

   case RING_OF_RINGS: 

     ref_x = ref.x;
     ref_y = ref.y;
     offset = 20;
	     
     if (hype_num_nodes==4) /** ring of rings **/
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8) /** ring of rings **/
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
	 case 19:   
	 case 37:   
	 case 55:   
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 4:    
	 case 13:   
	 case 31:   
	 case 22:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
           else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 2:    
	 case 11:   
	 case 38:   
	 case 47:   
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 7:
	 case 14:   
	 case 15:   
	 case 21:   
	 case 28:   
	 case 29:   
	     do_arc(first,second,drawgc2,offset,1,ref_x,ref_y);
             break;
	 case 39:   
	 case 46:   
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
	     do_arc(first,second,drawgc2,offset,1,ref_x,ref_y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16) /** ring of rings **/
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    
	 case 19:   
	 case 35:   
	 case 69:   
	 case 87:   
	 case 103:  
	 case 137:  
	 case 155:  
	 case 171:  
	 case 205:  
	 case 223:  
	 case 239:  
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 4:    
	 case 21:   
	 case 38:   
	 case 55:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
	 case 140:  
	 case 157:  
	 case 174:  
	 case 191:  
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 8:    
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	   else
	     do_ellipse2(8,0,drawgc1,1);
             break;
	 case 2:    
	   if(windows[ORDB].opt1==0)
	     do_ellipse2(2,0,drawgc1,1);
	   else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 25:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	   else
	     do_ellipse1(1,9,drawgc1,1);
             break;
	 case 70:   
	   if(windows[ORDB].opt1==0)
	     do_ellipse1(4,6,drawgc1,1);
	   else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 42:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	   else
	     do_ellipse1(10,2,drawgc1,0);
             break;
	 case 138:  
	   if(windows[ORDB].opt1==0)
	     do_ellipse1(10,8,drawgc1,0);
	   else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 59:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	   else
	     do_ellipse2(3,11,drawgc1,0);
             break;
	 case 206: 
	   if(windows[ORDB].opt1==0)
	     do_ellipse2(12,14,drawgc1,0);
	   else
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 case 3:    
	 case 18:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset+10,0,ref_x,ref_y);
	   else
            XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	 case 29:   
	 case 89:   
	 case 46:  
	 case 106:  
	 case 63:  
	 case 123:  
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	   else
	     do_arc(first,second,drawgc2,offset+10,0,ref_x,ref_y);
	     break;
	 case 71:   
	 case 86:   
	 case 139:  
	 case 154:  
	 case 207:  
	 case 222:  
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset+10,0,ref_x,ref_y);
	   else
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	     break;
	 case 12:    
	 case 72:   
	   if(windows[ORDB].opt1==0)
            XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
	     do_arc(first,second,drawgc2,offset+10,0,ref_x,ref_y);
	     break;
	 case 15:   
	 case 90:   
	 case 30:   
	 case 45:   
	 case 60:   
	 case 75:   
	 case 105:  
	 case 120:  
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
             break;
	 case 13:   
	 case 14:   
	 case 28:   
	 case 31:   
	 case 44:   
	 case 47:   
	 case 61:   
	 case 62:   
	 case 73:   
	 case 74:   
	 case 88:   
	 case 91:   
	 case 104:  
	 case 107:  
	 case 121:  
	 case 122:  
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	   else
            XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 7:   
	 case 11:   
	 case 67:   
	 case 79:   
	 case 143:   
	 case 22:   
	 case 26:   
	 case 94:   
	 case 156:  
	 case 37:  
	 case 41:  
	 case 109:  
	 case 173:  
	 case 52:  
	 case 56:  
	 case 124:  
	 case 188:  
	   if(windows[ORDB].opt1==0)
            XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
             break;
	 default:
            XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	    break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statement for ring of rings*/

   case WEB: 

     ref_x = ref.x;
     ref_y = ref.y;

     if (hype_num_nodes==4)    /*web*/
     {
       offset = 20;
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
         case 2:    
	 case 7:    
	 case 11:   
	     do_arc(first,second,drawgc1,offset,1,ref_x,ref_y);
	     break;
         default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
       }  /**ends the switch statement for value**/
     }   /**ends the statements for hype_num_nodes=4**/

     if (hype_num_nodes==8)    /*web*/
     {
       offset = 15;
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
	 case 1:    
	 case 19:   
	 case 2:    
	 case 4:    
	 case 11:   
	 case 13:   
	 case 22:   
	 case 31:   
	 case 32:   
	 case 37:   
	 case 38:   
	 case 47:   
	 case 55:   
	     do_arc(first,second,drawgc1,offset,1,ref_x,ref_y);
             break;
         default: 
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
       }   /**ends the switch statement for values**/
     }   /**ends statements for hype_num_nodes==8**/

     if (hype_num_nodes==16)    /*web*/
     {
       offset = 8;
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 1:     
	 case 35:    
	 case 87:    
	 case 70:    
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,25,1,ref_x,ref_y);
	   else
	     do_arc(first,second,drawgc1,offset,1,ref_x,ref_y);
	     break;
         case 4:     
	 case 8:     
         case 21:    
	 case 25:    
	 case 38:    
	 case 42:    
	 case 55:    
	 case 59:    
	 case 76:    
         case 93:    
	 case 110:   
	 case 127:   
	 case 140:   
	 case 157:   
	 case 174:   
	 case 191:   
	     do_arc(first,second,drawgc1,25,1,ref_x,ref_y);
	     break;
	 case 2:     
	 case 19:    
	 case 137:   
	 case 171:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,1,ref_x,ref_y);
	   else
	     do_arc(first,second,drawgc1,25,1,ref_x,ref_y);
	     break;
	 case 69:    
	 case 103:   
	 case 138:   
	 case 155:   
	 case 205:   
	 case 206:   
	 case 223:   
	 case 239:   
	     do_arc(first,second,drawgc1,offset,1,ref_x,ref_y);
             break;
         case 12:    
	     do_arc(first,second,drawgc2,6,1,ref_x,ref_y);
             break;
         case 36:    
         case 24:    
	     if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,6,1,ref_x,ref_y);
             else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	   	   ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
	     if (abs(webproc16[second]-webproc16[first])==2)
		do_arc(first,second,drawgc2,6,1,ref_x,ref_y);
             else
                XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	   	   ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
           }   /*ends switch statement for values for hype_num_nodes=16*/
       }   /**ends statements for hype_num_nodes==16**/

     break;
   
   case CUBE:
   case NESTED_CUBES: 
   case TREE:
   case CROSSHATCH: 
   case TESSERACT:
   case POLYTOPE:
   case SHUFFLE: 
   case PINWHEEL:
   case GEM:
  
     if(hops(0, num_nodes, 1, 0, first, second)==1){
       XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
         ctr[first].y,ctr[second].x,ctr[second].y);
     }else{
       XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
         ctr[first].y,ctr[second].x,ctr[second].y);
     }

       break;  /*ends case statements for cube & nested cubes*/

   case LATERAL_CUBES:
  
     ref_x = ref.x;
     ref_y = ref.y+rad;
     offset = 20;

     if (hype_num_nodes==4)  /** lateral cubes **/
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)  /** lateral cubes **/
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
	 case 2:   
	 case 11:   
	 case 38:   
	 case 47:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 1:    
	 case 19:   
	 case 37:   
	 case 55:   
	   if(windows[ORDB].opt1==0)
	     XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);

	 case 4:    
	 case 13:   
	 case 22:   
	 case 31:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
           else XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 3:    
	 case 10:   
	 case 39:   
	 case 46:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 5:    
	 case 12:   
	 case 23:   
	 case 30:   
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)  /** lateral cubes **/
     {
       offset = 14;
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 2:    
	 case 4:    
	 case 19:   
	 case 21:   
	 case 38:   
	 case 55:   
	 case 70:   
	 case 87:   
	 case 138:  
	 case 140:  
	 case 155:  
	 case 157:  
	 case 174:  
	 case 191:  
	 case 206:  
	 case 223:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 8:    
	 case 25:   
	 case 42:   
	 case 59:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
           if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
           else XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           break;

         case 1:    
	 case 35:   
	 case 69:   
	 case 103:  
	 case 137:  
	 case 171:  
	 case 205:  
	 case 239:  
           if(windows[ORDB].opt1==0)
	     XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	     break;
         case 6:    
         case 14:    
	 case 36:   
	 case 142:   
	 case 172:   
         case 23:  
         case 31:  
	 case 53:  
	 case 159:  
	 case 189:  
           if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
           else XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
         case 3:    
	 case 18:   
	 case 71:   
	 case 86:   
	 case 139:   
	 case 154:   
	 case 207:  
	 case 222:  
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	     break;

         case 7:    
         case 9:    
	 case 24:   
	 case 43:   
	 case 58:   
	 case 77:   
	 case 92:   
	 case 111:  
	 case 126:  
         case 143:  
           if(windows[ORDB].opt1==0)
	     XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else 
	     do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	     break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statements for lateral cubes */
	     
   case MESH:

     ref_x = ref.x+rad;
     ref_y = ref.y+rad;
     offset = 20;

     if (hype_num_nodes==4)   /** mesh **/
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)   /** mesh **/
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
	 case 11:   
	 case 13:   
	 case 19:   
	 case 31:   
	 case 37:   
	 case 47:   
	 case 55:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		 ctr[0].y,ctr[0].x-30,ctr[0].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		 ctr[4].y,ctr[4].x+30,ctr[4].y);
	     }
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		 ctr[0].y,ctr[0].x-30,ctr[0].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		 ctr[2].y,ctr[2].x+30,ctr[2].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }
             break;
	 case 22:   
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
	 	 ctr[2].y,ctr[2].x-30,ctr[2].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x,
	 	 ctr[6].y,ctr[6].x+30,ctr[6].y);
	     }
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
	 	 ctr[4].y,ctr[4].x-30,ctr[4].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x,
	 	 ctr[6].y,ctr[6].x+30,ctr[6].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }
             break;
         case 5:   
         case 12:  
         case 23:  
         case 30:  
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
	     do_arc(first,second,drawgc2,offset-5,0,ref_x,ref_y);
             break;
         case 3:   
         case 10:  
         case 39:  
         case 46:  
	     if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset-5,0,ref_x,ref_y);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)   /** mesh **/
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    
	 case 19:   
	 case 21:   
	 case 35:   
	 case 55:   
	 case 69:   
	 case 87:   
	 case 103:  
	 case 110:  
	 case 127:  
	 case 137:  
	 case 155:  
	 case 157:  
	 case 171:  
	 case 191:  
	 case 205:  
	 case 223:  
	 case 239:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 4:    
	 case 38:   
	 case 140:  
	 case 174:  
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[first].x - 30,ctr[first].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[second].x,
		 ctr[second].y,ctr[second].x + 30,ctr[second].y);
	     }
             break;
	 case 2:    
	 case 70:   
	 case 138:  
	 case 206:  
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[first].x - 30,ctr[first].y);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[second].x,
		 ctr[second].y,ctr[second].x + 30,ctr[second].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }
             break;
	 case 8:    
	 case 25:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
	       ctr[first].y,ctr[first].x,ctr[first].y - 30);
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[second].x,
	       ctr[second].y,ctr[second].x,ctr[second].y + 30);
             break;
	 case 76:   
	 case 93:   
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[first].x,ctr[first].y - 30);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[second].x,
		 ctr[second].y,ctr[second].x,ctr[second].y + 30);
	     }
             break;
	 case 42:   
	 case 59:   
	     if(windows[ORDB].opt1==0){
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[first].x,ctr[first].y - 30);
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[second].x,
		 ctr[second].y,ctr[second].x,ctr[second].y + 30);
	     }else{
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     }
             break;
         case 5:    
         case 20:   
         case 27:   
         case 78:   
         case 95:   
         case 39:   
         case 54:   
         case 57:   
         case 108:  
         case 125:  
         case 141:  
         case 156:  
         case 175:  
         case 190:  
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
	     do_arc(first,second,drawgc2,offset-5,0,ref_x,ref_y);
             break;

         case 3:    
         case 18:   
         case 29:   
         case 46:   
         case 63:   
         case 71:   
         case 86:   
         case 89:   
         case 106:  
         case 123:  
         case 139:  
         case 154:  
         case 207:  
         case 222:  
	   if(windows[ORDB].opt1==0)
	     do_arc(first,second,drawgc2,offset-5,0,ref_x,ref_y);
           else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;

         case 10:   
         case 12:   
         case 15:   
         case 40:   
         case 45:   
         case 60:   
         case 90:   
         case 72:   
         case 75:   
         case 105:  
         case 120:  
	     do_arc(first,second,drawgc2,offset-5,0,ref_x,ref_y);
             break;
         case 30:   
	     do_arc(first,second,drawgc2,offset-5,0,ref.x+rad,0);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statement for mesh*/ 

   case LINEAR: 

     ref_x = ref.x;
     ref_y = ref.y+rad;
     offset = 35;

     if (hype_num_nodes==4)   /*linear*/
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
             do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
	     break;
	 default:
             do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)   /*linear*/
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
	 case 2:    
	 case 4:    
	 case 11:   
	 case 13:   
	 case 19:   
	 case 22:   
	 case 31:   
	 case 37:   
	 case 38:   
	 case 47:   
	 case 55:   
             do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 default:
             do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
             break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)   /*linear*/ 
     {
       ref_x = ref.x;
       ref_y = ref.y;
       offset = 32;
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 8:    
	 case 25:   
	 case 42:   
	 case 59:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
         case 1:    
	 case 2:    
	 case 4:    
	 case 19:   
	 case 21:   
	 case 35:   
	 case 38:   
	 case 55:   
	 case 69:   
	 case 70:   
	 case 87:   
	 case 103:  
	 case 137:  
	 case 138:  
	 case 140:  
	 case 155:  
	 case 157:  
	 case 171:  
	 case 174:  
	 case 191:  
	 case 205:  
	 case 206:  
	 case 223:  
	 case 239:  
             do_arc(first,second,drawgc1,offset,0,ref_x,ref_y);
             break;
	 default:
             if (ctr[first].y == ctr[second].y)
                 do_arc(first,second,drawgc2,offset,0,ref_x,ref_y);
             else
              XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
	       ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/

       break;  /*ends case statement for linear*/ 

   case TORUS:
  
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
	   draw_torus_arc(first, second, drawgc1);
	   break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
	 case 2:    
	 case 4:    
	 case 11:   
	 case 13:   
	 case 22:   
	 case 19:   
	 case 31:   
	 case 38:   
	 case 37:   
	 case 47:   
	 case 55:   
	   draw_torus_arc(first, second, drawgc1);
	   break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    
	 case 2:    
	 case 4:    
	 case 19:   
	 case 21:   
	 case 35:   
	 case 38:   
	 case 55:   
	 case 69:   
	 case 70:   
	 case 87:   
	 case 103:  
	 case 137:  
	 case 138:  
	 case 140:  
	 case 155:  
	 case 157:  
	 case 171:  
	 case 174:  
	 case 191:  
	 case 206:  
	 case 205:  
	 case 223:  
	 case 239:  
	   draw_torus_arc(first, second, drawgc1);
	   break;

	 case 8:    
	 case 25:   
	 case 42:   
	 case 59:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for torus*/

   case ROSETTE: 
      if(ref.x<ref.y) buf=(ref.x)/2;
      else buf=(ref.y)/2;
  
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		10+ref.y,2*buf, 2*buf, 180*64, 180*64);
             break;
	 case 2:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x-buf,
	       ctr[2].y, 2*buf, 2*buf, 90*64, 180*64);
             break;
	 case 7:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x,
	       ctr[3].y,2*buf, 2*buf, 90*64, -180*64);
             break;
	 case 11:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[2].y-buf,2*buf, 2*buf, 0*64, 180*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
	 	 10+ref.y,2*buf, 2*buf, 180*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x-buf,
	         ctr[2].y, 2*buf, 2*buf, 90*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
	 	 10+ref.y,2*buf, 2*buf, 180*64, 180*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x-buf,
	         ctr[4].y, 2*buf, 2*buf, 90*64, 180*64);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		 ctr[2].y-buf,2*buf, 2*buf, 0*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 11:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	         ctr[3].y,2*buf, 2*buf, 90*64, -180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[3].x+
	         ctr[1].x)/2-buf, (ctr[3].y+ctr[1].y)/2-buf,
		 2*buf, 2*buf, 135*64, 180*64);
             break;
	 case 22:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	         ctr[6].y,2*buf, 2*buf, 90*64, -180*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[6].x+
		 ctr[4].x)/2-buf, (ctr[6].y+ctr[4].y)/2-buf,
		 2*buf, 2*buf, 45*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		 ctr[4].y-buf,2*buf, 2*buf, 0*64, 180*64);
             break;
	 case 37:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[5].x+
		 ctr[4].x)/2-buf, (ctr[5].y+ctr[4].y)/2-buf, 
		 2*buf, 2*buf, 135*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 31:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[3].x)/2-buf, (ctr[7].y+ctr[3].y)/2-buf,
		 2*buf, 2*buf, 225*64, 180*64); 
	     break;
	 case 47:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[5].x)/2-buf, (ctr[7].y+ctr[5].y)/2-buf,
		 2*buf, 2*buf, 225*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[5].x)/2-buf, (ctr[7].y+ctr[5].y)/2-buf,
		 2*buf, 2*buf, 315*64, 180*64);
             break;
	 case 55:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[6].x)/2-buf, (ctr[7].y+ctr[6].y)/2-buf,
		 2*buf, 2*buf, 315*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 13:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[5].x+
		 ctr[1].x)/2-buf, (ctr[5].y+ctr[1].y)/2-buf,
		 2*buf, 2*buf, 45*64, 180*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
         case 1:    
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
	 	 10+ref.y,2*buf, 2*buf, 180*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x-buf,
	         ctr[2].y, 2*buf, 2*buf, 90*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
	 	 10+ref.y,2*buf, 2*buf, 180*64, 180*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x-buf,
	         ctr[4].y, 2*buf, 2*buf, 90*64, 180*64);
             break;
	 case 35:  
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		 ctr[2].y-buf,2*buf, 2*buf, 0*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	         ctr[3].y,2*buf, 2*buf, 90*64, -180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[3].x+
	         ctr[1].x)/2-buf, (ctr[3].y+ctr[1].y)/2-buf,
		 2*buf, 2*buf, 135*64, 180*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	         ctr[6].y,2*buf, 2*buf, 90*64, -180*64);
             break;
	 case 70:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[6].x+
		 ctr[4].x)/2-buf, (ctr[6].y+ctr[4].y)/2-buf,
		 2*buf, 2*buf, 45*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		 ctr[4].y-buf,2*buf, 2*buf, 0*64, 180*64);
             break;
	 case 69:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[5].x+
		 ctr[4].x)/2-buf, (ctr[5].y+ctr[4].y)/2-buf, 
		 2*buf, 2*buf, 135*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 55:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[3].x)/2-buf, (ctr[7].y+ctr[3].y)/2-buf,
		 2*buf, 2*buf, 225*64, 180*64); 
	     break;
	 case 87:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[5].x)/2-buf, (ctr[7].y+ctr[5].y)/2-buf,
		 2*buf, 2*buf, 225*64, 180*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[5].x)/2-buf, (ctr[7].y+ctr[5].y)/2-buf,
		 2*buf, 2*buf, 315*64, 180*64);
             break;
	 case 103:  
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[7].x+
		 ctr[6].x)/2-buf, (ctr[7].y+ctr[6].y)/2-buf,
		 2*buf, 2*buf, 315*64, 180*64);
	     else
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 21:   
	     if(windows[ORDB].opt1==0)
               XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		 ctr[first].y,ctr[second].x,ctr[second].y);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,(ctr[5].x+
		 ctr[1].x)/2-buf, (ctr[5].y+ctr[1].y)/2-buf,
		 2*buf, 2*buf, 45*64, 180*64);
             break;
	 case 138:  
	 case 155:  
	 case 205:  
	 case 239:  
	 case 254: 
	 case 137:  
	 case 140:  
	 case 157:  
	 case 171:  
	 case 174:  
	 case 191:  
	 case 206:  
	 case 223:  
	 case 8:    
	 case 25:   
	 case 42:   
	 case 59:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for octagon*/


   case QUATREFOIL:
  
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		ctr[0].y-(ctr[1].x-ctr[0].x)/2,ctr[1].x-ctr[0].x,
		ctr[1].x-ctr[0].x, 180*64, 180*64);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x-
	       (ctr[0].y-ctr[1].y)/2, ctr[1].y,ctr[0].y-
	       ctr[1].y, ctr[0].y-ctr[1].y, 90*64, 180*64);
             break;
	 case 2:    
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x-
	       (ctr[0].y-ctr[2].y)/2, ctr[2].y,ctr[0].y-
	       ctr[2].y, ctr[0].y-ctr[2].y, 90*64, 180*64);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		ctr[0].y-(ctr[2].x-ctr[0].x)/2,ctr[2].x-ctr[0].x,
		ctr[2].x-ctr[0].x, 180*64, 180*64);
             break;
	 case 7:    
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x-
	       (ctr[1].y-ctr[3].y)/2, ctr[3].y,ctr[1].y-
	       ctr[3].y, ctr[1].y-ctr[3].y, 90*64, -180*64);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[1].y-(ctr[3].x-ctr[1].x)/2,ctr[3].x-ctr[1].x,
		ctr[3].x-ctr[1].x, 0*64, 180*64);
             break;
	 case 11:   
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[2].y-(ctr[3].x-ctr[2].x)/2,ctr[3].x-ctr[2].x,
		ctr[3].x-ctr[2].x, 0*64, 180*64);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x-
	       (ctr[2].y-ctr[3].y)/2, ctr[3].y,ctr[2].y-
	       ctr[3].y, ctr[2].y-ctr[3].y, 90*64, -180*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
	 case 2:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x-
	       (ctr[0].y-ctr[2].y)/2, ctr[2].y,ctr[0].y-
	       ctr[2].y, ctr[0].y-ctr[2].y, 90*64, 180*64);
             break;
	 case 38:   
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x-
	       (ctr[4].y-ctr[6].y)/2, ctr[6].y,ctr[4].y-
	       ctr[6].y, ctr[4].y-ctr[6].y, 90*64, -180*64);
             break;
	 case 11:   
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x-
	       (ctr[1].y-ctr[3].y)/2, ctr[3].y,ctr[1].y-
	       ctr[3].y, ctr[1].y-ctr[3].y, 90*64, -180*64);
           else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 13:   
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[1].y-(ctr[5].x-ctr[1].x)/2,ctr[5].x-
		ctr[1].x, ctr[5].x-ctr[1].x, 180*64, 180*64);
             break;
	 case 37:   
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[4].y-(ctr[5].x-ctr[4].x)/2,ctr[5].x-
		ctr[4].x, ctr[5].x-ctr[4].x, 180*64, 180*64);
           else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 31:   
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
           else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x,
		ctr[3].y-(ctr[7].x-ctr[3].x)/2,ctr[7].x-
		ctr[3].x, ctr[7].x-ctr[3].x, 180*64, -180*64);
             break;
	 case 55:   
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x,
		ctr[6].y-(ctr[7].x-ctr[6].x)/2,ctr[7].x-
		ctr[6].x, ctr[7].x-ctr[6].x, 180*64, -180*64);
           else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 1:    
	 case 4:    
	 case 22:   
	 case 19:   
	 case 47:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 138:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[10].x-
	       (ctr[8].y-ctr[10].y)/2, ctr[10].y,
	       ctr[8].y-ctr[10].y, ctr[8].y-ctr[10].y, 
	       90*64, 180*64);
             break;
	 case 206:  
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x-
	       (ctr[12].y-ctr[14].y)/2, ctr[14].y,
	       ctr[12].y-ctr[14].y, ctr[12].y-ctr[14].y, 
	       90*64, -180*64);
             break;
	 case 155:  
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x-
	       (ctr[9].y-ctr[11].y)/2, ctr[11].y,
	       ctr[9].y-ctr[11].y, ctr[9].y-ctr[11].y, 
	       90*64, -180*64);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 157:  
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[9].x,
		ctr[9].y-(ctr[13].x-ctr[9].x)/2,
		ctr[13].x-ctr[9].x, ctr[13].x-ctr[9].x, 
		180*64, 180*64);
             break;
	 case 205:  
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[12].x,
		ctr[12].y-(ctr[13].x-ctr[12].x)/2,
		ctr[13].x-ctr[12].x, ctr[13].x-ctr[12].x, 
		180*64, 180*64);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 191:  
	   if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	   else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[11].y-(ctr[15].x-ctr[11].x)/2,
		ctr[15].x-ctr[11].x, ctr[15].x-ctr[11].x, 
		180*64, -180*64);
             break;
	 case 239:  
	   if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x,
		ctr[14].y-(ctr[15].x-ctr[14].x)/2,
		ctr[15].x-ctr[14].x, ctr[15].x-ctr[14].x, 
		180*64, -180*64);
	   else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
         case 1:    
	 case 2:    
	 case 4:    
	 case 19:   
	 case 21:   
	 case 35:   
	 case 38:   
	 case 55:   
	 case 69:   
	 case 70:   
	 case 87:   
	 case 103:  
	 case 137:  
	 case 140:  
	 case 171:  
	 case 174:  
	 case 223:  
	 case 8:    
	 case 25:   
	 case 42:   
	 case 59:   
	 case 76:   
	 case 93:   
	 case 110:  
	 case 127:  
	 case 179:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for octagon*/

   case CIRCLES:
  
     if(ref.x<ref.y){
       buf=ref.x;
     }else{
       buf=ref.y;
     }
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-(2*buf)/5+10,
		ref.y-(2*buf)/5+10,(4*buf)/5, (4*buf)/5, 225*64, 89*64);
             break;
	 case 2:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-(2*buf)/5+10,
		ref.y-(2*buf)/5+10,(4*buf)/5, (4*buf)/5, 135*64, 89*64);
             break;
	 case 7:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-(2*buf)/5+10,
		ref.y-(2*buf)/5+10,(4*buf)/5, (4*buf)/5, 315*64, 89*64);
             break;
	 case 11:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-(2*buf)/5+10,
		ref.y-(2*buf)/5+10,(4*buf)/5, (4*buf)/5, 45*64, 89*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 225*64, 90*64);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y-(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 135*64, 90*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 135*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y-(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 225*64, 89*64);
             break;
	 case 11:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x+
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y-(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 315*64, 90*64);
             break;
	 case 13:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 315*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x+
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y-(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 225*64, 89*64);
             break;
	 case 37:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 45*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 225*64, 90*64);
             break;
             break;
	 case 22:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 135*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y+(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 45*64, 89*64);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 225*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 45*64, 90*64);
             break;
	 case 55:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 45*64, 90*64);
             break;
	 case 31:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 315*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x+
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y+(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 45*64, 89*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x-
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y+(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 135*64, 90*64);
             break;
	 case 47:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ref.x+
		(int)(0.7071*(double)(3*buf)/10)-(3*buf)/5+10, 
		ref.y+(int)(0.7071*(double)(3*buf)/10)-
		(3*buf)/5+10,(6*buf)/5, (6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y
		-(3*buf)/10,(3*buf)/5, (3*buf)/5, 315*64, 90*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 138:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
             break;
	 case 155:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
             break;
	 case 205:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
             break;
	 case 239:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
             break;
         case 1:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
             break;
	 case 21:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
             break;
	 case 35:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
             break;
	 case 55:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
             break;
	 case 69:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
             break;
	 case 70:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
             break;
	 case 87:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
             break;
	 case 103:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
             break;
	 case 137:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
             break;
	 case 140:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
             break;
	 case 157:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
             break;
	 case 171:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 225*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 45*64, 89*64);
             break;
	 case 174:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
             break;
	 case 191:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
             break;
	 case 206:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 135*64, 89*64);
             break;
	 case 223:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 45*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x+
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10, 10+ref.y-
		(int)(0.7107*(double)(6*buf)/10)-(3*buf)/10,(3*buf)/5, 
		(3*buf)/5, 315*64, 89*64);
             break;
	 case 8:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
             break;
	 case 25:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
             break;
	 case 42:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
             break;
	 case 59:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
             break;
	 case 76:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
             break;
	 case 93:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 135*64, 89*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[6].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
             break;
	 case 110:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[9].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
             break;
	 case 127:  
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,pts[6].x-
		(3*buf)/5+10, pts[9].y-(3*buf)/5+10,(6*buf)/5, 
		(6*buf)/5, 315*64, 89*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for octagon*/

   case ORBITS:
  
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1, ctr[1].x,
		ctr[1].y-rad/4, rad/2, rad/2, 180*64, 90*64);
             break;
	 case 2:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1, ctr[0].x-
	       (3*rad)/4, ctr[2].y-(3*rad)/4, (3*rad)/2, (3*rad)/2, 
	       270*64, 90*64);
             break;
	 case 7:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1, ctr[1].x,
		ctr[3].y, (3*rad)/2, (3*rad)/2, 90*64, 90*64);
             break;
	 case 11:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x-rad/4,
		ctr[3].y, rad/2, rad/2, 0*64, 90*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
         case 1:    
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x, 
		 ctr[1].y-rad/3, (2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-rad, 
		 15+ref.y-(4*rad)/3, 2*rad, 2*rad, 15840, 2880);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x-
		rad, ctr[2].y-rad,2*rad, 2*rad, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x, ctr[2].y-
		rad,2*rad, 2*rad, 180*64, 90*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-rad, 
		 15+ref.y-(4*rad)/3, 2*rad, 2*rad, 15840, 2880);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x-
		rad/3, ctr[4].y-rad/3, (2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 11:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,2*rad, 2*rad, 90*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x, 
		 ctr[3].y-rad/3, (2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 13:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,5+ref.x-
		 (2*rad)/3, 10+ref.y-rad, 2*rad, 2*rad, 10080, 2880);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x-rad, 
	       ctr[5].y-rad,2*rad, 2*rad, 270*64, 90*64);
             break;
	 case 37:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x, 
	       ctr[5].y-rad,2*rad, 2*rad, 180*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,15+ref.x-
		 (4*rad)/3, 10+ref.y-rad, 2*rad, 2*rad, -1440, 2880);
             break;
             break;
	 case 22:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,15+ref.x-
		 (4*rad)/3, 10+ref.y-rad, 2*rad, 2*rad, -1440, 2880);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x-rad/3,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,5+ref.x-
		 (2*rad)/3, 10+ref.y-rad, 2*rad, 2*rad, 10080, 2880);
             break;
	 case 55:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x-rad, 
	         ctr[7].y,2*rad, 2*rad, 0*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-rad, 
		 5+ref.y-(2*rad)/3, 2*rad, 2*rad, 4320, 2880);
             break;
	 case 31:   
	     if(windows[ORDB].opt1==0)
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-rad, 
		 5+ref.y-(2*rad)/3, 2*rad, 2*rad, 4320, 2880);
	     else
              XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x,
		ctr[7].y,2*rad, 2*rad, 90*64, 90*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x-
		rad/3, ctr[6].y-rad/3, (2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
               XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x-rad, 
	         ctr[6].y,2*rad, 2*rad, 0*64, 90*64);
             break;
	 case 47:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x,
		ctr[7].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x-rad/3,
		ctr[7].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 138:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[0].x,
		ctr[2].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 155:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[9].x,
		ctr[11].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 205:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x,
		ctr[12].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[15].y, 2*rad, 2*rad, 180*64, 90*64);
             break;
	 case 239:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x,
		ctr[12].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[15].y, 2*rad, 2*rad, 0*64, 90*64);
             break;
         case 1:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[12].y, 2*rad, 2*rad, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[0].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 19:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 21:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x,
		ctr[7].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 35:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x,
		ctr[3].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x,
		ctr[6].y-rad, 2*rad, 2*rad, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 55:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 69:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x,
		ctr[1].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 70:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x-rad,
		ctr[6].y-rad, 2*rad, 2*rad, 270*64, 90*64);
             break;
	 case 87:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x,
		ctr[7].y, 2*rad, 2*rad, 90*64, 90*64);
             break;
	 case 103:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x,
		ctr[7].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 case 137:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[9].x,
		ctr[9].y-rad, 2*rad, 2*rad, 180*64, 90*64);
             break;
	 case 140:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[12].y, 2*rad, 2*rad, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[0].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 157:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[15].x,
		ctr[13].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 171:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x-rad,
		ctr[11].y, 2*rad, 2*rad, 0*64, 90*64);
             break;
	 case 174:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x-rad,
		ctr[14].y, 2*rad, 2*rad, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
             break;
	 case 191:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
             break;
	 case 206:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x,
		ctr[12].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[15].y, 2*rad, 2*rad, 270*64, 90*64);
             break;
	 case 223:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[14].x,
		ctr[12].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[15].y, 2*rad, 2*rad, 90*64, 90*64);
             break;
	 case 8:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[12].y, 2*rad, 2*rad, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[0].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 case 25:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[1].x-rad,
		ctr[9].y-rad, 2*rad, 2*rad, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 case 42:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[3].x,
		ctr[11].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 59:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 270*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 76:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[12].y, 2*rad, 2*rad, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[4].x,
		ctr[0].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 93:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[5].x,
		ctr[13].y, 2*rad, 2*rad, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[13].x,
		ctr[9].y,(2*rad)/3, (2*rad)/3, 180*64, 90*64);
             break;
	 case 110:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[6].x,
		ctr[14].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[2].x,
		ctr[6].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 case 127:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[7].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 90*64, 90*64);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,ctr[11].x,
		ctr[15].y,(2*rad)/3, (2*rad)/3, 0*64, 90*64);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for octagon*/

   case GRID: 
  
     if (hype_num_nodes==4) 
     {
       value = 4*first + second;
       switch (value)
       {
	 case 0:
	 case 5:
	 case 10:
	 case 15:
	     break;
         case 1:    
	 case 2:    
	 case 7:    
	 case 11:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=4*/
     }   /*ends if statement for hype_num_nodes=4*/

     if (hype_num_nodes==8)
     {
       if (ref.x<2*ref.y) buf=ref.x/5;
       else buf=(2*ref.y)/5;
       value = 8*first + second;
       switch (value)
       {
	 case 0:
	 case 9:
	 case 18:
	 case 27:
	 case 36:
	 case 45:
	 case 54:
	 case 63:
	     break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
	       (17*buf)/4, 10+ref.y-(51*buf)/8,(17*buf)/2, (17*buf)/2, 
	       225*64, 89*64);
             break;
	 case 22:   
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-(17*buf)/4, 
	       10+ref.y-(17*buf)/8,(17*buf)/2, (17*buf)/2, 45*64, 89*64);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
	       (17*buf)/4, 10+ref.y-(51*buf)/8,(17*buf)/2, (17*buf)/2, 
	       225*64, 89*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-
	       (17*buf)/4, 10+ref.y-(17*buf)/8,(17*buf)/2, (17*buf)/2, 
	       45*64, 89*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 11:   
	 case 37:   
	 case 55:   
         case 1:    
	 case 13:   
	 case 19:   
	 case 31:   
	 case 47:   
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=8*/
     }   /*ends if statement for hype_num_nodes=8*/

     if (hype_num_nodes==16)
     {
       if (ref.x<ref.y) buf=ref.x/5;
       else buf=ref.y/5;
       value = 16*first + second;
       switch (value)
       {
	 case 0:
	 case 17:
	 case 34:
	 case 51:
	 case 68:
	 case 85:
	 case 102:
	 case 119:
	 case 136:
	 case 153:
	 case 170:
	 case 187:
	 case 204:
	 case 221:
	 case 238:
	 case 255:
	     break;
	 case 8:    
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-4*buf,
	      10+ref.y-5*buf, 10*buf, 10*buf, 143*64, 74*64);
             break;
	 case 4:    
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-6*buf, 10*buf, 10*buf, 233*64, 74*64);
             break;
	 case 76:   
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-6*buf,
	      10+ref.y-5*buf, 10*buf, 10*buf, 323*64, 74*64);
             break;
	 case 140:  
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-4*buf, 10*buf, 10*buf, 53*64, 74*64);
             break;
	 case 2:    
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-6*buf, 10*buf, 10*buf, 233*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 42:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-6*buf,
	      10+ref.y-5*buf, 10*buf, 10*buf, 323*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 25:   
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-10*buf,
	      10+ref.y-5*buf, 10*buf, 10*buf, 323*64, 74*64);
             break;
	 case 93:   
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	      10+ref.y-5*buf, 10*buf, 10*buf, 143*64, 74*64);
             break;
	 case 59:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x,
	      10+ref.y-5*buf, 10*buf, 10*buf, 143*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 174:  
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-10*buf, 10*buf, 10*buf, 233*64, 74*64);
             break;
	 case 206:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-10*buf, 10*buf, 10*buf, 233*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 38:   
	     if(windows[ORDB].opt1==0)
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     else
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y, 10*buf, 10*buf, 53*64, 74*64);
             break;
	 case 70:   
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y, 10*buf, 10*buf, 53*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 138:  
	     if(windows[ORDB].opt1==0)
             XDrawArc(mydisplay,windows[HYPE].window,drawgc1,10+ref.x-5*buf,
	      10+ref.y-4*buf, 10*buf, 10*buf, 53*64, 74*64);
	     else
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 case 155:  
	 case 205:  
	 case 239:  
         case 1:    
	 case 19:   
	 case 21:   
	 case 35:   
	 case 55:   
	 case 69:   
	 case 87:   
	 case 103:  
	 case 137:  
	 case 157:  
	 case 171:  
	 case 191:  
	 case 223:  
	 case 110:  
	 case 127:  
             XDrawLine(mydisplay,windows[HYPE].window,drawgc1,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
             break;
	 default:
             XDrawLine(mydisplay,windows[HYPE].window,drawgc2,ctr[first].x,
		ctr[first].y,ctr[second].x,ctr[second].y);
	     break;
       }  /*ends switch statement for hype_num_nodes=16*/
     }   /*ends if statement for hype_num_nodes=16*/
       break;  /*ends case statements for octagon*/


  }  /*Ends the switch statement for windows[HTYB].opt1 */

}   /*Ends the draw_connection*/

draw_torus_arc(first, second, gc)
 int first;
 int second;
 GC gc;
{
  int val;

  switch(hype_num_nodes){
    case 4:
      val=4*first+second;
      if(!windows[ORDB].opt1){
        switch(val)
        {
	  case 1:
	  case 11:
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[second].x, ctr[second].y);
	    break;

          case 2:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-ref.x/9,
	      ctr[first].y, (2*ref.x)/9, (2*ref.y)/9, 
	      90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[second].y, ctr[second].x, ctr[second].y);
	    break;

          case 7:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[second].y);
	    break;
        }
      }else{
        switch(val)
        {
          case 1:
	    if(hypenode1==first&&hypenode2==second){
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
	      ctr[second].y, ctr[second].x+(2*ref.x)/9, ctr[second].y);
	    }else{
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[second].y, ctr[second].x, ctr[second].y);
	    }
	    break;

          case 2:
	    if(hypenode1==first&&hypenode2==second){
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
	      ctr[first].y, ctr[second].x, ctr[second].y);
	    }else{
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y+ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[first].x, ctr[second].y+ (2*ref.y)/9);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
	      ctr[second].y, ctr[second].x, ctr[second].y+ (2*ref.y)/9);
	    }
	    break;

          case 7:
	    if(hypenode1==first&&hypenode2==second){
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y-(3*ref.y)/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
	      ctr[first].y-(2*ref.y)/9, ctr[second].x, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y-(2*ref.y)/9, ctr[first].x, ctr[first].y);
	    }else{
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[second].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[first].x, ctr[second].y);
	    }
	    break;

          case 11:
	    if(hypenode1==first&&hypenode2==second){
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[second].x, ctr[first].y);
	    }else{
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      (3*ref.x)/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
	      ctr[second].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
	      ctr[first].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[first].y);
	    }
	    break;
        }
      }
      break;

    case 8:
      val=8*first+second;
      if(!windows[ORDB].opt1){
        switch(val)
        {
	  case 1:
	  case 19:
	  case 37:
	  case 55:
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[second].x, ctr[second].y);
	  break;
	  case 2:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y, ctr[second].x, ctr[second].y);
	  break;

	  case 13:
	  case 4:
	    if(hypenode1==first&&hypenode2==second){
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y-ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, 180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	        ctr[first].y, ctr[second].x, ctr[second].y);
	    }else{
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[second].y+ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, -180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[first].x, 
	        ctr[first].y+(6*ref.y)/9);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
                ctr[second].y, ctr[second].x, ctr[second].y+
	        (2*ref.y)/9);
	    }
	  break;

	  case 11:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[second].y);
	  break;

	  case 31:
	  case 22:
	    if(hypenode1==first&&hypenode2==second){
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y-(3*ref.y)/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, 180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	        ctr[second].y, ctr[second].x, 
	        ctr[second].y-(6*ref.y)/9);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
                ctr[first].y, ctr[first].x, ctr[first].y-
	        (2*ref.y)/9);
	    }else{
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[second].y-ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, -180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[first].x, ctr[second].y);
	    }
	  break;

  	  case 38:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      (3*ref.x)/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x-(6*ref.x)/9, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[first].y);
	  break;

	  case 47:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[first].y);
	  break;

        }
      }else{
        switch(val)
        {
	  case 4:
	  case 13:
	  case 22:
	  case 31:
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[second].x, ctr[second].y);
	  break;
	  case 1:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y, ctr[second].x, ctr[second].y);
	  break;

	  case 2:
	  case 38:
	    if(hypenode1==first&&hypenode2==second){
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y-ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, 180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	        ctr[first].y, ctr[second].x, ctr[second].y);
	    }else{
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[second].y+ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, -180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[first].x, 
	        ctr[first].y+(6*ref.y)/9);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
                ctr[second].y, ctr[second].x, ctr[second].y+
	        (2*ref.y)/9);
	    }
	  break;

	  case 37:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[second].y);
	  break;

	  case 11:
	  case 47:
	    if(hypenode1==first&&hypenode2==second){
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y-(3*ref.y)/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, 180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	        ctr[second].y, ctr[second].x, 
	        ctr[second].y-(6*ref.y)/9);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
                ctr[first].y, ctr[first].x, ctr[first].y-
	        (2*ref.y)/9);
	    }else{
              XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[second].y-ref.y/9, (2*ref.x)/9, 
	        (2*ref.y)/9, 0, -180*64);
              XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	        ctr[first].y, ctr[first].x, ctr[second].y);
	    }
	  break;

	  case 55:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[first].y);
	  break;

  	  case 19:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      (3*ref.x)/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x-(6*ref.x)/9, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[first].y);
	  break;

        }
      }
      break;

    case 16:
      val=16*first+second;
      if(!windows[ORDB].opt1){
        switch(val)
        {
	  case 1:
	  case 35:
	  case 69:
	  case 103:
	  case 137:
	  case 171:
	  case 205:
	  case 239:
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[second].y);
	  break;

	  case 2:
	  case 138:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-ref.x/9, 
	      ctr[first].y, (2*ref.x)/9, (2*ref.y)/9, 
	      90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y, ctr[second].x, ctr[second].y);
	  break;

	  case 4:
	  case 21:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[first].y, ctr[second].x, ctr[second].y);
	  break;

	  case 19:
	  case 155:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[second].y);
	  break;

	  case 38:
	  case 55:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y-(3*ref.y)/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x, 
	      ctr[second].y-(6*ref.y)/9);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x, ctr[first].y-
	      (2*ref.y)/9);
	  break;

  	  case 70:
	  case 206:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      (3*ref.x)/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x-(6*ref.x)/9, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[first].y);
	  break;

	  case 87:
	  case 223:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[first].y);
	  break;

	  case 140:
	  case 157:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y+ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[first].x, 
	      ctr[second].y+(2*ref.y)/9);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x, ctr[second].y+
	      (2*ref.y)/9);
	  break;

	  case 174:
	  case 191:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[first].x, ctr[second].y);
  	  break;
        }
      }else{
        switch(val)
        {
	  case 4:
	  case 21:
	  case 38:
	  case 55:
	  case 140:
	  case 157:
	  case 174:
	  case 191:
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[second].y);
	  break;

	  case 1:
	  case 137:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y, ctr[second].x, ctr[second].y);
	  break;

	  case 2:
	  case 70:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[first].y, ctr[second].x, ctr[second].y);
	  break;

	  case 69:
	  case 205:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x+
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[first].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x+(2*ref.x)/9, 
	      ctr[second].y);
	  break;

	  case 19:
	  case 87:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y-(3*ref.y)/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x, 
	      ctr[second].y-(6*ref.y)/9);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x, ctr[first].y-
	      (2*ref.y)/9);
	  break;

  	  case 35:
	  case 171:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x-
	      (3*ref.x)/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, 180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x, 
	      ctr[second].y, ctr[second].x-(6*ref.x)/9, 
	      ctr[second].y);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x,
              ctr[first].y, ctr[first].x-(2*ref.x)/9, 
	      ctr[first].y);
	  break;

	  case 103:
	  case 239:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[second].x-
	      ref.x/9, ctr[first].y, (2*ref.x)/9, 
	      (2*ref.y)/9, 90*64, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[second].x, ctr[first].y);
	  break;

	  case 138:
	  case 206:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y+ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[first].x, 
	      ctr[second].y+(2*ref.y)/9);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[second].x,
              ctr[second].y, ctr[second].x, ctr[second].y+
	      (2*ref.y)/9);
	  break;

	  case 155:
	  case 223:
            XDrawArc(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[second].y-ref.y/9, (2*ref.x)/9, 
	      (2*ref.y)/9, 0, -180*64);
            XDrawLine(mydisplay, windows[HYPE].window, gc, ctr[first].x, 
	      ctr[first].y, ctr[first].x, ctr[second].y);
  	  break;
        }
      }
      break;
  }
}

/****************************************************
 * Procedure to calculate and draw or erase an arc. *
 ****************************************************/

do_arc(first,second,gc,offset,inscribe,ref_x,ref_y)
  int first, second, offset, inscribe, ref_x, ref_y;
  GC gc;
{
  int point,width,hght,angle1,angle2;
  XPoint top;
  double bisectpt_x,bisectpt_y,circle_ctr_x,circle_ctr_y;
  double dist_to_arc,dist_btwn_pts,dist_of_bisect,slope,conv,arg;
  double radius,circle_ctr_x1,circle_ctr_y1,dist1;
  double circle_ctr_x2,circle_ctr_y2,dist2;

  conv = 180.0/PI;

  bisectpt_x = (ctr[first].x + ctr[second].x)/2.0;
  bisectpt_y = (ctr[first].y + ctr[second].y)/2.0;
  dist_btwn_pts = (sqrt((double)(ctr[first].x-ctr[second].x)*
		     (ctr[first].x-ctr[second].x)
		   + (ctr[first].y-ctr[second].y)*
		     (ctr[first].y-ctr[second].y)))/2.0;
  dist_to_arc = dist_btwn_pts*2.0*(double)offset/100.0;
  dist_of_bisect = (dist_btwn_pts*dist_btwn_pts-dist_to_arc*dist_to_arc)/
					  (2.0*dist_to_arc);
  radius = dist_to_arc + dist_of_bisect;
  width = 2.0*radius;
  hght = width;
  angle2 = conv*2*atan(dist_btwn_pts/dist_of_bisect);
  if (ctr[first].y == ctr[second].y)
  {
   circle_ctr_x1 = bisectpt_x;
   circle_ctr_y1 = bisectpt_y+dist_of_bisect;
   dist1 = sqrt((circle_ctr_x1-ref_x)*(circle_ctr_x1-ref_x)+
 	       (circle_ctr_y1-ref_y)*(circle_ctr_y1-ref_y));
   circle_ctr_x2 = bisectpt_x;
   circle_ctr_y2 = bisectpt_y-dist_of_bisect;
   dist2 = sqrt((circle_ctr_x2-ref_x)*(circle_ctr_x2-ref_x)+
 	       (circle_ctr_y2-ref_y)*(circle_ctr_y2-ref_y));
  }
  else
  {
   slope =(-1.0)*(double)(ctr[second].x-ctr[first].x)/
		(double)(ctr[second].y-ctr[first].y);
   circle_ctr_x1 = bisectpt_x+(dist_of_bisect/sqrt(1.0+slope*slope));
   circle_ctr_y1 = bisectpt_y+slope*(dist_of_bisect/sqrt(1.0+slope*slope));
   dist1 = sqrt((circle_ctr_x1-ref_x)*(circle_ctr_x1-ref_x)+
 	       (circle_ctr_y1-ref_y)*(circle_ctr_y1-ref_y));
 
   circle_ctr_x2 = bisectpt_x-(dist_of_bisect/sqrt(1.0+slope*slope));
   circle_ctr_y2 = bisectpt_y-slope*(dist_of_bisect/sqrt(1.0+slope*slope));
   dist2 = sqrt((circle_ctr_x2-ref_x)*(circle_ctr_x2-ref_x)+
 	       (circle_ctr_y2-ref_y)*(circle_ctr_y2-ref_y));
  }
  /*inscribe = 0 when the arcs are to be circumscribed
    and inscribe = 1 when the arcs are to be inscribed
    relative to the ref point(ctr of window)*/

  switch (inscribe) 
  {                 

  case 0: /*circle_ctr equals ctr closest to the ref point*/
    if (dist1<dist2)  /*draws arcs outside circle*/
    {
      circle_ctr_x = circle_ctr_x1;
      circle_ctr_y = circle_ctr_y1;
    }
    else
    {
      circle_ctr_x = circle_ctr_x2;
      circle_ctr_y = circle_ctr_y2;
    }
    break;

  case 1: /*circle_ctr equals ctr fartherest from the ref point*/
    if (dist1>dist2)  /*draws arcs in circle*/
    {
      circle_ctr_x = circle_ctr_x1;
      circle_ctr_y = circle_ctr_y1;
    }
    else
    {
      circle_ctr_x = circle_ctr_x2;
      circle_ctr_y = circle_ctr_y2;
    }
    break;
  }  /*ends switch*/

    if (ctr[first].y < ctr[second].y)
    {
         point = first;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
	 if (circle_ctr_y < ctr[point].y)
	    angle1 = conv*atan(arg) - 90.5;
         else
            angle1 = 90.5 + conv*atan(arg);
    }
    if (ctr[first].y > ctr[second].y)
    {
         point = second;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
	 if (circle_ctr_y < ctr[point].y)
	    angle1 = conv*atan(arg) - 90.5;
         else
            angle1 = 90.5 + conv*atan(arg);
    }
    if (ctr[first].y == ctr[second].y) 
    {
      if (circle_ctr_y<bisectpt_y)
      {
        if (ctr[first].x<ctr[second].x)
        {
         point = second;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
         angle1 = conv*atan(arg) - 90.5;
	 angle2 = - angle2;
        }
        else
        {
	 point = first;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
         angle1 = conv*atan(arg) - 90.5;
	 angle2 = - angle2;
	}
      }
      if (circle_ctr_y>bisectpt_y)
      {
	if (ctr[first].x<ctr[second].x)
        {
 	 point = second;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
         angle1 = 90.5 + conv*atan(arg);
        }
        else 
        {
	 point = first;
         arg = (double)(ctr[point].x-circle_ctr_x)/
	       (double)(ctr[point].y-circle_ctr_y);
         angle1 = 90.5 + conv*atan(arg);
        }
      }
    }
    if (ctr[first].x == ctr[second].x)
    {
         arg = (double)(ctr[point].x-circle_ctr_x)/radius;
         angle1 = conv*acos(arg) + 0.5;
    }
    if (circle_ctr_x < bisectpt_x)
         angle2 = - angle2;

    top.x = circle_ctr_x - radius;
    top.y = circle_ctr_y - radius;
    XDrawArc(mydisplay,windows[HYPE].window,gc,top.x,top.y,width,
	       hght,angle1*64,angle2*64);

}  /*Ends do_arc procedure*/

do_ellipse1(first,second,gc,chck)
  int first, second, chck;
  GC gc;

{
  int wid, ht, angle1, angle2;
  XPoint top;
  double width, hght, cent_x, cent_y, conv, fudge;

  conv = 180.0/PI;
  width = ctr[second].x - ctr[first].x + 40;
  hght = (ctr[second].x - ctr[first].x) * 0.30;
  fudge = (ctr[second].x - ctr[first].x) * 0.08;
  if (chck == 0)
  {
    cent_x = (ctr[second].x + ctr[first].x) / 2.0;  
    cent_y = ctr[first].y + hght / 2.0 - fudge;
    angle1 = 2*conv*atan((hght/2.0)/(double)(ctr[second].x-cent_x))+0.5;
    angle2 = -(180 + 2 * angle1);
  }
  else
  {
    cent_x = (ctr[second].x + ctr[first].x) / 2.0;  
    cent_y = ctr[first].y - hght/2.0 + fudge;
    angle1 = -2*conv*(atan((hght/2.0)/(double)(ctr[second].x-cent_x)))-0.5;
    angle2 = 180 + 2 * abs(angle1);
  }
  top.x = cent_x - width/2 + 0.5;
  top.y = cent_y - hght/2 + 0.5;
  wid = width + 0.5;
  ht = hght + 0.5;
  XDrawArc(mydisplay,windows[HYPE].window,gc,top.x,top.y,wid,ht,
	   angle1*64,angle2*64);
}

do_ellipse2(first,second,gc,chck)
  int first, second, chck;
  GC gc;

{
  int wid,ht,angle1,angle2;
  XPoint top;
  double width,hght,cent_x,cent_y,conv,fudge;

  conv = 180.0/PI;
  width = (ctr[second].y - ctr[first].y) * 0.30;
  fudge = (ctr[second].y - ctr[first].y) * 0.08;
  hght = ctr[second].y - ctr[first].y + 40;
  if (chck == 0)
  {
    cent_x = ctr[first].x + width/2.0 - fudge;
    cent_y = (ctr[second].y + ctr[first].y)/2.0;  
    angle1 = 90.5+2*conv*atan((width/2.0)/(double)(cent_y-ctr[first].y));
    angle2 = -(2 * angle1);
  }
  else
  {
    cent_x = ctr[first].x - width / 2.0 + fudge;
    cent_y = (ctr[second].y + ctr[first].y) / 2.0;  
    angle1 = 90.5-2*conv*(atan((width/2.0)/(double)(cent_y-ctr[first].y)));
    angle2 = 360 - 2 * abs(angle1);
  }
  top.x = cent_x - width/2 + 0.5;
  top.y = cent_y - hght/2 + 0.5;
  wid = width + 0.5;
  ht = hght + 0.5;
  XDrawArc(mydisplay,windows[HYPE].window,gc,top.x,top.y,wid,ht,
	   angle1*64,angle2*64);
}
