#include <stdio.h>
#include <math.h>
#include <X11/Xlib.h>
#include "defines.h"

struct win_info {
  Window window;
  int width;
  int height;
  int x;
  int y;
  int opt1;
  int opt2;
};

extern Display *mydisplay;
extern struct win_info windows[];
extern GC micro_gc, gc[];
extern FILE *tfptr;
extern int **cum_vol, num_nodes, end_of_file, go_flag, exit_count,
	   sum_busy[], sum_ovhd[], skip, cur_time, stop_time, count_ovhd[], 
	   dest, node, key_index, begin_of_file, count_busy[], count_idle[], 
           time_unit, sliderwidth, max_time, close_count;
float total_pct_busy[MAXP], total_pct_ovhd[MAXP], total_pct_idle[MAXP];
int vol_bin[6], max_prof_count;

extern char filename[], linestr[];
extern FILE *recptr[18];

get_trace()
{
    int i, j;

    /* The variable go_flag changes depending on form of action the user
       chooses.  When no animation is being done, start has not been hit or
       pause has been selected - go_flag is equal to 0.  When it is running
       straight through the tracefile (start or resume has been selected),
       go_flag is equal to 1.  When step is being used, go_flag is equal to
       2. When the whole program is quit, go_flag is equal to -1. */

    /* if in run state and haven't hit stop time */
    if (go_flag == 1 && cur_time < stop_time)
    {
	j=(int)(pow(10.0,((double)windows[SLID].opt1*6)/(double)(sliderwidth)));
	for(i=0; i<j; i++);
	/* while skip = 1 (just read an "uninteresting" traceline) */
	while(skip) {
	    /* as long as we're not at the end of the file */
	    if (fgets(linestr, MAXLINE, tfptr) != NULL && exit_count &&
		close_count) {
	        /* read through a traceline and collect needed data */
	        scan(linestr);
	        /* read through a traceline and collect needed data */
	        end_of_file = 0;
		begin_of_file=0;
	    } else {
	        /* we're at end of file, set go_flag equal to 0 (do nothing) */
	        go_flag = 0;
	        end_of_file = 1;
		skip = 0;
		draw_end();
		begin_of_file = 1;
		rewind(tfptr);
	    }
	}
	if (!end_of_file){
	    /* update appropriate displays according to new data */
	    if(key_index==SEND&&dest==ALL){
	      for(i=0; i<node; i++){
	      dest=i;
	      draw();
	      }
	      for(i=node+1; i<num_nodes; i++){
	      dest=i;
	      draw();
	      }
	    } else {
	      draw();
	    }
	    /* in order to read the next line, set skip = 1 */
	    skip = 1;
	}
	else skip = 0;
    }
}
draw_end()
{

int i, j;

    /* write "end of file" msg in trace record window */
        if (windows[TRAC].opt1) {
	    XDrawImageString(mydisplay, windows[TRAC].window,
	        gc[CLOK], 22, 16, "end of file", 11);
        }

        for(i=ANIM; i<=NTWK; i++){
         if(windows[i+REC_OFF].opt1)
           fflush(recptr[i]);
        }

        for (i=0; i<num_nodes; i++){
          if (max_time){
            total_pct_busy[i] = (100.0 * (float)sum_busy[i]/(float)time_unit)/
	      (float)max_time;
            total_pct_ovhd[i] = (100.0 * (float)sum_ovhd[i]/(float)time_unit)/
	      (float)max_time;
            total_pct_idle[i] = 100.0 - total_pct_busy[i] -
	    total_pct_ovhd[i];
          }
        }
        if (windows[UTLS].opt1) 
          expose(UTLS);

        if (windows[STTS].opt1)
          expose(STTS);

        if (windows[TSMY].opt1)
          expose(TSMY);

        if (windows[STRK].opt1)
          expose(STRK);

	for (i=0; i<num_nodes+1; i++)
	    if (count_ovhd[i] >= max_prof_count)
		max_prof_count = count_ovhd[i];
	for (i=0; i<num_nodes+1; i++)
	    if (count_idle[i] >= max_prof_count)
		max_prof_count = count_idle[i];
	for (i=0; i<num_nodes+1; i++)
	    if (count_busy[i] >= max_prof_count)
		max_prof_count = count_busy[i];
	max_prof_count = 10*ceil((double)(max_prof_count*10)/max_time);
	if(!max_prof_count)max_prof_count = 1;

        if (windows[PROF].opt1)
          expose(PROF);

        if (windows[TSKC].opt1)
          expose(TSKC);

        if (windows[ANIM].opt1) 
	  expose(ANIM);

	if (windows[HYPE].opt1)
	  expose(HYPE);

	/* determine top and bottom totals */
	for (i = 0; i < num_nodes; i++)
	    for (j = 0; j < num_nodes; j++)
	      if (cum_vol[i][j] > vol_bin[5])
	        vol_bin[0] = vol_bin[5] = cum_vol[i][j];
	for (i = 0; i < num_nodes; i++)
	    for (j = 0; j < num_nodes; j++)
	      if (cum_vol[i][j] < vol_bin[0] && cum_vol[i][j] != 0)
	        vol_bin[0] = cum_vol[i][j];
	vol_bin[1] = vol_bin[0] + (vol_bin[5] - vol_bin[0]) / 5;
	vol_bin[2] = vol_bin[0] + 2 * (vol_bin[5] - vol_bin[0]) / 5;
	vol_bin[3] = vol_bin[0] + 3 * (vol_bin[5] - vol_bin[0]) / 5;
	vol_bin[4] = vol_bin[0] + 4 * (vol_bin[5] - vol_bin[0]) / 5;
	if(vol_bin[5]-vol_bin[0]<5){
	  for(i=1; i<5; i++){
	    vol_bin[i]=vol_bin[0]+i;
	  }
	}
	if(windows[LGND].opt1){
	    expose(LGND);
	    expose(CODB);
	}
        if (windows[NTWK].opt1) 
	    expose(NTWK);
        if (windows[MTRX].opt1) 
	    expose(MTRX);
        /* eof alert */
        XBell(mydisplay, -50);
}
