/* miscellaneous */
#define HOST -32768 /*host number*/
#define ALL -1 /* All nodes*/
#define MAXLINE 1000 /*maximum number of characters per traceline*/
#define MAXP 128 /*maximum number of processors*/

/*The following defines are used as subscripts in the window array and some
  are used as subscripts in several other arrays, such as the gc array, and
  the opened array*/
#define ANIM  0  /*animation display*/
#define HYPE  1  /*hypercube display*/
#define MTRX  2  /*matrix display*/
#define KIVT  3  /*kiviat display*/
#define TSKS  4  /*task status display*/
#define TSKG  5  /*task gantt display*/
#define SPTM  6  /*spacetime display*/
#define CRIT  7  /*critical path display*/
#define UTLG  8  /*utilization gantt display*/
#define UTLC  9  /*utilization count display*/
#define NINF 10  /*node info display*/
#define TRAF 11  /*traffic display*/
#define PSTA 12  /*processor status display*/
#define QUEU 13  /*queues display*/
#define TSKC 14  /*task count display*/
#define UTLS 15  /*utilization summary display*/
#define PHPT 16  /*phase portrait display*/
#define NTWK 17  /*network display*/
#define TSMY 18  /*task summary display*/
#define PROF 19  /*profile display*/
#define STRK 20  /*streak display*/
#define UTMT 21  /*utilization meter display*/
#define CMMT 22  /*communication meter display*/
#define SLID 23  /*slider window*/
#define TRAC 24  /*trace records display*/
#define STTS 25  /*statistics display*/
#define CLOK 26  /*clock display*/
#define SOPT 27  /*set options menu*/
#define ROPT 28  /*record options menu*/
#define INFO 29  /*buttonpress info display*/
#define LGND 30  /*color code legend*/
#define FLBR 31  /*file browser*/
#define TMEN 32  /*task menu*/
#define UMEN 33  /*utilization menu*/
#define CMEN 34  /*communication menu*/
#define OMEN 35  /*other menu*/
#define MENU 36  /*main menu*/
#define ANMB 37  /*animation button*/
#define HYPB 38  /*hypercube button*/
#define MTXB 39  /*matrix button*/
#define KIVB 40  /*kiviat button*/
#define TSTB 41  /*task status button*/
#define TSGB 42  /*task gantt button*/
#define STMB 43  /*spacetime button*/
#define CRTB 44  /*critical path button*/
#define UTGB 45  /*utilization gantt button*/
#define UTCB 46  /*utilization count button*/
#define NIFB 47  /*node info button*/
#define TRFB 48  /*traffic button*/
#define PSTB 49  /*processor status button*/
#define QUEB 50  /*queues button*/
#define TSCB 51  /*task count button*/
#define UTSB 52  /*utilization summary button*/
#define PHPB 53  /*phase portrait button*/
#define NTWB 54  /*network button*/
#define TSMB 55  /*task summary button*/
#define PRFB 56  /*profile button*/
#define STKB 57  /*streak button*/
#define UTMB 58  /*utilization meter button*/
#define CMMB 59  /*communication meter button*/
#define SLDB 60  /*slider window button*/
#define TRCB 61  /*trace button*/
#define STTB 62  /*statistics button*/
#define CLKB 63  /*clock button*/
#define OPTB 64  /*options menu button*/
#define ROPB 65  /*options menu button*/
#define INFB 66  /*info button*/
#define LGNB 67  /*color code legend button*/
#define FBRB 68  /*file browser button*/
#define TMNB 69  /*task menu button*/
#define UMNB 70  /*utilization menu button*/
#define CMNB 71  /*communication menu button*/
#define OMNB 72  /*other menu button*/
#define USRB 73  /*user button*/
#define RUNB 74  /*start button*/
#define PAUB 75  /*pause/resume button*/
#define STPB 76  /*step button*/
#define SDPB 77  /*screendump button*/
#define ENVB 78  /*save environment button*/
#define QITB 79  /*quit button*/
#define STAR 80  /*start time input button*/
#define STOP 81  /*stop time input button*/
#define STMU 82  /*time unit  input button*/
#define TFIL 83  /*tracefile input button*/
#define DELT 84  /*smoothing interval input button*/
#define SPRT 85  /*printer input button*/
#define TRCT 86  /*trace type input button*/
#define TRCN 87  /*trace node input button*/
#define SINC 88  /*step increment input button*/
#define QEST 89  /*overwrite .pgrc?*/
#define YESB 90  /*yes button*/
#define QNOB 91  /*no button*/
#define ORDB 92  /*order button*/
#define SCRB 93  /*scroll button*/
#define SNDB 94  /*node info node button*/
#define STYB 95  /*node info stat type button*/
#define MESB 96  /*queues count/length button*/
#define SIZB 97  /*traffic count/length button*/
#define TRNB 98  /*traffic node button*/
#define TSTP 99  /*stop on tracemark/msg button*/
#define PERR 100  /*stop on error button*/
#define HTYB 101  /*hypercube type button*/
#define NTYB 102  /*hypercube type button*/
#define MTRB 103  /*comm meter type button*/
#define CPFB 104  /*profile type button*/
#define CODB 105  /*color code type button*/
#define ANIR 106  /*animation record button*/
#define HYPR 107  /*hypercube record button*/
#define MTRR 108  /*matrix record button*/
#define KIVR 109  /*kiviat record button*/
#define TSSR 110  /*task status record button*/
#define TSGR 111  /*task gantt record button*/
#define SPTR 112  /*spacetime record button*/
#define CRIR 113  /*critical path record button*/
#define UTGR 114  /*utilization gantt record button*/
#define UTCR 115  /*utilization count record button*/
#define NINR 116  /*node info record button*/
#define TRAR 117  /*traffic record button*/
#define PSTR 118  /*processor status record button*/
#define QUER 119  /*message queues record button*/
#define TSCR 120  /*task count record button*/
#define UTSR 121  /*utilization summary record button*/
#define PHPR 122  /*phase portrait record button*/
#define NTWR 123  /*network record button*/
#define RSTR 124  /*record start*/
#define RSTP 125  /*record stop*/
#define RFNP 126  /*record file name*/
#define STAB 127
#define CLOB 128  /*close button*/
#define ATYB 129  /*animation type*/
#define MTYB 130  /*mesh type*/
#define MORB 131  /*mesh order*/
#define NOPB 132  /*network option button*/
#define NMOB 133
#define NMSB 134
#define KVTB 135
#define SRKB 136
#define PATB 137
#define ASVB 138
#define ARDB 139
#define ANFL 140
#define RSTB 141
#define DIMB 142
#define DSTB 143
#define COLB 144
#define SHNB 145
#define SCLB 146  /*scale button*/

#define REC_OFF 106

/*The following defines are the values of the "keywords" that are found at the
beginning of each line in a tracefile*/
#define EVENTMARK        -2
#define EVENTENTRY       -3
#define EVENTEXIT        -4
#define EVENTLABEL       -5
#define EVENTDATA        -6
#define EVENTMESSAGE     -7

#define OPEN            -11
#define CLOSE           -12
#define SEND            -21
#define SENDBEGIN       -27
#define SENDSTATUS      -28
#define SENDENDV        -30
#define SENDENDW        -31
#define RECV            -51
#define RECVBLOCK       -52
#define WAIT            -56
#define RECVBEGIN       -57
#define RECVSTATUS      -58
#define RECVENDV        -60
#define RECVENDW        -61
#define WRITE          -221
#define READ           -251
#define CLOCKSYNC      -401
#define SYNC           -402
#define LOAD           -503
#define IDLE           -601
#define OVERHEAD       -602
#define UOVERHEAD      -603
#define TSTART         -901
#define TEVENTS        -902
#define TFILES         -903
#define TLEVEL         -904
#define TMSG           -911
#define TFLUSH         -912
#define TFULL1         -913
#define TFULL2         -914

#define TEXIT          100
#define RECVWAKE       101
#define USERBLOCKBEGIN 102
#define USERBLOCKEND   103
#define USERMARK       104

/*the following defines are used as subscripts in the gc array along with
  with some of the defines above. They are described here by their colors
  as for a color monitor. The "colors" and/or stipples are different for
  a grayscale or monochrome screen*/
#define SPTH 27 /*green gc for horizontal lines in spacetime*/
#define KIVH 28 /*plum gc for kiviat highwater mark*/
#define MSQH 29 /*plum gc for queues highwater marks*/
#define LGN0 31  /*color code legend input button*/
#define LGN1 32  /*color code legend input button*/
#define LGN2 33  /*color code legend input button*/
#define LGN3 34  /*color code legend input button*/
#define UTLB 35 /*green gc for busy in utilization displays*/
#define COMH 37 /*blue gc for traffic display*/
#define UTLI 38 /*red gc for idle in utilization displays*/
#define MSQC 39 /*blue violet gc for current value in queues*/
#define KIVC 40 /*orchid gc for current value in kiviat*/
#define CSTD 41 /*blue gc for lines in node info display*/
#define GNTL 42 /*black gc for separating lines in util gantt*/
#define MENS 43 /*beige gc for active menu buttons*/
#define ANMI 44 /*red gc for idle in animation display*/
#define ANMC 45 /*green gc for busy in animation display*/
#define ANMS 46 /*blue gc for send in animation display*/
#define ANMR 47 /*yellow gc for recv in animation display*/
#define CSTH 48 /*red (or dashed) gc for "extension" of line in node info*/
#define SPT0 49 /*blue gc for msg size code in spacetime, also in matrix*/
#define SPT1 50 /*blueviolet gc for msg size code in spacetime, also in matrix*/
#define SPT2 51 /*purple gc for msg size code in spacetime, also in matrix*/
#define SPT3 52 /*redviolet gc for msg size code in spacetime, also in matrix*/
#define SPT4 53 /*red gc for msg size code in spacetime, also in matrix*/
#define UTLO 54 /*yellow gc for overhead in utilization displays*/
#define HDSH 55 /*red gc for non-cube connection line in hypercube display*/
#define HSLD 56 /*blue gc for cube connection line in hypercube display*/
#define TMBR 57 /*cyan gc for timebar on clock display*/
#define BKBG 58 /*light brown gc for in progress state in task status display*/
#define BKED 59 /*dark brown gc for completed state in task status display*/
#define PHDL 60 /*black gc for phase portrait line when there are no tasks*/
#define MNBG 61 /*cyan gc for menu background*/
#define CRTP 62 /*red gc for critical path in crit path display*/
#define NCRP 63 /*blue gc for noncritical path in crit path display*/
#define ERAS 64 /*white gc foreground used for erasing*/
#define ERA2 65 /*white gc foreground used for erasing*/
#define NWK1 66
#define NWK2 67
#define NWK3 68
#define NWK4 69
#define NWK5 70
#define NWK6 71
#define NWK7 72
#define NWK8 73
#define NWK9 74
#define BSYS 75
#define IDLS 76
#define SPC0 77 /*blue gc for task 0 in task displays*/
#define COL0 141
#define TSK0 205

#define CUBE 0
#define LATERAL_CUBES 1
#define NESTED_CUBES 2
#define SQUARES 3
#define PINWHEEL 4
#define POLYTOPE 5
#define TESSERACT 6
#define GEM 7
#define QUATREFOIL 8
#define ROSETTE 9
#define CIRCLES 10
#define GRID 11
#define MESH 12
#define TORUS 13
#define ORBITS 14
#define RING_OF_RINGS 15
#define WEB 16
#define RING 17
#define CROSSHATCH 18
#define LINEAR 19
#define TREE 20
#define SHUFFLE 21

#define BUTTERFLY 0
#define GRAY_CODE 1
#define HYPERCUBE 2
#define OMEGA 3
#define BASELINE 4
#define BINARY_TREE 5
#define QUADTREE 6
#define NTWK_MESH 7
#define CROSSBAR 8

/*the following defines are used as subscripts in the colors array*/
#define RED 0
#define YELLOW 1
#define GREEN 2
#define BLUE 3
#define PURPLE 4
#define REDVIOLET 5
#define BLUEVIOLET 6
#define CYAN 7
#define PLUM 8
#define ORCHID 9
#define BEIGE 10
#define GREENBLUE 11
#define LIGHTBLUE 12
#define DARKBLUE 13
#define MEDIUMLIGHTBLUE 14
#define PURERED 15
#define BROWN 16
#define MEDIUMDARKBLUE 17
#define ORANGE 18
#define ORANGERED 19
#define FUSCHIA 20
#define YELLOWORANGE 21
#define MEDIUMGREEN 22
#define PUREBLUE 23
#define DEEPPURPLE 24
#define DARKGREEN 25
#define GRAY0 26
#define GRAY1 27
#define GRAY2 28
#define GRAY3 29
#define GRAY4 30
#define GRAY5 31
#define GRAY6 32
#define GRAY7 33

/*obviously, this is an approximation to pi*/
#define PI 3.141592653589793

typedef struct {
  int sent;
  int rcvd;
} MSG_STRUCT;

typedef struct {
  MSG_STRUCT max;
  MSG_STRUCT min;
  MSG_STRUCT total;
} MMT_STRUCT;

typedef struct {
  int busy;
  int busy_ovhd;
  int ovhd_idle;
  int idle;
} BOD_STRUCT;
