#include "defines.h"
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>

extern char filename[];
int crit_node_count, crit_node[1000], crit_time_send[1000],crit_time[1000],
    crit_count, first_trace_exit;
extern int time_unit, max_time, min_time;
static output(), utcopyn();

backwards()
{

	register char	*p, *q;
	register int	i;

	struct	stat	st;
	off_t		off, lseek();
	char		buffer[ 1 + BUFSIZ + BUFSIZ + 1 ];
	char		*buf;
	char		*readerr = "Read error at offset %lu of %s\n";
	int		fd;



	buf = buffer;
	*buf++ = '\n';


        for(i=0;i<1000;i++)
	crit_time_send[i] = 0;
	first_trace_exit = 1;
		if (stat(p=filename, &st) == -1) {
			fprintf(stderr , "Bad status for %s\n", p);
			exit(1);
		}
		if ((off = st.st_size) == 0) exit(1);
		if ((fd = open(p, 0)) == -1) {
			fprintf(stderr, "Can't open %s\n", p);
			exit(1);
		}

		if ((i = off % BUFSIZ ) == 0) i = BUFSIZ;
		off -= i;

		lseek(fd, off, 0);
		if (read(fd, buf, i) != i) {
			fprintf(stderr, readerr, off, p);
			close(fd);
			exit(1);
		}
		p = q = buf + i;
		if (*--p == '\n') q = p;


		for (;;) {
			while (*--p != '\n');
			if (p < buf) {
				if (off == 0) {
					output(p, q);
					close(fd);
					break;
				}
				lseek(fd, off -= BUFSIZ, 0);
				if ((i = q - buf) > BUFSIZ) {
					fprintf(stderr, "Line too long\n");
					i = BUFSIZ;
				}
				utcopyn(p = buf + BUFSIZ, buf, i);
				q = p + i;
				if (read(fd, buf, BUFSIZ) != BUFSIZ) {
					fprintf(stderr, readerr, off, filename);
					close(fd);
					break;
				}
			}
			if(*p=='\n'){
			  output(p, q);
			  q = p;
			}
		}
   crit_time_send[0] = (max_time+min_time)*time_unit+1;
   crit_time[crit_node_count] = -1;
   crit_count = crit_node_count;
   for(i=crit_node_count+1; i<1000;i++)
       crit_node[i] = -1;
}

static output(p, q)
register char   *p,*q;
{
        char line[MAXLINE];
	int i;

	for (p++, i=0; p < q; line[i++] = *p++);
	line[i]=NULL;
	crit_path_search(line);
}
static utcopyn(tp, fp, n)
register char *tp, *fp;
register int n;
{
	while (--n >= 0) *tp++ = *fp++;
	return;
}

crit_path_search(l)
char l[MAXLINE];
{
    int looking_for_rw, looking_for_s, k, node, link, e;
    float ctime;

    sscanf(l, "%d %d", &e, &k);
    
    switch(k){
       case TSTART:
        if(e==EVENTEXIT&&first_trace_exit){
            sscanf(l, "%*d %*d %*f %d", &node);
            first_trace_exit=0;
            crit_node_count=0;
            crit_node[crit_node_count]=node;
	    looking_for_rw=1;
        }
        break; 
       case SEND:
       case SENDBEGIN:
        if(e==EVENTENTRY&&looking_for_s){
          sscanf(l, "%*d %*d %f %d %*d %*d %*s %*d %*d %d", &ctime, &node,
            &link);
          if(node==crit_node[crit_node_count]&&(link==ALL||link==crit_node[crit_node_count-1])&&crit_time_send[crit_node_count]==0){
              crit_time_send[crit_node_count]=(int)(1000000.0*ctime);
	      looking_for_s=0;
	      looking_for_rw=1;
	  } 
        }
        break;
       case RECVBLOCK:
        if(e==EVENTEXIT&&looking_for_rw){
          sscanf(l, "%*d %*d %f %d %*d %*d %*s %*d %*d %d", &ctime, &node,
            &link);
          if(node==crit_node[crit_node_count]){
              crit_node[crit_node_count+1]=link;
              crit_time[crit_node_count]=(int)(1000000.0*ctime);
              crit_node_count++;
	      looking_for_rw=0;
	      looking_for_s=1;
          }
	}
        break;
        default:
	break;
    }
}
