c Supernodal left looking, primer supernode loop (cache),
c Supernode update with indirect addressing
c Relative pivot tolerance
c =============================================================================
c
      subroutine nfactor(ecolpnt,
     x vcstat,rowidx,pivots,count,
     x nonzeros,diag,err,updat,mut,index,dropn,slktyp,
     x snhead,fpnt,invperm,nodtyp,dv,odiag)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 err,mut(mn),dropn,ecolpnt(mn),vcstat(mn),
     x rowidx(cfree),pivots(mn),count(mn),index(mn),slktyp(m)
      integer*4 snhead(mn),fpnt(mn),invperm(mn),nodtyp(mn)
      real*8 nonzeros(cfree),diag(mn),updat(mn),dv(m),odiag(mn)
c
      common/factor/ tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
      real*8         tpiv1,tpiv2,tabs,trabs,lam,tfind,order,supdens
      common/numer/ tplus,tzer
      real*8        tplus,tzer
c -----------------------------------------------------------------------------
      integer*4 i,j,k,o,p,pnt1,pnt2,ppnt1,ppnt2,col,kprew,
     x prewnode,ppnode,rb,w1
      real*8 s,diap,diam
      character*99 buff
c------------------------------------------------------------------------------
      err=0
      w1=0
c
c  initialization
c
      do 10 i=1,mn
        mut(i)=0
        index(i)=0
        updat(i)=0.0
        fpnt(i)=ecolpnt(i)
  10  continue
      ppnode=0
      prewnode=0
      i=0
c
c  loop for pivot columns
c
 100  i=i+1
      if(i.gt.pivotn)goto 60
      col=pivots(i)
c
c  step vcstat if relaxed
c
      if(vcstat(col).le.-2)then
        call colremv(i,col,mut,index,fpnt,count,pivots,invperm,
     x  snhead,nodtyp,rowidx,nonzeros,ppnode,prewnode)
        diag(col)=0.0
        i=i-1
        if((ppnode.gt.0).and.(prewnode.eq.i))goto 110        
        goto 100
      endif
c
      ppnt1=ecolpnt(col)
      ppnt2=count(col)
      if(ppnt1.le.nz)then
        diag(col)=1.0d00/diag(col)
        goto 180
      endif
      kprew=index(col)
c
c  compute
c
      diap=diag(col)
      diam=0.0d+0      
 130  if(kprew)129,150,131
c
c Standard transformation
c
 131  k=mut(kprew)
      pnt1=fpnt(kprew)
      pnt2=count(kprew)
      if(pnt1.lt.pnt2)then
        o=rowidx(pnt1+1)
        mut(kprew)=index(o)
        index(o)=kprew
      endif
      pnt1=pnt1+1
      fpnt(kprew)=pnt1
      s=-nonzeros(pnt1-1)*diag(kprew)
      if(kprew.le.n)then
        diap=diap+s*nonzeros(pnt1-1)
      else
        diam=diam+s*nonzeros(pnt1-1)
      endif
      do 170 o=pnt1,pnt2
        updat(rowidx(o))=updat(rowidx(o))+s*nonzeros(o)
 170  continue
      kprew=k
      goto 130
c
c supernodal transformation
c
 129  kprew=-kprew
      k=mut(kprew)
      p=invperm(kprew)
      pnt1=fpnt(kprew)+1      
      if(pnt1.le.count(kprew))then
        o=rowidx(pnt1)
        mut(kprew)=index(o)
        index(o)=-kprew
      endif
      if(kprew.le.n)then
        call cspnd(p,snhead(p),diag,nonzeros,
     x  fpnt,count,pivots,updat,diap,rowidx(pnt1))
      else
        call cspnd(p,snhead(p),diag,nonzeros,
     x  fpnt,count,pivots,updat,diam,rowidx(pnt1))
      endif
      kprew=k
      goto 130
c
c  pack a column, and free the working array
c
 150  do k=ppnt1,ppnt2
        nonzeros(k)=updat(rowidx(k))
        updat(rowidx(k))=0
      enddo
c
c set up diag
c
      if((ppnode.le.0).or.(prewnode.ne.snhead(i)))then
        diap=diap+diam
        diam=max(trabs,abs(diam*trabs))
        if(abs(diap).lt.diam)then
          call rngchk(rowidx,nonzeros,ecolpnt(col),count(col),
     x    vcstat,rb,diag,slktyp,dropn,col,dv,diap,w1,odiag(col))
          if(rb.ne.0)err=1
          diag(col)=diap
          if(vcstat(col).le.-2)goto 100
        else
          diag(col)=1.0d00/diap
        endif
      else
        diag(col)=diam
        updat(col)=diap
      endif
c
c Transformation in (primer) supernode
c
 110  if(prewnode.eq.i)then
        if(ppnode.gt.0)then
          do j=ppnode+1,i
            o=j-1
            p=pivots(j)
            call cspnode(ppnode,o,diag,nonzeros,fpnt,count,pivots,
     x      nonzeros(ecolpnt(p)),diag(p))
            diam=max(trabs,abs(diag(p)*trabs))
            diag(p)=diag(p)+updat(p)
            if(abs(diag(p)).lt.diam)then
              call rngchk(rowidx,nonzeros,ecolpnt(p),count(p),
     x        vcstat,rb,diag,slktyp,dropn,p,dv,diag(p),w1,odiag(p))
              if(rb.ne.0)err=1
            else
              diag(p)=1.0d00/diag(p)
            endif
          enddo
        endif
        ppnode=0
      endif
c
c Update the linked list
c
 180  if(snhead(i).eq.0)then
        ppnode=0
        if(ppnt1.le.ppnt2)then
          j=rowidx(ppnt1)
          mut(col)=index(j)
          index(j)=col
        endif
        prewnode=0
      else
        if(prewnode.ne.snhead(i))then
          prewnode=snhead(i)
          if(nodtyp(i).gt.0)then
            ppnode=i
          else
            ppnode=-i
          endif
          if(ecolpnt(pivots(prewnode)).le.count(pivots(prewnode)))then
            j=rowidx(ecolpnt(pivots(prewnode)))
            mut(col)=index(j)
            index(j)=-col
          endif
        endif
      endif
c
c  end of the main loop
c
      goto 100
c
c  end of mfactor
c
  60  if(w1.gt.0)then
        write(buff,'(1x,a,i6)')'Total warnings of row dependencies:',w1
        call mprnt(buff)
      endif
      return
      end
c
c =============================================================================
c
      subroutine colremv(i,col,mut,index,fpnt,count,pivots,invperm,
     x snhead,nodtyp,rowidx,nonzeros,ppnode,prewnode)
c
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
c
      integer*4 i,col,mut(mn),index(mn),fpnt(mn),count(mn),pivots(mn),
     x invperm(mn),snhead(mn),nodtyp(mn),rowidx(cfree),ppnode,
     x prewnode
      real*8 nonzeros(cfree)
c
      integer*4 j,jj,k,l,o,p,pnt1
c 
        jj=index(col)
 195    if(jj.eq.0)goto 103
        if(jj.lt.0)then
          j=-jj
        else
          j=jj
        endif
        k=mut(j)
        pnt1=fpnt(j)
        call move(pnt1,count(j),rowidx,nonzeros)
        if(pnt1.le.count(j))then
          o=rowidx(pnt1)
          mut(j)=index(o)
          index(o)=jj
        endif
        if(jj.lt.0)then
          p=invperm(j)
          l=snhead(p)
          do o=p+1,l
          call move(fpnt(pivots(o)),count(pivots(o)),rowidx,nonzeros)
          enddo
        endif
        jj=k
        goto 195
c
c Step in the primer supernode
c
 103  if((ppnode.gt.0).and.(prewnode.eq.snhead(i)))then
        l=i-1
        do o=ppnode,l
          pnt1=fpnt(pivots(o))
 104      if(pnt1.le.count(pivots(o)))then
            if(rowidx(pnt1).eq.col)then
              call move(pnt1,count(pivots(o)),rowidx,nonzeros)
              pnt1=count(pivots(o)) 
            endif
            pnt1=pnt1+1
            goto 104
          endif
        enddo
      endif
c
c Make changes
c
      pivotn=pivotn-1
      do j=i,pivotn
        pivots(j)=pivots(j+1)
        snhead(j)=snhead(j+1)
        nodtyp(j)=nodtyp(j+1)
      enddo
      do j=1,pivotn
        if(snhead(j).ge.i)snhead(j)=snhead(j)-1
        invperm(pivots(j))=j
      enddo
      if(prewnode.ge.i)prewnode=prewnode-1
      return
      end
c
c =============================================================================
c
      subroutine move(pnt1,pnt2,rowidx,nonzeros)
      common/dims/ n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4    n,n1,m,mn,nz,cfree,pivotn,denwin,rfree
      integer*4 pnt1,pnt2,rowidx(cfree),i,j
      real*8    nonzeros(cfree),s
      if(pnt1.le.pnt2)then
        j=rowidx(pnt1)
        s=nonzeros(pnt1)       
        pnt2=pnt2-1
        do i=pnt1,pnt2
          nonzeros(i)=nonzeros(i+1)
          rowidx(i)=rowidx(i+1)
        enddo
        rowidx(pnt2+1)=j
        nonzeros(pnt2+1)=s
      endif
      return
      end
c
c =============================================================================      
              
