c ============================================================================
c
      subroutine mpsout(m,n,nz,fout,sfile,code,opt,
     x rownam,colnam,range,lbound,ubound,rhs,
     x rowtyp,xs,colsta,rowsta,rowval,colpnt,rowidx,nonzeros,
     x colpre,rowpre,iter,corect,outlev,minmax,big,objnam,
     x tottim,factim)
c
      integer*4 m,n,nz,rowtyp(m),colsta(n),rowsta(m),colpnt(n+1),
     x rowidx(nz),rowpre(m),colpre(n),factim,tottim,
     x fout,code,iter,corect,outlev,sfile,rownam(m*2),colnam(n*2)
      real*8 rhs(m),range(m),lbound(n),ubound(n),opt,xs(n),big,
     x rowval(m),nonzeros(nz)
c
      character*8  objnam,c1
      integer*4    minmax
      character*6  str4
      integer*4    i,j,pnt1,pnt2
      real*8       sol,lbig
c
c --------------------------------------------------------------------------
c
   1  format(1x,'OBJECTIVE FUNCTION : ',A8,'  VALUE  : ',d19.12,
     x ' (maximize)')
   2  format(1x,'OBJECTIVE FUNCTION : ',A8,'  VALUE  : ',d19.12,
     x ' (minimize)')
   3  format(1x,'Iterations    : ',I8,'  Time    : ',f12.2,' Sec')
   4  format(1x,'Corrections   : ',I8,'  Average : ',f12.2)
   7  format(1x,'TOTAL SOLUTION TIME    =',F12.2,' Sec')
   8  format(1x)
   9  format(1x,'-------B-P-M-P-D---INTERIOR-POINT-LP-OPTIMIZER---',
     x 'VERSION-2.12----------')
  10  format(1x,'---C-O-L-U-M-N-S----R-E-P-O-R-T---')
  11  format(1x,'  NAME          VALUE       STATUS')
  12  format(1x,'----------------------------------')
  14  format(1x,'------R-O-W-S----R-E-P-O-R-T------')


  18  format(1x,'Execution stopped.')
  19  format(1x,'OPTIMAL SOLUTION FOUND')
  20  format(1x,'Problem is dual infeasibile (or badly scaled).')
  21  format(1x,'Problem is primal infeasibile (or badly scaled).')
  22  format(1x,'Termination code :',i3)
  23  format(1x,'General memory limit')
c
c Read column and rownames
c
      rewind(sfile)
      read(sfile)(rownam(i),i=1,m)
      read(sfile)(rownam(i+m),i=1,m)
      read(sfile)(colnam(i),i=1,n)
      read(sfile)(colnam(i+n),i=1,n)
      close(sfile)
      lbig=0.9d+0*big
c
c Write statistics
c
      write(fout,9)
      write(fout,8)
      write(fout,22)code
      if(code.eq.-2)then
        write(fout,23)
        goto 999
      endif
      if(code.le.1)then
         write(fout,18)
      else if(code.eq.2)then
         write(fout,19)
      else if(code.eq.3)then
         write(fout,20)
      else if(code.eq.4)then
         write(fout,21)
      endif
c
      if(minmax.eq.-1)then
        write(fout,1)objnam,-opt
      else
        write(fout,2)objnam,opt
      endif
      write(fout,8)
      write(fout,3)iter,(0.01d+0*dble(factim))
      if(iter.eq.0)iter=1
      write(fout,4)corect,(dble(corect)/dble(iter))
      write(fout,7)(0.01d+0*dble(tottim))
      if(outlev.eq.0)goto 99
c
c columns report
c
      write(fout,8)
      write(fout,10)
      write(fout,11)
      write(fout,12)
      do 60 i=1,n
        str4='      '
        if(colsta(i).eq.-2)str4=' FIXED'
        if(colsta(i).eq.-3)then
          if(colpre(i).eq.0)then
             str4='    FX'
          else
             str4='ROWSNG'
          endif
        endif
        if((ubound(i).gt.lbig).and.(lbound(i).lt.-lbig))str4='  FREE'
        if(colsta(i).eq.  1)str4=' BASIC'
        if(colsta(i).eq. -4)str4='COLSNG'
        if(colsta(i).eq. -5)str4='ROWACT'
        if(colsta(i).eq. -6)str4='CHEPDU'
        if(colsta(i).eq. -7)str4='DUCHEK'
        if(colsta(i).eq. -8)str4='BNDCHK'
        if(colsta(i).lt.-12)str4='COLDBL'
        if(colsta(i).eq.-10)str4='AGGREG'
        call btoc(colnam(i),colnam(i+n),c1)
        write(fout,'(1x,a8,1x,d18.11,1x,a6)')c1,xs(i),str4
  60  continue
c
c Calculating row values
c
      do i=1,m
        rowval(i)=0.0d+0
      enddo
      do i=1,n
        pnt1=colpnt(i)
        pnt2=colpnt(i+1)-1
        sol=xs(i)
        do j=pnt1,pnt2
          rowval(rowidx(j))=rowval(rowidx(j))+nonzeros(j)*sol
        enddo
      enddo
c
c rows report
c
      write(fout,8)
      write(fout,14)
      write(fout,11)
      write(fout,12)
      do 90 i=1,m
        str4='      '
        if(rowsta(i).eq.-2)str4='  FREE'
        if(rowsta(i).eq.-3)then
          if(rowpre(i).eq.0)then
             str4='     N'
          else
             str4='ROWSNG'
          endif
        endif
        if(rowsta(i).eq.  1)str4=' BASIC'
        if(rowsta(i).eq. -4)str4='COLSNG'
        if(rowsta(i).eq. -5)str4='ROWACT'
        if(rowsta(i).eq. -6)str4='CHEPDU'
        if(rowsta(i).eq. -7)str4='DUCHEK'
        if(rowsta(i).eq. -8)str4='BNDCHK'
        if(rowsta(i).lt.-12)str4='COLDBL'
        if(rowsta(i).eq.-10)str4='AGGREG'
        call btoc(rownam(i),rownam(i+m),c1)
        write(fout,'(1x,a8,1x,d18.11,1x,a6)')c1,rowval(i),str4
  90  continue
      goto 99
c
  99  write(fout,12)
 999  return
      end
c
c ===========================================================================
